PROGRAM VToolTest;
{
 ****************************************************************************
 ****************************************************************************
}

{$M 16000,0,50000}

USES Crt,Voctool;

VAR
   Sound : Pointer; { Pointer on chantillon in memory }
   Check : BOOLEAN; { Flag for boolean test            }
   Ch    : CHAR;    { Input Buffer                     }

PROCEDURE Erreur;
{
}
BEGIN
   Write(' error #',VOCErrStat:3,' =');
   PrintVOCErrMessage;
   WriteLn;
   HALT(VOCErrStat);
   END;

BEGIN
  ClrScr;

{ the driver aren't installed }
  IF Not(VOCDriverInstalled) THEN Erreur;

{ Load DEMO.VOC file in memory }
  Check := VOCGetBuffer(Sound,'DEMO.VOC');

{ Incorrectly loading }
  IF Not(Check) THEN Erreur;

{ Master Loop of programm }
  Write('CT-Voice-Driver Version : ');
  WriteLn(Hi(VOCDriverVersion),'.',Lo(VOCDriverVersion));
  WriteLn('Would-you like hear (o)ne or (r)epeat sound ?');
  Write('INPUT : '); Ch := ReadKey;WriteLn;WriteLn;
  CASE UpCase(Ch) OF
   'O' : BEGIN
            Write('Press anykey for stop ...');
            VOCOutput(Sound);
            REPEAT UNTIL KeyPressed OR (VOCStatusWord = 0);
            IF KeyPressed THEN VOCStop;
            END;
   'R' : BEGIN
            Ch := #0;
            Write('Press <ESC> for stop...');
            REPEAT
               VOCOutputLoop(Sound);
               REPEAT UNTIL KeyPressed OR (VOCStatusWord = 0);
               IF KeyPressed THEN Ch := ReadKey;
               UNTIL Ch = #27;
            VOCStop;
            END;
   END;

{ Free memory of VOC File }
  Check := VOCFreeBuffer(Sound);
  IF Not(Check) THEN Erreur;
END.