{
 

 Visionix ANSI Functions unit (VANSIu)
   Version 0.2
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 ** revision history in reverse chronological order **

 Initials  Date      Comment
     

 jrt       12/23/93  Added more documentation.

 jrt       11/01/93  Moved drivers out to vansiiou.

 mep       05/08/93  Drivers (local and buffer) might work now - doubt it :)

 mep       04/29/93  Created.

 
}

(*-

[SECTION: Section 2: The Text I/O Libraries]
[CHAPTER: Chapter 1: The ANSI Functions library]

[TEXT]

<Overview>


This unit mainly provides functions which generate ANSI command strings.
Each function returns a string which is the ANSI command equivalent
of the function.

For example, The ANSIClrScr function returns the ANSI Clear screen
command as a string, '<ESC>[2J'.

<IBM ANSI Graphics Specification:>


  ESC[   ANSI Start Sequence, follwed by the following commands:

  0;30m  Black FG                    40m    Black BC
  0;34m  Blue FG                     44m    Blue BC
  0;32m  Green FG                    42m    Green BC
  0;36m  Cyan FG                     46m    Cyan BC
  0;31m  Red FG                      41m    Red BC
  0;35m  Magenta FG                  45m    Magenta BC
  0;33m  Brown FG                    43m    Brown BC
  0;37m  LightGray FG                47m    LightGray BC

  1;30m  DarkGray FG
  1;34m  LightBlue FG                0m     Attr OFF
  1;32m  LightGreen FG               1m     Bold ON
  1;36m  LightCyan FG                2m     Faint/Dim (not Bold) ON
  1;31m  LightRed FG                 3m     Italic ON
  1;35m  LightMagenta FG             4m     Underline ON
  1;33m  Yellow FG                   5m     Blink ON
  1;37m  White FG                    6m     Fast Blink ON
                                     7m     Rev. Video ON
  H      Home (upper left)           8m     Concealed/Invisible ON
  f      Home (upper left)           9m     Subscript ON
                                     10m    Superscript ON
  #H     Home (then down # rows)
  #f     Home (then down # rows)     2J     ClrScr
                                     1J     ClrScr (before cursor position)
  r;cH   GotoXY (X=c, Y=r)           J      ClrScr (after cursor position)
  r;cf   GotoXY (X=c, Y=r)
                                     K      ClrEol
  A      Up one line                 1K     ClrEol (before cursor position)
  #A     Up # lines                  2K     ClrEol (whole line)

  B      Down one line               L      InsLine
  #B     Down # lines                #L     InsLine # lines

  C      Right one line              M      DelLine
  #C     Right # lines               #M     DelLine # lines

  D      Left one line
  #D     Left # lines

  6n     Cursor Positon Request -
           console returns Cursor Position Report defined as: r;cR

  s      Save pos
  u      Restore pos

  =7h,   Wrap at EOL
  ?7h

  =7l,   No wrap at EOL
  ?7l

  =h,    Set screen to mode #
  =#h,
  ?#h,
  #h

  =l     Reset screen to mode #
  =#l,
  ?#l,
  #l

  #;#p   Redefine keyboard (ASCII-value key to ASCII value)
  #p     Redefine keyboard (clears key)
  #;"s"p Redefine keyboard (change first # to following string)

  22m    Bold OFF
  24m    Underline OFF
  25m    Blink OFF
  27m    Rev. Video OFF

  #@     Inserts # blank characters at cursor position

  #P     Deletes # characters including cursor character

  M{string}^C    ANSI Music (same as BASICA's PLAY command)


<Interface>

-*)


Unit VANSIu;

Interface

Uses

  DOS,
  VTypesu,
  VStringu,
  VGenu;

{}

{}

Function  ANSITextColor(          FG             : BYTE      ) : STRING;

Function  ANSITextBackground(     BG             : BYTE      ) : STRING;

Function  ANSITextAttr(           Attr           : BYTE      ) : STRING;

Function  ANSIHome                                             : STRING;

Function  ANSIHomeRow(            Rows           : BYTE      ) : STRING;

Function  ANSIGotoXY(             X              : BYTE;
                                  Y              : BYTE      ) : STRING;

Function  ANSIUp                                               : STRING;

Function  ANSIUpCount(            Rows           : BYTE      ) : STRING;

Function  ANSIDown                                             : STRING;

Function  ANSIDownCount(          Rows           : BYTE      ) : STRING;

Function  ANSIRight                                            : STRING;

Function  ANSIRightCount(         Cols           : BYTE      ) : STRING;

Function  ANSILeft                                             : STRING;

Function  ANSILeftCount(          Cols           : BYTE      ) : STRING;

Function  ANSIClrScr                                           : STRING;

Function  ANSIClrScrBefore                                     : STRING;

Function  ANSIClrScrAfter                                      : STRING;

Function  ANSIClrEol                                           : STRING;

Function  ANSIClrSol                                           : STRING;

Function  ANSIClrLine                                          : STRING;

Function  ANSIInsLine                                          : STRING;

Function  ANSIInsLineCount(       Rows           : BYTE      ) : STRING;

Function  ANSIDelLine                                          : STRING;

Function  ANSIDelLineCount(       Rows           : BYTE      ) : STRING;

Function  ANSISavePos                                          : STRING;

Function  ANSIRestorePos                                       : STRING;

Function  ANSIWrapEol                                          : STRING;

Function  ANSINoWrapEol                                        : STRING;

Function  ANSIRequestXY                                        : STRING;

Function  ANSIReportXY                                         : STRING;

Function  ANSIMusic(              Play           : STRING    ) : STRING;

{ NOTE: These next two functions are probably going to be yanked.}


Function  ANSIMisc(               Params         : STRING    ) : STRING;

(*
Procedure ANSIWrite(              Ch             : CHAR      );
*)

{}

Implementation

Const

  Black          = 0;
  Blue           = 1;
  Green          = 2;
  Cyan           = 3;
  Red            = 4;
  Magenta        = 5;
  Brown          = 6;
  LightGray      = 7;
  DarkGray       = 8;
  LightBlue      = 9;
  LightGreen     = 10;
  LightCyan      = 11;
  LightRed       = 12;
  LightMagenta   = 13;
  Yellow         = 14;
  White          = 15;
  Blink          = 128;

  BackBlack      = 0 SHL 4;
  BackBlue       = 1 SHL 4;
  BackGreen      = 2 SHL 4;
  BackCyan       = 3 SHL 4;
  BackRed        = 4 SHL 4;
  BackMagenta    = 5 SHL 4;
  BackBrown      = 6 SHL 4;
  BackLightGray  = 7 SHL 4;


{}

Type

  TANSIEmu = RECORD

    Cmd        : STRING;
    StringMode : BOOLEAN;
    AttrBold   : BYTE;
    SaveX      : BYTE;
    SaveY      : BYTE;

    X          : BYTE;
    Y          : BYTE;
    N          : BYTE;
    TmpS       : STRING;

  END;

  PAnsiEmu = ^TAnsiEmu;

Var

  ANSIEmu : TANSIEmu;

{}

Function  ANSITextColor(          FG             : BYTE      ) : STRING;

Var

  S : STRING[40];

BEGIN

  S := ESC + '[';

  Case FG of

    Black        : S := S + '0;30';
    Blue         : S := S + '0;34';
    Green        : S := S + '0;32';
    Cyan         : S := S + '0;36';
    Red          : S := S + '0;31';
    Magenta      : S := S + '0;35';
    Brown        : S := S + '0;33';
    LightGray    : S := S + '0;37';
    DarkGray     : S := S + '1;30';
    LightBlue    : S := S + '1;34';
    LightGreen   : S := S + '1;32';
    LightCyan    : S := S + '1;36';
    LightRed     : S := S + '1;31';
    LightMagenta : S := S + '1;35';
    Yellow       : S := S + '1;33';
    White        : S := S + '1;37';

  End;

  ANSITextColor := S + 'm';

END;

{}

Function  ANSITextBackground(     BG             : BYTE      ) : STRING;

Var

  S : STRING[40];

BEGIN

  S := ESC + '[';

  Case BG of

    Black        : S := S + '0;40';
    Blue         : S := S + '0;44';
    Green        : S := S + '0;42';
    Cyan         : S := S + '0;46';
    Red          : S := S + '0;41';
    Magenta      : S := S + '0;45';
    Brown        : S := S + '0;43';
    LightGray    : S := S + '0;47';
(*
    DarkGray     : S := S + '1;40';
    LightBlue    : S := S + '1;44';
    LightGreen   : S := S + '1;42';
    LightCyan    : S := S + '1;46';
    LightRed     : S := S + '1;41';
    LightMagenta : S := S + '1;45';
    Yellow       : S := S + '1;43';
    White        : S := S + '1;47';
*)
  End;

  ANSITextBackground := S + 'm';

END;

{}

Function  ANSITextAttr(           Attr           : BYTE      ) : STRING;

Var

  FG    : BYTE;
  BG    : BYTE;
  Blink : BOOLEAN;
  S     : STRING;

BEGIN

  FG    := (Attr AND $0F);
  BG    := (Attr AND $70) SHR 4;
  Blink := ( (Attr AND $80) SHR 7 ) <> 0;
  S     := ESC + '[';

  Case FG of

    Black        : S := S + '0;30';
    Blue         : S := S + '0;34';
    Green        : S := S + '0;32';
    Cyan         : S := S + '0;36';
    Red          : S := S + '0;31';
    Magenta      : S := S + '0;35';
    Brown        : S := S + '0;33';
    LightGray    : S := S + '0;37';
    DarkGray     : S := S + '1;30';
    LightBlue    : S := S + '1;34';
    LightGreen   : S := S + '1;32';
    LightCyan    : S := S + '1;36';
    LightRed     : S := S + '1;31';
    LightMagenta : S := S + '1;35';
    Yellow       : S := S + '1;33';
    White        : S := S + '1;37';

  End;

  S := S + ';';

  Case BG of

    Black        : S := S + '40';
    Blue         : S := S + '44';
    Green        : S := S + '42';
    Cyan         : S := S + '46';
    Red          : S := S + '41';
    Magenta      : S := S + '45';
    Brown        : S := S + '43';
    LightGray    : S := S + '47';
(*
    DarkGray     : S := S + '1;40';
    LightBlue    : S := S + '1;44';
    LightGreen   : S := S + '1;42';
    LightCyan    : S := S + '1;46';
    LightRed     : S := S + '1;41';
    LightMagenta : S := S + '1;45';
    Yellow       : S := S + '1;43';
    White        : S := S + '1;47';
*)
  End;

  If Blink Then
    S := S + ';5';

  ANSITextAttr := S + 'm';

END;

{}

Function  ANSIHome                                             : STRING;

BEGIN

  ANSIHome := ESC + '[H';

END;

{}

Function  ANSIHomeRow(            Rows           : BYTE      ) : STRING;

BEGIN

  ANSIHomeRow := ESC + '[' + IntToStr(Rows) + 'H';

END;

{}

Function  ANSIGotoXY(             X              : BYTE;
                                  Y              : BYTE      ) : STRING;

BEGIN

  ANSIGotoXY := ESC + '[' + IntToStr(Y) + ';' + IntToStr(X) + 'H';

END;

{}

Function  ANSIUp                                               : STRING;

BEGIN

  ANSIUp := ESC + '[A';

END;

{}

Function  ANSIUpCount(            Rows           : BYTE      ) : STRING;

BEGIN

  ANSIUpCount := ESC + '[' + IntToStr(Rows) + 'A';

END;

{}

Function  ANSIDown                                             : STRING;

BEGIN

  ANSIDown := ESC + '[B';

END;

{}

Function  ANSIDownCount(          Rows           : BYTE      ) : STRING;

BEGIN

  ANSIDownCount := ESC + '[' + IntToStr(Rows) + 'B';

END;

{}

Function  ANSIRight                                            : STRING;

BEGIN

  ANSIRight := ESC + '[C';

END;

{}

Function  ANSIRightCount(         Cols           : BYTE      ) : STRING;

BEGIN

  ANSIRightCount := ESC + '[' + IntToStr(Cols) + 'C';

END;

{}

Function  ANSILeft                                             : STRING;

BEGIN

  ANSILeft := ESC + '[D';

END;

{}

Function  ANSILeftCount(          Cols           : BYTE      ) : STRING;

BEGIN

  ANSILeftCount := ESC + '[' + IntToStr(Cols) + 'D';

END;

{}

Function  ANSIClrScr                                           : STRING;

BEGIN

  ANSIClrScr := ESC + '[2J';

END;

{}

Function  ANSIClrScrBefore                                     : STRING;

BEGIN

  ANSIClrScrBefore := ESC + '[1J';

END;

{}

Function  ANSIClrScrAfter                                      : STRING;

BEGIN

  ANSIClrScrAfter := ESC + '[J';

END;

{}

Function  ANSIClrEol                                           : STRING;

BEGIN

  ANSIClrEol := ESC + '[K';

END;

{}

Function  ANSIClrSol                                           : STRING;

BEGIN

  ANSIClrSol := ESC + '[1K';

END;

{}

Function  ANSIClrLine                                          : STRING;

BEGIN

  ANSIClrLIne := ESC + '[2K';

END;

{}

Function  ANSIInsLine                                          : STRING;

BEGIN

  ANSIInsLine := ESC + '[L';

END;

{}

Function  ANSIInsLineCount(       Rows           : BYTE      ) : STRING;

BEGIN

  ANSIInsLineCount := ESC + '[' + IntToStr(Rows) + 'L';

END;

{}

Function  ANSIDelLine                                          : STRING;

BEGIN

  ANSIDelLine := ESC + '[M';

END;

{}

Function  ANSIDelLineCount(       Rows           : BYTE      ) : STRING;

BEGIN

  ANSIDelLineCount := ESC + '[' + IntToStr(Rows) + 'M';

END;

{}

Function  ANSISavePos                                          : STRING;

BEGIN

  ANSISavePos := ESC + '[s';

END;

{}

Function  ANSIRestorePos                                       : STRING;

BEGIN

  ANSIRestorePos := ESC + '[u';

END;

{}

Function  ANSIWrapEol                                          : STRING;

BEGIN

  ANSIWrapEol := ESC + '[=7h';

END;

{}

Function  ANSINoWrapEol                                        : STRING;

BEGIN

  ANSINoWrapEol := ESC + '[=7l';

END;

{}

Function  ANSIRequestXY                                        : STRING;

BEGIN

  ANSIRequestXY := ESC + '[6n';

END;

{}

Function  ANSIReportXY                                         : STRING;

BEGIN

{  ANSIReportXY := ESC + '[' + IntToStr(WhereY) + ';' + IntToStr(WhereX) + 'R'; }

END;

{}

Function  ANSIMusic(              Play           : STRING    ) : STRING;

BEGIN

  ANSIMusic := ESC + '[M' + Play + #3;

END;

{}

Function  ANSIMisc(               Params         : STRING    ) : STRING;

Var

  Param : STRING;
  S     : STRING;

BEGIN

  S := '';

  Param := '';
  REPEAT

    Param := GetNextParam( Param, Params );

    If (Param <> '') Then
    BEGIN

    END;

  UNTIL (Param = '');

  ANSIMisc := S;

END;

{}

Function ANSITakeParam( Var Cmd : STRING ) : STRING;

Var

  Idx  : BYTE;
  Cnt  : BYTE;

BEGIN

  Idx := Pos(';', Cmd);

  If Idx = 0 Then
  BEGIN

    Cnt := Byte(Cmd[0]) - 2;

    ANSITakeParam := Copy(Cmd, 3, Cnt);
    Delete(Cmd, 3, Cnt);

  END
  Else
  BEGIN

    Dec(Idx);
    Cnt := Idx - 2;

    ANSITakeParam := Copy(Cmd, 3, Cnt);
    Delete(Cmd, 3, Succ(Cnt));

  END;

END;

{}

Function ANSITakeInt( Var Cmd : STRING ) : INTEGER;

BEGIN

  ANSITakeInt := StrToInt( ANSITakeParam(Cmd) );

END;

{}

Function ANSINextParam( Var Cmd : STRING ) : INTEGER;

{ -1 = no parameter        }
{  1 = string parameter    }
{  2 = command             }
{  3 = number parameter    }
{  4 = blank parameter ';' }

BEGIN

  If Byte(Cmd[0]) < 3 Then
    ANSINextParam := -1
  Else
  If Cmd[Byte(Cmd[0])] = '"' Then
    ANSINextParam := 1
  Else
  If NOT IsNum(Cmd[Byte(Cmd[0])]) Then
    ANSINextParam := 2
  Else
  If Cmd[3] = ';' Then
  BEGIN
    Delete(Cmd, 3, 1);   { yuck - but works! }
    ANSINextParam := 4;
  END
  Else
    ANSINextParam := 3;

END;

{}

Procedure ResetCmd;

BEGIN

  ANSIEmu.Cmd := '';

END;

{}
(*
Procedure ANSIWrite(              Ch             : CHAR      );

Var

  L1 : INTEGER;
  L2 : BYTE;
  L3 : BYTE;

BEGIN

  With ANSIEmu Do
  BEGIN

    If Cmd[0] > NUL Then
    BEGIN

      If Byte(Cmd[0]) = 1 Then
      BEGIN

        If Ch = '[' Then
          Cmd := Cmd + Ch
        Else
        BEGIN

          Write(Ch);
          ResetCmd;

        END;

      END
      Else
      BEGIN

        If StringMode AND (Ch <> '"') Then
          Cmd := Cmd + Ch
        Else
        Case Ch of

          '0'..'9', { inputing number(s) values }
          ';' :
            Cmd := Cmd + Ch;

          'A' :     { Up Row }

            BEGIN

              If ANSINextParam(Cmd) = 3 Then
                L1 := ANSITakeInt(Cmd)
              Else
                L1 := 1;
              For L2 := 1 to L1 Do
              BEGIN

                L3 := WhereY;
                Inc(L3, Hi(WindMin));

                If ( L3 > Hi(WindMin) ) Then
                  GotoXY(WhereX, Pred(WhereY));

              END;

              ResetCmd;

            END;

          'B' :     { Down Row }

            BEGIN

              If ANSINextParam(Cmd) = 3 Then
                L1 := ANSITakeInt(Cmd)
              Else
                L1 := 1;
              For L2 := 1 to L1 Do
              BEGIN

                L3 := WhereY;
                Inc(L3, Hi(WindMin));

                If ( L3 < Hi(WindMax) ) Then
                  GotoXY(WhereX, Succ(WhereY));

              END;

              ResetCmd;

            END;

          'C' :     { Right Col }

            BEGIN

              If ANSINextParam(Cmd) = 3 Then
                L1 := ANSITakeInt(Cmd)
              Else
                L1 := 1;
              For L2 := 1 to L1 Do
              BEGIN

                L3 := WhereX;
                Inc(L3, Lo(WindMin));

                If ( L3 < Lo(WindMax) ) Then
                  GotoXY(Succ(WhereX), WhereY);

              END;

              ResetCmd;

            END;

          'D' :     { Left Col }

            BEGIN

              If ANSINextParam(Cmd) = 3 Then
                L1 := ANSITakeInt(Cmd)
              Else
                L1 := 1;
              For L2 := 1 to L1 Do
              BEGIN

                L3 := WhereX;
                Inc(L3, Lo(WindMin));

                If ( L3 > Lo(WindMin) ) Then
                  GotoXY(Pred(WhereX), WhereY);

              END;

              ResetCmd;

            END;

          'H',      { Home/GotoRC }
          'f' :

            BEGIN

              With ANSIEmu Do
              BEGIN

                X := Succ(Lo(WindMin));
                Y := Succ(Hi(WindMin));

                If ANSINextParam(Cmd) = 3 Then
                  Inc( Y, Pred(ANSITakeInt(Cmd)) );
                If ANSINextParam(Cmd) = 3 Then
                  Inc( X, Pred(ANSITakeInt(Cmd)) );

                GotoXY( LesserInt(X, Succ(Lo(WindMax))),
                        LesserInt(Y, Succ(Hi(WindMax))) );

              END;

              ResetCmd;

            END;

          's' :     { Save Cursor Position }

            BEGIN

              ANSIEmu.SaveX := WhereX;
              ANSIEmu.SaveY := WhereY;

              ResetCmd;

            END;

          'u' :     { Restore Cursor Position }

            BEGIN

              If (ANSIEmu.SaveX > 0) and
                 (ANSIEmu.SaveY > 0) Then
                GotoXY(ANSIEmu.SaveX, ANSIEmu.SaveY);

              ResetCmd;

            END;

          'm' :     { Graphics }

            BEGIN

              While ( ANSINextParam(Cmd) = 3 ) Do
              BEGIN

                With ANSIEmu Do
                BEGIN

                  L3 := ANSITakeInt(Cmd);

                  Case L3 of

                    0  :   { Attrs OFF }
                      BEGIN

                        AttrBold := 0;
                        TextAttr := 7;

                      END;

                    1  :   { Bold ON }
                      BEGIN

                        AttrBold := 8;
                        TextAttr := TextAttr OR $8;

                      END;

                    5  : TextAttr := TextAttr OR $80;  { Blink ON }
                    7  : TextAttr := TextAttr XOR $FF; { Rev. Video ON }
                    22 : AttrBold := 0; { Bold OFF }
                    25 : TextAttr := TextAttr AND NOT $80; { Blink OFF }
                    27 : TextAttr := TextAttr XOR $FF; { Rev. Video OFF }
                    30 : TextColor(Black + AttrBold);
                    31 : TextColor(Red + AttrBold);
                    32 : TextColor(Green + AttrBold);
                    33 : TextColor(Brown + AttrBold);
                    34 : TextColor(Blue + AttrBold);
                    35 : TextColor(Magenta + AttrBold);
                    36 : TextColor(Cyan + AttrBold);
                    37 : TextColor(LightGray + AttrBold);
                    40 : TextBackGround(Black);
                    41 : TextBackGround(Red);
                    42 : TextBackGround(Green);
                    43 : TextBackGround(Brown);
                    44 : TextBackGround(Blue);
                    45 : TextBackGround(Magenta);
                    46 : TextBackGround(Cyan);
                    47 : TextBackGround(LightGray);

                  End;

                END;

              END;

              ResetCmd;

            END;

          'J' :     { ClrScr }

            BEGIN

              With ANSIEmu Do
              BEGIN

                If ANSINextParam(Cmd) = 3 Then
                  L3 := ANSITakeInt(Cmd)
                Else
                BEGIN  { ClrScr >= }

                  X  := WhereX;
                  Y  := WhereY;
                  L1 := X;
                  L2 := Y;

                  While ( L2 <= Hi(WindMax)) Do
                  BEGIN

                    While (L1 <= Lo(WindMax)) Do
                    BEGIN

                      Inc(L1);
                      Write(SP);

                    END;

                    Inc(L2);
                    L1 := Lo(WindMin);
                    GotoXY(L1, L2);

                  END;

                  GotoXY(X, Y);

                END;

                If L3 = 2 Then  { ClrScr }
                BEGIN

                  ClrScr;
                  TextAttr := 7;

                END
                Else
                If L3 = 1 Then  { ClrScr <= }
                BEGIN

                  With ANSIEmu Do
                  BEGIN

                    X  := WhereX;
                    Y  := WhereY;
                    L1 := X;
                    L2 := Y;

                    GotoXY( Lo(WindMin), Hi(WindMin) );
                    While (WhereY < L2) Do
                    BEGIN

                      While ( WhereX < Lo(WindMax) ) Do
                      BEGIN

                        GotoXY(Succ(WhereX), WhereY);
                        Write(SP);

                      END;

                      GotoXY( Lo(WindMin), Succ(WhereY));

                    END;

                    While (WhereX <= L1) Do
                    BEGIN

                      GotoXY(Succ(WhereX), WhereY);
                      Write(SP);

                    END;

                    GotoXY(X, Y);

                  END;

                END;

              END;

              ResetCmd;

            END;

          'K' :     { ClrEol }

            BEGIN

              ClrEol;

              ResetCmd;

            END;

          'L' :     { InsLine }

            BEGIN

              If ANSINextParam(Cmd) = 3 Then
                L1 := ANSITakeInt(Cmd)
              Else
                L1 := 1;
              For L2 := 1 to L1 Do
                InsLine;

              ResetCmd;

            END;

          'M' :     { DelLine }

            BEGIN

              If ANSINextParam(Cmd) = 3 Then
                L1 := ANSITakeInt(Cmd)
              Else
                L1 := 1;
              For L2 := 1 to L1 Do
                DelLine;

              ResetCmd;

            END;

          'n' :     { Device Status Report }

            BEGIN

              If ANSINextParam(Cmd) = 3 Then
                L1 := ANSITakeInt(Cmd)
              Else
                L1 := 1;

              If L1 = 6 Then
                Write('[' + IntToStr(WhereY) + ';' + IntToStr(WhereX) + 'R');

              ResetCmd;

            END;

          '@' :     { Inserts Characters on Line }

            BEGIN

              If ANSINextParam(Cmd) = 3 Then
                L1 := ANSITakeInt(Cmd)
              Else
                L1 := 1;
              For L2 := 1 to L1 Do
              BEGIN

              END;

              ResetCmd;

            END;

          'P' :     { Deletes Characters on Line }

            BEGIN

              If ANSINextParam(Cmd) = 3 Then
                L1 := ANSITakeInt(Cmd)
              Else
                L1 := 1;
              For L2 := 1 to L1 Do
              BEGIN

              END;

              ResetCmd;

            END;

          'h' :     { Set Graphic Modes }

            BEGIN

              If (ANSINextParam(Cmd) = 3) Then
              BEGIN

                L3 := Byte(ANSITakeInt(Cmd));

                ASM

                  MOV AH, 0
                  MOV AL, L3
                  INT 10h

                END;

              END;

              ResetCmd;

            END;

          'l' :     { Reset Graphic Modes }

            BEGIN

              If (ANSINextParam(Cmd) = 3) Then
              BEGIN

                L3 := Byte(ANSITakeInt(Cmd));

                ASM

                  MOV AH, 0
                  MOV AL, L3
                  INT 10h

                END;

              END;

              ResetCmd;

            END;

          'p' :     { Keyboard Redefination }
            BEGIN

              ResetCmd;

            END;

          '"' :     { inputing a string value }
            BEGIN

              StringMode := NOT StringMode;
              Cmd := Cmd + Ch;

            END;

          '?',
          '=' :
            Cmd := Cmd + Ch;
         Else
         BEGIN

           Write(Ch);
           ResetCmd;

         END

        End;{of case}

      END;

    END
    Else
    If Ch = #27 Then
      Cmd := Cmd + Ch
    Else
      Write(Ch);

  END;

END;
*)

{}
{}
{}

BEGIN

  FillChar( ANSIEmu, SizeOf(TANSIEmu), 0 );

END.
