{
 

 Visionix BIOS Unit (VBIOS)
   Version 0.6m
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 jrt       11/30/93  Yanked out keyboard, int13, cgapixelmap code.
                     moved cgapixelmap stuff to VFont.
                     used keyboard stuff to start vkeybu.

 jrt       10/27/93  Renamed from VBIOS to VBIOSu for beta 0.30

 mep       05/17/93  Added IsBlinkEnabled

 mep       02/13/93  Added various tables

 mep       02/11/93  Cleaned up code for beta release

 jrt       02/08/93  Sync with beta 0.12 release

 jrt       12/07/92  Sync with beta 0.11 release

 jrt       11/25/92  Created

 
}

Unit VBIOSu;

Interface

{}

(*-

[TEXT]

[SECTION: Section 3: The Operating System Services Libraries]
[CHAPTER: Chapter 1: The BIOS Data Area Unit]


<Overview>

This unit maps a single pointer-variable onto the BIOS Data Area (BDA).
located at segment $40.  This pointer can then be used to access
the BDA in a clean way.  The unit works in real mode, protected mode,
and Windows.

For more information on the BIOS DATA area, consult any book which
expains the IBM PC/AT BIOS in detail.

<<Example:>>

  WriteLn(' Total base memory: ',BiosMemMap^.BaseMem );

  { to show the total amount of base memory. }

  WriteLn(' Fixed Disk Last Operation: ',BiosMemMap^.FixedDiskLastOp );


<Definition of abbreviated terms>

   Addr  = Address
   Alpha = Alphanumeric
   Alt   = Alternate
   Attr  = Attribute
   Brdr  = Border
   Buf   = Buffer
   Cmd   = Command
   Col   = Column
   Com   = Communications (serial)
   Ctrl  = Control
   Curr  = Current
   DCC   = Display Combination Code
   Disp  = Display
   Dyn   = Dynamic
   Equip = Equipment on system
   Err   = Error
   Ext   = Extended
   Gen   = Generator
   Grfx  = Graphic
   Idx   = Index
   Intr  = Interrupt
   Kbd   = Keyboard
   Lpt   = Printer (parallel)
   Mem   = Memory
   Ofs   = Offset
   Op    = Operation
   Pal   = Palette
   Param = Parameters
   Prof  = Profile
   Ptr   = Pointer
   Reg   = Register
   Rsvp  = Reserved for future use (unknown)
   Sec   = Secondary
   Sect  = Sector
   Sel   = Select
   Stat  = Status
   Strt  = Start
   Trk   = Track
   Usr   = User
   VSPT  = Video Save Pointer Table
   Vid   = Video

-*)

Type

  TDiskAddrField = RECORD

    Trk          : BYTE;
    Head         : BYTE;
    Sect         : BYTE;
    BytesPerSect : BYTE;

  END;

  {---}

  TBiosMemMap = RECORD

    ComAddr              : Array[1..4] of WORD;   {00}
    LptAddr              : Array[1..4] of WORD;   {08}
    Equip                : WORD;                  {10}
    Rsvp1                : BYTE;                  {12}
    BaseMem              : WORD;                  {13}
    Rsvp2                : BYTE;                  {15}
    Rsvp3                : BYTE;                  {16}
    KbdFlag1             : BYTE;                  {17}
    KbdFlag2             : BYTE;                  {18}
    KbdAltKeypad         : BYTE;                  {19}
    KbdBufHead           : WORD;                  {1A}
    KbdBufTail           : WORD;                  {1C}
    KbdBuf               : Array[1..16] of WORD;  {1E}
    DiskRecalStat        : BYTE;                  {3E}
    DiskMotorStat        : BYTE;                  {3F}
    DiskOffTimeout       : BYTE;                  {40}
    DiskLastOpStat       : BYTE;                  {41}
    DiskCmdStat          : Array[1..7] of BYTE;   {42}
    VidCurrMode          : BYTE;                  {49}
    VidCurrCol           : WORD;                  {4A}
    VidPageSize          : WORD;                  {4C}
    VidCurrPageAddr      : WORD;                  {4E}
    VidCursorPos         : Array[1..8] of WORD;   {50}
    VidCursorType        : WORD;                  {60}
    VidCurrPage          : BYTE;                  {62}
    VidCRTCtrlAddr       : WORD;                  {63}
    VidCurrModeSelReg    : BYTE;                  {65}
    VidCurrCGAPalReg     : BYTE;                  {66}
    PostRealModeAddr     : POINTER;               {67}
    PostLastUnknownIntr  : BYTE;                  {6B}
    TimerTicksToday      : LONGINT;               {6C}
    TimerOverflow        : BOOLEAN;               {70}
    CtrlBreak            : BYTE;                  {71}
    PostReset            : WORD;                  {72}
    FixedDiskLastOp      : BYTE;                  {74}
    FixedDiskNumDrive    : BYTE;                  {75}
    FixedDiskCtrl        : BYTE;                  {76}
    FixedDiskIOPortOfs   : BYTE;                  {77}
    LptTimeout           : Array[1..4] of BYTE;   {78}
    ComTimeout           : Array[1..4] of BYTE;   {7C}
    KbdBufStartOfs       : WORD;                  {80}
    KbdBufEndOfs         : WORD;                  {82}
    VidVGACurrRow        : BYTE;                  {84}
    VidVGACharScanSize   : WORD;                  {85}
    VidVGACtrl           : BYTE;                  {87}
    VidVGASwitch         : BYTE;                  {88}
    VidVGAModeSetCtrl    : BYTE;                  {89}
    VidVGADCCBase        : BYTE;                  {8A}
    DiskMediaCtrl        : BYTE;                  {8B}
    FixedDiskCtrlStat    : BYTE;                  {8C}
    FixedDiskCtrlErrStat : BYTE;                  {8D}
    FixedDiskIntrCtrl    : BYTE;                  {8E}
    DiskCtrlStat         : BYTE;                  {8F}
    Disk0MediaStat       : BYTE;                  {90}
    Disk1MediaStat       : BYTE;                  {91}
    Disk0MediaStrtOpStat : BYTE;                  {92}
    Disk1MediaStrtOpStat : BYTE;                  {93}
    Disk0MediaCurrTrk    : BYTE;                  {94}
    Disk1MediaCurrTrk    : BYTE;                  {95}
    KbdStat1             : BYTE;                  {96}
    KbdStat2             : BYTE;                  {97}
    TimerUsrWaitAddr     : POINTER;               {98}
    TimerUsrWaitTimeout  : LONGINT;               {9C}
    TimerWaitActiveStat  : BYTE;                  {A0}
    NetRsvp1             : Array[1..7] of BYTE;   {A1}
    VidVGAVSPTAddr       : POINTER;               {A8}
    VidDynSaveAreaAddr   : POINTER;               {AC}
    VidAlphaCharGenAddr  : POINTER;               {B0}
    VidGrfxCharGenAddr   : POINTER;               {B4}
    VidSecSaveAddr       : POINTER;               {B8}
    Rsvp6                : Array[1..4] of BYTE;   {BC}
    Rsvp7                : Array[1..$E] of BYTE;  {C0}
    TimerDaysSinceBoot   : WORD;                  {CE}
    Rsvp8                : Array[1..$20] of BYTE; {D0}
    UsrRsvp1             : Array[1..$10] of BYTE; {F0}
    LptScrnStat          : BYTE;                  {100}

  END;

  PBiosMemMap = ^TBiosMemMap;

  {----}

Var

  BIOSMemMap : PBIOSMemMap;

{}



Implementation

Uses

  VTypesu,
  DOS;


{}
{}
{}

BEGIN

  BiosMemMap := Ptr( Seg0040, 0 );

END.

