{


 Visionix DOS Protected Mode Interface Unit (VDPMI)
   Version 0.3
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED



 Revision history in reverse chronological order:

 Initials  Date      Comment
 --------  --------  -------------------------------------------------------

 jrt       10/25/93  Reintroduced unfinished code to implement a
                     permanent reflection buffer.

 jrt       05/26/93  Added RealIntr, finished RefBuffIntr

 rag       05/19/93  Fixed bug for protected mode.  VDPMIDosAllocMemBlock
                     is wrong, should have been VDPMIDosAllocMemory.
                     Also VDPMIFreeDosBlock should have been
                     VDPMIFreeDosMemory.

 mep       04/01/93  Finish majority of unit model.

 jrt       01/09/92  Added RefBuffIntr function.  May move to other unit
                     at a later date.

 jrt       12/15/92  Created.


}

(*-

[TEXT]

<Overview>

This unit implements a function for all commands in the DOS Protected
Mode Interface 0.9 and 1.0 specifications.  For more information,
refer to the DPMI specification.  (Intel Order No. 240977-001)

Additionally, this unit impelements functions to assist in allocating
and using protected mode to real mode "reflection buffers".  Reflection
buffers are used when calling a real mode BIOS routine from protected mode.

The documentation for this unit will be enhanced in the next release.

<Interface>

-*)


Unit VDPMIu;

Interface

Uses

  DOS,
  VTypesu,
  VGenu;

{}


{-----------------}
{ Error Constants }
{-----------------}

Const

  dpmiNoErr  = 0;
  dpmiGenErr = $CBAD;

Const

{-------------------------------------------------------}
{ Bitmaps/Constants for functions defined below:        }
{ - hexidecimal values are considered bitwise operants  }
{ - decimal values are considered constants             }
{-------------------------------------------------------}

  { VDPMISimRealIntr.Flags,     }
  { VDPMICallRealProc.Flags and }
  { VDPMICallRealIntrProc       }
  { - for DPMI 0.9 only.        }

   dpmibmResetIntrCtrlA20       = $1;

  { VDPMIGetVersion.Flags }

   dpmibmRunning32bit           = $1;
   dpmibmProcessorRetRealMode   = $2;
   dpmibmVirtMemSupport         = $4;
   dpmibmRsvp1                  = $8;

  { VDPMIGetVersion.ProcType }

   dpmibm286                    = 2;
   dpmibm386                    = 3;
   dpmibm486                    = 4;

  { VDPMIGetCaps.CaoFlags }

   dpmibmPagedAccessSupport     = $1;
   dpmibmPagedDirtySupport      = $1;
   dpmibmExpRestartSupport      = $2;
   dpmibmDevMapSupport          = $4;
   dpmibmConvMemMapSupport      = $8;
   dpmibmDemandZeroFilled       = $10;
   dpmibmWriteProtClientCap     = $20;
   dpmibmWriteProtHostCap       = $40;

 { VDPMIAllocLinMemory.Flags }

   dpmibmCreateCommitPages      = $1;

 { VDPMIResizeLinMemory.NewFlags -> see VDPMIAllocLinMemory.Flags }

   dpmibmSegDescUpdateReq       = $2;

 { VDPMIGetPageAttrs.PageAttr (each within PageAttrArr) }

   dpmibmPageType               = $1;  { 0..2 }
   dpmibmPageReadWrite          = $4;  { 3 }
   dpmibmAccessedBitsNext       = $8;  { 4 }
   dpmibmPageAccessed           = $10; { 5 - see dpmibmAccessedBitsNext }
   dpmibmPageWritten            = $20; { 6 - see dpmibmAccessedBitsNext }

 { VDPMITestDisableInts.PrevState and }
 { VDPMITestEnableInts.PrevState      }

   dpmibmPrevDisabled           = 0;
   dpmibmPrevEnabled            = 1;

 { VDPMITestInts.State }

   dpmibmNowDisabled            = 0;
   dpmibmNowEnabled             = 1;

 { VDPMISetDebugWatchp.WatchType }

   dpmibmDebugExecute           = 0;
   dpmibmDebugWrite             = 1;
   dpmibmDebugReadWrite         = 2;

 { VDPMIGetDebugWatchpState.WatchState }

   dpmibmWatchpExecuted         = $1;

 { VDPMISerOneSharedMem.Flags }

   dpmibmSerRetWithoutSuspend   = $1;
   dpmibmSerShared              = $2;

 { VDPMIFreeSerOnSharedMem.Flags }

   dpmibmReleaseSharedSer       = $1;
   dpmibmFreePendingSer         = $2;

 { VDPMIGetCoprocStatus }

   dpmibmClientNumCoprocEnabled = $1;
   dpmibmClientIsEmuCoproc      = $2;
   dpmibmNumCoprocPresent       = $4;
   dpmibmHostEmuCoprocInst      = $8;
   dpmibmCoprocType             = $10; { 4..7 }

   dpmibmCoprocNone             = 0;
   dpmibmCoproc80287            = 1;
   dpmibmCoproc80387            = 2;
   dpmibmCoproc80486            = 3;

 { VDPMISetCoProcEmulation.EmuFlags }

   dpmibmEnableClientNumCoproc  = $1;
   dpmibmClientWillEmuCoproc    = $2;

{---------------------------}
{ Constants for RefBuffIntr }
{---------------------------}

Const

  rb_ESAX    = $0001;
  rb_ESBX    = $0002;
  rb_ESCX    = $0003;
  rb_ESDX    = $0004;
  rb_ESSI    = $0005;
  rb_ESDI    = $0006;
  rb_ESBP    = $0007;

  rb_DSAX    = $0011;
  rb_DSBX    = $0012;
  rb_DSCX    = $0013;
  rb_DSDX    = $0014;
  rb_DSSI    = $0015;
  rb_DSDI    = $0016;
  rb_DSBP    = $0017;

  rb_down    = $0100;
  rb_up      = $0200;
  rb_updown  = $0300;
  rb_downup  = $0300;


{-----------------------------------}
{ DPMI Real mode register structure }
{-----------------------------------}

Type

  QWORD      = Array[1..2] of LONGINT;

  TREGISTERS = REGISTERS;

  TDPMIErr   = WORD;

  {---------------------------------}

  TDPMIRealRegs = RECORD

    EDI    : LONGINT;
    ESI    : LONGINT;
    EBP    : LONGINT;
    Resp1  : LONGINT;
    EBX    : LONGINT;
    EDX    : LONGINT;
    ECX    : LONGINT;
    EAX    : LONGINT;
    Flags  : WORD;
    ES     : WORD;
    DS     : WORD;
    FS     : WORD;
    GS     : WORD;
    IP     : WORD;
    CS     : WORD;
    SP     : WORD;
    SS     : WORD;

  END;
  PDPMIRealRegs = ^TDPMIRealRegs;

  {---------------------------------}

  TDescriptorT = RECORD

    DescLimit      : WORD;
    DescLinBaseLo  : WORD;
    DescLinBaseMid : BYTE;
    DescAccess     : BYTE;
    DescExtAccess  : BYTE;
    DescLinBaseHi  : BYTE;

  END;

  PDescriptorT = ^TDescriptorT;

  {---------------------------------}

  PVectHandle = POINTER; { Selector:Offset }

  PSelOfs = POINTER; { Selector:Offset }

  PSelOfs32 = Array[1..6] of BYTE; { Selector:Offset-32BIT }

  {---------------------------------}

  TDescBuff = RECORD

    Selector   : WORD;
    Descriptor : QWORD;

  END;
  PDescBuff = ^TDescBuff;

  {---------------------------------}

  TStackFrame16 = RECORD

    RetCSIP    : LONGINT;
    ErrorCode  : WORD;
    ExceptCSIP : LONGINT;
    Flags      : WORD;
    SSSP       : LONGINT;

  END;
  PStackFrame16 = ^TStackFrame16;

  {---------------------------------}

  TStackFrame32 = RECORD

    RetEIP      : LONGINT;
    RetCSSel    : WORD;
    Rsvp1       : WORD;
    ErrorCode   : LONGINT;
    ExceptEIP   : LONGINT;
    ExceptCSSel : WORD;
    Rsvp2       : WORD;
    EFlags      : LONGINT;
    ESP         : LONGINT;
    SS          : WORD;
    Rsvp3       : WORD;

  END;

  PStackFrame32 = ^TStackFrame32;

  {---------------------------------}

  TGetCapsBuff = RECORD

    MajorVer : BYTE;
    MinorVer : BYTE;
    Vendor   : Array[1..126] of CHAR;

  END;
  PGetCapsBuff = ^TGetCapsBuff;

  {---------------------------------}

  TFreeMemInfo = RECORD

    MaxAvailBlock      : LONGINT;
    MaxUnlockPageAlloc : LONGINT;
    MaxLockPageAlloc   : LONGINT;
    TotalLinAddrPages  : LONGINT;
    TotalUnlockPages   : LONGINT;
    FreePages          : LONGINT;
    TotalPhyPages      : LONGINT;
    FreeLinAddrPages   : LONGINT;
    SizePageFile       : LONGINT;
    Rsvp               : Array[1..12] of BYTE;

  END;
  PFreeMemInfo = ^TFreeMemInfo;

  {---------------------------------}

  TPageAttr = Array[1..1] of WORD;
  PPageAttr = ^PPageAttr;

  {---------------------------------}

  TMemInfo = RECORD

    HostPhyMemAlloc    : LONGINT;
    HostVirtMemAlloc   : LONGINT;
    HostVirtMemAvail   : LONGINT;
    CurrVirtMemAlloc   : LONGINT;
    CurrVirtMemAvail   : LONGINT;
    ClientVirtMemAlloc : LONGINT;
    ClientVirtMemAvail : LONGINT;
    ClientMemLocked    : LONGINT;
    ClientMaxMemLocked : LONGINT;
    ClientMaxLinAddr   : LONGINT;
    MaxBlockAvail      : LONGINT;
    MinAllocUnit       : LONGINT;
    AlignAllocUnit     : LONGINT;
    Rsvp               : Array[1..76] of BYTE;

  END;
  PMemInfo = ^TMemInfo;

  {---------------------------------}

  TRSPBuff = RECORD

    Desc16DataSeg     : QWORD;
    Desc16CodeSeg     : QWORD;
    Ofs16CallbackProc : WORD;
    Rsvp              : Array[1..2] of BYTE;
    Desc32DataSeg     : QWORD;
    Desc32CodeSeg     : QWORD;
    Ofs32CallbackProc : LONGINT;

  END;
  PRSPBuff = ^TRSPBuff;

  {---------------------------------}

  TMemReqStruct = RECORD

    ReqMemBlockSize : LONGINT;
    AllocBlockSize  : LONGINT;
    SMemHandle      : LONGINT;
    LinAddr         : LONGINT;
    MemBlockName    : PSelOfs32;
    Rsvp1           : Array[1..2] of BYTE;
    Rsvp2           : Array[1..4] of BYTE;

  END;
  PMemReqStruct = ^TMemReqStruct;

  {---------------------------------}

Type

  TVDPMIPermReflectBuff = RECORD

    Allocated : BOOLEAN;
    InUse     : BOOLEAN;

    RealPtr   : POINTER;
    ProtPtr   : POINTER;

    BuffSize  : LONGINT;

  END;

  PVDPMIPermReflectBuff = ^TVDPMIPermReflectBuff;



{}

{ see DPMI 0.9 spec for info on these functions }
{ can be used in any environment that is a DPMI }
{ server (BP 7.0 protected mode, windows dos    }
{ boxes, OS/2 dos boxes, etc.                   }


Function  VDPMIErrToStr(               ErrCode        : WORD    ) : STRING;

Function  VDPMIInstalled                                          : BOOLEAN;

Function  VDPMIInstallInfo(        Var Support32bit   : BOOLEAN;
                                   Var Processor      : BYTE;
                                   Var MajorVer       : BYTE;
                                   Var MinorVer       : BYTE;
                                   Var NumParagraphs  : WORD;
                                   Var DPMIEntry      : POINTER ) : TDPMIErr;

Function  VDPMIAllocLDTDescriptor(     NumDesc        : WORD;
                                   Var BaseSelector   : WORD    ) : TDPMIErr;

Function  VDPMIFreeLDTDescriptor(      Selector       : WORD    ) : TDPMIErr;

Function  VDPMIMapSegToSel(            RealModeSeg    : WORD;
                                   Var NewSelector    : WORD    ) : TDPMIErr;

Function  VDPMIGetSelectorDiff                                    : TDPMIErr;

Function  VDPMILockSel(                Selector       : WORD    ) : TDPMIErr;

Function  VDPMIUnlockSel(              Selector       : WORD    ) : TDPMIErr;

Function  VDPMIGetSegmentBase(         Selector       : WORD;
                                   Var BaseAddr       : LONGINT ) : TDPMIErr;

Function  VDPMISetSegmentBase(         Selector       : WORD;
                                       BaseAddr       : LONGINT ) : TDPMIErr;

Function  VDPMISetSegmentLimit(        Selector       : WORD;
                                       Limit          : LONGINT ) : TDPMIErr;

Function  VDPMISetSegmentRights(       Selector       : WORD;
                                       Rights         : BYTE;
                                       ExtRights      : BYTE    ) : TDPMIErr;

Function  VDPMICreateAlias(            Selector       : WORD;
                                   Var NewSelector    : WORD    ) : TDPMIErr;

Function  VDPMIGetDescriptor(          Selector       : WORD;
                                       DescBuff       : POINTER ) : TDPMIErr;

Function  VDPMISetDescriptor(          Selector       : WORD;
                                       DescBuff       : POINTER ) : TDPMIErr;

Function  VDPMIAllocSpecDescriptor(    Selector       : WORD    ) : TDPMIErr;

Function  VDPMIGetMultDescriptors(     NumDescs       : WORD;
                                       DescBuff       : PDescBuff;
                                   Var NumDescsCopied : WORD    ) : TDPMIErr;

Function  VDPMISetMultDescriptors(     NumDescs       : WORD;
                                       DescBuff       : PDescBuff;
                                   Var NumDescsCopied : WORD    ) : TDPMIErr;

Function  VDPMIAllocDOSMemory(         NumParas       : WORD;
                                   Var RealModeSeg    : WORD;
                                   Var ProtModeSel    : WORD    ) : TDPMIErr;

Function  VDPMIFreeDOSMemory(          ProtModeSel    : WORD    ) : TDPMIErr;

Function  VDPMIResizeDOSMemory(        Selector       : WORD;
                                       NewBlockParas  : WORD;
                                   Var MaxBlockSize   : WORD    ) : TDPMIErr;

Function  VDPMIGetRealIntrVector(      IntNum         : WORD;
                                   Var Vector         : POINTER ) : TDPMIErr;

Function  VDPMISetRealIntrVector(      IntNum         : WORD;
                                       Vector         : POINTER ) : TDPMIErr;

Function  VDPMIGetProcExpVector(       ExpNum         : BYTE;
                                   Var Vector         : PVectHandle ) : TDPMIErr;

Function  VDPMISetProcExpVector(       ExpNum         : BYTE;
                                       Vector         : PVectHandle ) : TDPMIErr;

Function  VDPMIGetProtIntrVector(      IntNum         : WORD;
                                   Var Vector         : PVectHandle ) : TDPMIErr;

Function  VDPMISetProtIntrVector(      IntNum         : WORD;
                                       Vector         : PVectHandle ) : TDPMIErr;

Function  VDPMIGetProtExtExpProc(      ExpNum         : BYTE;
                                   Var Handler        : PVectHandle ) : TDPMIErr;

Function  VDPMIGetRealExtExpProc(      ExpNum         : BYTE;
                                   Var Handler        : PVectHandle ) : TDPMIErr;

Function  VDPMISetProtExtExpProc(      ExpFaultNum    : BYTE;
                                   Var Handler        : PVectHandle ) : TDPMIErr;

Function  VDPMISetRealExtExpProc(      ExpFaultNum    : BYTE;
                                   Var Handler        : PVectHandle ) : TDPMIErr;

Function  VDPMISimRealIntr(            IntrNum        : WORD;
                                       Flags          : WORD;
                                       StackCopy      : WORD;
                                       RealRegs       : PDPMIRealRegs) : TDPMIErr;

Function  VDPMICallRealProc(           Flags          : WORD;
                                       StackCopy      : WORD;
                                       RealRegs       : PDPMIRealRegs) : TDPMIErr;

Function  VDPMICallRealIntrProc(       Flags          : WORD;
                                       StackCopy      : WORD;
                                       RealRegs       : PDPMIRealRegs) : TDPMIErr;

Function  VDPMIAllocRealCallback(      ProtProc       : PSelOfs;
                                       RealRegBuff    : PDPMIRealRegs;
                                   Var CallBackAddr   : POINTER ) : TDPMIErr;

Function  VDPMIFreeRealCallback(       CallBackAddr   : POINTER ) : TDPMIErr;

Function  VDPMIGetStateSRProcs(    Var StateBuffSize  : WORD;
                                   Var RealModeAddr   : POINTER;
                                   Var ProtModeAddr   : POINTER ) : TDPMIErr;

Function  VDPMIGetRawSwitchProcs(  Var RealToProtAddr : POINTER;
                                   Var ProtToRealAddr : POINTER ) : TDPMIErr;

Function  VDPMIGetVersion(         Var MajorVer       : BYTE;
                                   Var MinorVer       : BYTE;
                                   Var Flags          : WORD;
                                   Var ProcType       : BYTE;
                                   Var VirtMastPIC    : BYTE;
                                   Var VirtSlavePIC   : BYTE    ) : TDPMIErr;

Function  VDPMIGetCaps(                InfoBuffer     : PGetCapsBuff;
                                   Var CaoFlags       : WORD    ) : TDPMIErr;

Function  VDPMIGetFreeMemory(          InfoBuffer     : PFreeMemInfo ) : TDPMIErr;

Function  VDPMIAllocMemory(            Size           : LONGINT;
                                   Var LinAddr        : LONGINT;
                                   Var MemHandle      : LONGINT ) : TDPMIErr;

Function  VDPMIFreeMemory(             MemHandle      : LONGINT ) : TDPMIErr;

Function  VDPMIResizeMemory(           MemHandle      : LONGINT;
                                       NewSize        : LONGINT;
                                   Var NewMemHandle   : LONGINT;
                                   Var NewLinAddr     : LONGINT ) : TDPMIErr;

Function  VDPMIAllocLinMemory(         LinAddr        : LONGINT;
                                       Size           : LONGINT;
                                       Flags          : LONGINT;
                                   Var NewLinAddr     : LONGINT;
                                   Var MemHandle      : LONGINT ) : TDPMIErr;

Function  VDPMIResizeLinMemory(        MemHandle      : LONGINT;
                                       NewSize        : LONGINT;
                                       NewFlags       : LONGINT;
                                   Var NewLinAddr     : LONGINT;
                                   Var NewMemHandle   : LONGINT ) : TDPMIErr;

Function  VDPMIGetPageAttrs(           MemHandle      : LONGINT;
                                       BasePageOfs    : LONGINT;
                                       NumPages       : LONGINT;
                                   Var PageAttrArr    : PPageAttr ) : TDPMIErr;

Function  VDPMIModifyPageAttrs(        MemHandle      : LONGINT;
                                       BasePageOfs    : LONGINT;
                                       NumPages       : LONGINT;
                                       PageAttrArr    : PPageAttr;
                                   Var NewNumPages    : LONGINT ) : TDPMIErr;

Function  VDPMIMapDeviceMemory(        MemHandle      : LONGINT;
                                       PageOfs        : LONGINT;
                                       NumPages       : LONGINT;
                                       PhyDevAddr     : LONGINT ) : TDPMIErr;

Function  VDPMIMapConvMemory(          MemHandle      : LONGINT;
                                       PageOfs        : LONGINT;
                                       NumPages       : LONGINT;
                                       LinConvMemAddr : LONGINT ) : TDPMIErr;

Function  VDPMIGetMemorySizeBase(      MemHandle      : LONGINT;
                                   Var Size           : LONGINT;
                                   Var BaseAddr       : POINTER ) : TDPMIErr;

Function  VDPMIGetMemoryInfo(          MemInfo        : PMemInfo) : TDPMIErr;

Function  VDPMILockLinRegion(          LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Function  VDPMIUnlockLinRegion(        LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Function  VDPMIMarkRealRegionPageable( LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Function  VDPMIRelockRealRegion(       LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Function  VDPMIGetPageSize(        Var PageSize       : LONGINT ) : TDPMIErr;

Function  VDPMIMarkPagesCandidate(     LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Function  VDPMIDiscardPages(           LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Function  VDPMINominatePages(          LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Function  VDPMIDiscardPageContents(    LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Function  VDPMIMapPhysicalRegion(      PhysStart      : LONGINT;
                                       Size           : LONGINT;
                                   Var LinAddr        : LONGINT ) : TDPMIErr;

Function  VDPMIFreePhysicalRegion(     LinAddr        : LONGINT ) : TDPMIErr;

Function  VDPMITestDisableInts(    Var PrevState      : BYTE    ) : TDPMIErr;

Function  VDPMITestEnableInts(     Var PrevState      : BYTE    ) : TDPMIErr;

Function  VDPMITestInts(           Var State          : BYTE    ) : TDPMIErr;

Function  VDPMIGetVendorAPIEntry(      VendorName     : STRING;
                                   Var APIEntry       : POINTER ) : TDPMIErr;

Function  VDPMISetDebugWatchp(         LinAddr        : LONGINT;
                                       WatchSize      : BYTE;
                                       WatchType      : BYTE;
                                   Var WatchHandle    : WORD    ) : TDPMIErr;

Function  VDPMIClearDebugWatchp(       WatchHandle    : WORD    ) : TDPMIErr;


Function  VDPMIGetDebugWatchpState(    WatchHandle    : WORD;
                                   Var WatchState     : WORD    ) : TDPMIErr;

Function  VDPMIResetDebugWatchp(       WatchHandle    : WORD    ) : TDPMIErr;

Function  VDPMIInstallRSPCallback(     RSPBuff        : PRSPBuff) : TDPMIErr;

Function  VDPMITermAndStayResident(    RetCode        : BYTE;
                                       DosParasToKeep : WORD    ) : TDPMIErr;

Function  VDPMIAllocSharedMemory(      MemReqStruct   : PMemReqStruct ) : TDPMIErr;

Function  VDPMIFreeSharedMemory(       SMemHandle     : LONGINT ) : TDPMIErr;

Function  VDPMISerOnSharedMem(         SMemHandle     : LONGINT;
                                       Flags          : WORD    ) : TDPMIErr;

Function  VDPMIFreeSerOnSharedMem(     SMemHandle     : LONGINT;
                                       Flags          : WORD    ) : TDPMIErr;

Function  VDPMIGetCoprocStatus                                    : WORD;

Function  VDPMISetCoProcEmulation(     EmuFlags       : WORD    ) : TDPMIErr;

Function  RefBuffIntr(                 Flags          : WORD;
                                       IntNum         : BYTE;
                                       R              : TREGISTERS;
                                       BuffPtr        : POINTER;
                                       BuffSize       : LONGINT ) : TDPMIErr;

{}

Implementation

Var

  PermReflectBuff : TVDPMIPermReflectBuff;


{}

Function  VDPMIErrToStr(          ErrCode        : WORD         ) : STRING;

Var

  S : STRING;

BEGIN

  S := '';

  Case ErrCode of

    $0000..$7FFF: S := 'DOS error ' + IntToStr(ErrCode) + ' passed through by DPMI';
    $8001: S := 'Unsupported function';
    $8002: S := 'Object in wrong state for function';
    $8003: S := 'System integrity would be endangered';
    $8004: S := 'Deadlock detected';
    $8005: S := 'Pending serialization request cancelled';
    $8010: S := 'Out of DPMI internal resources';
    $8011: S := 'Descriptor unavailable';
    $8012: S := 'Linear memory unavailable';
    $8013: S := 'Physical memory unavailable';
    $8014: S := 'Backing store unavailable';
    $8015: S := 'Callback unavailable';
    $8016: S := 'Handle unavailable';
    $8017: S := 'Maximum lock count exceeded';
    $8018: S := 'Shared memory already serialized exclusively by another';
    $8019: S := 'Shared memory already serialized shared by another client';
    $8021: S := 'Invalid value for numeric or flag parameter';
    $8022: S := 'Invalid segment selector';
    $8023: S := 'Invalid handle';
    $8024: S := 'Invalid callback';
    $8025: S := 'Invalid linear address';
    $8026: S := 'Request not supported by hardware';

  End;

  VDPMIErrToStr := S;

END;

{}

Function  VDPMIInstalled                                          : BOOLEAN;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $1687;
  R.ES := 0;
  R.DS := 0;

  Intr( $2F, R );

  VDPMIInstalled := (R.AX = 0);

END;

{}

Function  VDPMIInstallInfo(        Var Support32bit   : BOOLEAN;
                                   Var Processor      : BYTE;
                                   Var MajorVer       : BYTE;
                                   Var MinorVer       : BYTE;
                                   Var NumParagraphs  : WORD;
                                   Var DPMIEntry      : POINTER ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $1687;
  R.ES := 0;
  R.DS := 0;

  Intr( $2F, R );

  If (R.AX <> 0) Then
  BEGIN

    VDPMIInstallInfo := dpmiGenErr;
    Exit;

  END
  Else
    VDPMIInstallInfo := dpmiNoErr;

  Support32bit  := (R.BX AND $1 <> 1);
  Processor     := R.CL;
  MajorVer      := R.DH;
  MinorVer      := R.DL;
  NumParagraphs := R.SI;
  DPMIEntry     := Ptr( R.ES, R.DI );

END;

{}

Function  VDPMIAllocLDTDescriptor(     NumDesc        : WORD;
                                   Var BaseSelector   : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0000;
  R.CX := NumDesc;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    BaseSelector            := 0;
    VDPMIAllocLDTDescriptor := R.AX;

  END
  Else
  BEGIN

    BaseSelector     := R.AX;
    VDPMIAllocLDTDescriptor := 0;

  END;

END;

{}

Function  VDPMIFreeLDTDescriptor(      Selector       : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0001;
  R.BX := Selector;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIFreeLDTDescriptor := R.AX;

  END
  Else
  BEGIN

    VDPMIFreeLDTDescriptor := 0;

  END;

END;

{}

Function  VDPMIMapSegToSel(            RealModeSeg    : WORD;
                                   Var NewSelector    : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0002;
  R.BX := RealModeSeg;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    NewSelector      := 0;
    VDPMIMapSegToSel := R.AX;

  END
  Else
  BEGIN

    VDPMIMapSegToSel := 0;

  END;

END;

{}

Function  VDPMIGetSelectorDiff                                    : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0003;
  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  VDPMIGetSelectorDiff := R.AX;

END;

{}

Function  VDPMILockSel(                Selector       : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0004;
  R.BX := Selector;
  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  VDPMILockSel := 0;  {!! Unknown return}

END;

{}

Function  VDPMIUnlockSel(              Selector       : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0005;
  R.BX := Selector;
  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  VDPMIUnlockSel := 0;  {!! Unknown return}

END;

{}

Function  VDPMIGetSegmentBase(         Selector       : WORD;
                                   Var BaseAddr       : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0006;
  R.BX := Selector;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetSegmentBase := R.AX;

  END
  Else
  BEGIN

    BaseAddr            := (R.CX SHL 16)+R.DX;
    VDPMIGetSegmentBase := 0;

  END;

END;

{}

Function  VDPMISetSegmentBase(         Selector       : WORD;
                                       BaseAddr       : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0007;
  R.BX := Selector;

  R.CX := TCastDWord(BaseAddr).HighWord;
  R.DX := TCastDWord(BaseAddr).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISetSegmentBase := R.AX;

  END
  Else
  BEGIN

    VDPMISetSegmentBase := 0;

  END;

END;

{}

Function  VDPMISetSegmentLimit(        Selector       : WORD;
                                       Limit          : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0008;
  R.BX := Selector;

  R.CX := TCastDWord(Limit).HighWord;
  R.DX := TCastDWord(Limit).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISetSegmentLimit := R.AX;

  END
  Else
  BEGIN

    VDPMISetSegmentLimit := 0;

  END;

END;

{}

Function  VDPMISetSegmentRights(       Selector       : WORD;
                                       Rights         : BYTE;
                                       ExtRights      : BYTE    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0009;
  R.BX := Selector;

  R.CL := Rights;
  R.CH := ExtRights;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISetSegmentRights := R.AX;

  END
  Else
  BEGIN

    VDPMISetSegmentRights := 0;

  END;

END;

{}

Function  VDPMICreateAlias(            Selector       : WORD;
                                   Var NewSelector    : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $000A;
  R.BX := Selector;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMICreateAlias := R.AX;

  END
  Else
  BEGIN

    NewSelector      := R.AX;
    VDPMICreateAlias := 0;

  END;

END;

{}

Function  VDPMIGetDescriptor(          Selector       : WORD;
                                       DescBuff       : POINTER ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $000B;
  R.BX := Selector;

  R.ES := TCastDWord(DescBuff).HighWord;
  R.DI := TCastDWord(DescBuff).LowWord;

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetDescriptor := R.AX;

  END
  Else
  BEGIN

    VDPMIGetDescriptor := 0;

  END;

END;

{}

Function  VDPMISetDescriptor(          Selector       : WORD;
                                       DescBuff       : POINTER ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $000C;
  R.BX := Selector;

  R.ES := TCastDWord(DescBuff).HighWord;
  R.DI := TCastDWord(DescBuff).LowWord;

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISetDescriptor := R.AX;

  END
  Else
  BEGIN

    VDPMISetDescriptor := 0;

  END;

END;

{}

Function  VDPMIAllocSpecDescriptor(    Selector       : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $000D;
  R.BX := Selector;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIAllocSpecDescriptor := R.AX;

  END
  Else
  BEGIN

    VDPMIAllocSpecDescriptor := 0;

  END;

END;

{}

Function  VDPMIGetMultDescriptors(     NumDescs       : WORD;
                                       DescBuff       : PDescBuff;
                                   Var NumDescsCopied : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $000E;
  R.CX := NumDescs;

  R.ES := TCastDWord(DescBuff).HighWord;
  R.DI := TCastDWord(DescBuff).LowWord;

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetMultDescriptors := R.AX;

  END
  Else
  BEGIN

    VDPMIGetMultDescriptors := 0;
    NumDescsCopied           := R.CX;

  END;

END;

{}

Function  VDPMISetMultDescriptors(     NumDescs       : WORD;
                                       DescBuff       : PDescBuff;
                                   Var NumDescsCopied : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $000F;
  R.CX := NumDescs;

  R.ES := TCastDWord(DescBuff).HighWord;
  R.DI := TCastDWord(DescBuff).LowWord;

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISetMultDescriptors := R.AX;

  END
  Else
  BEGIN

    VDPMISetMultDescriptors := 0;
    NumDescsCopied          := R.CX;

  END;

END;

{}

Function  VDPMIAllocDOSMemory(         NumParas       : WORD;
                                   Var RealModeSeg    : WORD;
                                   Var ProtModeSel    : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0100;
  R.BX := NumParas;

  R.ES := $0;
  R.DS := $0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
    VDPMIAllocDOSMemory := R.AX
  Else
  BEGIN

    RealModeSeg := R.AX;
    ProtModeSel := R.DX;

    VDPMIAllocDOSMemory := 0;

  END;

END;

{}

Function  VDPMIFreeDOSMemory(          ProtModeSel    : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0101;
  R.DX := ProtModeSel;
  R.ES := $0;
  R.DS := $0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
    VDPMIFreeDOSMemory := R.AX
  Else
    VDPMIFreeDOSMemory := 0;

END;

{}

Function  VDPMIResizeDOSMemory(        Selector       : WORD;
                                       NewBlockParas  : WORD;
                                   Var MaxBlockSize   : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0102;
  R.BX := NewBlockParas;
  R.DX := Selector;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIResizeDOSMemory := R.AX;
    MaxBlockSize         := R.BX;

  END
  Else
  BEGIN

    VDPMIResizeDOSMemory := 0;

  END;

END;

{}

Function  VDPMIGetRealIntrVector(      IntNum         : WORD;
                                   Var Vector         : POINTER ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0200;
  R.BL := IntNum;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  TCastDWord(Vector).HighWord := R.CX;
  TCastDWord(Vector).LowWord  := R.DX;

  VDPMIGetRealIntrVector := 0;

END;

{}

Function  VDPMISetRealIntrVector(      IntNum         : WORD;
                                       Vector         : POINTER ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0201;
  R.BL := IntNum;

  R.CX := TCastDWord(Vector).HighWord;
  R.DX := TCastDWord(Vector).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  VDPMISetRealIntrVector := 0;

END;

{}

Function  VDPMIGetProcExpVector(       ExpNum         : BYTE;
                                   Var Vector         : PVectHandle ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0202;
  R.BL := ExpNum;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetProcExpVector := R.AX;

  END
  Else
  BEGIN

    TCastDWord(Vector).HighWord := R.CX;
    TCastDWord(Vector).LowWord  := R.DX;
    VDPMIGetProcExpVector       := 0;

  END;

END;

{}

Function  VDPMISetProcExpVector(       ExpNum         : BYTE;
                                       Vector         : PVectHandle ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0203;
  R.BL := ExpNum;

  R.CX := TCastDWord(Vector).HighWord;
  R.DX := TCastDWord(Vector).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISetProcExpVector := R.AX;

  END
  Else
  BEGIN

    VDPMISetProcExpVector := 0;

  END;

END;

{}

Function  VDPMIGetProtIntrVector(      IntNum         : WORD;
                                   Var Vector         : PVectHandle ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0204;
  R.BL := IntNum;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  TCastDWord(Vector).HighWord := R.CX;
  TCastDWord(Vector).LowWord  := R.DX;

  VDPMIGetProtIntrVector := 0;

END;

{}

Function  VDPMISetProtIntrVector(      IntNum         : WORD;
                                       Vector         : PVectHandle ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0205;
  R.BL := IntNum;

  R.CX := TCastDWord(Vector).HighWord;
  R.DX := TCastDWord(Vector).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISetProtIntrVector := R.AX;

  END
  Else
  BEGIN

    VDPMISetProtIntrVector := 0;

  END;

END;

{}

Function  VDPMIGetProtExtExpProc(      ExpNum         : BYTE;
                                   Var Handler        : PVectHandle ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0210;
  R.BL := ExpNum;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetProtExtExpProc       := R.AX;

  END
  Else
  BEGIN

    TCastDWord(Handler).HighWord := R.CX;
    TCastDWord(Handler).LowWord  := R.DX; { !^! should be EDX }
    VDPMIGetProtExtExpProc       := 0;

  END;

END;

{}

Function  VDPMIGetRealExtExpProc(      ExpNum         : BYTE;
                                   Var Handler        : PVectHandle ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0211;
  R.BL := ExpNum;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetRealExtExpProc       := R.AX;

  END
  Else
  BEGIN

    TCastDWord(Handler).HighWord := R.CX;
    TCastDWord(Handler).LowWord  := R.DX; { !^! should be EDX }
    VDPMIGetRealExtExpProc       := 0;

  END;

END;

{}

Function  VDPMISetProtExtExpProc(      ExpFaultNum    : BYTE;
                                   Var Handler        : PVectHandle ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0212;
  R.BL := ExpFaultNum;

  R.CX := TCastDWord(Handler).HighWord;
  R.DX := TCastDWord(Handler).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISetProtExtExpProc := R.AX;

  END
  Else
  BEGIN

    VDPMISetProtExtExpProc := 0;

  END;

END;

{}

Function  VDPMISetRealExtExpProc(      ExpFaultNum    : BYTE;
                                   Var Handler        : PVectHandle ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0213;
  R.BL := ExpFaultNum;

  R.CX := TCastDWord(Handler).HighWord;
  R.DX := TCastDWord(Handler).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISetRealExtExpProc := R.AX;

  END
  Else
  BEGIN

    VDPMISetRealExtExpProc := 0;

  END;

END;

{}

Function  VDPMISimRealIntr(            IntrNum        : WORD;
                                       Flags          : WORD;
                                       StackCopy      : WORD;
                                       RealRegs       : PDPMIRealRegs) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0300;
  R.BL := IntrNum;
  R.BH := Flags;
  R.CX := StackCopy;

  R.ES := TCastDWord(RealRegs).HighWord;
  R.DI := TCastDWord(RealRegs).LowWord;

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISimRealIntr := R.AX;

  END
  Else
  BEGIN

    VDPMISimRealIntr := 0;

  END;

END;

{}

Function  VDPMICallRealProc(           Flags          : WORD;
                                       StackCopy      : WORD;
                                       RealRegs       : PDPMIRealRegs) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0301;
  R.BH := Flags;
  R.CX := StackCopy;

  R.ES := TCastDWord(RealRegs).HighWord;
  R.DI := TCastDWord(RealRegs).LowWord;

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMICallRealProc := R.AX;

  END
  Else
  BEGIN

    VDPMICallRealProc := 0;

  END;

END;

{}

Function  VDPMICallRealIntrProc(       Flags          : WORD;
                                       StackCopy      : WORD;
                                       RealRegs       : PDPMIRealRegs) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0302;
  R.BH := Flags;
  R.CX := StackCopy;

  R.ES := TCastDWord(RealRegs).HighWord;
  R.DI := TCastDWord(RealRegs).LowWord;

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMICallRealIntrProc := R.AX;

  END
  Else
  BEGIN

    VDPMICallRealIntrProc := 0;

  END;

END;

{}

Function  VDPMIAllocRealCallback(      ProtProc       : PSelOfs;
                                       RealRegBuff    : PDPMIRealRegs;
                                   Var CallBackAddr   : POINTER ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0303;

  R.DS := TCastDWord(CallBackAddr).HighWord;
  R.SI := TCastDWord(CallBackAddr).LowWord;

  R.ES := TCastDWord(RealRegBuff).HighWord;
  R.DI := TCastDWord(RealRegBuff).LowWord;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIAllocRealCallback := R.AX;

  END
  Else
  BEGIN

    VDPMIAllocRealCallback := 0;

  END;

END;

{}

Function  VDPMIFreeRealCallback(       CallBackAddr   : POINTER ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0304;

  R.CX := TCastDWord(CallBackAddr).HighWord;
  R.DX := TCastDWord(CallBackAddr).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIFreeRealCallback := R.AX;

  END
  Else
  BEGIN

    VDPMIFreeRealCallback := 0;

  END;

END;

{}

Function  VDPMIGetStateSRProcs(    Var StateBuffSize  : WORD;
                                   Var RealModeAddr   : POINTER;
                                   Var ProtModeAddr   : POINTER ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0305;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  StateBuffSize := R.AX;
  TCastDWord(RealModeAddr).HighWord := R.CX;
  TCastDWord(RealModeAddr).LowWord  := R.DX;
  TCastDWord(ProtModeAddr).HighWord := R.SI;
  TCastDWord(ProtModeAddr).LowWord  := R.DI;

  VDPMIGetStateSRProcs := 0;

END;

{}

Function  VDPMIGetRawSwitchProcs(  Var RealToProtAddr : POINTER;
                                   Var ProtToRealAddr : POINTER ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0306;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  TCastDWord(RealToProtAddr).HighWord := R.CX;
  TCastDWord(RealToProtAddr).LowWord  := R.DX;
  TCastDWord(ProtToRealAddr).HighWord := R.SI;
  TCastDWord(ProtToRealAddr).LowWord  := R.DI;

  VDPMIGetRawSwitchProcs := 0;

END;

{}

Function  VDPMIGetVersion(         Var MajorVer       : BYTE;
                                   Var MinorVer       : BYTE;
                                   Var Flags          : WORD;
                                   Var ProcType       : BYTE;
                                   Var VirtMastPIC    : BYTE;
                                   Var VirtSlavePIC   : BYTE    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0400;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  MajorVer     := R.AH;
  MinorVer     := R.AL;
  Flags        := R.BX;
  ProcType     := R.CL;
  VirtMastPIC  := R.DH;
  VirtSlavePIC := R.DL;

  VDPMIGetVersion := 0;

END;

{}

Function  VDPMIGetCaps(                InfoBuffer     : PGetCapsBuff;
                                   Var CaoFlags       : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0401;

  R.ES := TCastDWord(InfoBuffer).HighWord;
  R.DI := TCastDWord(InfoBuffer).LowWord;

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetCaps := R.AX;

  END
  Else
  BEGIN

    CaoFlags     := R.AX;
    VDPMIGetCaps := 0;

  END;

END;

{}

Function  VDPMIGetFreeMemory(          InfoBuffer     : PFreeMemInfo ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0500;

  R.ES := TCastDWord(InfoBuffer).HighWord;
  R.DI := TCastDWord(InfoBuffer).LowWord;

  R.DS := 0;

  Intr( $31, R );

  VDPMIGetFreeMemory := 0;

END;

{}

Function  VDPMIAllocMemory(            Size           : LONGINT;
                                   Var LinAddr        : LONGINT;
                                   Var MemHandle      : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0501;

  R.BX := TCastDWord(Size).HighWord;
  R.CX := TCastDWord(Size).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIAllocMemory := R.AX;

  END
  Else
  BEGIN

    TCastDWord(LinAddr).HighWord   := R.BX;
    TCastDWord(LinAddr).LowWord    := R.CX;
    TCastDWord(MemHandle).HighWord := R.SI;
    TCastDWord(MemHandle).LowWord  := R.DI;

    VDPMIAllocMemory := 0;

  END;

END;

{}

Function  VDPMIFreeMemory(             MemHandle      : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0502;

  R.SI := TCastDWord(MemHandle).HighWord;
  R.DI := TCastDWord(MemHandle).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIFreeMemory := R.AX;

  END
  Else
  BEGIN

    VDPMIFreeMemory := 0;

  END;

END;

{}

Function  VDPMIResizeMemory(           MemHandle      : LONGINT;
                                       NewSize        : LONGINT;
                                   Var NewMemHandle   : LONGINT;
                                   Var NewLinAddr     : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0503;

  R.BX := TCastDWord(NewSize).HighWord;
  R.CX := TCastDWord(NewSize).LowWord;
  R.SI := TCastDWord(MemHandle).HighWord;
  R.DI := TCastDWord(MemHandle).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIResizeMemory := R.AX;

  END
  Else
  BEGIN

    TCastDWord(NewLinAddr).HighWord   := R.BX;
    TCastDWord(NewLinAddr).LowWord    := R.CX;
    TCastDWord(NewMemHandle).HighWord := R.SI;
    TCastDWord(NewMemHandle).LowWord  := R.DI;

    VDPMIResizeMemory := 0;

  END;

END;

{}

Function  VDPMIAllocLinMemory(         LinAddr        : LONGINT;
                                       Size           : LONGINT;
                                       Flags          : LONGINT;
                                   Var NewLinAddr     : LONGINT;
                                   Var MemHandle      : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0504;

  R.BX := TCastDWord(LinAddr).HighWord; { !^! R.EBX := LinAddr; }
  R.CX := TCastDWord(Size).HighWord;    { !^! R.ECX := Size;    }
  R.DX := TCastDWord(Flags).HighWord;   { !^! R.EDX := Flags;   }

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIAllocLinMemory := R.AX;

  END
  Else
  BEGIN

    TCastDWord(NewLinAddr).HighWord := R.BX; { !^! NewLinAddr := R.EBX; }
    TCastDWord(MemHandle).HighWord  := R.SI; { !^! MemHandle  := R.ESI; }

    VDPMIAllocLinMemory := 0;

  END;

END;

{}

Function  VDPMIResizeLinMemory(        MemHandle      : LONGINT;
                                       NewSize        : LONGINT;
                                       NewFlags       : LONGINT;
                                   Var NewLinAddr     : LONGINT;
                                   Var NewMemHandle   : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0505;

  R.SI := TCastDWord(MemHandle).Highword; { !^! R.ESI := MemHandle; }
  R.CX := TCastDWord(NewSize).HighWord;   { !^! R.ECX := NewSize;   }
  R.DX := TCastDWord(NewFlags).HighWord;  { !^! R.EDX := NewFlags;  }

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIResizeLinMemory := R.AX;

  END
  Else
  BEGIN

    TCastDWord(NewLinAddr).HighWord := R.BX;    { !^! NewLinAddr := R.EBX; }
    TCastDWord(NewMemHandle).HighWord  := R.SI; { !^! NewMemHandle  := R.ESI; }

    VDPMIResizeLinMemory := 0;

  END;

END;

{}

Function  VDPMIGetPageAttrs(           MemHandle      : LONGINT;
                                       BasePageOfs    : LONGINT;
                                       NumPages       : LONGINT;
                                   Var PageAttrArr    : PPageAttr ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0506;

  R.SI := TCastDWord(MemHandle).Highword;   { !^! R.ESI := MemHandle; }
  R.BX := TCastDWord(BasePageOfs).Highword; { !^! R.EBX := BasePageOfs; }
  R.CX := TCastDWord(NumPages).Highword;    { !^! R.ECX := NumPages; }
  R.ES := TCastDWord(PageAttrArr).Highword;
  R.DX := TCastDWord(PageAttrArr).Lowword;  { !^! R.EDX ... }

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetPageAttrs := R.AX;

  END
  Else
  BEGIN

    VDPMIGetPageAttrs := 0;

  END;

END;

{}

Function  VDPMIModifyPageAttrs(        MemHandle      : LONGINT;
                                       BasePageOfs    : LONGINT;
                                       NumPages       : LONGINT;
                                       PageAttrArr    : PPageAttr;
                                   Var NewNumPages    : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0507;

  R.SI := TCastDWord(MemHandle).Highword;   { !^! R.ESI := MemHandle; }
  R.BX := TCastDWord(BasePageOfs).Highword; { !^! R.EBX := BasePageOfs; }
  R.CX := TCastDWord(NumPages).Highword;    { !^! R.ECX := NumPages; }
  R.ES := TCastDWord(PageAttrArr).Highword;
  R.DX := TCastDWord(PageAttrArr).Lowword;  { !^! R.EDX ... }

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIModifyPageAttrs := R.AX;

  END
  Else
  BEGIN

    TCastDWord(NewNumPages).Highword := R.CX; { !^! NewNumPages := R.ECX; }
    VDPMIModifyPageAttrs := 0;

  END;

END;

{}

Function  VDPMIMapDeviceMemory(        MemHandle      : LONGINT;
                                       PageOfs        : LONGINT;
                                       NumPages       : LONGINT;
                                       PhyDevAddr     : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0508;

  R.SI := TCastDWord(MemHandle).Highword;  { !^! R.ESI := MemHandle; }
  R.BX := TCastDWord(PageOfs).Highword;    { !^! R.EBX := PageOfs; }
  R.CX := TCastDWord(NumPages).Highword;   { !^! R.ECX := NumPages; }
  R.DX := TCastDWord(PhyDevAddr).Lowword;  { !^! R.EDX := PhyDevAddr; }

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIMapDeviceMemory := R.AX;

  END
  Else
  BEGIN

    VDPMIMapDeviceMemory := 0;

  END;

END;

{}

Function  VDPMIMapConvMemory(          MemHandle      : LONGINT;
                                       PageOfs        : LONGINT;
                                       NumPages       : LONGINT;
                                       LinConvMemAddr : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0509;

  R.SI := TCastDWord(MemHandle).Highword;     { !^! R.ESI := MemHandle; }
  R.BX := TCastDWord(PageOfs).Highword;       { !^! R.EBX := PageOfs; }
  R.CX := TCastDWord(NumPages).Highword;      { !^! R.ECX := NumPages; }
  R.DX := TCastDWord(LinConvMemAddr).Lowword; { !^! R.EDX := LinConvMemAddr; }

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIMapConvMemory := R.AX;

  END
  Else
  BEGIN

    VDPMIMapConvMemory := 0;

  END;

END;

{}

Function  VDPMIGetMemorySizeBase(      MemHandle      : LONGINT;
                                   Var Size           : LONGINT;
                                   Var BaseAddr       : POINTER ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $050A;

  R.SI := TCastDWord(MemHandle).HighWord;
  R.DI := TCastDWord(MemHandle).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetMemorySizeBase := R.AX;

  END
  Else
  BEGIN

    TCastDWord(Size).HighWord     := R.SI;
    TCastDWord(Size).LowWord      := R.DI;
    TCastDWord(BaseAddr).HighWord := R.BX;
    TCastDWord(BaseAddr).LowWord  := R.CX;

    VDPMIGetMemorySizeBase := 0;

  END;

END;

{}

Function  VDPMIGetMemoryInfo(          MemInfo        : PMemInfo) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $050B;

  R.ES := TCastDWord(MemInfo).HighWord;
  R.DI := TCastDWord(MemInfo).LowWord;

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
    VDPMIGetMemoryInfo := R.AX
  Else
    VDPMIGetMemoryInfo := 0;

END;

{}

Function  VDPMILockLinRegion(          LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0600;
  R.BX := TCastDWord(LinearStart).HighWord;
  R.CX := TCastDWord(LinearStart).LowWord;
  R.SI := TCastDWord(Size).HighWord;
  R.DI := TCastDWord(Size).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMILockLinRegion := R.AX;

  END
  Else
  BEGIN

    VDPMILockLinRegion := 0;

  END;

END;

{}

Function  VDPMIUnlockLinRegion(        LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0601;
  R.BX := TCastDWord(LinearStart).HighWord;
  R.CX := TCastDWord(LinearStart).LowWord;
  R.SI := TCastDWord(Size).HighWord;
  R.DI := TCastDWord(Size).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIUnlockLinRegion := R.AX;

  END
  Else
  BEGIN

    VDPMIUnlockLinRegion := 0;

  END;

END;

{}

Function  VDPMIMarkRealRegionPageable( LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0602;

  R.BX := TCastDWord(LinearStart).HighWord;
  R.CX := TCastDWord(LinearStart).LowWord;
  R.SI := TCastDWord(Size).HighWord;
  R.DI := TCastDWord(Size).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIMarkRealRegionPageable := R.AX;

  END
  Else
  BEGIN

    VDPMIMarkRealRegionPageable := 0;

  END;

END;

{}

Function  VDPMIRelockRealRegion(       LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0603;

  R.BX := TCastDWord(LinearStart).HighWord;
  R.CX := TCastDWord(LinearStart).LowWord;
  R.SI := TCastDWord(Size).HighWord;
  R.DI := TCastDWord(Size).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIRelockRealRegion := R.AX;

  END
  Else
  BEGIN

    VDPMIRelockRealRegion := 0;

  END;

END;

{}

Function  VDPMIGetPageSize(        Var PageSize       : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0604;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetPageSize := R.AX;

  END
  Else
  BEGIN

    TCastDWord(PageSize).HighWord := R.BX;
    TCastDWord(PageSize).LowWord  := R.CX;
    VDPMIGetPageSize              := 0;

  END;

END;

{}

Function  VDPMIMarkPagesCandidate(     LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0700;

  R.BX := TCastDWord(LinearStart).HighWord;
  R.CX := TCastDWord(LinearStart).LowWord;
  R.SI := TCastDWord(Size).HighWord;
  R.DI := TCastDWord(Size).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIMarkPagesCandidate := R.AX;

  END
  Else
  BEGIN

    VDPMIMarkPagesCandidate := 0;

  END;

END;

{}

Function  VDPMIDiscardPages(           LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0701;

  R.BX := TCastDWord(LinearStart).HighWord;
  R.CX := TCastDWord(LinearStart).LowWord;
  R.SI := TCastDWord(Size).HighWord;
  R.DI := TCastDWord(Size).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIDiscardPages := R.AX;

  END
  Else
  BEGIN

    VDPMIDiscardPages := 0;

  END;

END;

{}

Function  VDPMINominatePages(          LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0702;

  R.BX := TCastDWord(LinearStart).HighWord;
  R.CX := TCastDWord(LinearStart).LowWord;
  R.SI := TCastDWord(Size).HighWord;
  R.DI := TCastDWord(Size).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMINominatePages := R.AX;

  END
  Else
  BEGIN

    VDPMINominatePages := 0;

  END;

END;

{}

Function  VDPMIDiscardPageContents(    LinearStart    : LONGINT;
                                       Size           : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0703;

  R.BX := TCastDWord(LinearStart).HighWord;
  R.CX := TCastDWord(LinearStart).LowWord;
  R.SI := TCastDWord(Size).HighWord;
  R.DI := TCastDWord(Size).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIDiscardPageContents := R.AX;

  END
  Else
  BEGIN

    VDPMIDiscardPageContents := 0;

  END;

END;

{}

Function  VDPMIMapPhysicalRegion(      PhysStart      : LONGINT;
                                       Size           : LONGINT;
                                   Var LinAddr        : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0800;

  R.BX := TCastDWord(PhysStart).HighWord;
  R.CX := TCastDWord(PhysStart).LowWord;
  R.SI := TCastDWord(Size).HighWord;
  R.DI := TCastDWord(Size).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIMapPhysicalRegion       := R.AX;

  END
  Else
  BEGIN

    TCastDWord(LinAddr).HighWord := R.BX;
    TCastDWord(LinAddr).LowWord  := R.CX;
    VDPMIMapPhysicalRegion       := 0;

  END;

END;

{}

Function  VDPMIFreePhysicalRegion(     LinAddr        : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0801;

  R.BX := TCastDWord(LinAddr).HighWord;
  R.CX := TCastDWord(LinAddr).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIFreePhysicalRegion := R.AX;

  END
  Else
  BEGIN

    VDPMIFreePhysicalRegion := 0;

  END;

END;

{}

Function  VDPMITestDisableInts(    Var PrevState      : BYTE    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0900;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  PrevState := R.AL;

  VDPMITestDisableInts := 0;

END;

{}

Function  VDPMITestEnableInts(     Var PrevState      : BYTE    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0901;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  PrevState := R.AL;

  VDPMITestEnableInts := 0;

END;

{}

Function  VDPMITestInts(           Var State          : BYTE    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0902;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  State := R.AL;

  VDPMITestInts := 0;

END;

{}

Function  VDPMIGetVendorAPIEntry(      VendorName     : STRING;
                                   Var APIEntry       : POINTER ) : TDPMIErr;

Type

  TChar = Array[1..1] of CHAR;
  PChar = ^TChar;

Var

  R     : TREGISTERS;
  PStr1 : PChar;

BEGIN

  R.AX := $0A00;

  GetMem(PStr1, SizeOf(VendorName[0]));

  Move(VendorName[1], PStr1, Byte(VendorName[0]));
  PStr1^[Byte(VendorName[0])+1] := #0;           {!^! 0 or #0?}

  R.DS := TCastDWord(PStr1).HighWord;
  R.SI := TCastDWord(PStr1).LowWord;

  R.ES := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetVendorAPIEntry := R.AX;

  END
  Else
  BEGIN

    TCastDWord(APIEntry).HighWord := R.ES;
    TCastDWord(APIEntry).LowWord  := R.DI;

    VDPMIGetVendorAPIEntry := 0;

  END;

  FreeMem(PStr1, SizeOf(VendorName[0]));

END;

{}

Function  VDPMISetDebugWatchp(         LinAddr        : LONGINT;
                                       WatchSize      : BYTE;
                                       WatchType      : BYTE;
                                   Var WatchHandle    : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0B00;

  R.BX := TCastDWord(LinAddr).HighWord;
  R.CX := TCastDWord(LinAddr).LowWord;
  R.DL := WatchSize;
  R.DH := WatchType;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISetDebugWatchp := R.AX;

  END
  Else
  BEGIN

    WatchHandle         := R.BX;
    VDPMISetDebugWatchp := 0;

  END;

END;

{}

Function  VDPMIClearDebugWatchp(       WatchHandle    : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0B01;
  R.BX := WatchHandle;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIClearDebugWatchp := R.AX;

  END
  Else
  BEGIN

    VDPMIClearDebugWatchp := 0;

  END;

END;

{}

Function  VDPMIGetDebugWatchpState(    WatchHandle    : WORD;
                                   Var WatchState     : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0B02;
  R.BX := WatchHandle;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIGetDebugWatchpState := R.AX;

  END
  Else
  BEGIN

    WatchState               := R.AX;
    VDPMIGetDebugWatchpState := 0;

  END;

END;

{}

Function  VDPMIResetDebugWatchp(       WatchHandle    : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0B03;
  R.BX := WatchHandle;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIResetDebugWatchp := R.AX;

  END
  Else
  BEGIN

    VDPMIResetDebugWatchp := 0;

  END;

END;

{}

Function  VDPMIInstallRSPCallback(     RSPBuff        : PRSPBuff) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0C00;

  R.ES := TCastDWord(RSPBuff).HighWord;
  R.DI := TCastDWord(RSPBuff).LowWord;

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIInstallRSPCallback := R.AX;

  END
  Else
  BEGIN

    VDPMIInstallRSPCallback := 0;

  END;

END;

{}

Function  VDPMITermAndStayResident(    RetCode        : BYTE;
                                       DosParasToKeep : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0C01;

  R.BL := RetCode;
  R.DX := DosParasToKeep;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  VDPMITermAndStayResident := 0;

END;

{}

Function  VDPMIAllocSharedMemory(      MemReqStruct   : PMemReqStruct ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0D00;

  R.ES := TCastDWord(MemReqStruct).HighWord;
  R.DI := TCastDWord(MemReqStruct).LowWord;

  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIAllocSharedMemory := R.AX;

  END
  Else
  BEGIN

    VDPMIAllocSharedMemory := 0;

  END;

END;

{}

Function  VDPMIFreeSharedMemory(       SMemHandle     : LONGINT ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0D01;

  R.SI := TCastDWord(SMemHandle).HighWord;
  R.DI := TCastDWord(SMemHandle).LowWord;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIFreeSharedMemory := R.AX;

  END
  Else
  BEGIN

    VDPMIFreeSharedMemory := 0;

  END;

END;

{}

Function  VDPMISerOnSharedMem(         SMemHandle     : LONGINT;
                                       Flags          : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0D02;

  R.SI := TCastDWord(SMemHandle).HighWord;
  R.DI := TCastDWord(SMemHandle).LowWord;
  R.DX := Flags;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISerOnSharedMem := R.AX;

  END
  Else
  BEGIN

    VDPMISerOnSharedMem := 0;

  END;

END;

{}

Function  VDPMIFreeSerOnSharedMem(     SMemHandle     : LONGINT;
                                       Flags          : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0D03;

  R.SI := TCastDWord(SMemHandle).HighWord;
  R.DI := TCastDWord(SMemHandle).LowWord;
  R.DX := Flags;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMIFreeSerOnSharedMem := R.AX;

  END
  Else
  BEGIN

    VDPMIFreeSerOnSharedMem := 0;

  END;

END;

{}

Function  VDPMIGetCoprocStatus                                    : WORD;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0E00;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  VDPMIGetCoprocStatus := R.AX;

END;

{}

Function  VDPMISetCoProcEmulation(     EmuFlags       : WORD    ) : TDPMIErr;

Var

  R : TREGISTERS;

BEGIN

  R.AX := $0E01;
  R.BX := EmuFlags;

  R.ES := 0;
  R.DS := 0;

  Intr( $31, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VDPMISetCoProcEmulation := R.AX;

  END
  Else
  BEGIN

    VDPMISetCoProcEmulation := 0;

  END;

END;

{}

Function  RealIntr(                    IntNum         : BYTE;
                                       R              : TREGISTERS ):WORD;

Var

  RR : TDPMIRealRegs;

BEGIN

  RR.EDI   := R.DI;
  RR.ESI   := R.SI;
  RR.EBP   := R.BP;
  RR.EBX   := R.BX;
  RR.EDX   := R.DX;
  RR.ECX   := R.CX;
  RR.EAX   := R.AX;
  RR.Flags := R.Flags;
  RR.ES    := R.ES;
  RR.DS    := R.DS;
  RR.FS    := 0;
  RR.GS    := 0;

  RR.SS    := 0;
  RR.SP    := 0;


  VDPMISimRealIntr( IntNum, 0, 0, @RR );


  R.DI     := Word( RR.EDI );
  R.SI     := Word( RR.ESI );
  R.BP     := Word( RR.EBP );
  R.BX     := Word( RR.EBX );
  R.DX     := Word( RR.EDX );
  R.CX     := Word( RR.ECX );
  R.AX     := Word( RR.EAX );
  R.Flags  := RR.Flags;
  R.ES     := RR.ES;
  R.DS     := RR.DS;


END;

{}

Procedure RefBuffCopyUp(               BuffPtr        : POINTER;
                                       RBProt         : POINTER;
                                       BuffSize       : LONGINT   );

BEGIN

  Move( RBProt^, BuffPtr^, BuffSize );

END;

{}

Procedure RefBuffCopyDown(             BuffPtr        : POINTER;
                                       RBProt         : POINTER;
                                       BuffSize       : LONGINT   );


BEGIN

  Move( BuffPtr^, RBProt^, BuffSize );

END;

{}


Function  RefBuffNew(                  Flags          : WORD;
                                       BuffPtr        : POINTER;
                                       BuffSize       : LONGINT;
                                   Var RBReal         : POINTER;
                                   Var RBProt         : POINTER    ) : WORD;




Var

  Err        : WORD;
  RBRealSeg  : WORD;
  RBProtSel  : WORD;

BEGIN

  {----------------------------}
  { Allocate reflection buffer }
  {----------------------------}

  Err := VDPMIAllocDOSMemory  ( ( BuffSize Div 16)+1,
                                RBRealSeg,
                                RBProtSel               );

  If Err=0 Then
  BEGIN


    RBProt := Ptr( RBProtSel, 0 );

    RBReal := Ptr( RBRealSeg, 0 );

    {--------------------------------}
    { if copy "down" then move bytes }
    { to reflection buff             }
    {--------------------------------}

    If (Flags and rb_down)<>0 Then
    BEGIN

      Move( BuffPtr^,
            RBProt^,
            BuffSize            );

    END;

  END   { if err=0 (alloc ref buff) }
  ELSE
  BEGIN

  END; { if err=0 (alloc ref buff) }

  RefBuffNew := Err;

END;

{}

Procedure RefBuffDispose(              RBProt         : POINTER    );


Var

  Err : WORD;

BEGIN

  Err := VDPMIFreeDosMemory( TCastDWord( RBProt ).HighWord );

END;


{}

Function  RefBuffIntr(                 Flags          : WORD;
                                       IntNum         : BYTE;
                                       R              : TREGISTERS;
                                       BuffPtr        : POINTER;
                                       BuffSize       : LONGINT ) : TDPMIErr;

{---------------------------------------------------------------------------
  $0001  rb_ESBX    ES:BX points to buff
  $0002  rb_ESSI    ES:SI points to buff
  $0003  rb_ESDI    ES:DI points to buff

  $0004  rb_DSBX    DS:BX points to buff
  $0005  rb_DSSI    DS:SI points to buff
  $0006  rb_DSDI    DS:DI points to buff

  $0100  rb_down    Copy the reflected buffer down to real mode
  $0200  rb_up      Copy the reflected buffer up from real mode
  $0300  rb_downup  Copy the reflected buffer down to real mode and back up
  $0300  rb_updown  Copy the reflected buffer down to real mode and back up
----------------------------------------------------------------------------}

Var

  Err        : WORD;
  RBRealSeg  : WORD;
  RBProtSel  : WORD;

  RBProt     : POINTER;
  RBReal     : POINTER;

BEGIN

{$IFNDEF DPMI}

  Intr( IntNum, R );

{$ELSE}

  {----------------------------}
  { Allocate reflection buffer }
  { and do the copy down       }
  {----------------------------}

  Err := RefBuffNew( Flags,
                     BuffPtr,
                     BuffSize,
                     RBReal,
                     RBProt       );

  If Err=0 Then
  BEGIN

    RBRealSeg := TCastDWord( RBReal ).HighWord;

    {-------------------------------}
    { modify TREGISTERS to point to }
    { reflecion buffer              }
    {-------------------------------}

    Case (Flags and $00FF) Of

      rb_ESAX : BEGIN R.ES := RBRealSeg;  R.AX := 0; END;
      rb_ESBX : BEGIN R.ES := RBRealSeg;  R.BX := 0; END;
      rb_ESCX : BEGIN R.ES := RBRealSeg;  R.CX := 0; END;
      rb_ESDX : BEGIN R.ES := RBRealSeg;  R.DX := 0; END;
      rb_ESSI : BEGIN R.ES := RBRealSeg;  R.SI := 0; END;
      rb_ESDI : BEGIN R.ES := RBRealSeg;  R.DI := 0; END;
      rb_ESBP : BEGIN R.ES := RBRealSeg;  R.BP := 0; END;

      rb_DSAX : BEGIN R.DS := RBRealSeg;  R.AX := 0; END;
      rb_DSBX : BEGIN R.DS := RBRealSeg;  R.BX := 0; END;
      rb_DSCX : BEGIN R.DS := RBRealSeg;  R.CX := 0; END;
      rb_DSDX : BEGIN R.DS := RBRealSeg;  R.DX := 0; END;
      rb_DSSI : BEGIN R.DS := RBRealSeg;  R.SI := 0; END;
      rb_DSDI : BEGIN R.DS := RBRealSeg;  R.DI := 0; END;
      rb_DSBP : BEGIN R.DS := RBRealSeg;  R.BP := 0; END;

    END;

    {-------------------}
    { perform interrupt }
    {-------------------}

    RealIntr( IntNum, R );

    {--------------------------------}
    { if copy "up" then move bytes   }
    { from reflection buff           }
    {--------------------------------}

    If (Flags and rb_up)<>0 Then
    BEGIN

      RefBuffCopyUp( BuffPtr,
                     RBProt,
                     BuffSize       );

    END;

    {------------------------}
    { free reflection buffer }
    {------------------------}

    RefBuffDispose( RBProt );

  END   { if err=0 (alloc ref buff) }
  ELSE
  BEGIN


  END; { if err=0 (alloc ref buff) }


{$endif} {if DPMI / ELSE }

END;

{}

(*
Function VDPMIPermReflectBuffNew( Size           : LONGINT ) : WORD;

Var

  ERR       : WORD;
  RBRealSeg : WORD;
  RBProtSel : WORD;

BEGIN

  {---------------------------------------------------}
  { if the buffer is already allocated, dispose of it }
  {---------------------------------------------------}

  If PermReflectBuff.Allocated Then
    Err := VDPMIPermReflectBuffDispose;


  {--------------------------------}
  { get the DOS (below 1mb) memory }
  {--------------------------------}

  Err := VDPMIAllocDosMemBlock( (Size Div 16)+1,
                                RBRealSeg,
                                RBProtSel               );

  IF Err=0 Then
  BEGIN

    With PermReflectBuff Do
    BEGIN


      {---------------------------------------}
      { while interrupts are off, fill in the }
      { PermReflectBuff structure             }
      {---------------------------------------}

      ASM CLI END;

      Allocated := TRUE;
      InUse     := FALSE;
      RealPtr   := Ptr( RBRealSeg, 0 );
      ProtPtr   := Ptr( RBProtSel, 0 );
      BuffSize  := Size;


      ASM STI END;

    END; { with }

  END; { If err=0 }

  VDPMIPermReflectBuffNew := Err;

END;

{}

Function VDPMIPermReflectBuffDispose : WORD;

BEGIN

  Err := 0;

  With PermReflectBuff Do
  BEGIN

    {------------------------------}
    { has a buffer been allocated? }
    {------------------------------}

    If Allocated = TRUE Then
    BEGIN

      {---------------------------------}
      { make sure some async  procedure }
      { isnt using the buffer           }
      {---------------------------------}

      Repeat Until InUse=FALSE;

      ASM CLI END;

      Allocated := FALSE;

      ASM STI END;

      Err := VDPMIFreeDosMemBlock( Seg( ProtPtr^ ) );

    END;

  END;

  VDPMIPermReflectBuffDispose := Err;

END;

*)


{}
{}
{}

BEGIN

  PermReflectBuff.Allocated := FALSE;

END.
