{
 

 Visionix Expanded Memory Services Unit (VEMS)
   Version 0.7
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 mep       03/30/93  Moved EMS 4.0/3.2 code from VMemLow as replacement

 lpg       03/15/93  Added Source Documentation

 mep       02/11/93  Cleaned up code for beta release

 jrt       02/08/93  Sync with beta 0.12 release

 jrt       12/07/92  Sync with beta 0.11 release

 jrt       11/21/92  Sync with beta 0.08

 jrt       11/18/92  First logged revision.

 

}

(*-

[TEXT]

<Overview>

This unit implements a function for all commands in the EMS
specification.

The documentation for this unit will be enhanced in the next release.

<Interface>

-*)


Unit VEMSu;

Interface

Uses

  VTypesu,
  DOS;

{}

Type

  TEMSError  = BYTE;

  {-----------------------------}

  TEMSHandle = WORD;
  PEMSHandle = ^TEMSHandle;

  {-----------------------------}

  TEMMHandle = WORD;
  PEMMHandle = ^TEMMHandle;

  {-----------------------------}

  TEMSMapArr = RECORD

    LogicPage    : WORD;  { $FFFF = unmap physical pg }
    PhysicalPage : WORD;  { segment address }

  END;
  PEMSMapArr = ^TEMSMapArr;

  {-----------------------------}

  TEMSHandleName = Array[1..8] of BYTE;
  PEMSHandleName = ^TEMSHandleName;

  {-----------------------------}

  TEMSHandleDir = RECORD

    Handle     : WORD;
    HandleName : TEMSHandleName;

  END;
  PEMSHandleDir = ^TEMSHandleDir;

  {-----------------------------}

  TEMSMapAddr = RECORD

  END;
  PEMSMapAddr = ^TEMSMapAddr;

  {-----------------------------}

  TEMSCopyData = RECORD

    RegionLen       : LONGINT;
    SourceMemType   : BYTE;     { 0 = conventional, 1 = expanded }
    SourceHandle    : WORD;     { 0 if conventional memory       }
    SourceInitOfs   : WORD;     { within page if EMS,            }
                                { within segment if conventional }
    SourceInitSegPg : WORD;     { segment if conventional memory,}
                                { logical page if EMS            }
    DestMemType     : BYTE;     { 0 = conventional, 1 = expanded }
    DestHandle      : WORD;
    DestInitOfs     : WORD;
    DestInitSegPg   : WORD;

  END;
  PEMSCopyData = ^TEMSCopyData;

  {-----------------------------}

  TEMSMapPhyAddr = RECORD

    PhysicalPgSeg : WORD;
    PhysicalPgNum : WORD;

  END;
  PEMSMapPhyAddr = ^TEMSMapPhyAddr;

  {-----------------------------}

  TEMSHardwareCfgArr = RECORD

    SizeRawEMMPg       : WORD;  { in paragraphs }
    NumAlternRegSet    : WORD;
    SizeSaveMapContext : WORD;  { in bytes }
    NumRegSetAssignDMA : WORD;
    DMAOperationType   : WORD;  { 0 = DMA w/alternate register sets,  }
                                { 1 = only one DMA register set       }

  END;
  PEMSHardwareCfgArr = ^TEMSHardwareCfgArr;

{}

{----------}
{ EMS 3.2+ }
{----------}

Function  VEMSErrorToStr(             Status       : TEMSError  ) : STRING;

Function  VEMSInstalled                            : BOOLEAN;

Function  VEMSGetManagerStatus                     : TEMSError;

Function  VEMSGetPgFrameStatus(   Var PgFrameSeg   : WORD       ) : TEMSError;

Function  VEMSGetFreePg(          Var UnallocPg    : WORD;
                                  Var TotalPg      : WORD       ) : TEMSError;

Function  VEMSNewHandle(              LogicalPg    : WORD;
                                  Var EMSHandle    : TEMSHandle ) : TEMSError;

Function  VEMSMapMemory(              EMSHandle    : TEMSHandle;
                                      PhysicalPg   : BYTE;
                                      LogicalPg    : WORD       ) : TEMSError;

Function  VEMSDisposeHandle(          EMMHandle    : TEMMHandle ) : TEMSError;

Function  VEMMGetVersion(         Var EMMVersion   : BYTE       ) : TEMSError;

Function  VEMSSaveMapContext(         EMSHandle    : TEMSHandle ) : TEMSError;

Function  VEMSRestoreMapContext(      EMSHandle    : TEMSHandle ) : TEMSError;

Function  VEMMGetNumHandles(      Var NumHandles   : WORD       ) : TEMSError;

Function  VEMSPgsOwnedByHandle(       EMMHandle    : TEMMHandle;
                                  Var LogicalPgs   : WORD       ) : TEMSError;

Function  VEMSGetPgAllHandles(        EMMInfo      : POINTER;
                                  Var NumHandles   : WORD       ) : TEMSError;

Function  VEMSGetPgMap(               OutMapReg    : POINTER    ) : TEMSError;

Function  VEMSSetPgMap(               InMapReg     : POINTER    ) : TEMSError;

Function  VEMSGetSetPgMap(            InMapReg     : POINTER;
                                      OutMapReg    : POINTER    ) : TEMSError;

Function  VEMSGetSizePgMapArr(    Var Size         : BYTE       ) : TEMSError;


{}

{---------}
{ EMS 4.0 }
{---------}

Function  VEMSGetPartPgMap(           InPartMap    : POINTER;
                                      OutPartMap   : POINTER    ) : TEMSError;

Function  VEMSSetPartPgMap(           InPartMap    : POINTER    ) : TEMSError;

Function  VEMSGetSizePartPgMap(       NumMapSeg    : WORD;
                                  Var Size         : BYTE       ) : TEMSError;

Function  VEMSMapMultiHandlePg(       EMSHandle    : TEMSHandle;
                                      UseSegAddr   : BOOLEAN;
                                      NumInArr     : WORD;
                                      EMSMapArr    : PEMSMapArr ) : TEMSError;

Function  VEMSReallocatePg(           EMSHandle    : TEMSHandle;
                                      NumPg        : WORD;
                                  Var RealNumP     : WORD       ) : TEMSError;

Function  VEMSGetHandleAttr(          EMSHandle    : TEMSHandle;
                                  Var HandleAttr   : BYTE       ) : TEMSError;

Function  VEMSSetHandleAttr(          EMSHandle    : TEMSHandle;
                                      HandleAttr   : BYTE       ) : TEMSError;

Function  VEMSGetHandleCapable(       EMSHandle    : TEMSHandle;
                                  Var AttrCapable  : BYTE       ) : TEMSError;

Function  VEMSGetHandleName(          EMSHandle    : TEMSHandle;
                                      HandleName   : POINTER    ) : TEMSError;

Function  VEMSSetHandleName(          EMSHandle    : TEMSHandle;
                                      HandleName   : POINTER    ) : TEMSError;

Function  VEMSGetHandleDir(           HandleDir    : PEMSHandleDir;
                                  Var NumEntries   : BYTE       ) : TEMSError;

Function  VEMSSearchNamedHandle(      HandleName   : PEMSHandleName;
                                  Var Value        : WORD       ) : TEMSError;

Function  VEMSGetTotalHandles(    Var TotalHandles : WORD       ) : TEMSError;

Function  VEMSAlterPgMapJump(         EMSHandle    : TEMSHandle;
                                      UseSegAddr   : BOOLEAN;
                                      MapAddr      : PEMSMapAddr) : TEMSError;

Function  VEMSAlterPgMapCall(         EMSHandle    : TEMSHandle;
                                      UseSegAddr   : BOOLEAN;
                                      MapAddr      : PEMSMapAddr) : TEMSError;

Function  VEMSGetPgMapStackReq(   Var StackSpaceReq: WORD       ) : TEMSError;

Function  VEMSMoveMemRegion(          EMSCopyData  : PEMSCopyData): TEMSError;

Function  VEMSExchangeMemRegion(      EMSCopyData  : PEMSCopyData): TEMSError;

Function  VEMSGetMapPhyAddrArr(       MapPhyAddr   : PEMSMapPhyAddr;
                                  Var NumEntries   : WORD       ) : TEMSError;

Function  VEMSGetEntriesMPAArr(   Var NumEntries   : WORD       ) : TEMSError;

Function  VEMSHardwareCfgArr(         EMSHardwareCfgArr : PEMSHardwareCfgArr ) : TEMSError;

Function  VEMSGetUnallocRawPg(    Var UnallocRawPg : WORD;
                                  Var TotalRawPg   : WORD       ) : TEMSError;

Function  VEMSAllocStandardPg(        NumPg        : WORD;
                                  Var EMSHandle    : TEMSHandle ) : TEMSError;

Function  VEMSAllocRawPg(             NumPg        : WORD;
                                  Var EMSHandle    : TEMSHandle ) : TEMSError;

Function  VEMSGetAltMapRegSet(    Var AltMapRegSet : BYTE;
                                      SaveMapContxt: POINTER    ) : TEMSError;

Function  VEMSSetAltMapRegSet(        AltMapRegSet : BYTE;
                                      SaveMapContxt: POINTER    ) : TEMSError;

Function  VEMSGetAltMapSaveArrSize(Var ArrSize     : WORD       ) : TEMSError;

Function  VEMSAllocAltMapRegSet(  Var AltMapRegSet : BYTE       ) : TEMSError;

Function  VEMSDeallocAltMapRegSet(    AltMapRegSet : BYTE       ) : TEMSError;

Function  VEMSAllocDMARegSet(     Var DMARegSet    : BYTE       ) : TEMSError;

Function  VEMSEnabDMAAltMapRegSet(    DMARegSet    : BYTE;
                                      DMAChannel   : BYTE       ) : TEMSError;

Function  VEMSDisabDMAAltMapRegSet(   DMARegSet    : BYTE       ) : TEMSError;

Function  VEMSDeallocDMARegSet(       DMARegSet    : BYTE       ) : TEMSError;

Function  VEMSPrepWarmBoot                         : TEMSError;

Function  VEMSEnabOSFuncSet(      Var AccessKey    : LONGINT    ) : TEMSError;

Function  VEMSDisabOSFuncSet(     Var AccessKey    : LONGINT    ) : TEMSError;

Function  VEMSRetAccessKey(       Var AccessKey    : LONGINT    ) : TEMSError;

{}

Implementation

{}

Function  VEMSErrorToStr(             Status       : TEMSError  ) : STRING;

Var

  S : STRING;

BEGIN

  S := '';

  Case (Status SHR 8) Of

    $80 : S := 'Internal error';
    $81 : S := 'Hardware malfunction';
    $82 : S := 'Expanded memory manager is busy';
    $83 : S := 'Invalid handle';
    $84 : S := 'Undefined function requested';
    $85 : S := 'No more handles available';
    $86 : S := 'Error saving or restoring mapping context';
    $87 : S := 'Insufficient memory pages in system';
    $88 : S := 'Insufficient memory pages available';
    $89 : S := 'Attempt to allocate 0 pages';
    $8A : S := 'One or more logical pages are invalid';
    $8B : S := 'One or more physical pages are invalid';
    $8C : S := 'Page-mapping hardware state save area is full';
    $8D : S := 'Save area already contains this handle';
    $8E : S := 'Save area does not contain this handle';
    $8F : S := 'Undefined subfunction';
    $90 : S := 'Undefined attribute type';
    $91 : S := 'Feature not supported';
    $92 : S := 'Successful, but a portion of source region has been overwritten';
    $93 : S := 'Length of source or destination region exceeds length of region allocated to either handles';
    $94 : S := 'Conventional and expanded memory regions overlap';
    $95 : S := 'Offset within logical page exceeds size of logical page';
    $96 : S := 'Region length exceeds one megabyte';
    $97 : S := 'Source and destination EMS regions have same handle and overlap';
    $98 : S := 'Memory source or destination type undefined';
    $9A : S := 'Specified DMA or alternate map register set not supported';
    $9B : S := 'All DMA or alternate map register set currently allocated';
    $9C : S := 'Alternate DMA or map register sets not supported';
    $9D : S := 'Undefined or unallocated DMA or alternate map register set';
    $9E : S := 'Dedicated DMA channels not supported';
    $9F : S := 'Specified dedicated DMA channel not supported';
    $A0 : S := 'No such handle name';
    $A1 : S := 'Handle found has no name or duplicate handle name';
    $A2 : S := 'Attempted to wrap around one-megabyte conventional address space';
    $A3 : S := 'Contents of source array/partial page map corrupted; ' +
               'Count of mappable segments exceeds total number of mappable segments in system';
    $A4 : S := 'Access denied by operating system';

  End;

  VEMSErrorToStr := S;

END;

{}

(*-

[FUNCTION]

Function  VEMSInstalled                            : BOOLEAN;

[PARAMETERS]

(None)

[RETURNS]

Whether EMS Support is Available

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VEMSInstalled                            : BOOLEAN;

Type

  TEMSSignature = Array[1..8] of Char;
  PEMSSignature = ^TEMSSignature;

Var

  TempPtr : PEMSSignature;

BEGIN

  GetIntVec( $67, Pointer(TempPtr) );

  TempPtr := Ptr( Seg( TempPtr^ ), 10 );

  VEMSInstalled := (TempPtr^='EMMXXXX0');

END;

{}

Function  VEMSGetManagerStatus                     : TEMSError;

Assembler;

ASM

  MOV  AH, $40
  INT  $67

END;

{}

Function  VEMSGetPgFrameStatus(   Var PgFrameSeg   : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $41
  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, PgFrameSeg
  MOV  ES:[DI], BX

 @EXIT:

END;

{}

Function  VEMSGetFreePg(          Var UnallocPg    : WORD;
                                  Var TotalPg      : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $42
  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, UnallocPg
  MOV  ES:[DI], BX

  LES  DI, TotalPg
  MOV  ES:[DI], DX

 @EXIT:

END;

{}

Function  VEMSNewHandle(              LogicalPg    : WORD;
                                  Var EMSHandle    : TEMSHandle ) : TEMSError;

Assembler;

ASM

  MOV  AH, $43
  MOV  BX, LogicalPg
  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, EMSHandle
  MOV  ES:[DI], DX

 @EXIT:

END;

{}

Function  VEMSMapMemory(              EMSHandle    : TEMSHandle;
                                      PhysicalPg   : BYTE;
                                      LogicalPg    : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $44
  MOV  DX, EMSHandle
  MOV  AL, PhysicalPg  { [0..3] }
  MOV  BX, LogicalPg
  INT  $67

END;

{}

Function  VEMSDisposeHandle(          EMMHandle    : TEMMHandle ) : TEMSError;

Assembler;

ASM

  MOV  AH, $45
  MOV  DX, EMMHandle
  INT  $67

END;

{}

Function  VEMMGetVersion(         Var EMMVersion   : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $46
  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, EMMVersion
  MOV  ES:[DI], AL
  XOR  AL, AL

 @EXIT:

END;

{}

Function  VEMSSaveMapContext(         EMSHandle    : TEMSHandle ) : TEMSError;

Assembler;

ASM

  MOV  AH, $47
  MOV  DX, EMSHandle
  INT  $67

END;

{}

Function  VEMSRestoreMapContext(      EMSHandle    : TEMSHandle ) : TEMSError;

Assembler;

ASM

  MOV  AH, $48
  MOV  DX, EMSHandle
  INT  $67

END;

{}

Function  VEMMGetNumHandles(      Var NumHandles   : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $4B
  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, NumHandles
  MOV  ES:[DI], BX

 @EXIT:

END;

{}

Function  VEMSPgsOwnedByHandle(       EMMHandle    : TEMMHandle;
                                  Var LogicalPgs   : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $4C
  MOV  DX, EMMHandle
  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, LogicalPgs
  MOV  ES:[DI], BX

 @EXIT:

END;

{}

Function  VEMSGetPgAllHandles(        EMMInfo      : POINTER;
                                  Var NumHandles   : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $4D
  MOV  ES, word PTR [EMMInfo+2]
  MOV  DI, word PTR [EMMInfo]

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, NumHandles
  MOV  ES:[DI], BX

 @EXIT:

END;

{}

Function  VEMSGetPgMap(               OutMapReg    : POINTER    ) : TEMSError;

Assembler;

ASM

  MOV  AH, $4E
  MOV  AL, 0
  MOV  ES, word PTR [OutMapReg+2]
  MOV  DI, word PTR [OutMapReg]

  INT  $67

END;

{}

Function  VEMSSetPgMap(               InMapReg     : POINTER    ) : TEMSError;

Assembler;

ASM

  PUSH DS

  MOV  AH, $4E
  MOV  AL, 1
  MOV  DS, word PTR [InMapReg+2]
  MOV  SI, word PTR [InMapReg]

  INT  $67

  POP  DS

END;

{}

Function  VEMSGetSetPgMap(            InMapReg     : POINTER;
                                      OutMapReg    : POINTER    ) : TEMSError;

Assembler;

ASM

  PUSH DS

  MOV  AH, $4E
  MOV  AL, 2
  MOV  DS, word PTR [InMapReg+2]
  MOV  SI, word PTR [InMapReg]
  MOV  ES, word PTR [OutMapReg+2]
  MOV  DI, word PTR [OutMapReg]

  INT  $67

  POP  DS

END;

{}

Function  VEMSGetSizePgMapArr(    Var Size         : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $4E
  MOV  AL, 3
  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, Size
  MOV  ES:[DI], AL
  XOR  AL, AL

 @EXIT:

END;


{}

Function  VEMSGetPartPgMap(           InPartMap    : POINTER;
                                      OutPartMap   : POINTER    ) : TEMSError;

Assembler;

ASM

  PUSH DS

  MOV  AH, $4F
  MOV  AL, 0
  MOV  DS, word PTR [InPartMap+2]
  MOV  SI, word PTR [InPartMap]
  MOV  ES, word PTR [OutPartMap+2]
  MOV  DI, word PTR [OutPartMap]

  INT  $67

  POP  DS

END;

{}

Function  VEMSSetPartPgMap(           InPartMap    : POINTER    ) : TEMSError;

Assembler;

ASM

  PUSH DS

  MOV  AH, $4F
  MOV  AL, 1
  MOV  DS, word PTR [InPartMap+2]
  MOV  SI, word PTR [InPartMap]

  INT  $67

  POP  DS

END;

{}

Function  VEMSGetSizePartPgMap(       NumMapSeg    : WORD;
                                  Var Size         : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $4F
  MOV  AL, 2
  MOV  BX, NumMapSeg
  INT  $67

  LES  DI, Size
  MOV  ES:[DI], AL
  XOR  AL, AL

 @EXIT:

END;

{}

Function  VEMSMapMultiHandlePg(       EMSHandle    : TEMSHandle;
                                      UseSegAddr   : BOOLEAN;
                                      NumInArr     : WORD;
                                      EMSMapArr    : PEMSMapArr ) : TEMSError;

Assembler;

ASM

  POP  DS

  MOV  AH, $50
  MOV  DX, EMSHandle

  CMP  UseSegAddr, 1
  JE   @SegAddr

 @PhysicalPage:

  XOR  AL, AL
  JMP  @NextPreInt

 @SegAddr:

  MOV  AL, 1

 @NextPreInt:

  MOV  CX, NumInArr
  MOV  DS, word PTR [EMSMapArr+2]
  MOV  SI, word PTR [EMSMapArr]

  INT  $67

  PUSH DS

END;

{}

Function  VEMSReallocatePg(           EMSHandle    : TEMSHandle;
                                      NumPg        : WORD;
                                  Var RealNumP     : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $51
  MOV  DX, EMSHandle
  MOV  BX, NumPg

  INT  $67

  LES  DI, RealNumP
  MOV  ES:[DI], BX

 @EXIT:

END;

{}

Function  VEMSGetHandleAttr(          EMSHandle    : TEMSHandle;
                                  Var HandleAttr   : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $52
  MOV  AL, 0
  MOV  DX, EMSHandle

  INT  $67

  LES  DI, HandleAttr
  MOV  ES:[DI], AL
  XOR  AL, AL

END;

{}

Function  VEMSSetHandleAttr(          EMSHandle    : TEMSHandle;
                                      HandleAttr   : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $52
  MOV  AL, 1
  MOV  DX, EMSHandle
  MOV  BL, HandleAttr

  INT  $67

END;

{}

Function  VEMSGetHandleCapable(       EMSHandle    : TEMSHandle;
                                  Var AttrCapable  : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $52
  MOV  AL, 2
  MOV  DX, EMSHandle

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, AttrCapable
  MOV  ES:[DI], AL
  XOR  AL, AL

 @EXIT:

END;

{}

Function  VEMSGetHandleName(          EMSHandle    : TEMSHandle;
                                      HandleName   : POINTER    ) : TEMSError;

Assembler;

ASM

  MOV  AH, $53
  MOV  AL, 0
  MOV  DX, EMSHandle
  LES  DI, HandleName

  INT  $67

END;

{}

Function  VEMSSetHandleName(          EMSHandle    : TEMSHandle;
                                      HandleName   : POINTER    ) : TEMSError;

Assembler;

ASM

  PUSH DS

  MOV  AH, $53
  MOV  AL, 1
  MOV  DX, EMSHandle
  LDS  SI, HandleName

  INT  $67

  POP  DS

END;

{}

Function  VEMSGetHandleDir(           HandleDir    : PEMSHandleDir;
                                  Var NumEntries   : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $54
  MOV  AL, 0
  LES  DI, HandleDir

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, NumEntries
  MOV  ES:[DI], AL
  XOR  AL, AL

 @EXIT:

END;

{}

Function  VEMSSearchNamedHandle(      HandleName   : PEMSHandleName;
                                  Var Value        : WORD       ) : TEMSError;

Assembler;

ASM

  PUSH DS

  MOV  AH, $54
  MOV  AL, 1
  LDS  SI, HandleName

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, Value
  MOV  ES:[DI], DX

 @EXIT:

  POP  DS

END;

{}

Function  VEMSGetTotalHandles(    Var TotalHandles : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $54
  MOV  AL, 2

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, TotalHandles
  MOV  ES:[DI], BX

 @EXIT:

END;

{}

Function  VEMSAlterPgMapJump(         EMSHandle    : TEMSHandle;
                                      UseSegAddr   : BOOLEAN;
                                      MapAddr      : PEMSMapAddr) : TEMSError;

Assembler;

ASM

  PUSH DS

  MOV  AH, $55
  CMP  UseSegAddr, 1
  JE   @SegAddr

 @PhysicalPage:

  XOR  AL, AL
  JMP  @NextPreInt

 @SegAddr:

  MOV  AL, 1

 @NextPreInt:

  MOV  DX, EMSHandle
  LDS  SI, MapAddr

  INT  $67

  POP  DS

END;

{}

Function  VEMSAlterPgMapCall(         EMSHandle    : TEMSHandle;
                                      UseSegAddr   : BOOLEAN;
                                      MapAddr      : PEMSMapAddr) : TEMSError;

Assembler;

ASM

  PUSH DS

  MOV  AH, $56
  CMP  UseSegAddr, 1
  JE   @SegAddr

 @PhysicalPage:

  XOR  AL, AL
  JMP  @NextPreInt

 @SegAddr:

  MOV  AL, 1

 @NextPreInt:

  MOV  DX, EMSHandle
  LDS  SI, MapAddr

  INT  $67

  POP  DS

END;

{}

Function  VEMSGetPgMapStackReq(   Var StackSpaceReq: WORD       ) : TEMSError;

Assembler;

ASM

  PUSH DS

  MOV  AH, $56
  MOV  AL, 2

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, StackSpaceReq
  MOV  ES:[DI], BX

 @EXIT:

  POP  DS

END;

{}

Function  VEMSMoveMemRegion(          EMSCopyData  : PEMSCopyData): TEMSError;

Assembler;

ASM

  PUSH DS

  MOV  AH, $57
  MOV  AL, 0
  LDS  SI, EMSCopyData

  INT  $67

  POP  DS

END;

{}

Function  VEMSExchangeMemRegion(      EMSCopyData  : PEMSCopyData): TEMSError;

Assembler;

ASM

  PUSH DS

  MOV  AH, $57
  MOV  AL, 1
  LDS  SI, EMSCopyData

  INT  $67

  POP  DS

END;

{}

Function  VEMSGetMapPhyAddrArr(       MapPhyAddr   : PEMSMapPhyAddr;
                                  Var NumEntries   : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $58
  MOV  AL, 0
  LES  SI, MapPhyAddr

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, NumEntries
  MOV  ES:[DI], CX

 @EXIT:

END;

{}

Function  VEMSGetEntriesMPAArr(   Var NumEntries   : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $58
  MOV  AL, 1

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, NumEntries
  MOV  ES:[DI], CX

 @EXIT:

END;

{}

Function  VEMSHardwareCfgArr(         EMSHardwareCfgArr : PEMSHardwareCfgArr ) : TEMSError;

Assembler;

ASM

  MOV  AH, $59
  MOV  AL, 0
  LES  SI, EMSHardwareCfgArr

  INT  $67

END;

{}

Function  VEMSGetUnallocRawPg(    Var UnallocRawPg : WORD;
                                  Var TotalRawPg   : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $59
  MOV  AL, 1

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, UnallocRawPg
  MOV  ES:[DI], BX

  LES  DI, TotalRawPg
  MOV  ES:[DI], DX

 @EXIT:

END;

{}

Function  VEMSAllocStandardPg(        NumPg        : WORD;
                                  Var EMSHandle    : TEMSHandle ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5A
  MOV  AL, 0
  MOV  BX, NumPg

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, EMSHandle
  MOV  ES:[DI], DX

 @EXIT:

END;

{}

Function  VEMSAllocRawPg(             NumPg        : WORD;
                                  Var EMSHandle    : TEMSHandle ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5A
  MOV  AL, 1
  MOV  BX, NumPg

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, EMSHandle
  MOV  ES:[DI], DX

 @EXIT:

END;

{}

Function  VEMSGetAltMapRegSet(    Var AltMapRegSet : BYTE;
                                      SaveMapContxt: POINTER    ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5B
  MOV  AL, 0
  LES  DI, SaveMapContxt

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, AltMapRegSet
  MOV  ES:[DI], BL

 @EXIT:

END;

{}

Function  VEMSSetAltMapRegSet(        AltMapRegSet : BYTE;
                                      SaveMapContxt: POINTER    ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5B
  MOV  AL, 1
  MOV  BL, AltMapRegSet
  LES  DI, SaveMapContxt

  INT  $67

END;

{}

Function  VEMSGetAltMapSaveArrSize(Var ArrSize     : WORD       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5B
  MOV  AL, 2

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, ArrSize
  MOV  ES:[DI], DX

 @EXIT:

END;
{}

Function  VEMSAllocAltMapRegSet(  Var AltMapRegSet : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5B
  MOV  AL, 3

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, AltMapRegSet
  MOV  ES:[DI], BL

 @EXIT:

END;

{}

Function  VEMSDeallocAltMapRegSet(    AltMapRegSet : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5B
  MOV  AL, 4
  MOV  BL, AltMapRegSet

  INT  $67

END;

{}

Function  VEMSAllocDMARegSet(     Var DMARegSet    : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5B
  MOV  AL, 5

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, DMARegSet
  MOV  ES:[DI], BL

 @EXIT:

END;

{}

Function  VEMSEnabDMAAltMapRegSet(    DMARegSet    : BYTE;
                                      DMAChannel   : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5B
  MOV  AL, 6
  MOV  BL, DMARegSet
  MOV  DL, DMAChannel

  INT  $67

END;

{}

Function  VEMSDisabDMAAltMapRegSet(   DMARegSet    : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5B
  MOV  AL, 7
  MOV  BL, DMARegSet

  INT  $67

END;


{}

Function  VEMSDeallocDMARegSet(       DMARegSet    : BYTE       ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5B
  MOV  AL, 8
  MOV  BL, DMARegSet

  INT  $67

END;

{}

Function  VEMSPrepWarmBoot                         : TEMSError;

Assembler;

ASM

  MOV  AH, $5C
  INT  $67

END;

{}

Function  VEMSEnabOSFuncSet(      Var AccessKey    : LONGINT    ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5D
  MOV  AL, 0
  LES  DI, AccessKey
  MOV  BX, ES:[DI]
  MOV  CX, ES:[DI+2]

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, AccessKey
  MOV  ES:[DI], BX
  MOV  ES:[DI+2], CX

 @EXIT:

END;

{}

Function  VEMSDisabOSFuncSet(     Var AccessKey    : LONGINT    ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5D
  MOV  AL, 1
  LES  DI, AccessKey
  MOV  BX, ES:[DI]
  MOV  CX, ES:[DI+2]

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, AccessKey
  MOV  ES:[DI], BX
  MOV  ES:[DI+2], CX

 @EXIT:

END;

{}

Function  VEMSRetAccessKey(       Var AccessKey    : LONGINT    ) : TEMSError;

Assembler;

ASM

  MOV  AH, $5D
  MOV  AL, 2
  LES  DI, AccessKey
  MOV  BX, ES:[DI]
  MOV  CX, ES:[DI+2]

  INT  $67

  CMP  AH, 0
  JE   @SUCCESS

 @NEXT:

  JMP  @EXIT

 @SUCCESS:

  LES  DI, AccessKey
  MOV  ES:[DI], BX
  MOV  ES:[DI+2], CX

 @EXIT:

END;

{}
{}
{}

BEGIN
END.

