{
 

 Visionix Equipment Determination Unit (VEQUIP)
   Version 0.11
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 jrt       12/28/93  Added GetCpuTypeStr, yanked GetConsoleInfo funcs.

 mep       04/15/93  Added GetCPUType

 lpg       03/15/93  Added Source Decumentation

 mep       02/11/93  Cleaned up code for beta release

 jrt       02/08/93  Sync with beta 0.12 release

 jrt       12/15/92  Updated to work in protected mode for BP 7.0

 jrt       12/07/92  Sync with beta 0.11 release

 lpg       11/30/92  Added New functions & Merged Beta 008 - 009

 jrt       11/25/92  brought GetConsoleInfo over from VCRT
                     added Primary/AlternateConsoleIsColor functions

 lpg       11/24/92  Slightly modified (ASM)

 jrt       11/21/92  Sync with beta 0.08

 jrt       11/18/92  First logged revision.

 

 Notes:

   add funcs to report what I/O port serial ports are at
   add funcs to report what i/o port par    ports are at

   check for presence of weitek coprocessor

   load SI with 0 before all INT $11 calls

 
}

(*-

[TEXT]

<Overview>

This unit implements functions which return information about the
equipment that is currently connected to the PC on which the unit
is running.

The documentation for this unit will be enhanced in the next release.

<Interface>

-*)


Unit VEquipu;

Interface

Uses

  DOS;

{}

Const

  { Equipment Constants }

  ec8086  = 1;
  ec80286 = 2;
  ec80386 = 3;
  ec80486 = 4;
{}

Function  BIOSNameByte                                       : BYTE;

Function  BIOSDate                                           : STRING;

Function  FloppyPresent                                      : BOOLEAN;

Function  MathChipPresent                                    : BOOLEAN;

Function  PointingDevicePresent                              : BOOLEAN;

Function  NumFloppies                                        : INTEGER;

Function  NumRS232Cards                                      : INTEGER;

Function  GamePortPresent                                    : BOOLEAN;

Function  SerialPrinterPresent                               : BOOLEAN;  {PCJr Only}

Function  InternalModemPresent                               : BOOLEAN;  {Non-PCjr}

Function  NumPrinters                                        : INTEGER;

Function  GetCPUType                                         : BYTE;

Function  GetCPUTypeStr                                      : STRING;

{}


IMPLEMENTATION

{}

(*-

[FUNCTION]

Function BiosName                                            : BYTE;

[PARAMETERS]

(None)

[RETURNS]

The BIOS Name ID Byte

[DESCRIPTION]

Reads and Returns the System BIOS Name ID Byte.  These are as follows:
  ...
  ...
  ...
  ...

{ gets the name of the motherboard bios }


[SEE-ALSO]

[EXAMPLE]

-*)

Function BiosNameByte                                        : BYTE;

Assembler;
ASM

  PUSH DS
  MOV AX, $F000
  MOV DS, AX
  MOV SI, $FFFE

  MOV AL, byte PTR [DS:SI]

  POP DS

END;

{}

(*-

[FUNCTION]

Function BIOSDate                                            : STRING;

[PARAMETERS]

(None)

[RETURNS]

The BIOS Date String

[DESCRIPTION]

Reads and Returns the BIOS Date String

  { gets the date of the motherboard bios }

[SEE-ALSO]

[EXAMPLE]

-*)

Function BIOSDate                                            : STRING;

Var

  R : REGISTERS;
  S : STRING;

BEGIN

  Move( Mem[ $F000 : $FFF5 ], S[1], 8 );
  S[ 0 ] := CHAR( 8 );
  BIOSDate := S;

END;  { BIOSDate }

{}

(*-

[FUNCTION]

Function FloppyPresent                                     : BOOLEAN;

[PARAMETERS]

(None)

[RETURNS]

Whether a Floppy Drive is Installed. (TRUE=Yes)

[DESCRIPTION]

Tests and Returns whether even a single Floppy Drive is Installed in
the system.

  { returns TRUE if floppy drive is installed }

[SEE-ALSO]

[EXAMPLE]

-*)

Function FloppyPresent                                     : BOOLEAN;

Assembler;
ASM

  INT $11          { 0000 0000 - 0000 0001 }
  AND AL, $01

END;

{}

(*-

[FUNCTION]

Function MathChipPresent                                       : BOOLEAN;

[PARAMETERS]

(None)

[RETURNS]

Whether a Math Co-Processor Chip is Installed (TRUE=Yes)

[DESCRIPTION]

Tests and Returns whether a Math CoProcessor Chip is installed in the
system.

  { returns TRUE if Math Co-Processor exists }

[SEE-ALSO]

[EXAMPLE]

-*)

Function MathChipPresent                                       : BOOLEAN;

Assembler;
ASM

  INT $11          { 0000 0000 - 0000 0010 }
  AND AL, $02
  SHR AL, 1

END;

{}

(*-

[FUNCTION]

Function PointingDevicePresent                                : BOOLEAN;

[PARAMETERS]

(None)

[RETURNS]

Whether a Pointing Device Exists (TRUE=Yes)

[DESCRIPTION]

Tests and Returns whether any type of Pointing Device is attached to
the system.  This includes a Mouse, Light Pen, etc.

  { returns TRUE if a pointing device is present }

[SEE-ALSO]

[EXAMPLE]

-*)

Function PointingDevicePresent                                : BOOLEAN;

Assembler;
ASM

  INT  $11         { 0000 0000 - 0000 0100 }

  AND  AL, $04
  SHR  AL, 1
  SHR  AL, 1

END;

{}

(*-

[FUNCTION]

Function NumFloppies                                         : INTEGER;

[PARAMETERS]

(None)

[RETURNS]

The Number of Floppy Drives Attached

[DESCRIPTION]

Tests and Returns the Number of Floppy Drives Attached to the System.

  { returns the number of installed floppies }

[SEE-ALSO]

[EXAMPLE]

-*)

Function NumFloppies                                         : INTEGER;

Assembler;
ASM

  INT  $11                   { 0000 0000 - 1100 0000 }

  AND  AX, $00C0
  MOV  CL, 6
  SHR  AX, CL

END;  { NumFloppies }

{}

(*-

[FUNCTION]

Function NumRS232Cards                                       : INTEGER;

[PARAMETERS]

(None)

[RETURNS]

The Number of RS-232 Cards Attached

[DESCRIPTION]

Attempts to Detect the Number of RS-232 Cards that are attached to the
system.

  { returns the number of RS-232 ports }

[SEE-ALSO]

[EXAMPLE]

-*)

Function NumRS232Cards                                       : INTEGER;

Assembler;
ASM

  INT  $11         { 0000 1110 - 0000 0000 }

  MOV  AL, AH
  XOR  AH, AH
  SHR  AL, 1

END;

{}

(*-

[FUNCTION]

Function GamePortExists                                      : BOOLEAN;

[PARAMETERS]

(None)

[RETURNS]

Whether a Game Port Exits (TRUE=Yes)

[DESCRIPTION]

Tests and Returns whether a Game Port Present.

  { returns TRUE if a joystick port Present }

[SEE-ALSO]

[EXAMPLE]

-*)

Function GamePortPresent                                      : BOOLEAN;

Assembler;
ASM

  INT  $11         { 0001 0000 - 0000 0000 }

  MOV  AL, AH
  MOV  CL, 4
  SHR  AL, CL

END;

{}

(*-

[FUNCTION]

Function SerialPrinterPresent                                 : BOOLEAN;

[PARAMETERS]

(None)

[RETURNS]

Whether a Serial Printer Present (TRUE=Yes)

[DESCRIPTION]

Attempts to Detect and Report whether a Serial Printer is attached to the
System and Active (ie. Turned On).

Test Valid for PCJr Systems Only.

[SEE-ALSO]

[EXAMPLE]

-*)

Function SerialPrinterPresent                                 : BOOLEAN;

Assembler;
ASM

  INT  $11         { 0010 0000 - 0000 0000  - PCjr Only! }

  MOV  AL, AH
  MOV  CL, 5
  SHR  AL, CL

END;

{}

(*-

[FUNCTION]

Function InternalModemPresent                                 : BOOLEAN;

[PARAMETERS]

(None)

[RETURNS]

Whether an Internal Modem Present (TRUE=Yes)

[DESCRIPTION]

Tests and Returns whether an Internal Modem Present.

Test Valid only for Non-PCjr Systems.

[SEE-ALSO]

[EXAMPLE]

-*)

Function InternalModemPresent                                 : BOOLEAN;

Assembler;
ASM

  INT  $11         { 0010 0000 - 0000 0000   - Non-PCjr }

  MOV  AL, AH
  MOV  CL, 5
  SHR  AL, CL

END;

{}

(*-

[FUNCTION]

Function NumPrinters                                         : INTEGER;

[PARAMETERS]

(None)

[RETURNS]

Number of Printers Attached

[DESCRIPTION]

Attempts to Detect and Report the Number of Printers Attached to the
System and Active (ie. Turned On).

  { returns number of LPT ports }

[SEE-ALSO]

[EXAMPLE]

-*)

Function NumPrinters                                         : INTEGER;

Assembler;
ASM

  INT  $11         { 1100 0000 - 0000 0000 }

  MOV  AL, AH
  MOV  CL, 6
  SHR  AL, CL

  XOR  AH, AH

END;

{}

(*-

[FUNCTION]

Function  GetCPUType                                         : BYTE;

[PARAMETERS]

(None)

[RETURNS]

Type of microprocessor in system (1=8086, 2=80286, 3=80386, 4=80486)

[DESCRIPTION]

Finds the type of microprocessor being used with a system.

[SEE-ALSO]

[EXAMPLE]

-*)

  {

  Function given public domain from Salim Samaha.

  }

Function  GetCPUType                                         : BYTE;

Assembler;
ASM

  MOV   DX, ec8086
  PUSH  SP
  POP   AX
  CMP   SP,AX
  JNE   @OUT
  MOV   DX, ec80286
  PUSHF

  POP   AX
  OR    AX,4000h
  PUSH  AX
  POPF
  PUSHF
  POP   AX
  TEST  AX,4000h
  JE    @OUT
  MOV   DX, ec80386

{"DB 66h" indicates '386 extended instruction}

  DB 66h; MOV   BX, SP      {MOV EBX, ESP}
  DB 66h, 83h,  0E4h, 0FCh  {AND ESP, FFFC}
  DB 66h; PUSHF             {PUSHFD}
  DB 66h; POP   AX          {POP EAX}
  DB 66h; MOV   CX, AX      {MOV ECX, EAX}
  DB 66h, 35h,  00h
  DB 00h, 04h,  00          {XOR EAX, 00040000}
  DB 66h; PUSH  AX          {PUSH EAX}

  DB 66h; POPF              {POPFD}
  DB 66h; PUSHF             {PUSHFD}
  DB 66h; POP   AX          {POP EAX}
  DB 66h, 25h,  00h
  DB 00h, 04h,  00h         {AND EAX, 00040000}
  DB 66h, 81h,  0E1h, 00h
  DB 00h, 04h,  00h         {AND ECX, 00040000}
  DB 66h; CMP   AX, CX      {CMP EAX, ECX}
  JE @Not486
  MOV DX, ec80486

  @Not486:

  DB 66h; PUSH   CX         {PUSH EXC}
  DB 66h; POPF              {POPFD}
  DB 66h; MOV   SP, BX      {MOV ESP, EBX}

  @Out:

  MOV AX, DX

END;

{}

(*-

[FUNCTION]

Function  GetCPUTypeStr                                       : STRING;

[PARAMETERS]

(None)

[RETURNS]

Type of microprocessor in system ('8086', '80286', '80386', '80486' )

[DESCRIPTION]

Finds the type of microprocessor being used with the system.

[SEE-ALSO]

[EXAMPLE]

-*)


Function GetCPUTypeStr                                        : STRING;

BEGIN

  Case GetCPUType of

    ec8086  : GetCPUTypeStr := '8086';
    ec80286 : GetCPUTypeStr := '80286';
    ec80386 : GetCPUTypeStr := '80386';
    ec80486 : GetCPUTypeStr := '80486';

  Else

    GetCPUTypeStr := 'Unknown';

  END;

END;


{}

{}
{}

BEGIN
END.
