{
 

 Visionix Serial Communictions Unit - FOSSIL specification (VFOS)
   Version 0.8
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 ** revision history in reverse chronological order **

 Initials  Date      Comment
     

 mep       04/08/93  Redocumented code.

 mep       02/11/93  Cleaned up code for beta release
                     Fixed for DPMI mode

 jrt       02/08/93  Sync with beta 0.12 release

 mep       01/31/93  Bug fixes.

 jrt       12/07/92  Sync with beta 0.11 release

 jrt       11/21/92  Sync with beta 0.08

 mep       11/18/92  Code re-implemented to work with VSer.  Major changes
                     completed.  Second internal revision.

 mep       11/02/92  First logged revision.

 
}

(*-

[TEXT]

<Overview>

This unit implements a function for all commands in the FOSSIL
specification.  For more information, refer to the FOSSIL spec.

This unit also implements FOSSIL functions which are specific to the
X00 FOSSIL driver.

Additionally, this unit impelements a function to interface the FOSSIL
functions into the VSERu device-indepednent serial unit.  This function,
FosSerDriverProc, is a serial driver procedure for VDOSu serial channels.

FosSerDriverProc can be specified as the serial-driver for a serial
channel by calling VSerDriverNew and specifying FosSerDriverProc
as the serial driver procedure

<<Example>>

    { create a new serial channel       }
    { use the fossil serial driver proc }
    { connect channl to port # 2        }

    Err := VSerchanNew( 0,
                        FosSerDriverProc,
                        2,
                        0,
                        0,
                        Serh                    );


    { Serh is now a handle for the new serial channel }



<Interface>

-*)


Unit VFosu;

Interface

Uses

  VTypesu,
  VSerLu,
  DOS;

{}

Const

  {---------------}
  { FOSSIL Errors }
  {---------------}

  ferr_None       = 0;
  ferr_BadCopy    = 1;

  {--------------}
  { Miscellanous }
  {--------------}

  sfct_None       = 0;
  sfct_RtsCts     = 1;
  sfct_XonXoff    = 2;

  cfPortOK        = 0;

Type

  TFosStruct  = RECORD

    StrSiz    : WORD;      { Size of this structure in bytes                 }
    MajVer    : BYTE;      { FOSSIL specificiation revision                  }
    MinVer    : BYTE;      { Revision of this driver                         }
    IDent     : POINTER;   { Far-pointer to ASCIIZ driver description        }
    IBufSize  : WORD;      { Byte size of the receive buffer                 }
    IFree     : WORD;      { Number of buffered (received) bytes             }
    OBufSize  : WORD;      { Byte size of the transmit buffer                }
    OFree     : WORD;      { Number of buffered (transmit) bytes             }
    SWidth    : BYTE;      { Width of display screen                         }
    SHeight   : BYTE;      { Height of display screen                        }
    Baud      : BYTE;      { Baud rate, computer to modem                    }

  End;

  {---}

  PFosIData   = ^TFosIData;
  TFosIData   = RECORD

    ComPort   : BYTE;      { Communications port                             }
    BaudRate  : LONGINT;   { Bits per second rate                            }
    Parity    : CHAR;      { Parity of hardware error checking               }
    DataBits  : BYTE;      { Number of data bits                             }
    StopBits  : BYTE;      { Number of stop bits                             }
    PortStat  : WORD;      { Condition of UART. LoByte=MSR,HiByte=LSR        }
    UsingX00  : BOOLEAN;   { True if using X00 FOSSIL                        }
    Sig       : WORD;      { $1954 if FOSSIL installed                       }

    FosStruct : TFosStruct;

  END;

{}

Procedure VFosSetCommParam(            ComPort      : LONGINT;
                                       BaudRate     : WORD;
                                       Parity       : CHAR;
                                       DataBits     : BYTE;
                                       StopBits     : BYTE;
                                   Var PortStat     : WORD     );

Procedure VFosSendCharW(               ComPort      : WORD;
                                       Ch           : CHAR;
                                   Var PortStat     : WORD     );

Procedure VFosRecvCharW(               ComPort      : WORD;
                                   Var Ch           : CHAR;
                                   Var PortStat     : WORD     );

Function  VFosGetChar(                 ComPort      : WORD     ) : CHAR;

Procedure VFosGetPortStat(             ComPort      : WORD;
                                   Var PortStat     : WORD     );

Function  VFosChkPortStat(             ComPort      : WORD;
                                       Bit          : BYTE     ) : BOOLEAN;

Procedure VFosActivatePort(            ComPort      : WORD;
                                   Var Sig          : WORD;
                                   Var MaxFunc      : BYTE;
                                   Var FosRev       : BYTE     );

Procedure VFosDeActivatePort(          ComPort      : WORD     );

Procedure VFosSetDTR(                  ComPort      : WORD;
                                       OnOff        : BOOLEAN  );

Procedure VFosGetTimeTickInfo(     Var TickNo       : BYTE;
                                   Var TickPSec     : BYTE;
                                   Var MilPTick     : WORD     );

Procedure VFosFlushOutBuff(            ComPort      : WORD     );

Procedure VFosPurgeOutBuff(            ComPort      : WORD     );

Procedure VFosPurgeInBuff(             ComPort      : WORD     );

Procedure VFosSendChar(                ComPort      : WORD;
                                       Ch           : CHAR;
                                   Var BuffFull     : BOOLEAN  );

Procedure VFosPeekAhead(               ComPort      : WORD;
                                   Var BuffEmpty    : BOOLEAN;
                                   Var Ch           : CHAR     );

Procedure VFosKbRead(              Var ScanCode     : WORD     );

Procedure VFosKbReadW(             Var ScanCode     : WORD     );

Procedure VFosSetFlowControl(          ComPort      : WORD;
                                       FlowStat     : BYTE     );

Procedure VFosControlCheck(            ComPort      : WORD;
                                       CtrlStat     : BYTE;
                                   Var CtrlRecv     : BOOLEAN  );

Procedure VFosSetCurLoc(               X            : BYTE;
                                       Y            : BYTE     );

Procedure VFosGetCurLoc(           Var X            : BYTE;
                                   Var Y            : BYTE     );

Procedure VFosWriteANSI(               Ch           : CHAR     );

Procedure VFosSetWatchDog(             ComPort      : WORD;
                                       OnOff        : BOOLEAN  );

Procedure VFosWriteBIOS(               Ch           : CHAR     );

Procedure VFosReboot(                  WarmBoot     : BOOLEAN  );

Procedure VFosRecvBlock(               ComPort      : WORD;
                                       Buf          : POINTER;
                                       Count        : LONGINT;
                                   Var Result       : LONGINT  );

Procedure VFosSendBlock(               ComPort      : WORD;
                                       Buf          : POINTER;
                                       Count        : LONGINT;
                                   Var Result       : LONGINT  );

Procedure VFosSetBreak(                ComPort      : WORD;
                                       OnOff        : BOOLEAN  );

Procedure VFosGetInfo(                 ComPort      : WORD;
                                       Buf          : POINTER;
                                       Count        : WORD;
                                   Var Result       : WORD;
                                   Var SigS         : ST4      );

Function  VFosGetFosStruct(            ComPort      : WORD;
                                   Var FosStruct    : TFosStruct) : LONGINT;

Procedure VX00ActivatePort(            ComPort      : WORD;
                                   Var Sig          : WORD;
                                   Var MaxFunc      : BYTE;
                                   Var FosRev       : BYTE     );

Procedure VX00DeActivatePort(          ComPort      : WORD     );

Procedure VX00SetExtLineCtrl(          ComPort      : WORD;
                                       Break        : BOOLEAN;
                                       ParityB      : BYTE;
                                       StopBits     : BYTE;
                                       DataBits     : BYTE;
                                       BaudRateB    : BYTE;
                                   Var PortStat     : WORD     );

Procedure VX00ExtGetMCR(               ComPort      : WORD;
                                   Var MCRStat      : BYTE;
                                   Var PortStat     : WORD     );

Procedure VX00ExtSetMCR(               ComPort      : WORD;
                                       MCRStat      : BYTE;
                                   Var PortStat     : WORD     );

Procedure VX00RecvCh(                  ComPort      : WORD;
                                   Var Result       : BOOLEAN;
                                   Var Ch           : CHAR     );

Procedure VX00StuffInBuff(             Ch           : CHAR     );

{}

Procedure FosSerDriverProc(            SDP          : PSerDriverPacket );

{}

IMPLEMENTATION

Const

  fosInitSig     = $1954;

{}

(*-

[FUNCTION]

Procedure VFosSetCommParam(            ComPort      : LONGINT;
                                       BaudRate     : WORD;
                                       Parity       : CHAR;
                                       DataBits     : BYTE;
                                       StopBits     : BYTE;
                                   Var PortStat     : WORD     );

[PARAMETERS]

ComPort     Communications port.
BaudRate    Bits per second rate.
Parity      Parity of hardware error checking.
DataBits    Number of data bits.
StopBits    Number of stop bits.

[RETURNS]

PortStat    Condition of UART (Low Byte=MSR, High Byte=LSR).

[DESCRIPTION]

Set communications parameters: baud, parity, databits, and stopbits.  This
function is identical to the IBM PC BIOS call except that 110 baud and 150
baud have been replaced by 19200 baud and 38400 baud respectively.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosSetCommParam(            ComPort      : LONGINT;
                                       BaudRate     : WORD;
                                       Parity       : CHAR;
                                       DataBits     : BYTE;
                                       StopBits     : BYTE;
                                   Var PortStat     : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AL := 0;

  {---------------------}
  { Databits (bits 0-1) }
  {---------------------}

  Case DataBits of

    5 : Inc(R.AL, 0);
    6 : Inc(R.AL, 1);
    7 : Inc(R.AL, 2);
    8 : Inc(R.AL, 3);

  End;

  {------------------}
  { Stopbits (Bit 2) }
  {------------------}

  Case StopBits Of

    1 : Inc(R.AL, 0);
    2 : Inc(R.AL, 4);

  End;

  {-------------------}
  { Parity (Bits 3-4) }
  {-------------------}

  Case Parity of

    'N' : Inc(R.AL, $00); { None  }
    'O' : Inc(R.AL, $08); { Odd   }
    'E' : Inc(R.AL, $18); { Even  }
    'M' : Inc(R.AL, $28); { Mark  }
    'S' : Inc(R.AL, $38); { Space }

  End;

  {----------------------}
  { Baud Rate (Bits 5-7) }
  {----------------------}

  Case BaudRate of

    19200 : Inc(R.AL, $00);
    300   : Inc(R.AL, $40);
    600   : Inc(R.AL, $60);
    1200  : Inc(R.AL, $80);
    2400  : Inc(R.AL, $A0);
    4800  : Inc(R.AL, $C0);
    9600  : Inc(R.AL, $E0);

    Else
    BEGIN

      If BaudRate = 38400 Then
        Inc(R.AL, $20);

    END;

  End;

  R.AH := 0;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  PortStat := R.AX;

END;

{}

(*-

[FUNCTION]

Procedure VFosSendCharW(               ComPort      : WORD;
                                       Ch           : CHAR;
                                   Var PortStat     : WORD     );

[PARAMETERS]

ComPort     Communications port.
Ch          Charcter to transmit.

[RETURNS]

PortStat    Condition of UART (Low Byte=MSR, High Byte=LSR).

[DESCRIPTION]

Places a character into the transmit buffer.  If no room is available, then
function will loop until room becomes available or a timeout occurs (30
seconds).  If a timeout occurs, the timeout bit in PortStat will be set.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosSendCharW(               ComPort      : WORD;
                                       Ch           : CHAR;
                                   Var PortStat     : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $01;
  R.AL := Byte( Ch );
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  PortStat := R.AX;

END;

{}

(*-

[FUNCTION]

Procedure VFosRecvCharW(               ComPort      : WORD;
                                   Var Ch           : CHAR;
                                   Var PortStat     : WORD     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

Ch          Character to receive.
PortStat    Condition of UART (Low Byte=MSR, High Byte=LSR)

[DESCRIPTION]

Retrieves a character from the receive buffer.  If buffer is empty, then
function will wait until a character is received or a timeout occurs (30
seconds).  If a timeout occurs, the timeout bit in PortStat will be set.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosRecvCharW(               ComPort      : WORD;
                                   Var Ch           : CHAR;
                                   Var PortStat     : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $02;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  Ch       := Char( R.AL );
  PortStat := (PortStat AND $FF) + (R.AH SHL 8);

END;

{}

(*-

[FUNCTION]

Function  VFosGetChar(                 ComPort      : WORD     ) : CHAR;

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

Character from ComPort.

[DESCRIPTION]

Convienent function to retrieve one character from ComPort.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VFosGetChar(                 ComPort      : WORD     ) : CHAR;

Var

  Ch       : CHAR;
  PortStat : WORD;

BEGIN

  VFosRecvCharW( ComPort, Ch, PortStat );
  VFosGetChar := Ch;

END;

{}

(*-

[FUNCTION]

Procedure VFosGetPortStat(             ComPort      : WORD;
                                   Var PortStat     : WORD     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

PortStat    Condition of UART (Low Byte=MSR, High Byte=LSR).

[DESCRIPTION]

Returns serial port status.  The PortStat bitfield is to be used by the
MSR/LSR constants.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosGetPortStat(             ComPort      : WORD;
                                   Var PortStat     : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $03;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  PortStat := R.AX;

END;

{}

(*-

[FUNCTION]

Function  VFosChkPortStat(             ComPort      : WORD;
                                       Bit          : BYTE     ) : BOOLEAN;

[PARAMETERS]

ComPort     Communications port.
Bit         Bit in Port Status to check.

[RETURNS]

BOOLEAN condition of bitfield.

[DESCRIPTION]

Checks whether a bit location is set inside PortStat.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VFosChkPortStat(             ComPort      : WORD;
                                       Bit          : BYTE     ) : BOOLEAN;

Var

  PortStat : WORD;

BEGIN

  VFosGetPortStat( ComPort, PortStat );
  VFosChkPortStat := ( PortStat AND CBitMapW[Bit] ) <> 0;

END;

{}

(*-

[FUNCTION]

Procedure VFosActivatePort(            ComPort      : WORD;
                                   Var Sig          : WORD;
                                   Var MaxFunc      : BYTE;
                                   Var FosRev       : BYTE     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

Sig         Signature of communications driver installed.
MaxFunc     Number of functions supported by driver.
FosRev      Revision of the installed FOSSIL specification.

[DESCRIPTION]

This installs FOSSIL functions for the specified ComPort.  Use this before
any use of other ComPort dependant functions.  When called, DTR is raised,
but baud rate is not effected.  Any additional call to this function to an
installed ComPort will clear all buffers and flow control.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosActivatePort(            ComPort      : WORD;
                                   Var Sig          : WORD;
                                   Var MaxFunc      : BYTE;
                                   Var FosRev       : BYTE     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $04;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  Sig     := R.AX;
  MaxFunc := R.BL;
  FosRev  := R.BH;

END;

{}

(*-

[FUNCTION]

Procedure VFosDeActivatePort(          ComPort      : WORD     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

[DESCRIPTION]

Deactivates FOSSIL functions for the specified ComPort.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosDeActivatePort(          ComPort      : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $05;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VFosSetDTR(                  ComPort      : WORD;
                                       OnOff        : BOOLEAN  );

[PARAMETERS]

ComPort     Communications port.
OnOff       On/Off (True/False) switch for this function.

[RETURNS]

[DESCRIPTION]

Controls the DTR signal.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosSetDTR(                  ComPort      : WORD;
                                       OnOff        : BOOLEAN  );

Var

  R : REGISTERS;

BEGIN

  R.AH := $06;
  R.AL := Byte( OnOff );
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VFosGetTimeTickInfo(     Var TickNo       : BYTE;
                                   Var TickPSec     : BYTE;
                                   Var MilPTick     : WORD     );

[PARAMETERS]

[RETURNS]

TickNo      Timer tick interrupt number.
TickPSec    Approximate interrupts per second (18 on IBM).
MilPTick    Approximate number of milliseconds per tick.

[DESCRIPTION]

Returns the properties of the CPU's timer ticks.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosGetTimeTickInfo(     Var TickNo       : BYTE;
                                   Var TickPSec     : BYTE;
                                   Var MilPTick     : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $07;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  TickNo   := R.AL;
  TickPSec := R.AH;
  MilPTick := R.DX;

END;

{}

(*-

[FUNCTION]

Procedure VFosFlushOutBuff(            ComPort      : WORD     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

[DESCRIPTION]

Flushs the transmit buffer.  Waits until all the output is sent.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosFlushOutBuff(            ComPort      : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $08;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VFosPurgeOutBuff(            ComPort      : WORD     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

[DESCRIPTION]

Emptys the transmit buffer by removing all characters.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosPurgeOutBuff(            ComPort      : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $09;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VFosPurgeInBuff(             ComPort      : WORD     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

[DESCRIPTION]

Emptys the receive buffer by removing all characters.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosPurgeInBuff(             ComPort      : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $0A;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VFosSendChar(                ComPort      : WORD;
                                       Ch           : CHAR;
                                   Var BuffFull     : BOOLEAN  );

[PARAMETERS]

ComPort     Communications port.
Ch          Charcter to transmit.

[RETURNS]

BuffFull    Is the transmit buffer full?

[DESCRIPTION]

Places a character into the transmit buffer.  If no room is available (the
character was not buffered), the BuffFull will be set.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosSendChar(                ComPort      : WORD;
                                       Ch           : CHAR;
                                   Var BuffFull     : BOOLEAN  );

Var

  R : REGISTERS;

BEGIN

  R.AH := $0B;
  R.AL := Byte( Ch );
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  BuffFull := (R.AX = 0);

END;

{}

(*-

[FUNCTION]

Procedure VFosPeekAhead(               ComPort      : WORD;
                                   Var BuffEmpty    : BOOLEAN;
                                   Var Ch           : CHAR     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

BuffEmpty   Is the receive buffer empty?
Ch          Character to get from receive buffer.

[DESCRIPTION]

Issues a non-destructive read-ahead (peek) through the recieve buffer and
returns the next character from the receive buffer.  If the buffer is empty,
then BuffEmpty is set.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosPeekAhead(               ComPort      : WORD;
                                   Var BuffEmpty    : BOOLEAN;
                                   Var Ch           : CHAR     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $0C;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  Ch        := Char( R.AL );
  BuffEmpty := ( R.AX = $FFFF );

END;

{}

(*-

[FUNCTION]

Procedure VFosKbRead(              Var ScanCode     : WORD     );

[PARAMETERS]

[RETURNS]

ScanCode    Scancode from local keyboard.

[DESCRIPTION]

Returns a keyboard scancode of the next character in keyboard buffer. This
will not remove the character from the buffer - only "peeks".  If no
character is available, ScanCode will return as $FFFF.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosKbRead(              Var ScanCode     : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $0D;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  ScanCode := R.AX;

END;

{}

(*-

[FUNCTION]

Procedure VFosKbReadW(             Var ScanCode     : WORD     );

[PARAMETERS]

[RETURNS]

ScanCode    Scancode from local keyboard.

[DESCRIPTION]

Returns next character available from keyboard.  If no character is
available, then function will loop until a scancode is available.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosKbReadW(             Var ScanCode     : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $0E;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  ScanCode := R.AX;

END;

{}

(*-

[FUNCTION]

Procedure VFosSetFlowControl(          ComPort      : WORD;
                                       FlowStat     : BYTE     );

[PARAMETERS]

ComPort     Communications port.
FlowStat    Flow control bitfield as defined:

              Bit 0 = 1 Enable receiving of Xon/Xoff. This will stop
                        transmitting when Xoff is received.

              Bit 1 = 1 Enable RTS/CTS flow control. This will drop RTS
                        when receive buffer is 3/4 full and will be
                        raised when buffer is emptied to 1/4 full.  If
                        the baud rate is locked, then RTS/CTS will be
                        forced.

              Bit 2 = 0 Reserved.  Should always be 0.

              Bit 3 = 1 Enable transmitting of Xon/Xoff.  This will
                        send an Xoff when the buffers are 3/4 full, and
                        will send an Xon when they return to 1/4 full.

[RETURNS]

[DESCRIPTION]

Sets flow control for the serial I/O.  Xon/XOff (Software) and
RTS/CTS (Hardware) can both be enabled at the same time.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosSetFlowControl(          ComPort      : WORD;
                                       FlowStat     : BYTE     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $0F;
  R.AL := FlowStat;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VFosControlCheck(            ComPort      : WORD;
                                       CtrlStat     : BYTE;
                                   Var CtrlRecv     : BOOLEAN  );

[PARAMETERS]

ComPort     Communications port.
CtrlStat    bitfield as defined:

            Bit 0 = 1  Enable Ctrl-C/Ctrl-K checking.  If a Ctrl-C
                       or a Ctrl-K is received, this will set an
                       internal flag to be used as software needs.

            Bit 1 = 1  Disable the transmitter buffer.  This is not
                       absolute, as other functions re-enable the
                       transmitter.

[RETURNS]

CtrlRecv    True if a Ctrl-C or Ctrl-K has been received.

[DESCRIPTION]

Sets internal Control-C and Control-K checking.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosControlCheck(            ComPort      : WORD;
                                       CtrlStat     : BYTE;
                                   Var CtrlRecv     : BOOLEAN  );

Var

  R : REGISTERS;

BEGIN

  R.AH := $10;
  R.AL := CtrlStat;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  CtrlRecv := ( R.AX = 1 );

END;

{}

(*-

[FUNCTION]

Procedure VFosSetCurLoc(               X            : BYTE;
                                       Y            : BYTE     );

[PARAMETERS]

X           Column to set cursor location.
Y           Row to set cursor location.

[RETURNS]

[DESCRIPTION]

Sets the current cursor location on the local screen.  The coordinates are
zero-based.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosSetCurLoc(               X            : BYTE;
                                       Y            : BYTE     );
Var

  R : REGISTERS;

BEGIN

  R.AH := $11;
  R.DH := Y;  { Row }
  R.DL := X;  { Column }

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VFosGetCurLoc(           Var X            : BYTE;
                                   Var Y            : BYTE     );

[PARAMETERS]

[RETURNS]

X           Column of cursor location.
Y           Row of cursor location.

[DESCRIPTION]

Gets the current cursor location on the local screen.  The coordinates are
zero-based.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosGetCurLoc(           Var X            : BYTE;
                                   Var Y            : BYTE     );
Var

  R : REGISTERS;

BEGIN

  R.AH := $12;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  Y := R.DH;
  X := R.DL;

END;

{}

(*-

[FUNCTION]

Procedure VFosWriteANSI(               Ch           : CHAR     );

[PARAMETERS]

Ch          Character for screen.

[RETURNS]

[DESCRIPTION]

Prints a single character to the local screen using ANSI writes.  An ANSI
device driver is required.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosWriteANSI(               Ch           : CHAR     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $13;
  R.AL := Byte( CH );

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VFosSetWatchDog(             ComPort      : WORD;
                                       OnOff        : BOOLEAN  );

[PARAMETERS]

ComPort     Communications port.
OnOff       On/Off (True/False) switch for this function.

[RETURNS]

[DESCRIPTION]

The DCD WatchDog monitors carrier detection of a specified ComPort.  If
enabled, upon a carrier drop, the system will reboot.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosSetWatchDog(             ComPort      : WORD;
                                       OnOff        : BOOLEAN  );

Var

  R : REGISTERS;

BEGIN

  R.AH := $14;
  R.AL := Byte( OnOff );
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VFosWriteBIOS(               Ch           : CHAR     );

[PARAMETERS]

Ch          Charcter for the local screen.

[RETURNS]

[DESCRIPTION]

Writes a single character to the local screen using a BIOS-level routine.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosWriteBIOS(               Ch           : CHAR     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $15;
  R.AL := Byte( Ch );

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

{----------------------------------------------------------------------------}
{                                                                            }
{ Function 16h - Add or delete a routine from the timer tick                 }
{                                                                            }
{ FUNCTION NOT SUPPORTED.  See VMULTI.                                       }
{                                                                            }
{----------------------------------------------------------------------------}

{
Procedure VFosSetTimerProc(        OnOff    : BOOLEAN;
                                   ProcPtr  : POINTER;
                               Var Success  : BOOLEAN             );

BEGIN
END;
}

{}

(*-

[FUNCTION]

Procedure VFosReboot(                  WarmBoot     : BOOLEAN  );

[PARAMETERS]

WarmBoot    Warmboot if true, Coldboot if false.

[RETURNS]

[DESCRIPTION]

Reboots the system, allowing for a warm or cold boot.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosReboot(                  WarmBoot     : BOOLEAN  );

Var

  R : REGISTERS;

BEGIN

  R.AH := $17;
  R.AL := Byte(WarmBoot);

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VFosRecvBlock(               ComPort      : WORD;
                                       Buf          : POINTER;
                                       Count        : LONGINT;
                                   Var Result       : LONGINT  );

[PARAMETERS]

ComPort     Communications port.
Buf         Any variable.
Count       An expression of bytes to read.

[RETURNS]

Result      A variable of bytes actually read.

[DESCRIPTION]

Gets an stream of characters from the receive buffer to an internal buffer.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosRecvBlock(               ComPort      : WORD;
                                       Buf          : POINTER;
                                       Count        : LONGINT;
                                   Var Result       : LONGINT  );

Var

  R : REGISTERS;

BEGIN

  R.AH := $18;
  R.CX := Count;
  R.DX := ComPort;
  R.ES := Seg( Buf^ );
  R.DI := Ofs( Buf^ );

  R.DS := 0;

  Intr( $14, R );

  Result := R.AX;

END;

{}

(*-

[FUNCTION]

Procedure VFosSendBlock(               ComPort      : WORD;
                                       Buf          : POINTER;
                                       Count        : LONGINT;
                                   Var Result       : LONGINT  );

[PARAMETERS]

ComPort     Communications port.
Buf         Any variable.
Count       An expression of bytes to write.

[RETURNS]

Result      A variable of bytes actually wrote.

[DESCRIPTION]

Puts a stream of characters from an internal buffer into the transmit buffer.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosSendBlock(               ComPort      : WORD;
                                       Buf          : POINTER;
                                       Count        : LONGINT;
                                   Var Result       : LONGINT  );

Var

  R : REGISTERS;

BEGIN

  R.AH := $19;
  R.CX := Count;
  R.DX := ComPort;
  R.ES := Seg( Buf^ );
  R.DI := Ofs( Buf^ );

  R.DS := 0;

  Intr( $14, R );

  Result := R.AX;

END;

{}

(*-

[FUNCTION]

Procedure VFosSetBreak(                ComPort      : WORD;
                                       OnOff        : BOOLEAN  );

[PARAMETERS]

ComPort     Communications port.
OnOff       On/Off (True/False) switch for this function.

[RETURNS]

[DESCRIPTION]

Sends a break signal to ComPort - useful for activating command mode on
some modems.  If Xoff is currently active, this function will clear that
flag.  Break durations should be less than 1/10th of a second.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosSetBreak(                ComPort      : WORD;
                                       OnOff        : BOOLEAN  );

Var

  R : REGISTERS;

BEGIN

  R.AH := $1A;
  R.AL := Byte( OnOff );
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VFosGetInfo(                 ComPort      : WORD;
                                       Buf          : POINTER;
                                       Count        : WORD;
                                   Var Result       : WORD;
                                   Var SigS         : ST4      );

[PARAMETERS]

ComPort     Communications port.
Buf         Variable of type TFosStruct.
Count       An expression of bytes to read.

[RETURNS]

Result      A variable of bytes actually read.
SigS        Signature of FOSSIL driver installed.

[DESCRIPTION]

Gets information about the current FOSSIL environment.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VFosGetInfo(                 ComPort      : WORD;
                                       Buf          : POINTER;
                                       Count        : WORD;
                                   Var Result       : WORD;
                                   Var SigS         : ST4      );

Var

  R : REGISTERS;

BEGIN

  R.AH := $1B;
  R.CX := Count;
  R.DX := ComPort;
  R.ES := Seg( Buf^ );
  R.DI := Ofs( Buf^ );

  R.DS := 0;

  Intr( $14, R );

  Result := R.AX;
  SigS   := Char(Lo(R.CX)) + Char(Hi(R.CX)) +
            Char(Lo(R.DX)) + Char(Hi(R.DX));

END;

{}

(*-

[FUNCTION]

Function VFosGetFosStruct(             ComPort      : WORD;
                                   Var FosStruct    : TFosStruct) : LONGINT;

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

FosStruct   FOSSIL environment table.

[DESCRIPTION]

Gets information about the current FOSSIL environment using a simpler format.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VFosGetFosStruct(             ComPort      : WORD;
                                   Var FosStruct    : TFosStruct) : LONGINT;

Var

  Result : WORD;
  Sig    : ST4;

BEGIN

  VFosGetInfo(ComPort, @FosStruct, SizeOf(FosStruct), Result, Sig );

  If Result = SizeOf(FosStruct) Then
    VFosGetFosStruct := ferr_None
  Else
    VFosGetFosStruct := ferr_BadCopy;

END;

{}

(*-

[FUNCTION]

Procedure VX00ActivatePort(            ComPort      : WORD;
                                   Var Sig          : WORD;
                                   Var MaxFunc      : BYTE;
                                   Var FosRev       : BYTE     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

Sig         Signature of communications driver installed.
MaxFunc     Number of functions supported by driver.
FosRev      Revision of the installed FOSSIL specification.

[DESCRIPTION]

Activates a port as VFosActivatePort does.

[SEE-ALSO]

VFosActivePort

[EXAMPLE]

-*)

Procedure VX00ActivatePort(            ComPort      : WORD;
                                   Var Sig          : WORD;
                                   Var MaxFunc      : BYTE;
                                   Var FosRev       : BYTE     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $1C;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  Sig     := R.AX;
  MaxFunc := R.BL;
  FosRev  := R.BH;

END;

{}

(*-

[FUNCTION]

Procedure VX00DeActivatePort(          ComPort      : WORD     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

[DESCRIPTION]

Deactivates a port as VFosDeActivatePort does.

[SEE-ALSO]

VFosDeActivatePort

[EXAMPLE]

-*)

Procedure VX00DeActivatePort(          ComPort      : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $1D;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}

(*-

[FUNCTION]

Procedure VX00SetExtLineCtrl(          ComPort      : WORD;
                                       Break        : BOOLEAN;
                                       ParityB      : BYTE;
                                       StopBits     : BYTE;
                                       DataBits     : BYTE;
                                       BaudRateB    : BYTE;
                                   Var PortStat     : WORD     );

[PARAMETERS]

ComPort     Communications port.
ParityB     Parity of hardware error checking
StopBits    Number of stop bits
DataBits    Number of data bits
BaudRate    Bits per second rate

[RETURNS]

PortStat    Condition of UART (Low Byte=MSR, High Byte=LSR)

[DESCRIPTION]

Performs an extended line control initialization using ordinal values for
parameters as defined:

  Parity:   0 = None, 1 = Odd, 2 = Even, 3 = Mark (1), 4 = Space (0)
  Stopbits: 0 = One stop,
            1 = Two stops for 6,7 and 8 bits; and, 1.5 stops for 5 bits
  Databits: 0 = 5 bits, 1 = 6 bits, 2 = 7 bits, 3 = 8 bits
  Baudrate: 0..8 = 110, 150, 300, 600, 1200, 2400, 4800, 9600, 19200.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VX00SetExtLineCtrl(          ComPort      : WORD;
                                       Break        : BOOLEAN;
                                       ParityB      : BYTE;
                                       StopBits     : BYTE;
                                       DataBits     : BYTE;
                                       BaudRateB    : BYTE;
                                   Var PortStat     : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $1E;
  R.AL := Byte(Break);
  R.BH := ParityB;
  R.BL := StopBits;
  R.CH := DataBits;
  R.CL := BaudRateB;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  PortStat := R.AX;

END;

{}

(*-

[FUNCTION]

Procedure VX00ExtGetMCR(               ComPort      : WORD;
                                   Var MCRStat      : BYTE;
                                   Var PortStat     : WORD     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

MCRStat     Condition of MCR.
PortStat    Condition of UART (Low Byte=MSR, High Byte=LSR).

[DESCRIPTION]

Performs an extended serial port MCR (status/control) read operation.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VX00ExtGetMCR(               ComPort      : WORD;
                                   Var MCRStat      : BYTE;
                                   Var PortStat     : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $1F;
  R.AL := $00;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  MCRStat := R.BL;
  PortStat := R.AX;

END;

{}

(*-

[FUNCTION]

Procedure VX00ExtSetMCR(               ComPort      : WORD;
                                       MCRStat      : BYTE;
                                   Var PortStat     : WORD     );

[PARAMETERS]

ComPort     Communications port.
MCRStat     Condition of MCR.

[RETURNS]

PortStat    Condition of UART (Low Byte=MSR, High Byte=LSR).

[DESCRIPTION]

Performs an extended serial port MCR (status/control) write operation.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VX00ExtSetMCR(               ComPort      : WORD;
                                       MCRStat      : BYTE;
                                   Var PortStat     : WORD     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $1F;
  R.AL := $01;
  R.BL := MCRStat;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  PortStat := R.AX;

END;

{}

(*-

[FUNCTION]

Procedure VX00RecvCh(                  ComPort      : WORD;
                                   Var Result       : BOOLEAN;
                                   Var Ch           : CHAR     );

[PARAMETERS]

ComPort     Communications port.

[RETURNS]

Result      True if Ch holds a new character.
Ch          Character to receive.

[DESCRIPTION]

Reads a character from the receive buffer with no wait (destructive).  Works
the same as VFosPeekAhead except the character is removed from the receive
buffer.

[SEE-ALSO]

[EXAMPLE]

VFosPeekAhead

-*)

Procedure VX00RecvCh(                  ComPort      : WORD;
                                   Var Result       : BOOLEAN;
                                   Var Ch           : CHAR     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $20;
  R.DX := ComPort;

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

  Ch := Char( R.AL );
  Result := ( R.AH = $00 );

END;

{}

(*-

[FUNCTION]

Procedure VX00StuffInBuff(             Ch           : CHAR     );

[PARAMETERS]

Ch          Character to put into the receive buffer.

[RETURNS]

[DESCRIPTION]

Stuffs/Pokes a character into (at the end of) the receive buffer.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VX00StuffInBuff(             Ch           : CHAR     );

Var

  R : REGISTERS;

BEGIN

  R.AH := $20;
  R.AL := Byte( Ch );

  R.DS := 0;
  R.ES := 0;

  Intr( $14, R );

END;

{}
{}
{}

Procedure FosSerDriverProc( SDP : PSerDriverPacket );

Var

  IData : PFosIData;

  {---------------------}
  { Temporary variables }
  {---------------------}

  teB1,
  teB2  : BYTE;

  teW1,
  teW2  : WORD;

  tebool : BOOLEAN;

  {-----------------------------------------------------}

  Procedure MyGetBuffInfo( BuffType : BYTE );

  Var

    fs : TFosStruct;

  BEGIN

    If VFosGetFosStruct( IData^.ComPort, fs )=0 Then
    BEGIN

      Case BuffType of

        1 :
        BEGIN

          if fs.ifree<>4096 then
            fs:=fs;

          SDP^.BuffInfo.Size       := fs.IBufSize;
          SDP^.BuffInfo.Used       := fs.IBufSize-fs.IFree;
          SDP^.BuffInfo.Free       := fs.IFree;
          SDP^.BuffInfo.Changeable := FALSE;

          SDP^.Error         := 0;

        END;

        2 :
        BEGIN

          SDP^.BuffInfo.Size       := fs.OBufSize;
          SDP^.BuffInfo.Used       := fs.OBufSize-Fs.OFree;
          SDP^.BuffInfo.Free       := fs.OFree;
          SDP^.BuffInfo.Changeable := FALSE;

          SDP^.Error         := 0;

        END;

      ELSE

        SDP^.Error := $FFFF0000;

      END; { Case BuffType / else }

    END { if vfosgetstruct = 0 }
    ELSE
      SDP^.Error := $FFFF0000;

  END; { MyGetBuffInfo }

  {-----------------------------------------------------}


BEGIN  { FosSerDriverProc }

  IData := SDP^.IData;

  If SDP^.Error = 0 Then
  BEGIN

    Case SDP^.Func of

      {--------}

      SDFDriverNew:
      BEGIN

        IF @SDP^.SerDriverProc = @FosSerDriverProc Then
        BEGIN

          New( IData );

          FillChar( IData^, SizeOf(TFosIData), 0 );

          {--------------------------}
          { build instance data here }
          {--------------------------}

          IData^.ComPort := Pred( SDP^.DriverInfo1 );

          SDP^.IData := IData;

          SDP^.Error := 0;

        END;

      END; { Case SDF_DriverNew }

      {--------}

      SDFDriverOff:
      BEGIN
      END;

      {--------}

      SDFDriverOn:
      BEGIN
      END;

      {--------}

      SDFDriverDispose:
      BEGIN

        {--------------------------------}
        { Resolve any instance data here }
        {--------------------------------}


        {---------------------------}
        { Dispose all instance data }
        {---------------------------}

        If SDP^.IData <> NIL Then
        BEGIN

          Dispose( SDP^.IData );
          SDP^.IData := NIL;

        END;

      END;

      {--------}

      SDFActivate:
      BEGIN

        { clear out error, set comport to proper value }

        SDP^.Error := 0;

        { IData^.ComPort := Pred( SDP^.CommParam^.ComPort ); }

        { try to activate with the X00 enhanced function }

        VX00ActivatePort( IData^.ComPort, IData^.Sig, teB1, teB2 );

        { did we successfully init with the X00 function? }

        IData^.UsingX00 := (IData^.Sig = fosInitSig);

        { if not using x00, try the normal fossil init }

        If Not IData^.UsingX00 Then
        BEGIN

          VFosActivatePort( IData^.ComPort, IData^.Sig, teB1, teB2 );

          { if we still couldn't init, we have an error }

          If IData^.Sig <> fosInitSig Then
            SDP^.Error := $FFFF0000;

        END;

        { if error is still clear, set the comm params }

        If SDP^.Error = 0 Then
        BEGIN

          IData^.BaudRate := SDP^.CommParam^.BaudRate;
          IData^.Parity   := SDP^.CommParam^.Parity;
          IData^.DataBits := SDP^.CommParam^.DataBits;
          IData^.StopBits := SDP^.CommParam^.StopBits;

          VFosSetCommParam( IData^.ComPort,
                            IData^.BaudRate,
                            IData^.Parity,
                            IData^.DataBits,
                            IData^.StopBits,
                            IData^.PortStat );

        END; { if sdp^.error = 0 }

      END; { SDFActivate }

      {--------}

      SDFDeActivate:
      BEGIN

        If IData^.Sig = fosInitSig Then
        BEGIN

          { call the appropriate deactivate function }

          If IData^.UsingX00 Then
            VX00DeActivatePort( IData^.ComPort )
          Else
            VFosDeActivatePort( IData^.ComPort );

          { clear the signature and return "no error" }

          IData^.Sig := 0;

          SDP^.Error := 0;

        END
        Else

          { no valid signature, return an error }

          SDP^.Error := $FFFF0000;

      END; { SDFDeActivatePort }

      {--------}

      SDFSetCommParam:
      BEGIN

        IData^.BaudRate := SDP^.CommParam^.BaudRate;
        IData^.Parity   := SDP^.CommParam^.Parity;
        IData^.DataBits := SDP^.CommParam^.DataBits;
        IData^.StopBits := SDP^.CommParam^.StopBits;

(*
        { x00 extended line control is failing.  I think its }
        { because the port must be activated first.          }

        If IData^.UsingX00 Then  { !! X00's not functioning properly }
        BEGIN

          Case UpCase(IData^.Parity) of

            'N' : teB1 := 0;
            'O' : teB1 := 1;
            'E' : teB1 := 2;
            'M' : teB1 := 3;
            'S' : teB1 := 4;

          End;

          teB2 := Pred( IData^.StopBits );
          teW1 := IData^.DataBits - 5;

          Case IData^.BaudRate of

            110   : teW2 := 0;
            150   : teW2 := 1;
            300   : teW2 := 2;
            600   : teW2 := 3;
            1200  : teW2 := 4;
            2400  : teW2 := 5;
            4800  : teW2 := 6;
            9600  : teW2 := 7;
            19200 : teW2 := 8;

          End;

          VX00SetExtLineCtrl( IData^.ComPort,
{                              SDP^.CommParam^.Break,}
                              FALSE,
                              teB1,
                              teB2,
                              teW1,
                              teW2,
                              IData^.PortStat );


        END
        Else
        BEGIN

*)

          VFosSetCommParam( IData^.ComPort,
                            IData^.BaudRate,
                            IData^.Parity,
                            IData^.DataBits,
                            IData^.StopBits,
                            IData^.PortStat );

(*
        END;
*)

        SDP^.Status := IData^.PortStat;

        SDP^.Error  := 0;

      END;

      {--------}

      SDFGetCommParam:
      BEGIN

        SDP^.CommParam^.BaudRate := IData^.BaudRate;
        SDP^.CommParam^.Parity   := IData^.Parity;
        SDP^.CommParam^.DataBits := IData^.DataBits;
        SDP^.CommParam^.StopBits := IData^.StopBits;

        SDP^.Error := 0;

      END;

      {--------}
      {--------}
      {--------}

      SDFGetFlowConType:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}

      SDFSetFlowConType:
      BEGIN

        VFosSetFlowControl( IData^.ComPort, SDP^.FlowConType );

        SDP^.Error := 0;

      END;

      {--------}

      SDFTurnSendOnOff:
      BEGIN

        If IData^.UsingX00 Then
        BEGIN

          VX00ExtGetMCR(  IData^.ComPort,
                          teB1,
                          IData^.PortStat  );

          If IData^.PortStat = cfPortOK Then
          BEGIN

            If SDP^.OnOff Then
              teB1 := ( teB1 AND (NOT MCRrts) )
            ELSE
              teB1 := ( teB1 OR MCRrts );


            VX00ExtSetMCR(  IData^.ComPort,
                            teB1,
                            IData^.PortStat  );

          END;

          SDP^.Error  := 0;
          SDP^.Status := IData^.PortStat;

        END
        Else
        BEGIN

          { cant do this on non x00 fossils }

          SDP^.Error := $FFFF0000;

        END;

      END; { SDFTurnSendOnOff }

      {--------}

      SDFTurnReceiveOnOff:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}

      sdfGetFlowConChars:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}

      sdfSetFlowConChars:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}
      {--------}
      {--------}

      sdfGetLineControl:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}

      sdfGetLineStatus:
      BEGIN

        VFosGetPortStat( IData^.ComPort, IData^.PortStat );

        SDP^.Status := IData^.PortStat;
        SDP^.Error  := 0;

      END;

      {--------}

      sdfGetModemControl:
      BEGIN

        If IData^.UsingX00 Then
        BEGIN

          VX00ExtGetMCR(  IData^.ComPort,
                          teB1,
                          IData^.PortStat  );

          SDP^.Error := 0;
          SDP^.Val   := teb1;

        END
        ELSE
          SDP^.Error := $FFFF0000;

      END;

      {--------}

      sdfGetModemStatus:
      BEGIN

        VFosGetPortStat( IData^.ComPort, IData^.PortStat );

        SDP^.Status := IData^.PortStat;
        SDP^.Error  := 0;

      END;

      {--------}

      sdfGetBothStatus:
      BEGIN

        {---------------------------}
        { set first 16 LSR/MSR bits }
        {---------------------------}
(*
        IData^.PortStat := SDP^.Status AND $FFFF;

        VFosGetPortStat( IData^.ComPort, IData^.PortStat );

        SDP^.Status := (SDP^.Status AND NOT $FFFF) + IData^.PortStat;
*)

        VFosGetPortStat( IData^.ComPort, IData^.PortStat );

        SDP^.Status := IData^.PortStat;
        SDP^.Error  := 0;

        {----------------------}
        { set rest of bitfield }
        {----------------------}

      END;

      {--------}
      {--------}
      {--------}

      SDFDTROnOff:
      BEGIN

        VFosSetDTR( IData^.ComPort, SDP^.OnOff );

        SDP^.Error := 0;

      END;

      {--------}

      SDFBreakOnOff:
      BEGIN

        VFosSetBreak( IData^.ComPort, SDP^.OnOff );

        SDP^.Error := 0;

      END;

      {--------}

      SDFRTSOnOff:
      BEGIN

        If IData^.UsingX00 Then
        BEGIN

          VX00ExtGetMCR(  IData^.ComPort,
                          teB1,
                          IData^.PortStat  );

          If IData^.PortStat = cfPortOK Then
          BEGIN

            If SDP^.OnOff Then
              teB1 := ( teB1 AND (NOT MCRrts) )
            ELSE
              teB1 := ( teB1 OR MCRrts );


            VX00ExtSetMCR(  IData^.ComPort,
                            teB1,
                            IData^.PortStat  );

          END;

          SDP^.Error  := 0;
          SDP^.Status := IData^.PortStat;

        END
        Else
        BEGIN

          { cant do this on non x00 fossils }

          SDP^.Error := $FFFF0000;

        END;

      END;

      {--------}
      {--------}
      {--------}


      SDFFlushOutBuff:
      BEGIN

        VFosFlushOutBuff( IData^.ComPort );

        SDP^.Error := 0;

      END;

      {--------}

      SDFPurgeOutBuff:
      BEGIN

        VFosPurgeOutBuff( IData^.ComPort );

        SDP^.Error := 0;

      END;

      {--------}

      SDFPurgeInBuff:
      BEGIN

        VFosPurgeInBuff( IData^.ComPort );

        SDP^.Error := 0;

      END;

      {--------}

      sdfGetOutBuffInfo:
      BEGIN

        MyGetBuffInfo( 2 );

      END;

      {--------}

      sdfSetOutBuffInfo:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}

      sdfGetInBuffInfo:
      BEGIN

        MyGetBuffInfo( 1 );

      END;

      {--------}

      sdfSetInBuffInfo:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}
      {--------}
      {--------}


      SDFEventProcNew:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}

      SDFEventProcOff:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}

      SDFEventProcOn:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}

      SDFEventProcDispose:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}

      sdfEventProcMaskSet:
      BEGIN

        SDP^.Error := $FFFF0000;

      END;

      {--------}
      {--------}
      {--------}

      SDFWriteCh:
      BEGIN

        SDP^.Error := 0;

        VFosSendChar( IData^.ComPort, SDP^.Ch, Boolean(teB1) );

        If teB1 <> 0 Then
          SDP^.Error := $FFFF;

      END;

      {--------}

      SDFWriteBlock:
      BEGIN

        VFosSendBlock( IData^.ComPort,
                       SDP^.Buf,
                       SDP^.Count,
                       SDP^.Result );

        SDP^.Error := 0;

      END;

      {--------}

      SDFReadCh:
      BEGIN

        SDP^.Error := 0;

        IData^.UsingX00 := FALSE;

        If IData^.UsingX00 Then
        BEGIN

          VX00RecvCh( IData^.ComPort, Boolean(teB1), SDP^.Ch );

          If teB1 = 0 Then
            SDP^.Error := $FFFF;

        END
        Else
          VFosRecvCharW( IData^.ComPort, SDP^.Ch, IData^.PortStat );

      END;

      {--------}

      SDFReadBlock:
      BEGIN

        VFosRecvBlock( IData^.ComPort,
                       SDP^.Buf,
                       SDP^.Count,
                       SDP^.Result );

        SDP^.Error := 0;

      END;

      {--------}

      sdfPeekCh:
      BEGIN

        VFosPeekAhead( Idata^.ComPort,
                       tebool,
                       SDP^.Ch          );

        IF Tebool Then
          SDP^.Error := $FFFF
        Else
          SDP^.Error := 0;

      END;

      {--------}

    End;

  END;

END;

{}
{}
{}

BEGIN
END.
