{


 Visionix General Functions Unit (VGEN)
   Version 0.47
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED



 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 jrt       12/28/93  Added BoolToStr, BoolToYn, BoolToOnOff.

 jrt       11/02/93  Moved most string functions to VStringu;
                     Moved sort stuff to VSortu;
                     added (but didn't finish) GetJump, LongJump,
                     EnableInts, DisableInts, PushXXX, PopXXX.

 jrt       10/24/93  Reintroduced GetNextTwirlyChar

 bpl       09/30/93  Changed IsAlpha,IsAlphaNum,IsGrammer,IsUpCase, IsLoCase
                     to include full alphabet of foreign characters.

 jrt       07/10/93  Added IntToBase, BaseToInt, BaseToBase,
                     IntToBigNum, BigNumToInt.  ASMed ByteToBin.

 mep       05/17/93  Added PosBuf and PosBufNoCase

 jrt       05/15/93  Sync for BETA 0.21; Imported Trunc... funcs, GetQuote

 mep       04/25/93  Added PtrDiff.

 rob			 04/22/93  Added WordWrap.

 mep       04/04/93  Now Sort works with ShortInt, Byte, Integer, Word,
                     LongInt, String, PString, Real, and "User-supplied"
                     arrays (ie. Records).

 mep       03/29/93  Now uses TDecHex in VTypes.
                     Renamed PurgeTypeAheadBuffer to PurgeKbdBuf.

 mep       03/26/93  Now works with VBios.

 lpg       03/12/93  Completed Source Code Commenting

 lpg       03/11/93  Fixed Bug in BinToChar, IsHexByte
                     Added: HexToDecStr
                     Modified: DecToHexStr

 lpg       03/11/93  Added Source Commenting

 jrt       03/08/93  Moved DOS functions into unit VDOSHIGH

 jrt       02/15/93  Documentation integration and misc changes.
                       Renamed FirstString --> ProperString

 mep       02/11/93  Cleaned up code for beta release
                     Fixed SetKeyRate and DisketteStatus for DPMI mode.

 jrt       2/08/93   Sync with Beta 0.12

 mep       2/02/93   Added: DecToHexStr

 mep       1/31/93   Added: FileCRC32, CRC32String, FileCRC16,
                       and CRC16String.
                     Changed CRC32 to CRC32Char and CRC32Buffer.
                     Changed CRC16 to CRC16Char and CRC16Buffer.

 lpg       1/12/92   Modified: Trim
                     Added: TrimChar
                     Updated: DisketteStatus

 mep       1/2/93    Fixed: DeleteChars, UpperString, FirstString, PosCount,
                       StrToAsciiZ, AsciiZtoStr, Sort, PurgeTypeAheadBuffer.
                     Added: FillWord, KeyboardOff, KeyboardOn.

 lpg       12/27/92  Cleaned up unnecessary Code

 mep       12/22/92  Fixed PosNext, PosNextDelimit - TP70 bug.
                     Added: UnPutDot, PosAfter and PosBefore.

 mep       12/19/92  Fixed AddCommas.

 mep       12/16/92  Fixed FileExist only include file types
                       (not Directory and VolumeID).
                     Added: AddCommas.

 jrt       12/15/92  Changes for bp 7.0:
                       Added code to linear<-->ptr functions to support
                       pascal 7.0; changed PurgeTypeAheadBuffer to use
                       Seg0040 constant instead of direct value.

 mep       12/09/92  Fixed InDir, PutSlash, FileExist, GetFileTime,
                       GetFileSize, DirEmpty.
                     Added: TakeWord, TakeQuote, UnPutSlash, and MkSubDir.

 mep       12/08/92  Fixed CRC32 to work correctly.
                     Added credits at end of unit.

 jrt       12/07/92  Sync with beta 0.11 release

 mep       12/06/92  Made CompareSmaller assembly.
                     Fixed Sort, PutSlash, SwapBuffers.
                     Added: CopyOverStr, PosCount;

 jrt       12/02/92  Added: PtrToLin, LinToPtr, Ptr math functions,
                       NewString and DisposeString.

 mep       12/01/92  Added: CopyStr, PutSlash, PutDot, FileExist, GetFileTime,
                       GetFileAttr, GetFileSize, DirExist, DirEmpty,
                       PredDir, InDir, MaskWildcards

 mep       11/30/92  Sync update. Beta 0.10

 mep       11/29/92  Sync update.
                     Changed: SwapBuffers, Compare, CompareSmaller

 lpg       11/28/92  Added: DecToBCD, BCDtoDec, ByteToBCD, BCDtoByte,
                       WordToBCD, BCDtoWord, GetDOSVersion, DisketteStatus,
                       and FloppyReady.

 mep       11/25/92  Overlooked code and updated few bugs.
                     Cleaned-up code.
                     Re-implemented FastCompare.

 jrt       11/21/92  Sync with beta 0.08

 lpg       11/19/92  Corrected LowerChar, ArrayZtoStr, StrToArrayZ

 lpg       11/19/92  Added: ByteToBin, IntToBin, WordToBin, LongToBin,
                       BinToChar, BinToByte, BinToInt, BinToWord, BinToLong

 jrt       11/18/92  Got rid of swapNoBuff functions; set greater/lesser
                       code back to pascal on funcs that deal with signed
                       values

 jrt       11/11/92  Converted Swap funcs and Greater/lesser funcs to
                       asm code for performance.

 lpg       11/10/92  Added ValidByte, ValidInt, ValidLong, ValidFloat,
                       ValidSci, ValidHexByte, ValidHexWord, ValidHex.

 mep       11/06/92  Changed PosNextField to return SubS if '=' not found.

 lpg       11/01/92  Added Dollar Conversion Functions

 lpg       10/19/92  Moved Date/Time functions to VDATES

 lpg       10/18/92  Added IncTime, DecTime, IncDate, DecDate, IncDateTime,
                       DecDateTime, AddTime, SubTime, AddDate, SubDate,
                       AddDateTime, SubDateTime, SoundexPack, SoundexUnPack

 lpg       10/08/92  Added MarkTime, Modified ClockOn/Off to use MarkTime
                       SwapByteNoBuff, SwapIntNoBuff, SwapWordNoBuff,
                       PosNextDelimit

 mep       10/06/92  Fixed Sort for ANY type.
                     Removed CompareBytes - now use CompareBuffers.
                     Removed FastCompare - now use Compare
                     Updated SwapBuffers.

 mep       10/03/92  Added NEW functions:
                       GetCurrDateTime, DateTimeOK, DateTimeStr, StrDateTime,
                       DateTimeLinear, LinearDateTime, PosNext, PosNextField,
                       PosNextData, Compare, SetKeyRate, SetKeyFast,
                       FirstString, PurgeTypeAheadBuffer,
                       CRC16, CRC32, Sort, SwapBuffers, CompareBuffers.

                     Organization of code.

                     Changed functions:
                       StrToArray, StrToArrayZ, ArrayZtoStr

 lpg       10/01/92  Added More Functions.

 jrt       09/01/92  First logged revision.



NOT DONE:

  Function DecToHexStr(                S         : STRING   ) : STRING;

}

(*-

[SECTION: Section 1: The General Libraries]
[CHAPTER: Chapter 1: The General Functions Libraries]

[TEXT]

<Overview>

The general functions unit consists of functions which fall into 8
categories:


  - Validation routines

  - Type conversion

  - Variable comparing and swapping

  - System and CPU

  - CRC

  - Soundex functions

  - Pointer functions

  - Misc. functions


<Interface>

-*)

Unit VGenu;

Interface

Uses

  DOS,
{$IFNDEF OS2}
  VBiosu,
{$ENDIF}
  VTypesu;

{}

Type

  TCharArrayZ = Array[0..64000] of CHAR;

Type

  TJumpInfo = RECORD

    BP     : WORD;
    IP     : WORD;
    CS     : WORD;
    SP     : WORD;

  END;

  PJumpInfo = TJumpInfo;

Const

  cTwirlyString : STRING[8] = '|/-\|/-\';
  cTwirlyCurPos : BYTE = 1;

{}


{---------------------}
{ Validation Routines }
{---------------------}

Function  ValidByte(              S             : STRING        ) : BOOLEAN;

Function  ValidInt(               S             : STRING        ) : BOOLEAN;

Function  ValidLong(              S             : STRING        ) : BOOLEAN;

Function  ValidFloat(             S             : STRING        ) : BOOLEAN;

Function  ValidSci(               S             : STRING        ) : BOOLEAN;

Function  ValidHexByte(           S             : STRING        ) : BOOLEAN;

Function  ValidHexWord(           S             : STRING        ) : BOOLEAN;

Function  ValidHex(               S             : STRING        ) : BOOLEAN;


Function  IsAlpha(                C             : CHAR          ) : BOOLEAN;

Function  IsNum(                  C             : CHAR          ) : BOOLEAN;

Function  IsAlphaNum(             C             : CHAR          ) : BOOLEAN;

Function  IsUpCase(               C             : CHAR          ) : BOOLEAN;

Function  IsLoCase(               C             : CHAR          ) : BOOLEAN;

Function  IsGrammar(              C             : CHAR          ) : BOOLEAN;

Function  IsCtrl(                 C             : CHAR          ) : BOOLEAN;

Function  IsBorder(               C             : CHAR          ) : BOOLEAN;

Function  IsLang(                 C             : CHAR          ) : BOOLEAN;

Function  IsSymbol(               C             : CHAR          ) : BOOLEAN;


{------------------}
{ Type Conversions }
{------------------}

Function  IntToBase(              Base          : BYTE;
                                  Int           : LONGINT    ) : STRING;

Function  BaseToInt(              Base          : BYTE;
                                  S             : STRING     ) : LONGINT;

Function  BaseToBase(             InBase        : BYTE;
                                  InVal         : STRING;
                                  OutBase       : BYTE       ) : STRING;


Function  IntToStr(               L             : LONGINT       ) : STRING;

Function  StrToInt(               S             : STRING        ) : LONGINT;

Function  RealToStr(              R             : REAL;
                                  Field         : INTEGER;
                                  Decimals      : INTEGER       ) : STRING;

Function  StrToReal(              S             : STRING        ) : REAL;

Function  SciToStr(               R             : REAL          ) : STRING;

Function  StrToSci(               S             : STRING        ) : REAL;

Function  IntToText(              L             : LONGINT       ) : ST80;

Function  LongToDollars(          L             : LONGINT       ) : REAL;

Function  DollarsToLong(          R             : REAL          ) : LONGINT;

Function  BoolToStr(              Bool          : BOOLEAN;
                                  TrueStr       : STRING;
                                  FalseStr      : STRING        ) : STRING;


{------------------}
{ BigNum Functions }
{------------------}

Function  IntToBigNum(            L             : LONGINT       ) : STRING;

Function  BigNumToInt(            S             : STRING        ) : LONGINT;




{---------------}
{ Hex functions }
{---------------}

Function  CharToHex(              C             : SHORTINT      ) : ST80;

Function  ByteToHex(              B             : BYTE          ) : ST80;

Function  IntToHex(               I             : INTEGER       ) : ST80;

Function  WordToHex(              W             : WORD          ) : ST80;

Function  PtrToHex(               P             : POINTER       ) : ST80;

Function  LongToHex(              L             : LONGINT       ) : ST80;

Function  DecToHexStr(            S             : STRING        ) : STRING;

Function  HexToDecStr(            S             : STRING        ) : STRING;

Function  HexToChar(              S             : ST80          ) : SHORTINT;

Function  HexToByte(              S             : ST80          ) : BYTE;

Function  HexToInt(               S             : ST80          ) : INTEGER;

Function  HexToWord(              S             : ST80          ) : WORD;

Function  HexToLong(              S             : ST80          ) : LONGINT;


{------------------}
{ Binary Functions }
{------------------}

Function  ByteToBin(              B             : BYTE          ) : ST80;

Function  IntToBin(               I             : INTEGER       ) : ST80;

Function  WordToBin(              W             : WORD          ) : ST80;

Function  LongToBin(              L             : LONGINT       ) : ST80;


Function  BinToChar(              S             : ST80          ) : SHORTINT;

Function  BinToByte(              S             : ST80          ) : BYTE;

Function  BinToInt(               S             : ST80          ) : INTEGER;

Function  BinToWord(              S             : ST80          ) : WORD;

Function  BinToLong(              S             : ST80          ) : LONGINT;


{-----------------}
{ BCD Conversions }
{-----------------}

Function  DecToBCD(               Decimal       : BYTE          ) : BYTE;

Function  BCDtoDec(               Bcd           : BYTE          ) : BYTE;

Function  ByteToBCD(              Decimal       : BYTE          ) : WORD;

Function  BCDtoByte(              Bcd           : WORD          ) : BYTE;

Function  WordToBCD(              Decimal       : WORD          ) : LONGINT;

Function  BCDtoWord(              Bcd           : LONGINT       ) : WORD;



{---------------------------------}
{ Variable Comparing and swapping }
{---------------------------------}

Function  FastCompare(        Var Buf1;
                              Var Buf2;
                                  Count         : WORD          ) : WORD;

Function  Compare(            Var Buf1;
                              Var Buf2;
                                  Count         : WORD          ) : WORD;

Function  CompareSmaller(     Var Buf1;
                              Var Buf2;
                                  Count         : WORD          ) : SHORTINT;

Function  CompareBufByte(     Var Buff;
                                  Count         : WORD;
                                  B             : BYTE          ) : WORD;

Function  CompareBufWord(     Var Buff;
                                  Count         : WORD;
                                  W             : WORD          ) : WORD;

Function  LookupByte(             InByte        : BYTE;
                                  Count         : WORD;
                              Var LTable;
                              Var OutByte       : BYTE          ) : BOOLEAN;

Function  LookupWord(             InWord        : WORD;
                                  Count         : WORD;
                              Var LTable;
                              Var OutWord       : WORD          ) : BOOLEAN;

Procedure SwapBuffers(        Var Buf1;
                              Var Buf2;
                                  Count         : WORD          );

Procedure SwapWords(          Var A,
                                  B             : WORD          );

Procedure SwapInts(           Var A,
                                  B             : INTEGER       );

Procedure SwapBytes(          Var A,
                                  B             : BYTE          );

Function  GreaterInt(             A,
                                  B             : INTEGER       ) : INTEGER;

Function  GreaterWord(            A,
                                  B             : WORD          ) : WORD;

Function  GreaterLong(            A,
                                  B             : LONGINT       ) : LONGINT;

Function  LesserInt(              A,
                                  B             : INTEGER       ) : INTEGER;

Function  LesserWord(             A,
                                  B             : WORD          ) : WORD;

Function  LesserLong(             A,
                                  B             : LONGINT       ) : LONGINT;

Procedure FillWord(           Var Buf;
                                  Count         : WORD;
                                  Value         : WORD          );

Procedure FillLong(           Var Buf;
                                  Count         : WORD;
                                  Value         : LONGINT       );

{----------------}
{ System and CPU }
{----------------}

Procedure RebootMachine(          WarmBoot      : BOOLEAN       );


{---------------}
{ CRC Functions }
{---------------}

Procedure CRC16Char(          Var Ch            : CHAR;
                              Var Result        : WORD          );

Procedure CRC16Buffer(        Var Buf;
                                  Count         : WORD;
                              Var Result        : WORD          );

Procedure CRC32Char(          Var Ch            : CHAR;
                              Var Result        : LONGINT       );

Procedure CRC32Buffer(        Var Buf;
                                  Count         : WORD;
                              Var Result        : LONGINT       );

{-------------------}
{ Soundex functions }
{-------------------}

Function  SoundexPack(            S             : STRING        ) : WORD;

Function  SoundexUnPack(          W             : WORD          ) : STRING;

Function  SoundexStr(             S             : STRING        ) : STRING;

{----------------------------------}
{ Pointer / Pointer math functions }
{----------------------------------}

Function  PtrToLin(               Ptr           : POINTER       ) : LONGINT;

Function  LinToPtr(               Lin           : LONGINT       ) : POINTER;

Function  PtrAdd(                 OrigPtr       : POINTER;
                                  AddOfs        : LONGINT       ) : POINTER;

Function  PtrSub(                 OrigPtr       : POINTER;
                                  SubOfs        : LONGINT       ) : POINTER;

Function  PtrDiff(                A             : POINTER;
                                  B             : POINTER       ) : LONGINT;


{--------------------------------}
{ "inline" / low-level functions }
{--------------------------------}

Procedure FarCall(                Proc          : POINTER       );


Procedure SetJump(                JumpInfo      : PJumpInfo     );


Procedure LongJump(               JumpInfo      : PJumpInfo     );


Procedure EnableInts;

Procedure DisableInts;

Procedure PushWord(               W             : WORD          );

Procedure PushLong(               L             : LONGINT       );

Procedure PushPtr(                P             : POINTER       );

Function  PopWord : WORD;
Function  PopLong : LONGINT;
Function  PopPtr  : POINTER;


{----------------}
{ Misc functions }
{----------------}

Procedure BufferSRByte(    Buffer         : POINTER;
                           BuffSize       : WORD;
                           ByteToLookfor  : BYTE;
                           ReplaceWith    : BYTE      );

Function  GetNextTwirlyChar : CHAR;



{}


IMPLEMENTATION

Var

  StartClock : REAL;


(*-

[FUNCTION]

Function  ValidByte(                 S         : STRING  ) : BOOLEAN;

[PARAMETERS]

S           String representing a byte value

[RETURNS]

Whether that string did represent a byte value

[DESCRIPTION]

Returns whether or not the given String represents a Valid Byte
Value.

[SEE-ALSO]

ValidInt      ValidLong     ValidFlot    ValidSci
ValidHexByte  ValidHexWord  ValidHex

[EXAMPLE]

BEGIN

  WriteLn( ValidByte( '123' ) );  { TRUE  }
  WriteLn( ValidByte( '345' ) );  { FALSE }
  WriteLn( ValidByte( 'abc' ) );  { FALSE }

END;

-*)


Function ValidByte(          S         : STRING       ) : BOOLEAN;

Var

  B : BYTE;
  E : INTEGER;

BEGIN

  Val( S, B, E );
  ValidByte := E = 0;

END;  { ValidByte }

{}

(*-

[FUNCTION]

Function  ValidInt(                  S         : STRING  ) : BOOLEAN;

[PARAMETERS]

S           String representing a Signed Integer value (Word)

[RETURNS]

Whether that string did represent a signed integer value

[DESCRIPTION]

Returns whether or not the given String represents a Valid
Integer Value.

[SEE-ALSO]

ValidByte
ValidLong
ValidFloat
ValidSci
ValidHexByte
ValidHexWord
ValidHex

[EXAMPLE]

BEGIN

  WriteLn( ValidInt( '12345'  ) );  { TRUE  }
  WriteLn( ValidInt( '123456' ) );  { FALSE }
  WriteLn( ValidInt( 'abcdef' ) );  { FALSE }

END;

-*)


Function ValidInt(           S         : STRING       ) : BOOLEAN;

Var

  I : INTEGER;
  E : INTEGER;

BEGIN

  Val( S, I, E );
  ValidInt := E = 0;

END;  { ValidInt }

{}

(*-

[FUNCTION]

Function  ValidLong(                 S         : STRING  ) : BOOLEAN;

[PARAMETERS]
S           String representing a Signed Longint value (Double Word)

[RETURNS]

Whether that string did represent a signed longint value

[DESCRIPTION]

Returns whether or not the given String represents a Valid
Long Integer Value.

[SEE-ALSO]

ValidByte
ValidInt
ValidFloat
ValidSci
ValidHexByte
ValidHexWord
ValidHex

[EXAMPLE]

BEGIN

  WriteLn( ValidLong( '12345678'     ) );  { TRUE }
  WriteLn( ValidLong( '999999999999' ) );  { FALSE }
  WriteLn( ValidLong( 'abcdefgh'     ) );  { FALSE }

END;

-*)


Function ValidLong(          S         : STRING       ) : BOOLEAN;

Var

  L : LONGINT;
  E : INTEGER;

BEGIN

  Val( S, L, E );
  ValidLong := E = 0;

END;  { ValidLong }

{}

(*-

[FUNCTION]

Function  ValidFloat(                S         : STRING  ) : BOOLEAN;

[PARAMETERS]

S           String value representing a floating point value

[RETURNS]

Whether that string did represent a floating point value

[DESCRIPTION]

Returns whether or not the given String represents a Valid
Floating Point Value.

[SEE-ALSO]

ValidByte
ValidInt
ValidLong
ValidSci
ValidHexByte
ValidHexWord
ValidHex

[EXAMPLE]

BEGIN

  WriteLn( ValidFloat( '123.456' ) );  { TRUE  }
  WriteLn( ValidFloat( 'abcdefg' ) );  { FALSE }

END;

-*)

Function ValidFloat(         S         : STRING       ) : BOOLEAN;

Var

  R : REAL;
  E : INTEGER;

BEGIN

  Val( S, R, E );
  ValidFloat := E = 0;

END;  { ValidFloat }

{}

(*-

[FUNCTION]

Function  ValidSci(                  S         : STRING  ) : BOOLEAN;

[PARAMETERS]

S           String representing a floating point value in scientific
            notation

[RETURNS]

Whether that string did represent a floating point value in scientific
notation

[DESCRIPTION]

Returns whether or not the given String represents a Valid
Scientific Notation Floating Point Value.

[SEE-ALSO]

ValidByte
ValidInt
ValidLong
ValidFloat
ValidHexByte
ValidHexWord
ValidHex

[EXAMPLE]

BEGIN

  WriteLn( ValidSci( '1.234E10' ) );  { TRUE  }
  WriteLn( ValidSci( '12.34E10' ) );  { TRUE  }
  WriteLn( ValidSci( '1.234E99' ) );  { FALSE }
  WriteLn( ValidSci( '1.234X10' ) );  { FALSE }
  WriteLn( ValidSci( '12345678' ) );  { TRUE  }
  WriteLn( ValidSci( 'abcdefgh' ) );  { FALSE }

END;

-*)

Function ValidSci(           S         : STRING       ) : BOOLEAN;

Var

  R : REAL;
  E : INTEGER;

BEGIN

  Val( S, R, E );
  ValidSci := E = 0;

END;  { ValidSci }

{}

(*-

[FUNCTION]

Function  ValidHexByte(              S         : STRING  ) : BOOLEAN;

[PARAMETERS]

S           String representing Byte value in hex

[RETURNS]

Whether that string did represent a byte value in hex

[DESCRIPTION]

Returns whether or not the given String represents a Valid
Byte in Hexadecimal format.

[SEE-ALSO]

ValidByte
ValidInt
ValidLong
ValidFloat
ValidSci
ValidHexWord
ValidHex

[EXAMPLE]

BEGIN

  WriteLn( Valid( '1A'   ) );  { TRUE  }
  WriteLn( Valid( 'Ff'   ) );  { TRUE  }
  WriteLn( Valid( '1A2b' ) );  { FALSE }
  WriteLn( Valid( 'zyx'  ) );  { FALSE }
  WriteLn( Valid( '2'    ) );  { TRUE  }

END;

-*)


Function ValidHexByte(       S         : STRING       ) : BOOLEAN;

Const

  HexTable = '0123456789ABCDEF';

Var

  OK : BOOLEAN;
  I  : INTEGER;
  L  : INTEGER;

BEGIN

  If Byte(S[0]) = 1 Then
    S := '0' + S;

  I  := 1;
  L  := Byte(S[0]);
  OK := L = 2;

  While ( I <= L ) AND OK Do
  BEGIN

    OK := Pos( UpCase(S[I]), HexTable ) > 0;
    Inc( I );

  END;

  ValidHexByte := OK;

END;  { ValidHexByte }

{}

(*-

[FUNCTION]

Function  ValidHexWord(              S         : STRING  ) : BOOLEAN;

[PARAMETERS]

S           String representing a Word value in hex

[RETURNS]

Whether that string did represent a word value in hex

[DESCRIPTION]

Returns whether or not the given String represents a Valid
Word in Hexadecimal format.

[SEE-ALSO]

ValidByte
ValidInt
ValidLong
ValidFloat
ValidSci
ValidHexByte
ValidHex

[EXAMPLE]

BEGIN

  WriteLn( ValidHexWord( '1A2B'  ) );  { TRUE  }
  WriteLn( ValidHexWord( 'FFFf'  ) );  { TRUE  }
  WriteLn( ValidHexWord( '12345' ) );  { FALSE }
  WriteLn( ValidHexWord( 'zyxw'  ) );  { FALSE }
  WriteLn( ValidHexWord( '12'    ) );  { TRUE  }

END;

-*)

Function ValidHexWord(       S         : STRING       ) : BOOLEAN;

Const

  HexTable = '0123456789ABCDEF';

Var

  OK : BOOLEAN;
  I  : INTEGER;
  L  : INTEGER;

BEGIN

  OK := S <> '';

  While OK AND ( Byte(S[0]) < 4 ) Do
    S := '0' + S;

  I  := 1;
  L  := Byte(S[0]);
  OK := L = 4;

  While ( I <= L ) and OK Do
  BEGIN

    OK := Pos( UpCase(S[I]), HexTable ) > 0;
    Inc(I);

  END;

  ValidHexWord := OK;

END;  { ValidHexWord }

{}

(*-

[FUNCTION]

Function  ValidHex(                  S         : STRING  ) : BOOLEAN;

[PARAMETERS]

S           String representing a Word value in hex

[RETURNS]

Whether that string did represent a word value in hex

[DESCRIPTION]

Returns whether or not the given String represents a Valid
value in Hexadecimal format.  This function doesn't consider
length to be of consideration.  It simply checks that throughout
the entire length of the string, every character is within the
valid range of a Hex character.

[SEE-ALSO]

ValidByte
ValidInt
ValidLong
ValidFloat
ValidSci
ValidHexByte
ValidHex

[EXAMPLE]

BEGIN

  WriteLn( ValidHex( '1D'      ) );  { TRUE  }
  WriteLn( ValidHex( '15DF'    ) );  { TRUE  }
  WriteLn( ValidHex( 'zwyvx'   ) );  { FALSE }
  WriteLn( ValidHex( '153FD85' ) );  { TRUE  }

END;

-*)


Function ValidHex(           S         : STRING       ) : BOOLEAN;

Const

  HexTable = '0123456789ABCDEF';

Var

  OK : BOOLEAN;
  I  : INTEGER;
  L  : INTEGER;

BEGIN

  OK := S <> '';
  I  := 1;
  L  := Byte(S[0]);

  While ( I <= L ) and OK Do
  BEGIN

    OK := Pos( UpCase(S[I]), HexTable ) > 0;
    Inc(I);

  END;

  ValidHex := OK;

END;  { ValidHex }

{}

(*-

[FUNCTION]

Function  IsAlpha(                   C         : CHAR    ) : BOOLEAN;

[PARAMETERS]

Source character to be tested.

[RETURNS]

Was this character an Alphabetic Character?

[DESCRIPTION]

Test char to ensure that it is an alphabetic char and returns the result.
An alphabetic char is defined as... all alphabetic chars (both upper
and lower case) including foreign language inflections.

[SEE-ALSO]

IsNum
IsAlphaNum
IsUpCase
IsLoCase
IsGrammar
IsCtrl
IsBorder
IsLang
IsSymbol

[EXAMPLE]

BEGIN

  WriteLn( IsAlpha( 'a' ) );  { TRUE  }
  WriteLn( IsAlpha( 'A' ) );  { TRUE  }
  WriteLn( IsAlpha( '8' ) );  { FALSE }
  WriteLn( IsAlpha( '-' ) );  { FALSE }
  WriteLn( IsAlpha( '' ) );  { TRUE  - Note: It includes Foreign Text! }
  WriteLn( IsAlpha( '' ) );  { TRUE  }

END;

-*)

{----------------------------------------------------------}
{             Function IsAlpha                             }
{----------------------------------------------------------}
{ IN:  C (CHAR) source character to be tested              }
{ OUT: (BOOLEAN) was this char an alpha character?         }
{ Included in this set are all Foreign Language Text Chars }
{----------------------------------------------------------}

Function IsAlpha(            C         : CHAR         ) : BOOLEAN;

BEGIN

  IsAlpha := ( (Byte( C ) >= $41 ) AND    { A }
               (Byte( C ) <= $5A ) ) OR   { Z }

             ( (Byte( C ) >= $61 ) AND    { a }
               (Byte( C ) <= $7A ) ) OR   { z }

             ( (Byte( C ) >= $80 ) AND    {  }
               (Byte( C ) <= $AF ) ) OR   {  }

             ( (Byte( C ) >= $E0 ) AND    {  }
               (Byte( C ) <= $F1 ) );     {  }

END;

{}

(*-

[FUNCTION]

Function  IsNum(                     C         : CHAR    ) : BOOLEAN;

[PARAMETERS]

C           Source Character to be tested.

[RETURNS]

Whether that character did represent a numeric char

[DESCRIPTION]

Test char to ensure that it is a numeric char and returns the result.
A numeric char is defined as... all chars from ASCII xx to ASCII xx

[SEE-ALSO]

IsAlpha
IsAlphaNum
IsUpCase
IsLoCase
IsGrammar
IsCtrl
IsBorder
IsLang
IsSymbol

[EXAMPLE]

BEGIN

  WriteLn( IsNum( '4' ) );  { TRUE  }
  WriteLn( IsNum( 'K' ) );  { FALSE }
  WriteLn( IsNum( '#' ) );  { FALSE }

END;

-*)

Function IsNum(              C         : CHAR         ) : BOOLEAN;

BEGIN

  IsNum := ( ( Byte( C ) >= $30 ) AND   { 0 }
             ( Byte( C ) <= $39 ) );    { 9 }

END;

{}

(*-

[FUNCTION]

Function  IsAlphaNum(                C         : CHAR    ) : BOOLEAN;

[PARAMETERS]

C           Source Character character to be tested

[RETURNS]

Whether that character did represent an alpha-numeric char

[DESCRIPTION]

Tests char to ensure that it is alpha-numeric and returns result.
An alpha-numeric char is defined as... all numeric and alphbetic
chars (both upper and lower case) including foreign language inflections.

[SEE-ALSO]

IsAlpha
IsNum
IsUpCase
IsLoCase
IsGrammar
IsCtrl
IsBorder
IsLang
IsSymbol

[EXAMPLE]

BEGIN

  WriteLn( IsAlphaNum( 'a' ) );  { TRUE  }
  WriteLn( IsAlphaNum( 'A' ) );  { TRUE  }
  WriteLn( IsAlphaNum( ' ' ) );  { FALSE }
  WriteLn( IsAlphaNum( '4' ) );  { TRUE  }
  WriteLn( IsAlphaNum( '&' ) );  { FALSE }
  WriteLn( IsAlphaNum( '' ) );  { TRUE  }

END;

-*)

Function IsAlphaNum(         C         : CHAR         ) : BOOLEAN;

BEGIN

  IsAlphaNum := ( (Byte( C ) >= $30 ) AND     { 0 }
                  (Byte( C ) <= $39 ) ) OR    { 9 }

                ( (Byte( C ) >= $41 ) AND     { A }
                  (Byte( C ) <= $5A ) ) OR    { Z }

                ( (Byte( C ) >= $61 ) AND     { a }
                  (Byte( C ) <= $7A ) ) OR    { z }

                ( (Byte( C ) >= $80 ) AND     {  }
                  (Byte( C ) <= $AF ) ) OR    {  }

                ( (Byte( C ) >= $E0 ) AND     {  }
                  (Byte( C ) <= $F1 ) );      {  }

END;

{}

(*-

[FUNCTION]

Function  IsUpCase(                  C         : CHAR    ) : BOOLEAN;

[PARAMETERS]

C           Source Character to be tested

[RETURNS]

Whether that character did represent an upper case char of any language

[DESCRIPTION]

Tests char to ensure that it is an upper case char (whether English or
Foreign Inflection) and returns result.

[SEE-ALSO]

IsAlpha
IsNum
IsAlphaNum
IsLoCase
IsGrammar
IsCtrl
IsBorder
IsLang
IsSymbol

[EXAMPLE]

BEGIN

  WriteLn( IsUpCase( 'A' ) );  { TRUE  }
  WriteLn( IsUpCase( 'a' ) );  { FALSE }
  WriteLn( IsUpCase( '' ) );  { FALSE }
  WriteLn( IsUpCase( '' ) );  { TRUE  }
  WriteLn( IsUpCase( '%' ) );  { FALSE }
  WriteLn( IsUpCase( '3' ) );  { FALSE }

END;

-*)


Function IsUpCase(           C         : CHAR         ) : BOOLEAN;

BEGIN

	IsUpCase := ( ( Byte( C ) >= $41 ) AND		 { A }
                      ( Byte( C ) <= $5A ) ) OR 	 { Z }

		    ( ( Byte( C ) >= $80 ) AND		 {  }
		      ( Byte( C ) <= $9F ) ) OR 	 {  }

		      ( Byte( C ) = $F0 );      	 {  }

END;

{}

(*-

[FUNCTION]

Function  IsLoCase(                  C         : CHAR    ) : BOOLEAN;

[PARAMETERS]

C           Source Character to be tested

[RETURNS]

Whether that character did represent a lower case char in any language.

[DESCRIPTION]

Tests char to ensure that it is a lower case char (whether English or
Foreign Imflection) and returns result.

[SEE-ALSO]

IsAlpha
IsNum
IsAlphaNum
IsUpCase
IsGrammar
IsCtrl
IsBorder
IsLang
IsSymbol

[EXAMPLE]

BEGIN

  WriteLn( IsUpCase( 'A' ) );  { FALSE }
  WriteLn( IsUpCase( 'a' ) );  { TRUE  }
  WriteLn( IsUpCase( '' ) );  { TRUE  }
  WriteLn( IsUpCase( '' ) );  { FALSE }
  WriteLn( IsUpCase( '%' ) );  { FALSE }
  WriteLn( IsUpCase( '3' ) );  { FALSE }

END;

-*)


Function IsLoCase(           C         : CHAR         ) : BOOLEAN;

BEGIN

	IsLoCase := ( ( Byte( C ) <= $61 ) AND		 { a }
                      ( Byte( C ) >= $7A ) ) OR 	 { z }

		    ( ( Byte( C ) >= $A0 ) AND		 {  }
		      ( Byte( C ) <= $AF ) ) OR 	 {  }

		    ( ( Byte( C ) >= $E0 ) AND		 {  }
		      ( Byte( C ) <= $EF ) ) OR 	 {  }

		      ( Byte( C ) = $F1 );		 {  }

END;

{}

(*-

[FUNCTION]

Function  IsGrammar(                 C         : CHAR    ) : BOOLEAN;

[PARAMETERS]

C           Source Character to be tested

[RETURNS]

Whether that character did represent a grammar char

[DESCRIPTION]

Tests char to ensure that it is a grammar char and returns result.
This includes all standard grammar symbols as well as all math and
currency symbols.

[SEE-ALSO]

IsAlpha
IsNum
IsAlphaNum
IsUpCase
IsLoCase
IsCtrl
IsBorder
IsLang
IsSymbol

[EXAMPLE]

BEGIN

  WriteLn( IsGrammar( '.' ) );  { TRUE  }
  WriteLn( IsGrammar( '!' ) );  { TRUE  }
  WriteLn( IsGrammar( 'd' ) );  { FALSE }
  WriteLn( IsGrammar( '6' ) );  { FALSE }
  WriteLn( IsGrammar( '&' ) );  { TRUE  }
  WriteLn( IsGrammar( '/' ) );  { TRUE  }

END;

-*)


Function IsGrammar(          C         : CHAR         ) : BOOLEAN;

BEGIN

  IsGrammar := ( (Byte( C ) >= $21 ) AND    { ! }
                 (Byte( C ) <= $2F ) ) OR   { / }

               ( (Byte( C ) >= $3A ) AND    { : }
                 (Byte( C ) <= $40 ) ) OR   { @ }

               ( (Byte( C ) >= $5B ) AND    { [ }
                 (Byte( C ) <= $60 ) ) OR   { ` }

               ( (Byte( C ) >= $7B ) AND    { { }
                 (Byte( C ) <= $7E ) ) OR   { ~ }

	       ( (Byte( C ) >= $9B ) AND    {  }
		 (Byte( C ) <= $9F ) ) OR   {  }

	       (  Byte( C ) =  $A8 )   OR   {  }

	       ( (Byte( C ) >= $AB ) AND    {  }
		 (Byte( C ) <= $AF ) );     {  }

END;

{}

(*-

[FUNCTION]

Function  IsCtrl(                    C         : CHAR    ) : BOOLEAN;

[PARAMETERS]

C           Source Character to be tested.

[RETURNS]

Whether that character did represent a control character

[DESCRIPTION]

Tests char to ensure that it is a control char and returns the result.
A control char is defined as all chars below the ASCII value of 32.

[SEE-ALSO]

IsAlpha
IsNum
IsAlphaNum
IsUpCase
IsLoCase
IsGrammar
IsBorder
IsLang
IsSymbol

[EXAMPLE]

BEGIN

  WriteLn( IsCtrl( #13 ) );  { TRUE  }
  WriteLn( IsCtrl( #26 ) );  { TRUE  }
  WriteLn( IsCtrl( #32 ) );  { FALSE }
  WriteLn( IsCtrl( #97 ) );  { FALSE }

END;

-*)


Function IsCtrl(             C         : CHAR         ) : BOOLEAN;

BEGIN

  IsCtrl := ( Byte( C ) < $20 );

END;

{}

(*-

[FUNCTION]

Function  IsBorder(                  C         : CHAR    ) : BOOLEAN;

[PARAMETERS]

C           Source Character to be tested.

[RETURNS]

Whether that character did represent a border character.

[DESCRIPTION]

Tests char to ensure that it is a border char and returns the result.
A border char is defined as all line drawing chars as well as
non-graphic text chars (vertical bar,plus, and dash) in addition
to solid boxes.

Except where the ASCII value is below 128, these chars are represented
as those that extend and touch the adjacent chars.

[SEE-ALSO]

IsAlpha
IsNum
IsAlphaNum
IsUpCase
IsLoCase
IsGrammar
IsCtrl
IsLang
IsSymbol

[EXAMPLE]

BEGIN

  WriteLn( IsBorder( '' ) );  { TRUE  }
  WriteLn( IsBorder( '' ) );  { TRUE  }
  WriteLn( IsBorder( 'a' ) );  { FALSE }
  WriteLn( IsBorder( '7' ) );  { FALSE }
  WriteLn( IsBorder( '' ) );  { TRUE  }
  WriteLn( IsBorder( '&' ) );  { FALSE }
  WriteLn( IsBorder( '-' ) );  { TRUE  - Text Mode Borders }
  WriteLn( IsBorder( '|' ) );  { TRUE  }
  WriteLn( IsBorder( '+' ) );  { TRUE  }

END;

-*)


Function IsBorder(           C         : CHAR         ) : BOOLEAN;

BEGIN

  IsBorder := ( (Byte( C ) >= $B0 ) AND     {  }
                (Byte( C ) <= $DF ) ) OR    {  }

                (Byte( C )  = $A9 ) OR      {  }

                (Byte( C )  = $AA );        {  }

END;

{}

(*-

[FUNCTION]

Function  IsLang(                    C         : CHAR    ) : BOOLEAN;

[PARAMETERS]

C           Source Character to be tested.

[RETURNS]

Whether that character did represent a Foreign Language character.

[DESCRIPTION]

Test char to ensure that it is a language char and returns the result.
A language char is defined as all Foreign Language Alphbetic chars
(essentially those alpha chars containing foreign language inflections)

[SEE-ALSO]

IsAlpha
IsNum
IsAlphaNum
IsUpCase
IsLoCase
IsGrammar
IsCtrl
IsBorder
IsSymbol

[EXAMPLE]

BEGIN

  WriteLn( IsLang( '' ) );  { TRUE  }
  WriteLn( IsLang( '' ) );  { TRUE  }
  WriteLn( IsLang( 'a' ) );  { FALSE }
  WriteLn( IsLang( 'Q' ) );  { FALSE }
  WriteLn( IsLang( '6' ) );  { FALSE }
  WriteLn( IsLang( '&' ) );  { FALSE }
  WriteLn( IsLang( '' ) );  { FALSE }

END;

-*)


Function IsLang(             C         : CHAR         ) : BOOLEAN;

BEGIN

  IsLang := ( ( Byte( C ) >= $80 ) AND    {  }
              ( Byte( C ) <= $9A ) ) OR   {  }

            ( ( Byte( C ) >= $A0 ) AND    {  }
              ( Byte( C ) <= $A7 ) );     {  }

END;

{}

(*-

[FUNCTION]

Function  IsSymbol(                  C         : CHAR    ) : BOOLEAN;

[PARAMETERS]

C           Character representing a symbol char

[RETURNS]

Whether that character did represent a symbol char

[DESCRIPTION]

Tests char to ensure that it is a symbol char and returns the result.
A border char is defined as all chars excluding the following:
Numeric, Alphabetic (both upper and lower case), all grammar chars,
all border chars, all control characters, and all foreign language
chars.  Basically all misc chars not used by any of the previous tests
and definitions.

[SEE-ALSO]

IsAlpha
IsNum
IsAlphaNum
IsUpCase
IsLoCase
IsGrammar
IsCtrl
IsBorder
IsLang

[EXAMPLE]

BEGIN

  WriteLn( IsSymbol( '' ) );  { TRUE  }
  WriteLn( IsSymbol( 'A' ) );  { FALSE }
  WriteLn( IsSymbol( '6' ) );  { FALSE }
  WriteLn( IsSymbol( '#' ) );  { FALSE }
  WriteLn( IsSymbol( '' ) );  { TRUE  }
  WriteLn( IsSymbol( '' ) );  { FALSE }
  WriteLn( IsSymbol( '' ) );  { TRUE  }

END;

-*)


Function IsSymbol(           C         : CHAR         ) : BOOLEAN;

BEGIN

  IsSymbol := ( Byte( C ) <= $1F ) OR
              ( Byte( C ) >= $E0 );

END;

{}

(*-

[FUNCTION]

Function IntToBase(                  Base      : BYTE;
                                     Int       : LONGINT    ) : STRING;

[PARAMETERS]

Base        Base to convert to
Int         Decimal integer to convert

[RETURNS]

String representation of integer value in the specified base

[DESCRIPTION]

Converts a decimal integer into a string representation of the integer
in the specified base.  Digits are used in the order 0..9..A..Z

[SEE-ALSO]

StrToInt

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := IntToBase( 17, 10 );

  { S = 17 }

  S := IntToBase( 2, 7 );

  { S = 111 }

  S := IntToBase( 16, 255 );

  { S = FF }

  S := IntToBase( 36, 36 );

  { S = '10' }

  S := IntToBase( 36, 36*36 );

  { S = '100' }

  S := IntToBase( 36, 35 );

  { S = Z }

  S := IntToBase( 13, 13+1 );

  { S = '11' }



END;

-*)


Function IntToBase(                  Base      : BYTE;
                                     Int       : LONGINT    ) : STRING;

Const

  TDecBase : Array[0..36] of Char = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';

Var
  S : STRING;
  T : STRING;
  Z : INTEGER;

BEGIN
  S := '';
  While Int <> 0 Do
  BEGIN
    S   := S + TDecBase[ Int MOD Base ];
    Int := Int DIV Base;
  END;

  T[0] := S[0];

  For Z := Length( S ) Downto 1 Do
    T[ Length(S)-Z+1 ] := S[ Z ];

  IntToBase := T;

END; { IntToBase }


{}

(*-

[FUNCTION]

Function BaseToInt(                  Base      : BYTE;
                                     S         : STRING     ) : LONGINT;

[PARAMETERS]

Base        Base to convert from
Int         String representation of a value in base "base"

[RETURNS]

decimal integer equivalent of "S" from the specified base

[DESCRIPTION]

Converts a string representation of a value in the specified base to
a decimal integer.  Digits are used in the order 0..9..A..Z

[SEE-ALSO]

StrToInt

[EXAMPLE]

VAR
  Z : INTEGER;

BEGIN

  Z := BaseToInt( 36, '10' );

  { Z = 36 }

  Z := BaseToInt( 36, '100' );

  { Z = 1296 (36*36) }

  Z := BaseToInt( 13, '11' );

  { Z = 14 (13+1) }


END;

-*)


Function BaseToInt(                  Base      : BYTE;
                                     S         : STRING     ) : LONGINT;

Const

  TDecBase : Array[0..36] of Char = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';

Var

  DigitVal : LONGINT;
  Z        : INTEGER;
  Res      : LONGINT;

BEGIN

  Digitval := 1;
  Res      := 0;

  For Z := Length( S ) Downto 1 Do
  BEGIN

    Res := Res + ( (Pos( S[Z], TDecBase )-1) * DigitVal );

    DigitVal := Digitval * Base;

  END;

  BaseToInt := Res;

END;


{}

(*-

[FUNCTION]

Function  BaseToBase(             InBase        : BYTE;
                                  InVal         : STRING;
                                  OutBase       : BYTE       ) : STRING;

[PARAMETERS]

inBase      Base to convert from
inval       String representation of a value in base "inbase"
outBase     Base to convert to

[RETURNS]

"inval" converted from original base "inbase" to "outbase"

[DESCRIPTION]

Converts a string representation of a value in the specified base "inbase"
to a string representation of the same value in "outbase".

[SEE-ALSO]

StrToInt

[EXAMPLE]


   { to convert a hex-based value into a binary value }

   S := BaseToBase( 16, 'FF', 2 );

   { S now equals '11111111' }



-*)


Function  BaseToBase(             InBase        : BYTE;
                                  InVal         : STRING;
                                  OutBase       : BYTE       ) : STRING;

BEGIN

  BaseToBase := IntToBase( OutBase, BaseToInt( InBase, InVal ) );

END;

{}



(*-

[FUNCTION]

Function  IntToStr(                  L         : LONGINT ) : STRING;

[PARAMETERS]

L           Longint value to convert to string

[RETURNS]

String representation of integer value

[DESCRIPTION]

Converts an integer value into a string

[SEE-ALSO]

StrToInt

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := IntToStr( 12345 );

  { S = '12345' }

END;

-*)


Function  IntToStr(                  L         : LONGINT ) : STRING;

Var

  Result : STRING;

BEGIN

  Str( L, Result );

  IntToSTr := Result;

END;

{}

(*-

[FUNCTION]

Function  StrToInt(                  S         : STRING  ) : LONGINT;

[PARAMETERS]

S           String to convert to integer value

[RETURNS]

Integer representation of string.  If Error then result is Zero.

[DESCRIPTION]

Converts a string into an integer value.

[SEE-ALSO]

IntToStr

[EXAMPLE]

VAR
  L : LONGINT;

BEGIN

  L := StrToInt( '4312' );

  { L = 4312 }

END;

-*)

{----------------------------------------------------------}
{             Function StrToInt                            }
{----------------------------------------------------------}
{ IN:  S (STRING) string to convert                        }
{ OUT: (LONGINT) numeric representation of string          }
{ Converts a string to a numeric value                     }
{----------------------------------------------------------}

Function  StrToInt(                  S         : STRING  ) : LONGINT;

Var

  Error  : INTEGER;
  Number : LONGINT;

BEGIN

  Val( S, Number, Error );
  StrToInt := Number;

END;


{}

(*-

[FUNCTION]

Function  RealToStr(                 R         : REAL;
                                     Field     : INTEGER;
                                     Decimals  : INTEGER  ) : STRING;

[PARAMETERS]

R           Floating point value to convert to string
Field       Desired final width of string
Decimals    Desired number of decimal places to use in string

[RETURNS]

String representation of Floating point value

[DESCRIPTION]

Converts a floating point value into a string using the given string
width and decimal places.

[SEE-ALSO]

StrToReal

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := RealToStr( 1.5, 8, 4 );

  { S = '  1.5000' }

END;

-*)

Function  RealToStr(                 R         : REAL;
                                     Field     : INTEGER;
                                     Decimals  : INTEGER  ) : STRING;

Var

  Result: STRING;

BEGIN

  Str( R : Field : Decimals, Result );

  RealToStr := Result;

END;   { Of RealToStr }

{}

(*-

[FUNCTION]

Function  StrToReal(                 S         : STRING  ) : REAL;

[PARAMETERS]

S           String to convert to a floating point value

[RETURNS]

Floating point representation of string.

[DESCRIPTION]

Converts a string into a floating point value.
If Error then result is Zero.

NOTE: This Function does NOT take care of Leading or Trailing
Spaces or other Symbols.  This MUST be taken care of by the
caller.  All data must be prepared for immediate use.

[SEE-ALSO]

RealToStr

[EXAMPLE]

VAR
  R : REAL;

BEGIN

  R := StrToReal( '1.5' );

  { R = 1.5 }

END;

-*)


Function  StrToReal(                 S         : STRING  ) : REAL;

Var

  R     : REAL;
  Error : INTEGER;

BEGIN

  Val( S, R, Error );

  StrToReal := R;

END;   { Of StrToReal }

{}

(*-

[FUNCTION]

Function  SciToStr(                  R         : REAL    ) : STRING;

[PARAMETERS]

S           Floating point value to convert to string in scientific notation

[RETURNS]

String representation of floating point value using scientific notation

[DESCRIPTION]

Converts a floating point value into a string using scientific notation.

[SEE-ALSO]

StrToSci

[EXAMPLE]

VAR
  R : REAL;
  S : STRING;

BEGIN

  R := 1.25E2;  { 125 }
  S := SciToStr( R );

  { S = '1.25E2' }

END;

-*)


Function  SciToStr(                  R         : REAL    ) : STRING;

Var

  S : STRING;

BEGIN

  Str( R, S );
  SciToStr := S;

END;

{}

(*-

[FUNCTION]

Function  StrToSci(                  S         : STRING  ) : REAL;

[PARAMETERS]

S           String in scientific notation to convert to floating point value

[RETURNS]

Floating point representation of string.  If Error then result is Zero.

[DESCRIPTION]

Converts string of scientific notatation value to a floating point value.
If Error then floating point is Zero.

[SEE-ALSO]

SciToStr

[EXAMPLE]

VAR
  R : REAL;

BEGIN

  R := StrToSci( '1.25E2' );

  { R = 1.25E2 or 125 }

END;

-*)


Function  StrToSci(                  S         : STRING  ) : REAL;

Var

  R : REAL;
  I : INTEGER;

BEGIN

  Val( S, R, I );
  StrToSci := R;

END;

{}

(*-

[FUNCTION]

Function  IntToText(                 L         : LONGINT ) : ST80;

[PARAMETERS]

L           Integer value to convert to text string

[RETURNS]

Text String representation of integer value.

[DESCRIPTION]

Converts integer value into text form.  Handles all values into the
Billions.  The limiting factor is that the returned string is only
80 chars long and thus will clip any further text.

[SEE-ALSO]


[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := IntToText( 10 );
  { S now equals "Ten" }

  S := IntToText( 1,234,000 );

  { S equals "One Million, Two Hundred Thirty Four Thousand" }

-*)


Function  IntToText(                 L         : LONGINT  ) : ST80;

Var

  S,ST,
  S1,S2,S3 : STRING;
  Thousand,
  x,y,z    : INTEGER;
  Neg      : BOOLEAN;

BEGIN

  S        := '';
  ST       := '';
  Thousand := 0;

  Neg := FALSE;

  If ( L < 0 ) Then
  BEGIN

    Neg := TRUE;
    L   := L * -1;

  END;

  Repeat

    x :=   L MOD 10;
    y := ( L MOD 100 )  DIV 10;
    z := ( L MOD 1000 ) DIV 100;

    S1 := '';
    S2 := '';
    S3 := '';

    Case z Of
      1 : S1 := 'One';
      2 : S1 := 'Two';
      3 : S1 := 'Three';
      4 : S1 := 'Four';
      5 : S1 := 'Five';
      6 : S1 := 'Six';
      7 : S1 := 'Seven';
      8 : S1 := 'Eight';
      9 : S1 := 'Nine';
    END;

    If (y = 1) Then
    BEGIN

      Case x Of
        0 : S2 := 'Ten';
        1 : S2 := 'Eleven';
        2 : S2 := 'Twelve';
        3 : S2 := 'Thirteen';
        4 : S2 := 'Fourteen';
        5 : S2 := 'Fifteen';
        6 : S2 := 'Sixteen';
        7 : S2 := 'Seventeen';
        8 : S2 := 'Eighteen';
        9 : S2 := 'Nineteen';
      END;

    END
    Else
    BEGIN

      Case x Of
        1 : S3 := 'One';
        2 : S3 := 'Two';
        3 : S3 := 'Three';
        4 : S3 := 'Four';
        5 : S3 := 'Five';
        6 : S3 := 'Six';
        7 : S3 := 'Seven';
        8 : S3 := 'Eight';
        9 : S3 := 'Nine';
      END;

      Case y Of
        2 : S2 := 'Twenty';
        3 : S2 := 'Thirty';
        4 : S2 := 'Forty';
        5 : S2 := 'Fifty';
        6 : S2 := 'Sixty';
        7 : S2 := 'Seventy';
        8 : S2 := 'Eighty';
        9 : S2 := 'Ninety';
      END;

    END;

    If ( S1 <> '' ) Then
      ST := S1 + ' Hundred'
    Else
      ST := '';

    If ( S2 <> '' ) Then
    BEGIN

      If ( ST <> '' ) Then
        ST := ST + ' ' + S2
      Else
        ST := S2;

    END;

    If ( S3 <> '' ) Then
    BEGIN

      If ( ST <> '' ) Then
        ST := ST + ' ' + S3
      Else
        ST := S3;

    END;

    If ( ST <> '' ) Then
    BEGIN

      Case Thousand Of
        0 : ST := ST;
        1 : ST := ST + ' Thousand';
        2 : ST := ST + ' Million';
        3 : ST := ST + ' Billion';
      END;

      If ( S <> '' ) Then
        S := ST + ', ' + S
      Else
        S := ST;

    END;

    L := L DIV 1000;
    Inc(Thousand);

  Until L = 0;

  If ( S = '' ) Then
    S := 'Zero'
  Else
    If Neg Then
      S := 'Negative ' + S;

  IntToText := S;

END;   { Of IntToText }

{}

(*-

[FUNCTION]

Function  LongToDollars(             L         : LONGINT ) : REAL;

[PARAMETERS]

L           Currency Value in Cents

[RETURNS]

Currency Value in Dollars.  (Pennies now represented as fractions)

[DESCRIPTION]

Converts an integer penny amount into a floating point dollar amount

[SEE-ALSO]

DollarsToLong

[EXAMPLE]

VAR
  R : REAL;

BEGIN

  R := LongToDollars( 12500 );

  { R = 125.00 }

END;

-*)


Function  LongToDollars(             L         : LONGINT  ) : REAL;

Var

  R : REAL;

BEGIN

  R             := L;
  LongToDollars := R * 0.01;

END;

{}

(*-

[FUNCTION]

Function  DollarsToLong(             R         : REAL    ) : LONGINT;

[PARAMETERS]

R           Currency Value in Dollars

[RETURNS]

Currency Value in Cents.  (Dollars now represented as 100 Pennies)

[DESCRIPTION]

Converts a floating point dollar amount into an integer penny amount

[SEE-ALSO]

LongToDollars

[EXAMPLE]

VAR
  L : LONGINT;

BEGIN

  L := DollarsToLong( 125.00 );

  { L = 12500 }

END;

-*)


Function  DollarsToLong(             R         : REAL    ) : LONGINT;

BEGIN

  DollarsToLong := Round( R * 100.0 );

END;

{}

(*-

[FUNCTION]

Function  BoolToStr(              Bool          : BOOLEAN;
                                  TrueStr       : STRING;
                                  FalseStr      : STRING        ) : STRING;

[PARAMETERS]

Bool        boolean value to test
TrueStr     String to return if "bool" is TRUE
FalseStr    String to return if "bool" is false

[RETURNS]

Boolean as a string (either "TrueStr" or "FalseStr")

[DESCRIPTION]

This function converts the boolean value to a string.  If "Bool" is
true, the function will return "TrueStr".  If Bool is false, the
functionwill return "FalseStr".

[SEE-ALSO]

BoolToYN
BoolToOnOff

[EXAMPLE]

  WriteLN( BoolToStr( TRUE, 'On', 'Off' );

END;

-*)


Function  BoolToStr(              Bool          : BOOLEAN;
                                  TrueStr       : STRING;
                                  FalseStr      : STRING        ) : STRING;


BEGIN

 If Bool=TRUE Then
   BoolToStr := TrueStr
 Else
   BoolToStr := FalseStr;

END;

{}

(*-

[FUNCTION]

Function BoolToYN(                Bool          : BOOLEAN       ) : STRING;

[PARAMETERS]

Bool        boolean value to test

[RETURNS]

Boolean as a string (either "Yes" or "No")

[DESCRIPTION]

This function converts the boolean value to a string.  If "Bool" is
true, the function will return "Yes".  If Bool is false, the
functionwill return "No".

[SEE-ALSO]

BoolToStr
BoolToOnOff

[EXAMPLE]

  WriteLN( BoolToYN( TRUE ) );

END;

-*)


Function BoolToYN(                Bool          : BOOLEAN       ) : STRING;

BEGIN

  If Bool=TRUE Then
    BoolToYN := 'Yes'
  Else
    BoolToYn := 'No';

END;

{}


(*-

[FUNCTION]

Function BoolToOnOff(             Bool          : BOOLEAN       ) : STRING;

[PARAMETERS]

Bool        boolean value to test

[RETURNS]

Boolean as a string (either "On" or "Off")

[DESCRIPTION]

This function converts the boolean value to a string.  If "Bool" is
true, the function will return "On".  If Bool is false, the
functionwill return "Off".

[SEE-ALSO]

BoolToStr
BoolToOnOff

[EXAMPLE]

  WriteLN( BoolToOnOff( TRUE ) );

END;

-*)

Function BoolToOnOff(             Bool          : BOOLEAN       ) : STRING;

BEGIN

  If Bool=TRUE Then
    BoolToOnOff:= 'On'
  Else
    BoolToOnOff := 'Off';

END;


{}


Function  IntToBigNum(            L             : LONGINT       ) : STRING;

BEGIN

  IntToBigNum := IntToBase( 36, L );

END;


{}


Function  BigNumToInt(            S             : STRING        ) : LONGINT;


BEGIN

  BigNumToInt := BaseToInt( 36, S );

END;


{}

(*-

[FUNCTION]

Function  CharToHex(                 C         : SHORTINT) : ST80;

[PARAMETERS]

C           Signed Byte (SHORTINT) value to convert to a hex string

[RETURNS]

Hex string representation of signed byte value

[DESCRIPTION]

Converts a Signed Byte (Shortint) value into a hexadecimal string

[SEE-ALSO]

ByteToHex
IntToHex
WordToHex
PtrToHex
LongToHex
HexToChar
HexToByte
HexToInt
HexToWord
HexToLong

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := CharToHex( #32 );

  { S = '20' (Hex of 32) }

END;

-*)


Function  CharToHex(                 C         : SHORTINT ) : ST80;

Var

  S : ST80;

BEGIN

  CharToHex := TDecHex[ ( C AND $F0 ) SHR 4 ] + TDecHex[ C AND $0F ];

END;

{}

(*-

[FUNCTION]

Function  ByteToHex(                 B         : BYTE    ) : ST80;

[PARAMETERS]

B           Unsigned Byte value to convert to a hex string

[RETURNS]

Hex string representation of byte value

[DESCRIPTION]

Converts an Unsigned Byte Value into a Hexadecimal String

[SEE-ALSO]

CharToHex
IntToHex
WordToHex
PtrToHex
LongToHex
HexToChar
HexToByte
HexToInt
HexToWord
HexToLong

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := ByteToHex( #32 );

  { S = '20' (Hex of 32) }

END;

-*)


Function  ByteToHex(                 B         : BYTE     ) : ST80;

BEGIN

  ByteToHex := TDecHex[(B AND $F0) SHR 4] + TDecHex[B AND $0F];

END;

{}

(*-

[FUNCTION]

Function  IntToHex(                  I         : INTEGER ) : ST80;

[PARAMETERS]

I           Signed Word (INTEGER) value to convert to a hex string

[RETURNS]

Hex string representation of signed word value

[DESCRIPTION]

Converts a Signed Word (INTEGER) value into a hexadecimal string

[SEE-ALSO]

CharToHex
ByteToHex
WordToHex
PtrToHex
LongToHex
HexToChar
HexToByte
HexToInt
HexToWord
HexToLong

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := IntToHex( -32000 );

  { S = '8300' }

END;

-*)


Function  IntToHex(                  I         : INTEGER  ) : ST80;

BEGIN

  IntToHex := CharToHex( I SHR 8 ) + ByteToHex( I AND $FF );

END;

{}

(*-

[FUNCTION]

Function  WordToHex(                 W         : WORD    ) : ST80;

[PARAMETERS]

W           Unsigned Word to convert to a hex string

[RETURNS]

Hex string representation of word value

[DESCRIPTION]

Converts an Unsigned Word into a hexadecimal string

[SEE-ALSO]

CharToHex
ByteToHex
IntToHex
PtrToHex
LongToHex
HexToChar
HexToByte
HexToInt
HexToWord
HexToLong

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := WordToHex( 50000 );

  { S = 'C350' }

END;

-*)


Function  WordToHex(                 W         : WORD     ) : ST80;

BEGIN

  WordTohex := ByteToHex( W SHR 8 ) + ByteToHex( W AND $FF );

END;

{}

(*-

[FUNCTION]

Function  PtrToHex(                  P         : POINTER ) : ST80;

[PARAMETERS]

P           Pointer to convert to a hex string

[RETURNS]

Hex string representation of pointer value

[DESCRIPTION]

Converts a Pointer into a hexadecimal string (both segment and offset)

[SEE-ALSO]

CharToHex
ByteToHex
IntToHex
WordToHex
LongToHex
HexToChar
HexToByte
HexToInt
HexToWord
HexToLong

[EXAMPLE]

VAR
  P : POINTER;
  S : STRING;

BEGIN

  P := Ptr($A000,0);
  S := PtrToHex( P );

  { S = 'A000:0000' }

END;
-*)

{----------------------------------------------------------}
{             Function PtrToHex                            }
{----------------------------------------------------------}
{ IN:  P (POINTER) pointer to value                        }
{ OUT: (ST80) hex string                                   }
{ Converts value pointed to into a hex string              }
{----------------------------------------------------------}

Function  PtrToHex(                  P         : POINTER  ) : ST80;

BEGIN

  PtrToHex := WordToHex( Seg(P^) ) + ':' + WordToHex( Ofs(P^) );

END;

{}

(*-

[FUNCTION]

Function  LongToHex(                 L         : LONGINT ) : ST80;

[PARAMETERS]

L           Signed Double Word (LONGINT) Value to convert to a hex string

[RETURNS]

Hex string representation of Longint value

[DESCRIPTION]

Converts a Signed Double Word (LONGINT) into a hexadecimal string

[SEE-ALSO]

CharToHex
ByteToHex
IntToHex
WordToHex
PtrToHex
HexToChar
HexToByte
HexToInt
HexToWord
HexToLong

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := LongToHex( 123456789 );

  { S = '075BCD15' }

END;

-*)


Function  LongToHex(                 L         : LONGINT  ) : ST80;

BEGIN

  LongToHex := IntToHex( L SHR 16 ) + WordToHex( L AND $FFFF );

END;

{}

(*-

[FUNCTION]

Function DecToHexStr(                S         : STRING   ) : STRING;

[PARAMETERS]

S           Decimal Value in String Format

[RETURNS]

Hexidecimal Value String

[DESCRIPTION]

Converts a Decimal Value String into a Hexidecimal Value String.
The Result is 8 Characters Long.  The Caller must strip the any
Leading Zeros to the desired size.

[SEE-ALSO]

CharToHex
ByteToHex
IntToHex
WordToHex
PtrToHex
HexToChar
HexToByte
HexToInt
HexToWord
HexToLong
HexToDecStr

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := '1234';
  S := DecToHexStr( S );

  { S = '000004D2' - Caller Must Strip Leading Zeros if desired }

END;

-*)

Function DecToHexStr(                S         : STRING   ) : STRING;

BEGIN

  DecToHexStr := LongToHex( StrToInt( S ) );

END;

(*
Var

  Index     : WORD;
  NextIndex : WORD;
  Count     : WORD;
  L1        : BYTE;
  L2        : BYTE;

  S2        : STRING;
  Result    : LONGINT;
  ResultHex : STRING;

BEGIN

  NextIndex := 1;
  Index := NextIndex;

  REPEAT

    While ( Index <= Byte(S[0]) ) AND
          ( NOT IsNum(S[Index]) ) Do
      Inc( Index );

    If Index <= Byte(S[0]) Then
    BEGIN

      Count := Index;
      While ( Count < Byte(S[0]) ) AND
            ( IsNum(S[Succ(Count)]) ) Do
        Inc( Count );

      NextIndex := Succ(Count);

      {------------------------------------------------}
      { Perform conversion between Index and NextIndex }
      {------------------------------------------------}

      S2 := CopyStr( S, Index, NextIndex - Index );

      Result    := StrToInt( S2 );
      ResultHex := LongToHex( Result );

      While ( Byte(ResultHex[0]) > 1 ) AND
            ( ResultHex[1] = '0' ) Do
        Delete( ResultHex, 1, 1 );

      Delete( S, Index, NextIndex - Index );
      Insert( ResultHex, S, Index );

      {-----}

      Inc( Index, Byte(ResultHex[0]) );

    END;

  UNTIL (Index > Byte(S[0]));

  DecToHexStr := S;

END;
*)

{}

(*-

[FUNCTION]

Function HexToDecStr(                S         : STRING   ) : STRING;

[PARAMETERS]

S           Hexadecimal Value in String Format

[RETURNS]

Decimal Value String

[DESCRIPTION]

Converts a Hexadecimal Value String into a Decimal Longint Value String.

[SEE-ALSO]

CharToHex
ByteToHex
IntToHex
WordToHex
PtrToHex
HexToChar
HexToByte
HexToInt
HexToWord
HexToLong
DecToHexStr

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := '04D2';
  S := HexToDecStr( S );

  { S = '1234', Caller must Strip to Size Desired }

END;

-*)

Function HexToDecStr(                S         : STRING   ) : STRING;

BEGIN

  HexToDecStr := IntToStr( HexToLong( S ) );

END;

{}

(*-

[FUNCTION]

Function  HexToChar(                 S         : ST80    ) : SHORTINT;

[PARAMETERS]

S           String representation of signed byte hex value

[RETURNS]

Signed byte value represented by hex string

[DESCRIPTION]

Converts a hexadecimal string representation of a signed byte into
a signed byte value.  If Error then value is Zero.

[SEE-ALSO]

CharToHex
ByteToHex
IntToHex
WordToHex
PtrToHex
LongToHex
HexToByte
HexToInt
HexToWord
HexToLong

[EXAMPLE]

VAR
  I : SHORTINT;

BEGIN

  I := HexToChar( '80' );

  { I = -128 }

END;

-*)


Function  HexToChar(                 S         : ST80    ) : SHORTINT;

Var

  I : INTEGER;
  B : SHORTINT;

BEGIN

  While Byte( S[0] ) < 2 Do
    S := '0' + S;

  S[1] := UpCase( S[1] );
  S[2] := UpCase( S[2] );

  I := 0;

  While ( S[2] <> TDecHex[I] ) AND ( I < 16 ) Do
    Inc(I);

  If ( I > 15 ) Then
    I := 0;

  B := I;
  I := 0;

  While ( S[1] <> TDecHex[I] ) AND ( I < 16 ) Do
    Inc(I);

  If ( I > 15 ) Then
    I := 0;

  B := ( I SHL 4 ) + B;
  HexToChar := B;

END;

{}

(*-

[FUNCTION]

Function  HexToByte(                 S         : ST80    ) : BYTE;

[PARAMETERS]

S           String representation of byte hex value

[RETURNS]

Byte represented by hex string.

[DESCRIPTION]

Converts a hexadecimal string representation of a byte into a byte value.
If Error then value is Zero.

[SEE-ALSO]

CharToHex
ByteToHex
IntToHex
WordToHex
PtrToHex
LongToHex
HexToChar
HexToInt
HexToWord
HexToLong

[EXAMPLE]

VAR
  B : BYTE;

BEGIN

  B := HexToByte( '80' );

  { B = 128 }

END;

-*)


Function  HexToByte(                 S         : ST80    ) : BYTE;

Var

  I : INTEGER;
  B : BYTE;

BEGIN

  While Byte( S[0] ) < 2 Do
    S := '0' + S;

  S[1] := UpCase( S[1] );
  S[2] := UpCase( S[2] );

  I := 0;

  While ( S[1] <> TDecHex[I] ) and ( I < 16 ) Do
    Inc(I);

  If ( I > 15 ) Then
    I := 0;

  B := I SHL 4;
  I := 0;

  While ( S[2] <> TDecHex[I] ) and ( I < 16 ) Do
    Inc(I);

  If ( I > 15 ) Then
    I := 0;

  B := B + I;
  HexToByte:=B;

END;

{}

(*-

[FUNCTION]

Function  HexToInt(                  S         : ST80    ) : INTEGER;

[PARAMETERS]

S           String representation of integer hex value

[RETURNS]

Integer represented by hex string

[DESCRIPTION]

Converts a hexadecimal string representation of an integer (signed word)
into an integer value.  If Error then value is Zero.

[SEE-ALSO]

CharToHex
ByteToHex
IntToHex
WordToHex
PtrToHex
LongToHex
HexToChar
HexToByte
HexToWord
HexToLong

[EXAMPLE]

VAR
  I : INTEGER;

BEGIN

  I := HexToInt( '8300' );

  { I = -32000 }

END;

-*)


Function  HexToInt(                  S         : ST80    ) : INTEGER;

BEGIN

  While Byte( S[0] ) < 4 Do
    S := '0' + S;

  HexToInt := ( Word( HexToByte( S[1] + S[2] ) ) SHL 8 ) +
                      HexToByte( S[3] + S[4] );
END;

{}

(*-

[FUNCTION]

Function  HexToWord(                 S         : ST80    ) : WORD;

[PARAMETERS]

S           String representation of a word hex value

[RETURNS]

Word represented by hex string

[DESCRIPTION]

Converts a hexadecimal string representation of a word into a word value.
If Error then value is Zero.

[SEE-ALSO]

CharToHex
ByteToHex
IntToHex
WordToHex
PtrToHex
LongToHex
HexToChar
HexToByte
HexToInt
HexToLong

[EXAMPLE]

VAR
  W : WORD;

BEGIN

  W := HexToWord( 'C350' );

  { W = 50000 }

END;

-*)


Function  HexToWord(                 S         : ST80    ) : WORD;

BEGIN

  While Byte( S[0] ) < 4 Do
    S:='0'+ S;

  HexToWord := ( Word( HexToByte( S[1] + S[2] ) ) SHL 8 ) +
                       HexToByte( S[3] + S[4] );
END;

{}

(*-

[FUNCTION]

Function  HexToLong(                 S         : ST80    ) : LONGINT;

[PARAMETERS]

S           String representation of longint hex value (double word)

[RETURNS]

Longint represented by hex string

[DESCRIPTION]

Converts a hexadecimal string representation of a longint (signed double
word) into a longint value.  If Error then value is Zero.

[SEE-ALSO]

CharToHex
ByteToHex
IntToHex
WordToHex
PtrToHex
LongToHex
HexToChar
HexToByte
HexToInt
HexToWord

[EXAMPLE]

VAR
  L : LONGINT;

BEGIN

  L := HexToLong( '075BCD15' );

  { L = 123456789 }

END;


-*)


Function  HexToLong(                 S         : ST80    ) : LONGINT;

BEGIN

  While Byte( S[0] ) < 8 Do
    S := '0' + S;

  HexToLong:=  ( HexToWord( S[1] + S[2] + S[3] + S[4] ) SHL 16 )+
                 HexToWord( S[5] + S[6] + S[7] + S[8] );

END;

{}

(*-

[FUNCTION]

Function  ByteToBin(                 B         : BYTE    ) : ST80;

[PARAMETERS]

B           Byte value to convert to a binary string

[RETURNS]

Binary string representation of byte value

[DESCRIPTION]

Converts a byte value into a binary string

[SEE-ALSO]

IntToBin
WordToBin
LongToBin
BinToChar
BinToByte
BinToInt
BinToWord
BinToLong

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := ByteToBin( 125 );

  { S = '01111101' }

END;

-*)


Function  ByteToBin(                 B         : BYTE    ) : ST80;

Var

  S : STRING;

BEGIN

  ASM

    {--------------------------}
    { Make ES:DI Point to S[1] }
    {--------------------------}

    PUSH SS
    POP  ES
    LEA  DI, S+1

    {-----------------------}
    { setup other registers }
    {-----------------------}

    CLD                  { Clear the direction          }
    MOV  BL, 128          { Start at the highest bit     }
    MOV  CX, 8            { do 8-bits                    }
    MOV  AH, '0'          { put ASCII values in regs for }
    MOV  BH, '1'          { performance...               }

    {------------------}
    { The Actual Loop: }
    {------------------}

   @@1:

    MOV  AL, BH           { Set AL to the default ('1')  }
    TEST B, BL           { Q: Is this bit a 1?          }
    JNE  @@2              {  Y: Move on                  }
    MOV  AL, AH           {  N: Set Al to '0'            }

   @@2:

    STOSB                { Store AL at ES:DI, inc DI    }
    SHR  BL,1            { Test the next lowest bit     }
    LOOP @@1             { loop back to @@1             }

    {-------------------------------}
    { Setup the Strings length byte }
    {-------------------------------}

    MOV  byte PTR [S], 8

  END;

  ByteToBin := S;

END;

{}

(*-

[FUNCTION]

Function  IntToBin(                  I         : INTEGER ) : ST80;

[PARAMETERS]

I           Integer (signed word) value to convert to a binary string

[RETURNS]

Binary string representation of integer value.

[DESCRIPTION]

Converts a integer (signed word) value into a binary string

[SEE-ALSO]

ByteToBin
WordToBin
LongToBin
BinToChar
BinToByte
BinToInt
BinToWord
BinToLong

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := IntToBin( -32000 );

  { S = '1000001100000000' }

END;

-*)


Function  IntToBin(                  I         : INTEGER ) : ST80;

BEGIN

  IntToBin := ByteToBin( I SHR 8 ) + ByteToBin( I AND $FF );

END;

{}

(*-

[FUNCTION]

Function  WordToBin(                 W         : WORD    ) : ST80;

[PARAMETERS]

W           Word value to convert to a binary string

[RETURNS]

Binary string representation of word value

[DESCRIPTION]

Converts a word value into a binary string

[SEE-ALSO]

ByteToBin
IntToBin
LongToBin
BinToChar
BinToByte
BinToInt
BinToWord
BinToLong

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := WordToBin( 50000 );

  { S = '1100001101010000' }

END;

-*)


Function  WordToBin(                 W         : WORD    ) : ST80;

BEGIN

  WordToBin := ByteToBin( W SHR 8 ) + ByteToBin( W AND $FF );

END;

{}

(*-

[FUNCTION]

Function  LongToBin(                 L         : LONGINT ) : ST80;

[PARAMETERS]

L           Longint (signed double word) value to convert to binary string

[RETURNS]

Binary string representation of Longint

[DESCRIPTION]

Converts a longint (signed double word) value into a binary string

[SEE-ALSO]

ByteToBin
IntToBin
WordToBin
BinToChar
BinToByte
BinToInt
BinToWord
BinToLong

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := LongToBin( 123456789 );

  { S = '00000111010110111100110100010101' }

END;

-*)


Function  LongToBin(                 L         : LONGINT ) : ST80;

BEGIN

  LongToBin := IntToBin( L SHR 16 ) + WordToBin( L AND $FFFF );

END;

{}

(*-

[FUNCTION]

Function  BinToChar(                 S         : ST80    ) : SHORTINT;

[PARAMETERS]

S           Binary string to convert to a signed byte value

[RETURNS]

Signed byte value of binary string

[DESCRIPTION]

Converts a binary string into a signed byte value.
If Error then value is Zero.

[SEE-ALSO]

ByteToBin
IntToBin
WordToBin
LongToBin
BinToByte
BinToInt
BinToWord
BinToLong

[EXAMPLE]

VAR
  I : SHORTINT;

BEGIN

  I := BinToChar( '10000000' );
  { I = -128 }

END;

-*)


Function  BinToChar(                 S         : ST80    ) : SHORTINT;

Var

  C : SHORTINT;
  I : INTEGER;

BEGIN

  While Byte( S[0] ) < 8 Do
    S := '0' + S;

  C := 0;
  For I := 7 DownTo 1 Do
  BEGIN

    If S[ 8-I ] = '1' Then
      C := C OR ($1 SHL I);

  END;

  BinToChar := C;

END;

{}

(*-

[FUNCTION]

Function  BinToByte(                 S         : ST80    ) : BYTE;

[PARAMETERS]

S           Binary string to convert to a byte value

[RETURNS]

Byte value of binary string

[DESCRIPTION]

Converts a binary string into an unsigned byte value.
If Error then value is Zero.

[SEE-ALSO]

ByteToBin
IntToBin
WordToBin
LongToBin
BinToChar
BinToInt
BinToWord
BinToLong

[EXAMPLE]

VAR
  B : BYTE;

BEGIN

  B := BinToChar( '10000000' );
  { B = 128 }

END;

-*)


Function  BinToByte(                 S         : ST80    ) : BYTE;

Var

  B : BYTE;
  I : INTEGER;

BEGIN

  While Byte( S[0] ) < 8 Do
    S := '0' + S;

  B := 0;
  For I := 7 DownTo 0 Do
  BEGIN

    If S[ 8-I ] = '1' Then
      B := B OR ($1 SHL I);

  END;

  BinToByte := B;

END;

{}

(*-

[FUNCTION]

Function  BinToInt(                  S         : ST80    ) : INTEGER;

[PARAMETERS]

S           Binary string to convert to an integer (signed word) value

[RETURNS]

Integer value of binary string

[DESCRIPTION]

Converts a binary string into an integer value.
If Error then value is Zero.

[SEE-ALSO]

ByteToBin
IntToBin
WordToBin
LongToBin
BinToChar
BinToByte
BinToWord
BinToLong

[EXAMPLE]

VAR
  I : INTEGER;

BEGIN

  I := BinToInt( '1000001100000000' );

  { I := -32000 }

END;

-*)


Function  BinToInt(                  S         : ST80    ) : INTEGER;

BEGIN

  While Byte( S[0] ) < 16 Do
    S := '0' + S;

  BinToInt := ( Word( BinToChar( Copy( S, 1, 8 ) ) SHL 8 ) +
                      BinToByte( Copy( S, 8, 8 ) ) );

END;

{}

(*-

[FUNCTION]

Function  BinToWord(                 S         : ST80    ) : WORD;

[PARAMETERS]

S           Binary string to convert to a word value

[RETURNS]

Word value of binary string

[DESCRIPTION]

Converts a binary string into a word value.
If Error then value is Zero.

[SEE-ALSO]

ByteToBin
IntToBin
WordToBin
LongToBin
BinToChar
BinToByte
BinToInt
BinToLong

[EXAMPLE]

VAR
  W : WORD;

BEGIN

  W := BinToWord( '1100001101010000' );

  { W = 50000 }

END;

-*)


Function  BinToWord(                 S         : ST80    ) : WORD;

BEGIN

  While Byte( S[0] ) < 16 Do
    S := '0' + S;

  BinToWord := ( Word( BinToByte( Copy( S, 1, 8 ) ) SHL 8 ) +
                       BinToByte( Copy( S, 8, 8 ) ) );

END;

{}

(*-

[FUNCTION]

Function  BinToLong(                 S         : ST80    ) : LONGINT;

[PARAMETERS]

S           Binary String to convert to a longint (signed double word) value

[RETURNS]

Longint value of binary string

[DESCRIPTION]

Converts a binary string into a longint value.
If Error then value is Zero.

[SEE-ALSO]

ByteToBin
IntToBin
WordToBin
LongToBin
BinToChar
BinToByte
BinToInt
BinToWord

[EXAMPLE]

VAR
  L : LONGINT;

BEGIN

  L := BinToLong( '00000111010110111100110100010101' );

  { L = 123456789 }

END;

-*)


Function  BinToLong(                 S         : ST80    ) : LONGINT;

BEGIN

  While Byte( S[0] ) < 16 Do
    S := '0' + S;

  BinToLong := ( LongInt( BinToWord( Copy( S, 1, 8 ) ) SHL 16 ) +
                          BinToWord( Copy( S, 8, 8 ) ) );

END;

{}

(*-

[FUNCTION]

Function  DecToBCD(                  Decimal   : BYTE    ) : BYTE;

[PARAMETERS]

Decimal     Decimal Byte value (ranging from 0 to 99) to convert to a
            BCD byte value.

[RETURNS]

BCD value of Decimal byte value.

[DESCRIPTION]

Converts a decimal value ranging from 0 to 99 to Binary Coded Decimal
Format as a byte.

[SEE-ALSO]

BCDtoDec
ByteToBCD
BCDtoByte
WordToBCD
BCDtoWord

[EXAMPLE]

VAR
  B : BYTE;

BEGIN

  B := DecToBCD( 14 );

  { B = $14 }

END;

-*)


Function  DectoBCD(                  Decimal   : BYTE    ) : BYTE;

Assembler;
ASM

  MOV  AL, Decimal

  XOR  AH, AH      {prepare 16 bit division     }
  MOV  DH, 10      {work in decimal system      }
  DIV  DH          {divide AX by 10             }

  MOV  CL, 4
  SHL  AL, CL      {shift quotient left 4 places}

  OR   AL, AH      {OR remainder                }

END;

{}

(*-

[FUNCTION]

Function  BCDtoDec(                  Bcd       : BYTE    ) : BYTE;

[PARAMETERS]

Bcd         BCD Byte value (ranging 00h - 99h) to convert to a decimal
            byte value.

[RETURNS]

Decimal byte value of BCD byte value.

[DESCRIPTION]

Converts a BCD byte value ranging fron 00h to 99h to a decimal byte value

[SEE-ALSO]

DecToBCD
ByteToBCD
BCDtoByte
WordToBCD
BCDtoWord

[EXAMPLE]

VAR
  B : BYTE;

BEGIN

  B := BCDtoDec( $14 );

  { B = 14 }

END;

-*)


Function  BCDtoDec(                  Bcd       : BYTE    ) : BYTE;

Assembler;
ASM

  MOV  DL, Bcd
  MOV  AL, DL      {transmit value to AL     }

  MOV  CL, 4
  SHR  AL, CL      {shift 4 places right     }

  XOR  AH, AH      {set AH to 0              }
  MOV  DH, 10      {process in decimal system}
  MUL  DH          {multiply AX by 10        }
  MOV  DH, DL      {transmit DL to DH        }
  AND  DH, $0F     {set hi-nibble in DH to 0 }
  ADD  AL, DH      {add AL and DH            }

END;

{}

(*-

[FUNCTION]

Function  ByteToBCD(                 Decimal   : BYTE    ) : WORD;

[PARAMETERS]

Decimal     Decimal byte value (ranging from 0 to 255) to convert to
            a BCD word value

[RETURNS]

BCD word value of decimal byte value.

[DESCRIPTION]

Converts a Decimal byte value ranging from 0 to 255 to Binary Coded
Decimal format as a word.

[SEE-ALSO]

DecToBCD
BCDtoDec
BCDtoByte
WordToBCD
BCDtoWord

[EXAMPLE]

VAR
  W : WORD;

BEGIN

  W := ByteToBCD( 255 );

  { W = $0255 }

END;

-*)


Function  ByteToBCD(                 Decimal   : BYTE    ) : WORD;

BEGIN

  ByteToBCD := DecToBCD( Decimal DIV 100 ) SHL 8 +
               DecToBCD( Decimal MOD 100 );

END;

{}

(*-

[FUNCTION]

Function  BCDtoByte(                 Bcd       : WORD    ) : BYTE;

[PARAMETERS]

Bcd         BCD Word value (ranging from 0000h to 0255h) to convert to
            a decimal byte value.

[RETURNS]

Decimal byte value of BCD word value.

[DESCRIPTION]

Converts a BCD word value ranging from 0000h to 0255h to a decimal byte
value.

[SEE-ALSO]

DecToBCD
BCDtoDec
ByteToBCD
WordToBCD
BCDtoWord

[EXAMPLE]

VAR
  B : BYTE;

BEGIN

  B := BCDtoByte( $0255 );

  { B = 255 }

END;

-*)


Function  BCDtoByte(                 Bcd       : WORD    ) : BYTE;

BEGIN

  BCDtoByte := BCDtoDec( Hi(Bcd) ) * 100 + BCDtoDec( Lo(Bcd) );

END;

{}

(*-

[FUNCTION]

Function  WordToBCD(                 Decimal   : WORD    ) : LONGINT;

[PARAMETERS]

Decimal     Decimal word value (ranging from 0 to 65535) to convert to
            a BCD longint value

[RETURNS]

BCD longint value of decimal word value

[DESCRIPTION]

Converts a Decimal word value ranging from 0 to 65535 to Binary Coded
Decimal format as a longint.

[SEE-ALSO]

DecToBCD
BCDtoDec
ByteToBCD
BCDtoByte
BCDtoWord

[EXAMPLE]

VAR
  L : LONGINT;

BEGIN

  L := WordToBCD( 54321 );

  { L = $00054321 }

END;

-*)


Function  WordToBCD(                 Decimal   : WORD    ) : LONGINT;

BEGIN

  Decimal := Decimal MOD 100000000;

  WordToBCD := LONGINT( DecToBCD( ( Decimal DIV 1000000 ) MOD 100 ) ) SHL 24 +
               LONGINT( DecToBCD( ( Decimal DIV 10000 ) MOD 100 ) ) SHL 16 +
               LONGINT( DecToBCD( ( Decimal DIV 100 ) MOD 100 ) ) SHL  8 +
                        DecToBCD( Decimal MOD 100 );
END;

{}

(*-

[FUNCTION]

Function  BCDtoWord(                 Bcd       : LONGINT ) : WORD;

[PARAMETERS]

Bcd         BCD longint value (ranging from 00000000h to 00065535h) to
            convert to a decimal word value

[RETURNS]

Decimal word value of BCD longint value

[DESCRIPTION]

Converts a BCD longint value ranging fron 00000000h to 00065536h to a
decimal word value.

[SEE-ALSO]

DecToBCD
BCDtoDec
ByteToBCD
BCDtoByte
WordToBCD

[EXAMPLE]

VAR
  W : WORD;

BEGIN

  W := BCDtoWord( $00054321 );

  { W = 54321 }

END;

-*)


Function  BCDtoWord(                 Bcd       : LONGINT ) : WORD;

BEGIN

  BCDtoWord := BCDtoDec( ( Bcd SHL 24 ) AND $FF ) * 1000000 +
               BCDtoDec( ( Bcd SHL 16 ) AND $FF ) * 10000 +
               BCDtoDec( ( Bcd SHL  8 ) AND $FF ) * 100 +
               BCDtoDec(   Bcd AND $FF );

END;

{}



(*-

[FUNCTION]

Function  FastCompare(           Var Buf1;
                                 Var Buf2;
                                     Count     : WORD    ) : WORD;

[PARAMETERS]

Buffer1     VAR Address of First Buffer (Generic Type)
Buffer2     VAR Address of Second Buffer (Generic Type)
Count       Number of bytes in each buffer

[RETURNS]

Whether or not the provided Buffers were the same (0=Same, $FFFF=Not)

[DESCRIPTION]

This function compares two data buffers and returns a non-zero value
if the buffers data does not compare.  It doesn't indicate which byte
index the miscompare exists, just that it did.  If the data in both
buffers are alike the result is Zero.  This Operation is Optimized in
Assembly for the fastest possible Comparison.

[SEE-ALSO]

Compare
CompareSmaller
CompareBufByte

[EXAMPLE]

TYPE
  TBuff = ARRAY[1..10] of BYTE;

VAR
  B1,B2 : TBuff;
  W     : WORD;

BEGIN

  FillChar( B1, SizeOf( B1 ), 4 );
  FillChar( B2, SizeOf( B2 ), 4 );

  B2[7] := 49;  { Force MisCompare }

  W := FastCompare( B1, B2, SizeOf( TBuff ) );

  { W = $FFFF  - MisCompared! }

END;

-*)


Function  FastCompare(           Var Buf1;
                                 Var Buf2;
                                     Count     : WORD    ) : WORD;
Assembler;
ASM

  PUSH DS

  LES  DI, [Buf1]
  LDS  SI, [Buf2]
  MOV  CX, [Count]

  CLD
  REPZ CMPSB

  JNZ  @1
  XOR  AX, AX
  JMP  @2

 @1:
  MOV  AX, $FFFF

 @2:

  POP  DS

END;

{}

(*-

[FUNCTION]

Function  Compare(               Var Buf1;
                                 Var Buf2;
                                     Count     : WORD    ) : WORD;

[PARAMETERS]

Buf1        VAR Address of First Buffer (Generic Type)
Buf2        VAR Address of Second Buffer (Generic Type)
Count       Number of bytes in each buffer (Max = $FFFE bytes)

[RETURNS]

Index of First Miscompared Byte in Buffers, 0 if Buffers the Same

[DESCRIPTION]

This function compares two data buffers and returns a non-zero value
if the buffer's data does not compare.  This number will be the index
of the first byte miscompared between the two bufffers or Zero if the
buffers were alike.  This Operation is Optimized in Assembly for the
fastests possible Comparison.

[SEE-ALSO]

FastCompare
CompareSmaller
CompareBufByte

[EXAMPLE]

TYPE
  TBuff = ARRAY[1..10] of BYTE;

VAR
  B1,B2 : TBuff;
  W     : WORD;

BEGIN

  FillChar( B1, SizeOf( B1 ), 4 );
  FillChar( B2, SizeOf( B2 ), 4 );

  B2[7] := 49;  { Force MisCompare }

  W := Compare( B1, B2, SizeOf( TBuff ) );

  { W = 7  - MisCompare Index! }

END;

-*)


Function  Compare(               Var Buf1;
                                 Var Buf2;
                                     Count     : WORD    ) : WORD;
Assembler;
ASM

  PUSH DS

  LES  DI, Buf1
  LDS  SI, Buf2
  MOV  CX, Count

  CLD
  REPE CMPSB

  JNE  @1

  XOR  AX, AX
  JMP  @2

 @1:
  MOV  AX, Count
  SUB  AX, CX

 @2:

  POP  DS

END;

{}

(*-

[FUNCTION]

Function  CompareSmaller(        Var Buf1;
                                 Var Buf2;
                                     Count     : WORD    ) : SHORTINT;

[PARAMETERS]

Buf1        VAR Address of First Buffer (Generic Type)
Buf2        VAR Address of Second Buffer (Generic Type)
Count       Number of bytes in each buffer (Max = $FFFE bytes)

[RETURNS]

Which Buffer Data contains the Smaller Value or if they Match
  -1 if first is smaller than the second buffer
   0 if they are the same
   1 if first is bigger than the second buffer

[DESCRIPTION]

This function tests two buffers to see which Buffer Data contains a smaller
value.  At the first Miscompare, the one with the lesser Value is indicated
with a non-zero value (-1 if the 1st Buffer byte is smaller than the 2nd,
1 if the 1st Buffer byte is greater than the 2nd, or 0 [Zero] if they are
both the same).

[SEE-ALSO]

FastCompare
Compare
CompareBufByte

[EXAMPLE]

TYPE
  TBuff = ARRAY[1..10] of BYTE;

VAR
  B1,B2 : TBuff;
  I     : INTEGER;

BEGIN

  FillChar( B1, SizeOf( B1 ), 4 );
  FillChar( B2, SizeOf( B2 ), 4 );

  B2[7] := 49;  { Force MisCompare }

  I := CompareSmaller( B1, B2, SizeOf( TBuff ) );

  { I = -1  - MisCompare, 1st Buffer Smaller! }

END;

-*)


Function  CompareSmaller(        Var Buf1;
                                 Var Buf2;
                                     Count     : WORD    ) : SHORTINT;

Assembler;
ASM

  PUSH DS

  MOV  CX, Count      {!^!must take into account segment fix-ups here!}
  LES  DI, Buf1
  ADD  DI, Count
  LDS  SI, Buf2
  ADD  SI, Count

 @START:

  DEC  DI
  DEC  SI

  MOV  BL, ES:[DI]
  MOV  BH, DS:[SI]
  CMP  BL, BH
  JB   @LESSER
  JA   @GREATER

  LOOP @START

 @FINISH:

  XOR  AL, AL
  JMP  @EXIT

 @LESSER:

  MOV  AL, $FF
  JMP  @EXIT

 @GREATER:

  MOV  AL, $01

 @EXIT:

  POP  DS

END;

{}

(*-

[FUNCTION]

Function  CompareBufByte(        Var Buff;
                                     Count     : WORD;
                                     B         : BYTE    ) : WORD;

[PARAMETERS]

Buff        VAR Address of Buffer (Generic Type)
Count       Number of bytes in each buffer (Max = $FFFE byte)
B           Comparison byte

[RETURNS]

Index of First Miscompared byte in Buffer, 0 if Buffer all data matches
Compare Byte

[DESCRIPTION]

Compares a buffer with a byte value to determine whether or not all bytes
in that buffer are the same as the comparison byte.  Returns Zero if all
buffer data bytes match the compare byte, otherwise returns the index
into the buffer of the miscompare.

[SEE-ALSO]

FastCompare
Compare
CompareSmaller

[EXAMPLE]

TYPE
  TBuffer = ARRAY[1..512] of BYTE;

VAR
  B : TBuffer;
  C : BYTE;
  W : WORD;

BEGIN

  { COMPARE MATCH }

  FillChar( B, 512, #30 );
  C := #30;
  W := CompareBufByte( B, 512, C );

  { W will now equal 0 (Comparison Match) }

  { COMPARE MISMATCH }

  B[274] := $FF;  { Just to make sure Doesn't Compare }
  W := CompareBufByte( B, 512, C );

  { W will now Equal 274 (Index of Mismatch) }

END.

TYPE
  TBuff = ARRAY[1..10] of BYTE;

VAR
  Buf : TBuff;
  B   : BYTE;
  W   : WORD;

BEGIN

  FillChar( Bur, SizeOf( TBuff ), 4 );
  Buf[7] := 49;  { Force MisCompare! }

  W := CompareSmaller( Buf, SizeOf( TBuff ), $04 );

  { W = 7  - MisCompare Index! }

END;

-*)

Function  CompareBufByte(        Var Buff;
                                     Count     : WORD;
                                     B         : BYTE    ) : WORD;
Assembler;
ASM

  LES  DI, Buff         { make da es:di --> da buff  }
  MOV  CX, Count        { make cx         = da count }
  MOV  AL, B            { make al         = byte to compare to }

  CLD                   { go ever forward }
  REPE SCASB            { repeat while equal - compare to accumulator }

  JNE  @1               { if they were not equal, go on to @2 ... }

  XOR  AX, AX           { make ax = 0   ( "equal" flag ) }
  JMP  @2               { git on outa here }

 @1:
  MOV  AX, Count        { convert value to offset of miscompare }
  SUB  AX, CX           { ... }

 @2:

END;


{}

(*-

[FUNCTION]

Function  CompareBufWord(        Var Buff;
                                     Count     : WORD;
                                     W         : WORD    ) : WORD;

[PARAMETERS]

Buff        VAR Address of Buffer (Generic Type)
Count       Number of Words in each buffer (Max of $FFFE bytes)
W           2-Byte Comparison Value

[RETURNS]

Word Index of First Miscompared Word in Buffer, 0 if Buffer all data
matches the 2-Byte Compare Value (a Word)

[DESCRIPTION]

Compares a buffer with a 2-Byte value (a WORD) to determine whether or
not all Words in that buffer are the same as the comparison byte.
Returns Zero if all buffer data words match the compare word, otherwise
returns the Word Index into the buffer of the miscompare.

[SEE-ALSO]

FastCompare
Compare
CompareSmaller

[EXAMPLE]

TYPE
  TBuffer = ARRAY[1..256] of BYTE;

VAR
  B : TBuffer;
  C : BYTE;
  W : WORD;

BEGIN

  { COMPARE MATCH }

  FillChar( B, SizeOf( TBuffer ), #30 );
  C := #30;
  W := CompareBufByte( B, 256, C );

  { W will now equal 0 (Comparison Match) }

  { COMPARE MISMATCH }

  B[137] := $FF;  { Just to make sure Doesn't Compare }
  W := CompareBufByte( B, 256, C );

  { W will now Equal 137 (Index of Mismatch) }

END.

-*)

Function  CompareBufWord(        Var Buff;
                                     Count     : WORD;
                                     W         : WORD    ) : WORD;
Assembler;
ASM

  LES  DI, Buff         { make da es:di --> da buff  }
  MOV  CX, Count        { make cx         = da count }
  MOV  AX, W            { make ax         = word to compare to }

  CLD                   { go ever forward }
  REPE SCASW            { repeat while equal - compare to accumulator }

  JNE  @1               { if they were not equal, go on to @2 ... }

  XOR  AX, AX           { make ax = 0   ( "equal" flag ) }
  JMP  @2               { git on outa here }

 @1:
  MOV  AX, Count        { convert value to offset of miscompare }
  SUB  AX, CX           { ... }

 @2:

END;


{}

(*-

[FUNCTION]

Function  LookupByte(                 InByte   : BYTE;
                                      Count    : WORD;
                                  Var LTable;
                                  Var OutByte  : BYTE              ) : BOOLEAN;

[PARAMETERS]

InByte      Source Byte to look up in Table
Count       Number of entries in the lookup table
LTable      Address of the lookup table
OutByte     Byte indentified by source byte in table

[RETURNS]

TRUE if the source byte was found in the table, FALSE if one was not.

[DESCRIPTION]

This function allow a quick lookup of a 2-byte record (the first byte
being the lookup key and the 2nd byte being the data to find).  The
actual record is set up as in the example below.  It is an array of
translation records (see example).

You pass in a prepared lookup table and ask it to find the data
associated with a specific "key".  This can be useful for such actions
as translation tables for error codes, etc.

[SEE-ALSO]

LookupWord

[EXAMPLE]

Type
  TTableRec = RECORD
    Key  : BYTE;
    Data : BYTE;
  END;

  TTable = Array[1..6] of TTableRec;

VAR
  T : TTable;
  B : BYTE;

BEGIN

  T[1].Key :=  0;   T[1].Data := 14;
  T[2].Key :=  3;   T[2].Data := 12;
  T[3].Key :=  7;   T[3].Data := 54;
  T[4].Key := 12;   T[4].Data :=  2;
  T[5].Key := 14;   T[5].Data :=  7;
  T[6].Key := 15;   T[6].Data :=  9;

  If LookupByte( 12, 6, @T, B ) Then
    WriteLn( 'Item Found in Table.  Data=',B )
  Else
    WriteLn( 'Item NOT Found in Table.' );

  {------------------------------------------------}
  { Output would be "Item Found in Table.  Data=2" }
  {------------------------------------------------}

END.

-*)

Function  LookupByte(                 InByte   : BYTE;
                                      Count    : WORD;
                                  Var LTable;
                                  Var OutByte  : BYTE              ) : BOOLEAN;
Assembler;
ASM

  LES  DI, LTable           { make da es:di --> da buff  }
  MOV  CX, Count            { make cx         = da count }
  MOV  AL, InByte           { make al         = byte to compare to }

  CLD                       { go ever forward }

 @Startloop:
  SCASB                     { compare ES:[DI] to in byte }
  JE   @Found               { If equal, jump to @Found   }
  SCASB                     { otherwise skip the next byte }
  LOOP @StartLoop           { and loop de loop ... }

  MOV  AX, 0                { we fell outa the loop; set return to FALSE }
  JMP  @Outahere            { E.T. goes home... }

 @Found:

  PUSH DS                   { save the ever important data seg }

  MOV  AL, byte PTR ES:[DI] { get the outbyte from da table }

  LDS  SI, OutByte          { make DS:SI --> outbyte var }
  MOV  byte PTR DS:[SI], AL { store the outbyte }

  MOV  AL, 1                { set return value to TRUE }

  POP DS

 @Outahere:

END;

{}

(*-

[FUNCTION]

Function  LookupWord(                 InWord   : WORD;
                                      Count    : WORD;
                                  Var LTable;
                                  Var OutWord  : WORD              ) : BOOLEAN;

[PARAMETERS]

InWord      Source word to look up in table
Count       Number of entries in the lookup table
LTable      Address of the lookup table
OutWord     Word indentified by source byte in table

[RETURNS]

TRUE if the source word was found in the table, FALSE if one was not.

[DESCRIPTION]

This function allow a quick lookup of a 4-byte record (the first word
being the lookup key and the second word being the data to find).  The
actual record is set up as in the example below.  It is an array of
translation records (see example).

You pass in a prepared lookup table and ask it to find the data
associated with a specific "key".  This can be useful for such actions
as translation tables for error codes, etc.

[SEE-ALSO]

LookupWord

[EXAMPLE]

TYPE
  TTableRec = RECORD
    Key  : WORD;
    Data : WORD;
  END;

  TTable = Array[1..6] of TTableRec;

VAR
  T : TTable;
  W : WORD;

BEGIN

  T[1].Key :=  0;   T[1].Data := 14;
  T[2].Key :=  3;   T[2].Data := 12;
  T[3].Key :=  7;   T[3].Data := 54;
  T[4].Key := 12;   T[4].Data :=  2;
  T[5].Key := 14;   T[5].Data :=  7;
  T[6].Key := 15;   T[6].Data :=  9;

  If LookupByte( 12, 6, @T, B ) Then
    WriteLn( 'Item Found in Table.  Data=',B )
  Else
    WriteLn( 'Item NOT Found in Table.' );

  {------------------------------------------------}
  { Output would be "Item Found in Table.  Data=2" }
  {------------------------------------------------}

END.

-*)

Function  LookupWord(                 InWord   : WORD;
                                      Count    : WORD;
                                  Var LTable;
                                  Var OutWord  : WORD              ) : BOOLEAN;
Assembler;
ASM

  LES  DI, LTable           { make da es:di --> da buff  }
  MOV  CX, Count            { make cx         = da count }
  MOV  AX, InWord           { make al         = word to compare to }

  CLD                       { go ever forward }

 @Startloop:
  SCASW                     { compare ES:[DI] to in byte }
  JE   @Found               { If equal, jump to @Found   }
  SCASW                     { otherwise skip the next byte }
  LOOP @StartLoop           { and loop de loop ... }

  MOV  AX, 0                { we fell outa the loop; set return to FALSE }
  JMP  @Outahere            { E.T. goes home... }

 @Found:

  PUSH DS                   { save the ever important data seg }

  MOV  AX, word PTR ES:[DI] { get the outword from da table }

  LDS  SI, OutWord          { make DS:SI --> outword var }
  MOV  word PTR DS:[SI], AX { store the outword }

  MOV  AL, 1                { set return value to TRUE }

  POP DS

 @Outahere:

END;


{}

(*-

[FUNCTION]

Procedure SwapBuffers(           Var Buf1;
                                 Var Buf2;
                                     Count     : WORD    );

[PARAMETERS]

Buf1        VAR Address of First buffer of data
Buf2        VAR Address of Second buffer of data
Count       Number of bytes to swap

[RETURNS]

(None)

[DESCRIPTION]

Swaps a given number of bytes between two types/untyped buffers.

[SEE-ALSO]

[EXAMPLE]

TYPE
  TBuff = ARRAY[1..10] of BYTE;

VAR
  B1,B2 : TBuff;

BEGIN

  FillChar( B1, SizeOf( B1 ), 1 );
  FillChar( B2, SizeOf( B2 ), 2 );

  SwapBuffers( B1,B2, SizeOf( TBuff ) );

  { B1 now filled with 2's and B2 filled with 1's }

END;

-*)


Procedure SwapBuffers(           Var Buf1;
                                 Var Buf2;
                                     Count     : WORD    );
Assembler;
ASM

  PUSH DS

  LES  DI, Buf1
  LDS  SI, Buf2
  MOV  CX, Count

 @1:
  MOV  AL, [SI]
  MOV  BL, ES:[DI]

  MOV  [SI], BL
  MOV  ES:[DI], AL

  INC  SI
  INC  DI

  LOOP @1

  POP  DS

END;

{}

(*-

[FUNCTION]

Procedure SwapWords(             Var A,
                                     B         : WORD    );

[PARAMETERS]

A           VAR First word to swap
B           VAR Second word to swap

[RETURNS]

(None)

[DESCRIPTION]

Executes a bufferless two-word swap

[SEE-ALSO]

SwapInts
SwapBytes

[EXAMPLE]

VAR
  W1,W2 : WORD;

BEGIN

  W1 := 5;
  W2 := 3;

  SwapWords( W1, W2 );

  { W1 = 3, W2 = 5 }

END;

-*)

Procedure SwapWords(             Var A,
                                     B         : WORD    );
Assembler;
ASM

  PUSH DS


  LDS  SI, A
  LES  DI, B

  MOV  AX, [DS:SI]
  MOV  BX, [ES:DI]

  MOV  word PTR ES:DI, AX
  MOV  word PTR DS:SI, BX

  POP  DS

END;

{}

(*-

[FUNCTION]

Procedure SwapInts(              Var A,
                                     B         : INTEGER );

[PARAMETERS]

A           VAR First integer to swap
B           VAR Second integer to swap

[RETURNS]

(None)

[DESCRIPTION]

Executes a bufferless two-integer swap

[SEE-ALSO]

SwapWords
SwapBytes

[EXAMPLE]

VAR
  I1,I2 : INTEGER;

BEGIN

  I1 :=  5;
  I2 := -3;

  SwapInts( I1, I2 );

  { I1 = -3; I2 = 5 }

END;

-*)

Procedure SwapInts(              Var A,
                                     B         : INTEGER  );
Assembler;
ASM

  PUSH DS

  LDS  SI, A
  LES  DI, B

  MOV  AX, [DS:SI]
  MOV  BX, [ES:DI]

  MOV  word PTR ES:DI, AX
  MOV  word PTR DS:SI, BX

  POP  DS

END;

{}

(*-

[FUNCTION]

Procedure SwapBytes(             Var A,
                                     B         : BYTE    );

[PARAMETERS]

A           VAR First byte to swap
B           VAR Second byte to swap

[RETURNS]

(None)

[DESCRIPTION]

Executes a Bufferless 2-Byte swap

[SEE-ALSO]

SwapWords
SwapInts

[EXAMPLE]

VAR
  B1,B2 : BYTE;

BEGIN

  B1 := 5;
  B2 := 3;

  SwapBytes( B1, B2 );

  { B1 = 3, B2 = 5 }

END;

-*)

Procedure SwapBytes(             Var A,
                                     B         : BYTE    );
Assembler;
ASM

  PUSH DS

  MOV  DS, word PTR [A+2]
  MOV  SI, word PTR [A]

  MOV  ES, word PTR [B+2]
  MOV  DI, word PTR [B]

  MOV  AL, [DS:SI]
  MOV  BL, [ES:DI]

  MOV  byte PTR ES:DI, AL
  MOV  byte PTR DS:SI, BL

  POP  DS

END;

{}

(*-

[FUNCTION]

Function  GreaterInt(                A,
                                     B         : INTEGER ) : INTEGER;

[PARAMETERS]

A           First integer to compare
B           Second integer to compare

[RETURNS]

Greater of the two provided integer

[DESCRIPTION]

Compares two integer and returns the greater.

[SEE-ALSO]

GreaterWord
GreaterLong
LesserInt
LesserWord
LesserLong

[EXAMPLE]

VAR
  I1,I2,I3 : INTEGER;

BEGIN

  I1 :=  5;
  I2 := -3;

  I3 := GreaterInt( I1, I2 );

  { I3 = 5 }

END;

-*)

Function  GreaterInt(                A,
                                     B         : INTEGER  ) : INTEGER;

BEGIN

  If A > B Then
    GreaterInt := A
  Else
    GreaterInt := B;

END;

{}

(*-

[FUNCTION]

Function  GreaterWord(               A,
                                     B         : WORD    ) : WORD;

[PARAMETERS]

A           First word to compare
B           Second word to compare

[RETURNS]

Greater of the two provided words

[DESCRIPTION]

Compares two words and returns the greater.

[SEE-ALSO]

GreaterInt
GreaterLong
LesserInt
LesserWord
LesserLong

[EXAMPLE]

VAR
  W1,W2,W3 : INTEGER;

BEGIN

  W1 := 5;
  W2 := 3;

  W3 := GreaterWord( W1, W2 );

  { W3 = 5 }

END;

-*)

Function  GreaterWord(               A,
                                     B         : WORD    ) : WORD;

Assembler;
ASM

  MOV  AX, A
  CMP  AX, B
  JAE  @ABOVE
  MOV  AX, B

 @ABOVE:

END;

{}

(*-

[FUNCTION]

Function  GreaterLong(               A,
                                     B         : LONGINT ) : LONGINT;

[PARAMETERS]

A           First longint (signed double word) to compare
B           Second longint to compare

[RETURNS]

Greater of the two provided longints

[DESCRIPTION]

Compares two longints (signed double words) and returns the greater

[SEE-ALSO]

GreaterInt
GreaterWord
LesserInt
LesserWord
LesserLong

[EXAMPLE]

VAR
  L1,L2,L3 : INTEGER;

BEGIN

  L1 := 5;
  L2 := 3;

  L3 := GreaterLong( L1, L2 );

  { L3 = 5 }

END;

-*)

Function  GreaterLong(               A,
                                     B         : LONGINT  ) : LONGINT;

BEGIN

  If A > B Then
    GreaterLong := A
  Else
    GreaterLong := B;

END;

{}

(*-

[FUNCTION]

Function  LesserInt(                 A,
                                     B         : INTEGER ) : INTEGER;

[PARAMETERS]

A           First integer to compare
B           Second integer to compare

[RETURNS]

Lesser of the two integers

[DESCRIPTION]

Compares two integers and returns the lesser

[SEE-ALSO]

GreaterInt
GreaterWord
GreaterLong
LesserWord
LesserLong

[EXAMPLE]

VAR
  I1,I2,I3 : INTEGER;

BEGIN

  I1 :=  5;
  I2 := -3;

  I3 := LesserLong( I1, I2 );

  { I3 = -3 }

END;

-*)

Function  LesserInt(                 A,
                                     B         : INTEGER  ) : INTEGER;

BEGIN

  If ( A < B ) Then
    LesserInt := A
  Else
    LesserInt := B;

END;

{}

(*-

[FUNCTION]

Function  LesserWord(                A,
                                     B         : WORD    ) : WORD;

[PARAMETERS]

A           First word to compare
B           Second word to compare

[RETURNS]

Lesser of the two words

[DESCRIPTION]

Compares two words and returns the lesser

[SEE-ALSO]

GreaterInt
GreaterWord
GreaterLong
LesserInt
LesserLong

[EXAMPLE]

VAR
  W1,W2,W3 : WORD;

BEGIN

  W1 := 5;
  W2 := 3;

  W3 := LesserWord( W1, W2 );

  { W3 = 3 }

END;

-*)

Function  LesserWord(                A,
                                     B         : WORD    ) : WORD;
Assembler;
ASM

  MOV  AX, A
  MOV  BX, B

  CMP  AX, BX
  JNA  @2

  MOV  AX, BX

 @2:

END;

{}

(*-

[FUNCTION]

Function  LesserLong(                A,
                                     B         : LONGINT ) : LONGINT;

[PARAMETERS]

A           First longint (double word) to compare
B           Second longint to compare

[RETURNS]

Lesser of the two longints

[DESCRIPTION]

Compares two longints (signed double words) and returns the lesser

[SEE-ALSO]

GreaterInt
GreaterWord
GreaterLong
LesserInt
LesserWord

[EXAMPLE]

VAR
  L1,L2,L3 : INTEGER;

BEGIN

  L1 := 5;
  L2 := 3;

  L3 := LesserLong( L1, L2 );

  { L3 = 3 }

END;

-*)

Function LesserLong(                 A,
                                     B         : LONGINT ) : LONGINT;

BEGIN

  If ( A < B ) Then
    LesserLong := A
  Else
    LesserLong := B;

END;  { LesserLong }

{}

(*-

[FUNCTION]

Procedure FillWord(              Var Buf;
                                     Count     : WORD;
                                     Value     : WORD    );
[PARAMETERS]

Buf         VAR Address of untyped Buffer to fill
Count       Number of Words to Fill
Value       Word Value to fill Buffer with

[RETURNS]

Function : None
(Var     : [Buf] Buffer fill with Value)

[DESCRIPTION]

Takes an Untyped Buffer and fills it with a given Word Value "Value"
up to the number of Words given in "Count".  This is the same thing
as PASCAL's FillChar except it allows you to fill with 2-Byte Patterns
instead.

WARNING: Make sure Count Represents Buffer Size in Terms of 2-Byte
Words rather than simply the number of bytes of the Buffer.  Otherwise
this may result in a buffer overrun, potentially overwritting other
data in memory.

[SEE-ALSO]

FillLong

[EXAMPLE]

TYPE
  TBuff = ARRAY[1..12] of BYTE;

VAR
  B : TBuff;

BEGIN

  FillWord( B, SizeOf( B ) DIV 2, $1234 );

  { Entire Buffer (B) Filled with 2-Byte Value $1234 }

END;

-*)


Procedure FillWord(              Var Buf;
                                     Count     : WORD;
                                     Value     : WORD    );
Assembler;
ASM

  LES DI, Buf
  MOV AX, Value
  MOV CX, Count

  CLD
  REP STOSW

END;

{}

(*-

Procedure FillLong(              Var Buf;
                                     Count     : WORD;
                                     Value     : LONGINT );
[PARAMETERS]

Buf         VAR Address of untyped Buffer to fill
Count       Number of Words to Fill
Value       Longint Value to fill Buffer with

[RETURNS]

Function : None
(Var     : [Buf] Buffer fill with Value)

[DESCRIPTION]

Takes an Untyped Buffer and fills it with a given Longint Value "Value"
up to the number of Longints given in "Count".  This is the same thing
as PASCAL's FillChar except it allows you to fill with 4-Byte Patterns
instead.

WARNING: Make sure Count Represents Buffer Size in Terms of 4-Byte
Words rather than simply the number of bytes of the Buffer.  Otherwise
this may result in a buffer overrun, potentially overwritting other
data in memory.

[SEE-ALSO]

FillWord

[EXAMPLE]

TYPE
  TBuff = ARRAY[1..12] of BYTE;

VAR
  B : TBuff;

BEGIN

  FillWord( B, SizeOf( B ) DIV 4, $12345678 );

  { Entire Buffer (B) Filled with 4-Byte Value $12345678 }

END;

-*)

Procedure FillLong(              Var Buf;
                                     Count     : WORD;
                                     Value     : LONGINT    );
Assembler;
ASM

  LES DI, Buf
  MOV AX, Word(Value)
  MOV BX, Word(Value+2)
  MOV CX, Count

  CLD

@@1:

  STOSW           { store the lower word   }
  XCHG AX,BX      { exchange low/high word }
  STOSW           { store the high  word   }
  XCHG AX,BX      { swap em back           }

  LOOP @@1        { loop de loop ...       }

END;


{}

(*-

[FUNCTION]

Procedure RebootMachine(             WarmBoot : BOOLEAN );

[PARAMETERS]

WarmBoot   TRUE to warmboot machine,
           FALSE to coldboot (do post and memory checks)


[RETURNS]

(None)

[DESCRIPTION]

Reboots the system.

NOTE:  On AT and compatible machines, the keyboard controler is wired
to the CPUs reboot line.  In this routine we reboot the machine by
telling the keyboard controller to "wiggle" the reboot line.  This is
the same thing that the code at $FFFF:0 does.  We program the reboot
directly instead of jumping to $FFFF:0 to avoid any DPMI calls that
would be otherwise necessary in protected mode / Windows.

[SEE-ALSO]

[EXAMPLE]


BEGIN

  WriteLn( 'Ready to Reboot your System.' );
  WriteLn( 'Press "W" to WarmBoot, otherwise will Coldboot' );

  RebootMachine( UpCase( ReadKey ) = 'W' );

END;

-*)


Procedure RebootMachine(   WarmBoot : BOOLEAN );

BEGIN

  {$IFDEF OS2}

  {$ELSE}
    If WarmBoot Then
      BiosMemMap^.PostReset := $1234
    Else
      BiosMemMap^.PostReset := $0000;

    ASM

      MOV     dx, 70h
      MOV     al, 0Fh
      OUT     dx, al
      INC     dx
      XOR     al, al
      OUT     dx, al
      DEC     ax

      MOV     al, 0FEh
      MOV     dx, 64h
      OUT     dx, al

    END;

  {$ENDIF}

END;

{}



(*-

[FUNCTION]

Procedure CRC16Char(           Var Ch          : CHAR;
                               Var Result      : WORD );

[PARAMETERS]

Ch          VAR Address of Source Byte to CRC
Result      VAR Returned 16-Bit CRC Checksum on Source Byte

[RETURNS]

Function : None
(Var     : [Result] Returned 16-Bit CRC Checksum on Source Byte)

[DESCRIPTION]

[SEE-ALSO]

CRC16String
CRC16Buffer
CRC32Char
CRC32String
CRC32Buffer

[EXAMPLE]

VAR
  Ch    : CHAR;
  CRC16 : WORD;

BEGIN

  Ch := 'A';

  CRC16Char( Ch, CRC16 );

  { CRC16 = $0041 }

END;

-*)

Procedure CRC16Char(           Var Ch          : CHAR;
                               Var Result      : WORD );

CONST

  {

  updcrc derived from article Copyright (C) 1986 Stephen Satchell.
  NOTE: First argument must be in range 0 to 255.
        Second argument is referenced twice.

  Programmers may incorporate any or all code into their programs,
  giving proper credit within the source. Publication of the
  source routines is permitted so long as proper credit is given
  to Stephen Satchell, Satchell Evaluations and Chuck Forsberg,
  Omen Technology.

  crctab calculated by Mark G. Mendel, Network Systems Corporation

  }

  CRCTab16 : Array[Byte] of WORD =

   ($0000, $1021, $2042, $3063, $4084, $50A5, $60C6, $70E7,
    $8108, $9129, $A14A, $B16B, $C18C, $D1AD, $E1CE, $F1EF,
    $1231, $0210, $3273, $2252, $52B5, $4294, $72F7, $62D6,
    $9339, $8318, $B37B, $A35A, $D3BD, $C39C, $F3FF, $E3DE,
    $2462, $3443, $0420, $1401, $64E6, $74C7, $44A4, $5485,
    $A56A, $B54B, $8528, $9509, $E5EE, $F5CF, $C5AC, $D58D,
    $3653, $2672, $1611, $0630, $76D7, $66F6, $5695, $46B4,
    $B75B, $A77A, $9719, $8738, $F7DF, $E7FE, $D79D, $C7BC,
    $48C4, $58E5, $6886, $78A7, $0840, $1861, $2802, $3823,
    $C9CC, $D9ED, $E98E, $F9AF, $8948, $9969, $A90A, $B92B,
    $5AF5, $4AD4, $7AB7, $6A96, $1A71, $0A50, $3A33, $2A12,
    $DBFD, $CBDC, $FBBF, $EB9E, $9B79, $8B58, $BB3B, $AB1A,
    $6CA6, $7C87, $4CE4, $5CC5, $2C22, $3C03, $0C60, $1C41,
    $EDAE, $FD8F, $CDEC, $DDCD, $AD2A, $BD0B, $8D68, $9D49,
    $7E97, $6EB6, $5ED5, $4EF4, $3E13, $2E32, $1E51, $0E70,
    $FF9F, $EFBE, $DFDD, $CFFC, $BF1B, $AF3A, $9F59, $8F78,
    $9188, $81A9, $B1CA, $A1EB, $D10C, $C12D, $F14E, $E16F,
    $1080, $00A1, $30C2, $20E3, $5004, $4025, $7046, $6067,
    $83B9, $9398, $A3FB, $B3DA, $C33D, $D31C, $E37F, $F35E,
    $02B1, $1290, $22F3, $32D2, $4235, $5214, $6277, $7256,
    $B5EA, $A5CB, $95A8, $8589, $F56E, $E43F, $D52C, $C50D,
    $34E2, $24C3, $14A0, $0481, $7466, $6447, $5424, $4405,
    $A7DB, $B7FA, $8799, $97B8, $E75F, $F77E, $C71D, $D73C,
    $26D3, $36F2, $0691, $16B0, $6657, $7676, $4615, $5634,
    $D94C, $C96D, $F90E, $E92F, $99C8, $89E9, $B98A, $A9AB,
    $5844, $4865, $7806, $6827, $18C0, $08E1, $3882, $28A3,
    $CB7D, $DB5C, $EB3F, $FB1E, $8BF9, $9BD8, $ABBB, $BB9A,
    $4A75, $5A54, $6A37, $7A16, $0AF1, $1AD0, $2AB3, $3A92,
    $FD2E, $ED0F, $DD6C, $CD4D, $BDAA, $AD8B, $9DE8, $8DC9,
    $7C26, $6C07, $5C64, $4C45, $3CA2, $2C83, $1CE0, $0CC1,
    $EF1F, $FF3E, $CF5D, $DF7C, $AF9B, $BFBA, $8FD9, $9FF8,
    $6E17, $7E36, $4E55, $5E74, $2E93, $3EB2, $0ED1, $1EF0);

BEGIN

  Result := CRCTab16[(Result SHR 8) AND $FF] XOR (Result SHL 8) XOR Byte(Ch);

END;

{}

(*-

[FUNCTION]

Procedure CRC16Buffer(         Var Buf;
                                   Count       : WORD;
                               Var Result      : WORD );

[PARAMETERS]

Buf         VAR Address of untyped Data Buffer to CRC
Count       Number of bytes in Data Buffer
Result      VAR 16-bit CRC totals on Data Buffer

[RETURNS]

Function : None
(Var     : [Result] 16-bit CRC on the Buffer)

[DESCRIPTION]

[SEE-ALSO]

CRC16Char
CRC16String
CRC32Char
CRC32String
CRC32Buffer

[EXAMPLE]

TYPE
  TBuff = ARRAY[1..10] of BYTE;

VAR
  B     : TBuff;
  CRC16 : WORD;

BEGIN

  FillChar( B, SizeOf( B ), $04 );
  CRC16 := 0;

  CRC16Buffer( B, SizeOf( B ), CRC16 );

  { CRC16 = $43D3 }

END;

-*)

Procedure CRC16Buffer(         Var Buf;
                                   Count       : WORD;
                               Var Result      : WORD );

Var

  I    : WORD;

BEGIN

  For I := 0 to Count Do
    CRC16Char( Char(TByteArray(Buf)[I]), Result );

END;

{}

(*-

[FUNCTION]

Procedure CRC32Char(           Var Ch          : CHAR;
                               Var Result      : LONGINT );

[PARAMETERS]

Ch          VAR Address of Source Byte to CRC
Result      VAR Returned 32-Bit CRC Checksum on Source Byte

[RETURNS]

Function : None
(Var     : [Result] 32-Bit CRC Checksum on Source Byte)

[DESCRIPTION]

[SEE-ALSO]

CRC16Char
CRC16String
CRC16Buffer
CRC32String
CRC32Buffer

[EXAMPLE]

VAR
  Ch    : CHAR;
  CRC32 : LONGINT;

BEGIN

  Ch := 'A';

  CRC32Char( Ch, CRC32 );

  { CRC32 = $01DB7106 }

END;

-*)

Procedure CRC32Char(           Var Ch          : CHAR;
                               Var Result      : LONGINT );

CONST

  {

  Copyright (C) 1986 Gary S. Brown.  You may use this program, or
  code or tables extracted from it, as desired without restriction.

  }

  CRCTab32 : Array[Byte] of LONGINT =

 ($00000000, $77073096, $EE0E612C, $990951BA, $076DC419, $706AF48F, $E963A535, $9E6495A3,
  $0EDB8832, $79DCB8A4, $E0D5E91E, $97D2D988, $09B64C2B, $7EB17CBD, $E7B82D07, $90BF1D91,
  $1DB71064, $6AB020F2, $F3B97148, $84BE41DE, $1ADAD47D, $6DDDE4EB, $F4D4B551, $83D385C7,
  $136C9856, $646BA8C0, $FD62F97A, $8A65C9EC, $14015C4F, $63066CD9, $FA0F3D63, $8D080DF5,
  $3B6E20C8, $4C69105E, $D56041E4, $A2677172, $3C03E4D1, $4B04D447, $D20D85FD, $A50AB56B,
  $35B5A8FA, $42B2986C, $DBBBC9D6, $ACBCF940, $32D86CE3, $45DF5C75, $DCD60DCF, $ABD13D59,
  $26D930AC, $51DE003A, $C8D75180, $BFD06116, $21B4F4B5, $56B3C423, $CFBA9599, $B8BDA50F,
  $2802B89E, $5F058808, $C60CD9B2, $B10BE924, $2F6F7C87, $58684C11, $C1611DAB, $B6662D3D,
  $76DC4190, $01DB7106, $98D220BC, $EFD5102A, $71B18589, $06B6B51F, $9FBFE4A5, $E8B8D433,
  $7807C9A2, $0F00F934, $9609A88E, $E10E9818, $7F6A0DBB, $086D3D2D, $91646C97, $E6635C01,
  $6B6B51F4, $1C6C6162, $856530D8, $F262004E, $6C0695ED, $1B01A57B, $8208F4C1, $F50FC457,
  $65B0D9C6, $12B7E950, $8BBEB8EA, $FCB9887C, $62DD1DDF, $15DA2D49, $8CD37CF3, $FBD44C65,
  $4DB26158, $3AB551CE, $A3BC0074, $D4BB30E2, $4ADFA541, $3DD895D7, $A4D1C46D, $D3D6F4FB,
  $4369E96A, $346ED9FC, $AD678846, $DA60B8D0, $44042D73, $33031DE5, $AA0A4C5F, $DD0D7CC9,
  $5005713C, $270241AA, $BE0B1010, $C90C2086, $5768B525, $206F85B3, $B966D409, $CE61E49F,
  $5EDEF90E, $29D9C998, $B0D09822, $C7D7A8B4, $59B33D17, $2EB40D81, $B7BD5C3B, $C0BA6CAD,
  $EDB88320, $9ABFB3B6, $03B6E20C, $74B1D29A, $EAD54739, $9DD277AF, $04DB2615, $73DC1683,
  $E3630B12, $94643B84, $0D6D6A3E, $7A6A5AA8, $E40ECF0B, $9309FF9D, $0A00AE27, $7D079EB1,
  $F00F9344, $8708A3D2, $1E01F268, $6906C2FE, $F762575D, $806567CB, $196C3671, $6E6B06E7,
  $FED41B76, $89D32BE0, $10DA7A5A, $67DD4ACC, $F9B9DF6F, $8EBEEFF9, $17B7BE43, $60B08ED5,
  $D6D6A3E8, $A1D1937E, $38D8C2C4, $4FDFF252, $D1BB67F1, $A6BC5767, $3FB506DD, $48B2364B,
  $D80D2BDA, $AF0A1B4C, $36034AF6, $41047A60, $DF60EFC3, $A867DF55, $316E8EEF, $4669BE79,
  $CB61B38C, $BC66831A, $256FD2A0, $5268E236, $CC0C7795, $BB0B4703, $220216B9, $5505262F,
  $C5BA3BBE, $B2BD0B28, $2BB45A92, $5CB36A04, $C2D7FFA7, $B5D0CF31, $2CD99E8B, $5BDEAE1D,
  $9B64C2B0, $EC63F226, $756AA39C, $026D930A, $9C0906A9, $EB0E363F, $72076785, $05005713,
  $95BF4A82, $E2B87A14, $7BB12BAE, $0CB61B38, $92D28E9B, $E5D5BE0D, $7CDCEFB7, $0BDBDF21,
  $86D3D2D4, $F1D4E242, $68DDB3F8, $1FDA836E, $81BE16CD, $F6B9265B, $6FB077E1, $18B74777,
  $88085AE6, $FF0F6A70, $66063BCA, $11010B5C, $8F659EFF, $F862AE69, $616BFFD3, $166CCF45,
  $A00AE278, $D70DD2EE, $4E048354, $3903B3C2, $A7672661, $D06016F7, $4969474D, $3E6E77DB,
  $AED16A4A, $D9D65ADC, $40DF0B66, $37D83BF0, $A9BCAE53, $DEBB9EC5, $47B2CF7F, $30B5FFE9,
  $BDBDF21C, $CABAC28A, $53B39330, $24B4A3A6, $BAD03605, $CDD70693, $54DE5729, $23D967BF,
  $B3667A2E, $C4614AB8, $5D681B02, $2A6F2B94, $B40BBE37, $C30C8EA1, $5A05DF1B, $2D02EF8D);

BEGIN

  Result := CRCTab32[(Result XOR Byte(Ch)) AND $FF] XOR (Result SHR 8);

END;

{}

(*-

[FUNCTION]

Procedure CRC32Buffer(         Var Buf;
                                   Count       : WORD;
                               Var Result      : LONGINT );

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

CRC16Char
CRC16String
CRC16Buffer
CRC32Char
CRC32String

[EXAMPLE]

TYPE
  TBuff = ARRAY[1..10] of BYTE;

VAR
  B     : TBuff;
  CRC32 : LONGINT;

BEGIN

  FillChar( B, SizeOf( B ), $04 );
  CRC32 := 0;

  CRC32Buffer( B, SizeOf( B ), CRC32 );

  { CRC32 = $1716C742 }

END;
-*)

Procedure CRC32Buffer(         Var Buf;
                                   Count       : WORD;
                               Var Result      : LONGINT );

Var

  I    : WORD;

BEGIN

  For I := 0 to Count Do
    CRC32Char( Char(TByteArray(Buf)[I]), Result );

END;

{}


(*-

[FUNCTION]

Function  SoundexPack(               S         : STRING  ) : WORD;

[PARAMETERS]

S           Text string (one text word) to Soundex Encode and pack

[RETURNS]

Packed (as WORD) Soundex Code for string

[DESCRIPTION]

Soundex Encodes a text string and packs it as word value.
A Soundex Code is an AlphaNumeric Code derived from the pronounciation
of a text word.  It's standard format is the first letter of the
original word along with a numbering system designed to encompass
sounds of similar pronounciation.  The result is that the Soundex Code
for a word is the same as a Soundex for a word which sounds the same.
(ie. "There", "Their", and "They're" would all have the same Soundex
Code).  This resulting code is further compressed from 4 bytes downto
the space of a single binary word (2 bytes).  Uses SoundexUnPack to
revert to it's standard Soundex Format.  This Packed Code may be used
just as you would the standard Soundex Code in all operations and uses.
In fact, it is recommended to be used in this format for saving of
record storage space as well as simplicity of comparison tests.

[SEE-ALSO]

SoundexUnPack
SoundexStr

[EXAMPLE]

VAR
  W1,W2 : WORD;

BEGIN

  W1 := SoundexPack( 'Jonson' );
  W2 := SoundexPack( 'Johnsonn' );

  { Both W1 and W2 contain the value 10765 }

END;

-*)

Function  SoundexPack(               S         : STRING  ) : WORD;

Type

  TN = Array[0..255] of INTEGER;

Var

  N     : TN;
  I     : INTEGER;
  Err   : INTEGER;
  Temp  : STRING;
  W1,W2 : WORD;

BEGIN

  FillChar( N, SizeOf( N ), 0 );

  For I := 1 to Byte( S[0] ) Do
  BEGIN

    S[I] := UpCase( Char( S[I] ) );

    N[I] := Byte( S[I] );

    If Pos(Char(N[I]), 'BFPV') > 0 Then
      N[I] := 1
    Else

    If Pos(Char(N[I]), 'CGJKQSXZ') > 0 Then
      N[I] := 2
    Else

    If Pos(Char(N[I]), 'DT') > 0 Then
      N[I] := 3
    Else

    If N[I] = Byte('L') Then
      N[I] := 4
    Else

    If Pos(Char(N[I]), 'MN') > 0 Then
      N[I] := 5
    Else

    If N[I] = Byte('R') Then
      N[I] := 6
    Else
      N[I]:=0;

    If N[I-1] = N[I] Then
      N[I] := 0;

  END;

  Temp := S[1];

  For I := 2 to Byte( S[0] ) Do
  BEGIN

    If (N[I] <> 0) Then
    BEGIN

      Temp := Temp + Char( N[I] + 48 );

      If ( Byte( Temp[0] ) = 4) Then
        I := Byte(S[0]);

    END;

  END;

  While ( Byte( Temp[0] ) < 4) Do
    Temp := Temp + '0';

  W1 := Byte( Byte( Temp[1] ) - 64 ); {FIRST CONVERT THE ALPHA}
  W1 := (W1 SHL 10);

  Temp[1] := '0';                    {NOW CONVERT THE NUMERICS}
  Val( Temp, I, Err );
  W2 := I;

  SoundexPack := W1 + W2;

END;

{}

(*-

[FUNCTION]

Function  SoundexUnPack(             W         : WORD    ) : STRING;

[PARAMETERS]

W           Word representing Packed Soundex Code to be unpacked

[RETURNS]

Standard Unpacked Soundex Code from Packed Code Value

[DESCRIPTION]

Unpacks a soundex code from packed code value.
A Soundex Code is an AlphaNumeric Code derived from the pronounciation
of a text word.  It's standard format is the first letter of the
original word along with a numbering system designed to encompass
sounds of similar pronounciation.  (See SoundexPack for example)  This
takes the packed 2 byte compressed Soundex Code and uncompresses it
it's standard Soundex Format as a 4 byte string Code.  It is recommended
that for operational uses, the compressed for be used for both the
savings of record storage space as well as simplicity of comparison tests.

[SEE-ALSO]

SoundexPack
SoundexStr

[EXAMPLE]

VAR
  W : WORD;
  S : STRING;

BEGIN

  W := SoundexPack( 'Jonson' );
  S := SoundexUnPack( W );

  { W = 10765, S = 'J525' }

END;

-*)


Function  SoundexUnPack(             W         : WORD    ) : STRING;

Var

  W1,W2 : WORD;
  T1,T2 : STRING;

BEGIN

  T1 := '';
  T2 := '';

  W1 := W SHR 10;            {extract alpha code}
  T1[1] := CHAR( W1 + 64 );   {shift back to alpha range}
  W1 := W1 SHL 10;
  W2 := ( W1 XOR W );

  Str( W2:3, T2 );
  T1 := T1[1] + T2;

  If (T1[2] = ' ') Then
    T1[2] := '0';
  If (T1[3] = ' ') Then
    T1[3] := '0';

  SoundexUnPack := T1;

END;


{}

(*-

[FUNCTION]

Function  SoundexStr(                S         : STRING  ) : STRING;

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

For the rare instances when one would like to display the actual Soundex
Symbolic Code, this function will output that Symbolic Code as a string.

Use of this is more for show than actually utilizing the data, as it is
always faster and much more efficient to use a Packed Soundex Code value
for all comparison operations than to compare by Strings.

[SEE-ALSO]

SoundexPack
SoundexUnPack

[EXAMPLE]

VAR
  S : STRING;

BEGIN

  S := SoundexStr( 'Jonson' );

  { S = 'J525' }

END;

-*)

Function  SoundexStr(                S         : STRING  ) : STRING;

BEGIN

  SoundexStr := SoundexUnPack( SoundexPack( S ) );

END;


{}

(*-

[FUNCTION]

Function  PtrToLin(                  Ptr       : POINTER ) : LONGINT;

[PARAMETERS]

Ptr         Pointer Address to Convert to Linear Address

[RETURNS]

Linear Address associated with Pointer Address

[DESCRIPTION]

Converts a Segmented Address Pointer into a Linear Memory Address.

This is most useful for Windows or DPMI Pointer routines.
This could also be used to manipulate Pointer Math.

[SEE-ALSO]

LinToPtr

[EXAMPLE]

VAR
  P : POINTER;
  L : LONGINT;

BEGIN

  P := Ptr( $A000, $0 );
  L := PtrToLin( P );

  { L = $000A0000 }

END;

-*)

Function PtrToLin(           Ptr       : POINTER      ) : LONGINT;

BEGIN



  { for windows or dpmi -- call get selector base and add offset }
  { to return the linear address.                                }


  PtrToLin :=   Longint( TCastDWord( Ptr ).LowWord ) +
              ( Longint( TCastDWord( Ptr ).HighWord ) SHL 4 );

END;

{}

(*-

[FUNCTION]

Function  LinToPtr(                  Lin       : LONGINT ) : POINTER;

[PARAMETERS]

Lin         Linear Memory Address

[RETURNS]

Pointer associated with same Linear Memory Address

[DESCRIPTION]

Converts a Linear Memory Address Longint into a Segmented Memory Addr
Pointer.

[SEE-ALSO]

PtrToLin

[EXAMPLE]

VAR
  P : POINTER;
  L : LONGINT;

BEGIN

  L := $000A0000;
  P := LinToPtr( L );

  { P = $A000:0000 }

END;

-*)

Function LinToPtr(          Lin        : LONGINT      ) : POINTER;

BEGIN

  LinToPtr := Ptr( Lin SHR 4, Lin MOD 16 );

END;

{}

(*-

[FUNCTION]

Function  PtrAdd(                    OrigPtr   : POINTER;
                                     AddOfs    : LONGINT ) : POINTER;

[PARAMETERS]

OrigPtr     Source Pointer to work with
AddOfs      Pointer Offset to Add

[RETURNS]

New Pointer from the above pointer math

[DESCRIPTION]

This function will take the provided Source Pointer and Add to it the
Offset Address "AddOfs" to come up with another Pointer Address.  This
is math at the Pointer Level and comes in very useful with routines
emulating C Style Pointer operations.

[SEE-ALSO]

PtrSub
PtrDiff

[EXAMPLE]

VAR
  T,P : POINTER;
  Len : INTEGER;

BEGIN

  T   := NewString( 300, 'This is a Test' + #0 );
  { T is now a "C"-Type String }

  P   := T;
  Len := 0;

  While ( P <> #0) Do
  BEGIN
    Inc( Len );
    P := PtrAdd( P, 1 );
  END;

  { Len now equals the length of the AsciiZ string }

END;

-*)

Function PtrAdd(             OrigPtr   : POINTER;
                             AddOfs    : LONGINT      ) : POINTER;

BEGIN

  PtrAdd := Ptr( TCastDWord( OrigPtr ).HighWord +
                 TCastDWord( AddOfs  ).HighWord * SelectorInc,
                 TCastDWord( OrigPtr ).LowWord  +
                 TCastDWord( AddOfs  ).LowWord                 );


END;

{}

(*-

[FUNCTION]

Function  PtrSub(                    OrigPtr   : POINTER;
                                     SubOfs    : LONGINT ) : POINTER;

[PARAMETERS]

OrigPtr     Source Pointer to work with
SubOfs      Pointer Offset to Subtract

[RETURNS]

New Pointer from the above pointer math

[DESCRIPTION]

This function will take the provided Source Pointer and Subtract from
it's address the Offset "SubOfs" to produce another pointer.  This is
basically math at the Pointer Level and can be very useful when used
much like C Pointer routines

Suggest that this may be more useful moving Pointer Indexes into
DataBases.

[SEE-ALSO]

PtrAdd
PtrDiff

[EXAMPLE]


VAR
  P   : POINTER;
  Len : INTEGER;

BEGIN

  P   := NewString( 300, 'This is a Test'+#0 );
  { P is now a "C"-Type String }

  Len := 0;

  While ( P <> #0) Do
  BEGIN
    Inc( Len );
    P := PtrAdd( P, 1 );
  END;

  P := PtrSub( P, Len );

  {------------------------------------------------------}
  { "Len" now equals the length of the AsciiZ string     }
  { while "P" is returned to the original string address }
  {------------------------------------------------------}


  {-------------------------------------------------}
  { GRANTED THIS IS NOT AN EXAMPLE OF OPTIMAL USAGE }
  { BUT IT DOES SHOW THE ACTION.                    }
  {-------------------------------------------------}

END;

-*)

Function PtrSub(             OrigPtr   : POINTER;
                             SubOfs    : LONGINT      ) : POINTER;

BEGIN



  PtrSub := Ptr( TCastDWord( OrigPtr ).HighWord -
                 TCastDWord( SubOfs  ).HighWord * SelectorInc,
                 TCastDWord( OrigPtr ).LowWord  -
                 TCastDWord( SubOfs  ).LowWord                 );



END;

{}

(*-

[FUNCTION]

Function  PtrDiff(                A             : POINTER;
                                  B             : POINTER       ) : LONGINT;

[PARAMETERS]

A           1st pointer
B           2nd pointer

[RETURNS]

Difference between the two pointers.

[DESCRIPTION]

Returns the difference between two pointers.

[SEE-ALSO]

PtrSub
PtrAdd

[EXAMPLE]

-*)

Function  PtrDiff(                A             : POINTER;
                                  B             : POINTER       ) : LONGINT;

BEGIN

  PtrDiff := (LongInt(TCastDWord(A).HighWord) SHL TCastDWord(A).LowWord+4) -
             (LongInt(TCastDWord(B).HighWord) SHL TCastDWord(B).LowWord+4);

END;

{}


(*-

[FUNCTION]

Procedure FarCall(          Proc          : POINTER );

[PARAMETERS]

Proc        Far Pointer to Procedure to Call

[RETURNS]

(None)

[DESCRIPTION]

Jumps to the Far Pointer and executes the Procedure.

NOTE: Caller must be sure to declare his Procedures to be called
as Far Procedures as shown in the Example below.

[SEE-ALSO]

(None)

[EXAMPLE]

Procedure MyRoutine; Far
BEGIN
  WriteLn( 'Something to Do.');
END;

BEGIN

  FarCall( @MyRoutine );

END.

-*)

Procedure FarCall(          Proc          : POINTER );

Assembler;
ASM

  CALL [PROC]

END;



Procedure SetJump(                JumpInfo      : PJumpInfo     );



BEGIN

  ASM

    LES  BX, dword PTR [JumpInfo]

    MOV  SI, SP                   { get SP   }

    MOV  AX, word PTR SS:[SI+2]   { get BP   }
    MOV  word PTR ES:[BX  ],AX    { store it }

    MOV  AX, word PTR SS:[SI+4]   { get IP   }
    MOV  word PTR ES:[BX+2],AX    { store it }

    MOV  AX, word PTR SS:[SI+6]   { get CS   }
    MOV  word PTR ES:[BX+4],AX    { store it }

    MOV  word PTR ES:[BX+6],SI    { store SP }

  END;

END;


Procedure LongJump(               JumpInfo      : PJumpInfo     );

BEGIN

  ASM

    LES BX, dword PTR [jumpinfo]

    MOV SI, SP



  END;

END;


Procedure EnableInts; Assembler;

ASM
  CLI;
END;

Procedure DisableInts; Assembler;

ASM
  STI;
END;


Procedure PushWord(               W             : WORD          );

BEGIN

END;

Procedure PushLong(               L             : LONGINT       );

BEGIN

END;

Procedure PushPtr(                P             : POINTER       );

BEGIN

END;

Function  PopWord : WORD;

BEGIN

END;

Function  PopLong : LONGINT;

BEGIN

END;

Function  PopPtr  : POINTER;

BEGIN

END;

Procedure BufferSRByte(    Buffer         : POINTER;
                           BuffSize       : WORD;
                           ByteToLookfor  : BYTE;
                           ReplaceWith    : BYTE      );

ASSEMBLER;

ASM

  LES DI, dword PTR [BUFFER]
  MOV AL, ByteToLookFor
  CLD
  MOV CX, BuffSize
  MOV AH, ReplaceWith

 @@1:
  REPNE SCASB
  JNE @@2

  MOV byte PTR ES:[DI-1], AH
  JCXZ @@2

  JMP @@1

 @@2:

END;

{}

Function  GetNextTwirlyChar : CHAR;

BEGIN

  If cTwirlyCurPos=8 Then
    cTwirlyCurPos:=1
  Else
    Inc( cTwirlyCurPos );


  GetNextTwirlyChar := cTwirlyString[ cTwirlyCurPos ];

END;

{}
{}
{}

BEGIN
END.
