Program VGI;


Uses

  DOS,
  VTypesu,
  VStringu,
  VGenu,
  VDoshu;


Var
  TotalFuncs : LONGINT;

Procedure GrabInterface(          IncPreFace  : BOOLEAN;
                                  GetComments : BOOLEAN;
                                  InFile      : STRING;
                                  OutFile     : STRING     );

Var

  FI : TEXT;
  FO : TEXT;

  T  : STRING;
  T2 : STRING;

  FoundInterface : BOOLEAN;
  FoundImp       : BOOLEAN;

  InComment      : BOOLEAN;
  ThisFuncs      : LONGINT;

BEGIN

  Assign( FI, InFile );
  Reset( FI );

  Assign( FO, OutFile );
  Rewrite( FO );

  FoundInterface := FALSE;
  FoundImp       := FALSE;

  ThisFuncs := 0;

  While (Not Eof( FI )) and (FoundImp=FALSE) Do
  BEGIN

    ReadLn( FI, T );

    T2 := UpperString( TrimChar( T, onCenter, ' ' ));

    If T2 = 'IMPLEMENTATION' Then
      FoundImp := TRUE
    ELSE
    BEGIN

      If T2 = 'INTERFACE' Then
      BEGIN

        FoundInterface := TRUE;

      END
      ELSE
      BEGIN

        If (IncPreFace) or (FoundInterface) Then
        BEGIN
          WriteLn( FO, T );

        END;  { if incpreface or foundinterface }

      END; { if t2=interface / else }

    END; { if t2=implementation / else }

  END; { while not eof ... }




  InComment := FALSE;

  If GetComments Then
  While (Not Eof( FI )) Do
  BEGIN

    ReadLn( FI, T );

    T2 := UpperString( TrimChar( T, onCenter, ' ' ));


    If T2='[FUNCTION]' Then
    BEGIN
      Inc( ThisFuncs  );
      Inc( TotalFuncs );

    END;


    If Not InComment Then
    BEGIN

      If Copy(T2, 1, 3)='(*-' Then
      BEGIN
        InComment := TRUE;

        WriteLn( FO, '' );
        WriteLn( FO, RepeatString( '', 78 ) );
        WriteLn( FO, '' );

      END;

    END
    ELSE
    BEGIN

      If Copy(T2, 1, 3)='-*)' Then
        InComment := FALSE
      ELSE
        WriteLn( FO, T );

    END;

  END;


  Close( FI );
  Close( FO );

  Write('  Functions/Procedures:',ThisFuncs );


END; { procedure grabinterface }


{----------------------------------------------------------------}


Procedure SearchFiles( WildCard : STRING );


Var

  DirInfo : SearchRec;

  DestFile : STRING;

BEGIN

  FindFirst( WildCard, Archive, DirInfo );

  While DosError = 0 Do
  BEGIN

    DestFile := MaskWildCards( DirInfo.Name, '*.INT' );

    Write( DirInfo.Name+' -=> ', DestFile );

    GrabInterface( TRUE,
                   TRUE,
                   DirInfo.Name,
                   DestFile      );

    WriteLn;

    FindNext(DirInfo);

  END;

  WriteLn;
  WRiteLn;
  WriteLn('Total functions/procedures:',TotalFuncs );

END;


{----------------------------------------------------------------}

BEGIN

  WriteLn;
  WriteLn('Visionix Grab Interface Program (VGI) 0.9');
  WriteLN('Copyright 1993 Visionix');
  WriteLn('ALL RIGHTS RESERVED');
  WriteLn;

  If ParamCount=1 Then
    SearchFiles( ParamStr( 1 ) )
  ELSE
    WriteLn('Usage:  VGI filespec');

  WriteLn;

END.