{
 

 Visionix Inline Unit (VSER)
   Version 0.5
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 revision history in reverse chronological order:

 Initials  Date      Comment

     

 12/07/93  jrt       Started this unit.

 
}

(*-

[SECTION: Section 1: The General Libraries]
[CHAPTER: Chapter 8: The inline Function Library]

[TEXT]

<Overview>

This unit consists of functions which are (or will be) implemented as
Borland Pascal 7.0 INLINE function types.

Currently this unit includes functions that replace the Turbo Pascal
compilers string concatanation functions and expressions.  The TP
functions and expressions (IE: the Concat function and the S := S+ '???'
type expression) are _extremely_ slow.  As an example, by changing
to these functions from the Concat function, the ANSI filter found
in VANSIIOU increased in performance by over 40% on a 486/50 machine.

These functions are all implemented as fast assembly routines that
do no paramater checking whatsoever.  When concatenating two string
with these functions, the caller must make sure that the two
strings will not be over 255 bytes in length when concatenated.

<Interface>

-*)


Unit VInlineu;

Interface

Uses

  VTypesu;

Procedure StrAddCh(           Var S1             : STRING;
                                  TheCH          : CHAR         );

Procedure StrAddStr(          Var S1             : STRING;
                              Var S2             : STRING       );

Procedure StrAddConstStr(     Var S1             : STRING;
                                  S2             : STRING       );




Implementation

Procedure StrAddCh(           Var S1             : STRING;
                                  TheCH          : CHAR         );

BEGIN

  ASM

    { get ptr to S1 in ES:DI }

    LES BX, [S1]

    { load AL with length of S1 }

    MOV AL, byte PTR ES:[BX]
    XOR AH, AH

    { increment string length }

    INC byte PTR ES:[BX]

    { move string pointer down to proper spot }

    INC BL
    ADD BX, AX

    MOV AL, TheCH
    MOV byte PTR ES:[BX], AL

  END;

END;


Procedure StrAddStr(          Var S1             : STRING;
                              Var S2             : STRING       );

BEGIN

  ASM

    PUSH DS

    { get ptrs to strings }

    LES DI, [S1]
    LDS SI, [S2]

    { get lengths (BX=len of s1, CX=len of s2) }

    MOV BL, byte PTR ES:[DI]
    XOR BH, BH
    MOV CL, byte PTR DS:[SI]
    XOR CH, CH

    { move ptr to s2 down 1 byte (past length) }

    INC SI

    { add len of s1+len of s2; store as new length in s1 }

    MOV AL, BL
    ADD AL, CL

    MOV byte PTR ES:[DI], AL

    { move ptr to s1 down to the end }

    INC DI
    ADD DI, BX

    { append the string }

    CLD
    REPZ MOVSB

    { restore DS }

    POP DS

  END;

END;

Procedure StrAddConstStr(     Var S1             : STRING;
                                  S2             : STRING       );

BEGIN

  ASM

    PUSH DS

    { get ptrs to strings }
    LES DI, [S1]

    LDS SI, dword PTR [S2]

    PUSH SS
    POP  DS
    LEA  SI, S2

{
    PUSH SS
    POP  DS
    MOV  SI, offset S2
}
    { get lengths (BX=len of s1, CX=len of s2) }

    MOV BL, byte PTR ES:[DI]
    XOR BH, BH
    MOV CL, byte PTR DS:[SI]
    XOR CH, CH

    { move ptr to s2 down 1 byte (past length) }

    INC SI

    { add len of s1+len of s2; store as new length in s1 }

    MOV AL, BL
    ADD AL, CL

    MOV byte PTR DS:[DI], AL

    { move ptr to s1 down to the end }

    INC DI
    ADD DI, BX

    { append the string }

    CLD
    REPZ MOVSB

    { restore DS }

    POP DS

  END;

END;



BEGIN

END.