{


 Visionix OS/2 16-Bit KBD DLL API Import Unit
 Copyright 1993 Visionix
 ALL RIGHTS RESERVED



 Revision history in reverse chronological order:

 Initials  Date      Comment
 --------  --------  -------------------------------------------------------

 jrt       12/11/93  First logged revision.


}




Unit VKbdI;

Interface

Uses

  VTypes2u;


Const

  { KbdRegister constants }

  KR_KBDCHARIN                = $00000001;
  KR_KBDPEEK                  = $00000002;
  KR_KBDFLUSHBUFFER           = $00000004;
  KR_KBDGETSTATUS             = $00000008;
  KR_KBDSETSTATUS             = $00000010;
  KR_KBDSTRINGIN              = $00000020;
  KR_KBDOPEN                  = $00000040;
  KR_KBDCLOSE                 = $00000080;
  KR_KBDGETFOCUS              = $00000100;
  KR_KBDFREEFOCUS             = $00000200;
  KR_KBDGETCP                 = $00000400;
  KR_KBDSETCP                 = $00000800;
  KR_KBDXLATE                 = $00001000;
  KR_KBDSETCUSTXT             = $00002000;

  { ??? Constants }

  IO_WAIT                     = 0;
  IO_NOWAIT                   = 1;

  { TKbdInfo.Mask constants }

  KEYBOARD_ECHO_ON            = $0001;
  KEYBOARD_ECHO_OFF           = $0002;
  KEYBOARD_BINARY_MODE        = $0004;
  KEYBOARD_ASCII_MODE         = $0008;
  KEYBOARD_MODIFY_STATE       = $0010;
  KEYBOARD_MODIFY_INTERIM     = $0020;
  KEYBOARD_MODIFY_TURNAROUND  = $0040;
  KEYBOARD_2B_TURNAROUND      = $0080;
  KEYBOARD_SHIFT_REPORT       = $0100;

  { TKbdInfo.Status / TKbdKeyInfo.State / KBDTrans.State constants }

  KBDSTF_RIGHTSHIFT           = $0001;
  KBDSTF_LEFTSHIFT            = $0002;
  KBDSTF_CONTROL              = $0004;
  KBDSTF_ALT                  = $0008;
  KBDSTF_SCROLLLOCK_ON        = $0010;
  KBDSTF_NUMLOCK_ON           = $0020;
  KBDSTF_CAPSLOCK_ON          = $0040;
  KBDSTF_INSERT_ON            = $0080;
  KBDSTF_LEFTCONTROL          = $0100;
  KBDSTF_LEFTALT              = $0200;
  KBDSTF_RIGHTCONTROL         = $0400;
  KBDSTF_RIGHTALT             = $0800;
  KBDSTF_SCROLLLOCK           = $1000;
  KBDSTF_NUMLOCK              = $2000;
  KBDSTF_CAPSLOCK             = $4000;
  KBDSTF_SYSREQ               = $8000;

  { TKbdTrans.status contants }

  KBDTRF_SHIFT_KEY_IN         = $01;
  KBDTRF_CONVERSION_REQUEST   = $20;
  KBDTRF_FINAL_CHAR_IN        = $40;
  KBDTRF_INTERIM_CHAR_IN      = $80;










Type


  THKBD = WORD;


  TKbdKeyInfo = RECORD

    TheChar       : CHAR;
    Scan          : CHAR;
    Status        : BYTE;
    ShiftStatus   : BYTE;
    State         : WORD;
    Time          : LONGINT;

  END;

  PKbdKeyInfo = ^TKbdKeyInfo;



  TKBDInfo = RECORD

    CB           : WORD;
    Mask         : WORD;
    TurnAroundCh : WORD;
    Interim      : WORD;
    State        : WORD;

  END;

  PKBDInfo = ^TKBDInfo;


  TStringInBuff = RECORD

    CB     : WORD;
    ChIn   : WORD;

  END;

  PStringInBuff = ^TStringInBuff;


  TKBDTrans = RECORD

    TheChar       : CHAR;
    Scan          : CHAR;
    Status        : BYTE;
    ShiftStatus   : BYTE;
    State         : WORD;
    Time          : LONGINT;
    FSDD          : WORD;
    FSXLate       : WORD;
    FSShift       : WORD;
    Zero          : WORD;

  END;

  PKbdTrans = ^TKbdTrans;


  TKbdHWID = RECORD

    CB            : WORD;
    KeyboardID    : WORD;
    Reserved1     : WORD;
    Reserved2     : WORD;

  END;

  PKbdHWID = ^TKbdHWID;



Function  KbdCharIn(              KeyInfo        : PKbdKeyInfo;
                                  WaitFlag       : WORD;
                                  KBDHandle      : THKBD        ) : WORD;


Function  KbdClose(               KBDHandle      : THKBD        ) : WORD;

Function  KbdDeRegister                                           : WORD;

Function  KbdFlushBuffer(         KBDHandle      : THKBD        ) : WORD;

Function  KbdFreeFocus(           KBDHandle      : THKBD        ) : WORD;

Function  KbdGetCP(               Reserved       : LONGINT;
                              Var CodePage       : WORD;
                                  KBDHandle      : THKBD        ) : WORD;

Function  KbdGetHWID(             KBDHwid       : PKbdHWID;
                                  KBDHandle     : THKBD         ) : WORD;


Function  KbdGetFocus(            WaitFlag       : WORD;
                                  KBDHandle      : THKBD        ) : WORD;

Function  KbdGetStatus(           KbdInfo        : PKBDInfo;
                                  KBDHandle      : THKBD        ) : WORD;

Function  KbdOpen(            Var KBDHandle      : THKBD        ) : WORD;

Function  KbdPeek(                KeyInfo        : PKbdKeyInfo;
                                  KBDHandle      : THKBD        ) : WORD;

Function  KbdRegister(            ModuleName     : PCHAR;
                                  EntryName      : PCHAR;
                                  FuncFlags      : LONGINT      ) : WORD;

Function  KbdSetCP(               Reserved       : LONGINT;
                                  CodePage       : WORD;
                                  KBDHandle      : THKBD        ) : WORD;

Function  KbdSetCustXt(           TransTable     : POINTER;
                                  KBDHandle      : THKBD        ) : WORD;


Function  KbdSetFgnd                                              : WORD;

Function  KbdSetHWID(             KBDHwid       : PKbdHWID;
                                  KBDHandle     : THKBD         ) : WORD;

Function  KbdSetStatus(           KbdInfo        : PKBDInfo;
                                  KBDHandle      : THKBD        ) : WORD;

Function  KbdStringIn(            Buff           : POINTER;
                                  StringInBuff   : PStringInBuff;
                                  WaitFlag       : WORD;
                                  KBDHandle      : THKBD        ) : WORD;


Function  KbdSync(                WaitFlag       : WORD         ) : WORD;

Function  KbdXlate(               KbdTrans       : PKBDTrans;
                                  KBDHandle      : THKBD        ) : WORD;



Implementation


Function  KbdCharIn(              KeyInfo        : PKbdKeyInfo;
                                  WaitFlag       : WORD;
                                  KBDHandle      : THKBD        ) : WORD;

  External 'KBDCALLS' Index 4;




Function  KbdClose(               KBDHandle      : THKBD        ) : WORD;

  External 'KBDCALLS' Index 17;




Function  KbdDeRegister                                           : WORD;

  External 'KBDCALLS' Index 20;




Function  KbdFlushBuffer(         KBDHandle      : THKBD        ) : WORD;

  External 'KBDCALLS' Index 13;




Function  KbdFreeFocus(           KBDHandle      : THKBD        ) : WORD;

  External 'KBDCALLS' Index 18;


Function  KbdGetCP(               Reserved       : LONGINT;
                              Var CodePage       : WORD;
                                  KBDHandle      : THKBD        ) : WORD;

  External 'KBDCALLS' Index 3;



Function  KbdGetHWID(             KBDHwid       : PKbdHWID;
                                  KBDHandle     : THKBD         ) : WORD;

  External 'KBDCALLS' Index 24;


Function  KbdGetFocus(            WaitFlag       : WORD;
                                  KBDHandle      : THKBD        ) : WORD;


  External 'KBDCALLS' Index 12;



Function  KbdGetStatus(           KbdInfo        : PKBDInfo;
                                  KBDHandle      : THKBD        ) : WORD;

  External 'KBDCALLS' Index 10;



Function  KbdOpen(            Var KBDHandle      : THKBD        ) : WORD;


  External 'KBDCALLS' Index 23;



Function  KbdPeek(                KeyInfo        : PKbdKeyInfo;
                                  KBDHandle      : THKBD        ) : WORD;

  External 'KBDCALLS' Index 22;




Function  KbdRegister(            ModuleName     : PCHAR;
                                  EntryName      : PCHAR;
                                  FuncFlags      : LONGINT      ) : WORD;

  External 'KBDCALLS' Index 8;




Function  KbdSetCP(               Reserved       : LONGINT;
                                  CodePage       : WORD;
                                  KBDHandle      : THKBD        ) : WORD;


  External 'KBDCALLS' Index 5;



Function  KbdSetCustXt(           TransTable     : POINTER;
                                  KBDHandle      : THKBD        ) : WORD;

  External 'KBDCALLS' Index 1;




Function  KbdSetFgnd                                              : WORD;

  External 'KBDCALLS' Index 21;


Function  KbdSetHWID(             KBDHwid       : PKbdHWID;
                                  KBDHandle     : THKBD         ) : WORD;

  External 'KBDCALLS' Index 25;


Function  KbdSetStatus(           KbdInfo        : PKBDInfo;
                                  KBDHandle      : THKBD        ) : WORD;

  External 'KBDCALLS' Index 11;



Function  KbdStringIn(            Buff           : POINTER;
                                  StringInBuff   : PStringInBuff;
                                  WaitFlag       : WORD;
                                  KBDHandle      : THKBD        ) : WORD;

  External 'KBDCALLS' Index 9;




Function  KbdSync(                WaitFlag       : WORD         ) : WORD;

  External 'KBDCALLS' Index 7;



Function  KbdXlate(               KbdTrans       : PKBDTrans;
                                  KBDHandle      : THKBD        ) : WORD;

  External 'KBDCALLS' Index 14;




BEGIN

END.