{


Visionix Keyboard (VKeybu) Unit
   Version 0.7
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED



 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 jrt       11/02/93  Imported new key definitions from Robs
                     personal unit.

 jrt       11/02/93  Started by bringing over code from VBIOSu, VIN.

 jrt       11/02/93  First logged revision.


}

(*-

[TEXT]

<Overview>


The VKeybu unit implements a variety of functions for the PC/AT keyboard.

This unit also includes constants for most keyboard scan codes.

<Interface>

-*)


Unit VKeybu;

Interface

Uses

  DOS,
  VTypesu,
{$IFNDEF OS2}
  VBiosu;
{$ELSE}
  VKbdI;
{$ENDIF}


{}

Const

  Key_Tab       = 9;
  Key_ESC       = 27;
  Key_CR        = 13;

  Key_ShiftTab  = 15;
  Key_PgDn      = 81;
  Key_PgUp      = 73;
  Key_Home      = 71;
  Key_End       = 79;
  Key_Down      = 80;
  Key_Up        = 72;
  Key_Right     = 77;
  Key_Left      = 75;

  Key_Ins       = 82;
  Key_Del       = 83;

  Key_F1        = 59;
  Key_F2        = 60;
  Key_F3        = 61;
  Key_F4        = 62;
  Key_F5        = 63;
  Key_F6        = 64;
  Key_F7        = 65;
  Key_F8        = 66;
  Key_F9        = 67;
  Key_F10       = 68;

Const

   kENTER          = #13;
   kBackSpace      = #8;
   kTAB            = #9;
   kSpace          = #32;
   kESC            = #27;
   kNULL           = #0;
   kCtrlENTER      = #10;

   kCtrlA          = #1;
   kCtrlB          = #2;
   kCtrlC          = #3;
   kCtrlD          = #4;
   kCtrlE          = #5;
   kCtrlF          = #6;
   kCtrlG          = #7;
   kCtrlH          = #8;
   kCtrlI          = #9;
   kCtrlJ          = #10;
   kCtrlK          = #11;
   kCtrlL          = #12;
   kCtrlM          = #13;
   kCtrlN          = #14;
   kCtrlO          = #15;
   kCtrlP          = #16;
   kCtrlQ          = #17;
   kCtrlR          = #18;
   kCtrlS          = #19;
   kCtrlT          = #20;
   kCtrlU          = #21;
   kCtrlV          = #22;
   kCtrlW          = #23;
   kCtrlX          = #24;
   kCtrlY          = #25;
   kCtrlZ          = #26;

   kExtNull        = #3;
   kShiftTAB       = #15;
   kAltQ           = #16;
   kAltW           = #17;
   kAltE           = #18;
   kAltR           = #19;
   kAltT           = #20;
   kAltY           = #21;
   kAltU           = #22;
   kAltI           = #23;
   kAltO           = #24;
   kAltP           = #25;

   kAltA           = #30;
   kAltS           = #31;
   kAltD           = #32;
   kAltF           = #33;
   kAltG           = #34;
   kAltH           = #35;
   kAltJ           = #36;
   kAltK           = #37;
   kAltL           = #38;

   kAltZ           = #44;
   kAltX           = #45;
   kAltC           = #46;
   kAltV           = #47;
   kAltB           = #48;
   kAltN           = #49;
   kAltM           = #50;

   kF1             = #59;
   kF2             = #60;
   kF3             = #61;
   kF4             = #62;
   kF5             = #63;
   kF6             = #64;
   kF7             = #65;
   kF8             = #66;
   kF9             = #67;
   kF10            = #68;

   kShiftF1        = #84;
   kShiftF2        = #85;
   kShiftF3        = #86;
   kShiftF4        = #87;
   kShiftF5        = #88;
   kShiftF6        = #89;
   kShiftF7        = #90;
   kShiftF8        = #91;
   kShiftF9        = #92;
   kShiftF10       = #93;

   kCtrlF1         = #94;
   kCtrlF2         = #95;
   kCtrlF3         = #96;
   kCtrlF4         = #97;
   kCtrlF5         = #98;
   kCtrlF6         = #99;
   kCtrlF7         = #100;
   kCtrlF8         = #101;
   kCtrlF9         = #102;
   kCtrlF10        = #103;

   kAltF1          = #104;
   kAltF2          = #105;
   kAltF3          = #106;
   kAltF4          = #107;
   kAltF5          = #108;
   kAltF6          = #109;
   kAltF7          = #110;
   kAltF8          = #111;
   kAltF9          = #112;
   kAltF10         = #113;

   kHome           = #71;
   kUp             = #72;
   kPgUp           = #73;
   kLeft           = #75;
   kRight          = #77;
   kEnd            = #79;
   kDown           = #80;
   kPgDn           = #81;
   kIns            = #82;
   kDel            = #83;
   kShiftLeft      = #42;
   kShiftRight     = #54;

   kCtrlPrtSc      = #114;
   kCtrlLeft       = #115;
   kCtrlRight      = #116;
   kCtrlEnd        = #117;
   kCtrlPgDn       = #118;
   kCtrlHome       = #119;

   kAlt1           = #120;
   kAlt2           = #121;
   kAlt3           = #122;
   kAlt4           = #123;
   kAlt5           = #124;
   kAlt6           = #125;
   kAlt7           = #126;
   kAlt8           = #127;
   kAlt9           = #128;
   kAlt0           = #129;
   kAltMinus       = #130;
   kAltEqual       = #131;

   kCtrlPgUp       = #132;
   kF11            = #133;
   kF12            = #134;
   kShiftF11       = #135;
   kShiftF12       = #136;
   kCtrlF11        = #137;
   kCtrlF12        = #138;
   kAltF11         = #139;
   kAltF12         = #140;

   kInsert         = 128;
   kCaps           = 64;
   kNum            = 32;
   kScroll         = 16;
   kAlt            = 8;
   kCtrl           = 4;
   kLeftShift      = 2;
   kRightShift     = 1;



{$IFNDEF OS2}

{-----------------}
{ Keyboard Status }
{-----------------}

Function  IsAltPressed        : BOOLEAN;

Function  IsLeftAltPressed    : BOOLEAN;

Function  IsRightAltPressed   : BOOLEAN;

Function  IsCtrlPressed       : BOOLEAN;

Function  IsLeftCtrlPressed   : BOOLEAN;

Function  IsRightCtrlPressed  : BOOLEAN;

Function  IsShiftPressed      : BOOLEAN;

Function  IsLeftShiftPressed  : BOOLEAN;

Function  IsRightShiftPressed : BOOLEAN;

Function  IsInsertPressed     : BOOLEAN;

Function  IsInsertActive      : BOOLEAN;

Function  IsCapsLockPressed   : BOOLEAN;

Function  IsCapsLockActive    : BOOLEAN;

Function  IsNumLockPressed    : BOOLEAN;

Function  IsNumLockActive     : BOOLEAN;

Function  IsScrollLockPressed : BOOLEAN;

Function  IsScrollLockActive  : BOOLEAN;

Function  IsPauseStateActive  : BOOLEAN;

Function  IsSysReqPressed     : BOOLEAN;

Function  IsBlinkEnabled      : BOOLEAN;

Procedure ToggleCapsLock(            OnOff          : BOOLEAN );

Procedure ToggleInsert(              OnOff          : BOOLEAN );

Procedure ToggleNumLock(             OnOff          : BOOLEAN );

Procedure ToggleScrollLock(          OnOff          : BOOLEAN );

Function  PrevReadKey         : WORD;

{$ENDIF} { ifndef os2 }

Procedure KeyboardSetRate(        Delay     : BYTE;
                                  Rate      : BYTE    );

Procedure KeyboardSetFast;

Procedure KeyboardFlush;

Procedure KeyboardOff;

Procedure KeyboardOn;

Implementation


{$IFNDEF OS2}




{}

Function  IsAltPressed        : BOOLEAN;

BEGIN

  IsAltPressed := (BiosMemMap^.KbdFlag1 AND $8 <> 0);

END;

{}

Function  IsLeftAltPressed    : BOOLEAN;

BEGIN

  IsLeftAltPressed := (BiosMemMap^.KbdFlag2 AND $2 <> 0);

END;

{}

Function  IsRightAltPressed   : BOOLEAN;

BEGIN

  IsRightAltPressed := (BiosMemMap^.KbdStat1 AND $8 <> 0);

END;

{}

Function  IsCtrlPressed       : BOOLEAN;

BEGIN

  IsCtrlPressed := (BiosMemMap^.KbdFlag1 AND $4 <> 0);

END;

{}

Function  IsLeftCtrlPressed   : BOOLEAN;

BEGIN

  IsLeftCtrlPressed := (BiosMemMap^.KbdFlag2 AND $1 <> 0);

END;

{}

Function  IsRightCtrlPressed  : BOOLEAN;

BEGIN

  IsRightCtrlPressed := (BiosMemMap^.KbdStat1 AND $4 <> 0);

END;

{}

Function  IsShiftPressed      : BOOLEAN;

BEGIN

  IsShiftPressed := (BiosMemMap^.KbdFlag1 AND $1 <> 0) OR
                    (BiosMemMap^.KbdFlag1 AND $2 <> 0);

END;

{}

Function  IsLeftShiftPressed  : BOOLEAN;

BEGIN

  IsLeftShiftPressed := (BiosMemMap^.KbdFlag1 AND $2 <> 0);

END;

{}

Function  IsRightShiftPressed : BOOLEAN;

BEGIN

  IsRightShiftPressed := (BiosMemMap^.KbdFlag1 AND $1 <> 0);

END;

{}

Function  IsInsertPressed     : BOOLEAN;

BEGIN

  IsInsertPressed := (BiosMemMap^.KbdFlag2 AND $80 <> 0);

END;

{}

Function  IsInsertActive      : BOOLEAN;

BEGIN

  IsInsertActive := (BiosMemMap^.KbdFlag1 AND $80 <> 0);

END;

{}

Function  IsCapsLockPressed   : BOOLEAN;

BEGIN

  IsCapsLockPressed := (BiosMemMap^.KbdFlag2 AND $40 <> 0);

END;

{}

Function  IsCapsLockActive    : BOOLEAN;

BEGIN

  IsCapsLockActive := (BiosMemMap^.KbdFlag1 AND $40 <> 0);

END;

{}

Function  IsNumLockPressed    : BOOLEAN;

BEGIN

  IsNumLockPressed := (BiosMemMap^.KbdFlag2 AND $20 <> 0);

END;

{}

Function  IsNumLockActive     : BOOLEAN;

BEGIN

  IsNumLockActive := (BiosMemMap^.KbdFlag1 AND $20 <> 0);

END;

{}

Function  IsScrollLockPressed : BOOLEAN;

BEGIN

  IsScrollLockPressed := (BiosMemMap^.KbdFlag2 AND $10 <> 0);

END;

{}

Function  IsScrollLockActive  : BOOLEAN;

BEGIN

  IsScrollLockActive := (BiosMemMap^.KbdFlag1 AND $10 <> 0);

END;

{}

Function  IsPauseStateActive  : BOOLEAN;

BEGIN

  IsPauseStateActive := (BiosMemMap^.KbdFlag2 AND $8 <> 0);

END;

{}

Function  IsSysReqPressed     : BOOLEAN;

BEGIN

  IsSysReqPressed := (BiosMemMap^.KbdFlag2 AND $4 <> 0);

END;

{}

Function  IsBlinkEnabled      : BOOLEAN;

BEGIN

  IsBlinkEnabled := (BiosMemMap^.VidCurrModeSelReg AND $10 <> 0);

END;

{}

Procedure ToggleCapsLock(            OnOff          : BOOLEAN );

BEGIN

  If OnOff Then
    BiosMemMap^.KbdFlag1 := BiosMemMap^.KbdFlag1 OR $40
  Else
    BiosMemMap^.KbdFlag1 := BiosMemMap^.KbdFlag1 AND NOT $40;

END;

{}

Procedure ToggleInsert(              OnOff          : BOOLEAN );

BEGIN

  If OnOff Then
    BiosMemMap^.KbdFlag1 := BiosMemMap^.KbdFlag1 OR $80
  Else
    BiosMemMap^.KbdFlag1 := BiosMemMap^.KbdFlag1 AND NOT $80;

END;

{}

Procedure ToggleNumLock(             OnOff          : BOOLEAN );

BEGIN

  If OnOff Then
    BiosMemMap^.KbdFlag1 := BiosMemMap^.KbdFlag1 OR $20
  Else
    BiosMemMap^.KbdFlag1 := BiosMemMap^.KbdFlag1 AND NOT $20;

END;

{}

Procedure ToggleScrollLock(          OnOff          : BOOLEAN );

BEGIN

  If OnOff Then
    BiosMemMap^.KbdFlag1 := BiosMemMap^.KbdFlag1 OR $10
  Else
    BiosMemMap^.KbdFlag1 := BiosMemMap^.KbdFlag1 AND NOT $10;

END;

{}

Function  PrevReadKey         : WORD;

Var

  Pos  : WORD;

BEGIN

  Pos := BiosMemMap^.KbdBufTail;

  If Pos = BiosMemMap^.KbdBufStartOfs Then
    Pos := BiosMemMap^.KbdBufEndOfs;

  Dec( Pos, 2 );

  PrevReadKey :=
    BiosMemMap^.KbdBuf[Succ( (Pos - BiosMemMap^.KbdBufStartOfs) SHR 1 )];

END;

{}

Procedure SetupSysReqRoutine;

Var

  R : REGISTERS;

BEGIN

  R.AX := $2010;

  Intr( $15, R );

END;

{}

Procedure AfterSysReqRoutine;

Var

  R : REGISTERS;

BEGIN

  R.AX := $2011;

  Intr( $15, R );

END;

{}

Procedure KbdTranslate( Var ScanCode : BYTE;
                        Var Error    : BOOLEAN );

Var

  R : REGISTERS;

BEGIN

  R.AH := $4F;
  R.AL := ScanCode;
  R.Flags := R.Flags OR FCarry;

  Intr( $15, R );

  Error := (R.Flags AND FCarry = 0);

  If NOT Error Then
    ScanCode := R.AL;

END;


{}

{$ENDIF}


(*-

[FUNCTION]

Procedure KeyboardSetRate(           Delay     : BYTE;
                                     Rate      : BYTE    );

[PARAMETERS]

Delay       Delay value to set keyboard repeat to
Rate        Rate at which keys are read after delay period

[RETURNS]

(None)

[DESCRIPTION]

Sets the Keyboard typematic Rate and Delay times.

Delay       Delay value to set keyboard repeat to (this is a table)
                00h =  250ms  02h =  750ms
                01h =  500ms  03h = 1000ms

Rate        Rate at which keys are read after delay period (this is a table)
               Value Table is as such:
                00h = 30.0ms  08h = 15.0ms  10h =  7.5ms  18h =  3.7ms
                01h = 26.7ms  09h = 13.3ms  11h =  6.7ms  19h =  3.3ms
                02h = 24.0ms  0Ah = 12.0ms  12h =  6.0ms  1Ah =  3.0ms
                03h = 21.8ms  0Bh = 10.9ms  13h =  5.5ms  1Bh =  2.7ms
                04h = 20.0ms  0Ch = 10.0ms  14h =  5.0ms  1Ch =  2.5ms
                05h = 18.5ms  0Dh =  9.2ms  15h =  4.6ms  1Dh =  2.3ms
                06h = 17.1ms  0Eh =  8.6ms  16h =  4.3ms  1Eh =  2.1ms
                07h = 16.0ms  0Fh =  8.0ms  17h =  4.0ms  1Fh =  2.0ms
[SEE-ALSO]

SetKeyFast

[EXAMPLE]

VAR
  ch : CHAR;

BEGIN

  WriteLn( 'Setting Fastest Key Rate & Least Delay' );
  KeyboardSetRate( $00, $00 );

  WriteLn( 'Test by typing any key, <ENTER> to go to next test.' );
  REPEAT
    ch := ReadKey;
    Write( ch );
  UNTIL ch = #13;

  WriteLn( 'Setting Slowest Key Rate & Greatest Delay' );
  KeyboardSetRate( $03, $1F );

  WriteLn( 'Test by typing any key, <ESC> to quit test.' );
  REPEAT
    ch := ReadKey;
    Write( ch );
  UNTIL ch = #27;

  WriteLn( 'Resetting keyboard to Default Rate & Delay' );
  KeyboardSetRate( $01, $04 );

END;

-*)


Procedure KeyboardSetRate(           Delay     : BYTE;
                                     Rate      : BYTE    );

{$IFNDEF OS2}
Var

  R : Registers;

BEGIN

  If (Delay in [0..3]) AND
     (Rate in [0..31]) Then
  BEGIN

    R.AH := 3;
    R.AL := 5;
    R.BH := Delay;
    R.BL := Rate;
    R.DS := 0;
    R.ES := 0;

    Intr( $16, R );

  END;

END;

{$ELSE}

BEGIN

END;

{$ENDIF}

{}

(*-

[FUNCTION]

Procedure KeyboardSetFast;

[PARAMETERS]

(None)

[RETURNS]

(None)

[DESCRIPTION]

Sets the keyboard delay and rate to its maximum value

[SEE-ALSO]

KeyboardSetRate

[EXAMPLE]

VAR
  ch : CHAR;

BEGIN

  WriteLn( 'Test Current Keyboard Setting' );
  WriteLn( 'Test by typing any key, <ENTER> to for Fastest Speed.' );
  REPEAT
    ch := ReadKey;
    Write( ch );
  UNTIL ch = #13;

  WriteLn( 'Setting Fastest Key Rate & Least Delay' );
  SetkeyFast;
  WriteLn( 'Test by typing any key, <ESC> to go to quit.' );
  REPEAT
    ch := ReadKey;
    Write( ch );
  UNTIL ch = #27;

END;

-*)

Procedure KeyboardSetFast;

BEGIN

  KeyboardSetRate( 0, 0);

END;

{}

(*-

[FUNCTION]

Procedure KeyboardFlush;

[PARAMETERS]

(None)

[RETURNS]

(None)

[DESCRIPTION]

Flushes the Keyboard type-ahead buffer.  Keyboard buffer is now empty
and like nothing has been pressed.

[SEE-ALSO]

[EXAMPLE]

VAR
  ch : CHAR;

BEGIN

  WriteLn( 'Hold down a Key until Keyboard Buffer is Full (Beeps)' );
  WriteLn( 'and Keep Holding that Key.' );

  While NOT KeyPressed Do;

  Delay(2000);

  WriteLn( 'Purging Key Buffer.  And Accepting Keystokes... <ESC>=Quit' );
  PurgeKbdBuf;

  REPEAT
    ch := ReadKey;
    Write( ch );
  UNTIL ch = #27;

END;

-*)


Procedure KeyboardFlush;

BEGIN

  {$IFDEF OS2}
    KbdFlushBuffer( 0 );
  {$ELSE}
    BiosMemMap^.KbdBufTail := BiosMemMap^.KbdBufHead;
  {$ENDIF}

END;

{}

(*-

[FUNCTION]

Procedure KeyboardOff;

[PARAMETERS]

(None)

[RETURNS]

(None)

[DESCRIPTION]

Turns off keyboard access to the system

[SEE-ALSO]

KeyboardOn

[EXAMPLE]

VAR
  ch : CHAR;

BEGIN

  WriteLn( 'Type any Key to demonstrate Keyboard Active.' );
  WriteLn( 'Press <ENTER> when Ready for Test.' );
  REPEAT
    ch := ReadKey;
    Write( ch );
  UNTIL ch = #13;

  KeyboardOff;
  WriteLn( 'Keyboard is Now INACTIVE for 5 seconds.');
  WriteLn( 'Try to Press a Key.' );
  Delay( 5000 );

  KeyboardOn;

  WriteLn( 'Keyboard is ACTIVE again. Press any key.  <ESC>=Quit' )
  REPEAT
    ch := Readkey;
    Write( ch );
  UNTIL ch = #27;

  WriteLn( 'End of Test' );

END;

-*)

Procedure KeyboardOff;

{$IFNDEF OS2}

Assembler;
ASM

  IN  AL, $21
  OR  AL, 00000010b
  OUT $21, AL

END;

{$ELSE}

BEGIN

END;

{$ENDIF}

{}

(*-

[FUNCTION]

Procedure KeyboardOn;

[PARAMETERS]

(None)

[RETURNS]

(None)

[DESCRIPTION]

Turms on keyboard access to the system

[SEE-ALSO]

KeyboardOff

[EXAMPLE]

VAR
  ch : CHAR;

BEGIN

  WriteLn( 'Type any Key to demonstrate Keyboard Active.' );
  WriteLn( 'Press <ENTER> when Ready for Test.' );
  REPEAT
    ch := ReadKey;
    Write( ch );
  UNTIL ch = #13;

  KeyboardOff;
  WriteLn( 'Keyboard is Now INACTIVE for 5 seconds.');
  WriteLn( 'Try to Press a Key.' );
  Delay( 5000 );

  KeyboardOn;

  WriteLn( 'Keyboard is ACTIVE again. Press any key.  <ESC>=Quit' )
  REPEAT
    ch := Readkey;
    Write( ch );
  UNTIL ch = #27;

  WriteLn( 'End of Test' );

END;

-*)

Procedure KeyboardOn;

{$IFNDEF OS2}

Assembler;
ASM

  IN  AL, $21
  AND AL, 11111101b
  OUT $21, AL

END;

{$ELSE}

BEGIN

END;

{$ENDIF}

{}
{}
{}


BEGIN

END.