{
 

 Visionix Math Functions Unit (VMATH)
   Version 0.11
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 Revision history in reverse chronological order:

 Initials  Date      Comment
 --------  --------  --------------------------------------------------------

 mep       04/18/93  Added Integrate.

 mep       03/25/93  Fixed ArcSin, ArcCos, ArcCsc, ArcSec, ArcCot, and
                       Factorial.
                     Cleaned up code.

 mep       02/11/93  Cleaned up code for beta release

 jrt       02/08/93  Sync with beta 0.12

 mep       02/02/93  Changed hyberbolic function names to be more proper.
                     Cleanup of code for release (with more notes).
                     Added: DistanceXY, QuadraticPlus, QuadraticNeg,
                       Factorial, Permu, Combo, DegToRad, GradToRad,
                       DegToGrad, RadToDeg, RadToGrad, GradToDeg, GCF,
                       LCM.

 lpg       01/13/92  Added: Sin2,Cos2
                     Also wrote up quick Trig Info for header

 lpg       01/13/92  Renamed Clamp functions to Range

 jrt       12/07/92  Sync with beta 0.11 release

 jrt       11/21/92  Sync with beta 0.08

 lpg       11/08/92  Added more function:  all Hyp and Arc series.

 lpg       10/05/92  First logged revision.

 
}

(*

[TEXT]

<Overview>

This unit implements a wide variety of higher-level math functions.


Definitions of Terms
--------------------

TRIGONOMETRY - The branch of mathematics that deals with the relations
  between the sides and angles of pnae of spherical triangles, and the
  calculations based upon them.  [<NL trigonometria, lit., "triangle
  measuring"]

RADIAN - An angle at the center of a circle, subtending an arc of
  the circle equal in length to the radius.  A length of the circle's
  radius measured across a circle's circumference and measured in
  angles from the circle's center. 1 Radian = 57.2958 degrees.
  3.14159 Radians = 360 degrees.  [Radi(us) + an]

HYPOTENUSE - The side of a right triangle opposite the right angle.

QUADRANT - A quarter of a circle.  [ME<L quadrant-(s. of quadrans)
  4th part]

e (base of the natural logarithms) is approximately 2.718;

 (pi) is approximately 3.14159

 = Angle Theta (General reference angle)

 = Infinity

x = Absolute value of x

x = Square root of x

x^n = x raised to the n power

ln(x) = Natural logarithm of x




GRAPHS OF THE UNIT CIRCLE
=========================


I. QUADRANT SYSTEM
------------------

    R = Radius of Circle (here 1 unit)

                     +Y
                      .
                      .
                      .(0,1)
                 .....*......
               ..     .      .. B
              .       .        +
Quadrant 2   .        .       /|.   Quadrant 1
            .         .      / | .
           .          .     /  |  .
          .           .  R /   |   .
          .           .   /   a|   .
         .            .  / c   |    .
         .            . /      |    .
   (-1,0).           A./   b   |C   .(1,0)
-X ......*............+--------+....*..... +X
         .       (0,0).             .
         .      Origin.             .
         .            .             .
          .           .            .
          .           .            .
           .          .           .
            .         .          .
Quadrant 3   .        .         .   Quadrant 4
              .       .        .
               ..     .     ..
                 .....*.....
                      .(0,-1)
                      .
                      .
                     -Y



II. RADIANS AND DEGREES
-----------------------

                /2
          2/3        /3
             ....*....
    3/4  ..*         *..   /4
         .               .
        *        90       *
       .    120  .   60    .
      .          .          .
5/6 .   135     .     45    . /6
     *           .           *
    .  150       .        30  .
    .            .            .
    .            .            .
    .            .            .
   * 180 .......+......... 0 *  0
    .            .            .
    .            .            .
    .            .            .
    .  210       .       330  .
     *           .           *
7/6 .           .           . 11/6
      .  225     .     315  .
       .         .         .
        *   240     300   *
         .      270      .
    5/4  ..           ..  7/4
            *....*....*

          4/3       5/3
                3/2



III. CIRCULAR FUNCTION DEFINITIONS
----------------------------------

                Y
                .
                .

            .........
    (x,y)...         ...
        .       .       .
       *        .        .
      .|\       .         .
     . | \  r   .          .
    .  |  \     .           .        Where  is any angle:
    .  |   \                .
   .  y|    \   __           .        sin  = y / r
   .   |     \ /  \          .
   .   |      \   \         .        cos  = x / r
   .   |       \   |         .
.. . ..---------+ .......... . ..X    tan  = y / x
   .       x                 .
   .            .            .        csc  = r / y
   .            .            .
   .            .            .        sec  = r / x
    .           .           .
    .           .           .         cot  = x / y
     .          .          .
      .         .         .
       .        .        .
        .       .       .
         ..           ..
           ...........

                .
                .


IV. SINE/COSINE RELATIONSHIPS
-----------------------------

  On unit circles, (x, y) = (cos, sin)


                        (0, 1)

                           .
            (-1/2, 3/2)   .   (1/2, 3/2)

                       ....*....
    (-2/2, 2/2)   ..*         *..  (2/2, 2/2)
                   .       .       .
                  *        .        *
                 .         .         .
  (3/2, 1/2)   .          .          .  (3/2, 1/2)
               .           .           .
               *           .           *
              .     II     .     I      .
              .            .            .
              .            .            .
              .            .            .
(-1, 0) ..... * ...........+........... * ..... (1, 0)
              .            .            .
              .            .            .
              .            .            .
              .            .            .
               *    III    .     IV    *
               .           .           .
  (-3/2, -1/2) .          .          .  (3/2, -1/2)
                 .         .         .
                  *        .        *
                   .       .       .
    (-2/2, -2/2)  ..           ..  (2/2, -2/2)
                      *....*....*

            (-1/2, -3/2)  .  (1/2, -3/2)
                           .

                        (0, -1)



  In quadrant I,   ALL trig. functions are positive.
  In quadrant II,  only SIN and CSC are positive.
  In quadrant III, only TAN and COT are positive.
  In quadrant IV,  only COS and SEC are positive.





Definition of the Six Trigonometric Functions
---------------------------------------------
(Right triangle definitions, where 0 <  < /2)

          e
         s +    sin  = Opp / Hyp
        u /|O
       n / |p   cos  = Adj / Hyp
      e /  |p
     t /   |o   tan  = Opp / Adj
    o /    |s
   p /     |i   csc  = 1 / sin  = Hyp / Opp
  y /      |t
 H /      |e   sec  = 1 / cos  = Hyp / Adj
  +--------+
   Adjacent     cot  = 1 / tan  = Adj / Opp



Definition of Inverse Trigonometric Functions
---------------------------------------------

Function                     Domain         Range
--------------------------   ------------   ----------------

y = arcsin x iff sin y = x   -1 <= x <= 1   -/2 <= y <= /2

y = arccos x iff cos y = x   -1 <= x <= 1   0 <= y <= 

y = arctan x iff tan y = x   - < x <      -/2 < y < /2

y = arccot x iff cot y = x   - < x <      0 < y < 

y = arcsec x iff sec y = x   x >= 1       0 <= y <= , y <> /2

y = arccsc x iff csc y = x   x >= 1       -/2 <= y <= /2, y <> 0



Definition of the Hyberbolic Functions
--------------------------------------

Function                   Domain               Range
-------------------------  ------------------   ------------------

sinh x = (e^x - e^-x) / 2  - < x <            - < y < 

cosh x = (e^x + e^-x) / 2  - < x <            -1 <= y < 

tanh x = sinh x / cosh x   - < x <            -1 < y < 1

csch x = 1 / sinh x,       - < x < , x <> 0   - < y < , y <> 0

sech x = 1 / cosh x        - < x <            0 < y <= 1

coth x = 1 / tanh x,       - < x < , x <> 0   - < y < -1,
                                                 1 < y < 



Definition of the Inverse Hyperbolic Functions
----------------------------------------------

Function                                      Domain       Range
-------------------------------------------   ----------   ---------

arcsinh x = ln( x + (x^2 + 1) )              - < x <    - < y < 

arccosh x = ln( x + (x^2 - 1) )              1 <= x <     <= y < 

arctanh x = (1/2) * ln( (1 + x) / (1 - x) )   x < 1       <= y < 

arccoth x = (1/2) * ln( (x + 1) / (x - 1) )   x > 1      - < y < , y <> 0

arcsech x = ln( (1 + (1 - x^2)) / x )        0 < x <= 1   0 <= y < 

arccsch x = ln( (1 + (1 + x^2)) / x )      x > 0        - < y < , y <> 0

          = ln( (-1 + (1 + x^2)) / x )     x < 0


*)

{}

Unit VMathu;


INTERFACE


  {------------------------------------}
  { Constants and type definitions     }
  {------------------------------------}

Const

  cINFINITY  = 9.9999999999E+37;  {or 5.5E11, also 65000 for INTEGER}
  cOVERFLOW  = 9.9999999999E+37;
  cUNDERFLOW = 1.0E-37;
  cTolerance = 0.00000001;        {for math error tolerances}

Type

  {----------------------------------------------}
  { For procedures requiring a user-defined f(x) }
  {----------------------------------------------}

  FXFunc = Function( X : REAL ) : REAL;
  PXFunc = ^FXFunc;

  {--------------}
  { Linear Array }
  {--------------}

  TArrayR = Array[1..1] of REAL;
  PArrayR = ^TArrayR;

  TArrayRA = Array[1..100] of REAL;
  PArrayRA = ^TArrayRA;

  {-------------------------------------------}
  { Coordinate Array - Maps over Linear Array }
  {-------------------------------------------}

  TRec2R = RECORD

    X : REAL;
    Y : REAL;

  END;

  TArray2R = Array[1..1] of TRec2R;
  PArray2R = ^TArray2R;

  TArray2RA = Array[1..100] of TRec2R;
  PArray2RA = ^TArray2RA;

{}

Function  HMStoDegrees(      Degs      : WORD;
                             Mins      : WORD;
                             Secs      : REAL         ) : REAL;

Procedure DegreesToHMS(      Degrees   : REAL;
                         Var Degs      : INTEGER;
                         Var Min       : INTEGER;
                         Var Sec       : REAL         );

Function  DegToRad(          Deg       : REAL         ) : REAL;

Function  GradToRad(         Grad      : REAL         ) : REAL;

Function  DegToGrad(         Deg       : REAL         ) : REAL;

Function  RadToDeg(          Rad       : REAL         ) : REAL;

Function  RadToGrad(         Rad       : REAL         ) : REAL;

Function  GradToDeg(         Grad      : REAL         ) : REAL;

{----------------}
{ Trig Functions }
{----------------}

Function  Quad(              Radians   : REAL         ) : INTEGER;

Function  Quad2(             X, Y      : REAL         ) : INTEGER;

Function  Sin2(              X, Y      : REAL         ) : REAL;

Function  Cos2(              X, Y      : REAL         ) : REAL;

Function  Tan(               X         : REAL         ) : REAL;

Function  Tan2(              X, Y      : REAL         ) : REAL;

Function  Cot(               X         : REAL         ) : REAL;

Function  Cot2(              X, Y      : REAL         ) : REAL;

Function  Csc(               X         : REAL         ) : REAL;

Function  Sec(               X         : REAL         ) : REAL;

Function  Sinh(              X         : REAL         ) : REAL;  {NOT TESTED}

Function  Cosh(              X         : REAL         ) : REAL;

Function  Tanh(              X         : REAL         ) : REAL;

Function  Csch(              X         : REAL         ) : REAL;  {NOT TESTED}

Function  Sech(              X         : REAL         ) : REAL;  {NOT TESTED}

Function  Coth(              X         : REAL         ) : REAL;  {NOT TESTED}

Function  ArcSin(            X         : REAL         ) : REAL;

Function  ArcSin2(           X         : REAL;
                             Quadrant  : INTEGER      ) : REAL;

Function  ArcCos(            X         : REAL         ) : REAL;

Function  ArcCos2(           X         : REAL;
                             Quadrant  : INTEGER      ) : REAL;

Function  ArcTan1(           X         : REAL         ) : REAL;

Function  ArcTan2(           X, Y      : REAL         ) : REAL;

Function  ArcCsc(            X         : REAL         ) : REAL; {NOT TESTED}

Function  ArcSec(            X         : REAL         ) : REAL;  {NOT TESTED}

Function  ArcCot(            X         : REAL         ) : REAL;  {NOT TESTED}

Function  ArcSinh(           X         : REAL         ) : REAL;

Function  ArcCosh(           X         : REAL         ) : REAL;

Function  ArcTanh(           X         : REAL         ) : REAL;

Function  ArcCsch(           X         : REAL         ) : REAL;

Function  ArcSech(           X         : REAL         ) : REAL;

Function  ArcCoth(           X         : REAL         ) : REAL;

{----------------------}
{ Basic Math Functions }
{----------------------}

Function  Power(             Num       : LONGINT;
                             Exponent  : LONGINT      ) : LONGINT;

Function  PowerR(            Num       : REAL;
                             Exponent  : REAL         ) : REAL;

Function  Root(              Num       : LONGINT;
                             RootVal   : LONGINT      ) : LONGINT;

Function  RootR(             Num       : REAL;
                             RootVal   : REAL         ) : REAL;

Function  Log(               Num       : REAL;
                             Base      : REAL         ) : REAL;

Function  FastHyp(           XDist     : REAL;
                             YDist     : REAL         ) : REAL;

Function  FastHypR(          XDist     : REAL;
                             YDist     : REAL         ) : REAL;

Function  Hypot(             XDist     : REAL;
                             YDist     : REAL         ) : REAL;

Function  FastDist(          X1        : LONGINT;
                             Y1        : LONGINT;
                             X2        : LONGINT;
                             Y2        : LONGINT      ) : LONGINT;

Function  DistanceXY(        X1        : REAL;
                             Y1        : REAL;
                             X2        : REAL;
                             Y2        : REAL         ) : REAL;

Function  Percent(           Part      : LONGINT;
                             Whole     : LONGINT      ) : REAL;

Function  Min(               A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

Function  MinR(              A         : REAL;
                             B         : REAL         ) : REAL;

Function  Max(               A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

Function  MaxR(              A         : REAL;
                             B         : REAL         ) : REAL;

Function  Range(             Num       : LONGINT;
                             Low       : LONGINT;
                             High      : LONGINT      ) : LONGINT;

Function  RangeR(            Num       : REAL;
                             Low       : REAL;
                             High      : REAL         ) : REAL;

Function  Floor(             Num       : LONGINT;
                             Low       : LONGINT      ) : LONGINT;

Function  FloorR(            Num       : REAL;
                             Low       : REAL         ) : REAL;

Function  Ceiling(           Num       : LONGINT;
                             High      : LONGINT      ) : LONGINT;

Function  CeilingR(          Num       : REAL;
                             High      : REAL         ) : REAL;

Function  Sign(              Num       : LONGINT      ) : INTEGER;

Function  SignR(             Num       : REAL         ) : INTEGER;


{-----------------------}
{ Higher Math Functions }
{-----------------------}

Function  QuadraticPlus(     A         : LONGINT;
                             B         : LONGINT;
                             C         : LONGINT      ) : REAL;

Function  QuadraticNeg(      A         : LONGINT;
                             B         : LONGINT;
                             C         : LONGINT      ) : REAL;

Function  Factorial(         N         : BYTE         ) : REAL;

Function  Permu(             N         : BYTE;
                             R         : BYTE         ) : REAL;

Function  Combo(             N         : BYTE;
                             R         : BYTE         ) : REAL;

Function  Prime(             N         : LONGINT      ) : BOOLEAN;

Function  GCF(               A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

Function  LCM(               A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

Procedure LoadArrayR(    VAR Arr       : PArrayR;
                             Idx       : WORD;
                             R         : REAL         );

Procedure LoadArrayRXY(  VAR Arr       : PArray2R;
                             Idx       : WORD;
                             X         : REAL;
                             Y         : REAL         );

Procedure MeanStdDev(        Arr       : PArrayR;
                             Cnt       : INTEGER;
                         VAR Mean      : REAL;
                         VAR StdDev    : REAL         );

Function  Sigma(             Arr       : PArrayR;
                             Cnt       : INTEGER      ) : REAL;

Procedure LeastSqr(          Arr       : PArray2R;
                             Cnt       : INTEGER;
                         VAR YInt      : REAL;
                         VAR Slope     : REAL         );

Function  Integrate(         A         : REAL;
                             B         : REAL;
                             Func      : PXFunc;
                             N         : WORD;
                             MaxErr    : REAL         ) : REAL;

  {------------------------------}
  { Begin implementation of code }
  {------------------------------}

IMPLEMENTATION

Const

  PI_1   = PI * 0.5;    {  90 Degrees - End of 1st Quadrant }
  PI_2   = PI;          { 180 Degrees - End of 2nd Quadrant }
  PI_3   = PI * 1.5;    { 270 Degrees - End of 3rd Quadrant }
  PI_4   = PI * 2.0;    { 360 Degrees - End of 4th Quadrant }


Var
 Ra,Rb : REAL;  {TESTING VALUES}

{}

(*-

[FUNCTION]

Function HMStoDegrees(       Degs      : WORD;
                             Mins      : WORD;
                             Secs      : REAL         ) : REAL;

[PARAMETERS]

Degs        Arc Degrees
Mins        Arc Minutes
Secs        Arc Seconds

[RETURNS]

Floating point decimal degrees

[DESCRIPTION]

Converts arc degrees, minutes and seconds into a floating point
degree value.

[SEE-ALSO]

DegreesToHMS

[EXAMPLE]

BEGIN

  WriteLn( HMStoDegrees( 59, 30, 0 ):8:4 );

END;

-*)


Function HMStoDegrees(       Degs      : WORD;
                             Mins      : WORD;
                             Secs      : REAL         ) : REAL;

BEGIN

  HMStoDegrees := Degs + ( Mins DIV 60 ) + ( Secs / 3600.0 );

END;

{}

(*-

[FUNCTION]

Procedure DegreesToHMS(      Degrees   : REAL;
                         Var Degs      : INTEGER;
                         Var Min       : INTEGER;
                         Var Sec       : REAL         );

[PARAMETERS]

Degrees     Floating Point Angle in Degrees
Degs        VAR Returned Arc Degrees
Min         VAR Returned Arc Minutes
Sec         VAR Returned Arc Seconds

[RETURNS]

(Function : None)
(VAR      : [Degs] Arc Degrees)
(VAR      : [Min ] Arc Minutes)
(VAR      : [Sec ] Arc Seconds)

[DESCRIPTION]

Converts a Floating Point Angle in Degrees into the Component
Parts of Arc (Degrees, Minutes and Seconds)

[SEE-ALSO]

[EXAMPLE]

VAR
  D,M,S : REAL;

BEGIN

  DegreesToHMS( 45.6137, D,M,S );

  WriteLn( 'Deg = ',Deg:2:0 );
  WriteLn( 'Min = ',Min:2:0 );
  WriteLn( 'Sec = ',Sec:5:2 );

END;

-*)

Procedure DegreesToHMS(      Degrees   : REAL;
                         Var Degs      : INTEGER;
                         Var Min       : INTEGER;
                         Var Sec       : REAL         );

BEGIN

  Degs := Trunc( Degrees );
  Min  := Trunc( Degrees * 60.0 ) MOD 60;
  Sec  := Frac( Degrees * 60.0 ) * 60.0;

END;  { DegreesToHMS }

{}

(*-

[FUNCTION]

Function DegToRad(           Deg       : REAL         ) : REAL;

[PARAMETERS]

Deg         Floating Point Angle in Degrees

[RETURNS]

Angle in Radians

[DESCRIPTION]

Converts Arc Degrees to Radians.

[SEE-ALSO]

DegToGrad
RadToDeg
RadToGrad
GradToDeg
GradToRad

[EXAMPLE]

VAR
  Rad : REAL;

BEGIN

  Rad := DegToRad(   0.0 );  { Rad = 0.0000 }
  Rad := DegToRad(  30.0 );  { Rad = 0.5236 }
  Rad := DegToRad(  45.0 );  { Rad = 0.7854 }
  Rad := DegToRad(  90.0 );  { Rad = 1.5708 }
  Rad := DegToRad( 180.0 );  { Rad = 3.1416 }
  Rad := DegToRad( 360.0 );  { Rad = 6.2832 }

END;

-*)

Function DegToRad(           Deg       : REAL         ) : REAL;

BEGIN

  DegToRad := Deg * Pi / 180;

END; { DegToRad }

{}

(*-

[FUNCTION]

Function DegToGrad(          Deg       : REAL         ) : REAL;

[PARAMETERS]

Deg         Angle in Degrees

[RETURNS]

Angle in Gradients

[DESCRIPTION]

Converts Arc Degrees to Gradients

[SEE-ALSO]

DegToRad
RadToDeg
RadToGrad
GradToDeg
GradToRad

[EXAMPLE]

VAR
  Grad : REAL;

BEGIN

  Grad := DegToGrad(   0.0 );  { Grad =   0.0000 }
  Grad := DegToGrad(  30.0 );  { Grad =  33.3333 }
  Grad := DegToGrad(  45.0 );  { Grad =  50.0000 }
  Grad := DegToGrad(  90.0 );  { Grad = 100.0000 }
  Grad := DegToGrad( 180.0 );  { Grad = 200.0000 }
  Grad := DegToGrad( 360.0 );  { Grad = 400.0000 }

END;

-*)

Function DegToGrad(          Deg       : REAL         ) : REAL;

BEGIN

  DegToGrad := Deg / 0.9;

END; { DegToGrad }

{}

(*-

[FUNCTION]

Function RadToDeg(           Rad       : REAL         ) : REAL;

[PARAMETERS]

Rad         Angle in Radians

[RETURNS]

Angle in Degrees

[DESCRIPTION]

Converts Arc Radians to Degrees

[SEE-ALSO]

DegToRad
DegToGrad
RadToGrad
GradToDeg
GradToRad

[EXAMPLE]

VAR
  Deg : REAL;

BEGIN

  Deg := RadToDeg( 0.0    );  { Deg =   0.0000 }
  Deg := RadToDeg( PI/6.0 );  { Deg =  30.0000 }
  Deg := RadToDeg( PI*0.25);  { Deg =  45.0000 }
  Deg := RadToDeg( PI*0.5 );  { Deg =  90.0000 }
  Deg := RadToDeg( PI     );  { Deg = 180.0000 }
  Deg := RadToDeg( PI*2.0 );  { Deg = 360.0000 }

END;

-*)

Function RadToDeg(           Rad       : REAL         ) : REAL;

BEGIN

  RadToDeg := Rad * 180/Pi;

END; { RadToDeg }

{}

(*-

[FUNCTION]

Function RadToGrad(          Rad       : REAL         ) : REAL;

[PARAMETERS]

Rad         Angle in Radians

[RETURNS]

Angle in Gradients

[DESCRIPTION]

Converts Arc Radians to Gradients

[SEE-ALSO]

DegToRad
DegToGrad
RadToDeg
GradToDeg
GradToRad

[EXAMPLE]

VAR
  Grad : REAL;

BEGIN

  Grad := RadToGrad( 0.0    );  { Grad =   0.0000 }
  Grad := RadToGrad( PI/6.0 );  { Grad =  33.3333 }
  Grad := RadToGrad( PI*0.25);  { Grad =  50.0000 }
  Grad := RadToGrad( PI*0.5 );  { Grad = 100.0000 }
  Grad := RadToGrad( PI     );  { Grad = 200.0000 }
  Grad := RadToGrad( 2.0*PI );  { Grad = 400.0000 }

END;

-*)

Function RadToGrad(          Rad       : REAL         ) : REAL;

BEGIN

  RadToGrad := Rad * 200/Pi;

END; { RadToGrad }

{}

(*-

[FUNCTION]

Function GradToDeg(          Grad      : REAL         ) : REAL;

[PARAMETERS]

Grad        Angle in Gradients

[RETURNS]

Arc Degrees

[DESCRIPTION]

Converts Arc Gradients to Degrees

[SEE-ALSO]

DegToRad
DegToGrad
RadToDeg
RadToGrad
GradToRad

[EXAMPLE]

VAR
  Deg : REAL;

BEGIN

  Deg := GradToDeg(   0.0 );  { Deg =   0.0000 }
  Deg := GradToDeg(  30.0d);  { Deg =  30.0000 }
  Deg := GradToDeg(  50.0 );  { Deg =  45.0000 }
  Deg := GradToDeg( 100.0 );  { Deg =  90.0000 }
  Deg := GradToDeg( 200.0 );  { Deg = 180.0000 }
  Deg := GradToDeg( 400.0 );  { Deg = 360.0000 }

END;

-*)

Function GradToDeg(          Grad      : REAL         ) : REAL;

BEGIN

  GradToDeg := Grad * 0.9;

END; { GradToDeg }

{}

(*-

[FUNCTION]

Function GradToRad(          Grad      : REAL         ) : REAL;

[PARAMETERS]

Grad        Angle in Gradients

[RETURNS]

Angle in Radians

[DESCRIPTION]

Converts Arc Gradients to Radians

[SEE-ALSO]

DegToRad
DegToGrad
RadToDeg
RadToGrad
GradToDeg

[EXAMPLE]

VAR
  Rad : REAL;

BEGIN

  Rad := GradToRad(   0.0000 );  { Rad = 0.0000 }
  Rad := GradToRad(  33.3333 );  { Rad = 0.5236 }
  Rad := GradToRad(  50.0000 );  { Rad = 0.7854 }
  Rad := GradToRad( 100.0000 );  { Rad = 1.5708 }
  Rad := GradToRad( 200.0000 );  { Rad = 3.1416 }
  Rad := GradToRad( 400.0000 );  { Rad = 6.2832 }

END;

-*)

Function GradToRad(          Grad      : REAL         ) : REAL;

BEGIN

  GradToRad := Grad * Pi/200;

END; { GradToRad }

{}

(*-

[FUNCTION]

Function Quad(               Radians   : REAL         ) : INTEGER;

[PARAMETERS]

Radians     Angle in Radians

[RETURNS]

Quadrant in which the Radians is contained

[DESCRIPTION]

Determines which Quadrant is the Radian Angle falls in
There are 4 Quadrants as follows:
  Quadrant I   -   0 deg to  90 deg
  Quadrant II  -  91 deg to 180 deg
  Quadrant III - 181 deg to 270 deg
  Quadrant IV  - 271 deg to 359 deg

[SEE-ALSO]

Quad2

[EXAMPLE]

VAR
  Q : INTEGER;

BEGIN

  Q := Quad( DegToRad(   0.0 ) );  { Q = 1 }
  Q := Quad( DegToRad(  45.0 ) );  { Q = 1 }
  Q := Quad( DegToRad(  90.0 ) );  { Q = 1 }
  Q := Quad( DegToRad( 135.0 ) );  { Q = 2 }
  Q := Quad( DegToRad( 210.0 ) );  { Q = 3 }
  Q := Quad( DegToRad( 300.0 ) );  { Q = 4 }

END;

-*)

Function Quad(               Radians   : REAL         ) : INTEGER;

BEGIN

  While ( Radians > PI_4 ) Do
    Radians := Radians - PI_4;

  While ( Radians < 0.0 ) Do
    Radians := Radians + PI_4;

  If (Radians < PI_1) Then
    Quad := 1
  Else
  If (Radians < PI) Then
    Quad := 2
  Else
  If (Radians < PI_3) Then
    Quad := 3
  Else
    Quad := 4;

END;  { Quad }

{}

(*-

[FUNCTION]

Function Quad2(              X, Y      : REAL         ) : INTEGER;

[PARAMETERS]

X           X Coordinate Value
Y           Y Coordinate Value

[RETURNS]

Returns the Quadrant corresponding to the X and Y Values.

[DESCRIPTION]

Determines which Quadrant corresponds to the Coordinate X,Y

[SEE-ALSO]

Quad

[EXAMPLE]

VAR
  Q : INTEGER;

BEGIN

  Q := Quad2(  1.0,  0.0 );  { Q = 1 }
  Q := Quad2(  1.0,  1.0 );  { Q = 1 }
  Q := Quad2(  0.0,  1.0 );  { Q = 1 }
  Q := Quad2( -1.0,  1.0 );  { Q = 2 }
  Q := Quad2( -1.0, -1.0 );  { Q = 3 }
  Q := Quad2(  1.0, -1.0 );  { Q = 4 }

END;

-*)

Function Quad2(              X, Y      : REAL         ) : INTEGER;

BEGIN

  If ( Y = Abs( Y ) ) Then   {+pos}
  BEGIN

    If ( X = Abs( X ) ) Then {+pos}
      Quad2 := 1
    Else
      Quad2 := 2;

  END
  Else
  BEGIN

    If ( X = Abs( X ) ) Then {+pos}
      Quad2 := 4
    Else
      Quad2 := 3;

  END;

END;  { Quad2 }

{}

(*-

[FUNCTION]

Function Sin2(               X,Y       : REAL         ) : REAL;

[PARAMETERS]

X           X Coordinate Value
Y           Y Coordinate Value

[RETURNS]

Sine of the Angle created by Coordinate X,Y

[DESCRIPTION]

Determines and returns the Sine of the Angle computed from
the Coordinate X,Y

[SEE-ALSO]

Cos2   Sinh   ArcSin    ArcSinh
Tan    Cosh   ArcSin2   ArcCosh
Tan2   Tanh   ArcCos    ArcTanh
Cot           ArcCos2   ArcCsch
Cot2          ArcTan1   ArcSech
Csc           ArcTan2   ArcCoth
Sec           ArcCsc
              ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;

BEGIN

  For i := 0 to 100 Do
    WriteLn( 'Sin2(1,',i,') = ',Sin2( 1.0, i ) :8:4 );

END;

-*)

Function Sin2(               X,Y       : REAL         ) : REAL;

BEGIN

  Sin2 := Y / ( Sqrt( Sqr(X) + Sqr(Y) ) );

END;  { Sin2 }

{}

(*-

[FUNCTION]

Function Cos2(               X,Y       : REAL         ) : REAL;

[PARAMETERS]

X           X Coordinate Value
Y           Y Coordinate Value

[RETURNS]

CoSine of Angle created by Coordinate X,Y

[DESCRIPTION]

Determines and returns the CoSine of the Angle computed from
the Coordinate X,Y

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Tan    Cosh   ArcSin2   ArcCosh
Tan2   Tanh   ArcCos    ArcTanh
Cot           ArcCos2   ArcCsch
Cot2          ArcTan1   ArcSech
Csc           ArcTan2   ArcCoth
Sec           ArcCsc
              ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;

BEGIN

  For i := 0 to 100 Do
    WriteLn( 'Cos2(1,',i,') = ',Cos2( 1.0, i ) :8:4 );

END;

-*)

Function Cos2(               X,Y       : REAL         ) : REAL;

BEGIN

  Cos2 := X / ( Sqrt( Sqr(X) + Sqr(Y) ) );

END;  { Cos2 }

{}

(*-

[FUNCTION]

Function Tan(                X         : REAL         ) : REAL;

[PARAMETERS]

X           Angle in Radians

[RETURNS]

Returns the Tangent of the Angle

[DESCRIPTION]

Computes and returns the Tangent of the given Angle.  Replaces
Std Pascal "Tan" as handles range checking and bounds.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan2   Tanh   ArcCos    ArcTanh
Cot           ArcCos2   ArcCsch
Cot2          ArcTan1   ArcSech
Csc           ArcTan2   ArcCoth
Sec           ArcCsc
              ArcSec
              ArcCot

[EXAMPLE]

VAR
  R : REAL;
  I : INTEGER;

BEGIN

  R := 0.0;
  For i := 0 to 100 Do
  BEGIN

    WriteLn( 'Tan(',R:0:0,') = ',Tan( R ) :8:4 );
    R := R + 1.0;

  END;  { For i }

END;

-*)

Function Tan(                X         : REAL         ) : REAL;

Var

  R2 : REAL;

BEGIN

  R2 := X;

  While ( R2 > PI_4 ) Do
    R2:= R2 - PI_4;

  While ( R2 < 0.0 ) Do
    R2 := R2 + PI_4;

  If ( Cos( R2 ) <  cTolerance ) And
     ( Cos( R2 ) > -cTolerance ) Then
    Tan := cINFINITY
  Else
    Tan := Sin( X ) / Cos( X );

END;  { Tan }

{}

(*-

[FUNCTION]

Function Tan2(               X, Y      : REAL         ) : REAL;

[PARAMETERS]

X           X Coordinate Value
Y           Y Coordinate Value

[RETURNS]

Tangent of the Angle created by Coordinate X,Y

[DESCRIPTION]

Computes and returns the Tangent of the Angle computed from
the Coordinate X,Y

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Cot           ArcCos2   ArcCsch
Cot2          ArcTan1   ArcSech
Csc           ArcTan2   ArcCoth
Sec           ArcCsc
              ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;

BEGIN

  For i := 0 to 100 Do
    WriteLn( 'Tan2(1,',i,') = ',Tan2( 1.0, i ) :8:4 );

END;

-*)

Function Tan2(               X, Y      : REAL         ) : REAL;

BEGIN

  If ( X = 0.0 ) Then
  BEGIN

    CASE Quad2( Y, X ) OF
      1 : Tan2 :=  cINFINITY;
      2 : Tan2 := -cINFINITY;
      3 : Tan2 :=  cINFINITY;
      4 : Tan2 := -cINFINITY;
    END; {case quad}

  END
  Else
  BEGIN

    CASE Quad2( Y, X ) OF
      1 : Tan2 := Sin( Y / X ) / Cos( Y / X );
      2 : Tan2 := PI - Sin( Y / X ) / Cos( Y / X );
      3 : Tan2 := PI + Sin( Y / X ) / Cos( Y / X );
      4 : Tan2 := PI * 2.0 - Sin( Y / X ) / Cos( Y / X );
    END; {case quad}

  END;

END;  { Tan2 }

{}

(*-

[FUNCTION]

Function Cot(                X         : REAL         ) : REAL;

[PARAMETERS]

X           Angle in Radians

[RETURNS]

CoTangent of the Angle

[DESCRIPTION]

Conputes and returns the CoTangent of a given Angle.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot2          ArcTan1   ArcSech
Csc           ArcTan2   ArcCoth
Sec           ArcCsc
              ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 0.0;
  For i := 0 to 100 Do
  BEGIN

    WriteLn( 'Cot(',R:0:0,') = ',Cot( 1.0, i ) :8:4 );
    R := R + 1.0;

  END;  { For i }

END;

-*)

Function Cot(                X         : REAL         ) : REAL;

Var

  R2 : REAL;

BEGIN

  R2 := X;

  While ( R2 > PI_4 ) Do
    R2 := R2 - PI_4;

  While ( R2 < 0.0 ) Do
    R2 := R2 + PI_4;

  If ( Sin( R2 ) <  cTolerance ) And
     ( Sin( R2 ) > -cTolerance ) Then
    Cot := cINFINITY
  Else
    Cot := Cos( X ) / Sin( X );

END;  { Cot }

{}

(*-

[FUNCTION]

Function Cot2(               X, Y      : REAL         ) : REAL;

[PARAMETERS]

X           X Coordinate Value
Y           Y Coordinate Value

[RETURNS]

CoTangent of Angle computed from Coordinate X,Y

[DESCRIPTION]

Computes and returns the CoTangent of an Angle computed from
the  Coordinate X,Y

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Csc           ArcTan2   ArcCoth
Sec           ArcCsc
              ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;

BEGIN

  For i := 0 to 100 Do
    WriteLn( 'Cot2(1,',i,') = ',Cot2( 1.0, i ) :8:4 );

END;

-*)

Function Cot2(               X, Y      : REAL         ) : REAL;

BEGIN

  If ( X <> 0.0 ) Then
    Cot2 := Cos( Y / X ) / Sin( Y / X )
  Else
    Cot2 := cINFINITY

END;  { Cot2 }

{}

(*-

[FUNCTION]

Function Csc(                X         : REAL         ) : REAL;

[PARAMETERS]

X           Angle in Radians

[RETURNS]

CoSecant of Angle

[DESCRIPTION]

Computes and returns the CoSecant of a given Angle

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2   ArcCoth
Sec           ArcCsc
              ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 0.0;
  For i := 0 to 100 Do
  BEGIN

    WriteLn( 'Csc(',R:0:0,') = ',Csc( R ) :8:4 );
    R := R + 1.0;

  END;  { For i }

END;

-*)

Function Csc(                X         : REAL         ) : REAL;

Var

  R2  : REAL;

BEGIN

  R2 := X;

  While ( R2 > PI_4 ) Do
    R2 := R2 - PI_4;

  While ( R2 < 0.0 ) Do
    R2 := R2 + PI_4;

  If ( Sin( R2 ) <  cTolerance ) And
     ( Sin( R2 ) > -cTolerance ) Then
    Csc := cINFINITY
  Else
    Csc := 1.0 / Sin( X );

END;  { Csc }

{}

(*-

[FUNCTION]

Function Sec(                X         : REAL         ) : REAL;

[PARAMETERS]

X           Angle in Radians

[RETURNS]

Secant of Angle

[DESCRIPTION]

Computes and returns the Secant of a given Angle

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2   ArcCoth
Csc           ArcCsc
              ArcSec
              ArcCot

[EXAMPLE]


VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 0.0;
  For i := 0 to 100 Do
  BEGIN

    WriteLn( 'Sec(',R:0:0,') = ',Sec( R ) :8:4 );
    R := R + 1.0;

  END;  { For i }

END;

-*)

Function Sec(                X         : REAL         ) : REAL;

Var

  R2 : REAL;

BEGIN

  R2 := X;

  While ( R2 > PI_4 ) Do
    R2 := R2 - PI_4;

  While ( R2 < 0.0 ) Do
    R2 := R2 + PI_4;

  If ( Cos( R2 ) <  cTolerance ) And
     ( Cos( R2 ) > -cTolerance ) Then
    Sec := cINFINITY
  Else
    Sec := 1.0 / Cos( X );

END;  { Sec }

{}

(*-

[FUNCTION]

Function Sinh(               X         : REAL         ) : REAL;  {NOT TESTED}

[PARAMETERS]

X           Angle in Radians

[RETURNS]

Hyperbolic Sine of Angle

[DESCRIPTION]

Computes and returns the Hyperbolic Sine of a given Angle

[SEE-ALSO]

Sin2   Cosh   ArcSin    ArcSinh
Cos2   Tanh   ArcSin2   ArcCosh
Tan           ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2   ArcCoth
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 0.0;
  For i := 0 to 100 Do
  BEGIN

    WriteLn( 'Sinh(',R:0:0,') = ',Sinh( R ) :8:4 );
    R := R + 1.0;

  END;  { For i }

END;

-*)

Function Sinh(               X         : REAL         ) : REAL;

BEGIN

  Sinh := ( Exp(X) - Exp(-X) ) / 2;

END;  { Sinh }

{}

(*-

[FUNCTION]

Function Cosh(               X         : REAL         ) : REAL;

[PARAMETERS]

X           Angle in Radians

[RETURNS]

Hyperbolic CoSine of Angle

[DESCRIPTION]

Computes and returns the Hyperbolic CoSine of a given Angle

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Tanh   ArcSin2   ArcCosh
Tan           ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2   ArcCoth
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 0.0;
  For i := 0 to 100 Do
  BEGIN

    WriteLn( 'Cosh(',R:0:0,') = ',Cosh( R ) :8:4 );
    R := R + 1.0;

  END;  { For i }

END;

-*)

Function Cosh(               X         : REAL         ) : REAL;

BEGIN

  Cosh := ( Exp(X) + Exp(-X) ) / 2;

END;  { Cosh }

{}

(*-

[FUNCTION]

Function Tanh(               X         : REAL         ) : REAL;

[PARAMETERS]

X           Angle in Radians

[RETURNS]

Hyperbolic Tangent of Angle

[DESCRIPTION]

Computes and returns the Hyperbolic Tangent of a given Angle

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan           ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2   ArcCoth
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 0.0;
  For i := 0 to 100 Do
  BEGIN

    WriteLn( 'Tanh(',R:0:0,') = ',Tanh( R ) :8:4 );
    R := R + 1.0;

  END;  { For i }

END;

-*)

Function Tanh(               X         : REAL         ) : REAL;

Var

  Q : REAL;

BEGIN

  Q := Exp(X) + Exp(-X);

  If ( Q <> 0.0 ) Then
    Tanh := ( Exp( X ) - Exp( -X ) ) / Q
  Else
    Tanh := cINFINITY;

END;  { Tanh }

{}

(*-

[FUNCTION]

Function Csch(               X         : REAL         ) : REAL;  {NOT TESTED}

[PARAMETERS]

X           Angle in Radians

[RETURNS]

Hyperbolic Cosecant of Angle

[DESCRIPTION]

Computes and returns the Hyperbolic Cosecant of a given Angle

[SEE-ALSO]

Sin2   Cosh   ArcSin    ArcSinh
Cos2   Tanh   ArcSin2   ArcCosh
Tan           ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2   ArcCoth
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 0.0;
  For i := 0 to 100 Do
  BEGIN

    WriteLn( 'Csch(',R:0:0,') = ',Csch( R ) :8:4 );
    R := R + 1.0;

  END;  { For i }

END;

-*)

Function Csch(               X         : REAL         ) : REAL;

BEGIN

  If X <> 0 Then
    Csch := 1 / Sinh( X );

END;  { Csch }

{}

(*-

[FUNCTION]

Function Sech(                X         : REAL         ) : REAL;

[PARAMETERS]

X           Angle in Radians

[RETURNS]

Hyperbolic Secant of Angle

[DESCRIPTION]

Computes and returns the Hyperbolic Secant of a given Angle

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Tanh   ArcSin2   ArcCosh
Tan           ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2   ArcCoth
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 0.0;
  For i := 0 to 100 Do
  BEGIN

    WriteLn( 'Sech(',R:0:0,') = ',Sech( R ) :8:4 );
    R := R + 1.0;

  END;  { For i }

END;

-*)

Function Sech(               X         : REAL         ) : REAL;

BEGIN

  Sech := 1 / Cosh( X );

END;  { Sech }

{}

(*-

[FUNCTION]

Function Coth(               X         : REAL         ) : REAL;

[PARAMETERS]

X           Angle in Radians

[RETURNS]

Hyperbolic Cotangent of Angle

[DESCRIPTION]

Computes and returns the Hyperbolic Cotangent of a given Angle

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan           ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2   ArcCoth
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 0.0;
  For i := 0 to 100 Do
  BEGIN

    WriteLn( 'Coth(',R:0:0,') = ',Coth( R ) :8:4 );
    R := R + 1.0;

  END;  { For i }

END;

-*)

Function Coth(               X         : REAL         ) : REAL;

BEGIN

  If X <> 0 Then
    Coth := 1 / Tanh( X );

END;  { Coth }

{}

(*-

[FUNCTION]

Function ArcSin(             X     : REAL         ) : REAL;

[PARAMETERS]

X       Sine Value

[RETURNS]

Angle in radians whose sine is X.

[DESCRIPTION]

Computes and returns the Inverse sine of a given value.
Positive sine values are assumed quadrant 1 and negative sine
values are assumed as quadrant 4 as there is no means to
compute an absolute angle based on the simple sine value.

NOTE: Sine Value is NOT Range Checked and MUST be in Bounds.

[SEE-ALSO]

Sin2   Sinh   ArcSin2   ArcSinh
Cos2   Cosh   ArcCos    ArcCosh
Tan    Tanh   ArcCos2   ArcTanh
Tan2          ArcTan1   ArcCsch
Cot           ArcTan2   ArcSech
Cot2          ArcCsc    ArcCoth
Csc           ArcSec
Sec           ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcSin(',R:0:0,') = ',ArcSin( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcSin(             X     : REAL         ) : REAL;

BEGIN

  If (X >= -1) AND (X <= 1) Then
    ArcSin := ArcTan( X / ( Sqrt( 1.0 - Sqr( X ) ) ) );

END;  { ArcSin }

{}

(*-

[FUNCTION]

Function ArcSin2(            X     : REAL;
                             Quadrant  : INTEGER      ) : REAL;

[PARAMETERS]

X       Sine Value
Quadrant    Angular Quadrant Containing Sine Value

[RETURNS]

Arc Sine Angle of Sine X in Radians.

[DESCRIPTION]

Computes and returns the Arc Sine of a given Sine Value.
Using the input Quadrant, the Correct Absolute Sine Angle
is determined.

NOTE: Sine Value is NOT Range Checked and MUST be in Bounds.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcCos    ArcCosh
Tan    Tanh   ArcCos2   ArcTanh
Tan2          ArcTan1   ArcCsch
Cot           ArcTan2   ArcSech
Cot2          ArcCsc    ArcCoth
Csc           ArcSec
Sec           ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcSin2(',R:0:0,') [Quad=3] = ',ArcSin2( R, 3 ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcSin2(            X     : REAL;
                             Quadrant  : INTEGER      ) : REAL;

BEGIN

  CASE Quadrant OF
    1 : ArcSin2 := ArcTan( X / ( Sqrt( 1.0 - Sqr( X ) ) ) );
    2 : ArcSin2 := PI_2 - ArcTan( X / ( Sqrt( 1.0 - Sqr( X ) ) ) );
    3 : ArcSin2 := PI_2 - ArcTan( X / ( Sqrt( 1.0 - Sqr( X ) ) ) );
    4 : ArcSin2 := PI_4 - ArcTan( X / ( Sqrt( 1.0 - Sqr( X ) ) ) );
  END;

END;  { ArcSin2 }

{}

(*-

[FUNCTION]

Function ArcCos(             X     : REAL         ) : REAL;

[PARAMETERS]

X       CoSine Value

[RETURNS]

Inverse cosine angle in radians.

[DESCRIPTION]

Computes and returns the Arc CoSine of a given CoSine Value.
Positive CoSine Values are assumed Quadrant 1 and negative
CoSine Values are assumed Quadrant 2 as there is no means to
compute Absolute Angle based upon Simple CoSine Value.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos2   ArcTanh
Tan2          ArcTan1   ArcCsch
Cot           ArcTan2   ArcSech
Cot2          ArcCsc    ArcCoth
Csc           ArcSec
Sec           ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcCos(',R:0:0,') = ',ArcCos( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcCos(             X     : REAL         ) : REAL;

BEGIN

  If (X >= -1) AND (X <= 1) Then
    ArcCos := ArcTan( Sqrt(1.0 - Sqr(X)) / X );

END;  { ArcCos }

{}

(*-

[FUNCTION]

Function ArcCos2(            X     : REAL;
                             Quadrant  : INTEGER      ) : REAL;

[PARAMETERS]

X       CoSine Value
Quadrant    Angular Quadrant Containing CoSine Value

[RETURNS]

Arc CoSine Angle of CoSine Value

[DESCRIPTION]

Computes and returns the Arc CoSine of a given CoSine Value.
Using the input Quadrant, the Correct Absolute CoSine Angle
is determined.

NOTE: Cosine Value is NOT Range Checked and MUST be in Bounds.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcTan1   ArcCsch
Cot           ArcTan2   ArcSech
Cot2          ArcCsc    ArcCoth
Csc           ArcSec
Sec           ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcCos2(',R:0:0,') [Quad=3] = ',ArcCos2( R,3 ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcCos2(            X     : REAL;
                             Quadrant  : INTEGER      ) : REAL;

                                       {ROUNDING ERROR AT BOTTOM}
                                       { 2)  0- 90 DN TO  0 AS +90 }
                                       {    90-180 DN TO -1 AS 180 }
                                       {   180-270 UP     0 AS +90 }
                                       {   270-360 UP TO  0 AS   0 }

BEGIN

  CASE Quadrant OF
    1 : ArcCos2 := ArcTan( ( Sqrt( 1.0 - Sqr( X ) ) ) / X );
    2 : ArcCos2 := ArcTan( ( Sqrt( 1.0 - Sqr( X ) ) ) / X );
    3 : ArcCos2 := PI_4 - ArcTan( ( Sqrt( 1.0 - Sqr( X ) ) ) / X );
    4 : ArcCos2 := PI_4 - ArcTan( ( Sqrt( 1.0 - Sqr( X ) ) ) / X );
  END;

END;  { ArcCos2 }

{}

(*-

[FUNCTION]

Function ArcTan1(            X     : REAL         ) : REAL;

[PARAMETERS]

X       Tangent Value

[RETURNS]

Arc Tangent Angle of Tangent X

[DESCRIPTION]

Computes and returns the Arc Tangent of a given Tangent Value.
Positive Tangent Values are assumed Quadrant 1 and negative
Tangent Values are assumed Quadrant 4 as there is no means to
compute Absolute Angle based upon Simple Tangent Value.

NOTE: Limiting Tangent Range is based upon the Constant cINFINITY.
Anything exceeds this in either direction is considered 90 degrees.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan2   ArcSech
Cot2          ArcCsc    ArcCoth
Csc           ArcSec
Sec           ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcTan1(',R:0:0,') = ',ArcTan1( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcTan1(            X     : REAL         ) : REAL;

Var

  R2,
  AT   : REAL;

BEGIN

  R2 := X;

  If ( X >= cINFINITY ) Then
    AT := PI_1
  Else
  If ( X >= 0.0 ) Then
    AT := ArcTan( X )
  Else
    AT := PI + ArcTan( X );

  ArcTan1 := AT;

END;  { ArcTan1 }

{}

(*-

[FUNCTION]

Function ArcTan2(            X, Y      : REAL         ) : REAL;

[PARAMETERS]

X           X Coordinate Value
Y           Y Coordinate Value

[RETURNS]

Arc Tangent Angle computed from Coordinate X,Y

[DESCRIPTION]

Determines and returns the ArcTangent Angle of a given Tangent
Value computed from the Coordinate X,Y


Borland Pascal has a problem with an Angle in the 4th Quadrant
when the argument becomes negative.  The Negative argument table
has not been uniformly prepared.  This function handles that
problem.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcCsc    ArcCoth
Csc           ArcSec
Sec           ArcCot

[EXAMPLE]

VAR
  I : INTEGER;

BEGIN

  For i := 100 DownTo 0 Do
    WriteLn( 'ArcTan2(1,',i,') = ',ArcTan2( 1, i ) :8:4 );

END;

-*)

Function ArcTan2(            X, Y      : REAL         ) : REAL;

Var

  AT   : REAL;

BEGIN

  If ( X = 0.0 ) Then
  BEGIN

    CASE Quad2( X, Y ) OF
      1 : AT := PI;
      2 : AT := PI;
      3 : AT := PI_4;
      4 : AT := PI_4;
    END; {case quad}

  END
  Else
  BEGIN

    CASE Quad2( X, Y ) OF
      1 : AT := ArcTan( Y / X );
      2 : AT := PI   - ArcTan( Abs(Y / X) );  { BP ArcTan has problems }
      3 : AT := PI   + Arctan( Y / X );       { with negative Angles   }
      4 : AT := PI_4 - ArcTan( Abs(Y / X) );
    END; {case quad}

  END;

  ArcTan2 := AT;

END;  { ArcTan2 }

{}

(*-

[FUNCTION]

Function ArcCsc(             X     : REAL         ) : REAL;

[PARAMETERS]

X       CoSecant Value

[RETURNS]

Inverse cosecant angle in radians.

[DESCRIPTION]

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2   ArcCoth
Csc           ArcSec
Sec           ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcCsc(',R:0:0,') = ',ArcCsc( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcCsc(             X     : REAL         ) : REAL;  {INCOMPLETE}

BEGIN

  If ( Abs(X) >= 1 ) Then
    ArcCsc := ArcSin(1/X);

END;  { ArcCsc }

{}

(*-

[FUNCTION]

Function ArcSec(             X     : REAL         ) : REAL;

[PARAMETERS]

X       Secant Value

[RETURNS]

Inverse secant angle in radians.

[DESCRIPTION]

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2   ArcCoth
Csc           ArcCsc
Sec           ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcSec(',R:0:0,') = ',ArcSec( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcSec(             X     : REAL         ) : REAL;  {INCOMPLETE}

BEGIN

  If ( Abs(X) >= 1 ) Then
    ArcSec := ArcCos(1/X);

END;  { ArcSec }

{}

(*-

[FUNCTION]

Function ArcCot(             X     : REAL         ) : REAL;

[PARAMETERS]

X       CoTangent Value

[RETURNS]

Inverse cotangent angle in radians.

[DESCRIPTION]


[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2   ArcCoth
Csc           ArcCsc
Sec           ArcSec

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcCot(',R:0:0,') = ',ArcCot( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcCot(             X     : REAL         ) : REAL;  {INCOMPLETE}

BEGIN

  ArcCot := ArcTan(1/X);

END;  { ArcCot }

{}

(*-

[FUNCTION]

Function ArcSinh(            X     : REAL         ) : REAL;

[PARAMETERS]

X       Hyperbolic Sine Value

[RETURNS]

Arc Hyperbolic Sine Angle

[DESCRIPTION]

Computes and returns the Arc Hyperbolic Sine Angle of a given
Hyperbolic Sine Angle.

NOTE: The Hyperbolic Sine Value is NOT Range Checked and MUST
be in Bounds.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcCosh
Cos2   Cosh   ArcSin2   ArcTanh
Tan    Tanh   ArcCos    ArcCsch
Tan2          ArcCos2   ArcSech
Cot           ArcTan1   ArcCoth
Cot2          ArcTan2
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcSinh(',R:0:0,') = ',ArcSinh( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcSinh(            X     : REAL         ) : REAL;

BEGIN

  ArcSinh := Ln( X + Sqrt(X*X + 1) );

END;  { ArcSinh }

{}

(*-

[FUNCTION]

Function ArcCosh(            X     : REAL         ) : REAL;

[PARAMETERS]

X       Hyperbolic CoSine Value

[RETURNS]

Arc Hyperbolic CoSine Angle

[DESCRIPTION]

Computes and returns the Arc Hyperbolic CoSine Angle of a given
Hyperbolic CoSine Value.

NOTE: The Hyperbolic CoSine Value is NOT Range Checked and MUST
be in Bounds.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcTanh
Tan    Tanh   ArcCos    ArcCsch
Tan2          ArcCos2   ArcSech
Cot           ArcTan1   ArcCoth
Cot2          ArcTan2
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcCosh(',R:0:0,') = ',ArcCosh( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcCosh(            X     : REAL         ) : REAL;

BEGIN

  If (X >= 1) Then
    ArcCosh := Ln( X + Sqrt(X*X - 1) );

END;  { ArcCosh }

{}

(*-

[FUNCTION]

Function ArcTanh(            X     : REAL         ) : REAL;

[PARAMETERS]

X       Hyperbolic Tangent Value

[RETURNS]

Arc Hyperbolic Tangent Angle

[DESCRIPTION]

Computes and returns the Arc Hyperbolic Tangent Angle of a given
Hyperbolic Tangent Value.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcCsch
Tan2          ArcCos2   ArcSech
Cot           ArcTan1   ArcCoth
Cot2          ArcTan2
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcTanh(',R:0:0,') = ',ArcTanh( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcTanh(            X     : REAL         ) : REAL;

BEGIN

  If Abs(X) < 1 Then
    ArcTanh := (1/2) * Ln( (1 + X) / (1 - X) );

END;  { ArcTanh }

{}

(*-

[FUNCTION]

Function ArcCsch(            X     : REAL         ) : REAL;

[PARAMETERS]

X       Hyperbolic CoSecant Value

[RETURNS]

Arc Hyperbolic CoSecant Angle

[DESCRIPTION]

Computes and returns the Arc Hyperbolic CoSecant Angle of a given
Hyperbolic CoSecant Value.

NOTE: The Hyperbolic CoSecant Value is NOT Range Checked and MUST
be in Bounds.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcSech
Cot           ArcTan1   ArcCoth
Cot2          ArcTan2
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcCsch(',R:0:0,') = ',ArcCsch( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcCsch(            X     : REAL         ) : REAL;

BEGIN

  If (X > 0) Then
    ArcCsch := Ln( (1 + Sqrt(1 + X*X)) / Abs(X) )
  Else
  If (X < 0) Then
    ArcCsch := Ln( (-1 + Sqrt(1 + X*X)) / Abs(X) );

END;  { ArcCsch }

{}

(*-

[FUNCTION]

Function ArcSech(            X     : REAL         ) : REAL;

[PARAMETERS]

X       Hyperbolic Secant Value

[RETURNS]

Arc Hyperbolic Secant Angle

[DESCRIPTION]

Computes and returns the Arc Hyperbolic Secant Angle of a given
Hyperbolic Secant Value.

NOTE: The Hyperbolic Secant Value is NOT Range Checked and MUST
be in Bounds.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcCoth
Cot2          ArcTan2
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcSech(',R:0:0,') = ',ArcSech( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcSech(            X     : REAL         ) : REAL;

BEGIN

  If (X > 0) AND (X <= 1) Then
    ArcSech := Ln( (1 + Sqrt(1 - X*X)) / X );

END;  { ArcSech }

{}

(*-

[FUNCTION]

Function ArcCoth(            X     : REAL         ) : REAL;

[PARAMETERS]

X       Hyperbolic Tangent Value

[RETURNS]

Arc Hyperbolic Tangent Angle

[DESCRIPTION]

Computes and returns the Arc Hyperbolic Tangent Angle of a given
Hyperbolic Tangent Value.

[SEE-ALSO]

Sin2   Sinh   ArcSin    ArcSinh
Cos2   Cosh   ArcSin2   ArcCosh
Tan    Tanh   ArcCos    ArcTanh
Tan2          ArcCos2   ArcCsch
Cot           ArcTan1   ArcSech
Cot2          ArcTan2
Csc           ArcCsc
Sec           ArcSec
              ArcCot

[EXAMPLE]

VAR
  I : INTEGER;
  R : REAL;

BEGIN

  R := 1.0;
  For i := 100 DownTo 0 Do
  BEGIN

    WriteLn( 'ArcCoth(',R:0:0,') = ',ArcCoth( R ) :8:4 );
    R := R - 0.01;

  END;  { For i }

END;

-*)

Function ArcCoth(            X     : REAL         ) : REAL;

BEGIN

  If Abs(X) > 1 Then
    ArcCoth := (1/2) * Ln( (X + 1) / (X - 1) );

END;  { ArcCoth }

{}

(*-

[FUNCTION]

Function Power(              Num       : LONGINT;
                             Exponent  : LONGINT      ) : LONGINT;

[PARAMETERS]

Num         Number to Raise to Power
Exponent    Power to Raise Value by

[RETURNS]

Number Raised by a given Power

[DESCRIPTION]

Determines the Number Raised to a given Power.  Return the result
as a Long Integer Value.

[SEE-ALSO]

PowerR
Root
RootR

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := PowerR( 7, 2 );  { Answer = 49 }

END;

-*)


Function Power(              Num       : LONGINT;
                             Exponent  : LONGINT      ) : LONGINT;

Var

  R1,R2 : REAL;

BEGIN

  If ( Num > 0 ) Then
  BEGIN

    R1 := Num;
    R2 := Exponent;
    Power := Round( Exp( Ln( R1 ) *  R2 ) );

  END
  Else
    Power := 0;

END;  { Power }

{}

(*-

[FUNCTION]

Function PowerR(             Num       : REAL;
                             Exponent  : REAL         ) : REAL;

[PARAMETERS]

Num         Number to Raise to a Power
Exponent    Power to Raise Number by

[RETURNS]

Number Raised by a given Power

[DESCRIPTION]

Determines the Number Raised by a given Power.  Returns the result
as a Floating Point Value.

[SEE-ALSO]

Power
Root
RootR

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := PowerR( 7.0, 2.0 );  { Answer = 49.0 }

END;

-*)


Function PowerR(             Num       : REAL;
                             Exponent  : REAL         ) : REAL;
BEGIN

  If ( Num > 0.0 ) Then
  BEGIN

    If ( Exponent > 88 ) Then
      PowerR := cOVERFLOW
    Else
    If ( Exponent < -88 ) Then
      PowerR := cUNDERFLOW
    Else
      PowerR := Exp( Exponent * Ln( Num ) )
  END
  Else
    If ( Num = 0.0 ) And ( Exponent = 0.0 ) Then
      PowerR := 1.0
    Else
      PowerR := 0.0;

END;  { PowerR }

{}

(*-

[FUNCTION]

Function Root(               Num       : LONGINT;
                             RootVal   : LONGINT      ) : LONGINT;

[PARAMETERS]

Num         Number to get a Root from  (Must be > 0 or RunTime Error!)
RootVal     Root to apply to Number (can be any real number)

[RETURNS]

The Root Value of a given Number

[DESCRIPTION]

Computes the Root Value of a given Number.  The result is returned
as a Long Integer Value.

NOTE: Be sure that "Num" is Zero (0) or greater as imaginary Roots
and use of other Complex Numbers will cause a Runtime Error in this
Function.

[SEE-ALSO]

Power
PowerR
RootR

[EXAMPLE]

VAR
  Answer : LONGINT;

BEGIN

  Answer := Root( 49, 2 );  { Answer = 7 }

END;

-*)


Function Root(               Num       : LONGINT;
                             RootVal   : LONGINT      ) : LONGINT;

Var

  R1,R2 : LONGINT;

BEGIN

  If ( Num > 0 ) Then
  BEGIN

    R1 := Num;
    R2 := RootVal;
    Root := Round( Exp( Ln( R1 ) * ( 1.0 / R2 ) ) );

  END
  Else
    Root := 0;

END;  { Root }

{}

(*-

[FUNCTION]

Function RootR(              Num       : REAL;
                             RootVal   : REAL         ) : REAL;

[PARAMETERS]

Num         Number to get a Root from  (Must be > 0 or RunTime Error!)
RootVal     Root to apply to Number (can be any real number)

[RETURNS]

The Root Value of a given Number

[DESCRIPTION]

Computes the Root Value of a given Number.  The result is returned
as a Floating Point Value.

NOTE: Be sure that "Num" is Zero (0) or greater as imaginary Roots
and use of other Complex Numbers will cause a Runtime Error in this
Function.

[SEE-ALSO]

Power
PowerR
Root

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := RootR( 49.0, 2.0 );  { Answer = 7.0 }

END;

-*)

Function RootR(              Num       : REAL;
                             RootVal   : REAL         ) : REAL;
BEGIN

  If ( Num > 0 ) Then
    RootR := Exp( Ln( Num ) * ( 1.0 / RootVal ) )
  Else
    RootR := 0;

END;  { RootR }

{}

(*-

[FUNCTION]

Function Log(                Num       : REAL;
                             Base      : REAL         ) : REAL;

[PARAMETERS]

Num         Number to determine a Base of
Base        Base Value to use for Logarithm

[RETURNS]

Logarithm of a given Number.

[DESCRIPTION]

Computes a Logarithm of a given Number using a given Base.
To use "Natural" Logarithm use the Value from the Function E
as the Base.

The result is returned as a Floating Point Value.

[SEE-ALSO]

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := Log( 32, 2 );  { Answer = 5.0 }

END;

-*)

Function Log(                Num       : REAL;
                             Base      : REAL         ) : REAL;
BEGIN

  If ( Num < 0.0 ) Then
    Log := cUNDERFLOW
  Else
  If ( Base < 1.0 ) Then
    Log := cOVERFLOW
  Else
    Log := Ln( Num ) / Ln( Base );

END;  { Log }

{}

(*-

[Function]

Function FastHyp(            XDist     : REAL;
                             YDist     : REAL        ) : REAL;

[PARAMETERS]

XDist       X Distance between Points
YDist       Y Distance between Points

[RETURNS]

The Hypotenuse of the X and Y Distances

[DESCRIPTION]

Computes and returns the Hypotenuse of the X and Y Distances
from another Point.  The main advantage of this routine is that
is does all the routines as simple Math functions thereby
reducing the computation time.

This method is useful in providing accept/reject distance tests
in 2D graphics.  These are commonly used in providing "Gravity
Fields" or other proximity tests for circle or ellipse selection.
This form is commony employed in libraries offering a high-precision
hypot as the conventional form is prone to severe loss of accuracy.

Note that the code is symmetric about the axis x = y = 1 within the
first quadrant.  Absolute value operation on the input arguments
allow for four-quadrant operation, yeilding isometric distance lines
of eight-fold symmetry.

[SEE-ALSO]

[EXAMPLE]

-*)

Function FastHyp(            XDist     : REAL;
                             YDist     : REAL        ) : REAL;
BEGIN

  If XDist <> 0.0 Then
    FastHyp := XDist * ( 1.0 + 0.5 * Sqr( YDist / XDist ) )
  Else
    FastHyp := Sqrt( Sqr( XDist ) + Sqr( YDist ) );

END;

{}

(*-

[Function]

Function FastHypR(           XDist     : REAL;
                             YDist     : REAL        ) : REAL;

[PARAMETERS]

XDist       X Distance between Points
YDist       Y Distance between Points

[RETURNS]

The Hypotenuse of the X and Y Distances

[DESCRIPTION]

Computes and returns the Hypotenuse of the X and Y Distances
from another Point.  The main advantage of this routine is that
is does all the routines as simple Math functions thereby
reducing the computation time.

This method is useful in providing accept/reject distance tests
in 2D graphics.  These are commonly used in providing "Gravity
Fields" or other proximity tests for circle or ellipse selection.
This form is commony employed in libraries offering a high-precision
hypot as the conventional form is prone to severe loss of accuracy.

Note that the code is symmetric about the axis x = y = 1 within the
first quadrant.  Absolute value operation on the input arguments
allow for four-quadrant operation, yeilding isometric distance lines
of eight-fold symmetry.

[SEE-ALSO]

[EXAMPLE]

-*)

Function FastHypR(           XDist     : REAL;
                             YDist     : REAL        ) : REAL;
BEGIN

  If XDist <> 0.0 Then
    FastHypR := XDist * ( 1.0 + 0.5 * Sqr( YDist / XDist ) )
  Else
    FastHypR := Sqrt( Sqr( XDist ) + Sqr( YDist ) );

END;

{}

(*-

[Function]

Function Hypot(              XDist     : REAL;
                             YDist     : REAL        ) : REAL;

[PARAMETERS]

XDist       X Distance between Points
YDist       Y Distance between Points

[RETURNS]

The Hypotenuse of the X and Y Distances

[DESCRIPTION]

Computes and returns the Hypotenuse of the X and Y Distances
from another Point.

[SEE-ALSO]

[EXAMPLE]

-*)

Function Hypot(              XDist     : REAL;
                             YDist     : REAL        ) : REAL;
BEGIN

  Hypot := Sqrt( Sqr( XDist ) + Sqr( YDist ) );

END;

{}

(*-

[FUNCTION]

Function FastDist(           X1        : LONGINT;
                             Y1        : LONGINT;
                             X2        : LONGINT;
                             Y2        : LONGINT      ) : LONGINT;

[PARAMETERS]

X1          X Coordinate of 1st Point
Y1          Y Coordinate of 1st Point
X2          X Coordinate of 2nd Point
Y2          Y Coordinate of 2nd Point

[RETURNS]

The Distance between the 2 Points (the Hypotenuse)

[DESCRIPTION]

Computes and returns the distance between 2 points whose Coordinates
are provided.

[SEE-ALSO]

Hypot

[EXAMPLE]

BEGIN

  WriteLn( 'Distance = ',FastDist( 10,10, 20,20 ):8:4 );

END;

-*)

Function FastDist(           X1        : LONGINT;
                             Y1        : LONGINT;
                             X2        : LONGINT;
                             Y2        : LONGINT      ) : LONGINT;
VAR
  L : LONGINT;

BEGIN

  X2 := X2 - X1;
  If X2 < 0 Then X2 := -X2;
  Y2 := Y2 - Y1;
  If Y2 < 0 Then Y2 := -Y2;

  If (X2 > Y2) Then
    L := Y2
  Else
    L := X2;

  FastDist := X2 + Y2 - L SHR 1;

END;

{}

(*-

[FUNCTION]

Function DistanceXY(         X1        : REAL;
                             Y1        : REAL;
                             X2        : REAL;
                             Y2        : REAL         ) : REAL;

[PARAMETERS]

X1          X Coordinate of 1st Point
Y1          Y Coordinate of 1st Point
X2          X Coordinate of 2nd Point
Y2          Y Coordinate of 2nd Point

[RETURNS]

The Distance between the 2 Points (the Hypotenuse)

[DESCRIPTION]

Computes and returns the distance between 2 points whose Coordinates
are provided.

[SEE-ALSO]

Hypot

[EXAMPLE]

BEGIN

  WriteLn( 'Distance = ',Distance( 10,10, 20,20 ):8:4 );

END;

-*)

Function DistanceXY(         X1        : REAL;
                             Y1        : REAL;
                             X2        : REAL;
                             Y2        : REAL         ) : REAL;

BEGIN

  DistanceXY := Sqrt( Sqr(X2 - X1) + Sqr(Y2 - Y1) );

END;

{}

(*-

[FUNCTION]

Function Percent(            Part      : LONGINT;
                             Whole     : LONGINT      ) : REAL;

[PARAMETERS]

Part        Portion of the Whole being Referenced
Whole       Size representing 100% of Value

[RETURNS]

Percentage of 100% which Part represents

[DESCRIPTION]

Determines what percentage of the "Whole" Value the "Part" Value
represents.

[SEE-ALSO]

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := Percent( 30.0, 60.0 );  { Answer = 50.0 }

END;

-*)

Function Percent(            Part      : LONGINT;
                             Whole     : LONGINT      ) : REAL;

Var

  R1,R2 : REAL;

BEGIN

  R1 := Part;
  R2 := Whole;

  Percent := 100.0 * ( R1 / R2 );

END;  { Percent }

{}

(*-

[FUNCTION]

Function Min(                A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

[PARAMETERS]

A           1st Source Value
B           2nd Source Value

[RETURNS]

The Lesser of the two Values

[DESCRIPTION]

Returns the Lesser of the Two Values as a Long Integer Value.

[SEE-ALSO]

MinR
Max
MaxR

[EXAMPLE]

VAR
  Answer : LONGINT;

BEGIN

  Answer := Min( 5, 3 );  { Answer = 3 }

END;

-*)

Function Min(                A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

BEGIN

  If A < B Then
    Min := A
  Else
    Min := B;

END;  { Min }

{}

(*-

[FUNCTION]

Function MinR(               A         : REAL;
                             B         : REAL         ) : REAL;

[PARAMETERS]

A           1st Source Value
B           2nd Source Value

[RETURNS]

The Lesser of the two Values

[DESCRIPTION]

Returns the Lesser of the Two Values as a Floating Point Value.

[SEE-ALSO]

Min
Max
MaxR

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := MinR( 5.2, 3.6 );  { Answer := 3.6 }

END;

-*)

Function MinR(               A         : REAL;
                             B         : REAL         ) : REAL;

BEGIN

  If A < B Then
    MinR := A
  Else
    MinR := B;

END;  { MinR }

{}

(*-

[FUNCTION]

Function Max(                A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

[PARAMETERS]

A           1st Source Value
B           2nd Source Value

[RETURNS]

The Greater of the two Values

[DESCRIPTION]

Returns the Greater of the Two Values as a Long Integer Value.

[SEE-ALSO]

Min
MinR
MaxR

[EXAMPLE]

VAR
  Answer : LONGINT;

BEGIN

  Answer := Max( 5, 3 );  { Answer = 5 }

END;

-*)

Function Max(                A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

BEGIN

  If A > B Then
    Max := A
  Else
    Max := B;

END;  { Max }

{}

(*-

[FUNCTION]

Function MaxR(               A         : REAL;
                             B         : REAL         ) : REAL;

[PARAMETERS]

A           1st Source Value
B           2nd Source Value

[RETURNS]

The Greater of the two Values

[DESCRIPTION]

Returns the Greater of the Two Values as a Floating Point Value.

[SEE-ALSO]

Min
MinR
Max

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := MaxR( 5.2, 3.6 );  { Answer = 5.2 }

END;

-*)

Function MaxR(               A         : REAL;
                             B         : REAL         ) : REAL;

BEGIN

  If A > B Then
    MaxR := A
  Else
    MaxR := B;

END;

{}

(*-

[FUNCTION]

Function Range(              Num       : LONGINT;
                             Low       : LONGINT;
                             High      : LONGINT      ) : LONGINT;

[PARAMETERS]

Num         Source Value to Range Check
Low         Minimum Limit
High        Maximum Limit

[RETURNS]

The Value Clipped by the Range

[DESCRIPTION]

Range Checks a Value and Clips it to within the given Minimum
and Maximum Range.  Result is returned as a Long Integer Value.

[SEE-ALSO]

RangeR
Floor
FloorR
Ceiling
CeilingR

[EXAMPLE]

VAR
  Answer : LONGINT;

BEGIN

  Answer := RangeR( 43 ,40, 50 );  { Answer = 43 }
  Answer := RangeR( 37 ,40, 50 );  { Answer = 40 }
  Answer := RangeR( 73 ,40, 50 );  { Answer = 50 }

END;

-*)

Function Range(              Num       : LONGINT;
                             Low       : LONGINT;
                             High      : LONGINT      ) : LONGINT;

BEGIN

  If ( Num < Low ) Then
    Num := Low;

  If ( Num > High ) Then
    Num := High;

  Range := Num;

END;  { Range }

{}

(*-

[FUNCTION]

Function RangeR(             Num       : REAL;
                             Low       : REAL;
                             High      : REAL         ) : REAL;

[PARAMETERS]

Num         Source Value to Range Check
Low         Minimum Limit
High        Maximum Limit

[RETURNS]

The Value Clipped by the Range

[DESCRIPTION]

Range Checks a Value and Clips it to within the given Minimum
and Maximum Range.  Result is returned as a Floating Point Value.

[SEE-ALSO]

Range
Floor
FloorR
Ceiling
CeilingR

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := RangeR( 43.6 ,40.0, 50.0 );  { Answer = 43.6 }
  Answer := RangeR( 37.2 ,40.0, 50.0 );  { Answer = 40.0 }
  Answer := RangeR( 73.3 ,40.0, 50.0 );  { Answer = 50.0 }

END;

-*)

Function RangeR(             Num       : REAL;
                             Low       : REAL;
                             High      : REAL         ) : REAL;

BEGIN

  If ( Num < Low ) Then
    Num := Low;

  If ( Num > High ) Then
    Num := High;

  RangeR := Num;

END;  { RangeR }

{}

(*-

[FUNCTION]

Function Floor(              Num       : LONGINT;
                             Low       : LONGINT      ) : LONGINT;

[PARAMETERS]

Num         Source Value to Range Check
Low         Minimum Limit

[RETURNS]

The Value Clipped by the Minimum Range

[DESCRIPTION]

Range Checks a Value and Clips it so it is at or above a given
Minimum Range.  The result is returned as a Long Integer Value.

[SEE-ALSO]

Range
RangeR
FloorR
Ceiling
CeilingR

[EXAMPLE]

VAR
  Answer : LONGINT;

BEGIN

  Answer := Floor( 33, 25 );  { Answer = 33 }
  Answer := Floor( 17, 25 );  { Answer = 25 }

END;

-*)

Function Floor(              Num       : LONGINT;
                             Low       : LONGINT      ) : LONGINT;

BEGIN

  If ( Num < Low ) Then
    Floor := Low
  Else
    Floor := Num;

END;  { Floor }

{}

(*-

[FUNCTION]

Function FloorR(             Num       : REAL;
                             Low       : REAL         ) : REAL;

[PARAMETERS]

Num         Source Value to Range Check
Low         Minimum Limit

[RETURNS]

The Value Clipped by the Minimum Range

[DESCRIPTION]

Range Checks a Value and Clips it so it is at or above a given
Minimum Range.  The result is returned as a Floating Point Value.

[SEE-ALSO]

Range
RangeR
Floor
Ceiling
CeilingR

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := FloorR( 22.5, 20.0 );  { Answer = 22.5 }
  Answer := FloorR( 17.5, 20.0 );  { Answer = 20.0 }

END;

-*)

Function FloorR(             Num       : REAL;
                             Low       : REAL         ) : REAL;

BEGIN

  If ( Num < Low ) Then
    FloorR := Low
  Else
    FloorR := Num;

END;  { FloorR }

{}

(*-

[FUNCTION]

Function Ceiling(            Num       : LONGINT;
                             High      : LONGINT      ) : LONGINT;

[PARAMETERS]

Num         Source Value to Range Check
High        Maximum Limit

[RETURNS]

The Value Clipped by the Maximum Range

[DESCRIPTION]

Range Checks a Value and Clips it so it is at or above a given
Maximum Range.  The result is returned as a Long Integer Value.

[SEE-ALSO]

Range
RangeR
Floor
FloorR
CeilingR

[EXAMPLE]

VAR
  Answer : LONGINT;

BEGIN

  Answer := Ceiling( 32, 40 );  { Answer = 32 }
  Answer := Ceiling( 45, 40 );  { Answer = 40 }

END;

-*)

Function Ceiling(            Num       : LONGINT;
                             High      : LONGINT      ) : LONGINT;

BEGIN

  If ( Num < High ) Then
    Ceiling := High
  Else
    Ceiling := Num;

END;  { Ceiling }

{}

(*-

[FUNCTION]

Function CeilingR(           Num       : REAL;
                             High      : REAL         ) : REAL;

[PARAMETERS]

Num         Source Value to Range Check
High        Maximum Limit

[RETURNS]

The Value Clipped by the Maximum Range

[DESCRIPTION]

Range Checks a Value and Clips it so it is at or above a given
Maximum Range.  The result is returned as a Floating Point Value.

[SEE-ALSO]

Range
RangeR
Floor
FloorR
Ceiling

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := Ceiling(  95.2, 100.0 );  { Answer :=  95.2 }
  Answer := Ceiling( 104.5, 100.0 );  { Answer := 100.0 }

END;

-*)

Function CeilingR(           Num       : REAL;
                             High      : REAL         ) : REAL;

BEGIN

  If ( Num > High ) Then
    CeilingR := High
  Else
    CeilingR := Num;

END;  { CeilingR }

{}

(*-

[FUNCTION]

Function Sign(               Num       : LONGINT      ) : INTEGER;

[PARAMETERS]

Num         Source Value

[RETURNS]

The Value's Sign (+1 if >= 0, or -1 if < 0 )

[DESCRIPTION]

Determines the sign of the Source Value.  If it is Greater or Equal
to Zero, then it is +1.  If it is Less than Zero, then it is -1.
The result is returned as a Long Integer Value.

[SEE-ALSO]

[EXAMPLE]

VAR
  Answer : INTEGER;

BEGIN

  Answer := Sign( 100 );  { Answer = +1 }

END;

-*)

Function Sign(               Num       : LONGINT      ) : INTEGER;

BEGIN

  If ( Num < 0 ) Then
    Sign := -1
  Else
    Sign := 1;

END;  { Sign }

{}

(*-

[FUNCTION]

Function SignR(              Num       : LONGINT      ) : INTEGER;

[PARAMETERS]

Num         Source Value

a[RETURNS]

The Value's Sign (+1 if >= 0, or -1 if < 0 )

[DESCRIPTION]

Determines the sign of the Source Value.  If it is Greater or Equal
to Zero, then it is +1.  If it is Less than Zero, then it is -1.
The result is returned as a Floating Point Value.

[SEE-ALSO]

Sign

[EXAMPLE]

VAR
  Answer : INTEGER;

BEGIN

  Answer := SignR( -32.6 );  { Answer = -1 }

END;

-*)

Function SignR(              Num       : REAL         ) : INTEGER;

BEGIN

  If ( Num < 0.0 ) Then
    SignR := -1
  Else
    SignR := 1;

END;  { SignR }


{}

(*-

[FUNCTION]

Function QuadraticPlus(      A         : LONGINT;
                             B         : LONGINT;
                             C         : LONGINT      ) : REAL;

[PARAMETERS]

A           1st Polynomial Position Value
B           2nd Polynomial Position Value
C           3rd Polynomial Position Value

[RETURNS]

Positive Quadratic Solution in Terms of X

[DESCRIPTION]

Computes the Quadratic of y = Ax^2 + Bx + C in terms of X with
only the Positive Answer returned.

[SEE-ALSO]

QuadraticNeg

[EXAMPLE]

VAR
  X : REAL;

BEGIN

  X := QuadraticPlus( 2, 8, 4 );  { X = -0.5858 }

END;

-*)

Function QuadraticPlus(      A         : LONGINT;
                             B         : LONGINT;
                             C         : LONGINT      ) : REAL;

Var

  X : REAL;

BEGIN

  X := Sqr(B) - (4 * A * C);

  If (X < 0) Then
    QuadraticPlus := 0
  Else
    QuadraticPlus := (-B + Sqrt(X)) / (2 * A);

END;  { Quadratic }


{}

(*-

[FUNCTION]

Function QuadraticNeg(       A         : LONGINT;
                             B         : LONGINT;
                             C         : LONGINT      ) : REAL;

[PARAMETERS]

A           1st Polynomial Position Value
B           2nd Polynomial Position Value
C           3rd Polynomial Position Value

[RETURNS]

Negative Quadratic Solution in Terms of X

[DESCRIPTION]

Computes the Quadratic of y = Ax^2 + Bx + C in terms of X with
only the Negative Answer returned.

[SEE-ALSO]

QuadraticPlus

[EXAMPLE]

VAR
  X : REAL;

BEGIN

  X := QuadraticNeg( 2, 8, 4 );  { X = -3.4142}

END;

-*)

Function QuadraticNeg(       A         : LONGINT;
                             B         : LONGINT;
                             C         : LONGINT      ) : REAL;

Var

  X : REAL;

BEGIN

  X := Sqr(B) - (4 * A * C);

  If (X < 0) Then
    QuadraticNeg := 0
  Else
    QuadraticNeg := (-B - Sqrt(X)) / (2 * A);

END;  { QuadraticNeg }


{}

(*-

[FUNCTION]

Function Factorial(           N         : BYTE         ) : REAL;


[PARAMETERS]

N           Natural Number to Factor

[RETURNS]

Factorial Product

[DESCRIPTION]

Returns the Factorial Product of a Number.  N=33 is the Maximum
for real type answers.

[SEE-ALSO]

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := Factorial(   2 );  { Answer =         2.0000 }
  Answer := Factorial(   4 );  { Answer =        24.0000 }
  Answer := Factorial(   6 );  { Answer =       720.0000 }
  Answer := Factorial(  12 );  { Answer = 479001600.0000 }
  Answer := Factorial(  36 );  { Answer =         1.0000 }
  Answer := Factorial( 100 );  { Answer =         1.0000 }

END;

-*)

Function Factorial(           N         : BYTE         ) : REAL;

Var

  Result : REAL;
  Loop   : BYTE;

BEGIN

  If (N = 0) Then
    Factorial := 1
  Else
  BEGIN

    Result := N;
    For Loop := (N - 1) DownTo 2 Do
      Result := Result * Loop;

    Factorial := Result;

  END;

END;  { Factorial }


{}

(*-

[FUNCTION]

Function Permu(              N         : BYTE;
                             R         : BYTE         ) : REAL;

[PARAMETERS]

N           Number of Objects to Use
R           Use R at a Time (for each Permutation)

[RETURNS]

Permutation Product

[DESCRIPTION]

Returns the number of permutations of "N" Objects taken "R"
at a time, which means a listing or an arrangement of R of
the Objects in a definite order, where R <= N.  The number
of such arrangements is denoted by P(n,r).

[SEE-ALSO]

Combo

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := Permu( 12, 2 );  { Answer =   134 }
  Answer := Permu( 12, 3 );  { Answer =  1340 }
  Answer := Permu( 12, 4 );  { Answer = 11880 }
  Answer := Permu( 12, 5 );  { Answer = 95040 }

END;

-*)

Function Permu(              N         : BYTE;
                             R         : BYTE         ) : REAL;

BEGIN

  Permu := Factorial(N) / Factorial(N - R);

END;  { Permu }


{}

(*-

[FUNCTION]

Function Combo(              N         : BYTE;
                             R         : BYTE         ) : REAL;

[PARAMETERS]

N           Number of Objects to Use
R           Use R at a Time (for each combination)

[RETURNS]

Combination Product

[DESCRIPTION]

Returns the selection or subset of "R" Objects from a set of
"N" Objects, where R <= N.  The number of such combinations
is denoted C(n,r).

[SEE-ALSO]

Permu

[EXAMPLE]

VAR
  Answer : REAL;

BEGIN

  Answer := Combo( 12, 2 );  { Answer =  66 }
  Answer := Combo( 12, 3 );  { Answer = 220 }
  Answer := Combo( 12, 4 );  { Answer = 495 }
  Answer := Combo( 12, 5 );  { Answer = 792 }


END;

-*)

Function Combo(              N         : BYTE;
                             R         : BYTE         ) : REAL;

BEGIN

  Combo := Factorial(N) / ( Factorial(R) * Factorial(N - R) );

END;  { Combo }


{}

(*-

[FUNCTION]

Function Prime(              N         : LONGINT      ) : BOOLEAN;

[PARAMETERS]

N           Number to Check that it is a Prime Number

[RETURNS]

Whether or not this Number was a Prime Nmuber

[DESCRIPTION]

Determines if this number was a Prime Number and returns the result.

[SEE-ALSO]

[EXAMPLE]

BEGIN

  WriteLn( 'Prime( 3)=',Prime( 3) );  { TRUE  }
  WriteLn( 'Prime( 6)=',Prime( 6) );  { FALSE }
  WriteLn( 'Prime(15)=',Prime(15) );  { FALSE }
  WriteLn( 'Prime(23)=',Prime(23) );  { TRUE  }

END;

-*)

Function Prime(              N         : LONGINT      ) : BOOLEAN;

Var

  C : LONGINT;
  S : REAL;
  X : BOOLEAN;

BEGIN

  N := Abs(N);
  S := Sqrt(N);

  X := ( (N <= 2) OR ( Odd(N) ) AND (S <> Int(S) ) );

  If X Then
  BEGIN

    C := 3;

    While (X AND (C < Int(S))) Do
    BEGIN

      X := ((N MOD C) > 0);
      Inc(C, 2);

    END;  { While X }

  END;  { If X }

  Prime := X;

END; { Prime }

{}

(*-

[FUNCTION]

Function GCF(                A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

[PARAMETERS]

A           1st Source Number
B           2nd Source Number

[RETURNS]

The Greatest Common Factor of the two numbers.

[DESCRIPTION]

Determines the Greatest Common Factor between the two given
numbers.

[SEE-ALSO]

LCM

[EXAMPLE]

VAR
  Answer : LONGINT;

BEGIN

  Answer := GCF( 6, 9 );

  { Answer := 3 }

END;

-*)

Function GCF(                A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

Var

  X    : LONGINT;
  High : LONGINT;

BEGIN

  High := 1;

  For X := 2 to A Do
    If (A MOD X = 0) AND
       (B MOD X = 0) Then
      High := X;

  GCF := High;

END; { GCF }

{}

(*-

[FUNCTION]

Function LCM(                A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

[PARAMETERS]

A           1st Source Number
B           2nd Source Number

[RETURNS]

The Least Common Multiple of the two numbers.

[DESCRIPTION]

Determines the Least Common Multiple between the two given
Numbers.

[SEE-ALSO]

GCF

[EXAMPLE]

VAR
  Answer : LONGINT;

BEGIN

  Answer := LCM( 36, 54 );

  { Answer = 108 }

END;

-*)

Function LCM(                A         : LONGINT;
                             B         : LONGINT      ) : LONGINT;

Var

  Incre : LONGINT;
  Low   : LONGINT;
  High  : LONGINT;

BEGIN

  If (A > B) Then
  BEGIN

    High := A;
    Low := B;

  END
  Else
  BEGIN

    High := B;
    Low := A;

  END;

  Incre := High;

  While (High MOD Low <> 0) Do
    High := High + Incre;

  LCM := High;

END; { LCM }

{}

(*-

[FUNCTION]

Procedure LoadArrayR( VAR Arr : PArrayR;
                          Idx : WORD;
                          R   : REAL  );

[PARAMETERS]

Arr         Pointer to Linear Data Array
Idx         Number of Elements in the Data Array
R           Value to set Element to

[RETURNS]

(Function : None)
(VAR      : Pointer to Linear Data Array w/ Data Modified)

[DESCRIPTION]

Loads the Data Array's Indexed Element to the Provided Value
Use this Procedure to quickly Load the Data Array Values for the
Coordinate Record at a specific Index.

[SEE-ALSO]

LoadArrayRXY

[EXAMPLE]

VAR
  Arr : PArrayR;

BEGIN

  LoadArrayR( Arr, 3, 97.5 );

  { Element in "Arr" at Index 3 now equals 97.5 }

END;

-*)

Procedure LoadArrayR( VAR Arr : PArrayR;
                          Idx : WORD;
                          R   : REAL  );
BEGIN

  Arr^[Idx] := R;

END;  { LoadArrayR }

{}

(*-

[FUNCTION]

Procedure LoadArrayRXY( VAR Arr : PArray2R;
                            Idx : WORD;
                            X   : REAL;
                            Y   : REAL  );

[PARAMETERS]

Arr         Pointer to Linear Data Array or Coordinates
Idx         Number of Elements in the Data Array
X           Value to Set X-Element To
Y           Value to Set Y-Element To

[RETURNS]

(Function : None)
(VAR      : Pointer to Linear Data Array w/ Data Modified)

[DESCRIPTION]

Loads the Data Array's Indexed Elements (X & Y) to the Provided Values.
Use this Procedure to quickly Load the Data Array Values for the
Coordinate Record at a specific Index.

[SEE-ALSO]

LoadArrayR

[EXAMPLE]

VAR
  Arr : PArray2R;

BEGIN

  LoadArrayRXY( Arr, 5, 2.5, 3.7 );

  { Record in "Arr" at Index now contains X=2.5 and Y=3.7 }

END;

-*)

Procedure LoadArrayRXY( VAR Arr : PArray2R;
                            Idx : WORD;
                            X   : REAL;
                            Y   : REAL  );
BEGIN

  Arr^[Idx].X := X;
  Arr^[Idx].Y := Y;

END;  { LoadArrayRXY }

{}

(*-

[FUNCTION]

Procedure MeanStdDev( Arr    : PArrayR;  { Data Array }
                      Cnt    : INTEGER;  { Data Count }
                  VAR Mean   : REAL;     { Mean }
                  VAR StdDev : REAL );   { Standard Deviation }

[PARAMETERS]

Arr         Pointer to Linear Data Array
Cnt         Number of Elements in Linear Data Array
Mean        VAR Returned Mean Value of Dispursion
StdDev      VAR Returned Standard Deviation of Dispursion

[RETURNS]

(Function : None)
(VAR      : [Mean] Returned Mean Value of Dispursion)
(VAR      : [StdDev] Returned Standard Deviation of Dispursion)

[DESCRIPTION]

Takes a List of Values and determines what the Mean [Middle] Dispersion
Value is and what the Dispursion Deviation is.

[SEE-ALSO]

[EXAMPLE]

VAR
  Arr    : PArrayR;
  Mean,
  StdDev : REAL;

BEGIN
  LoadArray( Arr, 1, 1 );
  LoadArray( Arr, 2, 2 );
  LoadArray( Arr, 3, 3 );
  LoadArray( Arr, 4, 4 );
  LoadArray( Arr, 5, 5 );

  MeanStdDev( Arr, 5, Mean, StdDev );

  { Mean = 3.000,  StdDev = 1.5811 }

END.

-*)

Procedure MeanStdDev( Arr    : PArrayR;  { Data Array }
                      Cnt    : INTEGER;  { Data Count }
                  VAR Mean   : REAL;     { Mean }
                  VAR StdDev : REAL );   { Standard Deviation }
VAR
  I     : INTEGER;
  SumX,
  SumSq : REAL;

BEGIN
  SumX  := 0.0;
  SumSq := 0.0;

  For i := 1 to Cnt Do
  BEGIN
    SumX  := SumX  + Arr^[i];
    SumSq := SumSq + Arr^[i] * Arr^[i];
  END;  { For i }

  Mean   := SumX / Cnt;
  StdDev := Sqrt( (SumSq - Sqr(SumX) / Cnt) / (Cnt-1) );

END;  { MeanStdDev }


{}

(*-

[FUNCTION]

Function Sigma( Arr : PArrayR;
                Cnt : INTEGER ) : REAL;

[PARAMETERS]

Arr         Pointer to Linear Data Array
Cnt         Number of Elements in Data Array

[RETURNS]

The Sigma Summation of the Data Values

[DESCRIPTION]

Calculates the Sigma Summation of the Data Provided.

[SEE-ALSO]

[EXAMPLE]

-*)

Function Sigma( Arr : PArrayR;
                Cnt : INTEGER ) : REAL;
VAR
  Sum : REAL;
  I   : INTEGER;
BEGIN
  Sum := 0.0;
  For I := 1 to Cnt Do
    Sum := Sum + Arr^[i];
  Sigma := Sum;
END;  { Sigma }

{}

(*-

[FUNCTION]

Procedure LeastSqr( Arr   : PArray2R; { Data Array }
                    Cnt   : INTEGER;  { Data Count }
                VAR YInt  : REAL;     { Y-Intercept }
                VAR Slope : REAL );   { Slope }

[PARAMETERS]

Arr         Pointer to Linear Array of Point Coordinate Data
Cnt         Number of Coordinates in Array
YInt        VAR Returned Y-Intercept Solution
Slope       VAR Returned Line Slope Solution

[RETURNS]

(Function : None)
(VAR      : [YInt] Returned Y-Intercept Solution)
(VAR      : [Slope] Returned Line Slope Solution)

[DESCRIPTION]

Does a Least Squares Line Fitting Algorithm on the Point Data
and determines the Line Solution's Y-Intercept and Slope (expressed
as a Tangent Value - ArcTan returns Angle).

To Construct resulting Line use the Algorithm

              y = Slope * x + YInt;

[SEE-ALSO]

(None)

[EXAMPLES]

VAR
  Arr   : PArray2RA;
  YInt,
  Slope : REAL;

BEGIN

  LoadArrayRXY( Arr, 1, 1, 2 );
  LoadArrayRXY( Arr, 2, 2, 3 );
  LoadArrayRXY( Arr, 3, 3, 4 );
  LoadArrayRXY( Arr, 4, 4, 5 );
  LoadArrayRXY( Arr, 5, 5, 6 );
  LoadArrayRXY( Arr, 6, 6, 7 );

  LeastSqr( Arr, 6, YInt, Slope );

  { YInt = 1.0, Slope = 1.0[Tan] (45deg) }

END;

-*)

Procedure LeastSqr( Arr   : PArray2R; { Data Array }
                    Cnt   : INTEGER;  { Data Count }
                VAR YInt  : REAL;     { Y-Intercept }
                VAR Slope : REAL );   { Slope }
VAR
{  Tmp         : PArrayR; }
  i           : INTEGER;
  SumX,SumY,
  SumXY,X,Y,
  SumX2,SumY2,
  SXX,SXY,SYY : REAL;

BEGIN
  YInt  := 0.0;
  Slope := 0.0;

  SumX  := 0.0;
  SumY  := 0.0;
  SumXY := 0.0;
  SumX2 := 0.0;
  SumY2 := 0.0;

  For i := 1 to Cnt Do  { Sigma Summation }
  BEGIN
    X := Arr^[i].X;
    Y := Arr^[i].Y;
    SumX  := SumX  + X;
    SumY  := SumY  + Y;
    SumXY := SumXY + X*Y;
    SumX2 := SumX2 + X*X;
    SumY2 := SumY2 + Y*Y;
  END;  { For i }

  SXX := SumX2 - SumX * SumX / Cnt;
  SXY := SumXY - SumX * SumY / Cnt;
  SYY := SumY2 - SumY * SumY / Cnt;

  Slope := SXY / SXX;
  YInt  := ( (SumX2 * SumY - SumX * SumXY) / Cnt) / SXX;

  {--------------------------------------}
  { Calculate Sample Line                }
  {--------------------------------------}
  { For i := 1 to Cnt Do                 }
  {   Line[i] := YInt + Slope * Arr^[i]; }
  {--------------------------------------}

END;  { LeastSqr }

{}

(*-

[FUNCTION]

Function  Integrate(         A         : REAL;
                             B         : REAL;
                             Func      : PXFunc;
                             N         : WORD;
                             MaxErr    : REAL         ) : REAL;

[PARAMETERS]

A               Left/Lower limit of interval.
B               Right/Upper limit of interval.
Func            Function to call for evaluation of f(x).
N               Number of subintervals to evaluate.
MaxErr          Maximum error tolerance in answer.

[RETURNS]

REAL            Definite integral of f(x).

[DESCRIPTION]

This approximation technique of evaluating an antiderivative is useful
when the antiderivative is not an elementary function (and the Fundamental
Theorem of Calculus can not be applied).

Letting f be continuous on [a, b].  Simpson's Rule for approximating
the definite integral f(x)dx is given by:

   b-a
   --- * [f(X0) + 4f(X1) + 2f(X2) + 4f(X3) + ... + 4f(Xn-1) + f(Xn)]
   3n

Moreover, as n -> , the approximation approaches the indefinate integral.

If f has a continuous fourth derivative on [a, b], then the error E in
approximating the definite integral f(x)dx by Simpson's Rule is:

   E <= ( (b - a)^5 / 180n^4 ) * ( max f''''(x) ), a <= x <= b

[SEE-ALSO]

[EXAMPLES]

Function FuncX(X : REAL) : REAL; Far;
BEGIN

  FuncX := 4 / (1 + Sqr(X));

END;

Var

  Answer : REAL;

BEGIN

  Answer := Integrate( 0, 1, @FuncX, 6, cTolerance );
  WriteLn( Answer:12:12 );

  { Answer = 3.14159265360 }

END.

-*)

Function  Integrate(         A         : REAL;
                             B         : REAL;
                             Func      : PXFunc;
                             N         : WORD;
                             MaxErr    : REAL         ) : REAL;

Var

  FX  : FXFunc;

  {}
  { The following two functions are free, and not sold in VDL, but instead }
  { distributed with VDL.                                                  }
  {}

  Procedure Trapezoidal(     A         : REAL;
                             B         : REAL;
                         Var Integ     : REAL;
                             N         : INTEGER );

  Var

    J      : INTEGER;
    X      : REAL;
    Sum    : REAL;
    DeltaX : REAL;
    RIter  : REAL;
    WIter  : WORD;

  BEGIN

    WIter := 1 SHL (N-2);
    RIter := WIter;

    If (N = 1) Then

      {------------------------}
      { area of end trapezoids }
      {------------------------}

      Integ := (B - A) / 2 * (FX(A) + FX(B))

    Else
    BEGIN

      {----------------------}
      { area + Nth trapezoid }
      {----------------------}

      DeltaX := (B - A) / RIter;
      X      := (DeltaX / 2) + A;
      Sum    := 0.0;

      For J := 1 to WIter Do
      BEGIN

        Sum := Sum + FX(X);
        X   := X + DeltaX;

      END;

      Integ := (Integ + (B - A) * Sum / RIter) / 2;

    END;

  END;

  {}

  Procedure Simpson(         A         : REAL;
                             B         : REAL;
                         Var Integ     : REAL    );

  Label Done;

  Var

    L1        : WORD;
    Trapz     : REAL;
    SaveTrapz : REAL;
    SaveInteg : REAL;

  BEGIN

    SaveTrapz := MaxErr;
    SaveInteg := MaxErr;

    For L1 := 1 to N Do
    BEGIN

      Trapezoidal(A, B, Trapz, L1);
      Integ := (4.0 * Trapz - SaveTrapz) / 3.0;

      If ( Abs(Integ - SaveInteg) < MaxErr * Abs(SaveInteg) ) Then
        Goto Done;

      SaveInteg := Integ;
      SaveTrapz := Trapz;

    END;

    Done:

  END;

  {}

Var

  Answer : REAL;

BEGIN

   FX := FXFunc( Func );
   Simpson( A, B, Answer );
   Integrate := Answer;

END;

{}
{}
{}

BEGIN
END.
