{
 

 Visionix Memory Management Unit (VMEM)
   Version 0.5
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 jrt       12/28/93  Added documentation

 jrt       11/01/93  Uncommented VMemZero stuff.

 mep       02/11/93  Cleaned up code for beta release

 jrt       02/08/93  Sync with beta 0.12 release

 jrt       12/07/92  Sync with beta 0.11 release

 jrt       11/21/92  Sync with beta 0.08

 jrt       08/01/92  First logged revision.

 
}

(*-

[TEXT]

<Overview>

The VMemu unit implements 4 simple, cross-platform memory allocation
functions.  This unit has been rewritten to include support for
both Windows and OS/2 GlobalAlloc/GlobalLock/GlobalFree functions.

This unit will be replaced with the new unit in the next BETA release.

-*)

Unit VMemu;

Interface

Uses

  VTypesu;

{}

Const

  allocZERO      = $01;

Type

  TMemHeader = RECORD

    Locks    : LONGINT;
    Size     : LONGINT;
    Ptr      : Pointer;

  END;

  PMemHeader = ^TMemHeader;

{}


Function  VMemAlloc(              Flags          : WORD;
                                  Size           : LONGINT         ):THandle;


Function  VMemLock(               MemHandle      : THandle         ):Pointer;


Procedure VMemUnlock(             MemHandle      : THandle         );


Procedure VMemFree(               MemHandle      : THandle         );


{}

Implementation

{}

Procedure VMemZero( Mem : Pointer; Size : WORD );

Var

  TheSeg  : WORD;
  TheOfs  : WORD;
  TheSize : WORD;

BEGIN

  TheSeg  := Seg( Mem^ );
  TheOfs  := Ofs( Mem^ );
  TheSize := Size;

  ASM

    MOV ES, TheSeg
    MOV DI, TheOfs

    MOV AX,0
    MOV CX,TheSize

    CLD
    REPZ STOSB

  END;

END;

{}

(*-

[FUNCTION]

Function  VMemAlloc(              Flags          : WORD;
                                  Size           : LONGINT         ):THandle;


[PARAMETERS]

Flags       Allocation control flags
                allocZERO zero out allocated memory.

Size        Size of the memory block to allocate, in bytes.

[RETURNS]

0/NIL if an error,
otherwise a valid Memory Handle,

[DESCRIPTION]

This function allocates a memory block and returns the handle of the
memory block.  If the block could not be allocated, or an error
occurred, this function will return a 0/nil.

-*)


Function  VMemAlloc(              Flags          : WORD;
                                  Size           : LONGINT         ):THandle;

Var

  NMH : PMemHeader;

BEGIN

  If Size + 1024 > MaxAvail Then
  BEGIN

    VMemAlloc := NIL;

  END
  ELSE
  BEGIN

    New( NMH );

    NMH^.Locks := 0;
    NMH^.Size  := Size;

    GetMem( NMH^.Ptr, Word( Size ) );

    If Flags and allocZERO >0 Then
      VMemZero( NMH, Word( Size ) );

    VMemAlloc := NMH;

  END;

END;

{}

(*-

[FUNCTION]

Function  VMemLock(               MemHandle      : THandle         ):Pointer;

[PARAMETERS]

memhandle   memory handle obtained from a previous call to VMemAlloc

[RETURNS]

0/NIL if an error,
otherwise a pointer the locked memory block.

[DESCRIPTION]

This function locks down the memory block associated with "Memhandle"
and returns a pointer to the memory block.

-*)


Function  VMemLock(               MemHandle      : THandle         ):Pointer;

BEGIN

  If MemHandle<>NIL Then
  BEGIN

    Inc( PMemHeader( MemHandle )^.Locks );

    VMemLock := PMemHeader( MemHandle )^.Ptr;

  END
  ELSE
  BEGIN

    VMemLock := NIL;

  END;

END;

{}

(*-

[FUNCTION]

Procedure VMemUnlock(             MemHandle      : THandle         );

[PARAMETERS]

memhandle   memory handle obtained from a previous call to VMemAlloc

[RETURNS]

nothing

[DESCRIPTION]

This function unlocks the memory block associated with "Memhandle".

-*)



Procedure VMemUnlock(             MemHandle      : THandle         );

BEGIN

  Dec( PMemHeader( MemHandle )^.Locks );

END;

{}

(*-

[FUNCTION]

Procedure VMemFree(               MemHandle      : THandle         );

[PARAMETERS]

memhandle   memory handle obtained from a previous call to VMemAlloc

[RETURNS]

nothing

[DESCRIPTION]

This function frees the memory block associated with "Memhandle".

-*)



Procedure VMemFree(               MemHandle      : THandle         );

  { VMemFree frees a memory handle and the memory associated with  }
  { it.                                                            }
  {                                                                }
  { MemHandle           Previously allocated memory handle.        }

BEGIN

  { What to do is locks <> 0 ??? }

  If MemHandle<>NIL Then
  BEGIN

    FreeMem( PMemHeader( MemHandle )^.Ptr,
             PMemHeader( MemHandle )^.Size  );

    Dispose( PMemHeader( MemHandle ) );

  END;

END;

{}
{}
{}

BEGIN

END.
