Unit VMouI;

Interface

Const

  { MouRegister constants }

  MR_MOUGETNUMBUTTONS     = $00000001;
  MR_MOUGETNUMMICKEYS     = $00000002;
  MR_MOUGETDEVSTATUS      = $00000004;
  MR_MOUGETNUMQUEEL       = $00000008;
  MR_MOUREADEVENTQUE      = $00000010;
  MR_MOUGETSCALEFACT      = $00000020;
  MR_MOUGETEVENTMASK      = $00000040;
  MR_MOUSETSCALEFACT      = $00000080;
  MR_MOUSETEVENTMASK      = $00000100;
  MR_MOUOPEN              = $00000800;
  MR_MOUCLOSE             = $00001000;
  MR_MOUGETPTRSHAPE       = $00002000;
  MR_MOUSETPTRSHAPE       = $00004000;
  MR_MOUDRAWPTR           = $00008000;
  MR_MOUREMOVEPTR         = $00010000;
  MR_MOUGETPTRPOS         = $00020000;
  MR_MOUSETPTRPOS         = $00040000;
  MR_MOUINITREAL          = $00080000;
  MR_MOUSETDEVSTATUS      = $00100000;

  { mouse button constants }

  MHK_BUTTON1             = $0001;
  MHK_BUTTON2             = $0002;
  MHK_BUTTON3             = $0004;

  { MouGet/SetDevStatus constants }

  MOUSE_QUEUEBUSY         = $0001;
  MOUSE_BLOCKREAD         = $0002;
  MOUSE_FLUSH             = $0004;
  MOUSE_UNSUPPORTED_MODE  = $0008;
  MOUSE_DISABLED          = $0100;
  MOUSE_MICKEYS           = $0200;

  { MouReadEventQue constants }

  MOU_NOWAIT              = $0000;
  MOU_WAIT                = $0001;

  { Mouse que event types }

  MOUSE_MOTION                = $0001;
  MOUSE_MOTION_WITH_BN1_DOWN  = $0002;
  MOUSE_BN1_DOWN              = $0004;
  MOUSE_MOTION_WITH_BN2_DOWN  = $0008;
  MOUSE_BN2_DOWN              = $0010;
  MOUSE_MOTION_WITH_BN3_DOWN  = $0020;
  MOUSE_BN3_DOWN              = $0040;

  { MouSetDevStatus constants }

  MOU_NODRAW      = $0001;
  MOU_DRAW        = $0000;
  MOU_MICKEYS     = $0002;
  MOU_PELS        = $0000;







Type

  PWORD = ^WORD;

  TMH = WORD;

  TMouQueInfo = RECORD

    Events     : WORD;
    MaxEvents  : WORD;

  END;

  PMouQueInfo = ^TMouQueInfo;


  TPtrLoc = RECORD

    Row    : WORD;
    Col    : WORD;

  END;

  PPtrLoc = ^TPtrLoc;


  TPtrShape = RECORD

    CB     : WORD;
    Col    : WORD;
    Row    : WORD;
    HotCol : WORD;
    HotRow : WORD;

  END;

  PPtrShape = ^TPtrShape;


  TScaleFact = RECORD

    RowScale : WORD;
    ColScale : WORD;

  END;

  PScaleFact = ^TScaleFact;


  TMouEventInfo = RECORD

    FS     : WORD;
    Time   : LONGINT;
    Row    : WORD;
    Col    : WORD;

  END;

  PMouEventInfo = ^TMouEventInfo;

  TNoPtrRect = RECORD

    TopRow       : WORD;
    TopCol       : WORD;
    BottomRow    : WORD;
    BottomCol    : WORD;

  END;

  PNoPtrRect = ^TNoPtrRect;


  TThreshold = RECORD

    Length       : WORD;
    Level1       : WORD;
    Level1Mult   : WORD;
    Level2       : WORD;
    Level2Mult   : WORD;

  END;

  PThreshold = ^TThreshold;

Function  MouClose(               MouHandle      : TMH          ) : WORD;

Function  MouDeRegister                                           : WORD;

Function  MouDrawPtr(             MouHandle      : TMH          ) : WORD;

Function  MouFlushQue(            MouHandle      : TMH          ) : WORD;

Function  MouGetDevStatus(    Var Status         : WORD;
                                  MouHandle      : TMH          ) : WORD;

Function  MouGetEventMask(    Var EventMask      : WORD;
                                  MouHandle      : TMH          ) : WORD;

Function  MouGetNumButtons(   Var NumButtons     : WORD;
                                  MouHandle      : TMH          ) : WORD;

Function  MouGetNumMickeys(   Var Mickeys        : WORD;
                                  MouHandle      : TMH          ) : WORD;


Function  MouGetNumQueEl(         MouQueInfo     : PMouQueInfo;
                                  MouHandle      : TMH          ) : WORD;


Function  MouGetPtrPos(           PtrLoc         : PPtrLoc;
                                  MouHandle      : TMH          ) : WORD;


Function  MouGetPtrShape(         Buff           : POINTER;
                                  PtrShape       : PPtrShape;
                                  MouHandle      : TMH          ) : WORD;



Function  MouGetScaleFact(        ScaleFact      : PScaleFact;
                                  MouHandle      : TMH          ) : WORD;


Function  MouGetThreshold(        Threshold      : PThreshold;
                                  MouHandle      : TMH          ) : WORD;

Function  MouInitReal(            DriverName     : PCHAR        ) : WORD;


Function  MouOpen(                DriverName     : PCHAR;
                              Var MouHandle      : TMH          ) : WORD;


Function  MouReadEventQue(        MouseEvent     : PMouEventInfo;
                              Var WaitFlag       : WORD;
                                  MouHandle      : TMH          ) : WORD;

Function  MouRegister(            ModuleName     : PCHAR;
                                  EntryName      : WORD;
                                  FuncFlags      : LONGINT      ) : WORD;

Function  MouRemovePtr(           NoPtrRect      : PNoPtrRect;
                                  MouHandle      : TMH          ) : WORD;

Function  MouSetDevStatus(        Status         : PWORD;
                                  MouHandle      : TMH          ) : WORD;

Function  MouSetEventMask(        Events         : PWORD;
                                  MouHandle      : TMH          ) : WORD;


Function  MouSetPtrPos(           PtrLoc         : PPtrLoc;
                                  MouHandle      : TMH          ) : WORD;



Function  MouSetPtrShape(         Buff           : POINTER;
                                  PtrShape       : PPtrShape;
                                  MouHandle      : TMH          ) : WORD;


Function  MouSetScaleFact(        ScaleFact      : PScaleFact;
                                  MouHandle      : TMH          ) : WORD;

Function  MouSetThreshold(        Threshold      : PThreshold;
                                  MouHandle      : TMH          ) : WORD;

Function  MouSync(                Waitflag       : WORD         ) : WORD;




Implementation

Function  MouClose(               MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 9;



Function  MouDeRegister                                           : WORD;

  External 'MOUCALLS' Index 14;




Function  MouDrawPtr(             MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 26;




Function  MouFlushQue(            MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 7;




Function  MouGetDevStatus(    Var Status         : WORD;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 22;




Function  MouGetEventMask(    Var EventMask      : WORD;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 15;




Function  MouGetNumButtons(   Var NumButtons     : WORD;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 8;




Function  MouGetNumMickeys(   Var Mickeys        : WORD;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 3;




Function  MouGetNumQueEl(         MouQueInfo     : PMouQueInfo;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 13;





Function  MouGetPtrPos(           PtrLoc         : PPtrLoc;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 19;





Function  MouGetPtrShape(         Buff           : POINTER;
                                  PtrShape       : PPtrShape;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 1;






Function  MouGetScaleFact(        ScaleFact      : PScaleFact;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 6;


Function  MouGetThreshold(        Threshold      : PThreshold;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 29;



Function  MouInitReal(            DriverName     : PCHAR        ) : WORD;

  External 'MOUCALLS' Index 27;





Function  MouOpen(                DriverName     : PCHAR;
                              Var MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 17;





Function  MouReadEventQue(        MouseEvent     : PMouEventInfo;
                              Var WaitFlag       : WORD;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 20;




Function  MouRegister(            ModuleName     : PCHAR;
                                  EntryName      : WORD;
                                  FuncFlags      : LONGINT      ) : WORD;

  External 'MOUCALLS' Index 24;




Function  MouRemovePtr(           NoPtrRect      : PNoPtrRect;
                                  MouHandle      : TMH          ) : WORD;


  External 'MOUCALLS' Index 18;



Function  MouSetDevStatus(        Status         : PWORD;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 25;




Function  MouSetEventMask(        Events         : PWORD;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 16;





Function  MouSetPtrPos(           PtrLoc         : PPtrLoc;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 21;





Function  MouSetPtrShape(         Buff           : POINTER;
                                  PtrShape       : PPtrShape;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 2;





Function  MouSetScaleFact(        ScaleFact      : PScaleFact;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 11;




Function  MouSetThreshold(        Threshold      : PThreshold;
                                  MouHandle      : TMH          ) : WORD;

  External 'MOUCALLS' Index 30;


Function  MouSync(                Waitflag       : WORD         ) : WORD;

  External 'MOUCALLS' Index 23;








BEGIN


END.