{
 

 Visionix Microsoft CD-ROM Extensions Unit (VMSCDEX)
   Version 0.6
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 jrt       09/20/93  Changed TMSF to TFSM.  Added TFSMBackwards to fix
                     ReadQChanInfo.  Got rid of BCD conversion call in
                     GetAudioTrackInfo.

 lpg       03/16/93  Added Source Documentation

 mep       02/11/93  Cleaned up code (yuck!) for beta release

 jrt       02/08/93  Sync with beta 0.12 release

 jrt       12/07/92  Sync with beta 0.11 release

 jrt       11/21/92  Sync with beta 0.08

 jrt       11/18/92  First logged revision.

 
}

(*-

[TEXT]

<Overview>

This unit implements MSCDEX dependent functions to control and play
CD-ROM and CD-Audio discs.

For more information, see the MSCDEX documentation.

This overview will be enhanced for the next BETA release.

<Interface>

-*)

Unit VMSCDEXu;

Interface

Uses

  VTypesu,
  VGenu,
  DOS;

{}


Type

  TError = WORD;


Type

  TFSM = RECORD

    F : BYTE;
    S : BYTE;
    M : BYTE;

    P : BYTE;

  END;

  PFSM = ^TFSM;

  TFSMBackwards = RECORD

    M : BYTE;
    S : BYTE;
    F : BYTE;

    P : BYTE;

  END;

  PFSMBackwards = ^TFSMBackwards;


Type

  TUPCCode = Array[1..7] of BYTE;

  PUPCCode = ^TUPCCode;



Type

  TmscdexReqHeader = RECORD

    HeaderSize     : BYTE;
    Subunit        : BYTE;
    CommandCode    : BYTE;
    Status         : WORD;
    Reserved       : Array[1..8] of BYTE;

  END;

  PmscdexReqHeader = ^TmscdexReqHeader;


{------------------------}
{ MSCDEX IOCTL Requests  }
{------------------------}


Type

  TmscdexIOCTLReq = RECORD

    Header           : TmscdexReqHeader;
    MediaDescript    : BYTE;
    ControlBlock     : POINTER;
    ControlBlockSize : WORD;
    StartingSector   : WORD;
    RequestedVol     : POINTER;

  END;

  PmscdexIOCTLReq = ^TmscdexIOCTLReq;


  {--------------------------------}
  { IOCTL Read Control Block Types }
  {--------------------------------}

  Const

    cmscdexIOCTLread = 3;


  Type

    TmscdexGetDevAddr = RECORD

      ConBCode         : BYTE;
      DevAddr          : POINTER;

    END;

    PmscdexGetDevAddr = ^TmscdexGetDevAddr;



  Type

    TmscdexGetHeadPos = RECORD

      ConBCode        : BYTE;
      AddrMode        : BYTE;
      HeadPos         : LONGINT

    END;

    Const

      cmscdexGetHeadPos      = 1;
      cmscdexGetHeadPosCBS   = 5;


  Type

    TmscdexAudioChanInfo = RECORD

      ConBCode        : BYTE;
      InChan0         : BYTE;
      Volume0         : BYTE;
      InChan1         : BYTE;
      Volume1         : BYTE;
      InChan2         : BYTE;
      Volume2         : BYTE;
      InChan3         : BYTE;
      Volume3         : BYTE;

    END;

    PmscdexAudioChanInfo = ^TmscdexAudioChanInfo;

    Const

      cmscdexGetAudioChanInfo    = 4;
      cmscdexGetAudioChanInfoCBS = 9;


  Type

    TmscdexDevStatus = RECORD

      ConBCode        : BYTE;
      DevParams       : LONGINT;

    END;

    PmscdexDevStatus = ^TmscdexDevStatus;

    Const

      cmscdexGetDevStatus    = 6;
      cmscdexGetDevStatusCBS = 5;

    Const

      cmscdexDoorOpen      = 1;
      cmscdexDoorLocked    = 2;
      cmscdexCanRawRead    = 4;
      cmscdexReadWrite     = 8;
      cmscdexCanPlayAudio  = 16;
      cmscdexCanInterleave = 32;
      cmscdexCanPrefetch   = 64;
      cmscdexCanSetVolume  = 128;
      cmscdexCanRedbook    = 256;
      cmscdexNoDisc        = 1024;



  Type

    TmscdexGetSecSize = RECORD

      ConBCode        : BYTE;
      ReadMode        : BYTE;
      SectorSize      : WORD;

    END;

    PmscdexGetSecSize = ^TmscdexGetSecSize;

    Const

      cmscdexGetSecSize    = 7;
      cmscdexGetSecSizeCBS = 4;



  Type

    TmscdexGetVolumeSize = RECORD

      ConBCode        : BYTE;
      VolumeSize      : LONGINT;

    END;

    PmscdexGetVolumSize = ^TmscdexGetVolumeSize;

    Const

      cmscdexGetVolumeSize    = 8;
      cmscdexGetVolumeSizeCBS = 5;



  Type

    TmscdexCheckMediaChange = RECORD

      ConBCode        : BYTE;
      MediaStatus     : BYTE;

    END;

    PmscdexCheckmediaChange = ^TmscdexCheckMediaChange;

    Const

      cmscdexCheckMediaChange    = 9;
      cmscdexCheckMediaChangeCBS = 2;


    Const

      cmscdexMediaNotChanged   = $01;
      cmscdexMediaMaybeChanged = $00;
      cmscdexMeidaChanged      = $FF;



  Type

    TmscdexGetAudioDiskInfo = RECORD

      ConBCode        : BYTE;
      LowestTrack     : BYTE;
      HighestTrack    : BYTE;
      StartOfLeadout  : LONGINT;

    END;

    PmscdexGetAudioDiskInfo = ^TmscdexGetAudioDiskInfo;

    Const

      cmscdexGetAudioDiskInfo    = 10;
      cmscdexGetAudioDiskInfoCBS = 7;



  Type

    TmscdexGetAudioTrackInfo = RECORD

      ConBCode        : BYTE;
      TrackNum        : BYTE;
      StartPoint      : LONGINT;
      TrackConInfo    : BYTE;

    END;

    PmscdexGetAudioTrackInfo = ^TmscdexGetAudioTrackInfo;

    Const

      cmscdexGetAudioTrackInfo    = 11;
      cmscdexGetAudioTrackInfoCBS = 7;



  Type

    TmscdexGetAudioQChanInfo = RECORD

      ConBCode        : BYTE;
      ControlAndAddr  : BYTE;
      TrackNum        : BYTE;
      IndexNum        : BYTE;

      TrackTime       : TFSMBackwards;

      DiskTime        : TFSMBackwards;

    END;

    PmscdexGetAudioQChanInfo = ^TmscdexGetAudioQChanInfo;

    Const

      cmscdexGetAudioQChanInfo    = 12;
      cmscdexGetAudioQChanInfoCBS = 11;



  Type

    TmscdexGetAudioSubChanInfo = RECORD

      ConBCode        : BYTE;
      StartFrame      : LONGINT;
      TransferAddr    : POINTER;
      SecsToRead      : LONGINT;

    END;

    PmscdexGetAudioSubChanInfo = ^TmscdexGetAudioSubChanInfo;

    Const

      cmscdexGetAudioSubChanInfo    = 13;
      cmscdexGetAudioSubChanInfoCBS = 13;




  Type

    TmscdexGetUPCCode = RECORD

      ConBCode        : BYTE;
      ControlAndAdr   : BYTE;
      UPCCode         : TUPCCode;
      Zero            : BYTE;
      AFrame          : BYTE;

    END;

    PmscdexGetUPCCode = ^TmscdexGetUPCCode;

    Const

      cmscdexGetUPCCode    = 14;
      cmscdexGetUPCCodeCBS = 11;




  Type

    TmscdexGetAudioStatusInfo = RECORD

      ConBCode        : BYTE;
      AudioStatus     : WORD;
      PlayStart       : LONGINT;
      PlayEnd         : LONGINT;

    END;

    PmscdexGetAudioStatusInfo = ^TmscdexGetAudioStatusInfo;

    Const

      cmscdexGetAudioStatusInfo    = 15;
      cmscdexGetAudioStatusInfoCBS = 11;


  {---------------------------------}
  { IOCTL Write Control Block Types }
  {---------------------------------}

  Const

    cmscdexIOCTLWrite = 12;



  Type

    TmscdexEjectDisk = RECORD

      ConBCode        : BYTE;

    END;

    PmscdexEjectDisk = ^TmscdexEjectDisk;

    Const

      cmscdexEjectDisk    = 0;
      cmscdexEjectDiskCBS = 1;



  Type

    TmscdexLockUnlockDoor = RECORD

      ConBCode        : BYTE;
      LockCode        : BYTE;

    END;

    PmscdexLockUnlockDoor = ^TmscdexLockUnlockDoor;

    Const

      cmscdexLockUnlockDoor    = 1;
      cmscdexLockUnlockDoorCBS = 2;

    Const

      cmscdexLockDoor   = 1;
      cmscdexUnlockDoor = 0;



  Type

    TmscdexResetDrive = RECORD

      ConBCode        : BYTE;

    END;

    PmscdexResetDrive = ^TmscdexResetDrive;

    Const

      cmscdexResetDrive    = 2;
      cmscdexResetDriveCBS = 1;




  Type

    TmscdexAudioChanControl = RECORD

      ConBCode        : BYTE;
      InChan0         : BYTE;
      Volume0         : BYTE;
      InChan1         : BYTE;
      Volume1         : BYTE;
      InChan2         : BYTE;
      Volume2         : BYTE;
      InChan3         : BYTE;
      Volume3         : BYTE;

    END;

    PmscdexAudioChanControl = ^TmscdexAudioChanControl;

    Const

      cmscdexAudioChanControl    = 3;
      cmscdexAudioChanControlCBS = 9;





  Type

    TmscdexCloseTray = RECORD

      ConBCode        : BYTE;

    END;

    PmscdexCloseTray = ^TmscdexCloseTray;

    Const

      cmscdexCloseTray    = 5;
      cmscdexCloseTrayCBS = 1;





{--------------------------}
{ MSCDEX Read Long Request }
{--------------------------}


Type

  TmscdexReadLongReq = RECORD

    Header           : TmscdexReqHeader;
    AddrMode         : BYTE;
    TransferAddr     : POINTER;
    SecsToRead       : WORD;
    StartSec         : LONGINT;
    ReadMode         : BYTE;
    InterleaveSize   : BYTE;
    InterleaveSkip   : BYTE;

  END;

  PmscdexReadLongReq = ^TmscdexReadLongReq;

  Const

    cmscdexBlockMode     = 0;
    cmscdexHSGMode       = 0;

    cmscdexMSFMode       = 1;
    cmscdexRedBookMode   = 1;

    cmscdexCookedRead    = 0;
    cmscdexRawRead       = 1;



Type

  TmscdexPlayAudioReq = RECORD

    Header           : TmscdexReqHeader;
    AddrMode         : BYTE;
    Start            : LONGINT;
    PlayFor          : LONGINT;

  END;

  PmscdexPlayAudioReq = ^TmscdexPlayAudioReq;


Type

  TmscdexStopAudioReq = RECORD

    Header           : TmscdexReqHeader;
    
  END;

  PmscdexStopAudioReq = ^TmscdexStopAudioReq;



Type

  TmscdexResumeAudioReq = RECORD

    Header           : TmscdexReqHeader;
    
  END;

  PmscdexResumeAudioReq = ^TmscdexResumeAudioReq;




{}
{}

Procedure BCDFSMtoFSM( Var N : TFSM );


Function  MSCDEX_GetNumDrives : WORD;

Function  MSCDEX_GetFirstDrive : WORD;



Procedure MSCDEX_ExecRequest(          Drive          : BYTE;
                                       Request        : POINTER   );

{----------------------}
{ Read IOCTL Functions }
{----------------------}

Function  MSCDEX_GetHeadPos(           Drive          : BYTE;
                                       AddrMode       : BYTE;
                                   Var HeadPos        : LONGINT ) : TError;

Function  MSCDEX_GetAudioChanInfo(     Drive          : BYTE;
                                       Channel        : BYTE;
                                   Var InputChan      : BYTE;
                                   Var Volume         : BYTE    ) : TError;

Function  MSCDEX_GetDevStatus(         Drive          : BYTE;
                                   Var DevStatus      : LONGINT ) : TError;

{-}Function  MSCDEX_GetSectorSize(        Drive          : BYTE;
                                       ReadMode       : BYTE;
                                   Var SecSize        : WORD    ) : TError;

{-}Function  MSCDEX_GetVolumeSize(        Drive          : BYTE;
                                   Var VolumeSize     : LONGINT ) : TError;

{-}Function  MSCDEX_IsMediaChanged      ( Drive : BYTE )             : BYTE;

Function  MSCDEX_GetAudioDiskInfo(     Drive          : BYTE;
                                   Var StartTrack     : BYTE;
                                   Var EndTrack       : BYTE;
                                   Var LeadOutStart   : LONGINT ) : TError;

Function  MSCDEX_GetAudioTrackInfo(    Drive          : BYTE;
                                       TrackNum       : BYTE;
                                   Var StartPoint     : LONGINT;
                                   Var TrackConInfo   : BYTE    ) : TError;

Function  MSCDEX_GetAudioQChanInfo(    Drive          : BYTE;
                                   Var ConAddr        : BYTE;
                                   Var TrackNum       : BYTE;
                                   Var IndexNum       : BYTE;
                                   Var TrackTime      : TFSM;
                                   Var DiskTime       : TFSM    ) : TError;

{-}Function  MSCDEX_GetAudioSubChanInfo(  Drive          : BYTE;
                                       StartFrame     : LONGINT;
                                       SecsToRead     : LONGINT;
                                       TransferAddr   : POINTER ) : TError;

{-}Function  MSCDEX_GetUPCCode(           Drive          : BYTE;
                                   Var ConAddr        : BYTE;
                                   Var UPCCode        : TUPCCode;
                                   Var AFrame         : BYTE    ) : Terror;

Function  MSCDEX_GetAudioStatusInfo(   Drive          : BYTE;
                                   Var AudioStatus    : WORD;
                                   Var PlayStart      : LONGINT;
                                   Var PlayEnd        : LONGINT ) : TError;

{-----------------------}
{ IOCTL Write Functions }
{-----------------------}

{-}Function  MSCDEX_EjectDisk(            Drive          : BYTE    ) : TError;

{-}Function  MSCDEX_LockUnlockDoor(       Drive          : BYTE;
                                       Lock           : BOOLEAN ) : TError;

{-}Function  MSCDEX_ResetDrive(           Drive          : BYTE    ) : TError;

{-----------------------}
{ Audio Channel Control }
{-----------------------}

{-}Function  MSCDEX_CloseTray(            Drive          : BYTE    ) : TError;

{-}Function  MSCDEX_ReadLong(             Drive          : BYTE;
                                       AddrMode       : BYTE;
                                       TransferAddr   : POINTER;
                                       SecsToRead     : WORD;
                                       StartSec       : LONGINT;
                                       ReadMode       : BYTE;
                                       InterleaveSize : BYTE;
                                       InterleaveSkip : BYTE    ) : TError;

{----------------}
{ prefetch, seek }
{----------------}

Function  MSCDEX_PlayAudio(            Drive          : BYTE;
                                       AddrMode       : BYTE;
                                       Start          : LONGINT;
                                       Playfor        : LONGINT ) : TError;

Function  MSCDEX_StopAudio(            Drive          : BYTE    ) : TError;

Function  MSCDEX_ResumeAudio(          Drive          : BYTE    ) : TError;

{}

Implementation

{}

Procedure BCDFSMtoFSM( Var N : TFSM );

BEGIN

  N.M := BCDToDec( N.M );
  N.S := BCDToDec( N.S );
  N.F := BCDToDec( N.F );

END;  { BCDFSMtoFSM }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetNumDrives                                  : WORD;

[PARAMETERS]

(None)

[RETURNS]

Number of MSCDEX controlled CD-ROM drives in the system.

[DESCRIPTION]

This function obtains and returns a count of the number of MSCDEX
controlled CD-ROM drives in the system.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetNumDrives                                  : WORD;

Var

  R : REGISTERS;

BEGIN

  R.AH:=$15;
  R.AL:=$0;
  R.BX:=$0;

  Intr( $2F, R );


  MSCDEX_GetNumDrives := R.BX;

END;  { MSCDEX_GetNumDrives }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetFirstDrive                                 : WORD;

[PARAMETERS]

(None)

[RETURNS]

Value of the first MSCDEX drive (IE: 4 for d, 5 for e, etc)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetFirstDrive                                 : WORD;

Var

  R : REGISTERS;

BEGIN

  R.AH:=$15;
  R.AL:=$0;
  R.BX:=$0;

  Intr( $2F, R );


  MSCDEX_GetFirstDrive := R.CX;

END;  { MSCDEX_GetFirstDrive }

{}


(*-

[FUNCTION]

Procedure MSCDEX_ExecRequest(          Drive          : BYTE;
                                       Request        : POINTER   );

[PARAMETERS]

Drive       CD-ROM Drive Number
Request     Pointer to MSCDEX Request Packet

[RETURNS]

(None)

[DESCRIPTION]

This function executes an MSCDEX request packet.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure MSCDEX_ExecRequest(          Drive          : BYTE;
                                       Request        : POINTER   );

Var

  R : REGISTERS;

BEGIN

  R.AH := $15;
  R.AL := $10;
  R.CX := Drive;
  R.ES := Seg( Request^ );
  R.BX := Ofs( Request^ );

  Intr( $2F, R );

END;  { MSCDEX_ExecRequest }

{}

(*-

[FUNCTION]

Procedure MSCDEX_LoadIOR(              IOR            : PmscdexIOCTLReq;
                                       ReqHeadLength  : BYTE;
                                       CommandCode    : BYTE;
                                       MediaDescript  : BYTE;
                                       ControlBlock   : POINTER;
                                       CBS            : WORD             );

[PARAMETERS]

IOR           Pointer to MSCDEX IOCtl Request Packet
ReqHeadLength Request Header Length
CommandCode   Command code of the IOCTL request
MediaDescript Media description byte
ControlBlock  pointer to the command control block
CBS           size of the control block in bytes.

[RETURNS]

(None)

[DESCRIPTION]

This function is used to build a MSCDEX IOCTL request and the
associated structures.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure MSCDEX_LoadIOR(              IOR            : PmscdexIOCTLReq;
                                       ReqHeadLength  : BYTE;
                                       CommandCode    : BYTE;
                                       MediaDescript  : BYTE;
                                       ControlBlock   : POINTER;
                                       CBS            : WORD             );

BEGIN

  IOR^.Header.HeaderSize  := ReqHeadLength;
  IOR^.Header.CommandCode := CommandCode;
  IOR^.Header.Status      := 0;

  { zero reserved bytes }

  IOR^.MediaDescript      := MediaDescript;
  IOR^.ControlBlock       := ControlBlock;
  IOR^.ControlBlockSize   := CBS;
  IOR^.StartingSector     := 0;
  IOR^.RequestedVol       := NIL;

END;  { MSCDEX_LoadIOR }

{}

(*-

[FUNCTION]

Function MSCDEX_GetHeadPos(            Drive          : BYTE;
                                       AddrMode       : BYTE;
                                   Var HeadPos        : LONGINT ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number
AddrMode    logical block/msf addressing flag
HeadPos     VAR returned current head position in the specified addressing
            mode.

[RETURNS]

Function : 0 if successfull, otherwise a DOS error code.
(VAR     : [HeadPos]

[DESCRIPTION]

This function obtains and returns the current head position of the
specified "drive".  The position value is in the addressing mode
specified by "AddrMode".

[SEE-ALSO]

[EXAMPLE]

-*)

Function MSCDEX_GetHeadPos(            Drive          : BYTE;
                                       AddrMode       : BYTE;
                                   Var HeadPos        : LONGINT ) : TError;

Var

  IOR : TmscdexIOCTLReq;
  CB  : TmscdexGetHeadPos;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexGetHeadPosCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexGetHeadPos;
  CB.AddrMode := AddrMode;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  HeadPos               := CB.HeadPos;
  MSCDEX_GetHeadPos     := IOR.Header.Status;

END;  { MSCDEX_GetHeadPos }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetAudioChanInfo(     Drive          : BYTE;
                                       Channel        : BYTE;
                                   Var InputChan      : BYTE;
                                   Var Volume         : BYTE    ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number
Channel     ?
InputChan   VAR Returned ?
Volume      VAR Returned ?

[RETURNS]

Function : ?
(VAR     : [InputChan] ?)
(VAR     : [Volume] ?)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetAudioChanInfo(     Drive          : BYTE;
                                       Channel        : BYTE;
                                   Var InputChan      : BYTE;
                                   Var Volume         : BYTE    ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexAudioChanInfo;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexGetAudioChanInfoCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexGetAudioChanInfo;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  { pull out the junk }

  MSCDEX_GetAudioChanInfo := IOR.Header.Status;

END;  { MSCDEX_GetAudioChanInfo }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetDevStatus(         Drive          : BYTE;
                                   Var DevStatus      : LONGINT ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number
DevStatus   VAR Returned

[RETURNS]

0 if successfull, otherwise a DOS error code.

Devstatus         device status word (see MSCDEX documentation)

[DESCRIPTION]

This function obtains and returns the MSCDEX cd-rom status word
for the specified "drive".

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetDevStatus(         Drive          : BYTE;
                                   Var DevStatus      : LONGINT ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexDevStatus;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexGetDevStatusCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexGetDevStatus;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  DevStatus := CB.DevParams;

  MSCDEX_GetDevStatus := IOR.Header.Status;

END;  { MSCDEX_GetDevStatus }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetSectorSize(        Drive          : BYTE;
                                       ReadMode       : BYTE;
                                   Var SecSize        : WORD    ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number
ReadMode    ?
SecSize     VAR Returned Sector Size

[RETURNS]

Function : ?
(VAR     : [SecSize] Sector Size)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetSectorSize(        Drive          : BYTE;
                                       ReadMode       : BYTE;
                                   Var SecSize        : WORD    ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexGetSecSize;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexGetSecSizeCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexGetSecSize;
  CB.ReadMode := ReadMode;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  SecSize := CB.SectorSize;

  MSCDEX_GetSectorSize := IOR.Header.Status;

END;  { MSCDEX_GetSectorSize }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetVolumeSize(        Drive          : BYTE;
                                   Var VolumeSize     : LONGINT ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number
VolumeSize  VAR Returned ?

[RETURNS]

Function : ?
(VAR     : [VolumeSize] ?)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetVolumeSize(        Drive          : BYTE;
                                   Var VolumeSize     : LONGINT ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexGetVolumeSize;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexGetVolumeSizeCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexGetVolumeSize;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  VolumeSize := CB.VolumeSize;

  MSCDEX_GetVolumeSize := IOR.Header.Status;

END; { MSCDEX_GetVolumeSize }

{}

(*-

[FUNCTION]

Function  MSCDEX_IsMediaChanged(  Drive          : BYTE         ) : BYTE;

[PARAMETERS]

Drive       CD-ROM Drive Number

[RETURNS]

Whether the CD-ROM Media has been Changed (TRUE=Changed)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_IsMediaChanged(  Drive          : BYTE         ) : BYTE;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexCheckMediaChange;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexCheckMediaChangeCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexCheckMediaChange;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  MSCDEX_IsMediaChanged := CB.MediaStatus;

END;  { MSCDEX_IsMediaChanged }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetAudioDiskInfo(     Drive          : BYTE;
                                   Var StartTrack     : BYTE;
                                   Var EndTrack       : BYTE;
                                   Var LeadOutStart   : LONGINT ) : TError;

[PARAMETERS]

Drive        CD-ROM Drive Number
StartTrack   VAR Returned ?
EndTrack     VAR Returned ?
LeadOutStart VAR Returned ?

[RETURNS]

Function : ?
(VAR     : [StartTrack] ?)
(VAR     : [EndTrack] ?)
(VAR     : [LeadOutStart] ?)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetAudioDiskInfo(     Drive          : BYTE;
                                   Var StartTrack     : BYTE;
                                   Var EndTrack       : BYTE;
                                   Var LeadOutStart   : LONGINT ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexGetAudioDiskInfo;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexGetAudioDiskInfoCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexGetAudioDiskInfo;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  StartTrack   := CB.LowestTrack;
  EndTrack     := CB.HighestTrack;
  LeadOutStart := CB.StartOfLeadout;

  MSCDEX_GetAudioDiskInfo := IOR.Header.Status;

END;  { MSCDEX_GetAudioDiskInfo }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetAudioTrackInfo(    Drive          : BYTE;
                                       TrackNum       : BYTE;
                                   Var StartPoint     : LONGINT;
                                   Var TrackConInfo   : BYTE    ) : TError;

[PARAMETERS]

Drive        CD-ROM Drive Number
TrackNum     ?
StartPoint   VAR Returned ?
TrackConinfo VAR Returned ?

[RETURNS]

Function : ?
(VAR     : [StartPoint] ?)
(VAR     : [TrackConInfo] ?)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetAudioTrackInfo(    Drive          : BYTE;
                                       TrackNum       : BYTE;
                                   Var StartPoint     : LONGINT;
                                   Var TrackConInfo   : BYTE    ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexGetAudioTrackInfo;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexGetAudioTrackInfoCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexGetAudioTrackInfo;
  CB.TrackNum := TrackNum;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  StartPoint   := CB.StartPoint;

{  BCDFSMtoFSM( TFSM( StartPoint ) );  }

  TrackConInfo := CB.TrackConInfo;

  MSCDEX_GetAudioTrackInfo := IOR.Header.Status;

END;  { MSCDEX_GetAudioTrackInfo }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetAudioQChanInfo(    Drive          : BYTE;
                                   Var ConAddr        : BYTE;
                                   Var TrackNum       : BYTE;
                                   Var IndexNum       : BYTE;
                                   Var TrackTime      : TFSM;
                                   Var DiskTime       : TFSM    ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number
ConAddr     VAR Returned ?
TrackNum    VAR Returned ?
IndexNum    VAR Returned ?
TrackTime   VAR Returned ?
DiskTime    VAR Returned ?

[RETURNS]

Function : ?
(VAR     : [ConAddr] ?)
(VAR     : [TrackNum] ?)
(VAR     : [IndexNum] ?)
(VAR     : [TrackTime] ?)
(VAR     : [DiskTime] ?)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetAudioQChanInfo(    Drive          : BYTE;
                                   Var ConAddr        : BYTE;
                                   Var TrackNum       : BYTE;
                                   Var IndexNum       : BYTE;
                                   Var TrackTime      : TFSM;
                                   Var DiskTime       : TFSM    ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexGetAudioQChanInfo;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexGetAudioQChanInfoCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexGetAudioQChanInfo;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  ConAddr     := CB.ControlAndAddr;

  TrackNum    := CB.TrackNum;
  IndexNum    := CB.IndexNum;


  {----------------------------------------}
  { Ahem.  Here we load the times from the }
  { readQChanInfo structure into the TFSM  }
  { variables that are returned.  We do    }
  { this one field at a time because       }
  { the readQChanInfo function is the one  }
  { MSCDEX function that returns           }
  { TFSMBackwards records instead of TFSMs.}
  {----------------------------------------}


  TrackTime.M := CB.TrackTime.M;
  TrackTime.S := CB.TrackTime.S;
  TrackTime.F := CB.TrackTime.F;
  TrackTime.P := 0;

  DiskTime.M := CB.DiskTime.M;
  DiskTime.S := CB.DiskTime.S;
  DiskTime.F := CB.DiskTime.F;
  DiskTime.P := 0;

  MSCDEX_GetAudioQChanInfo := IOR.Header.Status;

END;  { MSCDEX_GetAudioQChanInfo }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetAudioSubChanInfo(  Drive          : BYTE;
                                       StartFrame     : LONGINT;
                                       SecsToRead     : LONGINT;
                                       TransferAddr   : POINTER ) : TError;

[PARAMETERS]

Drive        CD-ROM Drive Number
StartFrame   ?
SecsToRead   ?
TransferAddr ?

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetAudioSubChanInfo(  Drive          : BYTE;
                                       StartFrame     : LONGINT;
                                       SecsToRead     : LONGINT;
                                       TransferAddr   : POINTER ) : TError;

BEGIN

END;  { MSCDEX_GetAudioSubChanInfo }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetUPCCode(           Drive          : BYTE;
                                   Var ConAddr        : BYTE;
                                   Var UPCCode        : TUPCCode;
                                   Var AFrame         : BYTE    ) : Terror;

[PARAMETERS]

Drive       CD-ROM Drive Number
ConAddr     VAR Returned ?
UPCCode     VAR Returned ?
AFrame      VAR Returned ?

[RETURNS]

Function : ?
(VAR     : [ConAddr] ?)
(VAR     : [UPCCode] ?)
(VAR     : [AFrame] ?)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetUPCCode(           Drive          : BYTE;
                                   Var ConAddr        : BYTE;
                                   Var UPCCode        : TUPCCode;
                                   Var AFrame         : BYTE    ) : Terror;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexGetUPCCode;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexGetUPCCodeCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexGetUPCCode;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  UPCCode := CB.UPCCode;
  AFrame  := CB.AFrame;

  MSCDEX_GetUPCCode := IOR.Header.Status;

END;  { MSCDEX_GetUPCCode }

{}

(*-

[FUNCTION]

Function  MSCDEX_GetAudioStatusInfo(   Drive          : BYTE;
                                   Var AudioStatus    : WORD;
                                   Var PlayStart      : LONGINT;
                                   Var PlayEnd        : LONGINT ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number
AudioStatus VAR Returned ?
PlayStart   VAR Returned ?
PlayEnd     VAR Returned ?

[RETURNS]

Function : ?
(VAR     : [AudioStatus] ?)
(VAR     : [PlayStart] ?)
(VAR     : [PlayEnd] ?)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_GetAudioStatusInfo(   Drive          : BYTE;
                                   Var AudioStatus    : WORD;
                                   Var PlayStart      : LONGINT;
                                   Var PlayEnd        : LONGINT ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexGetAudioStatusInfo;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexGetAudioStatusInfoCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexGetAudioStatusInfo;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  AudioStatus := CB.AudioStatus;
  PlayStart   := CB.PlayStart;
  PlayEnd     := CB.PlayEnd;

  MSCDEX_GetAudioStatusInfo := IOR.Header.Status;

END;  { MSCDEX_GetAudioStatusInfo }

{}

(*-

[FUNCTION]

Function  MSCDEX_EjectDisk(            Drive          : BYTE    ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_EjectDisk(            Drive          : BYTE    ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexEjectDisk;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexEjectDiskCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexEjectDisk;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  MSCDEX_EjectDisk := IOR.Header.Status;

END;  { MSCDEX_EjectDisk }

{}

(*-

[FUNCTION]

Function  MSCDEX_LockUnlockDoor(       Drive          : BYTE;
                                       Lock           : BOOLEAN ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number
Lock        Is Action Lock Door? (TRUE=Yes)

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_LockUnlockDoor(       Drive          : BYTE;
                                       Lock           : BOOLEAN ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexLockUnlockDoor;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexLockUnlockDoorCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexLockUnlockDoor;

  If Lock Then
    CB.LockCode := cmscdexLockDoor
  Else
    CB.LockCode := 0;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  MSCDEX_LockUnlockDoor := IOR.Header.Status;

END; { MSCDEX_LockUnlockDoor }

{}

(*-

[FUNCTION]

Function  MSCDEX_ResetDrive(           Drive          : BYTE    ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_ResetDrive(           Drive          : BYTE    ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexResetDrive;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexResetDriveCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexResetDrive;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  MSCDEX_ResetDrive := IOR.Header.Status;

END;  { MSCDEX_ResetDrive }

{}

(*-

[FUNCTION]

Function  MSCDEX_CloseTray(            Drive          : BYTE    ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_CloseTray(            Drive          : BYTE    ) : TError;

Var

  IOR  : TmscdexIOCTLReq;
  CB   : TmscdexCloseTray;

BEGIN

  {---------------------------}
  { Load IOCTL request header }
  {---------------------------}

  MSCDEX_LoadIOR( @IOR,
                  22,
                  cmscdexIOCTLRead,
                  0,
                  @CB,
                  cmscdexCloseTrayCBS );

  {---------------------------}
  { Fill in the Control Block }
  {---------------------------}

  CB.ConBCode := cmscdexCloseTray;

  {-----------------}
  { Execute Request }
  {-----------------}

  MSCDEX_ExecRequest( Drive, @IOR );

  {------------------------------}
  { Extract Results from Request }
  {------------------------------}

  MSCDEX_CloseTray := IOR.Header.Status;

END;  { MSCDEX_CloseTray }

{}

(*-

[FUNCTION]

Function  MSCDEX_ReadLong(             Drive          : BYTE;
                                       AddrMode       : BYTE;
                                       TransferAddr   : POINTER;
                                       SecsToRead     : WORD;
                                       StartSec       : LONGINT;
                                       ReadMode       : BYTE;
                                       InterleaveSize : BYTE;
                                       InterleaveSkip : BYTE    ) : TError;

[PARAMETERS]

Drive          CD-ROM Drive Number
AddrMode       ?
TransferAddr   ?
SecsToRead     ?
StartSec       ?
ReadMode       ?
InterleaveSize ?
InterleaveSkip ?

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_ReadLong(             Drive          : BYTE;
                                       AddrMode       : BYTE;
                                       TransferAddr   : POINTER;
                                       SecsToRead     : WORD;
                                       StartSec       : LONGINT;
                                       ReadMode       : BYTE;
                                       InterleaveSize : BYTE;
                                       InterleaveSkip : BYTE    ) : TError;

BEGIN

END;  { MSCDEX_ReadLong }

{}

(*-

[FUNCTION]

Function  MSCDEX_PlayAudio(            Drive          : BYTE;
                                       AddrMode       : BYTE;
                                       Start          : LONGINT;
                                       PlayFor        : LONGINT ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number
AddrMode    ?
Start       ?
PlayFor     ?

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_PlayAudio(            Drive          : BYTE;
                                       AddrMode       : BYTE;
                                       Start          : LONGINT;
                                       PlayFor        : LONGINT ) : TError;

Var

  PlayR : TmscdexPlayAudioReq;
  Z     : INTEGER;

BEGIN

  PlayR.Header.HeaderSize  := 22;
  PlayR.Header.SubUnit     := 0;
  PlayR.Header.CommandCode := 132;

  PlayR.AddrMode := AddrMode;
  PlayR.Start    := Start;

  PlayR.PlayFor  := PlayFor;

  PlayR.Header.Status := 0;

  For Z:=1 to 8 DO
    PlayR.Header.Reserved[Z]:=0;

  MSCDEX_ExecRequest( Drive, @PlayR );

  MSCDEX_PlayAudio := PlayR.Header.Status;

END;  { MSCDEX_PlayAudio }

{}

(*-

[FUNCTION]

Function  MSCDEX_StopAudio(            Drive          : BYTE    ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_StopAudio(            Drive          : BYTE    ) : TError;

Var

  StopR : TmscdexStopAudioReq;

BEGIN

  StopR.Header.HeaderSize   := 22;
  StopR.Header.Subunit      := 0;
  StopR.Header.CommandCode  := 133;

  MSCDEX_ExecRequest( Drive, @StopR );

  MSCDEX_StopAudio := StopR.Header.Status;

END;  { MSCDEX_StopAudio }

{}

(*-

[FUNCTION]

Function  MSCDEX_ResumeAudio(          Drive          : BYTE    ) : TError;

[PARAMETERS]

Drive       CD-ROM Drive Number

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  MSCDEX_ResumeAudio(          Drive          : BYTE    ) : TError;

Var

  ResR : TmscdexResumeAudioReq;

BEGIN

  ResR.Header.HeaderSize   := 22;
  ResR.Header.Subunit      := 0;
  ResR.Header.CommandCode  := 136;

  MSCDEX_ExecRequest( Drive, @ResR );

  MSCDEX_ResumeAudio := ResR.Header.Status;

END;  { MSCDEX_ResumeAudio }

{}
{}
{}

BEGIN

END.
