{
 

 Visionix Output Unit (VOUT)
   Version 0.7
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 jrt       12/05/93  Changed single DriverParam parameter on
                     VOutSubChannelNew and VOutFilterAttach to
                     DriverParam1, DriverParam2, and DriverParam3.

 jrt       11/10/93  Added RegionFillxxx functions
                     Added RegionFillxxx cases to VirtScreenFilter

 jrt       07/10/93  Start of new channel/subchannel/filter architecture

 lpg       03/16/93  Added Source Documentation

 mep       02/11/93  Cleaned up code for beta release

 jrt       02/08/93  Sync with beta 0.12 release

 jrt       02/08/93  Added VOutGetScreenSize

 jrt       12/07/92  Sync with beta 0.11 release

 jrt       11/21/92  Sync with beta 0.08

 jrt       09/01/92  First logged revision.

 

 C A V E A T S :

   When we have a sub-channel with a driver and a filter, and the driver
   doesn't know how to scroll (and thus returns an ODS_CantDo/
   ODS_MsgNeedScrollxxx, the filter/driver can get out or sync if
   multiple-scroll commands come right after each other.

   This is because the filter does all of its work before it calls the
   driver, and so the filter will have already done all of its scrolling.
   When the driver asks for help with scrolling, the filter may no
   longer have all the information about the region to scroll, because
   it has already scrolled the stuff out of the region.

   Two solutions are currently proposed:

     1) filter will perform ops until it needs to scroll.  Filter will
        then call the Driver until it says it needs to scroll.  Filter
        will then scroll both in a synchronized manner.

     2) callback on scroll (yuck)


}


(*-

[TEXT]

<About VOUT>


<Overview>

- VOUT functions.  VOUT contains an extensive collection of video
  text output functions, such as VOutClrScr, VOutWriteString,
  VOutInsLine, VOutWindow, Etc.

- Multiple channels.  Every VOUT function takes a "channel handle".
  This tells VOUT which channel to perform the function on.
  "Multiple channels" can be used to perform operations on
  seperate video displays.  For example, two seperate channels
  could be set up for the primary and secondary monitors.  Commands
  sent to the first channel would go to the primary montior.  Commands
  sent to the second channel would go to the secondary monitor.
  Each monitor would then have a different display.

- Multiple sub-channels.  Sub-channels are synchronzied branches from
  a channel.

  Sub-channels allow the same output commands to be "synchronized"
  on different video displays.  For example, one channel could
  be created with two sub-channels.  One sub-channel would be
  setup for the local video display, and another could be setup
  to send ANSI over a serial port.  Commands to this channel would
  then be sent both to the local video display and out over the
  serial port.

  This could be used as the text-output interface for a BBS program
  or other host communications software.


<Implemenatation>

The following example shows how VOUTu is actually implemented.
In the example, we have two channels.  One for VCRT, and another
which could be for any other unit or program.

The VCRT channel has two-sub


              |   ^
              1   |
              |   14
              V   |
    +----------------------------+  +-----------------------------+
A   | VCRTu TP CRT API Unit      |  |  Other VOUT dependent Unit  |
    +----------------------------+  +-----------------------------+
              |   ^                              |    |
              2   |                              |    |
              |   13                             |    |
              V   |                              |    |
    +-------------------------------------------------------------+
B   |      VOUTu Visionix text input/output architecture unit     |
    +-------------------------------------------------------------+
              |   ^                              |    ^
              3   |                              |    |
              |   12                             |    |
              V   |                              V    |
    +--------------------------+       +--------------------------+
C   | VCRT Output channel      |       | Other Output Channel     |
    | (CallChannel function)   |       | (CallChannel function)   |
    +--------------------------+       +--------------------------+
        |   ^         |   ^               |   ^          |    ^
        4   |        11   |               |   |          |    |
        |   |         |   |               |   |          |    |
        |   |         V   |               V   |          V    |
     - - - - - - +  - - - - - -         - - - - - - +  - - - - - -
D   | VidMem       | SerANSI   |       | Other Sub    | Other     |
      Subchannel |   Subchannel          Channel    |   SubChannel
    + - - - - - -  + - - - - - +       + - - - - - -  + - - - - - +
        |   |         |   |               |   ^          |    ^
        |   |         |   |               |   |          |    |
        |   10        |   |               |   |          |    |
        V   |         |   |               |   |          V    |
    +------------+    |   |               |   |       +-----------+
E   | ANSI       |    |   |               |   |       | Other     |
    | Filter     |    12  |               |   |       | Filter    |
    +------------+    |   |               |   |       +-----------+
        |   ^         |   |               |   |          |    ^
        6   |         |   |               |   |          |    |
        |   9         |   |               |   |          |    |
        V   |         V   |               V   |          V    |
    +------------+    |   |               |   |       +-----------+
E   | Avatar     |    |   |               |   |       | Other     |
    | Filter     |    |   13              |   |       | Filter    |
    +------------+    |   |               |   |       +-----------+
        |   ^         |   |               |   |          |    ^
        7   |         |   |               |   |          |    |
        |   8         |   |               |   |          |    |
        V   |         V   |               V   |          V    |
    +------------+ +-----------+       +------------+ +-----------+
F   | VidMem     | | ANSI      |       | Other      | | Other     |
    | Out channel| | OutChannel|       | OutChannel | | OutChannel|
    | driverproc | | driverproc|       | DriverProc | | Driverproc|
    +------------+ +-----------+       +------------+ +-----------+
                        |
                        |
                        V
                   +-----------+
                   | To VSEru  |
                   +-----------+


(1)  An application makes a call to the VCRTu TP CRT API replacement
     unit to perform video a video text output operation.

(2)  VCRTu then calls the appropriate function in VOUTu, passing a handle
     which indicates that the operation should be performed on the
     "VCRT output channel"

(3)  VOUTu builds an "Out Driver Packet" (or ODP) with all the
     information about the current video text output operation.
     VOUTu then calls the "CallChannel" function to send the
     ODP to the appropriate output channel (as determined by the
     handle in #2)

(4)  The channel passes the ODP to the first sub-channel that it has.
     Each sub-channel is what is known as a "driver stack".
     A sub-channel is a "driver stack" because multiple "filters"
     can be stacked on top of a driver.

     The channel passes the ODP to the sub-channel by calling the
     first "filter" or "driver" on the sub-channels driver stack.

(5)  The ODP is received by a filter.
     A filter can examine the ODP and determine if it wants to "filter"
     the ODP.  "Filtering" can include either changing the ODP and
     sending it on or generating 1 or more new ODPs and sending it/them
     on.  A good example a filter is the ANSI filter, which converts
     all ANSI commands within ODP "Write Text" commands to the ODP
     equivalents of the ANSI commands, and passes them on.

     ODPs are "passed on" by calling the next filter/driver on the
     sub-channels driver stack.

(6)  The ODP is received by another filter.  In this example, the
     filter is an Avatar filter, which converts all Avatar commands
     within ODP "write text" commands their ODP equivalents, and
     passes them on.

     ODPs are again "passed on" by calling the next filter/driver on the
     sub-channels driver stack.

(7)  An "Output driver" receives an ODPs.  Several different varieties of
     ODPs exist.  The CrtVidMem driver takes ODPs and performs them
     on video memory, thereby updating the local screen.  The
     AnsiDriver converts ODPs into ANSI command sequences, which can
     then be sent to the DOS/OS-2 ANSI driver or out over the serial
     port.

(8)  When the "Output driver" has completed performing the ODP,
     it marks the ODP as completed and returns to whoever called it.
     If the "output driver" cannot complete the request for some
     reason (for example: if the Output driver was an ANSI one, and the
     ODP is a request to read video memory.  Their is no ANSI
     "read video memory" command, so the ANSI driver could not
     complete the ODP), the ODP marks the packet as incomplete.

     The driver then returns to whoever called it.  In this example,
     it is the "Avatar" filter, which was immediately before the driver
     on the driver stack.

(9)  The Avatar filter sees that the ODP was completed, and returns
     to whomever called it.  (In this case, the ANSI filter)

(10) The ANSI filter sees that the ODP was completed, and returns to
     whomever called it.  (In this case, the CallChannel function)

(11) The CallChannel function passes the ODP to the next sub-channel
     it has.   A sequence of events similar to 5-10 occurs again.
     The CallChannel function does this for each sub-channel it has.

(12) The CallChannel function returns to the procedure in the VOUTu
     unit that called it.

(13) The VOUTu unit extracts any return information from the ODP
     (IE: error code, current text attribute, current X/Y, etc)
     and returns that information to the VCRTu function which called
     it.

(14) VCRTu returns to the function which called it.


The text output operation has now been completed.  Although it might
seem that all of these operations would take an excessive amount
of time to complete, optimizations throughout the VOUTu architecture
insure that everything is accomplished rather quickly.


-*)


{$V-}

Unit VOutU;

Interface

Uses

  VTypesu,
  VGenu,
  VMultiu;

{}


{
  OutDriver --> Hardware
  OutDriver --> BIOS
  OutDriver --> DOS/ANSI
  OutDriver --> Crt
  OutDriver --> OpCrt
}

{--------------}
{ cursor types }
{--------------}

Const

  cctNone           = 0;
  cctSmall          = 1;
  cctHalf           = 2;
  cctBig            = 3;

Const

  ODF_DriverNew     = 1;  { <'A'> }
  ODF_DriverOff     = 2;
  ODF_DriverOn      = 3;
  ODF_DriverDispose = 4;
  ODF_WriteChar     = 5;
  ODF_WriteBlock    = 6;
  ODF_WriteVert     = 7;  { <^V><1><len><chars...> }
  ODF_ClrEOL        = 8;
  ODF_ClrScr        = 9;
  ODF_DelLine       = 10;
  ODF_InsLine       = 11;
  ODF_GotoXY        = 12;
  ODF_Window        = 13; { <^V><A><X1><Y1><X2><Y2>            }
  ODF_ColorText     = 14;
  ODF_ColorBack     = 15;

  ODF_GetWin        = 16; { <^V><B>                            }
  ODF_GetAttr       = 17; { <^V><C>                            }
  ODF_SetAttr       = 18;
  ODF_GetXY         = 19; { <^V><D>                            }
  ODF_GetNumScreens = 20; { <^V><E>                            }
  ODF_GoScreen      = 21; { <^V><F><screen>                    }
  ODF_SetCursorType = 22; { <^V><G><type>                      }
  ODF_DrawHLine     = 23; { <^V><H><X1><Y1><type><count>       }
  ODF_DrawVLine     = 24; { <^V><I><X1><Y1><type><count>       }
  ODF_DrawBox       = 25; { <^V><J><X1><Y1><X2><Y2><type>      }

  ODF_ReadChar      = 26; { <^V><K><X1><Y1>                    }
  ODF_ReadAttr      = 27; { <^V><L><X1><Y1>                    }
  ODF_WriteAttr     = 28; { <^V><M><X1><Y1><attr>              }

  ODF_QueryRegion   = 29; { <^V><N><X1><X2><Y1><Y2>            }
  ODF_ReadRegion    = 30; { <^V><O><X1><X2><Y1><Y2>            }
  ODF_WriteRegion   = 31; { <^V><P><X1><X2><Y1><Y2>            }

  ODF_DriverRenew   = 32; { <^V><Q><cols><rows>                }

  ODF_WriteCharAt   = 33; { <^V><R><X1><Y1><attr>              }
  ODF_WriteBlockAt  = 34; { <^V><S><X1><Y1><attr><count>       }
  ODF_WriteVertAt   = 35; { <^V><T><X1><Y1><attr><count>       }

  ODF_GetScreenSize = 36;

  ODF_CursorUp      = 40;
  ODF_CursorDown    = 41;
  ODF_CursorLeft    = 42;
  ODF_CursorRight   = 43;

  ODF_RegionScrUp   = 44;
  ODF_RegionScrDown = 45;
  ODF_RegionCopy    = 46;

  ODF_RegionFill    = 47;
  ODF_RegionFillA   = 48;
  ODF_RegionFillC   = 49;

  ODF_RepeatChar    = 50;
  ODF_RepeatCharAt  = 51;

  {ODF_RepeatAttr   = 52; }
  {ODF_RepeatAttrAt = 53; }

  ODF_RepeatBlock   = 54;
  ODF_RepeatBlockAt = 55;

  ODF_FlushBuffers  = 56;

  {--------------}

  ODS_Changed        = 1;            { the odp has been changed        }
  ODS_Install        = 2;            { When NEWing -- install me       }
  ODS_Sequence       = 4;            { packet is part of a sequence    }



  ODS_CantDo         = 8;            { I cant do/finish what you asked }
                                     { reason will be in the MSG field }

  ODS_MsgNoScreenBuff   = 1;         { I dont have a screen buffer     }
  ODS_MsgNeedScrollUp   = 2;         { I need to scroll the window up  }
  ODS_MsgNeedScrollDown = 3;         { I need to scroll the window down}




  OLT_UseChar        = 1;
  OLT_ASCII          = 2;
  OLT_UnderLine      = 3;
  OLT_Single         = 4;
  OLT_Double         = 5;

Type


  POutDriverPacket=^TOutDriverPacket;

  TOutDriverProc = Procedure( ODPacket : POutDriverPacket );

  TProcName = String[20];

  PProcName = ^TProcName;

  {----}

  POutDriverProcLLNode = ^TOutDriverProcLLNode;

  {----}

  TOutDriverPacket = Record

    Func          : WORD;
    ID            : Pointer;
    OutDriverProc : TOutDriverProc;
    Name          : PProcName;
{    DriverInfo    : Pointer; }

    DriverParam1  : LONGINT;
    DriverParam2  : LONGINT;
    DriverParam3  : LONGINT;

    NextDriver    : POutDriverProcLLNode;

    Ch            : CHAR;

    NumVal        : WORD;

    Start         : WORD;
    Size          : WORD;
    Buff          : Pointer;

    X1            : WORD;
    Y1            : WORD;
    X2            : WORD;
    Y2            : WORD;

    TheColor      : WORD;

    Attr          : WORD;

    Screens       : WORD;
    Cursor        : WORD;
    Mode          : WORD;

    LineType      : WORD;
    LineLen       : WORD;

    BoxType       : WORD;

    BoxTL         : CHAR;
    BoxT          : CHAR;
    BoxTR         : CHAR;
    BoxR          : CHAR;
    BoxBR         : CHAR;
    BoxB          : CHAR;
    BoxBL         : CHAR;
    BoxL          : CHAR;

    RegionSize    : LONGINT;
    Region        : Pointer;

    Status        : WORD;
    StatusMsg     : WORD;

  End;

  POutDriverProc = ^TOutDriverProc;

  POutDriverList = ^TOutDriverList;

  TOutDriverList = Record

    Proc      : TOutDriverProc;
    ID        : Pointer;
    Next      : POutDriverList;

  End;

  TOutDriverIData = Record

    Off     : WORD;
    Name    : TProcName;

  END;

  POutDriverIData = ^TOutDriverIData;

(*
  TChanInfo = Record

    ODP               : TOutDriverPacket;

    OutDriverListHead : POutDriverList;
    OutDriverListTail : POutDriverList;
    OutDriverListCurr : Array[1..64] of POutDriverList;

  END;
*)

  {------------------------------------------}
  { out driver proc link-list / driver stack }
  {------------------------------------------}


  TOutDriverProcLLNode = RECORD

    Name        : STRING;
    Proc        : TOutDriverProc;
    ID          : Pointer;
    NextPLLNode : POutDriverProcLLNode;

  END;

  {--------------------------------}
  { sub-channel circular link-list }
  {--------------------------------}

  PSubChannelList = ^TSubChannelList;

  TSubChannelList = RECORD

    Name        : STRING;
    Flags       : WORD;
{    ID          : POINTER; }

    FirstProc   : POutDriverProcLLNode;

    NextSubChan : PSubChannelList;

  END;

  {------------------}
  { The Channel type }
  {------------------}

  TChannel = RECORD

    Sig             : WORD; { $1976 }

    Flags           : WORD;
    Name            : STRING;

    ODP             : TOutDriverPacket;

    SubChanListHead : PSubChannelList;
    SubChanListTail : PSubChannelList;
    SubChanListCurr : Array[1..64] of PSubChannelList;

  END;


(*
  TChannel = RECORD

    Sig       : WORD; { $1976 }

    Flags     : WORD;
    Name      : STRING;

    ODP               : TOutDriverPacket;

    OutDriverListHead : POutDriverList;
    OutDriverListTail : POutDriverList;
    OutDriverListCurr : Array[1..64] of POutDriverList;

  END;
*)


  TChanHandle = ^TChannel;

{}

Procedure CallNextDriver( ODP : POutDriverPacket );


Function  VOutChannelNew(         Flags          : WORD;
                                  Name           : STRING     ):TChanHandle;

Function  VOutChannelDispose(     Chan           : TChanHandle ) : WORD;

{----------------------}
{ subchannel functions }
{----------------------}

Function  VOutSubChannelNew(      Chan           : TChanHandle;
                                  Flags          : WORD;
                                  SubChanName    : STRING;
                                  DriverProc     : TOutDriverProc;
                                  DriverParam1   : LONGINT;
                                  DriverParam2   : LONGINT;
                                  DriverParam3   : LONGINT      ):WORD;

Procedure VOutSubChannelOff(      Chan           : TChanHandle;
                                  Name           : TProcName  );

Procedure VOutSubChannelOn(       Chan           : TChanHandle;
                                  Name           : TProcName  );

Procedure VOutSubChannelDispose(  Chan           : TChanHandle;
                                  Name           : TProcName  );



{------------------}
{ filter functions }
{------------------}


Function  VOutFilterAttach(       Chan           : TChanHandle;
                                  Flags          : WORD;
                                  FilterName     : STRING;
                                  SubChanName    : STRING;
                                  Filter         : TOutDriverProc;
                                  FilterParam1   : LONGINT;
                                  FilterParam2   : LONGINT;
                                  FilterParam3   : LONGINT      ):WORD;

Procedure VOutFilterOff(          Chan           : TChanHandle;
                                  Name           : TProcName  );

Procedure VOutFilterOn(           Chan           : TChanHandle;
                                  Name           : TProcName  );

Procedure VOutFilterDetach(       Chan           : TChanHandle;
                                  Name           : TProcName  );


{-------------------------}
{ default out driver proc }
{-------------------------}

Procedure DefaultOutDriverProc(   ODP            : POutDriverPacket );


{-----------------------------}
{ VOUT presentation functions }
{-----------------------------}

Procedure VOutWriteChar(          Chan           : TChanHandle;
                                  Ch             : Char          );

Procedure VOutWriteBlock(         Chan           : TChanHandle;
                                  Block          : Pointer;
                                  Size           : WORD      );

Procedure VOutWriteString(        Chan           : TChanHandle;
                                  S              : STRING    );

Procedure VOutWriteBlockVert(     Chan           : TChanHandle;
                                  Block          : Pointer;
                                  Size           : WORD      );

Procedure VOutWriteStringVert(    Chan           : TChanHandle;
                                  S              : STRING    );

Procedure VOutWriteCharAt(        Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  Ch             : CHAR      );

Procedure VOutWriteBlockAt(       Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  Block          : Pointer;
                                  Size           : WORD      );

Procedure VOutWriteStringAt(      Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  S              : STRING    );

Procedure VOutWriteBlockVertAt(   Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  Block          : Pointer;
                                  Size           : WORD      );

Procedure VOutWriteStringVertAt(  Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  S              : STRING    );

Procedure VOutClrEOL(             Chan           : TChanHandle   );

Procedure VOutClrScr(             Chan           : TChanHandle   );

Procedure VOutDelLine(            Chan           : TChanHandle   );

Procedure VOutInsLine(            Chan           : TChanHandle   );

Procedure VOutGotoXY(             Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD      );

Procedure VOutWindow(             Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD      );

Procedure VOutTextColor(          Chan           : TChanHandle;
                                  TheColor       : WORD      );

Procedure VOutTextBackGround(     Chan           : TChanHandle;
                                  TheColor       : WORD      );


Function  VOutTextAttrGet(        Chan           : TChanHandle ): WORD;

Procedure VOutTextAttrSet(        Chan           : TChanHandle;
                                  Attr           : WORD      );


Function  VOutWhereX(             Chan           : TChanHandle ) : WORD;

Function  VOUtWhereY(             Chan           : TChanHandle ) : WORD;


Procedure VOutSetCursorType(      Chan           : TCHanHandle;
                                  CurType        : WORD         );


Function  VOutQueryRegion(        Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD      ) : LONGINT;

Procedure VOutReadRegion(         Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Region         : Pointer   );

Procedure VOutWriteRegion(        Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Region         : Pointer   );

Function  VOutCharRead(           Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD      ) : CHAR;

Function  VOutAttrRead(           Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD      ) : BYTE;

Procedure VOutAttrWrite(          Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  Attr           : BYTE      );



Procedure VOutGetScreenSize(      Chan           : TChanHandle;
                              Var Rows           : BYTE;
                              Var Cols           : BYTE      );

Procedure VOutCursorUp(           Chan           : TChanHandle;
                                  UpCount        : WORD      );

Procedure VOutCursorDown(         Chan           : TChanHandle;
                                  UpCount        : WORD      );

Procedure VOutCursorLeft(         Chan           : TChanHandle;
                                  UpCount        : WORD      );

Procedure VOutCursorRight(        Chan           : TChanHandle;
                                  UpCount        : WORD      );

Procedure VOutFillRegion(         Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Attr           : BYTE;
                                  Ch             : CHAR      );

Procedure VOutFillRegionAttr(     Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Attr           : BYTE       );

Procedure VOutFillRegionChar(     Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Ch             : CHAR      );


Procedure VOutRepeatBlock(        Chan           : TChanHandle;
                                  RepeatCount    : WORD;
                                  Block          : Pointer;
                                  Size           : WORD      );

Procedure VOutRepeatString(       Chan           : TChanHandle;
                                  RepeatCount    : WORD;
                                  S              : STRING    );

Procedure VOutFlush(              Chan           : TChanHandle );


Procedure VirtScreenFilter(       ODP            : POutDriverPacket );

{}

Implementation


{}


(*-

[FUNCTION]

Procedure DefaultOutDriverProc(   ODP       : POutDriverPacket );

[PARAMETERS]

ODP         Pointer to Out-Driver Packet

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure DefaultOutDriverProc(   ODP       : POutDriverPacket );

BEGIN
(*
  OpCrtOutDriverProc( ODP );
*)
END;  { DefaultOutDriverProc }

{}

(*-

[FUNCTION]

Procedure CallChannel(         ODP       : POutDriverPacket );

[PARAMETERS]

ODP         Pointer to Out-Driver Packet

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure CallChannel(   Chan      : TChanHandle;
                            ODP       : POutDriverPacket );

Var
(*
  ODN           : POutDriverList;
  NextCurrProc  : POutDriverList;
*)
  SCN             : PSubChannelList;
  NextCurrSubChan : PSubChannelList;
  SaveStart       : WORD;

BEGIN

  SCN := Chan^.SubChanListCurr[ ODP^.Func ];

  NextCurrSubChan := Chan^.SubChanListCurr[ ODP^.Func ]^.NextSubChan;

  ODP^. Status := 0;

  SaveStart := ODP^.Start;

  If SCN <> NIL Then
  BEGIN

    Repeat

      ODP^.Start := SaveStart;

      {--------------------------------------------}
      { Here we prime the sub-channel driver stack }
      { by calling the first driver on the stack.  }
      {--------------------------------------------}

      ODP^.ID := SCN^.FirstProc^.ID;

      ODP^.NextDriver := SCN^.FirstProc^.NextPLLNode;

      SCN^.FirstProc^.Proc( ODP );

      {-----------------------------------------}
      { if the sub-channel reports back that it }
      { is executing a sequence of events,      }
      { make it so that next time around, we    }
      { will call this sub-channel first again. }
      {-----------------------------------------}

      If ODP^.Status and ODS_Sequence>0 Then
      BEGIN

        NextCurrSubChan := SCN;
        ODP^.Status     := ODP^.Status - ODS_Sequence;

      END;  { If ODP^.Status }

      SCN := SCN^.NextSubChan;

    Until SCN = Chan^.SubChanListCurr[ ODP^.Func ];

    Chan^.SubChanListCurr[ ODP^.Func ] := NextCurrSubChan;

  END; { If ODN }

END;  { CallChannel }


{}

(*-

[FUNCTION]

Procedure CallNextDriver( ODP : POutDriverPacket );

[PARAMETERS]

ODP         Pointer to Out-Driver Packet

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure CallNextDriver( ODP : POutDriverPacket );

Var

  CurrDriver : POutDriverProcLLNode;

BEGIN

  If ODP^.NextDriver <> NIL Then
  BEGIN

    CurrDriver      := ODP^.NextDriver;

    ODP^.NextDriver := ODP^.NextDriver^.NextPLLNode;

    ODP^.ID         := CurrDriver^.ID;

    CurrDriver^.Proc( ODP );

    ODP^.NextDriver := CurrDriver;

  END;

END;

{}


Function  VOutChannelNew(         Flags          : WORD;
                                  Name           : STRING     ):TChanHandle;


Var

  NCH : TChanHandle;

BEGIN

  { Allocate a Channel handle }

  New( NCH );

  { fill in the new channel handle }


  NCH^.Sig   := $1976;
  NCH^.Flags := Flags;
  NCH^.Name  := Name;

  NCH^.SubChanListHead    := NIL;
  NCH^.SubChanListTail    := NIL;
  NCH^.SubChanListCurr[1] := NIL;

  VoutChannelNew := NCH;

END;

{}


Function  VOutChannelDispose(     Chan           : TChanHandle ) : WORD;


BEGIN


  Dispose( Chan );

END;

{}



(*-

[FUNCTION]

Function  VOutSubChannelNew(      Chan           : TChanHandle;
                                  Flags          : WORD;
                                  SubChanName    : STRING;
                                  DriverProc     : TOutDriverProc;
                                  DriverParam1   : LONGINT;
                                  DriverParam2   : LONGINT;
                                  DriverParam3   : LONGINT;     ):WORD;

[PARAMETERS]

Proc        Out-Driver Procedure
Name        ?
DriverInfo  Pointer to Out-Driver Information
Err         VAR Returned Error Code

[RETURNS]

Function : None
(VAR     : [Err] Error Code) (0=Success)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VOutSubChannelNew(      Chan           : TChanHandle;
                                  Flags          : WORD;
                                  SubChanName    : STRING;
                                  DriverProc     : TOutDriverProc;
                                  DriverParam1   : LONGINT;
                                  DriverParam2   : LONGINT;
                                  DriverParam3   : LONGINT      ):WORD;


Var

  DLN : POutDriverList;
  Z   : INTEGER;

  SLN : PSubChannelList;

  DLN2: POutDriverProcLLNode;

BEGIN

  With Chan^ Do
  BEGIN

    {-----------------------------------}
    { Build the OutDriverPacket for the }
    { "New" function                    }
    {-----------------------------------}

    ODP.Func          := ODF_DriverNew;

    ODP.ID            := NIL;
    ODP.OutDriverProc := DriverProc;
    ODP.Name          := @Name;
    ODP.DriverParam1  := DriverParam1;
    ODP.DriverParam2  := DriverParam2;
    ODP.DriverParam3  := DriverParam3;

    ODP.Status        := 0;

    ODP.NextDriver    := NIL;

    { call da oder drivers }

    {---------------------------}
    { Call the "New" Out Driver }
    {---------------------------}

    DriverProc( @ODP );

    {---------------------------------------}
    { Was the OutDriverPacket returned with }
    { the install bit set?                  }
    {---------------------------------------}

    If ODP.Status and ODS_Install <>0 Then
    BEGIN

      New( SLN  );

      New( DLN2 );

      {-----------------------------------}
      { Build the start of the out driver }
      { stack / linked list               }
      {-----------------------------------}

      DLN2^.Name        := SubChanName;
      DLN2^.Proc        := DriverProc;
      DLN2^.ID          := ODP.ID;
      DLN2^.NextPLLNode := NIL;

      {----------------------------}
      { Build the sub-channel node }
      {----------------------------}

      SLN^.Name         := SubChanName;
      SLN^.Flags        := Flags;
  {   SLN^.ID           := DriverParams; } {!^! what is this used for}
      SLN^.FirstProc    := DLN2;

      {--------------------------------}
      { Is this the first sub-channel? }
      {--------------------------------}

      If SubChanListHead = NIL Then
      BEGIN

        SubChanListHead := SLN;
        SubChanListTail := SLN;

        For Z := 1 to 64 Do
          SubChanListCurr[ Z ] := SLN;

      END;  { If SubChanListHead=NIL }

      {----------------------------------------------}
      { Fill out the next field to point to the head }
      {----------------------------------------------}

      SLN^.NextSubChan := SubChanListHead;

      {---------------------------------}
      { and put it in the SubChanList   }
      {---------------------------------}

      SubChanListTail^.NextSubChan := SLN;

      SubChanListTail := SLN;


(*
      {---------------------------------}
      { Create a new OutDriverList node }
      {---------------------------------}

      New( DLN );

      {-------------------------------}
      { Is this the first Out driver? }
      {-------------------------------}

      If OutDriverListHead = NIL Then
      BEGIN

        OutDriverListHead := DLN;
        OutDriverListTail := DLN;

        For Z := 1 to 64 Do
          OutDriverListCurr[ Z ] := DLN;

      END;  { If C.OutDriverListHead }

      {-----------------------}
      { Fill out the new node }
      {-----------------------}

      DLN^.Proc := DriverProc;
      DLN^.ID   := ODP.ID;
      DLN^.Next := OutDriverListHead;

      {---------------------------------}
      { and put it in the OutDriverList }
      {---------------------------------}

      OutDriverListTail^.Next := DLN;

      OutDriverListTail := DLN;
*)

    END; { If ODP^.Status = Install }

  END; { With Chan^ }

END; { VOutDriverNew }

{}

(*-

[FUNCTION]

Procedure VOutSubChannelOff(      Chan           : TChanHandle;
                                  Name           : TProcName  );

[PARAMETERS]

Name        ?

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutSubChannelOff(      Chan           : TChanHandle;
                                  Name           : TProcName  );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_DriverOff;
    ODP.Name := @Name;

    CallChannel( Chan, @ODP );

  END;  { With C }

END;  { VOutDriverOff }

{}

(*-

[FUNCTION]

Procedure VOutSubChannelOn(       Chan           : TChanHandle;
                                  Name           : TProcName  );

[PARAMETERS]

Name        ?

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutSubChannelOn(       Chan           : TChanHandle;
                                  Name           : TProcName  );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_DriverOn;
    ODP.Name := @Name;

    CallChannel( Chan, @ODP );

  END;  { With C }

END;  { VOutDriverOn }

{}

(*-

[FUNCTION]

Procedure VOutSubChannelDispose(  Chan           : TChanHandle;
                                  Name           : TProcName  );

[PARAMETERS]

Name        ?

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutSubChannelDispose(  Chan           : TChanHandle;
                                  Name           : TProcName  );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_DriverDispose;
    ODP.Name := @Name;

    CallChannel( Chan, @ODP );

  END;  { With C }

END;  { VOutSubChannelDispose }


{}



Function  VOutFilterAttach(       Chan           : TChanHandle;
                                  Flags          : WORD;
                                  FilterName     : STRING;
                                  SubChanName    : STRING;
                                  Filter         : TOutDriverProc;
                                  FilterParam1   : LONGINT;
                                  FilterParam2   : LONGINT;
                                  FilterParam3   : LONGINT      ):WORD;

Var

  TheSubChan   : PSubChannelList;

  DLN2         : POutDriverProcLLNode;

BEGIN


  With Chan^ Do
  BEGIN

    {----------------------}
    { Find the sub-channel }
    {----------------------}

    TheSubChan := Chan^.SubChanListHead;

    While (TheSubChan^.Name<>SubChanName                  ) and
          (TheSubChan^.NextSubChan<>Chan^.SubChanListHead ) Do

      TheSubChan := TheSubChan^.NextSubChan;


    If TheSubChan^.Name=SubChanName Then
    BEGIN

      {-----------------------------------}
      { Build the OutDriverPacket for the }
      { "New" function                    }
      {-----------------------------------}

      ODP.Func          := ODF_DriverNew;

      ODP.ID            := NIL;
      ODP.OutDriverProc := Filter;
      ODP.Name          := @FilterName;

      ODP.DriverParam1  := FilterParam1;
      ODP.DriverParam2  := FilterParam2;
      ODP.DriverParam3  := FilterParam3;

      ODP.Status        := 0;

      ODP.NextDriver    := NIL;

      {---------------------------}
      { Call the "New" Filter     }
      {---------------------------}

      Filter( @ODP );

      {---------------------------------------}
      { Was the OutDriverPacket returned with }
      { the install bit set?                  }
      {---------------------------------------}

      If ODP.Status and ODS_Install <>0 Then
      BEGIN

        New( DLN2 );

        {-----------------------------------}
        { Build the start of the out driver }
        { stack / linked list               }
        {-----------------------------------}

        DLN2^.Name        := FilterName;
        DLN2^.Proc        := Filter;
        DLN2^.ID          := ODP.ID;
        DLN2^.NextPLLNode := TheSubChan^.FirstProc;


        {---------------------}
        { put it on the stack }
        {---------------------}

        TheSubChan^.FirstProc := DLN2;

      END; { If ODP^.Status = Install }

    END; { If TheSubChan^.Name=SubChanname }

  END; { With Chan^ }

END;

{}


Procedure VOutFilterOff(          Chan           : TChanHandle;
                                  Name           : TProcName  );

BEGIN

END;

{}


Procedure VOutFilterOn(           Chan           : TChanHandle;
                                  Name           : TProcName  );

BEGIN

END;

{}


Procedure VOutFilterDetach(       Chan           : TChanHandle;
                                  Name           : TProcName  );



BEGIN

END;

{}

(*-

[FUNCTION]

Procedure VOutWriteChar(          Chan           : TChanHandle;
                                  Ch             : Char          );

[PARAMETERS]

Ch          Character to Write

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWriteChar(          Chan           : TChanHandle;
                                  Ch             : Char          );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_WriteChar;
    ODP.CH   := CH;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWriteChar }

{}

(*-

[FUNCTION]

Procedure VOutWriteBlock(         Chan           : TChanHandle;
                                  Block          : Pointer;
                                  Size           : WORD      );

[PARAMETERS]

Block       Pointer to Block Data to Write
Size        Size of Block Data in Bytes

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWriteBlock(         Chan           : TChanHandle;
                                  Block          : Pointer;
                                  Size           : WORD      );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_WriteBlock;
    ODP.Start  := 1;
    ODP.Size   := Size;
    ODP.Buff   := Block;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWriteBlock }

{}

(*-

[FUNCTION]

Procedure VOutWriteString(        Chan           : TChanHandle;
                                  S              : STRING    );

[PARAMETERS]

S           String to Write

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWriteString(        Chan           : TChanHandle;
                                  S              : STRING    );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_WriteBlock;
    ODP.Start  := 1;
    ODP.Size   := Byte(S[0]);
    ODP.Buff   := @S[1];

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWriteString }

{}

(*-

[FUNCTION]

Procedure VOutWriteBlockVert(     Chan           : TChanHandle;
                                  Block          : Pointer;
                                  Size           : WORD      );

[PARAMETERS]

Block       Pointer to Block Data to Write Vertically
Size        Size of Block Data in Bytes

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWriteBlockVert(     Chan           : TChanHandle;
                                  Block          : Pointer;
                                  Size           : WORD      );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_WriteVert;
    ODP.Size := Size;
    ODP.Buff := Block;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWriteBlockVert }

{}

(*-

[FUNCTION]

Procedure VOutWriteStringVert(    Chan           : TChanHandle;
                                  S              : STRING    );

[PARAMETERS]

S           String to Write Vertically
[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWriteStringVert(    Chan           : TChanHandle;
                                  S              : STRING    );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_WriteVert;
    ODP.Size := Byte(S[0]);
    ODP.Buff := @S[1];

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWriteStringVert }

{}

(*-

[FUNCTION]

Procedure VOutWriteCharAt(        Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  Ch             : CHAR      );

[PARAMETERS]

X           X Screen Coordinate
Y           Y Screen Coordinate
F           Foreground Color
B           Background Color
Ch          Character to Write

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWriteCharAt(        Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  Ch             : CHAR      );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_WriteCharAt;
    ODP.X1   := X;
    ODP.Y1   := Y;

    ODP.Attr := (VOutTextAttrGet( Chan ) and $FF80) +
                ((B AND $0F) SHL 4)         +
                (F AND $0F);

    ODP.CH   := CH;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWriteCharAt }

{}

(*-

[FUNCTION]

Procedure VOutWriteBlockAt(       Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  Block          : Pointer;
                                  Size           : WORD      );

[PARAMETERS]

X           X Screen Coordinate
Y           Y Screen Coordinate
F           Foreground Color
B           Background Color
Block       Pointer to Block Data to Write
Size        Size of Block Data in Bytes

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWriteBlockAt(       Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  Block          : Pointer;
                                  Size           : WORD      );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_WriteBlockAt;
    ODP.X1   := X;
    ODP.Y1   := Y;
    ODP.Attr := (VOutTextAttrGet( Chan ) and $FF80) + ((B AND $0F) SHL 4) + (F AND $0F);
    ODP.Size := Size;
    ODP.Buff := Block;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWriteBlockAt }

{}

(*-

[FUNCTION]

Procedure VOutWriteStringAt(      Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  S              : STRING    );

[PARAMETERS]

X           X Screen Coordinate
Y           Y Screen Coordinate
F           Foreground Color
B           Background Color
S           String to Write

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWriteStringAt(      Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  S              : STRING    );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Attr := (VOutTextAttrGet( Chan ) and $FF80) + ((B AND $0F) SHL 4) + (F AND $0F);

    ODP.Func := ODF_WriteBlockAt;
    ODP.X1   := X;
    ODP.Y1   := Y;
    ODP.Size := Byte(S[0]);
    ODP.Buff := @S[1];

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWriteStringAt }

{}

(*-

[FUNCTION]

Procedure VOutWriteBlockVertAt(   Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  Block          : Pointer;
                                  Size           : WORD      );


[PARAMETERS]

X           X Screen Coordinate
Y           Y Screen Coordinate
F           Foreground Color
B           Background Color
Block       Pointer to Block Data to Write
Size        Size of Block Data in Bytes

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWriteBlockVertAt(   Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  Block          : Pointer;
                                  Size           : WORD      );


BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_WriteVertAt;
    ODP.X1   := X;
    ODP.Y1   := Y;
    ODP.Attr := (VOutTextAttrGet( Chan )and $FF80) + ((B AND $0F) SHL 4) + (F AND $0F);
    ODP.Size := Size;
    ODP.Buff := Block;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWriteBlockVertAt }

{}

(*-

[FUNCTION]

Procedure VOutWriteStringVertAt(  Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  S              : STRING    );

[PARAMETERS]

X           X Screen Coordinate
Y           Y Screen Coordinate
F           Foreground Color
B           Background Color
S           String to Write

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWriteStringVertAt(  Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD;
                                  F              : WORD;
                                  B              : WORD;
                                  S              : STRING    );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_WriteVertAt;
    ODP.X1   := X;
    ODP.Y1   := Y;
    ODP.Attr := (VOutTextAttrGet( Chan ) and $FF80) + ((B AND $0F) SHL 4) + (F AND $0F);
    ODP.Size := Byte(S[0]);
    ODP.Buff := @S[1];

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWriteStringVertAt }

{}

(*-

[FUNCTION]

Procedure VOutClrEOL(             Chan           : TChanHandle   );

[PARAMETERS]

(None)

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutClrEOL(             Chan           : TChanHandle   );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_ClrEOL;
    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VoutClrEOL }

{}

(*-

[FUNCTION]

Procedure VOutClrScr(             Chan           : TChanHandle   );

[PARAMETERS]

(None)

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutClrScr(             Chan           : TChanHandle   );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_ClrScr;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutClrScr }

{}

(*-

[FUNCTION]

Procedure VOutDelLine(            Chan           : TChanHandle   );

[PARAMETERS]

(None)

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutDelLine(            Chan           : TChanHandle   );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_DelLine;
    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutDelLine }

{}

(*-

[FUNCTION]


[PARAMETERS]

(None)

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutInsLine(            Chan           : TChanHandle   );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_InsLine;
    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutInsLine }

{}

(*-

[FUNCTION]

Procedure VOutGotoXY(             Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD      );

[PARAMETERS]

X           New X Screen Coordinate
Y           New Y Screen Coordinate

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutGotoXY(             Chan           : TChanHandle;
                                  X              : WORD;
                                  Y              : WORD      );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_GotoXY;
    ODP.X1   := X;
    ODP.Y1   := Y;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutGotoXY }

{}

(*-

[FUNCTION]

Procedure VOutWindow(             Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD      );

[PARAMETERS]

X1          Window Left Screen Coordinate
Y1          Window Top Screen Coordinate
X2          Window Right Screen Coordinate
Y2          Window Bottom Screen Coordinate

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWindow(             Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD      );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func := ODF_Window;
    ODP.X1   := X1;
    ODP.Y1   := Y1;
    ODP.X2   := X2;
    ODP.Y2   := Y2;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWindow }

{}

(*-

[FUNCTION]

Procedure VOutTextColor(          Chan           : TChanHandle;
                                  TheColor       : WORD      );

[PARAMETERS]

TheColor    New Text Foreground Color

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutTextColor(          Chan           : TChanHandle;
                                  TheColor       : WORD      );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func     := ODF_ColorText;
    ODP.TheColor := TheColor;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutTextColor }

{}

(*-

[FUNCTION]

Procedure VOutTextBackGround(     Chan           : TChanHandle;
                                  TheColor       : WORD      );

[PARAMETERS]

TheColor    New Text Background Color

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutTextBackGround(     Chan           : TChanHandle;
                                  TheColor       : WORD      );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func     := ODF_ColorBack;
    ODP.TheColor := TheColor;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutTextBackGround }

{}

(*-

[FUNCTION]

Function  VOutTextAttrGet(        Chan           : TChanHandle ): WORD;


[PARAMETERS]

(None)

[RETURNS]

Current Text Attribute

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VOutTextAttrGet(        Chan           : TChanHandle ): WORD;


BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func     := ODF_GetAttr;

    CallChannel( Chan, @ODP );

    VOutTextAttrGet := ODP.Attr;

  END;  { With Chan^ }

END;  { VOutTextAttrGet }

{}

(*-

[FUNCTION]

Procedure VOutTextAttrSet(        Chan           : TChanHandle;
                                  Attr           : WORD      );


[PARAMETERS]

Attr        New Text Attribute

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutTextAttrSet(        Chan           : TChanHandle;
                                  Attr           : WORD      );


BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func     := ODF_SetAttr;
    ODP.Attr     := Attr;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutTextAttrSet }

{}

(*-

[FUNCTION]

Function  VOutWhereX(             Chan           : TChanHandle ) : WORD;

[PARAMETERS]

(None)

[RETURNS]

Current Cursor X Screen Coordinate

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VOUtWhereX(             Chan           : TChanHandle ) : WORD;

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func     := ODF_GetXY;

    CallChannel( Chan, @ODP );

    VOutWhereX := ODP.X1;

  END;  { With Chan^ }

END;  { VOutWhereX }

{}

(*-

[FUNCTION]

Function  VOUtWhereY(             Chan           : TChanHandle ) : WORD;

[PARAMETERS]

(None)

[RETURNS]

Current Cursor Y Screen Coordinate

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)


Function  VOUtWhereY(             Chan           : TChanHandle ) : WORD;

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func     := ODF_GetXY;

    CallChannel( Chan, @ODP );

    VOutWhereY := ODP.Y1;

  END;  { With Chan^ }

END;  { VOutWhereY }

{}

Procedure VOutSetCursorType(      CHan           : TCHanHandle;
                                  CurType        : WORD         );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func     := ODF_SetCursorType;
    ODP.NumVal   := CurType;

    CallChannel( Chan, @ODP );

  END;

END;


{}

(*-

[FUNCTION]

Function  VOutQueryRegion(        Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD      ) : LONGINT;


[PARAMETERS]

X1          Region Left Screen Coordinate
Y1          Region Top Screen Coordinate
X2          Region Right Screen Coordinate
Y2          Region Bottom Screen Coordinate

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VOutQueryRegion(        Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD      ) : LONGINT;


BEGIN

  VOutQueryRegion := ((1+X2-X1)*2) * (1+Y2-Y1);

END;  { VOutQueryRegion }

{}

(*-

[FUNCTION]

Procedure VOutReadRegion(         Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Region         : Pointer   );

[PARAMETERS]

X1          Region Left Screen Coordinate
Y1          Region Top Screen Coordinate
X2          Region Right Screen Coordinate
Y2          Region Bottom Screen Coordinate
Region      Pointer to Region Read Data

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutReadRegion(         Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Region         : Pointer   );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_ReadRegion;
    ODP.X1     := X1;
    ODP.Y1     := Y1;
    ODP.X2     := X2;
    ODP.Y2     := Y2;
    ODP.Region := Region;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END; { VOutReadRegion }

{}

(*-

[FUNCTION]

Procedure VOutWriteRegion(        Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Region         : Pointer   );


[PARAMETERS]

X1          Region Left Screen Coordinate
Y1          Region Top Screen Coordinate
X2          Region Right Screen Coordinate
Y2          Region Bottom Screen Coordinate
Region      Pointer to Region Write Data

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutWriteRegion(        Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Region         : Pointer   );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_WriteRegion;
    ODP.X1     := X1;
    ODP.Y1     := Y1;
    ODP.X2     := X2;
    ODP.Y2     := Y2;
    ODP.Region := Region;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutWriteRegion }

{}

(*-

[FUNCTION]

Function  VOutCharRead(           Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD      ) : CHAR;


[PARAMETERS]

X1          X Screen Coordinate
Y1          Y Screen Coordinate

[RETURNS]

Character Read at Screen Coordinates

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)


Function  VOutCharRead(           Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD      ) : CHAR;

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_ReadChar;
    ODP.X1     := X1;
    ODP.Y1     := Y1;

    CallChannel( Chan, @ODP );

    VOutCharRead := ODP.CH;

  END;  { With Chan^ }

END;  { VOutCharRead }

{}

(*-

[FUNCTION]

Function  VOutAttrRead(           Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD      ) : BYTE;


[PARAMETERS]

X1          X Screen Coordinate
Y1          Y Screen Coordinate

[RETURNS]

Attribute Read at Screen Coordinates

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VOutAttrRead(           Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD      ) : BYTE;

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_ReadAttr;
    ODP.X1     := X1;
    ODP.Y1     := Y1;

    CallChannel( Chan, @ODP );

    VOutAttrRead := ODP.Attr;

  END;  { With Chan^ }

END;  { VOutAttrRead }

{}

(*-

[FUNCTION]

Procedure VOutAttrWrite(          Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  Attr           : BYTE      );


[PARAMETERS]

X1          X Screen Coordinate
Y1          Y Screen Coordinate
Attr        Attribute to Write

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutAttrWrite(          Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  Attr           : BYTE      );


BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_WriteAttr;
    ODP.X1     := X1;
    ODP.Y1     := Y1;
    ODP.Attr   := Attr;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutAttrWrite }

{}

(*-

[FUNCTION]

Procedure VOutGetScreenSize(      Chan           : TChanHandle;
                              Var Rows           : BYTE;
                              Var Cols           : BYTE      );

[PARAMETERS]

Rows        VAR Returned Screen Height
Cols        VAR Returned Screen Width

[RETURNS]

Function : None
(VAR     : [Rows] Screen Height)
(VAR     : [Cols] Screen Width)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VOutGetScreenSize(      Chan           : TChanHandle;
                              Var Rows           : BYTE;
                              Var Cols           : BYTE      );


BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_GetScreenSize;

    CallChannel( Chan, @ODP );

    Rows := ODP.Y1;
    Cols := ODP.X1;

  END;  { With Chan^ }

END;  { VOutGetScreenSize }

{}

Procedure VOutCursorUp(           Chan           : TChanHandle;
                                  UpCount        : WORD      );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_CursorUp;
    ODP.Numval := Upcount;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutCursor         }

{}

Procedure VOutCursorDown(         Chan           : TChanHandle;
                                  UpCount        : WORD      );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_CursorDown;
    ODP.Numval := Upcount;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutCursor         }

{}

Procedure VOutCursorLeft(         Chan           : TChanHandle;
                                  UpCount        : WORD      );


BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_CursorLeft;
    ODP.Numval := Upcount;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutCursor         }

{}


Procedure VOutCursorRight(        Chan           : TChanHandle;
                                  UpCount        : WORD      );


BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_CursorRight;
    ODP.Numval := Upcount;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutCursor         }


(*-

[FUNCTION]

Procedure VirtScreenFilter(       ODP            : POutDriverPacket );

[PARAMETERS]

ODP         Pointer to Output Driver Packet

[RETURNS]

(None)

[DESCRIPTION]


[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VirtScreenFilter(       ODP            : POutDriverPacket );

Type

  TCharBuff = Array[1..32768] of CHAR;
  PCharBuff = ^TCharBuff;

  {----}

  TCell = Record

    Char    : CHAR;
    Attr    : BYTE;

  END;  { TCell }

  {----}

  TScreenStore = Array[0..32000] of TCell;

  PScreenStore = ^TScreenStore;

  {----}

  TScreen = RECORD

    CurX      : WORD;
    CurY      : WORD;
    CurAttr   : BYTE;

    WinX1     : WORD;
    WinX2     : WORD;
    WinY1     : WORD;
    WinY2     : WORD;

    CurType   : WORD;

    S         : PScreenStore;

  END;  { TScreen }

  PScreen = ^TScreen;

  {----}

  TVirtScreenFilterIData = Record

    Off        : WORD;
    Name       : TProcName;

    VirtualCRT : BOOLEAN;

    DisplayMode: BYTE;

    Cols       : WORD;
    Rows       : WORD;

    YMult      : WORD;

    NumScreens : BYTE;

    AScreen    : BYTE;

    Screen     : Array[1..8] of TScreen;

    MyODP      : TOutDriverPacket;

  END;  { TVirtScreenFilterIData }

  PVirtScreenFilterIData = ^TVirtScreenFilterIData;

  {----}

  TVirtScreenFilterInfo = RECORD

    Cols    : WORD;
    Rows    : WORD;
    Screens : WORD;

  END;  { TVirtScreenFilterInfo }

  PVirtScreenFilterInfo = ^TVirtScreenFilterInfo;

  MyPByte = ^Byte;
  MyPWord = ^Word;

Var

  IData      : PVirtScreenFilterIData;
  YMult      : WORD;

  AS         : PScreen;

  Z          : INTEGER;
  Z2         : INTEGER;
  Z3         : INTEGER;

  SaveCurX   : WORD;
  SaveCurY   : WORD;

  CallNext   : BOOLEAN;

  {}

  Procedure RegionScroll(         X1,Y1,X2,Y2    : WORD;
                                  Count          : INTEGER   );

  Var

    Z : INTEGER;
    CL: INTEGER;

    P : POINTER;

    NC: TCell;

    Wid : WORD;

  BEGIN


    Wid := (X2-X1)+1;

    NC.Char := ' ';
    NC.Attr := AS^.CurAttr;

    If Count<0 Then
    BEGIN

      { scroll up }

      For CL:=1 to Abs(Count) Do
      BEGIN

        For Z:= Y1 To Y2 Do
        BEGIN

          Move( AS^.S^[ ((Z+1)*YMult)+X1 ],
                AS^.S^[ (Z*YMult)+X1     ],
                Wid*2                         );


        END;  { For Z }

        P := Addr( AS^.S^[ (Y2*YMult)+X1     ] );

        ASM
          LES BX, [p]
          MOV AX, NC
          MOV CX, Wid
          CLD
          REPZ STOSW
        END;

      END; { for cl=1 to count }

    END  { if count<0 }
    ELSE
    BEGIN

      { scroll down/back }

      For CL:=1 to Count Do
      BEGIN

        For Z:= Y2 downTo Y1+1 Do
        BEGIN

          Move( AS^.S^[ ((Z-1)*YMult)+X1 ],
                AS^.S^[ (Z*YMult)+X1     ],
                Wid*2                         );

        END;  { For Z }

        P := Addr( AS^.S^[ (Y1*YMult)+X1     ] );

        ASM
          LES BX, [p]
          MOV AX, NC
          MOV CX, Wid
          CLD
          REPZ STOSW
        END;

      END; { for cl=1 to count }

    END; { if count<0 / else }

  END; { regionscroll }


  {}

  (*-

  [FUNCTION]

  Procedure RegionRead(             X1,Y1,X2,Y2    : WORD;
                                    Region         : PScreenStore );

  [PARAMETERS]

  X1          Source Left Screen Region Coordinate
  Y1          Source Top Screen Region Coordinate
  X2          Source Right Region Screen Region Coordinate
  Y2          Source Bottom Screen Region Coordinate
  Region      Pointer to Region Read Data

  [RETURNS]

  (None)

  [DESCRIPTION]

  Reads a region from the display console to a region store buffer.
  "Region" should be a pointer to a buffer which is big enough to hold
  the region data.  Use RegionMemQuery to determine how many bytes must
  be allocated.

  [SEE-ALSO]

  [EXAMPLE]

  -*)

  Procedure RegionRead(           X1,Y1,X2,Y2    : WORD;
                                  Region         : PScreenStore );
  Var
    Wid  : WORD;
    Z    : INTEGER;

  BEGIN

    Wid := (X2-X1)+1;

    For Z:= Y1 To Y2 Do
    BEGIN

      Move( AS^.S^[ (Z*YMult)+X1 ], Region^[ (Z-Y1)*Wid ], Wid*2 );

    END;  { For Z }

  END;  { RegionRead }

  {}

  (*-

  [FUNCTION]

  Procedure RegionWrite(            X1,Y1,X2,Y2    : WORD;
                                    Region         : PScreenStore );

  [PARAMETERS]

  X1          Left Screen Region Coordinate
  Y1          Top Screen Region Coordinate
  X2          Right Region Screen Region Coordinate
  Y2          Bottom Screen Region Coordinate
  Region      Pointer to Region Write Data

  [RETURNS]

  (None)

  [DESCRIPTION]

  [SEE-ALSO]

  [EXAMPLE]

  -*)

  Procedure RegionWrite(          X1,Y1,X2,Y2    : WORD;
                                  Region         : PScreenStore );

  Var
    Wid  : WORD;
    Z    : INTEGER;

  BEGIN

    Wid := (X2-X1)+1;

    For Z:= Y1 To Y2 Do
    BEGIN

      Move( Region^[ (Z-Y1)*Wid ], AS^.S^[ (Z*YMult)+X1 ], Wid*2 );

    END;  { For Z }

  END;  { RegionWrite }

  {}


  Procedure CursorDown(           Sync           : BOOLEAN   );

  BEGIN

    With AS^ Do
    BEGIN

      Inc( CurY );

      If CurY > WinY2 Then
      BEGIN

        RegionScroll( WinX1,
                      WinY1,
                      WinX2,
                      WinY2,
                      -1        );

        Dec( CurY );

      END;  { If CurY }


    END; { With AS^ }

  END; { CursorDown }

  {}

  Procedure CursorNextChar(       Sync           : BOOLEAN   );

  BEGIN

    With   AS^ Do
    BEGIN

      Inc( CurX );

      If CurX > WinX2 Then
      BEGIN

        CurX := WinX1;

        CursorDown( Sync );

      END;  { If CurX }


    END; { With AS^ }

  END; { CursorNextChar }

  {}

  Procedure SwapCoords( Var A,B : WORD );

  Var
    Temp : WORD;

  BEGIN

    Temp := A;
    A    := B;
    B    := Temp;

  END;  { SwapCoords }

  {}

  Procedure HelpNextGuyScrollUp;

  Var

    P : PScreenStore;

    x1,y1,x2,y2 : INTEGER;

  BEGIN

    x1 := AS^.WinX1;
    y1 := AS^.WinY1;
    x2 := AS^.WinX2;
    y2 := AS^.WinY2;

    { get mem for a region }

    GetMem( P, ((X2-X1)+1)*((Y2-Y1)+1)*2 );

    { read into the region }

    { we dont have to add one because we already scrolled it }

    RegionRead( X1, Y1,
                X2, Y2,
                pointer(p)               );

    { tell next guys to write the region }
    { (offset by one line)               }


    IData^.MyOdp.Func   := ODF_WriteRegion;
    IData^.MyOdp.X1     := X1+1;
    IData^.MyOdp.Y1     := Y1+1;
    IData^.MyOdp.X2     := X2+1;
    IData^.MyOdp.Y2     := Y2;
    IData^.MyOdp.Region := P;

    IData^.MyOdp.NextDriver := ODP^.NextDriver;

    IData^.MyOdp.Status := 0;

    CallNextDriver( @IData^.MyODP );

    { zero out bottom of window, someone!! }

    FreeMem( P, ((X2-X1)+1)*((Y2-Y1)+1)*2 );


    IData^.MyODP.Func   := ODF_ClrEol;
    IData^.MyODP.Status := 0;

    CallNextDriver( @IData^.MyODP );

  END;

  {}

  Procedure SyncRegion( X1,Y1,X2,Y2 : INTEGER );

  Var

    P : PScreenStore;

  BEGIN

    { get the memory }

    GetMem( P, ((X2-X1)+1)*((Y2-Y1)+1)*2 );

    { read into the region }

    RegionRead( X1, Y1,
                X2, Y2,
                pointer(p)               );

    { tell next guys to write the region }

    IData^.MyOdp.Func   := ODF_WriteRegion;
    IData^.MyOdp.X1     := Succ(X1);
    IData^.MyOdp.Y1     := Succ(Y1);
    IData^.MyOdp.X2     := Succ(X2);
    IData^.MyOdp.Y2     := Succ(Y2);
    IData^.MyOdp.Region := P;

    IData^.MyOdp.NextDriver := ODP^.NextDriver;

    IData^.MyOdp.Status := 0;

    CallNextDriver( @IData^.MyODP );

    { free the memory }

    FreeMem( P, ((X2-X1)+1)*((Y2-Y1)+1)*2 );


  END;


  {}

  Procedure MyClrScr;

  Var

   P   : POINTER;
   Z2  : INTEGER;
   Wid : WORD;
   NC  : TCell;

  BEGIN

    With AS^ DO
    BEGIN

      Wid := (WinX2-WinX1)+1;

      NC.Char := ' ';
      NC.Attr := AS^.CurAttr;

      For Z2:=WinY1 to WinY2 Do
      BEGIN

        P := Addr( AS^.S^[ (Z2*YMult)+WinX1     ] );

        ASM
          LES BX, [p]
          MOV AX, NC
          MOV CX, Wid
          CLD
          REPZ STOSW
        END;

      END; { For Z2 (y) }

      CurX := WinX1;
      CurY := WinY1;

    END; { With AS^ }

  END; { myclrscr }

  {}


BEGIN  { CRTOutDriverProc }

  CallNext := TRUE;

  IData := ODP^.ID;

  If ODP^.Func<> ODF_DriverNew Then
  BEGIN

    AS    := @IData^.Screen[ IData^.AScreen ];
    YMult := IData^.YMult;

  END;  { ODP^.Func }

  If ODP^.Status = 0 Then
  BEGIN

    Case ODP^.Func Of

      ODF_DriverNew:
      BEGIN

        IF @ODP^.OutDriverProc = @VirtScreenFilter Then
        BEGIN

          {-------------------------}
          { Get a new Instance Data }
          { master node.            }
          {-------------------------}

          New( Idata );

          { Here we check to see if we are being told to init }
          { as an actual crt driver or as a virtual.  This    }
          { needs to be yanked as this filter can only be     }
          { inited as a virtual! !^!                          }

          If (ODP^.DriverParam1 = 0) or
             (ODP^.DriverParam2 = 0) Then
          BEGIN

            IData^.VirtualCRT := TRUE;

            IData^.Name       := ODP^.Name^;
            IData^.Off        := 0;

            IData^.Cols       := 80;
            IData^.Rows       := 25;
            IData^.NumScreens := 1;

            IData^.YMult      := IData^.Cols;

            {------------------------}
            { Get the Virtual Screen }
            { stores.                }
            {------------------------}

            Z := (IData^.Cols) * (IData^.Rows) * SizeOf( TCell );

            For Z2 := 1 to IData^.NumScreens Do
            BEGIN
              GetMem( IData^.Screen[Z2].S, Z );

              IData^.Screen[Z2].CurX    := 0;
              IData^.Screen[Z2].CurY    := 0;
              IData^.Screen[Z2].CurAttr := $07;
              IData^.Screen[Z2].WinX1   := 0;
              IData^.Screen[Z2].WinY1   := 0;
              IData^.Screen[Z2].WinX2   := Idata^.Cols-1;
              IData^.Screen[Z2].WinY2   := Idata^.Rows-1;
              IData^.Screen[Z2].CurType := 0;
            END;

            {-----------------------}
            { Set the active screen }
            {-----------------------}

            IData^.AScreen := 1;

            {--------}
            { Return }
            {--------}

            ODP^.Status := ODS_Install+ODS_Changed;
            ODP^.ID     := IData;

          END  { If ODP^.Driverinfo }

          ELSE
          BEGIN

            {-------------------------------------------}
            { DriverData --> virtual CRT driverinfo, so }
            { we allocate virtual screen stores and     }
            { run in virtual CRT mode.                  }
            {-------------------------------------------}

            IData^.VirtualCRT := TRUE;

            IData^.Name       := ODP^.Name^;
            IData^.Off        := 0;

            IData^.Cols       := PVirtScreenFilterInfo( ODP^.DriverParam2 )^.Cols;
            IData^.Rows       := PVirtScreenFilterInfo( ODP^.DriverParam2 )^.Rows;
            IData^.NumScreens := PVirtScreenFilterInfo( ODP^.DriverParam2 )^.Screens;

            IData^.YMult      := IData^.Cols;

            {------------------------}
            { Get the Virtual Screen }
            { stores.                }
            {------------------------}

            Z := (IData^.Cols) * (IData^.Rows) * SizeOf( TCell );

            For Z2 := 1 to IData^.NumScreens Do
            BEGIN
              GetMem( IData^.Screen[Z2].S, Z );

              IData^.Screen[Z2].CurX    := 1;
              IData^.Screen[Z2].CurY    := 1;
              IData^.Screen[Z2].CurAttr := $07;
              IData^.Screen[Z2].WinX1   := 1;
              IData^.Screen[Z2].WinY1   := 1;
              IData^.Screen[Z2].WinX2   := Idata^.Cols;
              IData^.Screen[Z2].WinY2   := Idata^.Rows;
              IData^.Screen[Z2].CurType := 0;
            END;

            {-----------------------}
            { Set the active screen }
            {-----------------------}

            IData^.AScreen := 1;

            {--------}
            { Return }
            {--------}

            ODP^.Status := ODS_Install+ODS_Changed;
            ODP^.ID     := IData;

          END; {IF ODP^.Driverinfo / Else }

        END; { If ODP^.OutDriverProc --> Us }

      END; { ODF_DriverNew }

      {----}

      ODF_DriverOff:
      BEGIN

        If ODP^.Name^ = IData^.Name Then
        BEGIN

          Inc( Idata^.Off );

        END;  { If ODP^.Name^ }

      END;  { ODF_DriverOff }

      {----}

      ODF_DriverOn:
      BEGIN

        If ODP^.Name^ = IData^.Name Then
        BEGIN

          If Idata^.Off <> 0 Then
            Dec( Idata^.Off );

        END;  { ODP^.Name^ }

      END;  { ODF_DriverOn }

      {----}

      ODF_DriverDispose:
      BEGIN

        If ODP^.Name^ = IData^.Name Then
        BEGIN

          {RemoveFromOutDriverStack }

          Dispose( IData );

        END;  { If ODP^.Name^ }

      END;  { ODF_DriverDispose }

      {----}

      ODF_WriteChar:
      BEGIN

        With AS^ Do
        BEGIN

          Case ODP^.Ch Of

            #13:
            BEGIN

              CurX := WinX1;

            END;  { #13 }

            #10:
            BEGIN

              CursorDown( TRUE );

            END;  { #10 }

          Else

            S^[ (CurY*YMult)+CurX ].Char := ODP^.CH;
            S^[ (CurY*YMult)+CurX ].Attr := CurAttr;

            CursorNextChar( TRUE );

          END;  { Case ODP^.Ch }

        END; { With AS^ }

        CallNextDriver( ODP );

        If (ODP^.Status    = ODS_CantDo          ) and
           (ODP^.StatusMsg = ODS_MsgNeedScrollUp ) Then
          HelpNextGuyScrollUp;

        CallNext := FALSE;

      END;  { ODF_WriteChar }

      {----}

      ODF_WriteBlock:
      BEGIN

        With AS^ DO
        BEGIN

          For Z:=ODP^.Start to ODP^.Size Do
          BEGIN

            Case PCharBuff( ODP^.Buff)^[Z] Of

              #13:
              BEGIN

                CurX := WinX1;

                CursorDown( TRUE );

              END;  { #13 }

              #10: {do nothing, man} ;

            Else

              S^[ (CurY*YMult)+CurX ].Char := PCharBuff( ODP^.Buff )^[Z];
              S^[ (CurY*YMult)+CurX ].Attr := CurAttr;

              CursorNextChar( TRUE );

            END;  { Case PCharBuff( ODP^.Buf)^[Z] }

          END; { For Z }

        END; { With AS^ }

        Repeat
          ODP^.Status := 0;

          CallNextDriver( ODP );

          If (ODP^.Status    = ODS_CantDo          ) and
             (ODP^.StatusMsg = ODS_MsgNeedScrollUp ) Then
            HelpNextGuyScrollUp;

        Until ODP^.Start=ODP^.Size;

        CallNext := FALSE;

      END;  { ODF_WriteBlock }

      {----}

      ODF_WriteVert:
      BEGIN

        With AS^ DO
        BEGIN

          For Z:=1 to ODP^.Size Do
          BEGIN

            S^[ (CurY*YMult)+CurX ].Char := PCharBuff( ODP^.Buff )^[Z];
            S^[ (CurY*YMult)+CurX ].Attr := CurAttr;

            CursorDown( TRUE );

          END;  { For Z }

        END; { With AS^ }

      END;  { ODF_WriteVert }

      {----}

      ODF_WriteCharAt:
      BEGIN

        With AS^ Do
        BEGIN

          S^[ (Pred(ODP^.Y1)*YMult)+Pred(ODP^.X1) ].Char := ODP^.CH;

          S^[ (Pred(ODP^.Y1)*YMult)+Pred(ODP^.X1) ].Attr :=
                                                         ODP^.Attr;

                                            {CRTColorMap[ ODP^.Attr ];}

        END; { With AS^ }

      END;  { ODF_WriteCharAt }

      {----}

      ODF_WriteBlockAt:
      BEGIN

        With AS^ DO
        BEGIN

          SaveCurX := CurX;
          SaveCurY := CurY;

          For Z:=1 to ODP^.Size Do
          BEGIN

            S^[ (Pred(ODP^.Y1)*YMult)+ODP^.X1+Z-2].Char :=
                                        PCharBuff( ODP^.Buff )^[Z];

            S^[ (Pred(ODP^.Y1)*YMult)+ODP^.X1+Z-2].Attr :=
                                                          ODP^.Attr
                                            {CRTColorMap[ ODP^.Attr ];}

          END; { For Z }

        END; { With AS^ }

      END;  { ODF_WriteBlockAt }

      {----}

      ODF_WriteVertAt:
      BEGIN

        With AS^ DO
        BEGIN

          For Z:=1 to ODP^.Size Do
          BEGIN

            S^[ ((ODP^.Y1+Z-2)*YMult)+Pred(ODP^.X1) ].Char :=
                                        PCharBuff( ODP^.Buff )^[Z];

            S^[ ((ODP^.Y1+Z-2)*YMult)+Pred(ODP^.X1) ].Attr :=
                                                      ODP^.Attr;
                                        {CRTColorMap[ ODP^.Attr ];}

          END;  { For Z }

        END; { With AS^ }

      END;  { ODF_WriteVertAt }

      {----}

      ODF_ClrEOL:
      BEGIN

        With AS^ DO
        BEGIN

          For Z:=CurX to WinX2 Do
          BEGIN

            S^[ (CurY*YMult)+Z ].Char := ' ';
            S^[ (CurY*YMult)+Z ].Attr := CurAttr;

          END;  { For Z }

          { Cursor to next line? }

        END; { With AS^ }

      END;  { ODF_ClrEOL }

      {----}

      ODF_ClrScr:
      BEGIN

        MyClrScr;


      END;  { ODF_ClrScr }

      {----}

      ODF_DelLine:
      BEGIN

        With AS^ Do
        BEGIN

          RegionScroll( WinX1,
                        CurY,
                        WinX2,
                        WinY2,
                        -1         );

          { Cursor to WinX1?? }

        END;  { With AS^ }

      END;  { ODF_DelLine }

      {----}

      ODF_InsLine:
      BEGIN

        With AS^ Do
        BEGIN

          RegionScroll( WinX1,
                        CurY,
                        WinX2,
                        WinY2,
                        1         );

          { Cursor to WinX1?? }

        END;  { With AS^ }

      END;  { ODF_InsLine }

      {----}

      ODF_GotoXY:
      BEGIN

        With AS^Do
        BEGIN

          CurX := WinX1+(ODP^.X1-1);
          CurY := WinY1+(ODP^.Y1-1);


        END;  { With AS^ }

      END;  { ODF_GotoXY }

      {----}

      ODF_Window:
      BEGIN

        With AS^ Do
        BEGIN

          WinX1 := ODP^.X1-1;
          WinY1 := ODP^.Y1-1;
          WinX2 := ODP^.X2-1;
          WinY2 := ODP^.Y2-1;

          If WinX2<WinX1 Then SwapCoords( WinX1, WinX2 );
          If WinY2<WinY1 Then SwapCoords( WinY1, WinY2 );

          CurX  := WinX1;
          CurY  := WinY1;


          { call visionix services to set window coords }

        END;  { With AS^ }

      END;  { ODF_Window }

      {----}

      { 7 6 5 4 3 2 1 0 }
      { F B B B T T T T }

      ODF_ColorText:
      BEGIN

        With AS^ Do
        BEGIN

          CurAttr := (CurAttr AND $F0) + (ODP^.TheColor AND $0F);

        END;  { With AS^ }

      END;  { ODF_ColorText }

      {----}

      ODF_ColorBack:
      BEGIN

        With AS^ Do
        BEGIN

          CurAttr := (CurAttr AND $0F) + ((ODP^.TheColor AND $07) SHL 4);

        END;  { With AS^ }

      END;  { ODF_ColorBack }

      {----}

      ODF_GetWin:
      BEGIN

        With AS^ Do
        BEGIN

          ODP^.X1 := WinX1+1;
          ODP^.Y1 := WinY1+1;
          ODP^.X2 := WinX2+1;
          ODP^.Y2 := WinY2+1;

          ODP^.Status := ODS_Changed;

        END;  { With AS^ }

      END;  { ODF_GetWin }

      {----}

      ODF_GetAttr:
      BEGIN

        ODP^.Attr   := AS^.CurAttr;

        ODP^.Status := ODS_Changed;

      END;  { ODF_GetAttr }

      {----}

      ODF_SetAttr:
      BEGIN

        AS^.CurAttr := ODP^.Attr;

      END;  { ODF_SetAttr }

      {----}

      ODF_GetXY:
      BEGIN

        ODP^.X1 := (AS^.CurX+1)-AS^.WinX1;
        ODP^.Y1 := (AS^.CurY+1)-AS^.WinY1;

        ODP^.Status := ODS_Changed;

      END;  { ODF_GetXY }

      {----}

      ODF_GetNumScreens:
      BEGIN

        ODP^.Screens := IData^.NumScreens;

        ODP^.Status  := ODS_Changed;

      END;  { ODF_GetNumScreens }

      {----}

      ODF_GoScreen:
      BEGIN

        If ODP^.Screens <= IData^.NumScreens Then
          IData^.AScreen := ODP^.Screens;

      END;  { ODF_GoScreen }

      {----}

      ODF_SetCursorType:
      BEGIN


        { AS^.CurType :=  }

      END;  { ODF_SetCursorType }

      {----}


      ODF_DrawVLine:
      BEGIN

      END;  { ODF_DrawVLine }

      {----}

      ODF_DrawHLine:
      BEGIN

      END;  { ODF_DrawHLine }

      {----}

      ODF_DrawBox:
      BEGIN

      END;  { ODF_DrawBox }

      {----}

      ODF_ReadChar:
      BEGIN

        ODP^.CH := AS^.S^[ (Pred(ODP^.Y1)*YMult)+Pred(ODP^.X1) ].Char;

        ODP^.Status := ODS_Changed;

        CallNext := FALSE;

      END;  { ODF_ReadChar }

      {----}

      ODF_ReadAttr:
      BEGIN

        ODP^.Attr := AS^.S^[ (Pred(ODP^.Y1)*YMult)+ODP^.X1-1 ].Attr;

        ODP^.Status := ODS_Changed;

        CallNext := FALSE;

      END;  { ODF_ReadAttr }

      {----}

      ODF_WriteAttr:
      BEGIN

        AS^.S^[ (Pred(ODP^.Y1)*YMult)+ODP^.X1-1 ].Attr :=
                                                           ODP^.Attr;
                                             {CRTColorMap[ ODP^.Attr ];}

        CallNextDriver( ODP );

        {--------------------------------------}
        { can the rest of 'em do a write attr? }
        {--------------------------------------}

        If ODP^.Status=ODS_CantDo Then
        BEGIN

          { rewrite the cell by using the "region write" func }

          IData^.MyODP.Func := ODF_WriteRegion;

          IData^.MyODP.X1 := ODP^.X1;
          IData^.MyODP.Y1 := ODP^.Y1;
          IData^.MyODP.X2 := ODP^.X1;
          IData^.MyODP.Y2 := ODP^.Y1;

          IData^.MyODP.NextDriver := ODP^.NextDriver;

          IData^.MyODP.Region :=
                      Addr( AS^.S^[ (Pred(ODP^.Y1)*YMult)+ODP^.X1-1 ] );

          IData^.MyODP.Status := 0;

          CallNextDriver( @IData^.MyODP );

          ODP^.Status := 0;

        END;

        CallNext := FALSE;


      END;  { ODF_WriteAttr }

      {----}


      ODF_QueryRegion:
      BEGIN

        ODP^.RegionSize := ((ODP^.Y2-ODP^.Y1)+1)*((ODP^.X2-ODP^.X1)+1)*2;

      END;  { ODF_QueryRegion }

      {----}


      ODF_ReadRegion:
      BEGIN

        If ODP^.Status AND ODS_Changed=0 Then

          RegionRead( Pred(ODP^.X1), Pred(ODP^.Y1),
                      Pred(ODP^.X2), Pred(ODP^.Y2), ODP^.Region );

        ODP^.Status := ODS_Changed;

        CallNext := FALSE;

      END;  { ODF_ReadRegion }

      {----}

      ODF_WriteRegion:
      BEGIN

        RegionWrite( ODP^.X1-1, ODP^.Y1-1,
                     ODP^.X2-1, ODP^.Y2-1, ODP^.Region );

      END;  { ODF_WriteRegion }

      {----}


      ODF_DriverRenew:
      BEGIN

      END;  { ODF_DriverRenew }

      {----}

      ODF_CursorUp:
      BEGIN

        With AS^Do
        BEGIN
(*
          If (CurY-ODP^.Numval) >= WinY1 Then
            Dec( CurY, ODP^.NumVal )
          Else
            CurY := WinY1;
*)

          For Z:=1 to ODP^.NumVal Do
            If CurY>WinY1 Then
              Dec(CurY);



        END;  { With AS^ }

      END;  { ODF_CursorUp }

     {----}

      ODF_CursorDown:
      BEGIN

        With AS^Do
        BEGIN
(*
          If (CurY+ODP^.Numval) <= WinY2 Then
            Inc( CurY, ODP^.NumVal )
          Else
            CurY := WinY2;
*)
          For Z:=1 to ODP^.NumVal Do
            If CurY<WinY2 Then
              Inc(CurY);


        END;  { With AS^ }

      END;  { ODF_CursorDown }

    {----}

      ODF_CursorLeft:
      BEGIN

        With AS^ Do
        BEGIN
(*
          If (CurX-ODP^.Numval) >= WinX1 Then
            Dec( CurY, ODP^.NumVal )
          Else
            CurX := WinX1;
*)

          For Z:=1 to ODP^.Numval Do
            If CurX>WinX1 Then
              Dec(CurX);



        END;  { With AS^ }

      END;  { ODF_CursorLeft }

     {----}

      ODF_CursorRight:
      BEGIN

        With AS^Do
        BEGIN
(*
          If (CurX+ODP^.NumVal) <= WinX2 Then
            Inc( CurX, ODP^.NumVal )
          Else
            CurY := WinX2;
*)
          For Z:=1 to ODP^.Numval Do
            If CurX<WinX2 Then
              Inc(CurX);



        END;  { With AS^ }

      END;  { ODF_CursorRight }

     {----}

      ODF_RegionScrUp:
      BEGIN

        RegionScroll( Pred(ODP^.X1), Pred(ODP^.Y1),
                      Pred(ODP^.X2), Pred(ODP^.Y2),
                      ODP^.NumVal         );

      END;  { ODF_RegionScrUp }

     {----}

      ODF_RegionScrDown:
      BEGIN

        RegionScroll( Pred(ODP^.X1), Pred(ODP^.Y1),
                      Pred(ODP^.X2), Pred(ODP^.Y2),
                      0-ODP^.NumVal         );

      END;  { ODF_RegionScrDown }

     {----}

      ODF_RegionCopy:
      BEGIN

      END;  { ODF_RegionCopy }

     {----}

      ODF_RegionFill:
      BEGIN

        With AS^ DO
        BEGIN

          For Z2:=Pred(ODP^.Y1) to Pred(ODP^.Y2) Do
          BEGIN

            For Z:=Pred(ODP^.X1) to Pred(ODP^.X2) Do
            BEGIN

              S^[ (Z2*YMult)+Z ].Char := ODP^.CH;
              S^[ (Z2*YMult)+Z ].Attr := ODP^.Attr;

            END; { For Z (x) }

          END; { For Z2 (y) }

        END; { With AS^ }

      END;  { ODF_RegionFill }

     {----}

      ODF_RegionFillA:
      BEGIN

        With AS^ DO
        BEGIN

          For Z2:=Pred(ODP^.Y1) to Pred(ODP^.Y2) Do
          BEGIN

            For Z:=Pred(ODP^.X1) to Pred(ODP^.X2) Do
            BEGIN

              S^[ (Z2*YMult)+Z ].Attr := ODP^.Attr;

            END; { For Z (x) }

          END; { For Z2 (y) }

        END; { With AS^ }

        CallNextDriver( ODP );

        If (ODP^.Status    = ODS_CantDo          ) and
           (ODP^.StatusMsg = ODS_MsgNoScreenBuff ) Then
        BEGIN

          SyncRegion( Pred(ODP^.X1), Pred(ODP^.Y1),
                      Pred(ODP^.X2), Pred(ODP^.Y2)  );

        END;

        CallNext := FALSE;

      END;  { ODF_RegionFillA }

     {----}

      ODF_RegionFillC:
      BEGIN

        With AS^ DO
        BEGIN

          For Z2:=Pred(ODP^.Y1) to Pred(ODP^.Y2) Do
          BEGIN

            For Z:=Pred(ODP^.X1) to Pred(ODP^.X2) Do
            BEGIN

              S^[ (Z2*YMult)+Z ].Char := ODP^.CH;

            END; { For Z (x) }

          END; { For Z2 (y) }

        END; { With AS^ }

        CallNextDriver( ODP );

        If (ODP^.Status    = ODS_CantDo          ) and
           (ODP^.StatusMsg = ODS_MsgNoScreenBuff ) Then
        BEGIN

          SyncRegion( Pred(ODP^.X1), Pred(ODP^.Y1),
                      Pred(ODP^.X2), Pred(ODP^.Y2)  );

        END;

        CallNext := FALSE;

      END;  { ODF_RegionFillC }

     {----}

      ODF_RepeatChar:
      BEGIN

        With AS^ Do
        BEGIN

          IF (ODP^.CH<>#13) and (ODP^.CH<>#10) Then
          BEGIN

            For Z:=1 to ODP^.NumVal Do
            BEGIN

              S^[ (CurY*YMult)+CurX ].Char := ODP^.CH;
              S^[ (CurY*YMult)+CurX ].Attr := CurAttr;

              CursorNextChar( FALSE );

            END;  { For Z }


          END;  { If ODP^.Ch }

        END; { With AS^ }

      END;  { ODF_RepeatChar }

     {----}

      ODF_RepeatCharAt:
      BEGIN

        With AS^ DO
        BEGIN

          SaveCurX := CurX;
          SaveCurY := CurY;

          For Z:=1 to ODP^.NumVal Do
          BEGIN

            S^[ (Pred(ODP^.Y1)*YMult)+ODP^.X1+Z-2].Char := ODP^.CH;

            S^[ (Pred(ODP^.Y1)*YMult)+ODP^.X1+Z-2].Attr :=
                                                         ODP^.Attr;
                                            {CRTColorMap[ ODP^.Attr ];}

          END; { For Z }

        END; { With AS^ }

      END;  { ODF_RepeatCharAt }

     {----}

      ODF_GetScreenSize:
      BEGIN

        With AS^ Do
        BEGIN

          ODP^.X1 := IData^.Cols;
          ODP^.Y1 := Idata^.Rows;

        END;  { With AS^ }

      END;  { ODF_GetScreenSize }

     {----}

      ODF_RepeatBlock:
      BEGIN

        With AS^ DO
        BEGIN

          Z3 := ODP^.Start;

          For Z2:=1 to ODP^.NumVal Do
          BEGIN

            For Z:=Z3 to ODP^.Size Do
            BEGIN

              Case PCharBuff( ODP^.Buff)^[Z] Of

                #13:
                BEGIN

                  CurX := WinX1;

                  CursorDown( TRUE );

                END;  { #13 }

                #10: {do nothing, man} ;

              Else

                S^[ (CurY*YMult)+CurX ].Char := PCharBuff( ODP^.Buff )^[Z];
                S^[ (CurY*YMult)+CurX ].Attr := CurAttr;

                CursorNextChar( TRUE );

              END;  { Case PCharBuff( ODP^.Buf)^[Z] }

            END; { For Z }

            Z3 := 1;

          END; { for Z2 }

        END; { With AS^ }


        { for each repeat }

        While ODP^.NumVal>0 Do
        BEGIN

          Repeat
            ODP^.Status := 0;

            CallNextDriver( ODP );

            If (ODP^.Status    = ODS_CantDo          ) and
               (ODP^.StatusMsg = ODS_MsgNeedScrollUp ) Then
              HelpNextGuyScrollUp;

          Until ODP^.Start=ODP^.Size;

          { Dec( ODP^.NumVal ); }

        END; { while }

        ODP^.Start := ODP^.Size;

        CallNext := FALSE;

      END;  { ODF_RepeatBlock }

     {----}

      ODF_RepeatBlockAt:
      BEGIN

        With AS^ DO
        BEGIN

          SaveCurX := CurX;
          SaveCurY := CurY;

          For Z:=1 to ODP^.NumVal Do
          BEGIN

            S^[ (Pred(ODP^.Y1)*YMult)+ODP^.X1+Z-2].Char := ODP^.CH;

            S^[ (Pred(ODP^.Y1)*YMult)+ODP^.X1+Z-2].Attr :=
                                                         ODP^.Attr;
                                            {CRTColorMap[ ODP^.Attr ];}

          END; { For Z }

        END; { With AS^ }

      END;  { ODF_RepeatCharAt }


     {----}
     {----}

    Else { Else Case }

    END;  { Case ODP^.Func }

  END; { If ODP^.Status = 0 }

  If CallNext Then
    CallNextDriver( ODP );

END;  { VirtScreenFilter }

{}


Procedure VOutFillRegion(         Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Attr           : BYTE;
                                  Ch             : CHAR      );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_RegionFill;
    ODP.X1     := X1;
    ODP.Y1     := Y1;
    ODP.X2     := X2;
    ODP.Y2     := Y2;
    ODP.Ch     := CH;
    ODP.Attr   := Attr;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }


END;

{}


Procedure VOutFillRegionAttr(     Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Attr           : BYTE       );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_RegionFillA;
    ODP.X1     := X1;
    ODP.Y1     := Y1;
    ODP.X2     := X2;
    ODP.Y2     := Y2;
    ODP.Attr   := Attr;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;

{}


Procedure VOutFillRegionChar(     Chan           : TChanHandle;
                                  X1             : WORD;
                                  Y1             : WORD;
                                  X2             : WORD;
                                  Y2             : WORD;
                                  Ch             : CHAR      );

BEGIN

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_RegionFillC;
    ODP.X1     := X1;
    ODP.Y1     := Y1;
    ODP.X2     := X2;
    ODP.Y2     := Y2;
    ODP.Ch     := CH;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;  { VOutCursor         }

END;

{}

Procedure VOutRepeatBlock(        Chan           : TChanHandle;
                                  RepeatCount    : WORD;
                                  Block          : Pointer;
                                  Size           : WORD      );


BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_RepeatBlock;
    ODP.NumVal := RepeatCount;
    ODP.Start  := 1;
    ODP.Size   := Size;
    ODP.Buff   := Block;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }

END;

{}

Procedure VOutRepeatString(       Chan           : TChanHandle;
                                  RepeatCount    : WORD;
                                  S              : STRING    );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_RepeatBlock;
    ODP.NumVal := RepeatCount;
    ODP.Start  := 1;
    ODP.Size   := Byte(S[0]);
    ODP.Buff   := @S[1];

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }


END;

{}

Procedure VOutFlush(              Chan           : TChanHandle );

BEGIN

  With Chan^ Do
  BEGIN

    ODP.Func   := ODF_FlushBuffers;

    CallChannel( Chan, @ODP );

  END;  { With Chan^ }


END;

{}
{}
{}

BEGIN


END.


