{
 

 Visionix Resource File (VRESFILE)
   Version 0.7
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 File text retrieving library.  This unit provides the ability to use an
 external text file for all text.  This is so that programs being supplied
 to non-English countries may modify the text to their native language.
 Also, this provides a method of automating the creation of basic menus -
 all data provided in the .VRF file.

 

 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 jrt       11/20/93  Added IFDEF VUI around code that requires
                     the vuiwinu types.  This allows this unit
                     to be used without VUI.

 rob       08/31/93  Added VRF_NewInMem, Reads a VRF from memory.

 jrt       08/2?/93  Added code for reading the VRF at the end of an
                     EXE file.

 jrt       05/06/93  Added code to support hiercheral sections,
                     addded maxlines paramater to VRF_New,
                     added VRF_ChangeSection as part of section mods,
                     added VRF_GetView, VRF_GetBoolean, VRF_GetReal,
                     moved vrf info from local data segment to
                     TVRF rec which is allocated from the heap.

 lpg       03/15/93  Added Source Documentation

 jrt       04/08/93  Cleaned up code to use VGEN functions;
                     (GetParamName, etc)
                     Added code to do indexing.  Don't ask about
                     the indexing algorithym.

 mep       02/11/93  Cleaned up code for beta release

 jrt       11/21/92  Sync with beta 0.08

 jrt       09/29/92  Converted function names to new format;
                     Added VRF_GetInt; cleaned up, etc. etc.

 jrt       09/01/92  First logged revision.

 
}

(*-

[TEXT]

<About this unit>

This is a text-based resoure retrieval library.

This unit provides the ability to use an external text file for all text,
integers, reals, menus, dialogs, colors, and boolean values used by a
program.


<<ALL EXAMPLES ASSUME A RESOURCE FILE AS FOLLOWS>>

File Name: PROGRAM.VRF

---FILE BEGIN---

MENU_BEGIN "Sector Menu"
  "Read Sector      "
  "Write Sector     "
  "View/Edit Sector "
  KEYS = "RWV"
  ROWS = 5
  COLS = 1
  FORE = White
  BACK = Cyan
  MESG = "Select Action|<ESC>=Abort"
MENU_END

DIALOG_BEGIN "Out of Range"
  "[Sorry but that Entry is out of Range.|Please Try Again.]"
  TYPE = "[1]"
  OPTS = "OK"
DIALOG_END

DIALOG_BEGIN "AbortRetry Dialog"
  "[Error in Operation.||Please Select Action.]"
  TYPE = "[1]"
  OPTS = "[Abort|Retry|Ignore|Fail]"
  KEYS = "ARIF"
DIALOG_END

TEXT "Program Name" = "Sector Edit Program, Ver 1.0"

TEXT "DevName"      = "Device Name   :"
TEXT "TotBlks"      = "Total Sectors :"

TEXT "BPS"          = "Bytes Per Sector    :"
TEXT "SPC"          = "Sectors Per Cluster :"
TEXT "CPD"          = "Clusters Per Drive  :"

TEXT "EnterBlk"     = "Enter Sector to Load"

TEXT "PressKey"     = "Press any key to Continue"

TEXT "Reading"      = "Reading Sector.  One Moment..."
TEXT "Writing"      = "Writing Sector.  One Moment..."
TEXT "View/Edit"    = "Use Arrow Keys to Scroll|<ESC> to Quit"
TEXT "NoMessage"    = " "
TEXT "CurrInfo"     = "Drive : %D     Current Sector : %S"

TEXT "GB"           = "Thousand Bytes"
TEXT "KB"           = "KiloByte"
TEXT "MB"           = "MegaByte"

TEXT "Block"        = "Sector"

INTEGER "One"       = 1
INTEGER "Ten"       = 10
INTEGER "Hundred"   = 100
INTEGER "Thousand"  = 1000

INTEGER "Byte"      = 256

INTEGER "SectSize"  = 256
INTEGER "BlkSize"   = 512
INTEGER "ClustSize" = 2048
INTEGER "DrvSize"   = 20

INTEGER "Kilo"      = 1024
INTEGER "Meg"       = 1048576

COLOR "Black"       = 0
COLOR "Blue"        = 1
COLOR "Green"       = 2
COLOR "Cyan"        = 3
COLOR "Red"         = 4
COLOR "Magenta"     = 5
COLOR "Brown"       = 6
COLOR "Lt Gray"     = 7
COLOR "Dk Gray"     = 8
COLOR "Lt Blue"     = 9
COLOR "Lt Green"    = 10
COLOR "Lt Cyan"     = 11
COLOR "Lt Red"      = 12
COLOR "Lt Magenta"  = 13
COLOR "Yellow"      = 14
COLOR "White"       = 15

---FILE END---

-*)

Unit VResFu;

Interface

Uses

  VTypesu,
  VStringu,
  VGenu,
  VTextu,
{$IFDEF VUI}
  VUIWinu,
{$ENDIF}
  VDOSHu;

{}

Procedure VRF_New(                     FName     : ST80;
                                       NMaxLines : INTEGER      );

Procedure VRF_NewInMem(    P         : Pointer;
                           Size      : Word;
                           NMaxLines : INTEGER   );

Procedure VRF_ChangeSection(           Sec        : STRING );

{$IFDEF VUI}

Procedure VRF_GetMenu(                 ID         : ST80;
                                   Var Menu       : TMenu;
                                   Var Keys       : ST80;
                                   Var NumChoices : INTEGER;
                                   Var Rows       : INTEGER;
                                   Var Cols       : INTEGER;
                                   Var FC         : INTEGER;
                                   Var BC         : INTEGER;
                                   Var Message    : ST80     );

Function  VRF_DoMenu(                  Opts      : ST80;
                                       ID        : ST80;
                                       X         : INTEGER;
                                       Y         : INTEGER;
                                       FC        : INTEGER;
                                       BC        : INTEGER   ) : INTEGER;

Function  VRF_DoMenu_Kill(             Opts      : ST80;
                                       ID        : ST80;
                                       X         : INTEGER;
                                       Y         : INTEGER;
                                       FC        : INTEGER;
                                       BC        : INTEGER   ) : INTEGER;

Function  VRF_GetDialog(               ID        : ST80      ) : STRING;

Procedure VRF_GetView(                 ID        : ST80;
                                   Var Menu      : TMenu;
                                   Var Lines     : INTEGER   );


{$ENDIF} { ifdef vui }

Function  VRF_GetText(                 ID        : ST80      ) : STRING;



Function  VRF_GetInt(                  ID        : ST80      ) : LONGINT;

Function  VRF_GetBoolean(              ID        : ST80      ) : BOOLEAN;


Function  VRF_GetReal(                 ID        : ST80      ) : REAL;

Function  VRF_GetColorNum(             ID        : ST80      ) : BYTE;

Procedure VRF_Dispose;

{}

Implementation


{$IFDEF VUI}
Uses

  VCRTu,
  VUIwidgu;
{$ELSE}
Uses

  VCRTu;

{$ENDIF}


Type

  TArrayPStr = Array[1..1] of PSTRING;

  PArrayPStr = ^TArrayPStr;

  TVRF = RECORD

    IndexText     : Array[1..600     ] of PSTRING;
    IndexAt       : Array[1..600     ] of INTEGER;
    IndexLines    : INTEGER;
    LastStartLine : INTEGER;

    CurSec        : STRING;

    MenuText      : PArrayPStr;
    NumLines      : INTEGER;

    MaxLines      : INTEGER;

  END;

  PVRF = ^TVRF;

Var

  avrf          : PVRF;


{}

Function GetHeapString( P : POINTER ) : STRING;

BEGIN

  GetHeapString :=  VStrGet( P );

END;


(*-

[FUNCTION]

Procedure VRF_Error(                     S         : ST80      );

[PARAMETERS]

S           Resource File Error Message

[RETURNS]

(None)

[DESCRIPTION]

Takes the Provided Resource File Error Message and Displays it in the top
ONLEFT of the Screen.  Then Shuts down the Program.

[SEE-ALSO]

[EXAMPLE]

BEGIN

  WriteLn( 'About to Call VRF_Error...' );

  VRF_Error( 'Could not find Menu Item' );  { HALTS HERE }

  WriteLn( 'Should have never gotten here!' );

END;

-*)

Procedure VRF_Error(                     S         : ST80      );

BEGIN

{$IFDEF VUI}
  WGemMsgBox( '[4][Pardon me, but the following|'+
                  'resource file error occurred:||' +
                  S +
                  '|This program is stopping.][Sorry ]' );

  WClose;

{$ELSE}
  WriteStringAt( 1,1,
                 white, black,
                 'ResFile Error: '+S+'--Program Exiting.' );

{$ENDIF}


  Halt( 1 );

END;  { VRF_Error }

{}

(*-

[FUNCTION]

Function GetStartLine(                 ID        : ST80      ) : INTEGER;

[PARAMETERS]

ID          Resource File Item ID Name to search for

[RETURNS]

The Indexed Line Number which this Item ID Name represents.

[DESCRIPTION]

Takes the Item ID Name and searches the Pre-Loaded Resource File Data
until it either finds this item or fails to.  If it is found then the
Line Index Number is returned.

If not, then this is an Error Condition though nothing happens.

[SEE-ALSO]

[EXAMPLE]

{NOTE: All Examples use Above Demo Resource File}

BEGIN

  WriteLn( 'Found at Line ',GetStartLine( 'Blue' ) );

  { Should have Found this ID on Line x of the example Resource File }

END;

-*)

Function GetStartLine(                 ID        : ST80      ) : INTEGER;

Var

  Z   : INTEGER;
  SLS : INTEGER;

  S   : ST80;

BEGIN

  With AVRF^ Do
  BEGIN

    { fixup ID to include section name }

    If ID[1]<>'\' Then
      Insert( CurSec, ID, 1 );


    Z := LastStartLine-1;

    Repeat
      Inc( Z );
      S := GetHeapString( IndexText[Z] );
    Until ( Z > IndexLines ) or
          ( S = ID );



    IF Z > IndexLines Then
    BEGIN

      Z:=0;
      Repeat
        Inc( Z );
      Until ( Z > LastStartLine ) or
            ( GetHeapString( IndexText[Z] ) = ID );

      If Z > LastStartLine Then
        Z := NumLines+1;

    END;

    GetStartLine := IndexAt[Z];

  END; {with}

END;  { GetStartLine }

{}

(*-

[FUNCTION]

Procedure VRF_New(                     FName     : ST80      );

[PARAMETERS]

FName       Resource File to Load

[RETURNS]

(None)

[DESCRIPTION]

Reads the Resource File Data from the given File Name and Loads all
the Data in RAM for Quick Access.

[SEE-ALSO]

[EXAMPLE]

{NOTE: All Examples use Above Demo Resource File}

Uses VGen,VWinHigh,VResFile;

VAR
  I : INTEGER;

BEGIN

  WOpen( '',BLACK,BLUE,'CLOCK' );
  VRF_New( 'PROGRAM.MNU' );

  I := WGemDialogBox( VRF_GetDialog( 'AbortRetry' ) );

  WMessage( 'Selection : ' + IntToStr(i) + '|' + VRF_GetText('PressKey'),
            WHITE,CYAN );
  While NOT WKeyPressed Do;

  WDispose;
  WClose;

END;

-*)

Procedure VRF_New(                     FName     : ST80;
                                       NMaxLines : INTEGER      );

Var

  F   : TEXT;
  S   : STRING;
  S2  : STRING;

  Sec : STRING;


  Function CleanUpLine( S : STRING ) : STRING;

  BEGIN

    {--------------}
    { Zap the tabs }
    {--------------}

    S := SR( S, #9, ' ' );  { !^! maybe dis problem later, eh? }

    {-------------------------------}
    { Get rid of unnecessary spaces }
    {-------------------------------}

    S := TrimChar( S, ONCENTER, ' ' );

    CleanUpLine := S;

  END;

BEGIN


  {----------------------}
  { get memory for a VRF }
  {----------------------}

  New( AVRF );

  {-------------------------------------------------}
  { get memory for the array of pointers to strings }
  {-------------------------------------------------}

  GetMem( AVRF^.MenuText, 4*NMaxLines );

  { do the do }

  With AVRF^ Do
  BEGIN


    MaxLines   := NMaxLines;

    NumLines   := 0;
    IndexLines := 0;

    {---------------}
    { Open the file }
    {---------------}

    If NOT FileExist( FName ) Then
      VRF_Error( FName + ' Not Found!' );

    VTextAssign( 0,
                 F,
                 FName );

    Reset( F );


    {-------------------------}
    { look for RESOURCE_BEGIN }
    {-------------------------}

    Repeat
      ReadLn( F, S );
    Until (EOF(F)) or (CleanUpLine( S )='RESOURCE_BEGIN');


    If EOF(F) Then
      VRF_Error('No RESOURCE_BEGIN found.');


    {---------------------}
    { default section = \ }
    {---------------------}

    Sec := '\';

    {--------------------------------}
    { loop until EOF or RESOURCE_END }
    {--------------------------------}

    Repeat

      ReadLn( F, S );

      S := CleanUpLine( S );

      {-------------------------------------------}
      { If anything is ONLEFT in the line, store it }
      {-------------------------------------------}

      If S <> '' Then
      BEGIN

        Inc( NumLines );

        If NumLines > MaxLines Then
          VRF_Error( 'Exceeded Maximum Menu File Size.' );

        MenuText^[NumLines] := VStrNew( S );


        {------------------------------------}
        { Now we check to see if the line is }
        { a section marker or the beggining  }
        { of a resource.                     }
        {------------------------------------}

        S  := UpperString( S );

        { is it a section marker? }

        If Copy( S, 1, 13) = 'SECTION_BEGIN' Then
        BEGIN

          Sec := Sec + GetQuote( S ) + '\';

        END
        ELSE
        If Copy( S, 1, 11) = 'SECTION_END' Then
        BEGIN


          {---------------------------------------------}
          { Truncate everything after the 2nd ending \  }
          { in other words, go back one dir or section. }
          { Could have used PredDir but didnt feel like }
          { using VDOSHIGH                              }
          {---------------------------------------------}

          Sec := TruncAfterEnd( TruncAtEnd( Sec, '\' ),
                                '\'                      );

          If Sec='' Then
            VRF_Error('More SECTION_ENDS than SECTION_BEGINS.' );


        END
        ELSE
        BEGIN

          {----------------------------------}
          { Should we put it in the index?   }
          { (is it the start of a resource?) }
          {----------------------------------}

          S2 := Copy( S, 1, 4 );

          If Length( S2 ) = 4 Then
          BEGIN

            If (S2='MENU') or
               (S2='DIAL') or
               (S2='TEXT') or
               (S2='INTE') or
               (S2='VIEW') or
               (S2='BOOL') or
               (S2='REAL') or
               (S2='COLO') Then
            BEGIN

              {-----------------------------------------}
              { it is the start of a resource.  Get the }
              { resource name from the quotes, and      }
              { put it into the index.                  }
              {-----------------------------------------}

              S := GetQuote( S );

              IF Byte(S[0])>0 Then
              BEGIN

                Inc( IndexLines );

                IndexText[ IndexLines ] := VStrNew( Sec+S );
                IndexAt  [ IndexLines ] := NumLines;

              END;  { If Bytes(S[0]) }

            END;  { If S2='MENU' }

          END;  { If Length(S2) }

        END; { if section marker / else }

      END;  { If S <> '' }

    Until (EOF( F )) or (S='RESOURCE_END');

    LastStartLine := IndexLines;

    Close( F );

    CurSec := '\';

  END; {with}

END;  { VRF_New }

{}

Procedure VRF_ChangeSection(           Sec        : STRING );

BEGIN


   With AVRF^ DO
  BEGIN


    If Length( Sec )>0 Then
    BEGIN

      { make sure string has \ at end }

      If Sec[Length(Sec)]<>'\' Then
        Sec := Sec + '\';

      {-------------------------------------------}
      { if string starts at root section, replace }
      { cursection with it.  otherwise add the    }
      { section onto cursection.                  }
      {-------------------------------------------}

      If Sec[1]='\' Then
        CurSec := Sec
      ELSE
      If Sec[1]='.' Then
      BEGIN

        Delete( Sec, 1, 1 );

        While Sec[1]='.' Do
        BEGIN

          CurSec := TruncAfterEnd( TruncAtEnd( CurSec, '\' ),
                                   '\'                      );

          Delete( Sec, 1, 1 );

        END;

        If CurSec='' Then
          CurSec := '\';

        If Sec[1]='\' Then
        BEGIN

          Delete( Sec, 1, 1 );

          If Length( Sec ) >0 Then
          BEGIN

            If Sec[Length(Sec)]<>'\' Then
              Sec:=Sec+'\';

            CurSec := CurSec + Sec;

          END; { if length(sec)>0 (dir after ..s) }

        END; {if sec[1]=\ (dir after ..s) }

      END   { if sec[1]=. }
      ELSE
      BEGIN

        CurSec := CurSec + Sec

      END;

    END; { if length(sec)>0 }

  END; {with}

END;

{}

{$IFDEF VUI}

(*-

[FUNCTION]

Procedure VRF_GetMenu(                 ID         : ST80;
                                   Var Menu       : TMenu;
                                   Var Keys       : ST80;
                                   Var NumChoices : INTEGER;
                                   Var Rows       : INTEGER;
                                   Var Cols       : INTEGER;
                                   Var FC         : INTEGER;
                                   Var BC         : INTEGER;
                                   Var Message    : ST80     );

[PARAMETERS]

ID          Resource File Menu ID Name
Menu        VAR Returned Menu Data
Keys        VAR Returned Active Menu Keys
NumChoices  VAR Returned Number of Menu Choices
Rows        VAR Returned Number of Menu Rows
Cols        VAR Returned Number of Menu Cols
FC          VAR Returned Menu Foreground Color
BC          VAR Returned Menu Background Color
Message     VAR Returned Message Line associated with Menu

[RETURNS]

Function : None
(VAR     : [Menu] Menu Data)
(VAR     : [Keys] Active Menu Keys)
(VAR     : [NumChoices] Number of Menu Choices)
(VAR     : [Rows] Number of Menu Rows)
(VAR     : [Cols] Number of Menu Cols)
(VAR     : [FC] Menu Foreground Color)
(VAR     : [BC] Menu Background Color)
(VAR     : [Message] WMessage Line associated with Menu)

[DESCRIPTION]

Searches the Pre-Loaded Resource File Data for the Menu identified by the
ID Name.  When this is found, loads and returns all the Menu Information
associated with this.

[SEE-ALSO]

VFR_GetDialog
VFR_GetText
VFR_GetInt
VRF_GetColorNumber
VRF_DoMenu
VRF_DoMenu_Kill

[EXAMPLE]

{NOTE: All Examples use Above Demo Resource File}

Uses VGen,VWinHigh,VResFile;

VAR
  Menu      : TMenu;
  Keys, Msg : ST80;
  Num,
  Rows,Cols,
  FC,BC,
  I,Start   : INTEGER;

BEGIN

  WOpen( '', BLACK,BLUE, 'CLOCK' );
  VRF_New( 'Program.mnu' );

  VRF_Menu( 'Sector Menu', Menu, Keys, Num, Rows, Cols, FC,BC, Msg );

  WMessage( Msg, WHITE,CYAN );
  Start := 1;
  I     := WAutoMenu_Kill( Addr( Menu ),
                           Num,
                           Cols,
                           Rows,
                           Keys,
                           X, Y,
                           FC, BC,
                           FC, BC,
                           'Sector Menu',
                           Start );

  WMessage( 'Selection : '+IntToStr( i )+'|Press any Key to Quit',
            WHITE,CYAN );
  While NOT WKeyPressed Do;

  VRF_Dispose;
  WClose;

END;

-*)

Procedure VRF_GetMenu(                 ID         : ST80;
                                   Var Menu       : TMenu;
                                   Var Keys       : ST80;
                                   Var NumChoices : INTEGER;
                                   Var Rows       : INTEGER;
                                   Var Cols       : INTEGER;
                                   Var FC         : INTEGER;
                                   Var BC         : INTEGER;
                                   Var Message    : ST80     );

Var

  Z     : INTEGER;
  ZZ    : INTEGER;
  Error : INTEGER;
  S     : ST5;
  S1    : STRING;
  upS1  : STRING;


BEGIN


  With AVRF^ DO
  BEGIN

    NumChoices := 0;
    Keys       := '';
    Message    := '';

    ID := UpperString( ID );

    Z := GetStartLine( ID );

    If Z > NumLines Then
      VRF_Error( 'Could Not Find Menu "' + ID + '"' );

    Rows := 0;
    Cols := 0;

    Repeat

      Inc( Z );
      S1 := GetHeapString( MenuText^[Z] );

      UpS1 := UpperString( S1 );

      If S1[1] = '"' Then
      BEGIN

        Inc( NumChoices );

        Menu[NumChoices] := Copy( S1, 2, Length( S1 ) - 1 );

        Menu[NumChoices]:=
                Copy( Menu[NumChoices], 1, Pos( '"', Menu[NumChoices] ) - 1 );

      END;   { Of Then }

      {------------------------------------------}
      { Find the keys definition inside the menu }
      {------------------------------------------}

      If GetParamName( upS1 ) = 'KEYS' Then
      BEGIN

        Keys := GetParamData( S1 );

        Keys := TrimChar( Keys, ONLEFT, ' ' );
        Keys := TrimChar( Keys, ONCENTER, '"' );

      END;   { Of Then }

      {---------------------------------------------}
      { Find the message definition inside the menu }
      {---------------------------------------------}

      If GetParamName( upS1 ) = 'MESG' Then
      BEGIN

        Message := GetParamData( S1 );

        Message := TrimChar( Message, ONLEFT, ' ' );
        Message := TrimChar( Message, ONCENTER, '"' );

      END;   { Of Then }

      {-----------------------------------------}
      { Find the number of rows inside the menu }
      {-----------------------------------------}

      If GetParamName( ups1 ) = 'ROWS' Then
        Rows := StrToInt( GetParamData( upS1 ) );

      {--------------------------------------------}
      { Find the number of columns inside the menu }
      {--------------------------------------------}


      If GetParamName( upS1 ) = 'COLS' Then
        Cols := StrToInt( GetParamData( upS1 ) ) ;

      {------------------------------------------------------}
      { Find the foreground color definition inside the menu }
      {------------------------------------------------------}

      IF GetParamName( upS1 ) = 'FORE' Then
        FC := WColorFromString( GetParamData( upS1 ) );

      {------------------------------------------------------}
      { Find the background color definition inside the menu }
      {------------------------------------------------------}

      IF GetParamName( upS1 ) = 'BACK' Then
        BC := WColorFromString( GetParamData( upS1 ) );

    Until ( TrimChar( upS1, ONCENTER, ' ' ) = 'MENU_END' )
          OR ( Z > NumLines );

    {----------------------}
    { Do the goodbye stuff }
    {----------------------}

    If Z > NumLines Then
      VRF_Error( 'Could Not Find End of Menu "' + ID + '"' );

    If Rows = 0 Then
      Rows := NumChoices;

    If Cols = 0 Then
      Cols := 1;


  END; {with}

END;  { VRF_GetMenu }

{}

(*-

[FUNCTION]

Function  VRF_GetDialog(               ID        : ST80      ) : STRING;

[PARAMETERS]

ID          Resource File Dialog ID Name

[RETURNS]

Dialog Box String associated with ID Name

[DESCRIPTION]

Searches the Pre-Loaded Resource File Data for the Dialog identified by
the ID Name.  When this is found, loads and returns the Dialog String
information associated with this.

[SEE-ALSO]

VFR_GetMenu
VFR_GetText
VFR_GetInt
VRF_GetColorNumber

[EXAMPLE]

{NOTE: All Examples use Above Demo Resource File}

Uses VGen,VWinHigh,VResFile;

VAR
  S : STRING;
  I : INTEGER;

BEGIN

  WOpen( '',BLACK,BLUE,'CLOCK' );
  VRF_New( 'PROGRAM.MNU' );

  I := WGemDialogBox( VFR_GetDialog( 'AbortRetry' ) );

  WMessage( 'Selection : ',IntToStr(i)+'|Press any key to Quit',
            WHITE,CYAN );
  While NOT WKeyPressed Do;

  WDispose;
  WClose;

END;

-*)

Function  VRF_GetDialog(               ID        : ST80      ) : STRING;

Var

  Z          : INTEGER;
  S          : ST80;
  S1         : STRING;
  upS1       : STRING;
  DiaText    : STRING;
  DiaType    : ST80;
  DiaButtons : ST80;
  DiaKeys    : STRING[10];

BEGIN


  With AVRF^ Do
  BEGIN


    DiaText    := '';
    DiaType    := '[0]';
    DiaButtons := '[Okay ]';
    DiaKeys    := '[1234]';


    ID := UpperString( ID );

    Z := GetStartLine( ID );

    If Z > NumLines Then
      VRF_Error( 'Could Not Find Dialog "' + ID + '"' );

    Repeat
      Inc( Z );

      S1 := GetHeapString( MenuText^[Z] );

      upS1 := UpperString( S1 );

      If S1[1] = '"' Then
      BEGIN

        S := Copy( S1, 2, Length( S1 ) - 1 );
        S := Copy( S, 1, Pos( '"', S ) - 1 );

        DiaText := DiaText + S + '|';

      END;   { Of Then }

      {-------------------------------------}
      { Find the dialog box type definition }
      {-------------------------------------}

      If GetParamName( upS1 ) = 'TYPE' Then
      BEGIN

        S := GetParamData( upS1 );

        S := TrimChar( S, ONLEFT, ' ' );
        S := TrimChar( S, ONCENTER, '"' );

        DiaType := '[' + S + ']';

      END;   { Of Then }

      {--------------------------------------}
      { Find the avaiable options definition }
      {--------------------------------------}

      If GetParamName( upS1 ) = 'OPTS' Then
      BEGIN

        DiaButtons := GetParamData( upS1 );

        DiaButtons := TrimChar( DiaButtons, ONLEFT, ' ' );
        DiaButtons := TrimChar( DiaButtons, ONCENTER, '"' );

        If DiaButtons[1]<>'[' Then
          Insert( '[',DiaButtons,1 );

        If DiaButtons[Length(DiaButtons)]<>']' Then
          DiaButtons:=DiaButtons+']';

      END;   { Of Then }

      {--------------------------}
      { Find the keys definition }
      {--------------------------}


      If GetParamName( upS1 ) = 'KEYS' Then
      BEGIN

        DiaKeys := GetParamData( upS1 );

        DiaKeys := TrimChar( DiaKeys, ONLEFT, ' ' );
        DiaKeys := TrimChar( DiaKeys, ONCENTER, '"' );

      END;   { Of Then }

    Until ( TrimChar( upS1, ONCENTER, ' ' ) = 'DIALOG_END' )
          OR ( Z > NumLines );


    {----------------------}
    { Do the goodbye stuff }
    {----------------------}

    If Z > NumLines Then
      VRF_Error( 'Could Not Find End of Dialog "' + ID + '"' );

    Delete( DiaText, Length( DiaText ), 1 );

    VRF_GetDialog := DiaType + '[' + DiaText + ']' + DiaButtons + DiaKeys;

  END; { with }

END;  { VRF_GetDialog }

{}

(*-

[FUNCTION]


Procedure VRF_GetView(                 ID        : ST80;
                                   Var Menu      : TMenu;
                                   Var Lines     : INTEGER   );

[PARAMETERS]


[RETURNS]


[DESCRIPTION]


[SEE-ALSO]

[EXAMPLE]

-*)


Procedure VRF_GetView(                 ID        : ST80;
                                   Var Menu      : TMenu;
                                   Var Lines     : INTEGER   );



Var

  Z     : INTEGER;
  S1    : STRING;


BEGIN


  Lines := 0;

  With AVRF^ DO
  BEGIN

    ID := UpperString( ID );

    Z := GetStartLine( ID );

    If Z > NumLines Then
      VRF_Error( 'Could Not Find View "' + ID + '"' );

    Repeat

      Inc( Z );
      S1 := GetHeapString( MenuText^[Z] );

      If S1[1] = '"' Then
      BEGIN

        Inc( Lines );

        Menu[Lines] := GetQuote( S1 );

      END;   { Of Then }

    Until ( UpperString( TrimChar( S1, ONCENTER, ' ' ) )= 'VIEW_END' )
          OR ( Z > NumLines );

    {----------------------}
    { Do the goodbye stuff }
    {----------------------}

    If Z > NumLines Then
      VRF_Error( 'Could Not Find End of VIEW "' + ID + '"' );

  END; {with}

END;  { VRF_GetMenu }

{$ENDIF} { ifdef VUI }


{}


(*-

[FUNCTION]

Function  VRF_GetText(                 ID        : ST80      ) : STRING;

[PARAMETERS]

ID          File-Text Text ID Name

[RETURNS]

Text Associated with the Text ID Name

[DESCRIPTION]

Searches the Pre-Loaded File-Text Data for the Text identified by the
ID Name.  When this is found, loads and returns the Text String
information associated with this.

[SEE-ALSO]

VFR_GetMenu
VFR_GetDialog
VFR_GetInt
VRF_GetColorNumber

[EXAMPLE]

{NOTE: All Examples use Above Demo Resource File}

Uses VWinHigh,VResFile;

VAR
  BPS,
  SPC,
  CPD : LONGINT;

BEGIN

  WOpen( '', BLACK,BLUE, 'CLOCK' );
  VRF_New( 'PROGRAM.MNU' );

  WPrgName( VRF_Text( 'ProgName' ) );
  WNew( 10, 5, 40, 15, WHITE,CYAN,WHITE,CYAN, 'Drive Info' )

  BPS := VRF_GetInt('BlkSize') DIV VRF_GetInt('SectSize')
  SPC := VRF_GetInt('ClustSize') DIV BPS;
  CPD := VRF_GetInt('DrvSize') * VRF_GetInt('MB') DIV SPC;

  WriteLn ( VRF_Text( 'BPS' ), BPS );
  WriteLn ( VRF_Text( 'SPC' ), SPC );
  WriteLn ( VRF_Text( 'CPD' ), CPD );

  WMessage( VRF_GetText( 'PressKey' ), WHITE,CYAN );

  While NOT WKeyPressed Do;

  WDispose( 'Drive Info' );
  VRF_Dispose;
  WClose;

END;

-*)

Function  VRF_GetText(                 ID        : ST80      ) : STRING;

Var

  Z    : INTEGER;
  S    : STRING;
  Text : STRING;
  S1   : STRING;

  SaveZ: INTEGER;

BEGIN


  With AVRF^ Do
  BEGIN

    Text := '';

    ID := UpperString( ID );


    Z := GetStartLine( ID );

    If Z > NumLines Then
      VRF_Error( 'Could Not Find End of Text "' + ID + '"' );


    If Copy( GetHeapString( MenuText^[Z] ),
             1,
             5                             )<> 'TEXT_' Then

    BEGIN

      {------------------------------}
      { We found the text, so get it }
      {------------------------------}

      Text := GetHeapString( MenuText^[Z] );

      {------------------------}
      { Get just the data part }
      {------------------------}

      Text := Copy( Text,
                    Pos( '=', Text )+1,
                    255                   );

      {----------------------------}
      { trim the spaces and quotes }
      {----------------------------}

      Text := TrimChar( Text, ONLEFT, ' ' );
      Text := TrimChar( Text, ONCENTER, '"' );

    END   { Of Then }
    Else
    BEGIN

      Repeat

        Inc( Z );

        S1 := GetHeapString( MenuText^[Z] );

        If S1[1] = '"' Then
        BEGIN

          Text := Text + TrimChar( S1, ONCENTER, '"' );

        END;   { Of Then }

      Until ( UpperString( S1 ) = 'TEXT_END' ) OR ( Z > NumLines );

      If Z > NumLines Then
        VRF_Error( 'Could Not Find End of Text "' + ID + '"' );

    END;   { Of Else }

    VRF_GetText := SR( Text, '\n', #13 + #10 );

  END;

END;   { VRF_GetText }


{}


(*-

[FUNCTION]

Function  VRF_GetInt(                  ID        : ST80      ) : LONGINT;

[PARAMETERS]

ID          Resource File Integer ID Name

[RETURNS]

Integer Value associate with the Integer ID Name

[DESCRIPTION]

Searches the resource file data for the integer value identified by the
ID name, and returns the value.

[SEE-ALSO]

VFR_GetMenu
VFR_GetDialog
VFR_GetText
VFR_GetColorNumber

[EXAMPLE]

{NOTE: All Examples use demo resource file at top of unit.}

Uses VWinHigh,VResFile;

VAR
  BPS,
  SPC,
  CPD : LONGINT;

BEGIN

  WOpen( '', BLACK,BLUE, 'CLOCK' );
  VRF_New( 'PROGRAM.MNU' );

  WPrgName( VRF_Text( 'ProgName' ) );
  WNew( 10, 5, 40, 15, WHITE,CYAN,WHITE,CYAN, 'Drive Info' )

  BPS := VRF_GetInt('BlkSize') DIV VRF_GetInt('SectSize')
  SPC := VRF_GetInt('ClustSize') DIV BPS;
  CPD := VRF_GetInt('DrvSize') * VRF_GetInt('MB') DIV SPC;

  WriteLn ( VRF_Text( 'BPS' ), BPS );
  WriteLn ( VRF_Text( 'SPC' ), SPC );
  WriteLn ( VRF_Text( 'CPD' ), CPD );
  WriteLn;
  WriteLn( 'KiloByte = ', VRF_GetInt( 'KB' ) );
  WriteLn( 'GigaByte = ', VRF_GetInt( 'GB' ) );

  WMessage( VRF_GetText( 'PressKey' ), WHITE,CYAN );
  While NOT WKeyPressed Do;

  WDispose( 'Drive Info' );
  VRF_Dispose;
  WClose;

END;

-*)

Function  VRF_GetInt(                  ID        : ST80      ) : LONGINT;

Var

  Z    : INTEGER;
  S    : ST80;
  Text : ST80;

BEGIN


  With AVRF^DO
  BEGIN

    Text := '';

    ID := UpperString( ID );


    Z := GetStartLine( ID );

    If Z > NumLines Then
      VRF_Error( 'Could Not Find Integer "' + ID + '"' );

    Text := GetHeapString( MenuText^[Z ] );

    Text := Copy( Text,
                  Pos( '=', Text )+1,
                  255                );

    Text := TrimChar( Text, ONLEFT, ' ' );
    Text := TrimChar( Text, ONCENTER, '"' );

    VRF_GetInt := StrToInt( Text );


  END; { with }

END;  { VRF_GetInt }

{}

(*-

[FUNCTION]

Function  VRF_GetInt(                  ID        : ST80      ) : LONGINT;

[PARAMETERS]

ID          Resource File Integer ID Name

[RETURNS]

Integer Value associate with the Integer ID Name

[DESCRIPTION]

Searches the resource file data for the boolean value identified by the
ID name, and returns the value.

[SEE-ALSO]

VFR_GetMenu
VFR_GetDialog
VFR_GetText
VFR_GetColorNumber

[EXAMPLE]

-*)


Function  VRF_GetBoolean(              ID        : ST80      ) : BOOLEAN;


Var

  Z    : INTEGER;
  S    : ST80;
  Text : ST80;

BEGIN


  With AVRF^DO
  BEGIN

    Text := '';

    ID := UpperString( ID );


    Z := GetStartLine( ID );

    If Z > NumLines Then
      VRF_Error( 'Could Not Find Boolean "' + ID + '"' );

    Text := GetHeapString( MenuText^[Z ] );

    Text := Copy( Text,
                  Pos( '=', Text )+1,
                  255                );

    Text := TrimChar( Text, ONLEFT, ' ' );
    Text := TrimChar( Text, ONCENTER, '"' );
    Text := UpperString( TEXT );

    If (Copy(Text, 1, 1)='T') or
       (Copy(Text, 1, 1)='Y') or
       (Text='ON') Then
      VRF_GetBoolean := TRUE
    ELSE
      VRF_GetBoolean := FALSE;

  END; { with }

END; { VRF_GetBoolean }


{}

(*-

[FUNCTION]

Function  VRF_GetReal(                 ID        : ST80      ) : REAL;

[PARAMETERS]

ID          Resource File Integer ID Name

[RETURNS]

Real Value associate with the real ID Name

[DESCRIPTION]


Searches the resource file data for the real value identified by the
ID name, and returns the value.

[SEE-ALSO]

VFR_GetMenu
VFR_GetDialog
VFR_GetText
VFR_GetColorNumber

[EXAMPLE]

-*)


Function  VRF_GetReal(                 ID        : ST80      ) : REAL;

Var

  Z    : INTEGER;
  S    : ST80;
  Text : ST80;

BEGIN


  With AVRF^DO
  BEGIN

    Text := '';

    ID := UpperString( ID );


    Z := GetStartLine( ID );

    If Z > NumLines Then
      VRF_Error( 'Could Not Find Real "' + ID + '"' );

    Text := GetHeapString( MenuText^[Z ] );

    Text := Copy( Text,
                  Pos( '=', Text )+1,
                  255                );

    Text := TrimChar( Text, ONLEFT, ' ' );
    Text := TrimChar( Text, ONCENTER, '"' );

    VRF_GetReal := StrToReal( Text );


  END; { with }

END; { VRF_GetReal, Man. }

{}

(*-

[FUNCTION]

Function  VRF_GetColorNum(             ID        : ST80      ) : BYTE;

[PARAMETERS]

ID          Resource File Color ID Name

[RETURNS]

Color Value associate with the Color ID Name

[DESCRIPTION]

Searches the resource file data for the color value identified by the
ID name, and returns the value.

[SEE-ALSO]

VFR_GetMenu
VFR_GetDialog
VFR_GetText
VFR_GetInt

[EXAMPLE]

{NOTE: All Examples use Above Demo Resource File}

BEGIN

  VRF_New( 'Program.mnu' );

  WriteLn( 'Red   = ', VRF_GetColorNum( 'Red' ) );
  WriteLn( 'Blue  = ', VRF_GetColorNum( 'Green' ) );
  WriteLn( 'Green = ', VRF_GetColorNum( 'Blue' ) );

  WriteLn( VRF_GetText( 'PressKey' ) );
  While NOT WKeyPressed Do;

  VRF_Dispose;

END;

-*)

Function  VRF_GetColorNum(             ID        : ST80      ) : BYTE;

Var

  Z    : INTEGER;
  S    : ST80;
  Text : ST80;

BEGIN

  With AVRF^ Do
  BEGIN


    Text := '';

    ID := UpperString( ID );


    Z := GetStartLine( ID )-1;

    Repeat
      Inc( Z );
    Until ( Pos( 'COLOR "' + ID + '"=',
            UpperString( GetHeapString( MenuText^[Z] ) ) ) <> 0 ) OR
          ( Z > NumLines );

    If Z > NumLines Then
      VRF_Error( 'Could Not Find Color "' + ID + '"' );

    VRF_GetColorNum := ColorFromString( GetHeapString( MenuText^[Z] ) );

  END;

END;  { VRF_GetColorNum }

{}

{$IFDEF VUI}

(*-

[FUNCTION]

Function VRF_DoMenu(                   Opts      : ST80;
                                       ID        : ST80;
                                       X         : INTEGER;
                                       Y         : INTEGER;
                                       FC        : INTEGER;
                                       BC        : INTEGER    ) : INTEGER;

[PARAMETERS]

Opts        Menu Options
ID          Resource File Menu ID Name (Also used as Window Name)
X           Menu X Coordinate
Y           Menu Y Coordinate
FC          Overriding Foreground Color (-1 = Use data from File)
BC          Overriding Background Color (-1 = Use data from File)

[RETURNS]

User Menu Item Selection

[DESCRIPTION]

Searches the Pre-Loaded Resource File Data for the Menu identified by
the ID Name.  When this is found, loads and executes the Menu,
returning the User Menu Selection.

This Function does not Remove the Created Menu Window from the Screen,
which must be removed by the programmer manually.  The Window Name is
the same as the Resource File Menu ID Name.  So be sure that those
Names are what you would want displayed at the top of a Menu Window.

[SEE-ALSO]

VRF_GetMenu
VRF_DoMenu_Kill

[EXAMPLE]

{NOTE: All Examples use Above Demo Resource File}

Uses VGen,VWinHigh,VResFile;

VAR
  I : INTEGER;

BEGIN

  WOpen( '',BLACK,BLUE,'SHADOW' );
  VRF_New( 'PROGRAM.MNU' );

  I := VRF_DoMenu( '', 'Menu Name', 20, 5, -1, -1 );

  WMessage( 'Selection : '+IntToStr(i)+'|'+VRF_GetText('PressKey'),
            WHITE, CYAN );
  While NOT WKeyPressed Do;

  WDispose( 'Menu Name' );
  VRF_Dispose;
  WClose;

END;

-*)

Function VRF_DoMenu(                   Opts      : ST80;
                                       ID        : ST80;
                                       X         : INTEGER;
                                       Y         : INTEGER;
                                       FC        : INTEGER;
                                       BC        : INTEGER    ) : INTEGER;


Var

  Menu       : TMenu;
  NumChoices : INTEGER;
  Rows       : INTEGER;
  Cols       : INTEGER;
  Message    : ST80;
  Keys       : ST80;
  FC2        : INTEGER;
  BC2        : INTEGER;
  FStart     : WORD;

BEGIN


  VRF_GetMenu( Id, Menu, Keys, NumChoices, Rows, Cols, FC2, BC2, Message );

  If FC = -1 Then
    FC := FC2;

  If BC = -1 Then
    BC := BC2;

  FStart := 1;

  WMessage( Message, WHITE, BLUE );

  VRF_DoMenu := WAutoMenu( Addr( Menu ),
                       NumChoices,
                       Cols,
                       Rows,
                       Keys,
                       X, Y,
                       FC, BC,
                       FC, BC,
                       Opts + Id,
                       FStart );
END;  { VRF_DoMenu }

{}

(*-

[FUNCTION]

Function VRF_DoMenu_Kill(              Opts      : ST80;
                                       ID        : ST80;
                                       X         : INTEGER;
                                       Y         : INTEGER;
                                       FC        : INTEGER;
                                       BC        : INTEGER   ) : INTEGER;

[PARAMETERS]

Opts        Menu Options
ID          Resource File Menu ID Name  (Also used as Window Name)
X           Menu X Coordinate
Y           Menu Y Coordinate
FC          Overriding Foreground Color (-1 = Use data from File)
BC          Overriding Background Color (-1 = Use data from File)

[RETURNS]

User Menu Item Selection

[DESCRIPTION]

Searches the Pre-Loaded Resource File Data for the Menu identified by
the ID Name.  When this is found, loads and executes the Menu,
returning the User Menu Selection.  Also removes the Created Menu
Window from the Screen before returning.

[SEE-ALSO]

VRF_GetMenu
VRF_DoMenu

[EXAMPLE]

{NOTE: All Examples use Above Demo Resource File}

Uses VGen,VWinHigh,VResFile;

VAR
  I : INTEGER;

BEGIN

  WOpen( '',BLACK,BLUE,'SHADOW' );
  VRF_New( 'PROGRAM.MNU' );

  I := VRF_DoMenu_Kill( '', 'Menu Name', 20, 5, -1, -1 );

  WMessage( 'Selection : '+IntToStr(i)+'|'+VRF_GetText('PressKey'),
            WHITE, CYAN );
  While NOT WKeyPressed Do;

  VRF_Dispose;
  WClose;

END;

-*)

Function VRF_DoMenu_Kill(              Opts      : ST80;
                                       ID        : ST80;
                                       X         : INTEGER;
                                       Y         : INTEGER;
                                       FC        : INTEGER;
                                       BC        : INTEGER   ) : INTEGER;

Var

  Z : INTEGER;

BEGIN

  Z := VRF_DoMenu( Opts, ID, X, Y, FC, BC );

  WDispose( Opts + ID );

  VRF_DoMenu_Kill := Z;

END;  { VRF_DoMenu_Kill }

{$ENDIF} {ifdef vui}

{}

(*-

[FUNCTION]

Procedure VRF_Dispose;

[PARAMETERS]

(None)

[RETURNS]

(None)

[DESCRIPTION]

Deallocates all data Previously Loaded by the
[SEE-ALSO]

VRF_New

[EXAMPLE]

{NOTE: All Examples use Above Demo Resource File}

Uses VGen,VWinHigh,VResFile;

VAR
  S : STRING;
  I : INTEGER;

BEGIN

  WOpen( '',BLACK,BLUE,'CLOCK' );
  VRF_New( 'PROGRAM.MNU' );

  S := VFR_GetDialog( 'AbortRetry' );

  I := WGemDialogBox( S );

  WMessage( 'Selection : ',IntToStr(i)+'|Press any key to Quit',
            WHITE,CYAN );
  While NOT WKeyPressed Do;

  WDispose;
  WClose;

END;

-*)

Procedure VRF_Dispose;

Var

  Z : INTEGER;

BEGIN

  With AVRF^ Do
  BEGIN

    For Z := Numlines DownTo 1 Do
    BEGIN

      Dispose( MenuText^[Z] );
      MenuText^[Z] := NIL;

    END;   { Of For }

    NumLines := 0;

  END;

  Dispose( AVRF );

  AVRF := NIL;

END;  { VRF_Dispose }

{}

(*-

[FUNCTION]

Procedure VRF_NewInMem(    P         : Pointer;
                           Size      : Word;
                           NMaxLines : INTEGER   );

[PARAMETERS]

P         :  Pointer to where the VRF is in memory
Size      :  When doing a DIR *.VRF the size of it, you put here.
NMaxLines :  Maximum number of lines in VRF.

[RETURNS]

(None)

[DESCRIPTION]

Reads the Resource File Data from the given memory location and Loads all
the Data in RAM for Quick Access.

[SEE-ALSO]

VNew

[EXAMPLE]

{NOTE: All Examples use Above Demo Resource File}

Uses VGen,VWinHigh,VResFile;

VAR
  I : INTEGER;

BEGIN

  WOpen( '',BLACK,BLUE,'CLOCK' );
  VRF_NewInMenu( @VRFFILE, 21107 ,2000 );

  I := WGemDialogBox( VRF_GetDialog( 'AbortRetry' ) );

  WMessage( 'Selection : ' + IntToStr(i) + '|' + VRF_GetText('PressKey'),
            WHITE,CYAN );
  While NOT WKeyPressed Do;

  WDispose;
  WClose;

END;

-*)

Procedure VRF_NewInMem(    P         : Pointer;
                           Size      : Word;
                           NMaxLines : INTEGER   );

Type
   pBuffer = ^TBuffer;
   TBuffer = Array[0..64000] of Char;

Var

  F      : TEXT;
  S      : STRING;
  S2     : STRING;

  Sec    : STRING;
  Buff   : pBuffer;
  Offset : Word;


  Function ReadALineFromMem : STRING;
  Var
     S : STRING;
  Begin
     S := '';
     Repeat
        if buff^[Offset]<>#13 then
        Begin
           s := s + buff^[Offset];
           Inc(Offset);
        end;
     Until (Offset > Size) or (Buff^[Offset] = #13);
     Inc(Offset);
     if buff^[Offset] = #10 then
        inc(Offset);
     ReadALineFromMem := s;

  End;

  Function EOFile : Boolean;
  Begin
     Eofile := (Offset >= Size);
  End;

  Function CleanUpLine( S : STRING ) : STRING;

  BEGIN

    {--------------}
    { Zap the tabs }
    {--------------}

    S := SR( S, #9, ' ' );  { !^! maybe dis problem later, eh? }

    {-------------------------------}
    { Get rid of unnecessary spaces }
    {-------------------------------}

    S := TrimChar( S, ONCENTER, ' ' );

    CleanUpLine := S;

  END;

BEGIN

  Offset := 0;
  Buff   := pBuffer( p );

  {----------------------}
  { get memory for a VRF }
  {----------------------}

  New( AVRF );

  {-------------------------------------------------}
  { get memory for the array of pointers to strings }
  {-------------------------------------------------}

  GetMem( AVRF^.MenuText, 4*NMaxLines );

  { do the do }

  With AVRF^ Do
  BEGIN


    MaxLines   := NMaxLines;

    NumLines   := 0;
    IndexLines := 0;


    {-------------------------}
    { look for RESOURCE_BEGIN }
    {-------------------------}

    Repeat
      S := ReadALineFromMem;
    Until (EOFile) or (CleanUpLine( S )='RESOURCE_BEGIN');


    If EOFile Then
      VRF_Error('No RESOURCE_BEGIN found.');


    {---------------------}
    { default section = \ }
    {---------------------}

    Sec := '\';

    {--------------------------------}
    { loop until EOF or RESOURCE_END }
    {--------------------------------}

    Repeat

      s := ReadALineFromMem;

      S := CleanUpLine( S );

      {-------------------------------------------}
      { If anything is ONLEFT in the line, store it }
      {-------------------------------------------}

      If S <> '' Then
      BEGIN

        Inc( NumLines );

        If NumLines > MaxLines Then
          VRF_Error( 'Exceeded Maximum Menu File Size.' );

        MenuText^[NumLines] := VStrNew( S );


        {------------------------------------}
        { Now we check to see if the line is }
        { a section marker or the beggining  }
        { of a resource.                     }
        {------------------------------------}

        S  := UpperString( S );

        { is it a section marker? }

        If Copy( S, 1, 13) = 'SECTION_BEGIN' Then
        BEGIN

          Sec := Sec + GetQuote( S ) + '\';

        END
        ELSE
        If Copy( S, 1, 11) = 'SECTION_END' Then
        BEGIN


          {---------------------------------------------}
          { Truncate everything after the 2nd ending \  }
          { in other words, go back one dir or section. }
          { Could have used PredDir but didnt feel like }
          { using VDOSHIGH                              }
          {---------------------------------------------}

          Sec := TruncAfterEnd( TruncAtEnd( Sec, '\' ),
                                '\'                      );

          If Sec='' Then
            VRF_Error('More SECTION_ENDS than SECTION_BEGINS.' );


        END
        ELSE
        BEGIN

          {----------------------------------}
          { Should we put it in the index?   }
          { (is it the start of a resource?) }
          {----------------------------------}

          S2 := Copy( S, 1, 4 );

          If Length( S2 ) = 4 Then
          BEGIN

            If (S2='MENU') or
               (S2='DIAL') or
               (S2='TEXT') or
               (S2='INTE') or
               (S2='VIEW') or
               (S2='BOOL') or
               (S2='REAL') or
               (S2='COLO') Then
            BEGIN

              {-----------------------------------------}
              { it is the start of a resource.  Get the }
              { resource name from the quotes, and      }
              { put it into the index.                  }
              {-----------------------------------------}

              S := GetQuote( S );

              IF Byte(S[0])>0 Then
              BEGIN

                Inc( IndexLines );

                IndexText[ IndexLines ] := VStrNew( Sec+S );
                IndexAt  [ IndexLines ] := NumLines;

              END;  { If Bytes(S[0]) }

            END;  { If S2='MENU' }

          END;  { If Length(S2) }

        END; { if section marker / else }

      END;  { If S <> '' }

    Until (EOFile) or (S='RESOURCE_END');

    LastStartLine := IndexLines;

    CurSec := '\';

  END; {with}

END;  { VRF_New }

{}
{}

BEGIN

  AVRF := NIL;

END.
