{
 

 Visionix Serial Communictions High-level Unit (VSERHu)
   Version 0.5
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 revision history in reverse chronological order:

 Initials  Date      Comment

     

 jrt       12/06/93  Moved wait functions to here from VSeru;
                     finished VSerWaitMultiSt; finished timeout code
                     on all wait functions.

 jrt       12/05/93  First logged revision.

 
}

(*-

[TEXT]

<Overview>

This unit implements a variety of high-level serial communications
functions, which are based on the functions in VSeru.

This overview will be enhanced in the next BETA release.

<Interface>

-*)

Unit VSerHu;

Interface

Uses

  VTypesu,
  VAnsiiou,
  VDatesu,
  VOutu,
  VSeru,
  VSerLu,
  VStringu;


Const

  CModemOK       = 0;
  cModemNotReady = 1;


  cWaitErr       = $FFFF;
  cWaitTimeout   = $FFFE;
  cWaitGood      = $0000;


Type

  TMST = STRING[40];

  TModemDef = RECORD

    MsgGood               : TMST;           { good response after a cmd  }
    MsgError              : TMST;           { error response after a cmd }
    MsgNoDialtone         : TMST;           { no dialtone message        }
    MsgBusy               : TMST;           { busy message               }
    MsgNoAnswer           : TMST;           { no answer message          }
    MsgVoice              : TMST;           { Voice answered message     }

    MsgConnect110         : TMST;           { connect rate messages      }
    MsgConnect150         : TMST;
    MsgConnect300         : TMST;
    MsgConnect1200        : TMST;
    MsgConnect2400        : TMST;
    MsgConnect4800        : TMST;
    MsgConnect9600        : TMST;
    MsgConnect12000       : TMST;
    MsgConnect14400       : TMST;
    MsgConnect16800       : TMST;
    MsgConnect19200       : TMST;
    MsgConnect21600       : TMST;
    MsgConnect24000       : TMST;
    MsgConnect26800       : TMST;
    MsgConnect28800       : TMST;
    MsgConnect57600       : TMST;

    MsgRing               : TMST;           { phone is ringing message   }

    MsgCLIDDate           : TMST;           { Caller ID date message     }
    MsgCLIDTime           : TMST;           { Caller ID time message     }
    MsgCLIDPhoneNum       : TMST;           { Caller ID phone number msg }
    MsgCLIDName           : TMST;           { Caller ID Name msg         }

    CmdTestReady          : TMST;           { to test if modem is ready  }
    CmdReset              : TMST;           { to reset modem             }
    CmdCancel             : TMST;           { to cancel a previous cmd   }

    CmdDialTone           : TMST;           { for tone dialing           }
    CmdDialTonePost       : TMST;
    CmdDialPulse          : TMST;           { for pulse dialing          }
    CmdDialPulsePost      : TMST;

    CmdEchoOn             : TMST;           { for turning ECHO on        }
    CmdEchoOff            : TMST;           { for turning ECHO off       }

    CmdSpeakerOff         : TMST;           { for turning the spkr off   }
    CmdSpeakerNormal      : TMST;           { for spkr volume = normal   }
    CmdSpeakerHigh        : TMST;           { for spkr volume = high     }

    CmdHangup             : TMST;           { to hangup the line         }

  END;

  PModemDef = ^TModemDef;

{}




{----------------------------}
{ Modem definition functions }
{----------------------------}

Procedure VSerModemDefDefaults(   ModemDef            : PModemDef );

Function  VSerModemDefLoad(       ModemDef            : PModemDef;
                                  Flags               : LONGINT;
                                  DefFileName         : STRING;
                                  DefName             : STRING    ) : WORD;

Function  VSerModemDial(          Chan           : TSerHandle;
                                  Flags          : LONGINT;
                                  NumToDial      : STRING       ) : TError;

Function  VSerModemAnswer(        Chan           : TSerHandle;
                                  Flags          : LONGINT      ) : Terror;


(*

{-------------------------}
{ Modem control functions }
{-------------------------}

Function  VSerModemRegSet

Function  VSerModemRegGet



Function  VSerModemEchoOn

Function  VSerModemEchoOff

Function  VSerModemHangup

Function  VSerModemAnswer

Function  VSerModemFlowConSet

Function  VSerModemErrorConSet

Function  VSerModemCompressSet


{-----------------------------}
{ transfer protocol functions }
{-----------------------------}

Function  VSerProtUpload

Function  VSerProtDownload

{---------------------}
{ file send functions }
{---------------------}

Function  VSerFileSend

*)


{----------------}
{ Wait functions }
{----------------}

Function  VSerWaitCh(               Chan        : TSerHandle;
                                    ChToWaitFor : CHAR;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;

Function  VSerWaitBlock(            Chan        : TSerHandle;
                                    BlkToWaitSiz: LONGINT;
                                    BlkToWaitFor: POINTER;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;

Function  VSerWaitSt(               Chan        : TSerHandle;
                                    StToWaitFor : STRING;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;

Function  VSerWaitStMulti(          Chan        : TSerHandle;
                                    TheSt1      : STRING;
                                    TheSt2      : STRING;
                                    TheSt3      : STRING;
                                    TheSt4      : STRING;
                                    TheSt5      : STRING;
                                    TheSt6      : STRING;
                                    TheSt7      : STRING;
                                    TheSt8      : STRING;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;



Function  VSerWaitStList(           Chan        : TSerHandle;
                                    StListWait4 : PStrList;
                                    STTimeOut100: LONGINT;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;

{----------------}
{ misc functions }
{----------------}

Procedure VSerAnsiOutSubChanNew(  SerChan        : TSerHandle;
                                  Flags          : LONGINT;
                                  SubChanName    : STRING;
                                  TheOCH         : TChanHandle;
                                  AddVSFilt      : BOOLEAN        );


{}

Implementation

{}

(*-

[FUNCTION]

Procedure VSerModemDefDefaults(   ModemDef            : PModemDef );

[PARAMETERS]

modemdef    pointer to a variable of the type TModemDef

[RETURNS]

Nothing.

[DESCRIPTION]

This function loads the specified "ModemDef" with the default settings.
These default settings should work on any strictly-Hayes compatible
modem.

[SEE-ALSO]

[EXAMPLE]




-*)


Procedure VSerModemDefDefaults(   ModemDef            : PModemDef );

BEGIN

  With ModemDef^ Do
  BEGIN
    MsgGood              := 'OK';
    MsgError             := 'ERROR';
    MsgNoDialTone        := 'NO DIALTONE';
    MsgBusy              := 'BUSY';
    MsgNoAnswer          := 'NO CARRIER';
    MsgVoice             := 'VOICE';
    MsgConnect110        := 'CONNECT 110';
    MsgConnect300        := 'CONNECT 300';
    MsgConnect1200       := 'CONNECT 1200';
    MsgConnect2400       := 'CONNECT 2400';
    MsgConnect4800       := 'CONNECT 4800';
    MsgConnect9600       := 'CONNECT 9600';
    MsgConnect12000      := 'CONNECT 12000';
    MsgConnect14400      := 'CONNECT 14400';
    MsgConnect16800      := 'CONNECT 16800';
    MsgConnect19200      := 'CONNECT 19200';
    MsgConnect21600      := 'CONNECT 21600';
    MsgConnect24000      := 'CONNECT 24000';
    MsgConnect26800      := 'CONNECT 26800';
    MsgConnect28800      := 'CONNECT 28800';
    MsgConnect57600      := 'CONNECT 57600';
    MsgRing              := 'RING';
    MsgCLIDDate          := 'DATE=';
    MsgCLIDTime          := 'TIME=';
    MsgCLIDPhoneNum      := 'NUM =';
    MsgCLIDName          := 'NAME=';

    CmdTestReady         := 'AT'+#13+#10;
    CmdReset             := 'ATZ'+#13+#10;
    CmdCancel            := #13+#10;
    CmdDialTOne          := 'ATDT';
    CmdDialTonePost      := #13+#10;
    CmdDialPulse         := 'ATDP';
    CmdDialPulsePost     := #13+#10;
    CmdEchoOn            := 'ATE1'+#13+#10;
    CmdEchoOff           := 'ATE0'+#13+#10;
    CmdSpeakerOff        := 'ATM0'+#13+#10;
    CmdSpeakerNormal     := 'ATM1'+#13+#10;
    CmdSpeakerHigh       := 'ATM2'+#13+#10;
    CmdHangup            := '~~~+++~~~ATH'+#13+#10;
  END;

END; { VSerModemDefDefaults }



{}

(*-

[FUNCTION]

Function  VSerModemDefLoad(       ModemDef            : PModemDef;
                                  Flags               : LONGINT;
                                  DefFileName         : STRING;
                                  DefName             : STRING    ) : WORD;

[PARAMETERS]

modemdef    pointer to a variable of the type TModemDef
flags       load flags (currently 0)
deffilename name of the file to load the modem definition from
defname     name of the modem definition

[RETURNS]

0 if successfull, otherwise a DOS error code.

[DESCRIPTION]

This function loads the specified "ModemDef" from the definition
"defname" in the defintion file "Deffilename".

THIS FUNCTION IS NOT YET IMPLEMENTED.

[SEE-ALSO]

[EXAMPLE]




-*)


Function  VSerModemDefLoad(       ModemDef            : PModemDef;
                                  Flags               : LONGINT;
                                  DefFileName         : STRING;
                                  DefName             : STRING    ) : WORD;

BEGIN



END;


{}

(*

{-------------------------}
{ Modem control functions }
{-------------------------}

Function  VSerModemRegSet

Function  VSerModemRegGet

*)


(*-

[FUNCTION]

Function  VSerModemDial(          Chan           : TSerHandle;
                                  Flags          : LONGINT;
                                  NumToDial      : STRING       ) : TError;

[PARAMETERS]

chan        serial channel handle
flags       dial flags (currently 0)
numtodial   phone number to dial

[RETURNS]

0 if successfull, otherwise a serial error code.

[DESCRIPTION]

This function dials the specified number "numtodial" on the specified
serial channel.

[SEE-ALSO]

[EXAMPLE]




-*)



Function  VSerModemDial(          Chan           : TSerHandle;
                                  Flags          : LONGINT;
                                  NumToDial      : STRING       ) : TError;

BEGIN

  { purge all input }

  VSerPurgeInBuff( Chan );

  {------------------------------------------------}
  { make sure the modem is ready                   }
  { by sending an AT and looking for a returned OK }
  {------------------------------------------------}

  VSerWriteST( Chan, #13 );
  VSerWriteST( Chan, 'AT'+#13 );

  If (VSerWaitSt( Chan, 'OK', 200, FALSE ))=0 Then
  BEGIN

    VSerPurgeInBuff( Chan );

    Sleep( 200 );

    VSerWriteST( Chan, 'ATDT'+NumToDial+#13 );
    VSerPurgeInBuff( Chan );

    VSerWaitStMulti( Chan,
                     'NO DIALTONE',
                     'BUSY',
                     'NO ANSWER',
                     'CONNECT',
                     'NO CARRIER',
                     '',
                     '',
                     '',
                     2000,
                     FALSE             );

  END
  ELSE
    VSerModemDial := cModemNotReady;


END;


Function  VSerModemAnswer(        Chan           : TSerHandle;
                                  Flags          : LONGINT      ) : Terror;

BEGIN

  { purge all input }

  VSerPurgeInBuff( Chan );

  {------------------------------------------------}
  { make sure the modem is ready                   }
  { by sending an AT and looking for a returned OK }
  {------------------------------------------------}

  VSerWriteST( Chan, #13 );
  VSerWriteST( Chan, 'AT'+#13 );

  If (VSerWaitSt( Chan, 'OK', 200, FALSE ))=0 Then
  BEGIN

    VSerPurgeInBuff( Chan );

    Sleep( 200 );

    Repeat
    Until (VSerWaitSt( Chan, 'RING', 2000, FALSE)=0);

    VSerWriteST( Chan, 'ATA'+#13 );
    VSerPurgeInBuff( Chan );

    VSerWaitStMulti( Chan,
                     'NO DIALTONE',
                     'BUSY',
                     'NO ANSWER',
                     'CONNECT',
                     'NO CARRIER',
                     '',
                     '',
                     '',
                     2000,
                     FALSE             );

  END
  ELSE
    VSerModemAnswer := cModemNotReady;


END;




(*


Function  VSerModemEchoOn

Function  VSerModemEchoOff

Function  VSerModemHangup

{--------------------------------}
{ xmodem/ymodem/zmodem functions }
{--------------------------------}

Function  VSerProtUpload

Function  VSerProtDownload

{---------------------}
{ file send functions }
{---------------------}

Function  VSerFileSend

*)


{}



(*-

[FUNCTION]

Function  VSerWaitCh(               Chan        : TSerHandle;
                                    ChToWaitFor : CHAR;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;


[PARAMETERS]

chan        serial channel handle
chtowaitfor the character to wait for
timeout100  how long to wait for the character (-1=no wait)
casesense   TRUE if chtowaitfor case must match; FALSE if it doesn't

[RETURNS]

cWaitGood    if the character to wait for is received
cWaitTimeout if the timeout value elapsed
cWaitErr     if a serial error occurred.

[DESCRIPTION]

This function will wait for the character "chtowaitfor" on the specified
channel, until the character is received or the "timeout100" value
elapses.  If casesense is TRUE, only characters that exacly match
"chToWaitFor" can end the wait.  Otherwise, any upper or lower-case
character that matches can end the wait.

[SEE-ALSO]

[EXAMPLE]

  { to wait for the char 'O' for two seconds--case must match }

  Err := VSerWaitch( MyChan,
                     'O',
                     200,
                     TRUE      );



  { to wait for the char 'O' for ever--case does not need to match }

  Err := VSerWaitch( MyChan,
                     'O',
                     -1,
                     FALSE      );

-*)


Function  VSerWaitCh(               Chan        : TSerHandle;
                                    ChToWaitFor : CHAR;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;

Var

  CH          : CHAR;
  Err         : TError;
  StartSwatch : TSwatch;

BEGIN

  StartSwatch := CurrSwatch;

  If Not CaseSense Then
    ChToWaitFor := Upcase( ChToWaitFor );

  Repeat

    Err := VSerReadChEx( Chan,
                         csfWait,
                         CH,
                         TimeOut100 );

    If Not CaseSense Then
      Ch := Upcase( CH );

  Until ( Err<>0         ) or
        ( CH=ChToWaitFor ) or
        ( SwatchExpired( StartSwatch, Timeout100 ) );

  {---------------------------------}
  { if an error, return cwait err.  }
  { if a  match, return good.       }
  { otherwise a timeout occured.    }
  {---------------------------------}

  If Err<>0 Then
    VSerWaitCH := cWaitErr
  Else
  If CH=ChToWaitFor Then
    VSerWaitCH := cWaitGood
  Else
    VSerWaitCH := cWaitTimeout;

END;

{}

(*-

[FUNCTION]

Function  VSerWaitBlock(            Chan        : TSerHandle;
                                    BlkToWaitSiz: LONGINT;
                                    BlkToWaitFor: POINTER;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN      ) : TError;

[PARAMETERS]

chan            serial channel handle
blktowaitsiz    size of the block to wait for
blktowaitfor    pointer to the block to wait for
timeout100      timeout value
timeout100      how long to wait for the block (-1=no wait)
casesense       TRUE if block case must match; FALSE if it doesn't

[RETURNS]

cWaitGood    if the block to wait for is received
cWaitTimeout if the timeout value elapsed
cWaitErr     if a serial error occurred.

[DESCRIPTION]

This function will wait for the block "blktowaitfor" on the specified
channel, until the block is received or the "timeout100" value
elapses.  If casesense is TRUE, only sequential characters that exactly match
"blktowaitfor" can end the wait.  Otherwise, any upper or lower-case
sequential characters that match the block can end the wait.

[SEE-ALSO]

[EXAMPLE]

  { to wait for the block 'EMSI' for 2 seconds--case must match }

  Buff[0] := 'E';
  Buff[1] := 'M';
  Buff[2] := 'S';
  Buff[3] := 'I';

  Err := VSerWaitBlock( MyChan,
                        4,
                        @Buff,
                        200,
                        TRUE       );



  { to wait for the block 'EMS' forever --case need not match }

  Err := VSerWaitBlock( Mycyan,
                        4,
                        @Buff,
                        -1,
                        FALSE       );

-*)


Function  VSerWaitBlock(            Chan        : TSerHandle;
                                    BlkToWaitSiz: LONGINT;
                                    BlkToWaitFor: POINTER;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN      ) : TError;

Var

  MatchCount        : LONGINT;
  Err               : TError;
  CH                : CHAR;
  StartSwatch       : TSwatch;

BEGIN

  StartSwatch := CurrSwatch;

  MatchCount := 0;

  {-------------------------------------------------}
  { repeat until we find a match or an error occurs }
  { or the timeout expires.                         }
  {-------------------------------------------------}


  Repeat

    {----------------------------------------------}
    { Get a character, make sure their is no error }
    {----------------------------------------------}

    Err := VSerReadChEx( Chan, csfWait, CH, Timeout100 );

    If Err=0 Then
    BEGIN

        {------------------------------------------------------------}
        { for this block:  see if we have a match.  If so, increment }
        { the match count.  If not, reset the match count.  If the # }
        { of matches on this block  = the length of the block , we   }
        { have a block  match.                                       }
        {------------------------------------------------------------}


      IF CaseSense Then
      BEGIN
        If PCharArray( BlkToWaitFor )^[ Pred( MatchCount )] = Ch Then
          Inc( MatchCount )
        Else
          MatchCount := 0;
      END
      ELSE
      BEGIN
        If UpCase(PCharArray( BlkToWaitFor )^[ Succ( MatchCount )]) =
           UpCase( Ch ) Then
          Inc( MatchCount )
        Else
          MatchCount := 0;
      END; { if casesense / else }

    END; { if err=0 }

  Until ( Err<>0                                   ) or
        ( MatchCount=BlkToWaitSiz                  ) or
        ( SwatchExpired( StartSwatch, TimeOut100 ) );


  {---------------------------------}
  { if an error, return cwait err.  }
  { if a  match, return good.       }
  { otherwise a timeout occured.    }
  {---------------------------------}

  If Err<>0 Then
    VSerWaitBlock := cWaitErr
  Else
  If MatchCount=BlkToWaitSiz Then
    VSerWaitBlock := cWaitGood
  Else
    VSerWaitBlock := cWaitTimeout;


END;

{}


(*-

[FUNCTION]

Function  VSerWaitSt(               Chan        : TSerHandle;
                                    StToWaitFor : STRING;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;

[PARAMETERS]

chan            serial channel handle
sttowaitfor     string to wait for
timeout100      how long to wait for the block (-1=no wait)
casesense       TRUE if string case must match; FALSE if it doesn't

[RETURNS]

cWaitGood    if the string to wait for is received
cWaitTimeout if the timeout value elapsed
cWaitErr     if a serial error occurred.

[DESCRIPTION]

This function will wait for the string "sttowaitfor" on the specified
channel, until the string is received or the "timeout100" value
elapses.  If casesense is TRUE, only sequential characters that exactly match
"sttowaitfor" can end the wait.  Otherwise, any upper or lower-case
sequential characters that match the string can end the wait.

[SEE-ALSO]

[EXAMPLE]

  { to wait for the string 'Please Logon:' for 2 seconds--case must match }

  Err := VSerWaitString( MyChan,
                         'Please Logon:',
                         200,
                         TRUE       );


  { to wait for the string 'Please Logon:' forever--case need not match }

  Err := VSerWaitString( MyChan,
                         'Please Logon:',
                         -1,
                         FALSE               );


-*)

Function  VSerWaitSt(               Chan        : TSerHandle;
                                    StToWaitFor : STRING;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;

BEGIN

  VSerWaitSt := VSerWaitBlock( Chan,
                               Byte( StToWaitFor[ 0 ] ),
                               @StToWaitFor[1],
                               Timeout100,
                               CaseSense                        );

END;

{}

(*-

[FUNCTION]

Function  VSerWaitStMulti(          Chan        : TSerHandle;
                                    TheSt1      : STRING;
                                    TheSt2      : STRING;
                                    TheSt3      : STRING;
                                    TheSt4      : STRING;
                                    TheSt5      : STRING;
                                    TheSt6      : STRING;
                                    TheSt7      : STRING;
                                    TheSt8      : STRING;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;

[PARAMETERS]

chan            serial channel handle
TheSt1          string #1 to wait for
TheSt2          string #2 to wait for
TheSt3          string #3 to wait for
TheSt4          string #4 to wait for
TheSt5          string #5 to wait for
TheSt6          string #6 to wait for
TheSt7          string #7 to wait for
TheSt8          string #8 to wait for
timeout100      how long to wait for the block (-1=no wait)
casesense       TRUE if string case must match; FALSE if it doesn't

[RETURNS]

1-8          if the string #x was received
cWaitTimeout if the timeout value elapsed
cWaitErr     if a serial error occurred.

[DESCRIPTION]

This function will wait for any one of 8 specified strings on the specified
channel, until the one of thestrings is received or the "timeout100" value
elapses.  If casesense is TRUE, only sequential characters that exactly match
one of the strings can end the wait.  Otherwise, any upper or lower-case
sequential characters that match one of the strings can end the wait.

[SEE-ALSO]

[EXAMPLE]

  { to wait for either 'Please Logon:', 'Enter your name:', or  }
  { 'uucp!Login:' for 2 seconds--case must match                }

  Err := VSerWaitStMulti( Mychan,
                          'Please Logon:',
                          'Enter your name:',
                          'uucp!Login:',
                          '',
                          '',
                          '',
                          '',
                          '',
                          200,
                          TRUE                    );

  { to wait for either 'Please Logon:', 'Enter your name:', or  }
  { 'uucp!Login:' forever -- case need not match                }

  Err := VSerWaitStMulti( Mychan,
                          'Please Logon:',
                          'Enter your name:',
                          'uucp!Login:',
                          '',
                          '',
                          '',
                          '',
                          '',
                          -1,
                          FALSE                 );

-*)


Function  VSerWaitStMulti(          Chan        : TSerHandle;
                                    TheSt1      : STRING;
                                    TheSt2      : STRING;
                                    TheSt3      : STRING;
                                    TheSt4      : STRING;
                                    TheSt5      : STRING;
                                    TheSt6      : STRING;
                                    TheSt7      : STRING;
                                    TheSt8      : STRING;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;


Var

  TheString   : Array[1..8] of PSTRING;
  MatchCount  : Array[1..8] of BYTE;
  Z           : INTEGER;
  Err         : TError;
  CH          : CHAR;
  Done        : BOOLEAN;
  StartSwatch : TSwatch;

BEGIN

  StartSwatch := CurrSwatch;

  {------------------------}
  { setup the pointer list }
  {------------------------}

  TheString[1] := @TheSt1;
  TheString[2] := @TheSt2;
  TheString[3] := @TheSt3;
  TheString[4] := @TheSt4;
  TheString[5] := @TheSt5;
  TheString[6] := @TheSt6;
  TheString[7] := @TheSt7;
  TheString[8] := @TheSt8;

  For Z := 1 to 8 Do
    MatchCount[Z] := 0;

  {-------------------------------------------------}
  { repeat until we find a match or an error occurs }
  { or the timeout expires.                         }
  {-------------------------------------------------}

  Done := FALSE;

  Repeat

    {----------------------------------------------}
    { Get a character, make sure their is no error }
    {----------------------------------------------}

    Err := VSerReadChEx( Chan, csfwait, CH, timeout100 );

    If Err=0 Then
    BEGIN

      {---------------------------------------------------------}
      { loop through each string and see if we have a match yet }
      {---------------------------------------------------------}

      Z := 0;

      Repeat

        Inc( Z );

        {------------------------------------------------------------}
        { for each string, see if we have a match.  If so, increment }
        { the match count.  If not, reset the match count.  If the # }
        { of matches on this string = the length of the string, we   }
        { have a string match.                                       }
        {------------------------------------------------------------}

        If CaseSense Then
        BEGIN

          If ( MatchCount[Z] < Length(TheString[Z]^)           ) And
             ( TheString[Z]^[ Succ( MatchCount[Z] ) ] = Ch     ) Then
          BEGIN
            Inc( MatchCount[Z] );
            Done := ( MatchCount[Z]=Length( TheString[Z]^ ) );
          END
          Else
            MatchCount[Z] := 0;

        END    { if casesense }
        ELSE
        BEGIN

          If ( MatchCount[Z] < Length(TheString[Z]^)              ) And
             ( UpCase( TheString[Z]^[ Succ( MatchCount[Z] ) ] ) =
                 UpCase( Ch )                                     ) Then
          BEGIN
            Inc( MatchCount[Z] );
            Done := ( MatchCount[Z]=Length( TheString[Z]^ ) );
          END
          Else
            MatchCount[Z] := 0;

        END; { if casesense / else }

      Until (Z=8) or (Done);

    END; { if err=0 }

  Until ( Err<>0                                   ) or
        ( Done                                     ) or
        ( SwatchExpired( StartSwatch, Timeout100 ) );


  {----------------------------------------}
  { if an error, return cwait err.         }
  { if a  match, return which one matched. }
  { otherwise a timeout occured.           }
  {----------------------------------------}

  If Err<>0 Then
    VSerWaitStMulti := cWaitErr
  Else
  If Done Then
    VSerWaitStMulti := Z
  Else
    VSerWaitStMulti := cWaitTimeout;


END; { function VSerWaitStMulti }

{}


(*-

[FUNCTION]

Function  VSerWaitStList(           Chan        : TSerHandle;
                                    StListWait4 : PStrList;
                                    STTimeOut100: LONGINT;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;

[PARAMETERS]

chan            serial channel handle
stlistwait4     string-list to wait for
timeout100      how long to wait for the block (-1=no wait)
casesense       TRUE if string case must match; FALSE if it doesn't

[RETURNS]

1-32768      if the string #x was received
cWaitTimeout if the timeout value elapsed
cWaitErr     if a serial error occurred.

[DESCRIPTION]

This function will wait for any one of x specified strings on the specified
channel, until the one of the strings is received or the "timeout100" value
elapses.  If casesense is TRUE, only sequential characters that exactly match
one of the strings can end the wait.  Otherwise, any upper or lower-case
sequential characters that match one of the strings can end the wait.

THIS FUNCTION IS NOT YET IMPLEMENTED!

[SEE-ALSO]

[EXAMPLE]


-*)

Function  VSerWaitStList(           Chan        : TSerHandle;
                                    StListWait4 : PStrList;
                                    STTimeOut100: LONGINT;
                                    TimeOut100  : LONGINT;
                                    CaseSense   : BOOLEAN       ) : TError;

BEGIN

END;

{}

Procedure SerSendSt(              IData          : PAnsiOutDriverIdata;
                              Var ST             : STRING               ); Far;

BEGIN

  { Param 3 = Serial channel handle }

  While VSerGetOutFree( Pointer(Idata^.Param3) )<2048 Do;

  VSerWriteST( Pointer(IData^.Param3), ST );

END;


{}

(*-

[FUNCTION]

Procedure VSerAnsiOutSubChanNew(  SerChan        : TSerHandle;
                                  Flags          : LONGINT;
                                  SubChanName    : STRING;
                                  TheOCH         : TChanHandle;
                                  AddVSFilt      : BOOLEAN        );


[PARAMETERS]

serchan     serial channel handle
flags       currently 0
subchanname name of the new sub-channel
theoch      handle of the channel to create the sub-channel off of
addvsfilt   TRUE if the virtual screen filter should be attached
            to the new channel, FALSE if it should not.

[RETURNS]

Nothing.

[DESCRIPTION]

This function will create a new-sub channel named "subchanname" off of the
channel associate with "theoch".  The new channel will use the
AnsiOutDriverProc to create ANSI commands and send them to the serial
channel associated with "serchan".

If AddVSFilt is TRUE, the virtual-screen filter will be attached to this
new out-channel.  The virtual screen filter is required if you intend
to use the window or any of the region commands on the new channel.
The virutal screen filter keeps a virtual image of the remote screen.
If you do not need to use the Window or any of the region commands, you
do not need to attach the virtual screen filter.

What the heck does all that mean?
--------------------------------

By calling this function and specifying the CRTs outout channel handle
as "theoch", this function will create a sub-channel which will send
ANSI commands out the specified serial channel when you call GotoXY,
TextColor, ClrScr, Write, etc.  VCRT functions.

[SEE-ALSO]

[EXAMPLE]

  { to create a serial-ansi sub-channel on VCRTs output channel }

  VSerAnsiOutSubChanNew( MySerChan,
                         0,
                         'ANSISERCHAN',
                         CrtOCH,
                         TRUE                   );

-*)

Procedure VSerAnsiOutSubChanNew(  SerChan        : TSerHandle;
                                  Flags          : LONGINT;
                                  SubChanName    : STRING;
                                  TheOCH         : TChanHandle;
                                  AddVSFilt      : BOOLEAN        );

BEGIN

  {---------------------------------------------------------}
  { Create a new sub-channel off of the specified channel.  }
  { Make the anchor driver the ANSI out driver, and tell it }
  { to send all output to custom ansi output routine: our   }
  { local SerSendSt procedure.                              }
  {---------------------------------------------------------}

  VOutSubChannelNew( TheOCH,
                     0,
                     SubChanName,
                     ANSIOutDriverProc,
                     caoCustom,
                     Longint(@SerSendSt),
                     Longint(SerChan)        );

  If AddVSFilt Then
    VOutFilterAttach( TheOCH,
                      0,
                      'VSFILT',
                      SubChanName,
                      VirtScreenFilter,
                      0, 0, 0                );


END;

{}



{}
{}
{}
{}

BEGIN
END.
