
{
 

 Visionix Serial Communictions LOW Unit (VSER)
   Version 0.5
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 revision history in reverse chronological order:

 Initials  Date      Comment

     

 lpg       03/16/93  Added Source Documentation

 mep       02/11/93  Cleaned up code for beta release

 jrt       02/08/93  Sync with beta 0.12 release

 jrt       11/21/92  Sync with beta 0.08

 jrt       09/01/92  First logged revision.

 
}

(*-

[TEXT]

<Overview>

This unit implements various low-level serial communication types and
constants.

<Interface>

-*)


Unit VSerLu;

Interface

CONST

  {-------------------------}
  { Serial Driver Functions }
  {-------------------------}

  {- driver control        } {* = Added on 12/06/93 }

  sdfDriverNew        = $01;

  sdfDriverOff        = $02;
  sdfDriverOn         = $03;

  sdfDriverDispose    = $04;

  sdfActivate         = $05;
  sdfDeActivate       = $06;

  {- comm param            }

  sdfSetCommParam     = $10;
  sdfGetCommParam     = $11;

  {- flow control          }

  sdfGetFlowConType   = $20;
  sdfSetFlowConType   = $21;
  sdfTurnSendOnOff    = $22;
  sdfTurnReceiveOnOff = $23;
  sdfGetFlowConChars  = $24;
  sdfSetFlowconChars  = $25;

  {- Line information      }

  sdfGetLineControl   = $30; {*}
  sdfGetLineStatus    = $31; {*}

  {- Modem information     }

  sdfGetModemControl  = $40; {*}
  sdfGetModemStatus   = $41; {*}

  sdfGetBothStatus    = $42; {*}

  {- Line/Modem change     }

  sdfDTROnOff         = $50;
  sdfBreakOnOff       = $51;
  sdfRTSOnOff         = $52; {*}

  {- Buffer management     }

  sdfFlushOutBuff     = $60;
  sdfPurgeOutBuff     = $61;
  sdfPurgeInBuff      = $62;

  sdfGetOutBuffInfo   = $63; {*}
  sdfSetOutBuffInfo   = $64; {*}
  sdfGetInBuffInfo    = $65; {*}
  sdfSetInBuffInfo    = $66; {*}

  {- Event procedures      }

  sdfEventProcNew     = $70;
  sdfEventProcOff     = $71;
  sdfEventProcOn      = $72;
  sdfEventProcDispose = $73;
  sdfEventProcMaskSet = $74; {*}

  {- Input/Output          }

  sdfWriteCh          = $80;
  sdfWriteBlock       = $81;
  sdfReadCh           = $82;
  sdfReadBlock        = $83;
  sdfPeekCh           = $84; {*}

  {-}



  {----------------------------------------}
  { Modem Status Register status bits (AL) }
  {----------------------------------------}

  MSRctsDelta = $01; { Clear To Send changed                                 }
                     { Delta CTS - not reliable                              }
  MSRdsrDelta = $02; { Data Set Ready changed                                }
                     { Delta DSR - not reliable                              }
  MSRriDelta  = $04; { Ring Indicate changed                                 }
                     { Delta DCD - not reliable                              }
  MSRcdDelta  = $08; { Carrier Detect changed                                }
                     { always set to 1 upon return (DUMMY DCD)               }
  MSRcts      = $10; { Clear To Send                                         }
                     { CTS - DCE sets - do not xmit until true               }
  MSRdsr      = $20; { Data Set Ready                                        }
                     { DSR - modem is ready to be used                       }
  MSRri       = $40; { Ring Indicate                                         }
                     { RI - only on during active voltage signal             }
  MSRcd       = $80; { Carrier Detect                                        }
                     { DCD - data carrier detect                             }

  {---------------------------------------}
  { Line Status Register status bits (AH) }
  {---------------------------------------}

  LSRRcvReady = $01; { Received data ready                                   }
                     { RDA  - input data is available in buffer              }
  LSROverrun  = $02; { OverRun error                                         }
                     { OVRN - the input buffer has been overrun              }
  LSRParity   = $04; { Parity error                                          }
                     { Reserved (Parity error in BIOS INT 14h)               }
  LSRFrame    = $08; { Framing error                                         }
                     { Reserved (Framing error in BIOS INT 14h)              }
  LSRBreak    = $10; { Break detected                                        }
                     { Reserved (Break detect in BIOS INT 14h)               }
  LSRXhReady  = $20; { Transmit hold register empty                          }
                     { THRE - room is available in output buffer             }
  LSRXsReady  = $40; { Transmit shift register empty                         }
                     { TSRE - output buffer is empty                         }
  LSRTimeout  = $80; { Timeout (software implemented).  If true,             }
                     { then none of the above 15 bits are valid.             }

  {-----------------------------}
  { Modem Control Register bits }
  {-----------------------------}

  MCRDtr      = $1; { Data terminal ready                                    }
  MCRRts      = $2; { Request to send                                        }
  MCROut1     = $4; { Out1: software implemented output                      }
  MCROut2     = $8; { Out2: as Out1 with interrupts to system-bus            }
  MCRLoop     = $10;{ Loopback test mode                                     }

  {----------------------------}
  { Line Control Register bits }
  {----------------------------}

  LCRdatabits = $1; { Bits/character (databits) - bits 1-0                   }
  LCRstopbits = $4; { Stop bits of character                                 }
  LCRparity   = $8; { Parity - bits 5-3                                      }
  LCRbreak    = $20;{ Enable break status                                    }
  LCRdivisor  = $40;{ Enable addressing of baudrate divisor registers        }

  {----------------------------------------}
  { Interrupt Identification Register bits }
  {----------------------------------------}

  IIRReady    = $1; { Interrupt waiting status                               }

  {---------------------------}
  { Interrupt Enable Register }
  {---------------------------}

  IEREnabRE   = $1; { Enable read (receive data) interrupt status            }
  IEREnabWI   = $2; { Enable write (transmit empty) register interrupt       }
  IEREnabLSR  = $4; { Enable line status interrupt                           }
  IEREnabMSR  = $8; { Enable delta modem status interrupt                    }

  {------------------------------------------------------}
  { Serial Registers - These are the offsets from IOPort }
  {------------------------------------------------------}

  DLL = 0;  { Divisor Latch Least-significant-byte (LCR bit $80 on)          }
  DLM = 1;  { Divisor Latch Most-significant-byte (LCR bit $80 on)           }
  RBR = 0;  { Receiver Buffer Register (read)                                }
  THR = 0;  { Transmitter Holding Register (write)                           }
  IER = 1;  { Interrupt Enable Register                                      }
  IIR = 2;  { Interrupt Identification Register (read only)                  }
  LCR = 3;  { Line Control Register                                          }
  MCR = 4;  { Modem Control Register  (see above)                            }
  LSR = 5;  { Line Status Register  (see above)                              }
  MSR = 6;  { Modem Status Register  (see above)                             }
  SPR = 7;  { 8250 Scratch Pad Register                                      }

  {------------------------}
  { MISCELLANOUS CONSTANTS }
  {------------------------}

  IMR      = $21; { Port address of the Interrupt Mask Register              }

Type

  {------------------------------------}
  { communications parameter structure }
  {------------------------------------}

  TCommParam = RECORD

    BaudRate  : LONGINT;
    Parity    : CHAR;
    DataBits  : BYTE;
    StopBits  : BYTE;

  END;

  PCommParam = ^TCommParam;

  {------------------------}
  { Serial Event procedure }
  {------------------------}

  TSerEventProc = Procedure( Event : LONGINT;
                             Param1,Param2,Param3:LONGINT );

  PSerEventProc = ^TSerEventProc;


  {--------------------}
  { Serial buffer info }
  {--------------------}

  TSerBuffInfo = RECORD

    Size       : LONGINT;
    Used       : LONGINT;
    Free       : LONGINT;

    Changeable : BOOLEAN;

  END;

  PSerBuffInfo = ^TSerBuffInfo;


  {------------------------------------------------}
  { Serial driver packet / serial driver procedure }
  {------------------------------------------------}

  PSerDriverPacket = ^TSerDriverPacket;
  TSerDriverProc   = Procedure( SDPacket : PSerDriverPacket );
  PSerDriverProc   = ^TSerDriverProc;

  TSerDriverPacket = RECORD

    Func            : WORD;
    IData           : POINTER;
    SerDriverProc   : TSerDriverProc;
    DriverInfo1     : LONGINT;
    DriverInfo2     : LONGINT;
    DriverInfo3     : LONGINT;

    CommParam       : PCommParam;
    FlowConType     : INTEGER;
    OnOff           : BOOLEAN;
    Status          : LONGINT;
    Error           : LONGINT;
    Flags           : LONGINT;
    Timeout         : LONGINT;

    BuffInfo        : TSerBuffInfo;

  { EventProc       : TSerEventProc;
    EventMask       : WORD;
    EventProcInfo   : POINTER;
    EventProcHandle : TSerEventProcHandle; }

    Ch              : CHAR;
    Buf             : POINTER;
    Count           : LONGINT;
    Result          : LONGINT;

    Val             : LONGINT;

  END;

  {----------------------}
  { Event procedure list }
  {----------------------}

  PSerEventProcList = ^TSerEventProcList;

  TSerEventProcList = RECORD

    EventProc       : TSerEventProc;
    Next            : PSerEventProcList;

  END;

  {--------------------------}
  { Serial channel structure }
  {--------------------------}

  TSerChan = RECORD

    Sig              : WORD;
    SerDriverProc    : TSerDriverProc;
    SerDriverID      : POINTER;
  { EventProcList    : ... }

    WriteFlags       : LONGINT;
    WriteTimeout     : LONGINT;
    ReadFlags        : LONGINT;
    ReadTimeout      : LONGINT;
    ErrorCh          : CHAR;

    SDP              : TSerDriverPacket;

  END;

  PSerChan = ^TSerChan;



  {---------------------------------------}
  { Serial channel capabilities structure }
  {---------------------------------------}


  TSerCaps = RECORD

    CanDoEventProcs  : BOOLEAN;   { This serial channel supports EVENTS }
    CanChangeInBuff  : BOOLEAN;   { INPUT buffer size can be changed    }
    CanChangeOutBuff : BOOLEAN;   { OUTPUT buffer size can be changed   }
    CanControlRTS    : BOOLEAN;   { RTS can be manually raised/lowered  }

  END;

  PSerCaps = ^TSerCaps;


{}

(*
Procedure VSerLowBIOSInfo(             ComPort       : BYTE;
                                   Var IOPort        : WORD;
                                   Var IRQ           : BYTE;
                                   Var IntNo         : BYTE    );

*)

Implementation

{}

(*-

[FUNCTION]

Procedure VSerLowBIOSInfo(             ComPort       : BYTE;
                                   Var IOPort        : WORD;
                                   Var IRQ           : BYTE;
                                   Var IntNo         : BYTE    );

[PARAMETERS]

ComPort     Communications Port Number
IOPort      VAR Returned IO Port Number
IRQ         VAR Returned IRQ Number
IntNo       VAR Returned Interrupt Number

[RETURNS]

Function : None
(VAR     : [IOPort] IO Port Number)
(VAR     : [IRQ] Returned IRQ Number)
(VAR     : [IntNo] Returned Interrupt Number)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

(*
Procedure VSerLowBIOSInfo(             ComPort       : BYTE;
                                   Var IOPort        : WORD;
                                   Var IRQ           : BYTE;
                                   Var IntNo         : BYTE    );


{$IFNDEF OS2}
Var

  BIOSAsyncTable : Array[1..4] of WORD absolute $40:$00;

BEGIN

  {------------------------}
  { Setup port information }
  {------------------------}

  IOPort := BIOSAsyncTable[ComPort];
  IRQ    := Hi(IOPort) + 1;
  IntNo  := Hi(IOPort) + 9;

END; { VSerLowBIOSInfo }
{$ELSE}

BEGIN
 {!^!}
END;

{$ENDIF}

*)

{}
{}
{}

BEGIN
END.