{
 

 Visionix Serial Communictions Unit (VSER)
   Version 0.5
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 revision history in reverse chronological order:

 Initials  Date      Comment

     

 jrt       12/28/93  Documentation madness!

 jrt       12/06/93  Moved wait functions to VSerHu;

 jrt       12/05/93  Cleaned up, started wait functions.

 lpg       03/16/93  Added Source Documentation

 mep       02/11/93  Cleaned up code for beta release

 jrt       02/08/93  Sync with beta 0.12 release

 jrt       11/21/92  Sync with beta 0.08

 jrt       09/01/92  First logged revision.

 
}

(*-

[TEXT]

<Overview>

The VSERU unit implements a comprehensive set of functions for serial
communications.


<Interface>

-*)


Unit VSeru;

Interface

Uses

{$IFDEF VER70}
  Strings,
{$ENDIF}
  VTypesu,
  VSerLu;


{}

Const

  sfct_None       = 0;
  sfct_RtsCts     = 1;
  sfct_XonXoff    = 2;


  {-----------------}
  { TError Messages }
  {-----------------}

  ser_None               = 0;
  ser_NoMemAvail         = 1;
  ser_NoWrite            = 2;


  {------------------}
  { Status Bit Flags }
  {------------------}

  sbf_MSRctsDelta = 0;   { Clear To Send changed                     }
                         { Delta clear to send (not reliable)        }

  sbf_MSRdsrDelta = 1;   { Data Set Ready changed                    }
                         { Delta data set ready (not reliable)       }

  sbf_MSRriDelta  = 2;   { Ring Indicate changed                     }
                         { Delta data carrier detect (not reliable)  }

  sbf_MSRcdDelta  = 3;   { Carrier Detect changed                    }
                         { always set to 1 upon return (DUMMY DCD)   }

  sbf_MSRcts      = 4;   { Clear To Send                             }
                         { CTS - DCE sets - do not xmit until true   }

  sbf_MSRdsr      = 5;   { Data Set Ready                            }
                         { DSR - modem is ready to be used           }

  sbf_MSRri       = 6;   { Ring Indicate                             }
                         { RI - only on during active voltage signal }

  sbf_MSRcd       = 7;   { Carrier Detect                            }
                         { DCD - data carrier detect                 }

  sbf_LSRRcvReady = 8;   { Received data ready                       }
                         { RDA  - input data is available in buffer  }

  sbf_LSROverrun  = 9;   { OverRun error                             }
                         { OVRN - the input buffer has been overrun  }

  sbf_LSRParity   = 10;  { Parity error                              }
                         { Reserved (Parity error in BIOS INT 14h)   }

  sbf_LSRFrame    = 11;  { Framing error                             }
                         { Reserved (Framing error in BIOS INT 14h)  }

  sbf_LSRBreak    = 12;  { Break detected                            }
                         { Reserved (Break detect in BIOS INT 14h)   }

  sbf_LSRXhReady  = 13;  { Transmit hold register empty              }
                         { THRE - room is available in output buffer }

  sbf_LSRXsReady  = 14;  { Transmit shift register empty             }
                         { TSRE - output buffer is empty             }

  sbf_LSRTimeout  = 15;  { Timeout (software implemented).  If true, }
                         { then none of the above 15 bits are valid. }

  sbf_DTRReady    = 16;  { Data terminal ready                       }
                         { DTR - used as off-hook.                   }

  sbf_RTSReady    = 17;  { Request to send                           }
                         { RTS - DTE sets - use when data to xmit    }



{-----------------------------}
{ Serial ReadEx/WriteEx flags }
{-----------------------------}

Const

  csfDefault   = $00;          { Default settings (nowait/non-immediate) }
  csfNowait    = $00;          { No wait (return if char not avail/sent) }
  csfWait      = $01;          { Wait (until char is avail / sent      ) }
  csfImmediate = $02;          { Bypass read/write buffers;              }



Type

  TSerHandle = ^TSerChan;
  PSerHandle = ^TSerHandle;

  TError     = LONGINT;

{}
{}

{================}
{ Serial Channel }
{================}



Function  VSerChanNew(              Flags       : WORD;
                                    Proc        : TSerDriverProc;
                                    DriverInfo1 : LONGINT;
                                    DriverInfo2 : LONGINT;
                                    DriverInfo3 : LONGINT;
                                Var ChanHandle  : TSerHandle    ) : TError;

Procedure VSerGetCaps(              ChanHandle  : TSerHandle;
                                    Caps        : PSerCaps    );


Procedure VSerChanDispose(          ChanHandle  : TSerHandle    ) ;



{=======================}
{ Serial Channel Driver }
{=======================}


Function  VSerDriverNew(            Chan        : TSerHandle;
                                    Proc        : TSerDriverProc;
                                    DriverInfo1 : LONGINT;
                                    DriverInfo2 : LONGINT;
                                    DriverInfo3 : LONGINT      ) : TError;

Procedure VSerDriverDispose(        Handle      : TSerHandle    ) ;




Function  VSerChanActivate(         Chan        : TSerHandle;
                                    CommParam   : PCommParam    ) : TError;

Function  VSerChanDeactivate(       Chan        : TSerHandle    ) : TError;



{========================}
{ Serial Channel Control }
{========================}

Function  VSerGetCommParam(         Chan        : TSerHandle;
                                    CommParam   : PCommParam    ) : TError;

Function  VSerSetCommParam(         Chan        : TSerHandle;
                                    CommParam   : PCommParam    ) : TError;

Function  VSerGetBaud(              Chan        : TSerHandle    ) : LONGINT;

Function  VSerGetParity(            Chan        : TSerHandle    ) : CHAR;

Function  VSerGetDataBits(          Chan        : TSerHandle    ) : BYTE;

Function  VSerGetStopBits(          Chan        : TSerHandle    ) : BYTE;

Function  VSerSetBaud(              Chan        : TSerHandle;
                                    BaudRate    : LONGINT       ) : TError;

Function  VSerSetParity(            Chan        : TSerHandle;
                                    Parity      : CHAR          ) : TError;


Function  VSerSetDataBits(          Chan        : TSerHandle;
                                    DataBits    : WORD          ) : TError;

Function  VSerSetStopBits(          Chan        : TSerHandle;
                                    StopBits    : WORD          ) : TError;



  {--------------}
  { Flow Control }
   {--------------}

Function  VSerGetFlowConType(       Chan        : TSerHandle    ) : INTEGER;

Function  VSerSetFlowConType(       Chan        : TSerHandle;
                                    FlowConType : INTEGER       ) : TError;

Function  VSerGetFlowConChars(      Chan        : TSerHandle;
                                Var Startchar   : CHAR;
                                Var Stopchar    : CHAR          ) : TError;

Function  VSerSetFlowConChars(      Chan        : TSerHandle;
                                    Startchar   : CHAR;
                                    Stopchar    : CHAR          ) : TError;

Function  VSerTurnSendOn(           Chan        : TSerHandle    ) : TError;

Function  VSerTurnSendOff(          Chan        : TSerHandle    ) : TError;

Function  VserTurnReceiveOn(        Chan        : TSerHandle    ) : TError;

Function  VSerTurnReceiveOff(       Chan        : TSerHandle    ) : TError;


  {---------------------------}
  { line/modem control/status }
  {---------------------------}

Function  VSerGetLineControl(       Chan        : TSerHandle    ) : WORD;

Function  VSerGetLineStatus(        Chan        : TSerHandle    ) : WORD;

Function  VSerGetModemControl(      Chan        : TSerHandle    ) : WORD;

Function  VSerGetModemStatus(       Chan        : TSerHandle    ) : WORD;

Function  VSerGetStatus(            Chan        : TSerHandle    ) : LONGINT;

Function  VSerGetStatusBit(         Chan        : TSerHandle;
                                    Bit         : BYTE          ) : BOOLEAN;

Function  VSerCarrier(              Chan        : TSerHandle    ) : BOOLEAN;

Function  VSerRing(                 Chan        : TSerHandle    ) : BOOLEAN;

Function  VSerInAvail(              Chan        : TSerHandle    ) : BOOLEAN;

Function  VSerInFull(               Chan        : TSerHandle    ) : BOOLEAN;

Function  VSerOutReady(             Chan        : TSerHandle    ) : BOOLEAN;

Function  VSerOutEmpty(             Chan        : TSerHandle    ) : BOOLEAN;


  {-------------------}
  { Line/Modem change }
  {-------------------}

Function  VSerTurnDTROn(            Chan        : TSerHandle    ) : TError;

Function  VSerTurnDTROff(           Chan        : TSerHandle    ) : TError;

(*
Function  VSerDropDTR(              Chan        : TSerHandle;
                                    DTLen       : LONGINT       ) : TError;
*)

Function  VSerTurnBreakOn(          Chan        : TSerHandle    ) : TError;

Function  VSerTurnBreakOff(         Chan        : TSerHandle    ) : TError;

Function  VSerBreak(                Chan        : TSerHandle;
                                    BreakLen    : LONGINT       ) : TError;

Function  VSerTurnRTSON(            Chan        : TSerHandle    ) : TError;

Function  VSerTurnRTSOff(           Chan        : TSerHandle    ) : TError;

  {----------------}
  { Buffer Control }
  {----------------}

Function  VSerFlushOutBuff(         Chan        : TSerHandle    ) : TError;

Function  VSerPurgeOutBuff(         Chan        : TSerHandle    ) : TError;

Function  VSerPurgeInBuff(          Chan        : TSerHandle    ) : TError;

Function  VSerGetInBuffInfo(        Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;

Function  VSerSetInBuffInfo(        Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;

Function  VSerGetOutBuffInfo(       Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;

Function  VSerSetOutBuffInfo(       Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;


Function  VSerGetInAvail(           Chan        : TSerHandle    ) : LONGINT;

Function  VSerGetOutFree(           Chan        : TSerHandle    ) : LONGINT;





{==============}
{ Serial Event }
{==============}
(*
Procedure VSerEventProcNew(         Chan        : TSerHandle;
                                    Proc        : TSerEventProc;
                                    EventMask   : WORD;
                                    ProcInfo    : Pointer;
                                Var ProcHandle  : TSerHandle    ) : TError;

Procedure VSerEventProcOff(         ProcHandle  : TSerHandle    );

Procedure VSerEventProcOn(          ProcHandle  : TSerHandle    );

Procedure VSerEventProcDispose(     ProcHandle  : TSerHandle    );
*)



{====================}
{ Serial Channel I/O }
{====================}


Function  VSerWriteChEx(            Chan        : TSerHandle;
                                    Flags       : WORD;
                                    OutCh       : CHAR;
                                    Timeout100s : LONGINT       ) : TError;

Function  VSerWriteBlockEx(         Chan        : TSerHandle;
                                    Flags       : WORD;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT      ) : TError;

Function  VSerWriteStEx(            Chan        : TSerHandle;
                                    Flags       : WORD;
                                    ST          : STRING;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT      ) : TError;

{$IFDEF VER70}
Function  VSerWritePchEx(           Chan        : TSerHandle;
                                    Flags       : WORD;
                                    Pch         : PChar;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT     ) : TError;
{$ENDIF}
{---}


Function  VSerSetWriteTimeout(      Chan        : TSerHandle;
                                    TimeOut100s : LONGINT      ) : TError;

Function  VSerSetWriteFlags(        Chan        : TSerHandle;
                                    Flags       : WORD         ) : TError;

Function  VSerGetWriteTimeout(      Chan        : TSerHandle   ) : LONGINT;

Function  VSerGetWriteFlags(        Chan        : TSerHandle   ) : WORD;



Function  VSerWriteCh(              Chan        : TSerHandle;
                                    OutCh       : CHAR        ) : TError;

Function  VSerWriteBlock(           Chan        : TSerHandle;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER     ) : TError;

Function  VSerWriteSt(              Chan        : TSerHandle;
                                    St          : STRING      ) : TError;

{$IFDEF VER70}

Function  VSerWritePch(             Chan        : TSerHandle;
                                    Pch         : PChar       ) : TError;

{$ENDIF}

{---}

Function  VSerReadChEx(             Chan        : TSerHandle;
                                    Flags       : WORD;
                                Var InCh        : CHAR;
                                    Timeout100s : LONGINT       ) : TError;

Function  VSerReadBlockEx(          Chan        : TSerHandle;
                                    Flags       : WORD;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT      ) : TError;

Function  VSerReadStEx(             Chan        : TSerHandle;
                                    Flags       : WORD;
                                    STSize      : WORD;
                                Var ST          : STRING;
                                    TimeOut100s : LONGINT      ) : TError;

Function  VSerReadPchEx(            Chan        : TSerHandle;
                                    Flags       : WORD;
                                    PchSize     : LONGINT;
                                    Pch         : PChar;
                                    TimeOut100s : LONGINT      ) : TError;

{---}

Function  VSerSetReadTimeout(       Chan        : TSerHandle;
                                    TimeOut100s : LONGINT      ) : TError;

Function  VSerSetReadFlags(         Chan        : TSerHandle;
                                    Flags       : WORD         ) : TError;

Function  VSerGetReadTimeout(       Chan        : TSerHandle   ) : LONGINT;

Function  VSerGetReadFlags(         Chan        : TSerHandle   ) : WORD;




Function  VSerReadCh(               Chan        : TSerHandle;
                                Var InCh        : CHAR        ) : TError;

Function  VSerReadBlock(            Chan        : TSerHandle;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER     ) : TError;

Function  VSerReadSt(               Chan        : TSerHandle;
                                    STSize      : WORD;
                                Var St          : STRING      ) : TError;



Function  VSerReadPCh(              Chan        : TSerHandle;
                                    PchSize     : LONGINT;
                                    Pch         : PChar       ) : TError;

Function  VSerGetCh(                Chan        : TSerHandle  ) : CHAR;

Function  VSerGetStEx(              Chan        : TSerHandle;
                                    MaxBytes    : BYTE        ) : STRING;

Function  VSerGetSt(                Chan        : TSerHandle  ) : STRING;







(*
Procedure VSerWriteCh(              Chan        : TSerHandle;
                                    OutCh       : CHAR          );


Function  VSerWriteChEx(            Chan        : TSerHandle;
                                    OutCh       : CHAR          ) : TError;

Function  VSerWriteBlock(           Chan        : TSerHandle;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : Pointer;
                                Var XFerCount   : LONGINT       ) : TError;

Function  VSerWriteSt(              Chan        : TSerHandle;
                                    S           : STRING        ) : TError;

Function  VSerReadCh(               Chan        : TSerHandle    ) : CHAR;

Function  VSerReadChEx(             Chan        : TSerHandle;
                                Var Ch          : CHAR          ) : TError;

Function  VSerReadBlock(            Chan        : TSerHandle;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : Pointer;
                                Var XFerCount   : LONGINT       ) : TError;

Function  VSerReadSt(               Chan        : TSerHandle;
                                    MaxStSize   : BYTE;
                                Var St          : STRING        ) : TError;

*)

Function  VSerPeekCh(               Chan        : TSerHandle;
                                Var Ch          : CHAR          ) : TError;


{}
{}

IMPLEMENTATION


{}

(*-

[FUNCTION]

Function  VSerChanNew(              Flags       : WORD;
                                    Proc        : TSerDriverProc;
                                    DriverInfo1 : LONGINT;
                                    DriverInfo2 : LONGINT;
                                    DriverInfo3 : LONGINT;
                                Var ChanHandle  : TSerHandle    ) : TError;

[PARAMETERS]

Flags       Channel new flags (0)
Proc        Serial channel driver procedure
DriverInfo1 Information passed to serial channel driver
DriverInfo1 Information passed to serial channel driver
DriverInfo1 Information passed to serial channel driver
Chanhandle  (RETURNS) handle for the new channel

[RETURNS]

0 if successfully, otherwise a serial error value.

ChanHandle  handle for the new channel.

[DESCRIPTION]

This function creates a new serial channel.  A serial channel is a link
to a specific serial port on a specific serial driver.

Flags are currently 0.

Proc is the address of a serial channel driver procedure.  VisionTools
comes with three serial channel driver procedures:

  Name             Description                          Unit
  ---------------- ------------------------------------ --------------

  FosDriverProc    for FOSSIL drivers                   VFOSU
  UartDriverProc   for direct UART programming          VUARTU
  OS2SerDriverProc for OS/2 serial drivers              VOS2SERU

DriverInfo1,2, and 3 are paramaters which are passed to the specified
serial driver procedure.

DriverInfo1 is used to specify which port the driver should connect
this new channel two.  Values are typically in the range from 1-8.

DriverInfo2 and DriverInfo3 are not currently used by any of the
three VisionTools supplied serial channel driver procedures.

[SEE-ALSO]

[EXAMPLE]

  { To create a new channel attached to port 2 of the FOSSSIL driver }

  Error  := VSerChanNew( 0,
                         FosDriverProc,
                         2,
                         0,
                         0,
                         Mychan           );

  { To create a new channel attached to port 1 of the UART driver }

  Error  := VSerChanNew( 0,
                         UartDriverProc,
                         1,
                         0,
                         0,
                         Mychan           );


-*)

Function  VSerChanNew(              Flags       : WORD;
                                    Proc        : TSerDriverProc;
                                    DriverInfo1 : LONGINT;
                                    DriverInfo2 : LONGINT;
                                    DriverInfo3 : LONGINT;
                                Var ChanHandle  : TSerHandle    ) : TError;

BEGIN

  If ( MaxAvail >= SizeOf( TSerChan ) ) Then
  BEGIN

    New( ChanHandle );
    FillChar( ChanHandle^, SizeOf( TSerChan ), 0 );

    ChanHandle^.Sig  := $CBAD;

    VSerChanNew := VSerDriverNew( ChanHandle,
                                  Proc,
                                  DriverInfo1,
                                  DriverInfo2,
                                  DriverInfo3      );

  END  { If MaxAvail }

  Else
    VSerChanNew := ser_NoMemAvail;

END;  { VSerChanNew }

{}

(*-

[FUNCTION]

Procedure VSerGetCaps(              ChanHandle  : TSerHandle;
                                    Caps        : PSerCaps    );

[PARAMETERS]

Caps        Pointer to TSerCaps serial capabilities record.

[RETURNS]

"Caps" filled in.

[DESCRIPTION]

This function will obtain the capabilities information from the
specified serial channel.

  TSerCaps = RECORD

    CanDoEventProcs  : BOOLEAN;   { This serial channel supports EVENTS }
    CanChangeInBuff  : BOOLEAN;   { INPUT buffer size can be changed    }
    CanChangeOutBuff : BOOLEAN;   { OUTPUT buffer size can be changed   }
    CanControlRTS    : BOOLEAN;   { RTS can be manually raised/lowered  }

  END;

[SEE-ALSO]

[EXAMPLE]

Var

  SCaps : TSerCaps;

BEGIN

  VSerGetCaps( MyChan, @SCaps );

  If SCaps.CanDoEventProc=TRUE Then
    WriteLn('This serial channel supports events.')
  Else
    WriteLn('This serial channel does NOT support events.');


END;

-*)

Procedure VSerGetCaps(              ChanHandle  : TSerHandle;
                                    Caps        : PSerCaps    );

BEGIN

END;  { VSerGetCaps }


{}

(*-

[FUNCTION]

Procedure VSerChanDispose(          ChanHandle  : TSerHandle    ) ;

[PARAMETERS]

ChanHandle  serial channel handle

[RETURNS]

(None)

[DESCRIPTION]

This function disposes of a serial channel that was previously allocated
via a call to VSerChanNew.  This function automatically calls
VSerDriverDispose to insure that the serial driver connected to this
channel is properly closed.  This function should _always_ be called
when you are done with the serial channel.  This function automatically
calls VSerChanDeactivate.

[SEE-ALSO]

[EXAMPLE]


  VSerchanDispose( MyChan );

-*)

Procedure VSerChanDispose(          ChanHandle  : TSerHandle    ) ;

BEGIN

  If ChanHandle^.Sig = $CBAD Then
  BEGIN

    If @ChanHandle^.SerDriverProc<>NIL Then
      VSerDriverDispose( ChanHandle );

    Dispose( ChanHandle );

  END;

END;  { VSerChanDispose }



{}

(*-

[FUNCTION]

Function  VSerDriverNew(            Chan        : TSerHandle;
                                    Proc        : TSerDriverProc;
                                    DriverInfo1 : LONGINT;
                                    DriverInfo2 : LONGINT;
                                    DriverInfo3 : LONGINT      ) : TError;

[PARAMETERS]

Chan        Serial channel handle
Proc        Pointer to Serial Device Driver Procedure
DriverInfo1 paramater passed to the serial driver procedure.
DriverInfo1 paramater passed to the serial driver procedure.
DriverInfo1 paramater passed to the serial driver procedure.

[RETURNS]

0 if successfull, otherwisea serial error value.

[DESCRIPTION]

This function attaches a new serial driver to the specified serial
channel.  It should only be used when you want to dynamically change
what serial driver or port a channel is attached to after the
channel has been created.

[SEE-ALSO]

[EXAMPLE]

  { attach UART serial driver on COM1 to the channel }

  Err := VSerDriverNew( MyChan,
                        UartDriverProc,
                        1,
                        0,
                        0                     );

-*)

Function  VSerDriverNew(            Chan        : TSerHandle;
                                    Proc        : TSerDriverProc;
                                    DriverInfo1 : LONGINT;
                                    DriverInfo2 : LONGINT;
                                    DriverInfo3 : LONGINT      ) : TError;

BEGIN

  With Chan^ Do
  BEGIN

    SDP.Func          := SDFDriverNew;
    SDP.DriverInfo1   := DriverInfo1;
    SDP.DriverInfo2   := DriverInfo2;
    SDP.DriverInfo3   := DriverInfo3;
    SDP.SerDriverProc := Proc;
    SDP.Error         := 0;

    Proc( @SDP );

    If SDP.Error=0 Then          { install }
    BEGIN

      Chan^.SerDriverProc := SDP.SerDriverProc;
      Chan^.SerDriverID   := SDP.IData;

      Chan^.WriteFlags    := 0;
      Chan^.WriteTimeout  := -1;
      Chan^.ReadFlags     := 0;
      Chan^.ReadTimeout   := -1;

      Chan^.ErrorCh       := #255;

      VSerDriverNew := 0;

    END  { Uf SDP.Error }
    Else
    BEGIN

      VSerDriverNew := SDP.Error;

    END; { If SDP.Error / Else }  { (install) / else }

  END;  { With Chan^ }

END;  { VSerDriverNew }

{}

(*-

[FUNCTION]

Procedure VSerDriverDispose(        Handle      : TSerHandle    ) ;

[PARAMETERS]

Handle      serial channel handle

[RETURNS]

nothing.

[DESCRIPTION]

This function properly closes the serial driver attached to the
specified serial channel.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VSerDriverDispose(        Handle      : TSerHandle    ) ;

BEGIN

  VSerChanDeactivate( Handle );

  With Handle^ Do
  BEGIN

    SDP.Func          := SDFDriverDispose;
    SDP.Error         := 0;

    SerDriverProc( @SDP );

    @SDP.SerDriverProc := NIL;  { !! }

  END;  { With Handle^ }

END;  { VSerDriverDispose }

{}

{-----------------------------------}
{ Serial Channel control procedures }
{-----------------------------------}

(*-

[FUNCTION]

Function  VSerChanActivate(         Chan        : TSerHandle;
                                    CommParam   : PCommParam    ) : TError;

[PARAMETERS]

Chan        Serial channel handle
CommParam   Pointer to a serial communications paramaters record

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function activates the specified serial channel.  This function
must be called after the channel has been created (VSerChannew),
but before any other functions are used.

CommParam is a pointer to a serial communications paramaters structure
that should contain the initial settings of the serial channel:

  TCommParam = RECORD

    BaudRate  : LONGINT;         { Baudrate for the channel }
    Parity    : CHAR;            { Parity (N,E,O,M, or S    }
    DataBits  : BYTE;            { # of data bits (8/7)     }
    StopBits  : BYTE;            { # of stop bits (0/1/2)   }

  END;

[SEE-ALSO]

[EXAMPLE]


  { To create a new channel attached to port 2 of the FOSSSIL driver }

  Error  := VSerChanNew( 0,
                         FosDriverProc,
                         2,
                         0,
                         0,
                         Mychan           );

  { to activate the channel at settings 2400bps, no parity, 8 data bits }
  { and 1 stop bit.                                                     }

  CP.BaudRate   := 2400;
  CP.Parity     := 'N';
  CP.DataBits   := 8;
  CP.StopBits   := 1;

  Err := VSerChanActivate( Mychan, @CP );


-*)

Function  VSerChanActivate(         Chan        : TSerHandle;
                                    CommParam   : PCommParam    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFActivate;
      SDP.CommParam := CommParam;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      VSerChanActivate := SDP.Error;

    END  { With Chan^ }

  Else
    VSerChanActivate := $FBAD;

END;  { VSerChanActivate }

{}

(*-

[FUNCTION]

Function  VSerChanDeactivate(       Chan        : TSerHandle     ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function deactivates the port to which the specified serial
channel is attached.

[SEE-ALSO]

[EXAMPLE]

  VSerChanDeactivate( Chan );

-*)

Function  VSerChanDeactivate(       Chan        : TSerHandle    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFDeActivate;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      VSerChanDeactivate := SDP.Error;

    END  { With Chan^ }

  Else
    VSerChanDeactivate := $FBAD;

END;  { VSerChanDeactivate }

{}
{                                                                           }
{             C O M M     P A R A M        F U N C T I O N S                }
{                                                                           }
{}

(*-

[FUNCTION]

Function  VSerGetCommParam(         Chan        : TSerHandle;
                                    CommParam   : PCommParam    ) : TError;

[PARAMETERS]

Chan        Serial channel handle
CommParam   pointer to a variable of type TCommParam that will receive
            the current communications paramaters.

[RETURNS]

CommParam   filled in with the current communications paramaters of
            the specified serial channel.

[DESCRIPTION]

This function gets the current communications paramaters of the
specified serial channel.

  TCommParam = RECORD

    BaudRate  : LONGINT;         { Baudrate for the channel }
    Parity    : CHAR;            { Parity (N,E,O,M, or S    }
    DataBits  : BYTE;            { # of data bits (8/7)     }
    StopBits  : BYTE;            { # of stop bits (0/1/2)   }

  END;

[SEE-ALSO]

[EXAMPLE]

Var

  CP  : TCommParam;
  Err : TError;

BEGIN

  Err := VSerGetCommParam( MyChan, @CP );

  WriteLn( 'Baud Rate .......... ', CP.Baudrate );
  WriteLn( 'Parity ............. ', CP.Parity   );
  WriteLn( 'Data Bits .......... ', CP.DataBits );
  WriteLn( 'Stop Bits .......... ', CP.StopBits );


END;


-*)

Function  VSerGetCommParam(         Chan        : TSerHandle;
                                    CommParam   : PCommParam    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetCommParam;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      CommParam        := SDP.CommParam;

      VSerGetCommParam := SDP.Error;

    END  { With Chan^ }

  Else
    VSerGetCommParam := $FBAD;

END;  { VSerGetCommParam }

{}

(*-

[FUNCTION]

Function  VSerSetCommParam(         Chan        : TSerHandle;
                                    CommParam   : PCommParam    ) : TError;

[PARAMETERS]

Chan        Serial channel handle
CommParam   a variable of the TCommParam structure type.

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function sets the communications paramaters of the specified
serial channel.


  TCommParam = RECORD

    BaudRate  : LONGINT;         { Baudrate for the channel }
    Parity    : CHAR;            { Parity (N,E,O,M, or S    }
    DataBits  : BYTE;            { # of data bits (8/7)     }
    StopBits  : BYTE;            { # of stop bits (0/1/2)   }

  END;


[SEE-ALSO]

[EXAMPLE]

Function SetComm2To2400N81;

Var

  CP : TCommParam;

BEGIN

  { global variable mychan should have serial channel handle }

  CP.ComPort    := 2;
  CP.BaudRate   := 2400;
  CP.Parity     := 'N';
  CP.DataBits   := 8;
  CP.StopBits   := 1;

  Err := VSerSetCommParam( MyChan, @CP );

END;

-*)

Function  VSerSetCommParam(         Chan        : TSerHandle;
                                    CommParam   : PCommParam    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFSetCommParam;
      SDP.CommParam := CommParam;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      VSerSetCommParam := SDP.Error;

    END  { With Chan^ }

  Else
    VSerSetCommParam := $FBAD;

END;  { VSerSetCommParam }


{}

(*-

[FUNCTION]

Function  VSerGetBaud(              Chan        : TSerHandle    ) : LONGINT;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

Current baud rate of the specified channel.
-1 if an error occurred.

[DESCRIPTION]

This function gets and returns the current baud rate of the
specified serial channel.

[SEE-ALSO]

[EXAMPLE]

  WriteLn(' Baud Rate = ', VSerGetbaud( MyChan ) );

-*)

Function  VSerGetBaud(              Chan        : TSerHandle    ) : LONGINT;

Var

  CP   : TCommParam;

BEGIN

  If VSerGetCommParam( Chan, @CP )=0 Then
  BEGIN
    VSerGetBaud := CP.BaudRate;
  END
  ELSE
    VSerGetBaud := -1;

END;

{}

(*-

[FUNCTION]

Function  VSerGetParity(            Chan        : TSerHandle    ) : CHAR;

[PARAMETERS]

Chan        Serial channel

[RETURNS]

Current parity setting the specified channel.

  ?    Parity unknown/function error.
  N    No parity
  E    Even parity
  O    Odd Parity
  M    Mark parity
  S    Space parity

[DESCRIPTION]

This function returns the current parity setting of the specified
serial channel.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetParity(            Chan        : TSerHandle    ) : CHAR;

Var

  CP   : TCommParam;

BEGIN

  If VSerGetCommParam( Chan, @CP )=0 Then
  BEGIN
    VSerGetParity := CP.Parity;
  END
  ELSE
    VSerGetParity := '?';

END;

{}

(*-

[FUNCTION]

Function  VSerGetDataBits(          Chan        : TSerHandle    ) : BYTE;

[PARAMETERS]

Chan        Serial channel

[RETURNS]

The current data-bits setting of the specified serial channel
($FF if an error occurred)

[DESCRIPTION]

This function returns the current data-bits setting of the specified
serial channel.  If the information is unknown or an error occurred,
this function will return $FF.

[SEE-ALSO]

[EXAMPLE]

  WriteLn('Data Bits = ',VSerGetDataBits( MyChan ) );

-*)

Function  VSerGetDataBits(          Chan        : TSerHandle    ) : BYTE;

Var

  CP   : TCommParam;

BEGIN

  If VSerGetCommParam( Chan, @CP )=0 Then
  BEGIN
    VSerGetDatabits := CP.Databits;
  END
  ELSE
    VSerGetDatabits := $FF;

END;

{}

(*-

[FUNCTION]

Function  VSerGetStopBits(          Chan        : TSerHandle    ) : BYTE;

[PARAMETERS]

Chan        Serial channel

[RETURNS]

Current stop-bits setting of the specifed serial channel.
($FF if an error occurred)

This function returns the current stop-bits setting of the specified
serial channel.  If the information is unknown or an error occurred,
this function will return $FF.

[SEE-ALSO]

[EXAMPLE]

  WriteLn('Stop Bits = ',VSerGetStopBits( MyChan ) );

-*)

Function  VSerGetStopBits(          Chan        : TSerHandle    ) : BYTE;

Var

  CP   : TCommParam;

BEGIN

  If VSerGetCommParam( Chan, @CP )=0 Then
  BEGIN
    VSerGetStopBits := CP.StopBits;
  END
  ELSE
    VSerGetStopBits := $FF;

END;

{}

(*-

[FUNCTION]

Function  VSerSetBaud(              Chan        : TSerHandle;
                                    BaudRate    : LONGINT       ) : TError;

[PARAMETERS]

Chan        Serial channel
Baudrate    new baudrate

[RETURNS]

0 if successfull, otherwise a serial error.

[DESCRIPTION]

This function changes the baud rate of the specifed serial channel
to the new value "baudrate"

[SEE-ALSO]

[EXAMPLE]

  Err := VSerSetBaud( MyChan,
                      19200     );


-*)

Function  VSerSetBaud(              Chan        : TSerHandle;
                                    BaudRate    : LONGINT       ) : TError;

Var

  CP   : TCommParam;

BEGIN

  If VSerGetCommParam( Chan, @CP )=0 Then
  BEGIN
    CP.BaudRate := BaudRate;

    VSerSetBaud := VSerSetCommParam( Chan, @CP );
  END
  ELSE
    VSerSetBaud := $FFFF;

END;

{}

(*-

[FUNCTION]

Function  VSerSetParity(            Chan        : TSerHandle;
                                    Parity      : CHAR          ) : TError;

[PARAMETERS]

Chan        Serial channel handle
Parity      new parity value

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function changes the parity setting of the specified serial
channel.  The parity value can be any one of the following:

  N    No parity
  E    Even parity
  O    Odd Parity
  M    Mark parity
  S    Space parity

[SEE-ALSO]

[EXAMPLE]

  Err := VSerSetParity( MyChan, 'N' );

-*)

Function  VSerSetParity(            Chan        : TSerHandle;
                                    Parity      : CHAR          ) : TError;


Var

  CP   : TCommParam;

BEGIN

  If VSerGetCommParam( Chan, @CP )=0 Then
  BEGIN
    CP.Parity := Parity;

    VSerSetParity := VSerSetCommParam( Chan, @CP );
  END
  ELSE
    VSerSetParity := $FFFF;

END;

{}

(*-

[FUNCTION]

Function  VSerSetDataBits(          Chan        : TSerHandle;
                                    DataBits    : WORD          ) : TError;

[PARAMETERS]

Chan        Serial channel handle
Databits    new data-bits setting

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function changes the data-bits setting of the specified serial
channel.  The value is typically other 7 or 8.

[SEE-ALSO]

[EXAMPLE]

  Err := VSerSetDataBits( MyChan, 8 );

-*)

Function  VSerSetDataBits(          Chan        : TSerHandle;
                                    DataBits    : WORD          ) : TError;

Var

  CP   : TCommParam;

BEGIN

  If VSerGetCommParam( Chan, @CP )=0 Then
  BEGIN
    CP.Databits := Databits;

    VSerSetDatabits := VSerSetCommParam( Chan, @CP );
  END
  ELSE
    VSerSetDatabits := $FFFF;

END;

{}

(*-

[FUNCTION]

Function  VSerSetStopBits(          Chan        : TSerHandle;
                                    StopBits    : WORD          ) : TError;

[PARAMETERS]

Chan        Serial channel handle
Stopbits    new stop-bits setting

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function changes the stop-bits setting of the specified serial
channel.  The value is typically other 0, 1 or 2.

[SEE-ALSO]

[EXAMPLE]

  Err := VSerSetStopBits( MyChan, 1 );

-*)

Function  VSerSetStopBits(          Chan        : TSerHandle;
                                    StopBits    : WORD          ) : TError;

Var

  CP   : TCommParam;

BEGIN

  If VSerGetCommParam( Chan, @CP )=0 Then
  BEGIN
    CP.Stopbits := StopBits;

    VSerSetStopbits := VSerSetCommParam( Chan, @CP );
  END
  ELSE
    VSerSetStopbits := $FFFF;

END;




{}
{                                                                           }
{             F L O W     C O N T R O L    F U N C T I O N S                }
{                                                                           }
{}

(*-

[FUNCTION]

Function  VSerGetFlowConType(       Chan        : TSerHandle    ) : INTEGER;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetFlowConType(       Chan        : TSerHandle    ) : INTEGER;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetFlowConType;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      VSerGetFlowConType := SDP.FlowConType;

    END  { With Chan^ }

  Else
    VSerGetFlowConType := -1;

END;  { VSerGetFlowConType }

{}

(*-

[FUNCTION]

Function  VSerSetFlowConType(       Chan        : TSerHandle;
                                    FlowConType : INTEGER       ) : TError;

[PARAMETERS]

Chan        Serial channel handle
FlowconType ?

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerSetFlowConType(       Chan        : TSerHandle;
                                    FlowConType : INTEGER       ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func        := SDFSetFlowConType;
      SDP.FlowConType := FlowConType;
      SDP.Error       := 0;

      SerDriverProc( @SDP );

      VSerSetFlowConType := SDP.Error;

    END  { With Chan^ }

  Else
    VSerSetFlowConType := $FBAD;

END;  { VSerSetFlowConType }

{}


(*-

[FUNCTION]

Function  VSerGetFlowConChars(      Chan        : TSerHandle;
                                Var Startchar   : CHAR;
                                Var Stopchar    : CHAR          ) : TError;

[PARAMETERS]

Chan        Serial channel handle
FlowconType ?

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)


Function  VSerGetFlowConChars(      Chan        : TSerHandle;
                                Var Startchar   : CHAR;
                                Var Stopchar    : CHAR          ) : TError;


BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetFlowConChars;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      {!^!}

    END  { With Chan^ }

  Else
    VSerGetFlowConChars := $FFFF;

END;

{}

(*-

[FUNCTION]

Function  VSerSetFlowConChars(      Chan        : TSerHandle;
                                    Startchar   : CHAR;
                                    Stopchar    : CHAR          ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)


Function  VSerSetFlowConChars(      Chan        : TSerHandle;
                                    Startchar   : CHAR;
                                    Stopchar    : CHAR          ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFSetFlowConChars;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      {!^!}

    END  { With Chan^ }

  Else
    VSerSetFlowConChars := $FFFF;

END;

{}

(*-

[FUNCTION]

Function  VSerTurnSendOn(           Chan        : TSerHandle    ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function ...

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerTurnSendOn(           Chan        : TSerHandle    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFTurnSendOnOff;
      SDP.OnOff     := TRUE;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      VSerTurnSendOn := SDP.Error;

    END  { With Chan^ }

  Else
    VSerTurnSendOn := $FBAD;

END;  { VSerTurnSendOn }

{}

(*-

[FUNCTION]

Function  VSerTurnSendOff(          Chan        : TSerHandle    ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function disables...

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerTurnSendOff(          Chan        : TSerHandle    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFTurnSendOnOff;
      SDP.OnOff     := FALSE;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      VSerTurnSendOff := SDP.Error;

    END  { With Chan^ }

  Else
    VSerTurnSendOff := $FBAD;

END;  { VSerTurnSendOff }

{}

(*-

[FUNCTION]

Function  VserTurnReceiveOn(        Chan        : TSerHandle    ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VserTurnReceiveOn(        Chan        : TSerHandle    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFTurnReceiveOnOff;
      SDP.OnOff     := TRUE;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      VSerTurnReceiveOn := SDP.Error;

    END  { With Chan^ }

  Else
    VSerTurnReceiveOn := $FBAD;

END;  { VSerTurnReceiveOn }

{}

(*-

[FUNCTION]

Function  VSerTurnReceiveOff(       Chan        : TSerHandle    ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

[DESCRIPTION]

0 if successfull, otherwise a serial error value.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerTurnReceiveOff(       Chan        : TSerHandle    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFTurnReceiveOnOff;
      SDP.OnOff     := FALSE;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      VSerTurnReceiveOff := SDP.Error;

    END  { With Chan^ }

  Else
    VSerTurnReceiveOff := $FBAD;

END;  { VSerTurnReceiveOff }

{}
{                                                                           }
{         L I N E  /  M O D E M    S T A T U S     F U N C T I O N S        }
{                                                                           }
{}


(*-

[FUNCTION]


Function  VSerGetLineControl(       Chan        : TSerHandle    ) : WORD;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

The current line-control value for the specified serial channel.


       7   6   5   4   3   2   1   0
           |   |   |   |   |   [-+-]
           |   |   |   |   |     |
           |   |   |   |   |     Data Bits (0=5,1=6,2=7,3=8)
           |   |   |   |   |
           |   |   |   |   |
           |   |   |   |   Stop Bits (0=1, 1=2)
           |   |   |   |
           |   |   |   |
           |   |   |   Parity is enabled flag (0=off, 1=on)
           |   |   |
           |   |   |
           |   |   Parity even/odd flag (0=odd, 1=even)
           |   |
           |   |
           |   Sticky parity flag (0=nonsticky,1=sticky)
           |
           |
           Break flag (0=break is off, 1=break is on)


  cDataBitsMask      = $01+$02;     { Data bits (wordsize) mask    }
  cDataBits5         = $00;         { Data bits = 5                }
  cDataBits6         = $01;         { Data bits = 6                }
  cDataBits7         = $02;         { Data bits = 7                }
  cDataBits8         = $01+$02;     { Data bits = 8                }

  cStopBits1         = $00;         { Stop bits = 1                }
  cStopBits2         = $04;         { Stop bits = 2                }

  cParityEnable      = $08;         { Enable parity                }

  cParityEven        = $10;         { even parity                  }

  cStickyParity      = $20;         { sticky parity                }

  cBreakOn           = $40;         { turn break on                }

  cAccessDivLatch    = $80;         { access divisor latch         }


[DESCRIPTION]

This function gets and returns the line control value for the
specified serial channel.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetLineControl(       Chan        : TSerHandle    ) : WORD;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetLineControl;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      If SDP.Error=0 Then
        VSerGetLineControl := SDP.Val
      Else
        VSerGetLineControl := $FFFF;

    END  { With Chan^ }

  Else
    VSerGetLineControl := $FFFF;

END;  { VSerGetLineControl }

{}



(*-

[FUNCTION]


Function  VSerGetLineStatus(        Chan        : TSerHandle    ) : WORD;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

Line status value of the specified serial channel.


[DESCRIPTION]


       7   6   5   4   3   2   1   0--Data is in receive buffer flag
           |   |   |   |   |   |
           |   |   |   |   |   |
           |   |   |   |   |   Read buffer over-run error flag
           |   |   |   |   |
           |   |   |   |   |
           |   |   |   |   Parity error flag
           |   |   |   |
           |   |   |   |
           |   |   |   Framing error flag
           |   |   |
           |   |   |
           |   |   Incoming break flag (0=incoming break off,1=on)
           |   |
           |   |
           |   Trasmit holding register empty flag
           |
           |
           Transmit shift register empty flag



  cDataInRcvBuff     = $01;         { data in receive buffer       }
  cOverrunError      = $02;         { overrrun error               }
  cParityError       = $04;         { parity error                 }
  cFramingError      = $08;         { framing error                }
  cIncomingBreak     = $10;         { incoming break detected      }
  cTHREmpty          = $20;         { Transmit holding reg is empty}
  cTSREmpty          = $40;         { Transmit shift   reg is empty}
  cFIFORcvError      = $80;         { 16550 Fifo receive error     }


[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetLineStatus(        Chan        : TSerHandle    ) : WORD;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetLineStatus;
      SDP.Error     := 0;

      SerDriverProc( @SDP );

      VSerGetLineStatus := (SDP.Status AND $FF00) SHR 8;

    END  { With Chan^ }

  Else
    VSerGetLineStatus := $FFFF;

END;

{}



(*-

[FUNCTION]


Function  VSerGetModemControl(       Chan        : TSerHandle    ) : WORD;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

Modem control value of the specified serial channel.

[DESCRIPTION]



       7   6   5   4   3   2   1   0--Data Terminal ready (DTR)
           |   |   |   |   |   |
           |   |   |   |   |   |
           |   |   |   |   |   Ready to send (RTS)
           |   |   |   |   |
           |   |   |   |   |
           |   |   |   |   Unused
           |   |   |   |
           |   |   |   |
           |   |   |   Unused


  cDTR               = $01;         { Data terminal ready          }
  cRTS               = $02;         { Ready to send                }
  cOut1              = $04;         { Out 1 - not used in PCs      }

  cOut2              = $08;         { Out 2 -                      }
  cMasterEnableInts  = $08;         {   master enables interrupts  }

  cLoop              = $10;         { Loop enable (for testing)    }


[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetModemControl(       Chan        : TSerHandle    ) : WORD;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetModemControl;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      If SDP.Error=0 Then
        VSerGetModemControl := SDP.Val
      Else
        VSerGetModemControl := $FFFF;

    END  { With Chan^ }

  Else
    VSerGetModemControl := $FFFF;

END;


{}



(*-

[FUNCTION]


Function  VSerGetModemStatus(        Chan        : TSerHandle    ) : WORD;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

Modem status value for the specified serial channel.

[DESCRIPTION]

       7   6   5   4   3   2   1   0--CTS has changed flag
       |   |   |   |   |   |   |
       |   |   |   |   |   |   |
       |   |   |   |   |   |   DSR has changed flag
       |   |   |   |   |   |
       |   |   |   |   |   |
       |   |   |   |   |   RING has changed flag
       |   |   |   |   |
       |   |   |   |   |
       |   |   |   |   DCD (carrier) has changed flag
       |   |   |   |
       |   |   |   |
       |   |   |   CTS (Clear to send)
       |   |   |
       |   |   |
       |   |   DSR (Data set ready)
       |   |
       |   |
       |   RING (phone is ringing)
       |
       |
       DCD (Data Carrier Detect)

  cdCTS      = $01;                 { delta-clear to send          }
  cdDSR      = $02;                 { delta-Data Set Ready         }
  cdRI       = $04;                 { delta-Ring                   }
  cdDCD      = $08;                 { delta-Data Carrier Detect    }
  cCTS       = $10;                 { Clear to send                }
  cDSR       = $20;                 { Data Set Ready               }
  cRI        = $40;                 { Ring Indicator               }
  cDCD       = $80;                 { Data Carrier Detect          }



[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetModemStatus(        Chan        : TSerHandle    ) : WORD;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetModemStatus;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerGetModemStatus := SDP.Status And $00FF;

    END  { With Chan^ }

  Else
    VSerGetModemStatus := $FFFF;

END;

{}

(*-

[FUNCTION]

Function  VSerGetStatus(            Chan        : TSerHandle    ) : LONGINT;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

The line and modem status values of the specified serial channel.

[DESCRIPTION]

This function obtains and returns both the line and modem status
values of the specified serial channel.

The modem status is in the lowest byte (0), and the modem status
is in the next highest byte (1).  The upper two-bytes are currently
unused.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetStatus(            Chan        : TSerHandle    ) : LONGINT;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetBothStatus;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerGetStatus := SDP.Status;

    END  { With Chan^ }

  Else
    VSerGetStatus := -1;

END;  { VSerGetStatus }

(*-

[FUNCTION]

Function VSerGetStatusBit(          Chan        : TSerHandle;
                                    Bit         : BYTE          ) : BOOLEAN;

[PARAMETERS]

Chan        Serial channel handle
Bit         Bit # to test

[RETURNS]

Whether the specified "bit" in the combined line/modem status value
is set.

[DESCRIPTION]

This function gets the current combined status-word and tests
the specified bit in that word to see if it is set.  If the bit
is set, this function returns TRUE.  Otherwise it returns FALSE.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VSerGetStatusBit(          Chan        : TSerHandle;
                                    Bit         : BYTE          ) : BOOLEAN;

BEGIN

  VSerGetStatusBit := ( VSerGetStatus( Chan ) AND CBitMapL[Bit] ) <> 0;

END;  { VSerGetStatusBit }

{}

(*-

[FUNCTION]

Function  VSerCarrier(              Chan        : TSerHandle    ) : BOOLEAN;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

TRUE if a carrier is detected on the specified serial channel,
FALSE if a carrier is NOT detected.

[DESCRIPTION]

This function checks to see if a data carrier is present on the
specified serial channel.

[SEE-ALSO]

[EXAMPLE]

  IF VSerCarrier( MyChan ) Then
    WriteLN( 'Carrier is present.')
  Else
    WRiteLn( 'Carrier is NOT present.');

-*)

Function  VSerCarrier(              Chan        : TSerHandle    ) : BOOLEAN;

BEGIN

  VSerCarrier := VSerGetStatusBit( Chan, sbf_MSRcd );

END;  { VSerCarrier }

{}

(*-

[FUNCTION]

Function  VSerRing(                 Chan        : TSerHandle    ) : BOOLEAN;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

TRUE if the a RING is detected on the specified serial channel,
FALSE if a RING is not detected.

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerRing(                 Chan        : TSerHandle    ) : BOOLEAN;

BEGIN

  VSerRing := VSerGetStatusBit( Chan, sbf_MSRri );

END;  { VSerRing }

{}

(*-

[FUNCTION]

Function  VSerInAvail(              Chan        : TSerHandle    ) : BOOLEAN;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

TRUE if characaters are available to be read from the specified channel,
FALSE if no characters are currently available.

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerInAvail(              Chan        : TSerHandle    ) : BOOLEAN;

BEGIN

  VSerInAvail := VSerGetStatusBit( Chan, sbf_LSRRcvReady );

END;  { VSerInAvail }

{}

(*-

[FUNCTION]

Function  VSerInFull(               Chan        : TSerHandle    ) : BOOLEAN;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

TRUE if the input/read buffer for the specified channel is FULL,
FALSE if it is not FULL (IE: their is room for more characters)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerInFull(               Chan        : TSerHandle    ) : BOOLEAN;

BEGIN

  VSerInFull := VSerGetStatusBit( Chan, sbf_LSROverrun );

END;  { VSerInFull }

{}

(*-

[FUNCTION]

Function  VSerOutReady(             Chan        : TSerHandle    ) : BOOLEAN;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

TRUE if serial port/driver/buffer is ready to accept more characters
to write/send out,

FALSE if they are not.

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerOutReady(             Chan        : TSerHandle    ) : BOOLEAN;

BEGIN

  VSerOutReady := VSerGetStatusBit( Chan, sbf_LSRXhReady );

END;  { VSerOutReady }

{}

(*-

[FUNCTION]

Function  VSerOutEmpty(             Chan        : TSerHandle    ) : BOOLEAN;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

TRUE if the output buffer for the specified serial channel is empty,
FALSE if it is not (1 or more characters are in the output buffer)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerOutEmpty(             Chan        : TSerHandle    ) : BOOLEAN;

BEGIN

  VSerOutEmpty := VSerGetStatusBit( Chan, sbf_LSRXsReady );

END;  { VSerOutEmpty }


{}
{                                                                           }
{         L I N E  /  M O D E M    C H A N G E     F U N C T I O N S        }
{                                                                           }
{}


(*-

[FUNCTION]

Function  VSerTurnBreakOn(          Chan        : TSerHandle    ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function turns BREAK on on the port connected to the specified
serial channel.

[SEE-ALSO]

[EXAMPLE]

  Err := VSerTurnBreakOn( MyChan );

-*)

Function  VSerTurnBreakOn(          Chan        : TSerHandle    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFBreakOnOff;
      SDP.OnOff     := TRUE;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerTurnBreakOn := SDP.Error;

    END  { With Chan^ }

  Else
    VSerTurnBreakOn := $FBAD;

END;  { VSerTurnBreakOn }

{}

(*-

[FUNCTION]

Function  VSerTurnBreakOff(         Chan        : TSerHandle    ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function turns BREAK OFF on the port connected to the specified
serial channel.

[SEE-ALSO]

[EXAMPLE]

  Err := VSerTurnBreakOff( MyChan );

-*)

Function  VSerTurnBreakOff(         Chan        : TSerHandle    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFBreakOnOff;
      SDP.OnOff     := FALSE;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerTurnBreakOff := SDP.Error;

    END  { With Chan^ }

  Else
    VSerTurnBreakOff := $FBAD;

END;  { VSerTurnBreakOff }

{}

(*-

[FUNCTION]

Function  VSerBreak(                Chan        : TSerHandle;
                                    BreakLen    : LONGINT       ) : TError;

[PARAMETERS]

Chan        Serial channel handle
BreakLen    Break length, in 100s of a second.

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function turns BREAK on on the port connected to the specified
serial channel, leaves it on for the specified "breaklen", and then
turns BREAK off.

[SEE-ALSO]

[EXAMPLE]

  { turn break on for 1 second (100 100s) }

  Err := VSerBreak( MyChan, 100 );

-*)

Function  VSerBreak(                Chan        : TSerHandle;
                                    BreakLen    : LONGINT       ) : TError;

Var

  Err : TError;

BEGIN

  Err := VSerTurnBreakOn( Chan );

  { put pause code in here ^$^ }

  Err := VSerTurnBreakOff( Chan );

END;  { VSerBreak }

{}

(*-

[FUNCTION]

Function  VSerTurnDTROn(            Chan        : TSerHandle    ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function turns DTR On on the port connected to the specified
serial channel.

[SEE-ALSO]

[EXAMPLE]

  Err := VSerTurnDTROn( MyChan );

-*)

Function  VSerTurnDTROn(            Chan        : TSerHandle    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFDTROnOff;
      SDP.OnOff     := TRUE;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerTurnDTROn := SDP.Error;

    END  { With Chan^ }

  Else
    VSerTurnDTROn := $FBAD;

END;  { VSerTurnDTROn }

{}

(*-

[FUNCTION]

Function  VSerTurnDTROff(           Chan        : TSerHandle    ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function turns DTR OFF on the port connected to the specified
serial channel.

[SEE-ALSO]

[EXAMPLE]

  Err := VSerTurnDTROff( MyChan );

-*)

Function  VSerTurnDTROff(           Chan        : TSerHandle    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFDTROnOff;
      SDP.OnOff     := FALSE;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerTurnDTROff := SDP.Error;

    END  { With Chan^ }

  Else
    VSerTurnDTROff := $FBAD;

END;  { VSerTurnDTROff }

{}

(*-

[FUNCTION]

Function  VSerTurnRTSON(            Chan        : TSerHandle    ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function turns RTS ON on the port connected to the specified
serial channel.

[SEE-ALSO]

[EXAMPLE]

  Err := VSerTurnRTSOn( MyChan );

-*)

Function  VSerTurnRTSON(            Chan        : TSerHandle    ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFRTSOnOff;
      SDP.OnOff     := TRUE;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerTurnRTSOn := SDP.Error;

    END  { With Chan^ }

  Else
    VSerTurnRTSOn := $FBAD;

END;

{}

(*-

[FUNCTION]

Function  VSerTurnRTSOff(           Chan        : TSerHandle    ) : TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function turns RTS OFF on the port connected to the specified
serial channel.

[SEE-ALSO]

[EXAMPLE]

  Err := VSerTurnRTSOff( MyChan );

-*)

Function  VSerTurnRTSOff(           Chan        : TSerHandle    ) : TError;


BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFRTSOnOff;
      SDP.OnOff     := FALSE;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerTurnRTSOff := SDP.Error;

    END  { With Chan^ }

  Else
    VSerTurnRTSOff := $FBAD;

END;


{}
{                                                                           }
{          B U F F E R    C O N T R O L    F U N C T I O N S                }
{                                                                           }
{}

(*-

[FUNCTION]

Function  VSerFlushOutBuff(       Chan        : TSerHandle    ): TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function flushes the output buffer associated with the
specified serial channel.  All buffered output characters will be sent
out over the port.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerFlushOutBuff(       Chan        : TSerHandle    ): TError;

BEGIN


  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFFlushOutBuff;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerFlushOutBuff :=  SDP.Error;

    END  { With Chan^ }

  Else
    VSerFlushOutBuff := $FBAD;

END;  { VSerFlushOutBuff }

{}

(*-

[FUNCTION]

Function  VSerPurgeOutBuff(       Chan        : TSerHandle    ): TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function purges the output buffer associated with the
specified serial channel.  All buffered output characters will be
disposed of, without sending it out the serial port.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerPurgeOutBuff(       Chan        : TSerHandle    ): TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFPurgeOutBuff;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerPurgeOutBuff := SDP.Error;

    END  { With Chan^ }

  Else
    VSerPurgeOutBuff := $FBAD;

END;  { VSerPurgeOutBuff }

{}

(*-

[FUNCTION]

Function  VSerPurgeInBuff(        Chan        : TSerHandle    ): TError;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function puges the input buffer associated with the specified
serial channel.  All buffered characers (not yet read) will be
disposed of.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerPurgeInBuff(        Chan        : TSerHandle    ): TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFPurgeInBuff;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerPurgeInBuff := SDP.Error;

    END  { With Chan^ }

  Else
    VSerPurgeInBuff := $FBAD;

END;  { VSerPurgeInBuff }

{}

(*-

[FUNCTION]

Function  VSerGetInBuffInfo(        Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;

[PARAMETERS]

Chan        Serial channel handle
BuffInfo    pointer to a variable of the type TSerBuffInfo

[RETURNS]

0 if successfull, otherwise a serial error value.

BuffInfo    filled in.

[DESCRIPTION]

This function obtains information about the input (read) buffer
associated with the specified serial channel.

  TSerBuffInfo = RECORD

    Size       : LONGINT;         { size of the buffer, in bytes         }
    Used       : LONGINT;         { # of bytes which are used            }
    Free       : LONGINT;         { # of bytes which are free            }

    Changeable : BOOLEAN;         { TRUE if the buffer size is changeable}

  END;

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetInBuffInfo(        Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetInBuffInfo;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      BuffInfo^ := SDP.BuffInfo;

      VSerGetInBuffInfo := SDP.Error;

    END  { With Chan^ }

  Else
    VSerGetInBuffInfo := $FBAD;

END;

{}

(*-

[FUNCTION]

Function  VSerSetInBuffInfo(        Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;

[PARAMETERS]

Chan        Serial channel handle
BuffInfo    pointer to a variable of the type TSerBuffInfo

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function sets the ...

  TSerBuffInfo = RECORD

    Size       : LONGINT;         { size of the buffer, in bytes         }
    Used       : LONGINT;         { # of bytes which are used            }
    Free       : LONGINT;         { # of bytes which are free            }

    Changeable : BOOLEAN;         { TRUE if the buffer size is changeable}

  END;

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerSetInBuffInfo(        Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFSetInBuffInfo;
      SDP.BuffInfo  := BuffInfo^;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerSetInBuffInfo := SDP.Error;

    END  { With Chan^ }

  Else
    VSerSetInBuffInfo := $FBAD;


END;

{}

(*-

[FUNCTION]

Function  VSerGetOutBuffInfo(       Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;

[PARAMETERS]

Chan        Serial channel handle
BuffInfo    pointer to a variable of the type TSerBuffInfo

[RETURNS]

0 if successfull, otherwise a serial error value.

BuffInfo    filled in.

[DESCRIPTION]

This function obtains information about the output (write) buffer
associated with the specified serial channel.

  TSerBuffInfo = RECORD

    Size       : LONGINT;         { size of the buffer, in bytes         }
    Used       : LONGINT;         { # of bytes which are used            }
    Free       : LONGINT;         { # of bytes which are free            }

    Changeable : BOOLEAN;         { TRUE if the buffer size is changeable}

  END;

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetOutBuffInfo(       Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;


BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetOutBuffInfo;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      BuffInfo^ := SDP.BuffInfo;

      VSerGetOutBuffInfo := SDP.Error;

    END  { With Chan^ }

  Else
    VSerGetOutBuffInfo := $FBAD;

END;


{}

(*-

[FUNCTION]

Function  VSerSetOutBuffInfo(       Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;

[PARAMETERS]

Chan        Serial channel handle
BuffInfo    pointer to a variable of the type TSerBuffInfo

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function sets the ...

  TSerBuffInfo = RECORD

    Size       : LONGINT;         { size of the buffer, in bytes         }
    Used       : LONGINT;         { # of bytes which are used            }
    Free       : LONGINT;         { # of bytes which are free            }

    Changeable : BOOLEAN;         { TRUE if the buffer size is changeable}

  END;

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerSetOutBuffInfo(       Chan        : TSerHandle;
                                    BuffInfo    : PSerBuffInfo  ) : TError;


BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFSetOutBuffInfo;
      SDP.BuffInfo  := BuffInfo^;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerSetOutBuffInfo := SDP.Error;

    END  { With Chan^ }

  Else
    VSerSetOutBuffInfo := $FBAD;

END;

{}

(*-

[FUNCTION]

Function  VSerGetInAvail(           Chan        : TSerHandle    ) : LONGINT;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

-1 if an error occurred,
otherwise returns a count of bytes available for input/read.

[DESCRIPTION]

This function returns a count of the # of bytes that are currently
in and can be read from the input buffer.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetInAvail(           Chan        : TSerHandle    ) : LONGINT;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetInBuffInfo;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      If SDP.Error=0 Then
        VSerGetInAvail := SDP.BuffInfo.Used
      Else
        VSerGetInAvail := -1;

    END  { With Chan^ }

  Else
    VSerGetInAvail := $FBAD;

END;


{}

(*-

[FUNCTION]

Function  VSerGetOutFree(           Chan        : TSerHandle    ) : LONGINT;

[PARAMETERS]

Chan        Serial channel handle

[RETURNS]

-1 if an error occurred,
otherwise returns a count of bytes available for buffered output/writes.

[DESCRIPTION]

This function returns a count of the # of bytes that are currently
available to store buffered output/write information.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetOutFree(           Chan        : TSerHandle    ) : LONGINT;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFGetOutBuffInfo;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      If SDP.Error=0 Then
        VSerGetOutFree := SDP.BuffInfo.Free
      Else
        VSerGetOutFree := -1;

    END  { With Chan^ }

  Else
    VSerGetOutFree := $FBAD;


END;

{}
(*
Procedure VSerEventProcNew(         Chan        : TSerHandle;
                                    Proc        : TSerEventProc;
                                    EventMask   : WORD;
                                    ProcInfo    : Pointer;
                                Var ProcHandle  : TSerHandle    ) : TError;

Procedure VSerEventProcOff(         ProcHandle  : TSerHandle    );

Procedure VSerEventProcOn(          ProcHandle  : TSerHandle    );

Procedure VSerEventProcDispose(     ProcHandle  : TSerHandle    );
*)

{}



(*-

[FUNCTION]

Function  VSerWriteChEx(            Chan        : TSerHandle;
                                    Flags       : WORD;
                                    OutCh       : CHAR;
                                    Timeout100s : LONGINT       ) : TError;

[PARAMETERS]

Chan        serial channel handle
flags       write flags
outch       character to write
timeout100s timeout value

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function writes the specified character "outch" to the specified
serial channel "chan".

Flags

  csfDefault   = $00;          { Default settings (nowait/non-immediate) }
  csfNowait    = $00;          { No wait (return if char not avail/sent) }
  csfWait      = $01;          { Wait (until char is avail / sent      ) }
  csfImmediate = $02;          { Bypass read/write buffers;              }

TimeOut100s is a timeout value.  If no timeout is desired, this value
should be -1.  Otherwise, this function will attempt to send the
character until the timeout period elapses.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerWriteChEx(            Chan        : TSerHandle;
                                    Flags       : WORD;
                                    OutCh       : CHAR;
                                    Timeout100s : LONGINT       ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFWriteCh;
      SDP.Ch        := OutCh;
      SDP.Flags     := Flags;
      SDP.Timeout   := Timeout100s;
      SDP.Status    := 0;

      SerDriverProc( @SDP );

      VSerWriteChEx := SDP.Error;

    END  { With Chan^ }

  Else
    VSerWriteChEx := $FBAD;



END;


{}



(*-

[FUNCTION]

Function  VSerWriteBlockEx(         Chan        : TSerHandle;
                                    Flags       : WORD;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT      ) : TError;

[PARAMETERS]

Chan        serial channel handle
flags       write flags
buffsize    size of the block/buffer to write
buffptr     pointer to the block/buffer to write
timeout100s timeout value
xfercount   (RETURNED) # of characters sent

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function writes the specified block pointer to by "buffptr" to
the specified serial channel.

Flags

  csfDefault   = $00;          { Default settings (nowait/non-immediate) }
  csfNowait    = $00;          { No wait (return if char not avail/sent) }
  csfWait      = $01;          { Wait (until char is avail / sent      ) }
  csfImmediate = $02;          { Bypass read/write buffers;              }

TimeOut100s is a timeout value.  If no timeout is desired, this value
should be -1.  Otherwise, this function will attempt to send the
block until the timeout period elapses.

XFERCOUNT is filled in by this function.  It is a count of the # of
bytes from the block that were successfully sent.

[SEE-ALSO]

[EXAMPLE]

-*)


Function  VSerWriteBlockEx(         Chan        : TSerHandle;
                                    Flags       : WORD;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT      ) : TError;

BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func   := SDFWriteBlock;
      SDP.Count  := BuffSize;
      SDP.Buf    := BuffPtr;
      SDP.Flags  := Flags;
      SDP.Timeout:= TimeOut100s;
      SDP.Status := 0;

      SerDriverProc( @SDP );

      XFerCount := SDP.Result;

      VSerWriteBlockEx := SDP.Error;

    END  { With Chan^ }

  Else
    VSerWriteBlockEx := $FBAD;

END;



{}


(*-

[FUNCTION]

Function  VSerWriteStEx(            Chan        : TSerHandle;
                                    Flags       : WORD;
                                    ST          : STRING;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT      ) : TError;

[PARAMETERS]

Chan        serial channel handle
flags       write flags
st          the string to write
timeout100s timeout value
xfercount   (RETURNED) # of characters sent

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function writes the specified string "st" to
the specified serial channel.

Flags

  csfDefault   = $00;          { Default settings (nowait/non-immediate) }
  csfNowait    = $00;          { No wait (return if char not avail/sent) }
  csfWait      = $01;          { Wait (until char is avail / sent      ) }
  csfImmediate = $02;          { Bypass read/write buffers;              }

TimeOut100s is a timeout value.  If no timeout is desired, this value
should be -1.  Otherwise, this function will attempt to send the
string until the timeout period elapses.

XFERCOUNT is filled in by this function.  It is a count of the # of
bytes from the string that were successfully sent.

[SEE-ALSO]

[EXAMPLE]

-*)


Function  VSerWriteStEx(            Chan        : TSerHandle;
                                    Flags       : WORD;
                                    ST          : STRING;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT      ) : TError;

BEGIN


  VSerWriteStEx := VSerWriteBlockEx( Chan,
                                     Flags,
                                     Byte( ST[0] ),
                                     @ST[1],
                                     TimeOUt100s,
                                     XFerCount           );


END;



{}

(*-

[FUNCTION]

Function  VSerWritePchEx(           Chan        : TSerHandle;
                                    Flags       : WORD;
                                    Pch         : PChar;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT     ) : TError;

[PARAMETERS]

Chan        serial channel handle
flags       write flags
Pch         pointer to a null-terminated string to write
timeout100s timeout value
xfercount   (RETURNED) # of characters sent

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function writes the specified null-terminated string "pch" to
the specified serial channel.

Flags

  csfDefault   = $00;          { Default settings (nowait/non-immediate) }
  csfNowait    = $00;          { No wait (return if char not avail/sent) }
  csfWait      = $01;          { Wait (until char is avail / sent      ) }
  csfImmediate = $02;          { Bypass read/write buffers;              }

TimeOut100s is a timeout value.  If no timeout is desired, this value
should be -1.  Otherwise, this function will attempt to send the
string until the timeout period elapses.

XFERCOUNT is filled in by this function.  It is a count of the # of
bytes from the string that were successfully sent.

[SEE-ALSO]

[EXAMPLE]

-*)

{$IFDEF VER70}

Function  VSerWritePchEx(           Chan        : TSerHandle;
                                    Flags       : WORD;
                                    Pch         : PChar;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT     ) : TError;

BEGIN

  VSerWritePchEx := VSerWriteBlockEx( Chan,
                                      Flags,
                                      StrLen( PCh ),
                                      PCh,
                                      TimeOut100s,
                                      XFerCount        );

END;

{$ENDIF}   { !! version 6.0 bug }

{}

{---}


(*-

[FUNCTION]

Function  VSerSetWriteTimeout(      Chan        : TSerHandle;
                                    TimeOut100s : LONGINT      ) : TError;


[PARAMETERS]

Chan        serial channel handle
timeout100s default timeout value to use

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function sets the default timeout value that is used for the
"non-ex" write functions (IE:  VSerWritech, VSerWriteBlock)

[SEE-ALSO]

[EXAMPLE]

  { set the write timeout to 2 seconds (200 100s) }

  Err := VSerSetWriteTimeout( MyChan, 200 );

  { the call below will now timeout after 2 seconds }

  Err := VSerWriteCh( MyChan, '!' );

  { set the write timeout to 30 seconds (3000 100s) }

  Err := VSerSetWriteTimeout( MyChan, 3000 );

  { the call below will now timeout after 30 seconds }

  Err := VSerWriteCh( MyChan, '!' );


  { Set the write timeout to NONE }

  Err := VSerSetWriteTimeout( MyChan, -1 );

  { the call below will not timeout }

  Err := VSerWriteCh( MyChan, '!' );


-*)


Function  VSerSetWriteTimeout(      Chan        : TSerHandle;
                                    TimeOut100s : LONGINT      ) : TError;

BEGIN

  Chan^.WriteTimeout := Timeout100s;

END;


{}


(*-

[FUNCTION]

Function  VSerSetWriteFlags(        Chan        : TSerHandle;
                                    Flags       : WORD         ) : TError;


[PARAMETERS]

Chan        serial channel handle
flags       default write flags to use

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function sets the default "flags" value that is used for the
"non-ex" write functions (IE:  VSerWritech, VSerWriteBlock)

Flags

  csfDefault   = $00;          { Default settings (nowait/non-immediate) }
  csfNowait    = $00;          { No wait (return if char not avail/sent) }
  csfWait      = $01;          { Wait (until char is avail / sent      ) }
  csfImmediate = $02;          { Bypass read/write buffers;              }


[SEE-ALSO]

[EXAMPLE]

  { set the write flags to WAIT }

  Err := VSerSetWriteFlags( Mychan, csfWAIT );

  { the call below will now wait/block until the char is sent }

  Err := VSerWriteCh( MyChan, '!' );

  { set the write flags to NOWAIT }

  Err := VSerSetWriteFlags( Mychan, csfNOWAIT );

  { the call below will now return immediately if the char can not }
  { be sent                                                        }

  Err := VSerWriteCh( MyChan, '!' );




-*)


Function  VSerSetWriteFlags(        Chan        : TSerHandle;
                                    Flags       : WORD         ) : TError;

BEGIN

  Chan^.WriteFlags := Chan^.WriteFlags;

END;


{}



(*-

[FUNCTION]

Function  VSerGetWriteTimeout(      Chan        : TSerHandle   ) : LONGINT;


[PARAMETERS]

Chan        serial channel handle

[RETURNS]

current default timeout value,
-1 if an error occurred.

[DESCRIPTION]

This function obtains and returns the current default write timeout
value, which can be set via a call to VSerSetWriteTimeout.

The timeout value is in 100s of a second.

[SEE-ALSO]

[EXAMPLE]


  WriteLn( 'Current timeout value ........ ',
                        VSerGetWriteTimeout( MyChan ) );

-*)

Function  VSerGetWriteTimeout(      Chan        : TSerHandle   ) : LONGINT;

BEGIN

  VSerGetWriteTimeout := Chan^.WriteTimeout;

END;


{}



(*-

[FUNCTION]

Function  VSerGetWriteFlags(        Chan        : TSerHandle   ) : WORD;


[PARAMETERS]

Chan        serial channel handle

[RETURNS]

current default write flags.

[DESCRIPTION]

This function obtains and returns the current default write flags
value, which can be set via a call to VSerSetWriteFlags.

The timeout value is in 100s of a second.

[SEE-ALSO]

[EXAMPLE]


  If (VSerGetWriteFlags AND csfWAIT)<>0 Then
    WriteLN('Non-EX writes will not wait until completion')
  Else
    WriteLn('Non-EX writes will wait until completion.');

-*)


Function  VSerGetWriteFlags(        Chan        : TSerHandle   ) : WORD;

BEGIN

  VSerGetWriteFlags := Chan^.WriteFlags;

END;



{}

(*-

[FUNCTION]

Function  VSerWriteCh(              Chan        : TSerHandle;
                                    OutCh       : CHAR        ) : TError;


[PARAMETERS]

Chan        serial channel handle
outch       character to write

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function writes the specified character "outch" to the specified
serial channel "chan".

This function will use the default write flags and timeout values.
(As set by VSerSetWriteTimeout/VSerSetWriteFlags)

[SEE-ALSO]

[EXAMPLE]

  { write an exclamation point to the channel }

  Err := VSerWriteCh( MyChan, '!' );

-*)

Function  VSerWriteCh(              Chan        : TSerHandle;
                                    OutCh       : CHAR        ) : TError;

BEGIN

  VSerWriteCh := VSerWriteChEx( Chan,
                                Chan^.Writeflags,
                                OutCh,
                                Chan^.WriteTimeout );

END;



{}


(*-

[FUNCTION]

Function  VSerWriteBlock(           Chan        : TSerHandle;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER     ) : TError;

[PARAMETERS]

Chan        serial channel handle
buffsize    size of the block/buffer to write
buffptr     pointer to the block/buffer to write

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function writes the specified block pointer to by "buffptr" to
the specified serial channel.

This function will use the default write flags and timeout values.
(As set by VSerSetWriteTimeout/VSerSetWriteFlags)

If an error occurs, their is no way to determine how many characters
have been sent.  If you need to know have many characters are
successfully sent, use the VSerWriteBlockEx function.

[SEE-ALSO]

[EXAMPLE]

-*)


Function  VSerWriteBlock(           Chan        : TSerHandle;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER     ) : TError;

Var

  XFerCount : LONGINT;


BEGIN

  VSerWriteBlock := VSerWriteBlockEx( Chan,
                                      Chan^.WriteFlags,
                                      BuffSize,
                                      BuffPtr,
                                      Chan^.WriteTimeout,
                                      XFerCount            );


END;


{}



(*-

[FUNCTION]

Function  VSerWriteSt(              Chan        : TSerHandle;
                                    St          : STRING      ) : TError;

[PARAMETERS]

Chan        serial channel handle
st          the string to write

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function writes the specified string "st" to
the specified serial channel.

This function will use the default write flags and timeout values.
(As set by VSerSetWriteTimeout/VSerSetWriteFlags)

If an error occurs, their is no way to determine how many characters
have been sent.  If you need to know have many characters are
successfully sent, use the VSerWriteStEx function.

[SEE-ALSO]

[EXAMPLE]

  { write a string to the channel }

  Err := VSerWriteSt( MyChan, 'Hello, Serial World!');

-*)


Function  VSerWriteSt(              Chan        : TSerHandle;
                                    St          : STRING      ) : TError;


Var

  XFerCount : LONGINT;

BEGIN

  VSerWriteSt := VSerWriteStEx( Chan,
                                Chan^.WriteFlags,
                                ST,
                                Chan^.WriteTimeout,
                                XFerCount               );

END;


{}

(*-

[FUNCTION]

Function  VSerWritePch(             Chan        : TSerHandle;
                                    Pch         : PChar       ) : TError;


[PARAMETERS]

Chan        serial channel handle
Pch         pointer to a null-terminated string to write

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function writes the specified null-terminated string "pch" to
the specified serial channel.

This function will use the default write flags and timeout values.
(As set by VSerSetWriteTimeout/VSerSetWriteFlags)

If an error occurs, their is no way to determine how many characters
have been sent.  If you need to know have many characters are
successfully sent, use the VSerWritePchEx function.


[SEE-ALSO]

[EXAMPLE]

-*)

{$IFDEF VER70}

Function  VSerWritePch(             Chan        : TSerHandle;
                                    Pch         : PChar       ) : TError;
Var

  XFerCount : LONGINT;

BEGIN

  VSerWritePch := VSerWritePchEx( Chan,
                                  Chan^.WriteFlags,
                                  PCh,
                                  Chan^.WriteTimeout,
                                  XFerCount              );

END;

{$ENDIF}

{}

{---}

(*-

[FUNCTION]

Function  VSerReadChEx(             Chan        : TSerHandle;
                                    Flags       : WORD;
                                Var InCh        : CHAR;
                                    Timeout100s : LONGINT       ) : TError;

[PARAMETERS]

Chan        serial channel handle
flags       write flags
inch        varaible to receive the character
timeout100s timeout value

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function reads a characters from the specified serial channel "chan".

Flags

  csfDefault   = $00;          { Default settings (nowait/non-immediate) }
  csfNowait    = $00;          { No wait (return if char not avail/sent) }
  csfWait      = $01;          { Wait (until char is avail / sent      ) }
  csfImmediate = $02;          { Bypass read/write buffers;              }

TimeOut100s is a timeout value.  If no timeout is desired, this value
should be -1.  Otherwise, this function will attempt to read a chracter
from the specified channel until the timeout period elapses.

[SEE-ALSO]

[EXAMPLE]

Var

  NewCh : CHAR;

BEGIN

  { read a char; wait until one is ready or 2 seconds elapse }

  Err := VSerReadChEx( Mychan,
                       csfWait,
                       NewCh,
                       200         );

  { read another char; one is ready or 2 seconds elapse }

  Err := VSerReadChEx( Mychan,
                       csfWait,
                       NewCh,
                       200         );

  { read a char; wait until one is ready  }

  Err := VSerReadChEx( Mychan,
                       csfWait,
                       NewCh,
                       -1        );



  { read a char; return immediately if none are available }

  Err := VSerReadChEx( Mychan,
                       csfNoWait,
                       NewCh,
                       -1        );


END;

-*)


Function  VSerReadChEx(             Chan        : TSerHandle;
                                    Flags       : WORD;
                                Var InCh        : CHAR;
                                    Timeout100s : LONGINT       ) : TError;


BEGIN

  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func      := SDFReadCh;
      SDP.Status    := 0;
      SDP.Flags     := Flags;
      SDP.Timeout   := Timeout100s;

      SerDriverProc( @SDP );

      InCH          := SDP.Ch;

      VSerReadChEx  := SDP.Error;

    END

  Else
    VSerReadChEx := $FBAD;



END;


{}

(*-

[FUNCTION]


Function  VSerReadBlockEx(          Chan        : TSerHandle;
                                    Flags       : WORD;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT      ) : TError;

[PARAMETERS]

Chan        serial channel handle
flags       write flags
buffsize    size of the block/buffer to read into
buffptr     pointer to the block/buffer to read into
timeout100s timeout value
xfercount   (RETURNED) # of characters read

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function reads into the specified buffer pointed to by "buffptr" from
the specified serial channel.

Flags

  csfDefault   = $00;          { Default settings (nowait/non-immediate) }
  csfNowait    = $00;          { No wait (return if char not avail/sent) }
  csfWait      = $01;          { Wait (until char is avail / sent      ) }
  csfImmediate = $02;          { Bypass read/write buffers;              }

TimeOut100s is a timeout value.  If no timeout is desired, this value
should be -1.  Otherwise, this function will attempt to read into the
buffer until the timeout period elapses or the specified buffer is
filled.

XFERCOUNT is filled in by this function.  It is a count of the # of
bytes that were succesfully read into the buffer.

[SEE-ALSO]

[EXAMPLE]

-*)



Function  VSerReadBlockEx(          Chan        : TSerHandle;
                                    Flags       : WORD;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER;
                                    TimeOut100s : LONGINT;
                                Var XFerCount   : LONGINT      ) : TError;

BEGIN


  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func   := SDFReadBlock;
      SDP.Count  := BuffSize;
      SDP.Buf    := BuffPtr;
      SDP.Flags  := Flags;
      SDP.Timeout:= Timeout100s;
      SDP.Status := 0;

      SerDriverProc( @SDP );

      XFerCount       := SDP.Result;

      VSerReadBlockEx := SDP.Error;

    END  { With Chan^ }

  Else
    VSerReadBlockEx := $FBAD;


END;


{}


(*-

[FUNCTION]

Function  VSerReadStEx(             Chan        : TSerHandle;
                                    Flags       : WORD;
                                    STSize      : WORD;
                                Var ST          : STRING;
                                    TimeOut100s : LONGINT      ) : TError;


[PARAMETERS]

Chan        serial channel handle
flags       write flags
stsize      maximum size of the string to read into
st          string to read into
timeout100s timeout value
xfercount   (RETURNED) # of characters read

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function reads into the specified string for up to "STsize"
characters.

Flags

  csfDefault   = $00;          { Default settings (nowait/non-immediate) }
  csfNowait    = $00;          { No wait (return if char not avail/sent) }
  csfWait      = $01;          { Wait (until char is avail / sent      ) }
  csfImmediate = $02;          { Bypass read/write buffers;              }

TimeOut100s is a timeout value.  If no timeout is desired, this value
should be -1.  Otherwise, this function will attempt to read into the
string until the timeout period elapses or the specified "Stsize" # of
bytes has been read.

XFERCOUNT is filled in by this function.  It is a count of the # of
bytes that were succesfully read into the string.

[SEE-ALSO]

[EXAMPLE]

-*)


Function  VSerReadStEx(             Chan        : TSerHandle;
                                    Flags       : WORD;
                                    STSize      : WORD;
                                Var ST          : STRING;
                                    TimeOut100s : LONGINT      ) : TError;

BEGIN


  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func   := SDFReadBlock;
      SDP.Count  := STSize;
      SDP.Buf    := @ST[1];
      SDP.Flags  := Flags;
      SDP.Timeout:= Timeout100s;
      SDP.Status := 0;

      SerDriverProc( @SDP );

      Byte( ST[0] ) := SDP.Result;

      VSerReadStEx := SDP.Error;

    END  { With Chan^ }

  Else
    VSerReadStEx := $FBAD;

END;



{}



(*-

[FUNCTION]

Function  VSerReadPchEx(            Chan        : TSerHandle;
                                    Flags       : WORD;
                                    PchSize     : LONGINT;
                                    Pch         : PChar;
                                    TimeOut100s : LONGINT      ) : TError;


[PARAMETERS]

Chan        serial channel handle
flags       write flags
pchsize     maximum size of the string to read into
pch         string to read into
timeout100s timeout value
xfercount   (RETURNED) # of characters read

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function reads into the specified null-terimated string for up to
"pchsize" characters.

Flags

  csfDefault   = $00;          { Default settings (nowait/non-immediate) }
  csfNowait    = $00;          { No wait (return if char not avail/sent) }
  csfWait      = $01;          { Wait (until char is avail / sent      ) }
  csfImmediate = $02;          { Bypass read/write buffers;              }

TimeOut100s is a timeout value.  If no timeout is desired, this value
should be -1.  Otherwise, this function will attempt to read into the
string until the timeout period elapses or the specified "pchsize" # of
bytes has been read.

XFERCOUNT is filled in by this function.  It is a count of the # of
bytes that were succesfully read into the null-terimated string.

This function will automatically null-terminate the string that has
been read.

[SEE-ALSO]

[EXAMPLE]

-*)


Function  VSerReadPchEx(            Chan        : TSerHandle;
                                    Flags       : WORD;
                                    PchSize     : LONGINT;
                                    Pch         : PChar;
                                    TimeOut100s : LONGINT      ) : TError;

BEGIN


  If Chan^.Sig = $CBAD Then

    With Chan^ Do
    BEGIN

      SDP.Func   := SDFReadBlock;
      SDP.Count  := Pred(PchSize);
      SDP.Buf    := Pch;
      SDP.Flags  := Flags;
      SDP.Timeout:= Timeout100s;
      SDP.Status := 0;

      SerDriverProc( @SDP );

      PByteArray( Pch )^[ Succ(SDP.Result) ] := 0;

      VSerReadPchEx := SDP.Error;

    END  { With Chan^ }

  Else
    VSerReadPchEx := $FBAD;

END;


{}

(*-

[FUNCTION]


Function  VSerSetReadTimeout(       Chan        : TSerHandle;
                                    TimeOut100s : LONGINT      ) : TError;

[PARAMETERS]

Chan        serial channel handle
timeout100s default timeout value to use

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function sets the default timeout value that is used for the
"non-ex" read functions (IE:  VSerReadch, VSerReadBlock)

[SEE-ALSO]

[EXAMPLE]

Var

  CH : CHAR;
  Err: TError;

BEGIN

  { set the read timeout to 2 seconds (200 100s) }

  Err := VSerSetReadTimeout( MyChan, 200 );

  { the call below will now timeout after 2 seconds }

  Err := VSerReadCh( MyChan, Ch );

  { set the read timeout to 30 seconds (3000 100s) }

  Err := VSerSetReadTimeout( MyChan, 3000 );

  { the call below will now timeout after 30 seconds }

  Err := VSerReadCh( MyChan, Ch );

  { Set the read timeout to NONE }

  Err := VSerSetReadTimeout( MyChan, -1 );

  { the call below will not timeout }

  Err := VSerReadCh( MyChan, Ch );


END;


-*)

Function  VSerSetReadTimeout(       Chan        : TSerHandle;
                                    TimeOut100s : LONGINT      ) : TError;

BEGIN

  Chan^.ReadTimeOut := TimeOut100s;

END;


{}



(*-

[FUNCTION]

Function  VSerSetReadFlags(         Chan        : TSerHandle;
                                    Flags       : WORD         ) : TError;


[PARAMETERS]

Chan        serial channel handle
flags       default write flags to use

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function sets the default "flags" value that is used for the
"non-ex" read functions (IE:  VSerReadch, VSerReadBlock)

Flags

  csfDefault   = $00;          { Default settings (nowait/non-immediate) }
  csfNowait    = $00;          { No wait (return if char not avail/sent) }
  csfWait      = $01;          { Wait (until char is avail / sent      ) }
  csfImmediate = $02;          { Bypass read/write buffers;              }


[SEE-ALSO]

[EXAMPLE]

Var

  ch : char;
  Err: TError;

BEGIN

  { set the read flags to WAIT }

  Err := VSerSetReadFlags( Mychan, csfWAIT );

  { the call below will now wait/block until the char is read }

  Err := VSerReadCh( MyChan, ch );

  { set the read flags to NOWAIT }

  Err := VSerSetReadFlags( Mychan, csfNOWAIT );

  { the call below will now return immediately if the char can not }
  { be read                                                        }

  Err := VSerReadCh( MyChan, Ch );


END;


-*)


Function  VSerSetReadFlags(         Chan        : TSerHandle;
                                    Flags       : WORD         ) : TError;

BEGIN

  Chan^.ReadFlags := Flags;

END;


{}


(*-

[FUNCTION]


Function  VSerGetReadTimeout(       Chan        : TSerHandle   ) : LONGINT;


[PARAMETERS]

Chan        serial channel handle

[RETURNS]

current default timeout value,
-1 if an error occurred.

[DESCRIPTION]

This function obtains and returns the current default read timeout
value, which can be set via a call to VSerSetReadTimeout.

The timeout value is in 100s of a second.

[SEE-ALSO]

[EXAMPLE]


  WriteLn( 'Current timeout value ........ ',
                        VSerGetReadTimeout( MyChan ) );

-*)


Function  VSerGetReadTimeout(       Chan        : TSerHandle   ) : LONGINT;

BEGIN

  VSerGetReadTimeout := Chan^.ReadTimeout;

END;


{}


(*-

[FUNCTION]

Function  VSerGetReadFlags(         Chan        : TSerHandle   ) : WORD;


[PARAMETERS]

Chan        serial channel handle

[RETURNS]

current default write flags.

[DESCRIPTION]

This function obtains and returns the current default read flags
value, which can be set via a call to VSerSetReadFlags.

The timeout value is in 100s of a second.

[SEE-ALSO]

[EXAMPLE]


  If (VSerGetReadFlags AND csfWAIT)<>0 Then
    WriteLN('Non-EX read will return if a char is unavailable')
  Else
    WriteLn('Non-EX read will wait until a char is available.');

-*)

Function  VSerGetReadFlags(         Chan        : TSerHandle   ) : WORD;

BEGIN

  VSerGetReadFlags := Chan^.ReadFlags;

END;



{}

(*-

[FUNCTION]

Function  VSerReadCh(               Chan        : TSerHandle;
                                Var InCh        : CHAR        ) : TError;


[PARAMETERS]

Chan        serial channel handle
inch        variable that will receive the character

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function reads a characters into the variable "inch" from the
specified serial channel "chan"

This function will use the default read flags and timeout values.
(As set by VSerSetReadTimeout/VSerSetReadFlags)

[SEE-ALSO]

[EXAMPLE]

  { read a char from the channel }

  Err := VSerReadCh( MyChan, Ch );

  { if err=0, ch is the new char }

-*)



Function  VSerReadCh(               Chan        : TSerHandle;
                                Var InCh        : CHAR        ) : TError;

BEGIN

  VSerReadCh := VSerReadChEx( Chan,
                              Chan^.ReadFlags,
                              InCh,
                              Chan^.ReadTimeout );

END;





{}

(*-

[FUNCTION]

Function  VSerReadBlock(            Chan        : TSerHandle;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER     ) : TError;

[PARAMETERS]

Chan        serial channel handle
buffsize    size of the block/buffer to read into
buffptr     pointer to the block/buffer to read into

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function reads into the specified buffer pointed to by "buffptr" from
the specified serial channel.

This function will use the default read flags and timeout values.
(As set by VSerSetReadTimeout/VSerSetReadFlags)

If an error occurs, their is no way to determine how many characters
have been read.  If you need to know have many characters are
successfully read, use the VSerReadBlockEx function.

[SEE-ALSO]

[EXAMPLE]

-*)


Function  VSerReadBlock(            Chan        : TSerHandle;
                                    BuffSize    : LONGINT;
                                    BuffPtr     : POINTER     ) : TError;


Var

  XFerCount : LONGINT;

BEGIN

  VSerReadBlock := VSerReadBlockEx( Chan,
                                    Chan^.ReadFlags,
                                    BuffSize,
                                    BuffPtr,
                                    Chan^.ReadTimeOut,
                                    XFercount           );

END;



{}


(*-

[FUNCTION]

Function  VSerReadSt(               Chan        : TSerHandle;
                                    STSize      : WORD;
                                Var St          : STRING      ) : TError;

[PARAMETERS]

Chan        serial channel handle
stsize      maximum # of chars to read into the string
st          the string to read into

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function reads into the specified string for up to "STsize"
characters.

This function will use the default read flags and timeout values.
(As set by VSerSetReadTimeout/VSerSetReadFlags)

[SEE-ALSO]

[EXAMPLE]

-*)



Function  VSerReadSt(               Chan        : TSerHandle;
                                    STSize      : WORD;
                                Var St          : STRING      ) : TError;

BEGIN

  VSerReadSt := VSerReadStEx( Chan,
                              Chan^.ReadFlags,
                              STSize,
                              ST,
                              Chan^.ReadTimeout      );

END;


{}

(*-

[FUNCTION]

Function  VSerReadPCh(              Chan        : TSerHandle;
                                    PchSize     : LONGINT;
                                    Pch         : PChar       ) : TError;


[PARAMETERS]

Chan        serial channel handle
Pchsize     maximum # of chars to read into the string
Pch         pointer to a null-terminated string to read into

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function reads into the specified null-terimated string for up to
"pchsize" characters.

This function will use the default read flags and timeout values.
(As set by VSerSetReadTimeout/VSerSetReadFlags)

If an error occurs, their is no way to determine how many characters
have been read.  If you need to know have many characters are
successfully read, use the VSerReadPchEx function.

[SEE-ALSO]

[EXAMPLE]

-*)



Function  VSerReadPCh(              Chan        : TSerHandle;
                                    PchSize     : LONGINT;
                                    Pch         : PChar       ) : TError;

BEGIN

  VSerReadPCh := VSerReadPchEx( Chan,
                                Chan^.ReadFlags,
                                PChSize,
                                PCH,
                                Chan^.ReadTimeout   );


END;


{}

(*-

[FUNCTION]

Procedure VSerSetErrorCh(           Chan        : TSerHandle;
                                    ErrorCh     : CHAR        );


[PARAMETERS]

Chan        serial channel handle
errorch     character to return on errors

[RETURNS]

nothing

[DESCRIPTION]

This function sets the error character.  The error character willb
be returned by VSerGetCh when an error occurs.

[SEE-ALSO]

[EXAMPLE]

-*)


Procedure VSerSetErrorCh(           Chan        : TSerHandle;
                                    ErrorCh     : CHAR        );

BEGIN

  Chan^.ErrorCh := ErrorCh;

END;



{}

(*-

[FUNCTION]

Function  VSerGetCh(                Chan        : TSerHandle  ) : CHAR;

[PARAMETERS]

Chan        serial channel handle

[RETURNS]

The newly read character.

[DESCRIPTION]

This function reads a character from the specified serial channel
and returns it.  If an error occurs, this function will return the
character set by VSerSetErrorCh.

[SEE-ALSO]

[EXAMPLE]



-*)


Function  VSerGetCh(                Chan        : TSerHandle  ) : CHAR;

Var

  Err : TError;
  CH  : CHAR;

BEGIN

  Err := VSerReadCh( Chan, ch );

  If Err<>0 Then
    VSerGetCh := Chan^.ErrorCh
  Else
    VSerGetCh := Ch;

END;


{}

(*-

[FUNCTION]

Function  VSerGetStEx(              Chan        : TSerHandle;
                                    MaxBytes    : BYTE        ) : STRING;

[PARAMETERS]

Chan        serial channel handle
maxbytes    maximums # of bytes to read

[RETURNS]

The newly read string.

[DESCRIPTION]

This function reads a string from the specified serial channel
and returns it.  If an error occurs, this function will return the
an empty string.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VSerGetStEx(              Chan        : TSerHandle;
                                    MaxBytes    : BYTE        ) : STRING;

Var

  Err : TError;
  S   : STRING;

BEGIN

  Err := VSerReadSt( Chan,
                     MaxBytes,
                     S        );


  IF Err<>0 Then
    VSerGetStEx := ''
  Else
    VSerGetStEx := S;

END;



(*-

[FUNCTION]

Function  VSerGetSt(                Chan        : TSerHandle  ) : STRING;

[PARAMETERS]

Chan        serial channel handle

[RETURNS]

The newly read string.

[DESCRIPTION]

This function reads a string from the specified serial channel
and returns it.  If an error occurs, this function will return the
an empty string.

[SEE-ALSO]

[EXAMPLE]

-*)


Function  VSerGetSt(                Chan        : TSerHandle  ) : STRING;

Var

  Err : TError;
  S   : STRING;

BEGIN

  Err := VSerReadSt( Chan,
                     255,
                     S        );


  IF Err<>0 Then
    VSerGetSt := ''
  Else
    VSerGetSt := S;

END;

{}


(*-

[FUNCTION]

Function  VSerPeekCh(               Chan        : TSerHandle;
                                Var Ch          : CHAR          ) : TError;


[PARAMETERS]

Chan        serial channel handle
CH          (RETURNED) peeked character

[RETURNS]

0 if successfull, otherwise a serial error value.

[DESCRIPTION]

This function peeks a character into the variable "inch" from the
specified serial channel "chan"

This function will use the default read flags and timeout values.
(As set by VSerSetReadTimeout/VSerSetReadFlags)

[SEE-ALSO]

[EXAMPLE]

  { read a char from the channel }

  Err := VSerReadCh( MyChan, Ch );

  { if err=0, ch is the new char }

-*)


Function  VSerPeekCh(               Chan        : TSerHandle;
                                Var Ch          : CHAR          ) : TError;


BEGIN

END;



{}
{}
{}

BEGIN
END.



{
   SERIAL PORT NOTES
   =======================================================================

   Data Terminal Equipment (DTE): Originates and/or receives all of
     the data (program).

   Data Communications Equipment (DCE): Handles the problem of transmitting
     the data from place to place (modem).

   Request To Send (RTS) and Clear to Send (CTS):
   ----------------------------------------------
     Terminals may not transmit until CTS is received from the DCE.

     Although RTS/CTS are handshaking lines, they should never be used
     as flow control because it is very likely that data will be lost.

   Data Set Ready (DSR) and Data Terminal Ready (DTR):
   ---------------------------------------------------
     DSR (modem ready) is used to indicate that the modem is powered on
     and is not in test mode.

     In RS-232D, these are called DCE Ready and DTE Ready respectively.

     In calling-out, DTR is used to create the equivalent of an off-hook
     condition.  When the modem is in auto-answer mode, DTR may be asserted
     in response to the ring indicator to tell the modem to answer the
     incomming call.
}


{

  - 840AV (DEC) [8 track built in DSP)

  - Fujitsu 128 3.5 MO Cartridges.

  - Pinnacle Micro Optical hard drive.

  - Secondary storage.

  - $600

  QAM   - Quantative Amplitude Modulation - Video Transfer
                     Changing amplitude modulation
                     uses amplitude to change phase.

  QPSK  - Quantative Phase Shift Keying Modulation -
                     Shifting phase to send data
                     (data is encoded as phase shifts)





}


