{
 

 Visionix StringList Text File Device Driver Unit (VStrTxtU)
   Version 0.6
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 jrt       11/02/93  Changed to use stringlists in VSTRING;
                     renamed VStrTxtU

 jrt       10/27/93  Renamed from VATM to VATMU for beta 0.30

 lpg       03/15/93  Added Source Documentation

 mep       02/11/93  Cleaned up code for beta release

 jrt       02/08/93  Sync with beta 0.12 release

 jrt       12/07/92  Sync with beta 0.11 release

 jrt       11/21/92  Sync with beta 0.08

 jrt       09/01/92  First logged revision.

 
}

(*-

[TEXT]

<Overview>

This unit implements a text file device driver that will write to a
VSTRINGu string list.  This provides a flexable mechanism to use the
Write and WriteLn commands to format strings.

<Interface>

-*)

Unit VStrTxtu;

Interface

Uses

  VTypesu,
  VStringu,
  DOS;

{}

Procedure VStrTextAssign(     Var F              : Text;
                                  SL             : PStrList     );

Function  VStrTextGetLines(   Var F              : Text         ) : INTEGER;


{}

Implementation

Type

  TST_Info = RECORD

    SL        : PStrList;
    CurLine   : WORD;
    Buffer    : Array[0..255] of CHAR;

  END;

  PST_Info = ^TST_Info;

  {----}

Var

  HandlesGiven : BYTE;

  ST_InfoList : Array[1..32] of PST_Info;

{}

(*-

[FUNCTION]

Function VST_NullRoutine(     Var F              : TEXTREC      ):INTEGER;

[PARAMETERS]

F           VAR TextFile Record Handle

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function VST_NullRoutine(     Var F              : TEXTREC      ):INTEGER;
Far;

BEGIN

  VST_NullRoutine := 0;

END;  { VST_NullRoutine }

{}

(*-

[FUNCTION]

Function VST_InOutRoutine( var F : TEXTREC ) : INTEGER; Far;

[PARAMETERS]

F           VAR TextFile Handle Record

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function VST_InOutRoutine( var F : TEXTREC ) : INTEGER; Far;

Var
  Loopy   : INTEGER;
  Ch      : CHAR;
  ST_Info : PST_Info;
  S       : STRING;

BEGIN

  If F.Handle <> 0 Then
  BEGIN

    S := '';

    With F Do
    BEGIN

      ST_Info := ST_InfoList[ Handle ];

      Loopy := 0;

      While Loopy < BufPos Do
      BEGIN

        Case BufPtr^[Loopy] Of

          #10 :
          BEGIN

            {------------------------------------------}
            { put the string into the string list, and }
            { move onto the next line                  }
            {------------------------------------------}

            IF S<>'' Then
              VStrListPutStr( ST_Info^.SL,
                              ST_Info^.CurLine,
                              VStrListGetStr( ST_Info^.SL,
                                              ST_Info^.CurLine )+ S );

            S := '';

            Inc( ST_Info^.CurLine );

          END;

          #13 :
          BEGIN
          END;

        Else

          S := S + BufPtr^[Loopy];
(*
          ST_INfo^.Menu^[ ST_Info^.CurLine ]:=
                 ST_INfo^.Menu^[ ST_Info^.CurLine ]+ BufPtr^[Loopy];
*)

        END;  { Case BufPtr^[Loopy] }

        Inc( Loopy );

      END;  { While Loopy }

      {---------------------------------------------}
      { add the remainder to the string in the list }
      {---------------------------------------------}

      If S<>'' Then
        VStrListPutStr( ST_Info^.SL,
                        ST_Info^.CurLine,
                        VStrListGetStr( ST_Info^.SL,
                                        ST_Info^.CurLine )+ S );


      BufPos := 0;

      VST_InOutRoutine :=0;

    END;   { With F }

  END
  Else  { If F.Handle / Else }

    VST_InOutRoutine := 1;

END;   { Of InOutRoutine }

{}

(*-

[FUNCTION]

Function VST_CloseRoutine(    Var F              : TEXTREC      ):INTEGER;

[PARAMETERS]

F           VAR TextFile Record Handle

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function VST_CloseRoutine(    Var F              : TEXTREC      ):INTEGER;
Far;

Var
  Z : INTEGER;

BEGIN

  If F.Handle <> 0 Then
  BEGIN

    {------------------------}
    { Flush by calling InOut }
    {------------------------}

    Z := VST_InOutRoutine( F );

    {------------------------}
    { Dispose of the ST_Info }
    {------------------------}

    Dispose( ST_InfoList[ F.Handle ] );

    ST_InfoList[ F.Handle ] := NIL;

    {-------------------------}
    { Zero out the handle and }
    { return.                 }
    {-------------------------}

    F.Handle         := 0;

    VST_CloseRoutine := 0;

  END;  { If F.Handle }

END;  { VST_CloseRoutine }

{}

(*-

[FUNCTION]

Procedure VStrTextAssign(     Var F              : Text;
                                  StrList        : POINTER      );

[PARAMETERS]

F           VAR Text File Handle to Assign to Menu
StrList     Pointer to a string list

[RETURNS]

(None)

[DESCRIPTION]

Assigns the Text File Device Driver (TFDD) Handle "F" to a string list.
Subseqent Write operations to F will fill in the assigned string list.

  F                   Turbo Pascal TFDD Handle.
  Menu                Pointer to string list

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VStrTextAssign(     Var F              : Text;
                                  SL             : PStrList     );

Type

  PTextRec = ^TextRec;

Var

  ST_Info : PST_Info;
  F2      : PTextRec;
  Z       : INTEGER;

BEGIN

  F2 := @F;

  With F2^ Do
  BEGIN

    {----------------------------}
    { Make a new ST_Info record, }
    { F.Handle will point to it. }
    {----------------------------}

    New( ST_Info );

    ST_Info^.SL      := SL;
    ST_Info^.CurLine := 1;

    {-----------------}
    { Setup rest of F }
    {-----------------}

    Mode      := fmOutput;

    BufSize   := SizeOf( ST_Info^.Buffer );
    BufPtr    := @ST_Info^.Buffer;

    OpenFunc  := @VST_NullRoutine;
    FlushFunc := @VST_InOutRoutine;
    CloseFunc := @VST_CloseRoutine;
    InOutFunc := @VST_InOutRoutine;

    BufPos    := 0;

    { Search for handle slot }

    Z := 0;

    Repeat
      Inc( Z );
    Until (ST_InfoList[Z]=NIL) or (Z=32);

    If ST_InfoList[Z]=NIL Then
    BEGIN

      Handle                := Z;
      ST_InfoList[ Handle ] := ST_Info;

    END  { If ST_InfoList[z] }

    ELSE
      Handle := 0;

  END;  { With F2^ }

END;  { VAssignToMenu }

{}

(*-

[FUNCTION]

Function  VST_GetCurLine(     Var F              : Text         ) : INTEGER;

[PARAMETERS]

F           VAR Text File Handle (previously assigned to a menu)

[RETURNS]

Current Line number in Assigned Menu

[DESCRIPTION]

The Current Number of Lines in the Menu Assigned to the Text File.

VST_GetCurLine returns the current number of lines in the menu
assigned to "F".

 F                   Turbo Pascal TFDD Handle that has
                     previously been assigned to a menu.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VStrTextGetLines(   Var F              : Text         ) : INTEGER;

BEGIN

  VStrTextGetLines := ST_InfoList[ TextRec( F ).Handle ]^.CurLine;

END;  { VST_GetCurLine }

{}

(*-

[FUNCTION]

Procedure InitST_InfoList;

[PARAMETERS]

(None)

[RETURNS]

(None)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure InitST_InfoList;

Var

  Z : INTEGER;

BEGIN

  For Z:=1 to 32 Do
    ST_InfoList[Z] := NIL;

END;  { InitST_InfoList }

{}
{}
{}

BEGIN

  InitST_InfoList;

END.
