{
 

 Visionix "Text File" Read Unit (VTEXT)
   Version 0.6
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 jrt       11/15/93  NEED TO MAKE WORK IN OS/2--dos functions
                     are currently IFDEFed out.

 jrt       08/04/93  First logged revision.

 
}

(*-

[TEXT]

<Overview>

This function implements a text file device driver which "strips" or
ignores ASCII CTRL-Z (End Of File, EOF) markers.


<Interface>

-*)


Unit VTextu;

Interface

Uses

  VTypesu,
  VStringu,
  VGenu,
  DOS;


Procedure VTextAssign(            Flags     : WORD;
                              Var F         : Text;
                                  FName     : STRING           );




Implementation

Type

  TTFDDExInfo = RECORD




  END;

Type

  TMyTextRec = RECORD

    Handle        : WORD;
    Mode          : WORD;
    BufSize       : WORD;
    isPrivate     : WORD;
    BufPos        : WORD;
    Bufend        : WORD;
    BufPtr        : POINTER;
    OpenFunc      : POINTER;
    InOutFunc     : POINTER;
    FlushFunc     : POINTER;
    CloseFunc     : POINTER;

    TheFile       : ^FILE;
    TheOfs        : LONGINT;
    Reserved      : Array[1..8] of BYTE;

    Name          : Array[0..79] of CHAR;
    Buffer        : Array[0..127] of CHAR;

  END;


  PMyTextRecData = ^TMyTextRec;


{}


Function VTextReadInOutFunc(  Var F         : Text         ) : INTEGER;
Far;
Var

  Err : WORD;

{$IFNDEF OS2}
  R   : REGISTERS;
{$ENDIF}

  Z   : INTEGER;

BEGIN

  With TMyTextRec( F ) Do
  BEGIN

    {$IFNDEF OS2}

      R.AH := $3F;
      R.BX := FileRec( TheFile^ ).Handle;

      R.CX := BufSize;

      R.DS := Seg( BufPtr^ );
      R.DX := Ofs( BufPtr^ );

      Intr( $21, R );

      If Odd( R.Flags ) Then
      BEGIN

        VTextReadInOutFunc := R.AX;

      END
      ELSE
      BEGIN


        { Replace any CTRL-Zs with a 0 }

        BufferSRByte( @Buffer, BufSize, $1A, 0 );

        BufPos := 0;

        BufEnd := R.AX;

        VTextReadInOutFunc := 0;

      END; { If Odd( r.flags ) }

    {$ELSE}

    {$ENDIF}

  END; { with }

END; { VTextReadInOutFunc }

{}

Function VTextReadFlushFunc(  Var F         : Text         ) : INTEGER;
Far;

BEGIN

  With TextRec( F ) Do
  BEGIN
(*
    BufPos := 0;
    BufEnd := 0;
*)
  END;

  VTextReadFlushFunc := 0;

END;

{}

Function VTextReadCloseFunc(  Var F         : Text         ) : INTEGER;
Far;

BEGIN

  With TMyTextRec( F ) Do
  BEGIN

    Close( TheFile^ );

    Dispose( TheFile );

    VTextReadCloseFunc := IOResult;

  END;

END;

{}

Function VTextWriteInOutFunc( Var F         : Text         ) : INTEGER;
Far;

BEGIN

  With TextRec( F ) Do
  BEGIN


  END;

END;

{}

Function VTextWriteFlushFunc( Var F         : Text         ) : INTEGER;
Far;

BEGIN

  With TextRec( F ) Do
  BEGIN


  END;

END;

{}

Function VTextwriteCloseFunc( Var F         : Text         ) : INTEGER;
Far;

BEGIN

  With TextRec( F ) Do
  BEGIN


  END;

END;

{}

Function VTextOpenFunc(       Var F         : Text         ) : INTEGER;
Far;

Var

  S : STRING;
{$IFNDEF OS2}
  R : REGISTERS;
{$ENDIF}
  Z : INTEGER;

BEGIN

  With TMyTextRec( F ) Do
  BEGIN

    Case Mode of

      fmInOut:
      BEGIN


      END;

      fmOutput:
      BEGIN

      END;

      fmInput:
      BEGIN

        {$IFNDEF OS2}

          R.AH := $3D;
          R.AL := FileMode;
          R.DS := Seg( Name );
          R.DX := Ofs( Name );

          Intr( $21, R );

          If Odd( R.Flags ) Then
          BEGIN

            VTextOpenFunc := R.AX;

          END
          ELSE
          BEGIN

            FileRec( TheFile^ ).Handle  := R.AX;
            FileRec( TheFile^ ).Mode    := fmInOut;
            FileRec( TheFile^ ).RecSize := 1;

            For Z:=1 to 26 Do
              FileRec( TheFile^ ).Private[Z]  := 0;

            For Z:=1 to 16 Do
              FileRec( TheFile^ ).UserData[Z] := 0;

            Move( Name, FileRec( TheFile^ ).Name, 80 );

            InOutFunc    := @VTextReadInOutFunc;
            FlushFunc    := @VTextReadFlushFunc;
            CloseFunc    := @VTextReadCloseFunc;

            Handle       := R.AX;
            Mode         := fmInput;
            BufPos       := 0;

            VTextOpenFunc := 0;

          END;

        {$ELSE}

        {$ENDIF}

      END; { Case Mod of fmInput }

    END; { Case Mode of }

  END; { With textrec( f ) }

END; { Function VTextOpenFunc }

{}


Procedure VTextAssign(            Flags     : WORD;
                              Var F         : Text;
                                  FName     : STRING           );



BEGIN

  With TMyTextRec( F ) Do
  BEGIN

    Mode         := fmClosed;
    BufSize      := SizeOf( Buffer );
    BufPtr       := @Buffer;
    OpenFunc     := @VTextOpenFunc;
    InOutFunc    := NIL;
    FlushFunc    := NIL;
    CloseFunc    := NIL;

    StrToAsciiZ( FName, Name );

    New( TheFile );

  END;

END;

{tom kimb 628-0363}

{}
{}
{}


BEGIN

END.