{


 Visionix General Type Definitions Unit (VTYPE)
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED



 Revision history in reverse chronological order:

 Initials  Date      Comment
 --------  --------  -------------------------------------------------------

 rob       07/20/93  Added ST40.

 mep       04/07/93  Added TCharArray.

 mep       03/29/93  Added TDecHex and maxArrSize.

 mep       03/20/93  Added TWordArray and TLongIntArray.

 mep       02/11/93  Cleaned up code for beta release

 jrt       02/08/93  Sync with beta 0.12 release

 jrt       12/15/92  Changes for BP 7.0
                       Added constants which are defined in bp 7.0
                       but not in 6.0 so that they are included if
                       this unit is being compiled under 6.0

 jrt       11/21/92  Sync with beta 0.08

 lpg       10/07/92  Added String Constants:
                       cSPACE,cLoALPHA,cLoALPHANUM,cHiALPHA,cHiALPHANUM,
                       cALPHA,cALPHANUM,cNUMERIC,cGRAMMAR

 jrt       09/01/92  First logged revision.


}

(*-

[TEXT]

<Overview>

VTypesu is a unit that defines a variety of types, defines, and constants
that are used throught the VisionTools libraries.

<Interface>

-*)

Unit VTypesu;

Interface

{}

Const

  {---------}
  { Bitmaps }
  {---------}

  CBitMapB : Array[0..7] of Byte =
    ( $1, $2, $4, $8,
      $10, $20, $40, $80 );

  CBitMapW : Array[0..15] of Word =
    ( $1, $2, $4, $8,
      $10, $20, $40, $80,
      $100, $200, $400, $800,
      $1000, $2000, $4000, $8000 );

  CBitMapL : Array[0..31] of LongInt =
    ( $1, $2, $4, $8,
      $10, $20, $40, $80,
      $100, $200, $400, $800,
      $1000, $2000, $4000, $8000,
      $10000, $20000, $40000, $80000,
      $100000, $200000, $400000, $800000,
      $1000000, $2000000, $4000000, $8000000,
      $10000000, $20000000, $40000000, $80000000 );

  {-----------------}
  { Standard errors }
  {-----------------}

  SE_Ok       = 0;
  SE_NotFound = 1;
  SE_NoMem    = 2;
  SE_UserESC  = 3;

  {--------------------------}
  { Ascii Control Characters }
  {--------------------------}

  NUL   = #0;  {^@}     SOH   = #1;  {^A}     STX   = #2;  {^B}
  ETX   = #3;  {^C}     EOT   = #4;  {^D}     ENQ   = #5;  {^E}
  ACK   = #6;  {^F}     BEL   = #7;  {^G}     BS    = #8;  {^H}
  HT    = #9;  {^I}     LF    = #10; {^J}     VT    = #11; {^K}
  FF    = #12; {^L}     CR    = #13; {^M}     SO    = #14; {^N}
  SI    = #15; {^O}     DLE   = #16; {^P}     DC1   = #17; {^Q}
  DC2   = #18; {^R}     DC3   = #19; {^S}     DC4   = #20; {^T}
  NAK   = #21; {^U}     SYN   = #22; {^V}     ETB   = #23; {^W}
  CAN   = #24; {^X}     EM    = #25; {^Y}     SUB   = #26; {^Z}
  ESC   = #27;          FS    = #28; {^\}     GS    = #29; {^`}
  RS    = #30; {^=}     US    = #31; {^-}     SP    = #32;
  DEL   = #127;         BLANK = #255;         XON   = #17;
  XOFF  = #19;

  {-------------------------------}
  { Characters and character sets }
  {-------------------------------}

  cSPACE      = ' ';
  cLoALPHA    = 'abcdefghijklmnopqrstuvwxyz';
  cLoALPHANUM = 'abcdefghijklmnopqrstuvwxyz0123456789';
  cHiALPHA    = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  cHiALPHANUM = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
  cALPHA      = ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
  cALPHANUM   = ' abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
  cNUMERIC    = '0123456789';
  cGRAMMAR    = '!@#$%^&*(){}|[]\<>?,./';

  {----------------------------}
  { decimal / hex lookup table }
  {----------------------------}

  TDecHex : Array[0..15] of Char = '0123456789ABCDEF';

  {--------------------}
  { maximum array size }
  {--------------------}

  maxArrSize  = $FFF8;

{-------------------------------------------------------------------------}
{ Borland Pascal 7.0 compatability constants -- these are constants which }
{ are found in Pascal 7.0 but not in 6.0.  They are included so that      }
{ they can be used when the VTP units are compiled in 6.0                 }
{-------------------------------------------------------------------------}

{$IFNDEF VER70}

  Seg0040     = $0040;
  SegA000     = $A000;
  SegB000     = $B000;
  SegB800     = $B800;

  SelectorInc = $1000;

Type

  PChar       = ^Char;

{$ENDIF}

{--------------------------------------------------------------}
{ Define the VDLPROT protected mode flag when not in real mode }
{--------------------------------------------------------------}

{$IFDEF DPMI    } {$DEFINE VDLPROT} {$ENDIF}
{$IFDEF WINDOWS } {$DEFINE VDLPROT} {$ENDIF}
{$IFDEF OS2     } {$DEFINE VDLPROT} {$ENDIF}

{}

{-------------}
{ Misc. Types }
{-------------}

Type

  PByte      = ^BYTE;
  PInteger   = ^INTEGER;
  PWord      = ^WORD;
  PLongint   = ^LONGINT;
  PPointer   = ^POINTER;
  PReal      = ^REAL;

  ST2   = STRING[2];
  ST4   = STRING[4];
  ST5   = STRING[5];
  ST8   = STRING[8];
  ST16  = STRING[16];
  ST20  = STRING[20];
  ST32  = STRING[32];
  ST40  = STRING[40];
  ST80  = STRING[80];
  ST132 = STRING[132];
  ST255 = STRING[255];

  PST2   = ^ST2;
  PST4   = ^ST4;
  PST5   = ^ST5;
  PST8   = ^ST8;
  PST16  = ^ST16;
  PST20  = ^ST20;
  PST32  = ^ST32;
  PST40  = ^ST40;
  PST80  = ^ST80;
  PST132 = ^ST132;
  PST255 = ^ST255;

  TString = STRING;
  PString = ^TString;

  TProcName = String[20];
  PProcName = ^TProcName;

  THandle = POINTER;
  PHandle = ^THandle;

  {----------------}
  { Free-unions    }
  { (Cast records) }
  {----------------}

  TCastWord = RECORD
    LowByte  : BYTE;
    HighByte : BYTE;
  END;
  PCastWord = ^TCastWord;

  TCastDWord = RECORD
    LowWord  : WORD;
    HighWord : WORD;
  END;
  PCastDWord = ^TCastDWord;

  TCastQWord = RECORD
    LowDWord : LONGINT;
    HighDWord: LONGINT;
  END;
  PCastQWord = ^TCastQWord;

  {-----------------}
  { ShortInt arrays }
  {-----------------}

  TShortIntArray = ARRAY[1..maxArrSize] of SHORTINT;
  PShortIntArray = ^TShortIntArray;

  TShortIntArray0 = ARRAY[0..pred(maxArrSize)] of SHORTINT;
  PShortIntArray0 = ^TShortIntArray0;

  TShortIntDArray = Array[1..1] of SHORTINT;
  PShortIntDArray = ^TShortIntDArray;

  TShortIntDArray0 = Array[0..0] of SHORTINT;
  PShortIntDArray0 = ^TShortIntDArray0;

  {-------------}
  { Byte arrays }
  {-------------}

  TByteArray = ARRAY[1..maxArrSize] of BYTE;
  PByteArray = ^TByteArray;

  TByteArray0 = ARRAY[0..pred(maxArrSize)] of BYTE;
  PByteArray0 = ^TByteArray0;

  TByteDArray = Array[1..1] of BYTE;
  PByteDArray = ^TByteDArray;

  TByteDArray0 = Array[0..0] of BYTE;
  PByteDArray0 = ^TByteDArray0;

  {-------------}
  { Char arrays }
  {-------------}

  TCharArray = ARRAY[1..maxArrSize] of CHAR;
  PCharArray = ^TCharArray;

  TCharArray0 = ARRAY[0..pred(maxArrSize)] of CHAR;
  PCharArray0 = ^TCharArray0;

  TCharDArray = Array[1..1] of CHAR;
  PCharDArray = ^TCharDArray;

  TCharDArray0 = Array[0..0] of CHAR;
  PCharDArray0 = ^TCharDArray0;

  {----------------}
  { Integer arrays }
  {----------------}

  TIntArray = ARRAY[1..(maxArrSize DIV 2)] of INTEGER;
  PIntArray = ^PIntArray;

  TIntArray0 = ARRAY[0..Pred(maxArrSize DIV 2)] of INTEGER;
  PIntArray0 = ^PIntArray0;

  TIntDArray = Array[1..1] of INTEGER;
  PIntDArray = ^TIntDArray;

  TIntDArray0 = Array[0..0] of INTEGER;
  PIntDArray0 = ^TIntDArray0;

  {-------------}
  { Word arrays }
  {-------------}

  TWordArray = ARRAY[1..(maxArrSize DIV 2)] of WORD;
  PWordArray = ^PWordArray;

  TWordArray0 = ARRAY[0..Pred(maxArrSize DIV 2)] of WORD;
  PWordArray0 = ^PWordArray0;

  TWordDArray = Array[1..1] of WORD;
  PWordDArray = ^TWordDArray;

  TWordDArray0 = Array[0..0] of WORD;
  PWordDArray0 = ^TWordDArray0;

  {----------------}
  { Longint arrays }
  {----------------}

  TLongIntArray = ARRAY[1..(maxArrSize DIV 4)] of LONGINT;
  PLongIntArray = ^TLongIntArray;

  TLongIntArray0 = ARRAY[0..Pred(maxArrSize DIV 4)] of LONGINT;
  PLongIntArray0 = ^TLongIntArray0;

  TLongIntDArray = Array[1..1] of LONGINT;
  PLongIntDArray = ^TLongIntDArray;

  TLongIntDArray0 = Array[0..0] of LONGINT;
  PLongIntDArray0 = ^TLongIntDArray0;

{}
{}
{}

Implementation

BEGIN
END.
