{


 Visionix Virtual DMA Services Unit (VVDS)
   Version 0.1
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED



 Revision history in reverse chronological order:

 Initials  Date      Comment
 --------  --------  -------------------------------------------------------

 mep       03/27/93  Unit created.


}

(*-

[TEXT]

<Overview>

The VVDSu unit implements functions for the Microsoft/IBM Virtual
DMA Services (VDS) specification.  The virtual DMA services specifications
supplies services which allow for proper first and second party DMA
operations on PC/AT computers which are running in virtual memory
environments.  It includes services to get the physical address of
virtual memory locations; to get a scatter/gather list of virtualy
fragmented memory buffers; to allocate DMA translation buffer, and more.

<Interface>

-*)

Unit VVDSu;

Interface

{}

Const

  {-------------------------------------------}
  { Product Numbers - use with VVDSGetVersion }
  {-------------------------------------------}

  vdspnQMAPS      = $0000;  { Quadtel's QMAPS }
  vdspnHPMM       = $0000;  { Hewlett-Packard's HPMM.SYS }
  vdspnEMM386     = $0001;  { Microsoft's EMM386.EXE }
  vdspn386MAX     = $4560;  { Qualitas' 386MAX }
  vdspnMC         = $4D43;  { V Communication's Memory Commander }
  vdspnQEMM386    = $5145;  { Quarterdeck's QEMM-386 }

  vdsMaxArray     = $F;

  {-----------------------------------------}
  { Version Flags - use with VVDSGetVersion }
  {-----------------------------------------}

  vdsvfPCXTBus    = $1;     { DMA in first megabyte only }
  vdsvfPhyBuf     = $2;     { Physical buffer/Remap region in first megabyte }
  vdsvfAutoRemap  = $4;     { Automatic remap enabled }
  vdsvfPhyCont    = $8;     { All memory is physically contiguous }

Type

  TVDSErr = BYTE;

  {---}

  TDDS = RECORD  { DMA descriptor }

    RegionSize    : LONGINT;
    Offset        : LONGINT;
    SegSelector   : WORD;
    BufferID      : WORD;
    PhysicalAddr  : LONGINT;

  END;
  PDDS = ^TDDS;

  {---}

  TEDDS_Header = RECORD

    RegionSize    : LONGINT;
    Offset        : LONGINT;
    SegSelector   : WORD;
    Rsvp          : WORD;
    NumAvail      : WORD;
    NumUsed       : WORD;

  END;

  TEDDS_Region = RECORD

    PhysicalAddr  : LONGINT;
    Size          : LONGINT;

  END;

  TEDDS_Array = Array[0..vdsMaxArray] of TEDDS_Region;

  TEDDS = RECORD { Extended DMA descriptor }

    Header        : TEDDS_Header;
    Region        : TEDDS_Array;

  END;
  PEDDS = ^TEDDS;

  {---}

  TEDDSPageTable_Header = RECORD

    RegionSize    : LONGINT;
    Offset        : LONGINT;
    SegSelector   : WORD;
    Rsvp          : WORD;
    NumAvail      : WORD;
    NumUsed       : WORD;

  END;

  TEDDSPageTable_Region = RECORD

    Entry         : LONGINT;

  END;

  TEDDSPageTable_Array = Array[0..vdsMaxArray] of TEDDSPageTable_Region;

  TEDDSPageTable = RECORD { Extended DMA descriptor with page table entries }

    Header        : TEDDSPageTable_Header;
    PageTable     : TEDDSPageTable_Array;

  END;
  PEDDSPageTable = ^TEDDSPageTable;

{}

Function  VVDSErrorToStr(              ErrorCode      : TVDSErr   ) : STRING;

Function  VVDSInstalled                                             : BOOLEAN;

Function  VVDSGetVersion(          Var Version        : STRING;
                                   Var ProductNum     : WORD;
                                   Var ProductRev     : WORD;
                                   Var MaxDMABufSize  : LONGINT;
                                   Var Flags          : WORD      ) : TVDSErr;

Function  VVDSLockRegion(              Region         : PDDS;
                                       Flags          : WORD      ) : TVDSErr;

Function  VVDSUnlockRegion(            Region         : PDDS;
                                       Flags          : WORD      ) : TVDSErr;

Function  VVDSScatGatLockRegion(       Region         : PEDDS;
                                       Flags          : WORD      ) : TVDSErr;

Function  VVDSScatGatUnlockRegion(     Region         : PEDDS;
                                       Flags          : WORD      ) : TVDSErr;

Function  VVDSRequestDMABuf(           Region         : PDDS;
                                       Flags          : WORD      ) : TVDSErr;

Function  VVDSReleaseDMABuf(           Region         : PDDS;
                                       Flags          : WORD      ) : TVDSErr;

Function  VVDSCopyToDMABuf(            Region         : PDDS;
                                       DMABufOfs      : LONGINT   ) : TVDSErr;

Function  VVDSCopyFromDMABuf(          Region         : PDDS;
                                       DMABufOfs      : LONGINT   ) : TVDSErr;

Function  VVDSDisableDMATrans(         DMAChannel     : WORD      ) : TVDSErr;

Function  VVDSEnableDMATrans(          DMAChannel     : WORD;
                                   Var DCountAtZero   : BOOLEAN   ) : TVDSErr;

{}

Implementation

Uses

  DOS,
  VTypesu,
  VGenu;

{}

(*-

[FUNCTION]

Function  VVDSErrorToStr(              ErrorCode      : TVDSErr   ) : STRING;

[PARAMETERS]

ErrorCode   Errorcode of VDS call.

[RETURNS]

String of errorcode

[DESCRIPTION]

Returns a string of the cooresponding VDS errorcode.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSErrorToStr(              ErrorCode      : TVDSErr   ) : STRING;

Var

  S : STRING;

BEGIN

  S := '';

  Case ErrorCode of

    $01 : S := 'Region not in contiguous memory';
    $02 : S := 'Region crossed a physical alignment boundary';
    $03 : S := 'Unable to lock pages';
    $04 : S := 'No buffer available';
    $05 : S := 'Region too large for buffer';
    $06 : S := 'Buffer currently in use';
    $07 : S := 'Invalid memory region';
    $08 : S := 'Region was not locked';
    $09 : S := 'Number of physical pages greater than table length';
    $0A : S := 'Invalid buffer ID';
    $0B : S := 'Copy out of buffer range';
    $0C : S := 'Invalid DMA channel number';
    $0D : S := 'Disable count overflow';
    $0E : S := 'Disable count underflow';
    $0F : S := 'Function not supported';
    $10 : S := 'Reserved flag bits set in DX';

  End;

  VVDSErrorToStr := S;

END;

{}

(*-

[FUNCTION]

Function  VVDSInstalled                                             : BOOLEAN;

[PARAMETERS]

(none)

[RETURNS]

Condition of VDS.

[DESCRIPTION]

Checks for the presence of the Virtual DMA Services.

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSInstalled                                             : BOOLEAN;

BEGIN

  {-------------------------------}
  { This bit test is not reliable }
  {-------------------------------}

  VVDSInstalled := ( Byte(Ptr(Seg0040, $7B)^) AND $10 <> 0 );

END;

{}

(*-

[FUNCTION]

Function  VVDSGetVersion(          Var Version        : STRING;
                                   Var ProductNum     : WORD;
                                   Var ProductRev     : WORD;
                                   Var MaxDMABufSize  : LONGINT;
                                   Var Flags          : WORD      ) : TVDSErr;

[PARAMETERS]

(none)

[RETURNS]

Version        Version of VDS.
ProductNum     Product number of installed VDS.
ProductRev     Revision number of installed VDS.
MaxDMABufSize  for later

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSGetVersion(          Var Version        : STRING;
                                   Var ProductNum     : WORD;
                                   Var ProductRev     : WORD;
                                   Var MaxDMABufSize  : LONGINT;
                                   Var Flags          : WORD      ) : TVDSErr;

Var

  R : REGISTERS;

BEGIN

  R.AX := $8102;
  R.DX := $0000;
  R.ES := 0;
  R.DS := 0;

  Intr( $4B, R );

  If (R.Flags AND FCarry <> 0) Then
  BEGIN

    VVDSGetVersion := R.AL;

  END
  Else
  BEGIN

    Version        := IntToStr( R.AH ) + '.' + IntToStr( R.AL );
    ProductNum     := R.BX;
    ProductRev     := R.CX;
    MaxDMABufSize  := (R.SI SHL 16) + R.DI;  { SI:DI }
    Flags          := R.DX;

    VVDSGetVersion := 0;

  END;

END;

{}

(*-

[FUNCTION]

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSLockRegion(              Region         : PDDS;
                                       Flags          : WORD      ) : TVDSErr;

BEGIN

END;

{}

(*-

[FUNCTION]

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSUnlockRegion(            Region         : PDDS;
                                       Flags          : WORD      ) : TVDSErr;

BEGIN

END;

{}

(*-

[FUNCTION]

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSScatGatLockRegion(       Region         : PEDDS;
                                       Flags          : WORD      ) : TVDSErr;

BEGIN

END;

{}

(*-

[FUNCTION]

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSScatGatUnlockRegion(     Region         : PEDDS;
                                       Flags          : WORD      ) : TVDSErr;

BEGIN

END;

{}

(*-

[FUNCTION]

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSRequestDMABuf(           Region         : PDDS;
                                       Flags          : WORD      ) : TVDSErr;

BEGIN

END;

{}

(*-

[FUNCTION]

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSReleaseDMABuf(           Region         : PDDS;
                                       Flags          : WORD      ) : TVDSErr;

BEGIN

END;

{}

(*-

[FUNCTION]

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSCopyToDMABuf(            Region         : PDDS;
                                       DMABufOfs      : LONGINT   ) : TVDSErr;

BEGIN

END;

{}

(*-

[FUNCTION]

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSCopyFromDMABuf(          Region         : PDDS;
                                       DMABufOfs      : LONGINT   ) : TVDSErr;

BEGIN

END;

{}

(*-

[FUNCTION]

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSDisableDMATrans(         DMAChannel     : WORD      ) : TVDSErr;

BEGIN

END;

{}

(*-

[FUNCTION]

[PARAMETERS]

[RETURNS]

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function  VVDSEnableDMATrans(          DMAChannel     : WORD;
                                   Var DCountAtZero   : BOOLEAN   ) : TVDSErr;

BEGIN

END;

{}
{}
{}

BEGIN
END.