{


 Visionix OS/2 16-Bit VIO DLL API Import Unit
 Copyright 1993 Visionix
 ALL RIGHTS RESERVED



 Revision history in reverse chronological order:

 Initials  Date      Comment
 --------  --------  -------------------------------------------------------

 jrt       12/11/93  First logged revision.


}




Unit VVioI;

Interface

Uses

  VTypesu,
  VTypes2u;

Const

  { VioRegister 1st parameter constants }

  VR_VIOGETCURPOS         = $00000001;
  VR_VIOGETCURTYPE        = $00000002;
  VR_VIOGETMODE           = $00000004;
  VR_VIOGETBUF            = $00000008;
  VR_VIOGETPHYSBUF        = $00000010;
  VR_VIOSETCURPOS         = $00000020;
  VR_VIOSETCURTYPE        = $00000040;
  VR_VIOSETMODE           = $00000080;
  VR_VIOSHOWBUF           = $00000100;
  VR_VIOREADCHARSTR       = $00000200;
  VR_VIOREADCELLSTR       = $00000400;
  VR_VIOWRTNCHAR          = $00000800;
  VR_VIOWRTNATTR          = $00001000;
  VR_VIOWRTNCELL          = $00002000;
  VR_VIOWRTTTY            = $00004000;
  VR_VIOWRTCHARSTR        = $00008000;

  VR_VIOWRTCHARSTRATT     = $00010000;
  VR_VIOWRTCELLSTR        = $00020000;
  VR_VIOSCROLLUP          = $00040000;
  VR_VIOSCROLLDN          = $00080000;
  VR_VIOSCROLLLF          = $00100000;
  VR_VIOSCROLLRT          = $00200000;
  VR_VIOSETANSI           = $00400000;
  VR_VIOGETANSI           = $00800000;
  VR_VIOPRTSC             = $01000000;
  VR_VIOSCRLOCK           = $02000000;
  VR_VIOSCRUNLOCK         = $04000000;
  VR_VIOSAVREDRAWWAIT     = $08000000;
  VR_VIOSAVREDRAWUNDO     = $10000000;
  VR_VIOPOPUP             = $20000000;
  VR_VIOENDPOPUP          = $40000000;
  VR_VIOPRTSCTOGGLE       = $80000000;


  { VioRegister 2nd paramater constants }

  VR_VIOMODEWAIT    = $00000001;
  VR_VIOMODEUNDO    = $00000002;
  VR_VIOGETFONT     = $00000004;
  VR_VIOGETCONFIG   = $00000008;
  VR_VIOSETCP       = $00000010;
  VR_VIOGETCP       = $00000020;
  VR_VIOSETFONT     = $00000040;
  VR_VIOGETSTATE    = $00000080;
  VR_VIOSETSTATE    = $00000100;

  { VioModeInfo color constants }

  COLORS_2          = $01;
  COLORS_4          = $02;
  COLORS_16         = $04;

  { VioModeInfo screen mode constants }

  VGMT_OTHER        = $01;
  VMGT_GRAPHICS     = $02;
  VGMT_DISABLEBURST = $04;

  { Constants for VioCheckCharType }

  VCC_SBCSCHAR      = 0;
  VCC_DBCSFULLCHAR  = 1;
  VCC_DBCS1STHALF   = 2;
  VCC_DBCS2NDHALF   = 3;

  { constants for VioSetAnsi }

  ANSI_ON           = 1;
  ANSI_OFF          = 0;

  { constants for redraw functions }

  VSRWI_SAVEANDREDRAW   = 0;
  VSRWI_REDRAW          = 1;

  VSRWN_SAVE            = 0;
  VSRWN_REDRAW          = 1;

  UNDOI_GETOWNER        = 0;
  UNDOI_RELEASEOWNER    = 1;

  UNDOK_ERRORCODE       = 0;
  UNDOK_TERMINATE       = 1;


  { constants for VioModexxx }

  VMWR_POPUP            = 0;
  VMWN_POPUP            = 0;


  { Screen lock constants }

  LOCKIO_NOWAIT         = 0;
  LOCKIO_WAIT           = 1;

  LOCK_SUCCESS          = 0;
  LOCK_FAIL             = 1;

  { TVioConfigInfo.adapter constants }

  DISPLAY_MONOCHROME    = $0000;
  DISPLAY_CGA           = $0001;
  DISPLAY_EGA           = $0002;
  DISPLAY_VGA           = $0003;
  DISPLAY_8514A         = $0007;

  { TVioConfigInfo.Display constants }

  MONITOR_MONOCHROME    = $0000;
  MONITOR_COLOR         = $0001;
  MONITOR_ENHANCED      = $0002;
  MONITOR_8503          = $0003;
  MONITOR_851X_COLOR    = $0004;
  MONITOR_8514          = $0009;

  { VioConfigInfo ??? constants }

  VIO_CONFIG_CURRENT    = 0;
  VIO_CONFIG_PRIMARY    = 1;
  VIO_CONFIG_SECONDARY  = 2;

  { VioGetFont constants }

  VGFI_GETCURFONT       = 0;
  VGFI_GETROMFONT       = 1;


{-------------------------------------------------}
{ Font type attr structure (for VioCreateLogFont) }
{-------------------------------------------------}

Type

  TFontAttr = RECORD

    RecordLength      : WORD;
    Selection         : WORD;
    Match             : LONGINT;
    Facename          : Array[0..7] of CHAR; {!^!???}
    IDRegistry        : WORD;
    CodePage          : WORD;
    MaxBaseLineExt    : LONGINT;
    AveCharWidth      : LONGINT;
    WidthClass        : WORD;
    WeightClass       : WORD;
    TheType           : WORD;
    Quality           : INTEGER;
    FontUse           : WORD;

  END;

  PFontAttr = ^TFontAttr;

{--------------------------------------------------}
{ VIO Config info structure (For VioGetConfigInfo) }
{--------------------------------------------------}

Type

  TVioConfigInfo = RECORD

    CB                : WORD;
    Adapter           : WORD;
    Display           : WORD;
    Memory            : WORD;

    {
    Memory            : LONGINT;
    Configuration     : WORD;
    VDHVersion        : WORD;
    Flags             : WORD;
    HWBufferSize      : LONGINT;
    FullSaveSize      : LONGINT;
    PartSaveSize      : LONGINT;
    EMAdaptersOFF     : WORD;
    EMDisplaysOFF     : WORD;
    }

  END;

  PVioConfigInfo = ^TVioConfigInfo;

{-----------------------------------------------}
{ VIO cursor info structure (for VioGetCurInfo) }
{-----------------------------------------------}

Type

  TVioCursorInfo = RECORD

    ScanStart         : WORD;
    ScanEnd           : WORD;
    Width             : WORD;
    Attr              : WORD;

  END;

  PVioCursorInfo = ^TVioCursorInfo;


{----------------------------------------------}
{ VIO Font info structure (for VioGet/SetFont) }
{----------------------------------------------}

Type

  TVioFontInfo = RECORD

    CB                : WORD;
    TheType           : WORD;
    CellCols          : WORD;
    CellRows          : WORD;
    FontData          : POINTER;
    CBData            : WORD;

  END;

  PVioFontInfo = ^TVioFontInfo;


{----------------------------------------------}
{ VIO Mode info structure (for VioGet/SetMode) }
{----------------------------------------------}

Type

  TVioModeInfo = RECORD

    CB                : WORD;
    ModeType          : BYTE;
    Color             : BYTE;
    Cols              : WORD;
    Rows              : WORD;
    HorizRes          : WORD;
    VertRes           : WORD;
    (*
    FormatID          : BYTE;
    Attrib            : BYTE;
    BufAdr            : POINTER;
    BufLength         : LONGINT;
    FullLength        : LONGINT;
    PartialLength     : LONGINT;
    ExtDataAddr       : POINTER;
    *)

  END;

  PVioModeInfo = ^TVioModeInfo;


  Const

    cVGMT_Other        = 0;
    cVGMT_Graphics     = 1;
    cVGMT_DisableBurst = 2;

    cColors2           = 1;
    cColors4           = 2;
    cColors16          = 3;


{------------------------}
{ Video buffer cell type }
{------------------------}

Type

  TCell = RECORD

    CH   : CHAR;
    Attr : BYTE;

  END;

  PCell = ^TCell;


{-------------------------------------------}
{ VioPhysBuff structure (for VioGetPhysBuf) }
{-------------------------------------------}

Type

  TVioPhysBuf = RECORD

    Buff     : POINTER;
    CB       : LONGINT;
    TheSel   : Array[1..1] of TSel;

  END;

  PVioPhysBuf = ^TVioPhysBuf;

{---------------------------------}
{ VioGet/SetState structure types }
{---------------------------------}

  { !^! need info on color,uline, target stuff }

{ values for "TheType" fields }

Const

  VS_VIOPALSTATE        = 0;
  VS_VIOOVERSCAN        = 1;
  VS_VIOINTENSITY       = 2;
  VS_VIOCOLOREG         = 3;
  VS_VIOSETULINELOC     = 4;
  VS_VIOSETTARGET       = 5;


Type

  TVioPalState = RECORD

    CB         : WORD;
    TheType    : WORD;  {0}
    First      : WORD;
    Color      : Array[1..1] of WORD;

  END;

  PVioPalState = ^TVioPalState;

  TVioOverScan = RECORD

    CB         : WORD;
    TheType    : WORD;  {1}
    Color      : WORD;

  END;

  PVioOverScan = ^TVioOverScan;

  TVioIntensity = RECORD

    CB         : WORD;
    TheType    : WORD;  {2}

    FS         : WORD;

  END;

  PVioIntensity = ^TVioIntensity;

  TVioColorReg = RECORD

    CB         : WORD;
    TheType    : WORD;  {3??}
    FirstReg   : WORD;
    NumRegs    : WORD;
    RegAddr    : POINTER;

  END;

  PVioColorReg = ^TVioColorReg;

  TVioSetUlineLoc = RECORD

    CB         : WORD;
    TheType    : WORD;  {4??}
    ScanLine   : WORD;

  END;

  PVioSetUlineLoc = ^TVioSetULineLoc;

  TVioSetTarget = RECORD

    CB         : WORD;
    TheType    : WORD;  {5??}
    DefAlgo    : WORD;

  END;

  PVioSetTarget = ^TVioSetTarget;


{--------------------------------------------------------------------------}

Function VioAssociate(            HDC            : THDC;
                                  PrSpaceHandle  : THVPS   ) : WORD;

Function VioCheckCharType(        TheType        : PWORD;
                                  Row            : WORD;
                                  COL            : WORD;
                                  VioHandle      : THVIO   ) : WORD;


Function VioCreateLogFont(        FontAttr       : PFontAttr;
                                  FontLocalID    : LONGINT;
                                  FontName       : PStr8;
                                  PrSpaceHandle  : THVPS   ) : WORD;

Function  VioCreatePS(            NewHVPS        : PHVPS;
                                  Rows           : WORD;
                                  Cols           : WORD;
                                  Format         : WORD;
                                  AttrBytes      : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;

Function  VioDeleteSetID(         LocalID        : LONGINT;
                                  PrSpaceHandle  : THVPS   ) : WORD;

Function  VioDeRegister                                      : WORD;

Function  VioDestoryPS(           PrSpaceHandle  : THVPS   ) : WORD;

Function  VioEndPopUp(            VioHandle      : THVIO   ) : WORD;

Function  VioGetAnsi(         Var AnsiFlag       : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioGetBuf(          Var BuffAddr       : POINTER;
                              Var BuffSize       : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioGetConfig(           Reserved       : WORD;
                              Var VIOConfigInfo  : TVIOConfigInfo;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioGetCP(               Reserved       : WORD;
                              Var CodePage       : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioGetCurPos(       Var Row            : WORD;
                              Var Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioGetCurType(      Var VioCursorInfo  : TVIOCursorInfo;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioGetDeviceCellSize(Var Rows          : WORD;
                              Var Cols           : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;

Function  VioGetFont(             VIOFontInfo    : PVIOFontInfo;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioGetMode(         Var VIOModeInfo    : TVioModeInfo;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioGetOrg(          Var Row            : WORD;
                              Var Col            : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;


Function  VioGetPhysBuf(          VioPhysBuf     : PVioPhysBuf;
                                  Reserved       : WORD    ) : WORD;

Function  VioGetState(        Var StateInfo;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioModeUndo(            RelFlags       : WORD;
                                  TermFlags      : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioModeWait(            EventFlags     : WORD;
                                  NotifyVar      : PUShort;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioPopUp(               WaitFlagVar    : PUShort;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioPrtSc(               VioHandle      : THVIO   ) : WORD;

Function  VioPrtScToggle(         Viohandle      : THVIO   ) : WORD;


(*
Function  VioQueryFonts(      Var CbMetrics      : LONGINT;
                                  FontMetrics    : PFontMetrics;
                                  MetricsCB      : LONGINT;
                              Var NumFonts       : LONGINT;
                                  Facename       : PChar;
                                  Options        : LONGINT;
                                  PrSpaceHandle  : THVPS   ) : WORD;


Function  VioQuerySetIds(
*)

Function  VioReadCellStr(         Buff           : POINTER;
                              Var BuffLen        : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioReadCharStr(         Buff           : POINTER;
                              Var BuffLen        : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

{
Function  VioRedrawSize(          CBRedraw       : PCBRedraw ) : WORD;
}

Function  VioRegister(            ModuleName     : PCHAR;
                                  EntryName      : PCHAR;
                                  Function1      : LONGINT;
                                  Function2      : LONGINT ) : WORD;

Function  VioSavRedrawUndo(       RelFlags       : WORD;
                                  TermFlags      : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioSavRedrawWait(       EventFlags     : WORD;
                                  NotifyVar      : PUShort;
                                  Reserved       : WORD;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioScrLock(             WaitFlags      : WORD;
                                  NotLockedVar   : PBYTE;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioScrollDn(            TopRow         : WORD;
                                  LeftCol        : WORD;
                                  BottomRow      : WORD;
                                  RightCol       : WORD;
                                  ScrollCount    : WORD;
                                  CellToWrite    : PCell;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioScrollLf(            TopRow         : WORD;
                                  LeftCol        : WORD;
                                  BottomRow      : WORD;
                                  RightCol       : WORD;
                                  ScrollCount    : WORD;
                                  CellToWrite    : PCell;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioScrollRt(            TopRow         : WORD;
                                  LeftCol        : WORD;
                                  BottomRow      : WORD;
                                  RightCol       : WORD;
                                  ScrollCount    : WORD;
                                  CellToWrite    : PCell;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioScrollUp(            TopRow         : WORD;
                                  LeftCol        : WORD;
                                  BottomRow      : WORD;
                                  RightCol       : WORD;
                                  ScrollCount    : WORD;
                                  CellToWrite    : PCell;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioScrUnLock(           VioHandle      : THVIO   ) : WORD;

Function  VioSetAnsi(             AnsiFlag       : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioSetCP(               Reserved       : WORD;
                                  CodePage       : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioSetCurPos(           Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioSetCurType(          VioCursorInfo  : PVioCursorInfo;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioSetDeviceCellSize(   Rows           : WORD;
                                  Cols           : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;

Function  VioSetFont(             VioFontInfo    : PVioFontInfo;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioSetMode(             VioModeInfo    : PVioModeInfo;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioSetOrg(              Row            : WORD;
                                  Col            : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;

Function  VioSetState(            State          : POINTER;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioShowBuf(             VidBuffOfs     : WORD;
                                  VidBuffLen     : WORD;
                                  Viohandle      : THVIO   ) : WORD;

Function  VioShowPS(              Rows           : WORD;
                                  Cols           : WORD;
                                  Offset         : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;

Function  VioWrtCellStr(          Buff           : POINTER;
                                  BuffLen        : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioWrtCharStr(          Buff           : POINTER;
                                  BuffLen        : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;




Function  VioWrtCharStrAttr(      Buff           : POINTER;
                                  BuffLen        : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  Attr           : PBYTE;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioWrtNAttr(            Attr           : PBYTE;
                                  Count          : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

Function  VioWrtNCell(            Cell           : PCell;
                                  Count          : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioWrtNChar(            Char           : PChar;
                                  Count          : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;


Function  VioWrtTTY(              Str            : PChar;
                                  StrLen         : WORD;
                                  VioHandle      : THVIO   ) : WORD;



{--------------------------------------------------------------------------}

Implementation

Function VioAssociate(            HDC            : THDC;
                                  PrSpaceHandle  : THVPS   ) : WORD;

  External 'VIOCALLS' Index 55;


Function VioCheckCharType(        TheType        : PWORD;
                                  Row            : WORD;
                                  COL            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 75;

Function VioCreateLogFont(        FontAttr       : PFontAttr;
                                  FontLocalID    : LONGINT;
                                  FontName       : PStr8;
                                  PrSpaceHandle  : THVPS   ) : WORD;

  External 'VIOCALLS' Index 60;



Function  VioCreatePS(            NewHVPS        : PHVPS;
                                  Rows           : WORD;
                                  Cols           : WORD;
                                  Format         : WORD;
                                  AttrBytes      : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;

  External 'VIOCALLS' Index 56;



Function  VioDeleteSetID(         LocalID        : LONGINT;
                                  PrSpaceHandle  : THVPS   ) : WORD;


  External 'VIOCALLS' Index 57;


Function  VioDeRegister                                      : WORD;


  External 'VIOCALLS' Index 6;


Function  VioDestoryPS(           PrSpaceHandle  : THVPS   ) : WORD;


  External 'VIOCALLS' Index 61;


Function  VioEndPopUp(            VioHandle      : THVIO   ) : WORD;


  External 'VIOCALLS' Index 1;


Function  VioGetAnsi(         Var AnsiFlag       : WORD;
                                  VioHandle      : THVIO   ) : WORD;


  External 'VIOCALLS' Index 3;


Function  VioGetBuf(          Var BuffAddr       : POINTER;
                              Var BuffSize       : WORD;
                                  VioHandle      : THVIO   ) : WORD;


  External 'VIOCALLS' Index 31;


Function  VioGetConfig(           Reserved       : WORD;
                              Var VIOConfigInfo  : TVIOConfigInfo;
                                  VioHandle      : THVIO   ) : WORD;


  External 'VIOCALLS' Index 46;


Function  VioGetCP(               Reserved       : WORD;
                              Var CodePage       : WORD;
                                  VioHandle      : THVIO   ) : WORD;


  External 'VIOCALLS' Index 40;


Function  VioGetCurPos(       Var Row            : WORD;
                              Var Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;


  External 'VIOCALLS' Index 9;


Function  VioGetCurType(      Var VioCursorInfo  : TVIOCursorInfo;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 27;




Function  VioGetDeviceCellSize(Var Rows          : WORD;
                              Var Cols           : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;

  External 'VIOCALLS' Index 58;



Function  VioGetFont(             VIOFontInfo    : PVIOFontInfo;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 29;




Function  VioGetMode(         Var VIOModeInfo    : TVioModeInfo;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 21;




Function  VioGetOrg(          Var Row            : WORD;
                              Var Col            : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;

  External 'VIOCALLS' Index 59;




Function  VioGetPhysBuf(          VioPhysBuf     : PVioPhysBuf;
                                  Reserved       : WORD    ) : WORD;

  External 'VIOCALLS' Index 2;



Function  VioGetState(        Var StateInfo;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 49;




Function  VioModeUndo(            RelFlags       : WORD;
                                  TermFlags      : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 35;



Function  VioModeWait(            EventFlags     : WORD;
                                  NotifyVar      : PUShort;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 37;



Function  VioPopUp(               WaitFlagVar    : PUShort;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 11;



Function  VioPrtSc(               VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 8;



Function  VioPrtScToggle(         Viohandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 50;




(*
Function  VioQueryFonts(      Var CbMetrics      : LONGINT;
                                  FontMetrics    : PFontMetrics;
                                  MetricsCB      : LONGINT;
                              Var NumFonts       : LONGINT;
                                  Facename       : PChar;
                                  Options        : LONGINT;
                                  PrSpaceHandle  : THVPS   ) : WORD;


Function  VioQuerySetIds(
*)

Function  VioReadCellStr(         Buff           : POINTER;
                              Var BuffLen        : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 24;



Function  VioReadCharStr(         Buff           : POINTER;
                              Var BuffLen        : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 30;



Function  VioRegister(            ModuleName     : PCHAR;
                                  EntryName      : PCHAR;
                                  Function1      : LONGINT;
                                  Function2      : LONGINT ) : WORD;

  External 'VIOCALLS' Index 45;



Function  VioSavRedrawUndo(       RelFlags       : WORD;
                                  TermFlags      : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 28;



Function  VioSavRedrawWait(       EventFlags     : WORD;
                                  NotifyVar      : PUShort;
                                  Reserved       : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 25;




Function  VioScrLock(             WaitFlags      : WORD;
                                  NotLockedVar   : PBYTE;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 23;




Function  VioScrollDn(            TopRow         : WORD;
                                  LeftCol        : WORD;
                                  BottomRow      : WORD;
                                  RightCol       : WORD;
                                  ScrollCount    : WORD;
                                  CellToWrite    : PCell;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 47;



Function  VioScrollLf(            TopRow         : WORD;
                                  LeftCol        : WORD;
                                  BottomRow      : WORD;
                                  RightCol       : WORD;
                                  ScrollCount    : WORD;
                                  CellToWrite    : PCell;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 44;



Function  VioScrollRt(            TopRow         : WORD;
                                  LeftCol        : WORD;
                                  BottomRow      : WORD;
                                  RightCol       : WORD;
                                  ScrollCount    : WORD;
                                  CellToWrite    : PCell;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 12;



Function  VioScrollUp(            TopRow         : WORD;
                                  LeftCol        : WORD;
                                  BottomRow      : WORD;
                                  RightCol       : WORD;
                                  ScrollCount    : WORD;
                                  CellToWrite    : PCell;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 7;




Function  VioScrUnLock(           VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 18;



Function  VioSetAnsi(             AnsiFlag       : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 5;



Function  VioSetCP(               Reserved       : WORD;
                                  CodePage       : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 42;



Function  VioSetCurPos(           Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 15;



Function  VioSetCurType(          VioCursorInfo  : PVioCursorInfo;
                                  VioHandle      : THVIO   ) : WORD;


  External 'VIOCALLS' Index 32;


Function  VioSetDeviceCellSize(   Rows           : WORD;
                                  Cols           : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;

  External 'VIOCALLS' Index 65;



Function  VioSetFont(             VioFontInfo    : PVioFontInfo;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 33;




Function  VioSetMode(             VioModeInfo    : PVioModeInfo;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 22;




Function  VioSetOrg(              Row            : WORD;
                                  Col            : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;


  External 'VIOCALLS' Index 63;


Function  VioSetState(            State          : POINTER;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 51;



Function  VioShowBuf(             VidBuffOfs     : WORD;
                                  VidBuffLen     : WORD;
                                  Viohandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 43;



Function  VioShowPS(              Rows           : WORD;
                                  Cols           : WORD;
                                  Offset         : WORD;
                                  PrSpaceHandle  : THVPS   ) : WORD;

  External 'VIOCALLS' Index 66;



Function  VioWrtCellStr(          Buff           : POINTER;
                                  BuffLen        : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 10;



Function  VioWrtCharStr(          Buff           : POINTER;
                                  BuffLen        : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 13;






Function  VioWrtCharStrAttr(      Buff           : POINTER;
                                  BuffLen        : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  Attr           : PBYTE;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 48;




Function  VioWrtNAttr(            Attr           : PBYTE;
                                  Count          : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 26;



Function  VioWrtNCell(             Cell           : PCell;
                                  Count          : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;


  External 'VIOCALLS' Index 52;



Function  VioWrtNChar(            Char           : PChar;
                                  Count          : WORD;
                                  Row            : WORD;
                                  Col            : WORD;
                                  VioHandle      : THVIO   ) : WORD;

  External 'VIOCALLS' Index 53;




Function  VioWrtTTY(              Str            : PChar;
                                  StrLen         : WORD;
                                  VioHandle      : THVIO   ) : WORD;



  External 'VIOCALLS' Index 19;






{--------------------------------------------------------------------------}
{--------------------------------------------------------------------------}
{--------------------------------------------------------------------------}

BEGIN

END.
