{
 

 Visionix Extended Memory Services Unit (VXMS)
   Version 0.9
 Copyright 1991,92,93 Visionix
 ALL RIGHTS RESERVED

 

 Revision history in reverse chronological order:

 Initials  Date      Comment
     

 mep       03/25/93  Merged with VMemLow XMS routines.

 lpg       03/15/93  Added Source Documentation

 mep       02/11/93  Cleaned up code for beta release

 jrt       02/08/93  Sync with beta 0.12 release

 lpg       12/27/92  Cleaned up Unit

 jrt       12/07/92  Sync with beta 0.11 release

 lpg       11/25/92  Debugged ASM Routines

 jrt       11/21/92  Sync with beta 0.08

 mep/lpg   11/18/92  First logged revision.

 

}

(*-

[TEXT]

<Overview>

This unit implements a function for all commands in the XMS
specification.

The documentation for this unit will be enhanced in the next release.




<Interface>

-*)

Unit

  VXMSu;

Interface

Uses

  VTypesu,
  DOS;

{}

Type

  TXMSError   = BYTE;

  TXMBHandle  = WORD;
  TXMSHandleOfs  = LONGINT;

  TXMSHandle  = WORD;
  PXMSHandle  = ^TXMSHandle;

  TXMSMoveData = RECORD
    Count     : LONGINT;    { 32-bit, num bytes to trans }
    Source    : TXMBHandle;
    SourceOfs : TXMSHandleOfs;
    Dest      : TXMBHandle;
    DestOfs   : TXMSHandleOfs;
  END;
  PXMSMoveData = ^TXMSMoveData;

{}

{----------}
{ XMS 2.0+ }
{----------}

Function  VXMSErrorToStr(             Status       : BYTE       ) : STRING;

Function  VXMSInstalled                            : BOOLEAN;

Procedure VXMSGetHandleAddr;

Function  VXMSGetVersion                           : WORD;

Function  VXMMGetVersion                           : WORD;

Function  VHMAPresent                              : BOOLEAN;

Function  VHMANew                                  : TXMSError;

Function  VHMANewTSR(                 HMABytes     : WORD       ) : TXMSError;

Function  VHMADispose                              : TXMSError;

Function  VA20GlobalEnable                         : TXMSError;

Function  VA20GlobalDisable                        : TXMSError;

Function  VA20LocalEnable                          : TXMSError;

Function  VA20LocalDisable                         : TXMSError;

Function  VA20Query                                : TXMSError;

Function  VXMSGetFreeStat(        Var MaxBlock     : WORD;
                                  Var TotalK       : WORD       ) : TXMSError;

Function  VXMSGetMaxBlock                          : WORD;

Function  VXMSGetTotalFreeK                        : WORD;

Function  VXMBNew(                    SizeInK      : WORD;
                                  Var Handle       : TXMBHandle ) : TXMSError;

Function  VXMBDispose(                Handle       : TXMBHandle ) : TXMSError;

Function  VXMBMove(                   MoveData     : PXMSMoveData) : TXMSError;

Function  VXMBMoveBlock(              Count        : LONGINT;
                                      Source       : TXMBHandle;
                                      SourceOfs    : TXMSHandleOfs;
                                      Dest         : TXMBHandle;
                                      DestOfs      : TXMSHandleOfs ) : TXMSError;

Function  VXMBMoveMainToXMB(          Count        : WORD;
                                      FromPtr      : POINTER;
                                      ToHandle     : TXMBHandle;
                                      ToOfs        : TXMSHandleOfs ) : TXMSError;

Function  VXMBMoveXMBToMain(          Count        : WORD;
                                      ToPtr        : POINTER;
                                      FromHandle   : TXMBHandle;
                                      FromHandleOfs: TXMSHandleOfs ) : TXMSError;

Function  VXMBLock(                   Handle       : TXMBHandle ) : TXMSError;

Function  VXMBUnLock(                 Handle       : TXMBHandle ) : TXMSError;

Function  VXMBGetInfo(                Handle       : TXMBHandle;
                                  Var LockCount    : BYTE;
                                  Var FreeHandles  : BYTE;
                                  Var SizeInK      : WORD       ) : TXMSError;

Function  VXMBResize(                 NewSizeK     : WORD;
                                      Handle       : TXMBHandle ) : TXMSError;

Function  VUMBNew(                    SizeInPara   : WORD;
                                  Var SegOfUMB     : WORD;
                                  Var SizeAlloc    : WORD;
                                  Var MaxAvail     : WORD       ) : TXMSError;

Function  VUMBDispose(                SegOfUMB     : WORD       ) : TXMSError;


{}

{---------}
{ XMS 3.0 }
{---------}

Function  VUMBResize(                 SegOfUMB     : WORD;
                                      NewSize      : WORD       ) : TXMSError;

Function  VXMSQueryFreeXM(        Var MaxBlock     : LONGINT;
                                  Var HighByte     : LONGINT;
                                  Var TotalK       : LONGINT    ) : TXMSError;

Function  VXMSNew(                    SizeInK      : LONGINT;
                                  Var Handle       : TXMBHandle ) : TXMSError;

Function  VXMSGetInfo(                Handle       : TXMBHandle;
                                  Var LockCount    : BYTE;
                                  Var FreeHandles  : WORD;
                                  Var SizeInK      : LONGINT    ) : TXMSError;

Function  VXMSReSize(                 Handle       : TXMBHandle;
                                      NewSizeK     : LONGINT    ) : TXMSError;

{}

Implementation

Var

  XMSAddr : POINTER;

{}

(*-

[FUNCTION]

Function VXMSErrorToStr(                   Status    : BYTE       ) : STRING;

[PARAMETERS]

Status      XMS status code

[RETURNS]

XMS text error message.

[DESCRIPTION]

Takes the XMS error code value and converts it into a text message.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMSErrorToStr(                   Status    : BYTE       ) : STRING;

Var

  S : STRING;

BEGIN

  S := '';

  Case Status Of

    $80 : S := 'Function not implemented';
    $81 : S := 'VDISK device detected';
    $82 : S := 'A20 error occured';
    $8E : S := 'General driver error';
    $8F : S := 'Unrecoverable driver error';
    $90 : S := 'HMA does not exist';
    $91 : S := 'HMA is already in use';
    $92 : S := 'Size is smaller than /HMAMIN= parameter';
    $93 : S := 'HMA is not allocated';
    $94 : S := 'A20 line still enabled';
    $A0 : S := 'All extended memory is allocated';
    $A1 : S := 'All available handles are allocated';
    $A2 : S := 'Invalid handle';
    $A3 : S := 'Invalid source handle';
    $A4 : S := 'Invalid source offset';
    $A5 : S := 'Invalid destination handle';
    $A6 : S := 'Invalid destination offset';
    $A7 : S := 'Invalid length';
    $A8 : S := 'Move has an invalid overlap';
    $A9 : S := 'Parity error occurred';
    $AA : S := 'Block is not locked';
    $AB : S := 'Block is locked';
    $AC : S := 'Block lock count overflowed';
    $AD : S := 'Lock failure';
    $B0 : S := 'Only a smaller UMB is available';
    $B1 : S := 'No UMB is available';
    $B2 : S := 'Invalid UMB segment number';

  End;

  VXMSErrorToStr := S;

END;

{}

(*-

[FUNCTION]

Function VXMSInstalled                               : BOOLEAN;

[PARAMETERS]

(None)

[RETURNS]

Availability of XMS services.

[DESCRIPTION]

Determines whether extended memory services (XMS) are available.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMSInstalled                               : BOOLEAN;

Assembler;
ASM

  MOV  AX, $4300

  INT  $2F                   { Multiplexer Interrupt Identification }

  CMP  AL, $80
  JNE  @@1

  MOV  AL, 1                 { XMS Installed = TRUE }
  JMP  @@2

 @@1:
  XOR  AL, AL                { XMS Installed = FALSE }

 @@2:

END;

{}

(*-

[FUNCTION]

Procedure VXMSGetHandleAddr;

[PARAMETERS]

(None)

[RETURNS]

(None)

[DESCRIPTION]

This function gets the extended memory services address handle for future
XMS function calls.

[SEE-ALSO]

[EXAMPLE]

-*)

Procedure VXMSGetHandleAddr;

Assembler;
ASM

  MOV  AX, $4310

  INT  $2F

  {-----------------------------}
  { ES:BX -> driver entry point }
  {-----------------------------}

  MOV  word PTR [XMSAddr + 2], ES  {XMS Addr Seg}
  MOV  word PTR [XMSAddr], BX      {XMS Addr Ofs}

END;

{}

(*-

[FUNCTION]

Function VXMSGetVersion                              : WORD;

[PARAMETERS]

(None)

[RETURNS]

The XMS version number.

[DESCRIPTION]

Returns the extended memory services (XMS) version number.  The high-byte
being the major version number, and the low-byte being the minor version
number.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMSGetVersion                              : WORD;

Assembler;
ASM

  XOR  AH, AH
  CALL [XMSAddr]

END;

{}

(*-

[FUNCTION]

Function VXMMGetVersion                              : WORD;

[PARAMETERS]

(None)

[RETURNS]

The XMM version number.

[DESCRIPTION]

Returns the extended memory manager (XMM) version number.  The high-byte
being the major version number, and the low-byte being the minor version
number.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMMGetVersion                              : WORD;

Assembler;
ASM

  XOR  AH, AH
  CALL [XMSAddr]
  MOV  AX, BX

END;

{}

(*-

[FUNCTION]

Function VHMAPresent                                 : BOOLEAN;

[PARAMETERS]

(None)

[RETURNS]

Availability of HMA support.

[DESCRIPTION]

Determines whether high memory address (HMA) support is available.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VHMAPresent                                 : BOOLEAN;

Assembler;
ASM

  XOR  AH, AH
  CALL [XMSAddr]
  MOV  AL, DL

END;

{}

(*-

[FUNCTION]

Function VHMANew                                     : TXMSError;

[PARAMETERS]

(None)

[RETURNS]

HMA Error Code (0=Success)

[DESCRIPTION]

This function allocates memory in the high memory area (HMA).

This is a use only for non-TSR programs.  A TSR cannot use this routine
to allocate HMA memory.  It should use the VHMANewTSR Routine.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VHMANew                                     : TXMSError;

Assembler;
ASM

  MOV  AH, 1
  MOV  DX, $FFFF             {Non-TSR Applications Only}
  CALL [XMSAddr]

  CMP  AL, 0
  JNE  @@1

  MOV  AL, BL                {TXMSError = Error}
  JMP  @@2

 @@1:
  XOR  AL, AL                {TXMSError = No Error}

 @@2:

END;

{}

(*-

[FUNCTION]

Function VHMANewTSR(                       HMABytes  : WORD       ) : TXMSError;

[PARAMETERS]

HMABytes    Number of bytes in HMA to allocate

[RETURNS]

HMA Error Code (0=Success)

[DESCRIPTION]

This is a special routine just for TSRs.  A TSR cannot use the normal HMA
allocation functions, and neither should a normal program use this routine.

This function allocates memory in the high memory area (HMA).

[SEE-ALSO]

[EXAMPLE]

-*)

Function VHMANewTSR(                       HMABytes  : WORD       ) : TXMSError;

Assembler;
ASM

  MOV  AH, 1
  MOV  DX, HMABytes      {Bytes needed by driver or operating system}
  CALL [XMSAddr]

  CMP  AL, 1
  JE   @SUCCESS

  MOV  AL, BL            { TXMSError = Error }
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL            { TXMSError = No Error }

 @EXIT:

END;

{}

(*-

[FUNCTION]

Function VHMADispose                                 : TXMSError;

[PARAMETERS]

(None)

[RETURNS]

HMA Error Code (0=Success)

[DESCRIPTION]

Frees memory associate with the high memory area.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VHMADispose                                 : TXMSError;

Assembler;
ASM

  MOV  AH, 2
  CALL [XMSAddr]

  CMP  AL, 1
  JE   @SUCCESS

  MOV  AL, BL            { TXMSError = Error }
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL            { TXMSError = No Error }

 @EXIT:

END;

{}

(*-

[FUNCTION]

Function VA20GlobalEnable                            : TXMSError;

[PARAMETERS]

(None)

[RETURNS]

Whether the Global A20 memory line is enabled.

[DESCRIPTION]

Determines and reports whether the Global A20 memory line is enabled.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VA20GlobalEnable                            : TXMSError;

Assembler;
ASM

  MOV  AH, 3
  CALL [XMSAddr]

  CMP  AL, 1
  JE   @SUCCESS

  MOV  AL, BL            { TXMSError = Error }
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL            { TXMSError = No Error }

 @EXIT:

END;

{}

(*-

[FUNCTION]

Function VA20GlobalDisable                           : TXMSError;

[PARAMETERS]

(None)

[RETURNS]

Whether the Global A20 memory line is disabled.

[DESCRIPTION]

Determines and reports whether the Global A20 memory line is disabled.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VA20GlobalDisable                           : TXMSError;

Assembler;
ASM

  MOV  AH, 4
  CALL [XMSAddr]

  CMP  AL, 1
  JE   @SUCCESS

  MOV  AL, BL            { TXMSError = Error }
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL            { TXMSError = No Error }

 @EXIT:

END;

{}

(*-

[FUNCTION]

Function VA20LocalEnable                             : TXMSError;

[PARAMETERS]

(None)

[RETURNS]

Whether the Local A20 memory line is enabled.

[DESCRIPTION]

Determines and reports whether the Local A20 memory line is enabled.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VA20LocalEnable                             : TXMSError;

Assembler;
ASM

  MOV  AH, 5
  CALL [XMSAddr]

  CMP  AL, 1
  JE   @SUCCESS

  MOV  AL, BL            { TXMSError = Error }
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL            { TXMSError = No Error }

 @EXIT:

END;

{}

(*-

[FUNCTION]

Function VA20LocalDisable                            : TXMSError;

[PARAMETERS]

(None)

[RETURNS]

Whether the Local A20 memory line is disabled.

[DESCRIPTION]

Determines and reports whether the Local A20 memory line is disabled.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VA20LocalDisable                            : TXMSError;

Assembler;
ASM

  MOV  AH, 6
  CALL [XMSAddr]

  CMP  AL, 1
  JE   @SUCCESS

  MOV  AL, BL            { TXMSError = Error }
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL            { TXMSError = No Error }

 @EXIT:

END;

{}

(*-

[FUNCTION]

Function VA20Query                                   : TXMSError;

[PARAMETERS]

(None)

[RETURNS]

Whether the A20 memory line query is enabled.

[DESCRIPTION]

Determines and reports whether the A20 memory line query is enabled.
Note that a query action is only true if function returns no error -
this assumes line disabled if error.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VA20Query                                   : TXMSError;

Assembler;
ASM

  MOV  AH, 7
  CALL [XMSAddr]

  CMP  AL, 1
  JE   @SUCCESS

  MOV  AL, BL            { TXMSError = Disabled/Error   }
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL            { TXMSError = Enabled/No Error }

 @EXIT:

END;

{}

(*-

[FUNCTION]

Function VXMSGetFreeStat(          Var MaxBlock      : WORD;
                                   Var TotalK        : WORD       ) : TXMSError;

[PARAMETERS]

MaxBlock    VAR Returned Largest Available XMS Block
TotalK      VAR Returned Total XMS Size in KiloBytes

[RETURNS]

Function : XMS Error Code (0=Success)
(VAR     : [MaxBlock] Largest Available XMS Block)
(VAR     : [TotalK] Total XMS Size in KiloBytes)

[DESCRIPTION]

Returns both the Largest Available Extended Memory Service (XMS) Block
but also the Total Size of the XMS in KiloBytes.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMSGetFreeStat(          Var MaxBlock      : WORD;
                                   Var TotalK        : WORD       ) : TXMSError;

Assembler;
ASM

  PUSH DS

  MOV  AH, 8
  CALL [XMSAddr]

  MOV  DS, word PTR [MaxBlock+2]
  MOV  SI, word PTR [MaxBlock  ]

  MOV  ES, word PTR [TotalK+2]
  MOV  DI, word PTR [TotalK  ]

  MOV  word PTR DS:SI, AX    {MaxBlock}
  MOV  word PTR ES:DI, DX    {TotalK}

  MOV  AL, BL                {TXMSError}

  CMP  AL, 0
  JE   @@1

  MOV  word PTR DS:SI, 0     {Error, MaxBlock = 0}

 @@1:

  POP  DS

END;

{}

(*-

[FUNCTION]

Function VXMSGetMaxBlock                             : WORD;

[PARAMETERS]

(None)

[RETURNS]

Largest XMS Block Available

[DESCRIPTION]

Returns the Largest Available Extended Memory Service (XMS) Block.
Value is in KiloBytes.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMSGetMaxBlock                             : WORD;

Assembler;
ASM

  MOV  AH, 8
  CALL [XMSAddr]
                             {XMS Max Block [AX]}
END;

{}

(*-

[FUNCTION]

Function VXMSGetTotalFreeK                           : WORD;

[PARAMETERS]

(None)

[RETURNS]

Total Free K of XMS Memory

[DESCRIPTION]

Returns the Total Number of Free KiloBytes of Extended Memory Service (XMS)
Memory.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMSGetTotalFreeK                           : WORD;

Assembler;

ASM

  MOV  AH, 8
  CALL [XMSAddr]

  CMP  AX, 0
  JNE  @@1

  XOR  AX, AX                {Error, TotalFreeK = 0}

 @@1:
  MOV  AX, DX                {No Error, XMS Total Free K}

 @@2:

END;

{}

(*-

[FUNCTION]

Function VXMBNew(                      SizeInK       : WORD;
                                   Var Handle        : TXMBHandle ) : TXMSError;

[PARAMETERS]

SizeInK     Desired XMB Memory Allocation in KiloBytes
Handle      VAR Returned XMB Memory Handle

[RETURNS]

Function : XMB Error Code (0=Success)
(VAR     : [Handle] XMB Memory Handle)

[DESCRIPTION]

Allocates memory to an XMB Memory Handle

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMBNew(                      SizeInK       : WORD;
                                   Var Handle        : TXMBHandle ) : TXMSError;

Assembler;
ASM

  PUSH DS

  MOV  AH, 9
  MOV  DX, SizeInK
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL
  MOV  DS, word PTR [Handle + 2]
  MOV  SI, word PTR [Handle]
  MOV  word PTR DS:SI, DX

 @EXIT:

  POP  DS

END;

{}

(*-

[FUNCTION]

Function VXMBDispose(                  Handle        : TXMBHandle ) : TXMSError;

[PARAMETERS]

Handle      Handle to XMB Memory

[RETURNS]

XMB Error Code (0=Success)

[DESCRIPTION]

Frees memory associated with a previous allocated XMB Handle.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMBDispose(                  Handle        : TXMBHandle ) : TXMSError;

Assembler;
ASM

  MOV  AH, $0A
  MOV  DX, Handle
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL

 @EXIT:

END;

{}

(*-

[FUNCTION]

Function VXMBMove(                     MoveData      : PXMSMoveData) : TXMSError;

[PARAMETERS]

MoveData    Pointer to XMB Move Data Structure

[RETURNS]

XMB Error Code (0=Succes)

[DESCRIPTION]

Takes the XMB Move Data Structure and Moves the Data Accordingly.

Use XMBMoveBlock to Load the XMB Move Data Structure.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMBMove(                     MoveData      : PXMSMoveData) : TXMSError;

Assembler;
ASM

  PUSH DS
  POP  ES

  MOV  AX, word PTR[MoveData+2 ]
  MOV  DS, AX
  MOV  SI, word PTR[MoveData   ]
  MOV  AH, $0B
  CALL [ES:XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL

 @EXIT:

  PUSH ES
  POP  DS

END;

{}

(*-

[FUNCTION]

Function VXMBMoveBlock(                Count         : LONGINT;
                                       Source        : TXMBHandle;
                                       SourceOfs     : TXMSHandleOfs;
                                       Dest          : TXMBHandle;
                                       DestOfs       : TXMSHandleOfs ) : TXMSError;

[PARAMETERS]

Count       Number of Bytes to Move
Source      Source Address/Handle of Move Data
SourceOfs   Source Address/Handle Offset of Move Data
Dest        Destination Address/Handle of Move Data
DestOfs     Destination Address/Handle Offset of Move Data

[RETURNS]

XMB Error Code (0=Success)

[DESCRIPTION]

Moves a Block of Memory from the Source Address/XMB Handle to the
Destination Address/XMB Handle.  It is NOT Intended as a means of
Moving Main Memory Data to Main Memory but rather a means of moving
Data to/from XMB Memory.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMBMoveBlock(                Count         : LONGINT;
                                       Source        : TXMBHandle;
                                       SourceOfs     : TXMSHandleOfs;
                                       Dest          : TXMBHandle;
                                       DestOfs       : TXMSHandleOfs ) : TXMSError;

Var

  Struct : TXMSMoveData;

BEGIN

  Struct.Count     := Count;
  Struct.Source    := Source;
  Struct.SourceOfs := SourceOfs;
  Struct.Dest      := Dest;
  Struct.DestOfs   := DestOfs;

  VXMBMoveBlock := VXMBMove( @Struct );

END;

{}

(*-

[FUNCTION]

Function VXMBMoveMainToXMB(            Count         : WORD;
                                       FromPtr       : POINTER;
                                       ToHandle      : TXMBHandle;
                                       ToOfs         : TXMSHandleOfs ) : TXMSError;

[PARAMETERS]

Count       Number of Bytes to Move To XMB
FromPtr     Pointer to Source of Moving Data
ToHandle    Destination XMB Handle
ToHandleOfs Destination XMB Offset

[RETURNS]

XMB Error Code (0=Success)

[DESCRIPTION]

Moves a Block of Data from Main Memory (below 640K) to XMB Memory.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMBMoveMainToXMB(            Count         : WORD;
                                       FromPtr       : POINTER;
                                       ToHandle      : TXMBHandle;
                                       ToOfs         : TXMSHandleOfs ) : TXMSError;
BEGIN

  VXMBMoveMainToXMB := VXMBMoveBlock( Count,
                                      0,
                                      LONGINT( FromPtr ),
                                      ToHandle,
                                      ToOfs     );
END;

{}

(*-

[FUNCTION]

Function VXMBMoveXMBToMain(            Count         : WORD;
                                       ToPtr         : POINTER;
                                       FromHandle    : TXMBHandle;
                                       FromHandleOfs : TXMSHandleOfs ) : TXMSError;

[PARAMETERS]

Count         Number of Bytes to Move From XMB
ToPtr         Pointer to Destination of Moved XMB Data
FromHandle    Source XMB Handle
FromHandleOfs Source XMB Handle Offset

[RETURNS]

XMB Error Code

[DESCRIPTION]

Moves a Block of Data from XMB Memory to Main Memory (below 640K).

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMBMoveXMBToMain(            Count         : WORD;
                                       ToPtr         : POINTER;
                                       FromHandle    : TXMBHandle;
                                       FromHandleOfs : TXMSHandleOfs ) : TXMSError;

BEGIN

  VXMBMoveXMBToMain := VXMBMoveBlock( Count,
                                      FromHandle,
                                      FromHandleOfs,
                                      0,
                                      LONGINT( ToPtr ) );
END;

{}

(*-

[FUNCTION]

Function VXMBLock(                     Handle        : TXMBHandle ) : TXMSError;

[PARAMETERS]

Handle      XMB Handle to Lock

[RETURNS]

XMB Error Code (0=Success)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMBLock(                     Handle        : TXMBHandle ) : TXMSError;

Assembler;
ASM

  MOV  AH, $0C
  MOV  DX, Handle
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL
{ DX = High word of 32-bit linear address of locked block }
{ BX = Low word of 32-bit linear address of locked block }

 @EXIT:

END;

{}

(*-

[FUNCTION]

Function VXMBUnLock(                   Handle        : TXMBHandle ) : TXMSError;

[PARAMETERS]

Handle      XMB Handle to UnLock

[RETURNS]

XMB Error Code (0=Success)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMBUnLock(                   Handle        : TXMBHandle ) : TXMSError;

Assembler;
ASM

  MOV  AH, $0D
  MOV  DX, Handle
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL

 @EXIT:

END;

{}

(*-

[FUNCTION]

Function VXMBGetInfo(                  Handle        : TXMBHandle;
                                   Var LockCount     : BYTE;
                                   Var FreeHandles   : BYTE;
                                   Var SizeInK       : WORD       ) : TXMSError;

[PARAMETERS]

Handle      XMB Handle
LockCount   VAR Returned Number of XMB Locks
FreeHandles VAR Returned Number of Free XMB Handles
SizeInK     VAR Returned XMB Handle Memory Allocation

[RETURNS]

Function : XMB Error Code
(VAR     : [LockCount] Number of XMB Locks)
(VAR     : [FreeHandles] Number of Free XMB Handles)
(VAR     : [SizeInK] XMB Handle Memory Allocation)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMBGetInfo(                  Handle        : TXMBHandle;
                                   Var LockCount     : BYTE;
                                   Var FreeHandles   : BYTE;
                                   Var SizeInK       : WORD       ) : TXMSError;

Assembler;
ASM

  PUSH DS

  MOV  AH, $0E
  MOV  DX, Handle
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL
  MOV  DS, word PTR [LockCount+2]
  MOV  SI, word PTR [LockCount  ]
  MOV  ES, word PTR [FreeHandles+2]
  MOV  DI, word PTR [FreeHandles  ]
  MOV  byte PTR DS:SI, BH    {LockCount}
  MOV  byte PTR ES:DI, BL    {FreeHandles}

  MOV  DS, word PTR [SizeInK+2]
  MOV  SI, word PTR [SizeInK  ]
  MOV  word PTR DS:SI, DX    {SizeInK}

 @EXIT:

  POP  DS

END;

{}

(*-

[FUNCTION]

Function VXMBReSize(                   NewSizeK      : WORD;
                                       Handle        : TXMBHandle ) : TXMSError;

[PARAMETERS]

NewSizeK    New XMB Allocation for XMB Handle
Handle      Pre-Allocated Handle to XMB Memory

[RETURNS]

XMB Error Code (0=Success)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function VXMBReSize(                   NewSizeK      : WORD;
                                       Handle        : TXMBHandle ) : TXMSError;

Assembler;
ASM

  MOV  AH, $0F
  MOV  BX, NewSizeK
  MOV  DX, Handle
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL

 @EXIT:

END;

{}

(*-

[FUNCTION]

Function VUMBNew(                      SizeInPara    : WORD;
                                   Var SegOfUMB      : WORD;
                                   Var SizeAlloc     : WORD;
                                   Var MaxAvail      : WORD       ) : TXMSError;

[PARAMETERS]

SizeInPara  Size of Desired UMB Allocation in Paragraphs
SegOfUMB    VAR Returned Segment of UMB
SizeAlloc   VAR Returned Size Allocation
MaxAvail    VAR Returned Maximum UMB Space Available

[RETURNS]

Function : UMB Error Code (0=Success)
(VAR     : [SegOfUMB] Segment of UMB)
(VAR     : [SizeAlloc] Size Allocation)
(VAR     : [MaxAvail] Maximum UMB Space Available)

[DESCRIPTION]

Allocates an Upper Memory Block (UMB) of a Specified Number of Paragraphs.
And Returns the Memory Allocation Information or an Error Code.  Note that
MaxAvail is valid only if allocation error - if no error, it will be set
to $FFFF.

[SEE-ALSO]

[EXAMPLE]

-*)

Function VUMBNew(                      SizeInPara    : WORD;
                                   Var SegOfUMB      : WORD;
                                   Var SizeAlloc     : WORD;
                                   Var MaxAvail      : WORD       ) : TXMSError;

Assembler;
ASM

  PUSH DS

  MOV  AH, $10
  MOV  DX, SizeInPara
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  MOV  DS, word PTR [MaxAvail+2]
  MOV  SI, word PTR [MaxAvail  ]
  MOV  word PTR DS:SI, DX    {MaxAvail}
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL
  MOV  DS, word PTR [SegOfUMB+2]
  MOV  SI, word PTR [SegOfUMB  ]
  MOV  ES, word PTR [SizeAlloc+2]
  MOV  DI, word PTR [SizeAlloc  ]
  MOV  word PTR [DS:SI], BX  {SegOfUMB}
  MOV  word PTR [ES:DI], DX  {SizeAlloc}

 @EXIT:

  POP  DS

END;

{}

(*-

[FUNCTION]

Function VUMBDispose(                  SegOfUMB      : WORD       ) : TXMSError;

[PARAMETERS]

SegOfUMB    Segment Address of UMB

[RETURNS]

UMB Error Code (0=Success)

[DESCRIPTION]

[SEE-ALSO]

[EXAMPLE]

-*)

Function VUMBDispose(                  SegOfUMB      : WORD       ) : TXMSError;

Assembler;
ASM

  MOV  AH, $11
  MOV  DX, SegOfUMB
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL

 @EXIT:

END;

{}

Function VUMBResize(                   SegOfUMB      : WORD;
                                       NewSize       : WORD       ) : TXMSError;

Assembler;
ASM

  MOV  AH, $12
  MOV  DX, SegOfUMB
  MOV  BX, NewSize
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL

 @EXIT:

END;

{}

Function VXMSQueryFreeXM(          Var MaxBlock      : LONGINT;
                                   Var HighByte      : LONGINT;
                                   Var TotalK        : LONGINT    ) : TXMSError;

Assembler;
ASM

  MOV  AH, $88
  CALL [XMSAddr]

  MOV  AL, BL

END;

{}

Function VXMSNew(                      SizeInK       : LONGINT;
                                   Var Handle        : TXMBHandle ) : TXMSError;

Assembler;
ASM

  MOV  AH, $89
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL

 @EXIT:

END;

{}

Function VXMSGetInfo(                  Handle        : TXMBHandle;
                                   Var LockCount     : BYTE;
                                   Var FreeHandles   : WORD;
                                   Var SizeInK       : LONGINT    ) : TXMSError;

Assembler;
ASM

  MOV  AH, $8E
  MOV  DX, Handle
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL

 @EXIT:

END;

{}

Function VXMSResize(                  Handle         : TXMBHandle;
                                      NewSizeK       : LONGINT    ) : TXMSError;

Assembler;
ASM

  MOV  AH, $8F
  MOV  DX, Handle
{ MOV  EBX, NewSizeK }
  CALL [XMSAddr]

  CMP  AX, 1
  JE   @SUCCESS

  MOV  AL, BL
  JMP  @EXIT

 @SUCCESS:

  XOR  AL, AL

 @EXIT:

END;

{}
{}
{}

BEGIN

  If VXMSInstalled Then
    VXMSGetHandleAddr
  Else
    XMSAddr := NIL;

END.
