Program TCOPY;  { Test program for VCOPY }

Uses

  CRT,
  Dos,
  VCopy,
  VGen;

Var

  Err      : Integer;  { error code }
  PathFrom : PathStr;
  PathTo   : PathStr;
  Params   : STRING;

{}

Procedure CheckScrolling;

Const

  PauseStr = 'Press any key to continue ...';

Var

  Ch       : CHAR;
  L1       : BYTE;

BEGIN

  If (LastMode DIV Font8x8 = 0) Then
  BEGIN

    Write(PauseStr);
    Ch := ReadKey;
    For L1 := 1 to Length(PauseStr) Do
      Write(#8+#32+#8);

  END;

END;

{}
{}
{}

BEGIN

  {--------------------------}
  { Redirect to standard I/O }
  {--------------------------}

  Assign(Input, '');
  Reset(Input);
  Assign(Output, '');
  ReWrite(Output);

  {--------------------------}
  { Get paths and parameters }
  {--------------------------}

  PathFrom := ParamStr(1);
  PathTo   := ParamStr(2);
  Params   := ParamStr(3);

  If (PathFrom = '') OR (PathTo = '') Then
  BEGIN

    WriteLn('TCOPY 1.0 - test program for the Visionix VCOPY unit.                       ');
    WriteLn('                                                                             ');
    WriteLn(' Usage : [@][d:][path]sourcename [d:][path]targetname [param1,param2...]     ');
    WriteLn(' Parameters (comma delimited, no spaces) :                                   ');
    WriteLn('   ');
    WriteLn('  MOVE             Move instead of copy.                                     ');
    WriteLn('  NOOVERWRITE      Do not overwrite duplicate target file.                   ');
    WriteLn('  SUBDIR           Copy subdirectories                                       ');
    WriteLn('  SHOW=FADTPS      Show each file''s general info:                           ');
    WriteLn('                     Filename, Attributes, Date, Time, Packed-date, or Size. ');
    WriteLn('  ATTR=ASHR        Search mask for source attributes types:                  ');
    WriteLn('                     Archive, System, Hidden, and Readonly.                  ');
    WriteLn('  EXACTATTR        Each found source file needs to be exactly the above      ');
    WriteLn('                     attribute mask in order to be copied.                   ');
    WriteLn('  NEWER            Copy only if target doesn''t exist or source is newer     ');
    WriteLn('  SHARE            Use file-sharing/locking for copy                         ');
    WriteLn('  TIMEOUT=SSS      Timeout for events (like SHARE).  Default = 30 seconds    ');
    WriteLn('  APPEND           Append source file(s) to a single target file             ');
    WriteLn('  DATE=MM-DD-YY    Copy file(s) ON this date                                 ');
    WriteLn('  DATEB=MM-DD-YY   Copy file(s) BEFORE this date                             ');
    WriteLn('  DATEA=MM-DD-YY   Copy file(s) AFTER this date                              ');
    WriteLn('  DATEOB=MM-DD-YY  Copy file(s) ON or BEFORE this date                       ');
    WriteLn('  DATEOA=MM-DD-YY  Copy file(s) ON or AFTER this date                        ');
    WriteLn('  TIME=HH:MM       Copy file(s) AT this time                                 ');

    CheckScrolling;

    WriteLn('  TIMEB=HH:MM      Copy file(s) BEFORE this time                             ');
    WriteLn('  TIMEA=HH:MM      Copy file(s) AFTER this time                              ');
    WriteLn('  TIMEOB=HH:MM     Copy file(s) AT or BEFORE this time                       ');
    WriteLn('  TIMEOA=HH:MM     Copy file(s) AT or AFTER this time                        ');
    WriteLn('  MAKETARGETDIR    Create the target directory if it does not exist.         ');
    WriteLn('                     Otherwise, targetname will be thought as the target     ');
    WriteLn('                     filename mask.                                          ');
    WriteLn('  TARGETDIRONLY    Do not create target subdirectories to match source       ');
    WriteLn('                     subdirectories; instead, copy all source filespecs      ');
    WriteLn('                     only to the main target directory.                      ');
    WriteLn('  TESTMODE         Do everything as usual except the actual copying.         ');
    WriteLn('                                                                             ');
    WriteLn(' ListFile Usage (for each line):                                             ');
    WriteLn('  [d:][path]sourcename [[d:][path]targetname] [/param1,param2...]            ');
    WriteLn('   ');

    Halt(1);

  END;

  Err := VCopyFile( ParamStr(1),
                    ParamStr(2),
                    ParamStr(3) );

  Halt(Err);

END.

