uses vcrtu, vtypesu, vfontu, vgenu, vstringu;

Const

  FCCBR : Array[0..7] of BYTE =
    ( $00, $00, $FC, $1C, $3C, $74, $E4, $E4 );

Var

  fs16 : tfontset;
  fs8  : tfontset;

  l  : byte;
  ch : char;


{}

Procedure DrawSet( FontSet : TFontSet;
                   Index   : BYTE;
                   Count   : WORD );

Var

  Z1,
  Z2,
  Z4  : INTEGER;
  S   : STRING;

BEGIN

  Dec(Count);

  For Z1 := 0 to Count Do
  BEGIN

    For Z2 := 1 to FontSet.ScanLines Do
    BEGIN

      S[0] := #0;

      For Z4 := Pred(FontSet.Width) downto 0 Do
      BEGIN

        If (TByteArray(FontSet.Table^)[((Index+Z1)*FontSet.ScanLines)+Z2] AND CBitMapW[Z4]) <> 0 Then
          S := S + ''
        Else
          S := S + '';

      END;

      WriteLn(S);

    END;

    WriteLn;

  END;

END;

{}

Procedure TestOne;
BEGIN

  ClrScr;

{------------------------------------------}

  {--------------------}
  { Make 8x16 font set }
  {--------------------}

  TextMode(co80);
  VFontROM8x16Load;
  VFontSetGet( Font_VGA_8x16, fs16 );

{------------------------------------------}

  {-------------------}
  { Make 8x8 font set }
  {-------------------}

  TextMode(co80+font8x8);
  VFontROM8x8Load;
  VFontSetGet( Font_VGA_8x8, fs8 );

{------------------------------------------}

  {--------------------}
  { Make 8x8 font file }
  {--------------------}

  VFontPutText( 'FS8.FNT',
                    0,
                    255,
                    '#',
                    '.',
                    fs8 );

{------------------------------------------}

  {-----------------------------}
  { Scale 8x8 font file to 8x16 }
  {-----------------------------}

  VFontGetText( 'FS8.FNT',
                    0,
                    255,
                    '#',
                    '.',
                    fs8 );
  VFontSetScale( fs8, 70, 80, fs16 );
  VFontPutText( 'FS16.FNT',
                    0,
                    255,
                    '#',
                    '.',
                    fs16 );

{------------------------------------------}

  {------------------------------------}
  { Go 8x16 mode, then upload 8x16 set }
  {------------------------------------}

  TextMode(co80);
  VFontSetPut( fs16 );

(*

{------------------------------------------}

  {---------------------------}
  { Scale ROM 8x16 downto 8x8 }
  {---------------------------}

  VFontSetScale( fs16, 0, 255, fs8 );
  VFontPutTextFile( 'FS1.FNT',
                    0,
                    255,
                    '#',
                    '.',
                    fs8 );

{------------------------------------------}

  {-------------------------}
  { Scale ROM 8x8 upto 8x16 }
  {-------------------------}

  VFontSetScale( fs8, 0, 255, fs16 );
  VFontPutTextFile( 'FS2.FNT',
                    0,
                    255,
                    '#',
                    '.',
                    fs16 );

{------------------------------------------}

*)

  {-------------------}
  { Dispose font sets }
  {-------------------}

  VFontSetDispose( fs16 );
  VFontSetDispose( fs8 );

{------------------------------------------}

END;

{}

{ Scales 8x16 downto 8x8 then same data back to 8x16 }
{ This shows loss of data by scale resolutions. }

Procedure TestTwo;
BEGIN

  {--------------------}
  { Make 8x16 font set }
  {--------------------}

  TextMode(co80);
  VFontROM8x16Load;
  VFontSetGet( Font_VGA_8x16, fs16 );

  {-------------------}
  { Make 8x8 font set }
  {-------------------}

  TextMode(co80+font8x8);
  VFontSetNew( fs8, 8, 8 );

  {-----------------------------------------}
  { Scale 8x16 downto 8x8 then back to 8x16 }
  {-----------------------------------------}

  VFontSetScale( fs16, 0, 255, fs8 );
  VFontSetScale( fs8, 0, 255, fs16 );

  {---------------------------------}
  { Save 8x16 font set to text file }
  {---------------------------------}

(*
  VFontPutTextFile( 'FS16.FNT',
                    0,
                    255,
                    '#',
                    '.',
                    fs16 );
*)

  {------------------------------------}
  { Go 8x16 mode, then upload 8x16 set }
  {------------------------------------}

  TextMode(co80);
  VFontSetPut( fs16 );

  {-------------------}
  { Dispose font sets }
  {-------------------}

  VFontSetDispose( fs16 );
  VFontSetDispose( fs8 );

END;

{}

{ Scales 8x8 up to 8x16 then same data back to 8x8 }
{ This shows NO loss of data by scale resolutions. }

Procedure TestThree;
BEGIN

  {-------------------}
  { Make 8x8 font set }
  {-------------------}

  TextMode(co80+font8x8);
  VFontROM8x8Load;
  VFontPut( 65, 1, 8, @FCCBR );
  VFontSetGet( Font_VGA_8x8, fs8 );

  {--------------------}
  { Make 8x16 font set }
  {--------------------}

  TextMode(co80);
  VFontSetNew( fs16, 8, 16 );

  {--------------------------------------}
  { Scale 8x8 upto 8x16 then back to 8x8 }
  {--------------------------------------}

  VFontSetScale( fs8, 0, 255, fs16 );
  VFontSetScale( fs16, 0, 255, fs8 );

  {--------------------------------}
  { Save 8x8 font set to text file }
  {--------------------------------}

(*
  VFontPutTextFile( 'FS8.FNT',
                    0,
                    255,
                    '#',
                    '.',
                    fs8 );
*)

  {----------------------------------}
  { Go 8x8 mode, then upload 8x8 set }
  {----------------------------------}

  TextMode(co80+font8x8);
  VFontSetPut( fs8 );

  {-------------------}
  { Dispose font sets }
  {-------------------}

  VFontSetDispose( fs16 );
  VFontSetDispose( fs8 );

END;

{}

{-------------------------------------}
{ Read a text file (8x16) into memory }
{-------------------------------------}

Procedure TestFour;

BEGIN

  VFontSetNew( fs16, 8, 16 );
  VFontGetText( 'FS16.FNT',
                    0,
                    255,
                    '#',
                    ' ',
                    fs16 );
  VFontSetPut( fs16 );
  VFontSetDispose( fs16 );

END;

{}

{---------------------------}
{ Make a ROM 8x16 Text File }
{---------------------------}

Procedure TestFive;

BEGIN

  TextMode(co80);
  VFontROM8x16Load;
  VFontSetGet( Font_VGA_8x16, fs16 );
  VFontSetPut( fs16 );
  VFontPutText( 'FS16.FNT',
                    0,
                    255,
                    '#',
                    ' ',
                    fs16 );
  VFontSetPut( fs16 );
  VFontSetDispose( fs16 );

END;

{}

{----------------------------------------------}
{ Make a text file from default 8x16 font mode }
{----------------------------------------------}

Procedure TestSix;

BEGIN

  TextMode(co80);
  VFontSetGet( Font_VGA_8x16, fs16 );
  VFontGetImage( '\BAT\BROADWAY.FNT', fs16 );
  VFontPutText( 'FS16.FNT',
                    0,
                    255,
                    '#',
                    ' ',
                    fs16 );
  VFontSetDispose( fs16 );

END;

{}

{

  Tests alternate map for 512 on screen fonts.  First table is using the
  "fs16" var, and the second table is "fs8".  Then anytime you want to write
  an "alternate" character to the screen, set the high intensity byte:

    TextAttr := TextAttr AND NOT 8;

  Then,

    TextAttr := TextAttr OR 8;

  will return to the original set.  NOTICE: YOU WILL NOT HAVE HIGH INTENSITY
  CHARACTERS!  To reset to original 16 color mode, use the TextMode command.
}

Procedure TestSeven;

Var

  L1 : LONGINT;

BEGIN

  TextMode(co80);

  {---}

  VFontROM8x16Load;
  VFontSetGet( Font_VGA_8x16, fs16 );

  VFontSetGet( Font_VGA_8x16, fs8 );
  VFontGetImage( '\BAT\BROADWAY.FNT', fs8 );

  {---}

  VFontAltSetPut( fs8 );

  {---}

  TextColor(White);
  TextBackground(Black);

  TextAttr := TextAttr AND (NOT 8);

  For L1 := 0 to 255 Do
    Write(Char(L1));

  WriteLn;

  TextAttr := TextAttr OR 8;

  For L1 := 0 to 255 Do
    Write(Char(L1));

  WriteLn;

  {---}

  VFontSetDispose( fs16 );
  VFontSetDispose( fs8 );

END;

{}

{-----------------------------------------------}
{ Read a text file (8x16) into alternate memory }
{-----------------------------------------------}

Procedure TestEight;

BEGIN

  VFontSetNew( fs16, 8, 16 );
  VFontGetImage( '\BAT\BROADWAY.FNT', fs16 );
  VFontAltSetPut( fs16 );
  VFontSetDispose( fs16 );

END;

{}

Procedure TestNine;

Var

  L1 : LONGINT;
  Ch : CHAR;

  fs8b : TFontSet;

BEGIN

  TextMode(co80+font8x8);
  VFontROM8x8Load;

  {---}

  VFontSetNew( fs16, 8, 16 );
  VFontGetImage( '\BAT\COURIER.FNT', fs16 );

  VFontSetGet( Font_VGA_8x8, fs8 );

  VFontSetNew( fs8b, 8, 8 );
  VFontSetScale( fs16, 0, 255, fs8b );

  {---}

  VFontSetPut( fs8 );
  VFontAltSetPut( fs8b );

  {---}

  TextColor(White);
  TextBackground(Black);

  TextAttr := TextAttr AND (NOT 8);

  For L1 := 0 to 255 Do
    Write(Char(L1));

  WriteLn;

  TextAttr := TextAttr OR 8;

  For L1 := 0 to 255 Do
    Write(Char(L1));

  WriteLn;
  {---}

  VFontSetDispose( fs16 );
  VFontSetDispose( fs8 );
  VFontSetDispose( fs8b );

END;

{}

Procedure TestTen;

BEGIN

  TextMode(co80);
  VFontSetNew( fs16, 8, 16 );
  VFontGetText( 'MAIN.FNT',
                0,
                255,
                '#',
                ' ',
                fs16 );
  VFontSetPut( fs16 );

END;

{}
{}

BEGIN

  TestOne;

  TestTwo;

  TestThree;

  TestFour;

  TestFive;


  TestTen;

END.

