uses vcrtu, vtypesu, vfontu, vgenu, vstringu, dos, vdoshu;

Var

  fs16 : tfontset;
  fs8  : tfontset;

  l    : byte;
  ch   : char;

{}

Procedure LoadSet( S : STRING; ScanLines : BYTE );

Var

  fs : TFontSet;

BEGIN

  If NOT FileExist(S) Then
  BEGIN

    WriteLn(S, ' not found.');
    Halt(2);

  END;

  VFontSetNew( fs, 8, ScanLines );
  VFontGetText( S,
                0,
                255,
                '#',
                ' ',
                fs );
  VFontSetPut( fs );
  VFontSetDispose( fs );

END;

{}

Procedure SaveSet( S : STRING; ScanLines : BYTE );

Var

  fs : TFontSet;

BEGIN

  Case ScanLines of

    16 : VFontSetGet( Font_VGA_8x16, fs );
    8  : VFontSetGet( Font_VGA_8x8, fs );

  End;
  VFontPutText( S,
                0,
                255,
                '#',
                ' ',
                fs );
  VFontSetDispose( fs );

END;

{}

Procedure LoadImage( S : STRING );

Var

  fs : TFontSet;

BEGIN

  If NOT FileExist(S) Then
  BEGIN

    WriteLn(S, ' not found.');
    Halt(2);

  END;

  VFontGetNewImage( S, fs );

  VFontSetPut( fs );

  VFontSetDispose( fs );

END;

{}

Procedure SaveImage( S : STRING; ScanLines : BYTE );

Var

  fs : TFontSet;

BEGIN

  Case ScanLines of

    16 : VFontSetGet( Font_VGA_8x16, fs );
    8  : VFontSetGet( Font_VGA_8x8, fs );

  End;

  VFontPutImage( S, fs );

  VFontSetDispose( fs );

END;

{}

Procedure ScaleSet(     fn1    : STRING;
                        SL2str : STRING;
                        fn2    : STRING    );
Var

  SL2 : BYTE;
  fs1 : TFontSet;
  fs2 : TFontSet;

BEGIN

  SL2 := StrToInt(SL2str);

  fs1.Table := NIL;
  fs2.Table := NIL;

  VFontGetText( fn1, 0, 255, '#', ' ', fs1 );

  VFontSetNew( fs2, 8, SL2 );
  VFontSetScale( fs1, 0, 255, fs2 );

  VFontPutText( fn2, 0, 255, '#', ' ', fs2 );

  VFontSetDispose(fs1);
  VFontSetDispose(fs2);

END;

{}

Procedure LoadAltSet( S : STRING; ScanLines : BYTE );

Var

  fs : TFontSet;

BEGIN

  If NOT FileExist(S) Then
  BEGIN

    WriteLn(S, ' not found.');
    Halt(2);

  END;

  VFontSetNew( fs, 8, ScanLines );
  VFontGetText( S,
                0,
                255,
                '#',
                ' ',
                fs );
  VFontAltSetPut( fs );
  VFontSetDispose( fs );

END;

{}

Procedure LoadAltImage( S : STRING );

Var

  fs : TFontSet;

BEGIN

  If NOT FileExist(S) Then
  BEGIN

    WriteLn(S, ' not found.');
    Halt(2);

  END;

  VFontGetNewImage( S, fs );

  VFontAltSetPut( fs );

  VFontSetDispose( fs );

END;

{}

Procedure TextToImage( Source : STRING; Target : STRING );

Var

  fs : TFontSet;

BEGIN

  fs.Table := NIL;

  VFontGetText( Source, 0, 255, '#', ' ', fs );
  VFontPutImage( Target, fs );

  VFontSetDispose( fs );

END;

{}

Procedure ImageToText( Source : STRING; Target : STRING );

Var

  fs : TFontSet;

BEGIN

  VFontGetNewImage( Source, fs );
  VFontPutText( Target, 0, 255, '#', ' ', fs );

  VFontSetDispose( fs );

END;
{}

Procedure Help;
BEGIN

  WriteLn('[ TFONTED 1.0 by Killamac ]');
  WriteLn('Usage: TFONTED [filename] [option(s)]');
  WriteLn('Where: [filename] is your source font file');
  WriteLn('Options:');
  WriteLn('  8x8 = Use 8x8 Font Set (default is 8x16)');
  WriteLn('  LOADTEXT = Load textfile into VGA font set');
  WriteLn('  SAVETEXT = Save current VGA font set in memory to textfile');
  WriteLn('  LOADIMAGE = Load imagefile into VGA font set');
  WriteLn('  SAVEIMAGE = Save imagefile from VGA font set');
  WriteLn('  SCALE [SL] [OutFile] = Scales [filename] into a new scanline set');
  WriteLn('    and saves to a target-file');
  WriteLn('  LOADALTTEXT = Load textfile into VGA alternate font set');
  WriteLn('  LOADALTIMAGE = Load imagefile into VGA alternate font set');
  WriteLn('  TEXTTOIMAGE [OutFile]');
  WriteLn('  IMAGETOTEXT [OutFile]');
  WriteLn;
  WriteLn('Examples:');
  WriteLn('  TFONTED TE.FNT LOADSET (Loads TE.FNT 8x16 font textfile)');
  WriteLn('  TFONTED A.FNT 8x8 SAVESET (Creates A.FNT 8x8 font textfile)');
  WriteLn('  TFONTED A.FNT SCALE 16 B.FNT (Scales the last A.FNT 8x8 font');
  WriteLn('    textfile into the 8x16 font textfile B.FNT)');
  WriteLn('  TFONTED TE.FNT LOADALTSET (Loads TE.FNT into high-intensity foreground)');
  Halt(1);

END;

{}
{}
{}

Var

  fn    : PathStr;
  Param : STRING;
  SL    : BYTE;
  L1    : BYTE;

BEGIN

  If ParamCount < 2 Then
    Help;

  fn := ParamStr(1);

  SL := 16;

  For L1 := 2 to ParamCount Do
  BEGIN

    Param := UpperString(ParamStr(L1));

    If Param = '8X8' Then
      SL := 8
    Else
    If Param = 'SCALE' Then
      ScaleSet( fn, ParamStr(L1+1), ParamStr(L1+2) )
    Else
    If Param = 'LOADTEXT' Then
      LoadSet(fn, SL)
    Else
    If Param = 'SAVETEXT' Then
      SaveSet(fn, SL)
    Else
    If Param = 'LOADIMAGE' Then
      LoadImage(fn)
    Else
    If Param = 'SAVEIMAGE' Then
      SaveImage(fn, SL)
    Else
    If Param = 'LOADALTTEXT' Then
      LoadAltSet(fn, SL)
    Else
    If Param = 'LOADALTIMAGE' Then
      LoadAltImage(fn)
    Else
    If Param = 'TEXTTOIMAGE' Then
      TextToImage( fn, ParamStr(L1+1) )
    Else
    If Param = 'IMAGETOTEXT' Then
      ImageToText( fn, ParamStr(L1+1) );

  END;

END.
