Program TFormnew;

Uses

  VTypesu,
  VInu,
  VGenu,
  VCRTu,
  VStringu,
  vuiwinu,
  vuiwidgu,
  vuiformu;

VAR

   GlobalTest : BOOLEAN;
   F          : ARRAY[0..30] of TFormNode;
   S          : ARRAY[1..4] of ST80;
   M          : TMenu;
   M1         : TMenu50;
   B          : BYTE;
   Start      : BYTE;
   Retcode    : INTEGER;
   HexMode    : BOOLEAN;

{------------------------------------------------------}


Procedure GetFillPattern(     Start       : ST80;
                              X           : BYTE;
                              Y           : BYTE;
                              FC          : BYTE;
                              BC          : BYTE;
                              ReadPattern : BOOLEAN;
                          var HexMode     : BOOLEAN;
                          var Pattern     : STRING  );

Type

  TMyBytes = Array[1..32] of BYTE;
  PMyBytes = ^TMyBytes;

VAR
   Halfway : BOOLEAN;
   BitNum  : BYTE;
   Bytes   : PMyBytes;
   Ch      : CHAR;
   Ch1     : CHAR;
   Loopy   : BYTE;
   Test    : BOOLEAN;
   S       : ST80;
   OldInfo : ST80;
   OldMsg  : ST80;
   Len     : BYTE;

   {==================================}
   Procedure MoveCursor;
   BEGIN

     If ( HexMode ) AND ( Halfway ) Then
       GotoXY( X + 2 + ( BitNum ) * 3, Y )
     Else If HexMode Then
       GotoXY( X + 1 + ( BitNum ) * 3, Y )
     Else GotoXY( X + 51 + Bitnum, Y );

   END;   { Of MoveCursor }
   {==================================}
   Procedure WriteScreen;
   VAR
      Loopy  : BYTE;
      Ch     : CHAR;

   BEGIN
     S := '';

     For Loopy := 1 to 16 Do
       If ( Loopy - 1 = Len ) AND
               ( BitNum = Len ) AND
               ( Halfway ) Then
       BEGIN
         S := S + ' ' + ByteToHex( Bytes^[Loopy] );

         S[Length( S )] := '-'
       END   { Of Then }
       Else If Loopy > Len Then
         S := S + ' --'
       Else
         S := S + ' ' + ByteToHex( Bytes^[Loopy] );

     S := S + '  ';

     For Loopy := 1 to 16 Do
     BEGIN
       Ch := Chr( Bytes^[Loopy] );

       If Ord( Ch ) in [1..254] Then
         S := S + Ch
       Else
         S := S + '.';
     END;   { Of For }

     WFastWrite( X, Y, FC, BC, S );

     MoveCursor;
   END;   { Of WriteScreen }
   {===============================}

BEGIN
  BitNum  := 0;
  Halfway := FALSE;
  OldInfo := '';
  OldMsg  := '';
  Ch      := #255;
  Ch1     := #255;
  Len     := Length( Start );


(*
  For Loopy := 2 to 80 Do
    OldInfo := OldInfo + Vid_Mem^[WinEnv.LastRow - 1, Loopy].Ch;

  For Loopy := 2 to 80 Do
    OldMsg := OldMsg + Vid_Mem^[WinEnv.LastRow, Loopy].Ch;
*)

  OldInfo := '';
  OldMsg  := '';

  GetMem( Bytes, 16 );

  For Loopy := 1 to Length( Start ) Do
    Bytes^[Loopy] := Ord( Start[Loopy] );

  For Loopy := Length( Start ) + 1 to 16 Do
    Bytes^[Loopy] := 0;

  WriteScreen;

  If NOT ReadPattern Then
  BEGIN
    Pattern := Start;

    Freemem( Bytes, 16 );

    Exit;
  END;   { Of Then }

  WInfoMsg( Pad( 'If no pattern is entered, a null string will be returned',
                 79, ONCENTER, ' ' ), BLUE, CYAN );

  WMessage( '<Insert>=Hex/ASCII Toggle|' +
            '<Enter>=Accept  <ESC>=Abort', WHITE, BLUE );

  Repeat
    MoveCursor;

    Ch := WReadKey;

    Case Ord( Ch ) of

      8 :
      BEGIN
        If BitNum = Len Then
        BEGIN
          If Halfway Then
            Bytes^[Len + 1] := 0
          Else If Len <> 0 Then
          BEGIN
            Bytes^[Len] := 0;
            Dec( BitNum );
            Dec( Len );
          END   { Of Then }
        END   { Of Then }
        Else If BitNum = 0 Then
        BEGIN
          Bytes^[Len] := 0;
          Dec( Len );
          BitNum := Len;
        END   { Of Then }
        Else WinEnv.KeyBuff := #0 + #75;

        Halfway := FALSE;

        WriteScreen;
      END;    { Of BackSpace }

      Key_Tab:
      BEGIN

        If HexMode Then
        BEGIN
          HexMode         := FALSE;
          CH              := Chr( 255 );
          WinEnv.EventKey := 255;
        END;

      END;   { Of Tab }


      0 :
      BEGIN

        Ch1 := WReadKey;

        Case Ord( Ch1 ) of


          Key_Left:
          BEGIN
            HalfWay := FALSE;

            If BitNum <> 0 Then
              Dec( BitNum );
          END;   { Of Left }

          Key_Right:
          BEGIN
            Halfway := FALSE;

            If ( BitNum <> 15 ) AND ( BitNum <> Len ) Then
              Inc( BitNum )
            Else If ( BitNum = Len ) AND ( BitNum = 15 ) Then
              BitNum := 0;

          END;   { Of Right }

          Key_Home:
          BEGIN
            Halfway := FALSE;
            BitNum  := 0;
          END;   { Of Home }

          Key_End:
          BEGIN
            Halfway := FALSE;
            BitNum  := Len;

            If BitNum > 15 Then
              BitNum := 15;
          END;   { Of End }

          Key_ShiftTab:
          BEGIN

            If Not HexMode Then
            BEGIN
              HexMode            := TRUE;
              CH1                := Chr( 255 );
              WinEnv.EventKey    := 255;
              WinEnv.EventExtKey := 255;
            END;

          END;   { Of shift-tab }


        END;   { Of Tab }
      END;   { Of Extended Characters }
    END;   { Of Case }

    {---------------------------------------------}
    { This next If/Then/Else statement is written }
    { because I have yet to figure out how to do  }
    { a damned 'NOT in' statement.                }
    {---------------------------------------------}

    If ( NOT HexMode ) AND ( Ch in [#8,#9,#13,#27,#0] ) Then
    Else If HexMode Then
    Case Upcase( Ch ) of
      '0'..'9',
      'A'..'F' :
      BEGIN
        If Halfway = FALSE Then
        BEGIN
          If Ch in ['0'..'9'] Then
            Loopy := Ord( Ch ) - 48
          Else
            Loopy := Ord( Upcase( Ch ) ) - 55;

          Bytes^[Bitnum + 1] :=
                ( Bytes^[Bitnum + 1] MOD 16 ) + ( Loopy * 16 );

          Halfway := TRUE;

          WriteScreen;
        END   { Of Then }
        Else
        BEGIN
          If Ch in ['0'..'9'] Then
            Loopy := Ord( Ch ) - 48
          Else
            Loopy := Ord( Upcase( Ch ) ) - 55;

          Bytes^[Bitnum + 1] :=
                ( ( Bytes^[Bitnum + 1] DIV 16 ) * 16 ) + Loopy;

          If BitNum = Len Then
            Inc( Len );

          If BitNum <> 15 Then
            Inc( BitNum )
          Else
            BitNum := 0;

          Halfway := FALSE;
          WriteScreen;
        END;   { Of Else }

        MoveCursor;
      END;   { Of Normal characters }
    END   { Of Case }
    Else If Ch <> #27 Then
    BEGIN

      If Ch<>#255 Then
      BEGIN

        If (Ch=#8) and (Len>0) Then
          Dec( Len )
        Else
        BEGIN

          Bytes^[Bitnum + 1] := Ord( Ch );

          If BitNum = Len Then
            Inc( Len );

          If BitNum <> 15 Then
            Inc( BitNum )
          Else
            BitNum := 0;

        END;

        WriteScreen;

      END; { if ch<>255 }
    END;   { Of Else }

    WFlushKeyBuf;
  Until ( Ch = #27 ) OR
        ( Ch = #13 ) OR
        ( ( WinEnv.Events ) AND
          ( ( Ord( Ch1 ) in [ {Key_Up,Key_Down,}
                             Key_PgUp,Key_PgDn,
                             Key_F2..Key_F10,
                             Key_ShiftTab] ) OR
            ( Ch = #9 ) ) );

  If ( Ch = #0 ) Then
  BEGIN
    WinEnv.EventKey    := 0;
    WinEnv.EventExtKey := Ord( Ch1 );
  END   { Of Then }
  Else
  BEGIN
    WinEnv.EventKey    := Ord( CH );
    WinEnv.EventExtKey := 0;
  END;   { Of Else }

  S    := '';
  Test := FALSE;

  If Ch = #27 Then
    S := #27
  Else
    For Loopy := 1 to Len Do
      S := S + Chr( Bytes^[Loopy] );

  Freemem( Bytes, 16 );

  WInfoMsg( OldInfo, BLUE,  CYAN );
  WMessage( OldMsg,  WHITE, BLUE );

  Pattern := S;
END;   { Of GetFillPattern }




Procedure GrabPattern(            Msg    : LONGINT;
                                  FMA    : POINTER;
                                  Node   : BYTE          ); Far;

Var
   Test : BOOLEAN;
   FC   : BYTE;
   BC   : BYTE;
   Temp : STRING;

   FM   : PForm;

BEGIN


  FM := FMA;

  Test := (msg = fnpmRead );

  If Test Then
  BEGIN
    FC := WHITE;
    BC := WHITE;

    WCursorBIG;
  END   { Of Then }
  Else
  BEGIN
    FC := WHITE;
    BC := BLUE;
  END;   { Of Else }

  GetFillPattern( FM^[Node].Proc.S,
                  FM^[Node].X,
                  FM^[Node].Y,
                  FC, BC, Test, HexMode, Temp );

  If Temp <> #27 Then
    FM^[Node].Proc.S := Temp;

  WCursorOFF;
END;   { Of GrabPattern }


{------------------------------------------------------}



Function GetSearchItems : BOOLEAN;
VAR
   Z1     : BYTE;
   Z2     : BYTE;
   FC1    : BYTE;
   FC2    : BYTE;
   Master : BYTE;

   FP     : PFormMax;

BEGIN


  WNew( 3, 4, 77, 20, WHITE, BLUE, WHITE, WHITE, 'Search For Data' );

  {----------------------------------------}
  { Setup associated variables and records }
  {----------------------------------------}

  M1[1]   := 'Jons Partition            ';
  M1[2]   := 'Bills Partition           ';
  M1[3]   := 'Steves Partition          ';
  M1[4]   := 'No Paritition             ';
  M1[5]   := 'Jons Partition            ';
  M1[6]   := 'Bills Partition           ';
  M1[7]   := 'Steves Partition          ';
  M1[8]   := 'No Paritition             ';
  M1[9]   := 'Jons Partition            ';
  M1[10]   := 'Bills Partition           ';
  M1[11]   := 'Steves Partition          ';
  M1[12]   := 'No Paritition             ';
  M1[13]   := 'Jons Partition            ';
  M1[14]   := 'Bills Partition           ';
  M1[15]   := 'Steves Partition          ';
  M1[16]   := 'No Paritition             ';
  M1[17]   := 'Jons Partition            ';
  M1[18]   := 'Bills Partition           ';
  M1[19]   := 'Steves Partition          ';
  M1[20]   := 'No Paritition             ';

  B       := 20;

  HexMode := TRUE;
  start   := 1;

  {-------------------}
  { Allocate the form }
  {-------------------}

  FP := WFormNew( 50 );

  {----------------}
  { Build the form }
  {----------------}

  WFormAddBegin( FP, 0,0, white,blue, white,white, TRUE );

    WFormAddSetBegin( FP, TRUE, 0 );
      WFormAddRadioB( FP, 03,02, -1,-1, -1,-1, 0,0, TRUE, 00, TRUE  );
      WFormAddRadioB( FP, 03,03, -1,-1, -1,-1, 0,0, TRUE, 00, FALSE );
      WFormAddText(   FP, 30,03, -1,-1, -1,-1, 0,0, TRUE, -1,
                          40, 'RESULTS.TXT', NIL                    );
    WFormAddSetEnd(   FP );

    WFormAddProc( FP, 03,06, -1,-1, -1,-1, 0,0, TRUE, 0, GrabPattern, 70,1 );

    WFormAddSetBegin( FP, TRUE, 0 );
      WFormAddRadioB( FP, 03,08, -1,-1, -1,-1, 0,0, TRUE, 00, TRUE  );
      WFormAddRadioB( FP, 03,09, -1,-1, -1,-1, 0,0, TRUE, 00, FALSE );
      WFormAddListBox(FP, 30,09, -1,-1, -1,-1, 0,0, TRUE, -1,
                          @M1, B, 1, 2, 0, 1, '' );
    WFormAddSetEnd(   FP   );

    WFormAddSetBegin( FP, TRUE, 0 );
      WFormAddXBox(   FP, 03,12, -1,-1, -1,-1, 0,0, TRUE, 0, TRUE );
      WFormAddXBox(   FP, 03,13, -1,-1, -1,-1, 0,0, TRUE, 0, TRUE );
      WFormAddXBox(   FP, 03,14, -1,-1, -1,-1, 0,0, TRUE, 0, TRUE );
    WFormAddSetEnd(   FP );

    WFormAddButton(   FP, 38,13, blue,cyan, -1,-1, 0,0, TRUE, 0,
                          2, 'F2 = Accept ', NIL, fsEnter        );
    WFormAddButton(   FP, 58,13, blue,cyan, -1,-1, 0,0, TRUE, 0,
                          2, 'F3 = Abort  ', NIL, fsEscape       );

  WFormAddEnd(   FP );

  {-------------------}
  { Write out headers }
  {-------------------}

  WFastWrite( 7,2, YELLOW,BLUE, 'Show results on Screen' );

  WFastWrite( 7,3, YELLOW,BLUE, 'Write results to' );

  WFastWrite( 3,5, YELLOW,BLUE, 'String to search for' );

  WFastWrite( 7,8, YELLOW,BLUE, 'Search entire device' );

  WFastwrite( 7,9, YELLOW,BLUE, 'Search partition' );

  WFastwrite( 7,12, YELLOW,BLUE, 'Case sensitive search' );
  WFastwrite( 7,13, YELLOW,BLUE, 'Fuzzy/Soundex search' );
  WFastwrite( 7,14, YELLOW,BLUE, 'First 16 byte search' );

  {-------------}
  { Do the Form }
  {-------------}

  WMessage('Use the <TAB>, <SHIFT>-TAB, and Arrow keys to move.  <ENTER> to accept', white, blue );

  WFormDraw( FP );

  WFormRead( FP, start, retcode );


(*
  WEventsOn;

  Repeat

    WFormRead( FP, start, retcode );

    WInfoMsg('key='+intToStr(WinEnv.EventKey)+
             ' extkey='+IntToStr(WinEnv.EventKey)+
             ' mb='+IntToStr(WinEnv.EventButtons), blue, cyan );


  Until RetCode<>fsNone;

  WEventsOff;
*)

  WGemDialogBox('[1][Form Return Code='+IntToStr(retcode)+'][ok]');

  {---------------------}
  { Dispose of the form }
  {---------------------}

  WFormDispose( FP );

  GetSearchItems :=  RetCode <> fsEscape;

END;

{----------------------------------------------------------------}

Procedure Initialize;

VAR

  S     : ST80;
  Loopy : INTEGER;

BEGIN

  S := '';
  For Loopy := 1 to ParamCount Do
  BEGIN
    If Pos( '/hi', LowerString( ParamStr( Loopy ) ) ) <> 0 Then
      S := S + 'HIREZ,';
    If Pos( '/shi', LowerString( ParamStr( Loopy ) ) ) <> 0 Then
      S := S + 'SUPER-REZ,';
    If Pos( '/m', LowerString( ParamStr( Loopy ) ) ) <> 0 Then
      S := S + 'B/W,';
    If Pos( '/keepscreen', LowerString( ParamStr( Loopy ) ) ) <> 0 Then
      S := S + 'KEEPSCREEN,';
  END;

  S := 'KHITS=1,MOUSE,LOOK=1,CLOCK,' + S;

  If (CrtIsVga) and (ScreenRows=25) Then
  BEGIN

    WOpen( '', black, blue, S+'WIDGETFONT' );

    WinEnv.Look := 1;

    WLoadBlueGrayPalette;

    {DoNormalSetWins;}

{    WSet('BORDER=9'); }

  END
  ELSE
  BEGIN

    WOpen( '', black, blue, S);

    WinEnv.Look := 2;

    {DoNormalSetWins;}

  END;


  WSubmitDefKeys;

  {WSubmitKeyProc( #0, #65, Addr( DosShell ), 'DOS Shell' );}

  WPrgNameMsg( 'FormTest 0.0.1| Date 00/00/00  Time 00:00:00 AM',
               BLUE, CYAN );


  WInfoMsg( ' ', WHITE, CYAN );
  WMessage( 'Scanning for devices|<Please wait>', WHITE, BLUE );

  {------------------------------------------------------------}
  { Submit help procedure, help file name, and help file page. }
  {------------------------------------------------------------}

(*
  WSubmitHelpProc( Addr( WOldHelp ) );
  WSubmitKeyProc( #0, #59, Addr( F1W_Help ), 'Help!' );
*)

  WinEnv.Help     := 1;
  WinEnv.HelpFile := 'SSTUTIL.HLP';

  WCursorOFF;
END;   { Of Initialize }



BEGIN

  Initialize;

  While GetSearchItems Do;

  WClose;

END. blue, cyan );

