program tstrtxtu;


uses

  vtypesu,
  vgenu,
  vstringu,
  VStrTxtU;

Var
  smaxavail,smemavail : LONGINT;

{}

Procedure ShowMemInfoBefore;

BEGIN

  smaxavail := maxavail;
  smemavail := memavail;

  WriteLn('      Memory Before: MaxAvail=',Maxavail,' MemAvail=',MemAvail);

END;

Procedure ShowMemInfoDuring;

BEGIN

  WriteLn('      Memory During: MaxAvail=',Maxavail,
                              '(', smaxavail-maxavail,') ',
                              'MemAvail=',MemAvail,
                              '(', smemavail-memavail,') '  );

END;


Procedure ShowMemInfoAfter;

BEGIN

  WriteLn('      Memory After : MaxAvail=',Maxavail,
                              '(', smaxavail-maxavail,') ',
                              'MemAvail=',MemAvail,
                              '(', smemavail-memavail,') '  );



END;

{}


Procedure TestVStrTxtAssign( theflags : word );

Var

  SL                   :   PStrList;
  smaxavail, smemavail : LONGINT;

  sltype     : ST80;

  Z          : INTEGER;


  F          : TEXT;

BEGIN

  Case theflags of

    cslStrings   : sltype := 'cslStrings';
    cslPStrings  : sltype := 'cslPStrings';
    cslLLStrings : sltype := 'cslLLStrings';
    cslPChars    : sltype := 'cslPChars';
    cslLLPChars  : sltype := 'cslLLPChars';

  ELSE

    slType := 'UNKNOWN!';

  END;

  WriteLn('  Test VStrTxtAssign with '+sltype );

  smaxavail := maxavail;
  smemavail := memavail;

  WriteLn('    VStrListNew( ',WordToHex(theflags),', 10, 80 )' );
  SL := VStrListNew( theflags, 10, 80 );

  ShowMemInfoBefore;

  WriteLn('    VStrTxtAssign( f, sl )' );

  VStrTextAssign( F, SL );
  ShowMemInfoDuring;

  WriteLN( F, '' );
  WriteLN( F, 'Hi! How are you doing today?  I am fine.');
  WriteLn( F, ' I hope you are enjoying this, because I am.');
  WriteLn( F, '  The quick brown fox jumped over the lazy dog.');
  WriteLn( F, '   All-the-live-long-day.');
  WriteLn( F, '    Now is the time for all good people');
  Write  ( F, '     to purchase a copy of ');
  WriteLN( F, 'all Visionix Products...');

  For Z:=1 to VStrTextGetLines( F ) Do
    WriteLn('    VStrListGetStr( sl, ',z,'  ) ... ',
                 VStrListGetStr( SL, Z )              );

    WriteLn('    VStrListGetStr( sl, 10 ) ... ',
                 VStrListGetStr( SL, 10 )              );



  Close( F );
  ShowMemInfoAfter;



  WriteLn('    VStrListDispose()');

  VStrListDispose( SL );


  WriteLn;

END;

{}
{}
{}

BEGIN


  WriteLn;
  WriteLn;
  WriteLn('TSTRTXTGU (Tests VStrTxtu)');
  WriteLn('Version 0.1 November 2, 1993');
  WriteLn;


  TestVStrTxtAssign( cslStrings    );
  TestVStrTxtAssign( cslPStrings   );
  TestVStrTxtAssign( cslLLStrings  );
  TestVStrTxtAssign( cslPChars     );
  TestVStrTxtAssign( cslLLPChars   );


END.