Program vterm;

Uses

  VTypesu,
  VInu,
  VOutu,
  VCrtu,
  VAnsiiou,
  VAvtiou,
{$IFDEF DEBUG}
  VDebugu,
{$ENDIF}
  VKeybu,
  VFosu,
  VMultiu,
  VGenu,
  VResfu,
  VStringu,
  VUartu,
  VSerlu,
  VSeru,
  VSerhu;

{}

Procedure DoStatusLine( Status : BYTE; IData : POINTER ); Far;

Var

  S    : STRING;
  SerH : TSerHandle;
  N    : LONGINT;

BEGIN

  SerH := PSerHandle( IData )^;

  { setup header }

  S :=' VisionTerm - Alt<Q>=Quit ';

  { setup carrier string }

  S := S + BoolToStr( VSerCarrier( Serh ), ' Carrier  ', '          ' );

  { setup incoming characters string }

  S := S + BoolToStr( VSerInAvail( Serh ), ' Incoming ', '          ' );

  { setup trailer }

  S := S+' '+PadRight( IntToStr( VSerGetInAvail( Serh ) ), 9, ' ' ) + '';

  S := S+'           ';

  S := PadRight( S, 80, ' ' );

  { write it out }

  WriteStringAt( 1, ScreenRows, Black, LIGHTGRAY, S );

END;


{}

Function VisionTerm : WORD;

Var

  SerH : TSerHandle;
  Err  : WORD;
  SaveX: BYTE;
  SaveY: BYTE;
  SaveS: POINTER;
  Done : BOOLEAN;
  Fos  : BOOLEAN;
  LL   : BYTE;

  {}

  Function SetupPort( ThePort : INTEGER;
                      Baud    : INTEGER    ) : WORD;


  Var

    CP : TCommParam;

  BEGIN

    { Create new serial channel }

    Fos := VRF_GetBoolean('USEFOSSIL');

    If Fos Then
      Err := VSerChanNew( 0,
                          FosSerDriverProc,
                          ThePort,
                          0,
                          0,
                          SerH )
    Else
      Err := VSerChanNew( 0,
                          UartSerDriverProc,
                          ThePort,
                          0,
                          0,
                          SerH );

    If Err<>0 Then
    BEGIN
      SetupPort := Err;
      Exit;
    END;

    { activate/initialize the channel }

    CP.BaudRate   := VRF_GetInt( 'BAUDRATE' );
    CP.Parity     := 'N';
    CP.DataBits   := 8;
    CP.StopBits   := 1;

    Err := VSerChanActivate( SerH, @CP );

    If Err<>0 Then
    BEGIN
      SetupPort := Err;
      Exit;
    END;

    SetupPort := 0;

  END;


  {}


  Function Initialize : WORD;

  Var

    CP : TCommParam;
    Err: WORD;

  BEGIN

    VRF_New( 'VTERM.VRF', 200 );

    Err := SetupPort( VRF_GetInt( 'COMPORT'  ),
                      VRF_GetInt( 'BAUDRATE' )  );

    { add the ANSI and Avatar filters to the CRT output channel }

    AttachAnsiFilter(   CrtOCH, 'Bx00VMEM' );

    AttachAvatarFilter( CrtOCH, 'Bx00VMEM' );


    { launch the multi-proc that does the status line }


    If VRF_GetBoolean( 'STATUSLINE' ) Then
    BEGIN

      VMultiProcNew( DoStatusLine,        { procedure address }
                     10,                  { every 10/100 of a sec }
                     7,                   { medium priority }
                     'VT-StatusLine',     { name }
                     @SerH,               { instance data }
                     Err               );

      { Setup the screen }

      LL := ScreenRows-1;

    END
    ELSE
      LL := ScreenRows;

    Window( 1,1,ScreenCols,LL );

    TextColors( lightgray, black );

    ClrScr;

    { finish up }

    Initialize := Err;

  END;

  {}

  Procedure DeInit;

  BEGIN
    VSerChanDispose( Serh );

  END;

  {}

  Procedure DoExtendedKey( CH : CHAR );

  BEGIN

    Case CH Of
      kAltQ : Done := TRUE;
    END;

  END;

  {}

  Function TermLoop : WORD;

  Var

    CH   : CHAR;

  BEGIN

    Done := FALSE;

    Repeat

      { Read keyboard }

      If KeyPressed Then
      BEGIN
        CH := ReadKey;
        If CH<>#0 Then
          VSerWriteCh( Serh, CH )
        ELSE
          DoExtendedKey( ReadKey );
      END;

      { Read serial port }

      IF VSerInAvail( SerH ) Then
        Write( VSerGetStEx( Serh, VSerGetInAvail( Serh ) ) );

    Until Done;

  END;

  {}



BEGIN

  Err := Initialize;

  If Err=0 Then
  BEGIN
    Err := TermLoop;
  END;

  DeInit;

  VisionTerm := Err;

END;

{}
{}
{}


BEGIN

{$IFDEF DEBUG}

  DebugOpen('VTERM.LOG');

  DebugWriteLn('---------------------------');

{$ENDIF}


  VisionTerm;

END.

