Program PixelPerfectColision;

Uses Crt,Mode13h,Sprites;

Var Ship,Asteroid:Sprite;
    Exp:Array[1..2] Of Pointer;
    F:File;
    Pal:RGBList;
    EImg:Byte;

Function PPCol(Spr1,Spr2:Sprite):Boolean;
Var DeltaX,DeltaY:Integer;
    Sx1,Sx2,Sy1,Sy2:Integer;
    Seg1,Seg2,Ofs1,Ofs2:Word;
    X,Y:Integer;
    C1,C2:Byte;
    MinY,MinX:Integer;
Begin
     If (Spr1.XSize<Spr2.XSize) Then MinX:=Spr1.XSize Else MinX:=Spr2.XSize;
     If (Spr1.YSize<Spr2.YSize) Then MinY:=Spr1.YSize Else MinY:=Spr2.YSize;
     { Get intersect area }
     Sx1:=Spr2.X-Spr1.X;
     Sx2:=Spr1.X-Spr2.X;
     If Sx1<0 Then
     Begin
          DeltaX:=Spr2.X+Spr2.XSize-Spr1.X;
          If DeltaX>MinX Then DeltaX:=MinX;
          Sx1:=0;
     End
     Else
     Begin
          DeltaX:=Spr1.X+Spr1.XSize-Spr2.X;
          If DeltaX>MinX Then DeltaX:=MinX;
          Sx2:=0;
     End;
     Sy1:=Spr2.Y-Spr1.Y;
     Sy2:=Spr1.Y-Spr2.Y;
     If Sy1<0 Then
     Begin
          DeltaY:=Spr2.Y+Spr2.YSize-Spr1.Y;
          If DeltaY>MinY Then DeltaY:=MinY;
          Sy1:=0;
     End
     Else
     Begin
          DeltaY:=Spr1.Y+Spr1.YSize-Spr2.Y;
          If DeltaY>MinY Then DeltaY:=MinY;
          Sy2:=0;
     End;
     { Check the intersection }
     Seg1:=Seg(Spr1.Img^); Ofs1:=Ofs(Spr1.Img^)+4;
     Seg2:=Seg(Spr2.Img^); Ofs2:=Ofs(Spr2.Img^)+4;
     For Y:=0 To DeltaY-1 Do
     Begin
          Ofs1:=Spr1.XSize*(Y+Sy1)+Sx1+4;
          Ofs2:=Spr2.XSize*(Y+Sy2)+Sx2+4;
          For X:=0 To DeltaX-1 Do
          Begin
               C1:=Mem[Seg1:Ofs1];
               C2:=Mem[Seg2:Ofs2];
               If (C1<>0) And (C2<>0) Then Break;
               Inc(Ofs1); Inc(Ofs2);
          End;
          If (C1<>0) And (C2<>0) Then Break;
     End;
     If (C1<>0) And (C2<>0) Then PPCol:=True Else PPCol:=False;
End;

Function Col(Spr1,Spr2:Sprite):Boolean;
{ This checks for box collision and gets the checking of pixel perfect
  collision in case there is a box collision... }
Var XCol,YCol:Boolean;
    Delta,CompSize:Integer;
Begin
     Delta:=Spr2.X-Spr1.X;
     If Delta<0 Then
       If Abs(Delta)<Spr2.XSize Then XCol:=True Else XCol:=False
     Else
       If Delta<Spr1.XSize Then XCol:=True Else XCol:=False;
     Delta:=Spr2.Y-Spr1.Y;
     If Delta<0 Then
       If Abs(Delta)<Spr2.YSize Then YCol:=True Else YCol:=False
     Else
       If Delta<Spr1.YSize Then YCol:=True Else YCol:=False;
     If (XCol And YCol) Then Col:=PPCol(Spr1,Spr2) Else Col:=False;
End;

Begin
     Assign(F,'Sprites.Img'); Reset(F,1);
     LoadImage(F,Ship.Img); LoadImage(F,Asteroid.Img);
     LoadImage(F,Exp[1]); LoadImage(F,Exp[2]);
     Close(F);
     Ship.X:=10; Ship.Y:=105; Ship.XSize:=29; Ship.YSize:=7;
     Asteroid.X:=200; Asteroid.Y:=100; Asteroid.XSize:=36; Asteroid.YSize:=33;
     LoadPal('Cube.Pal',Pal);
     InitGraph;
     SetPalette(Pal);
     EImg:=1;
     Repeat
           WaitVbl;
           Cls(0,VGA);
           Ship.X:=Ship.X+2;
           DrawSprite(Asteroid,VGA);
           DrawSprite(Ship,VGA);
           If Col(Ship,Asteroid) Then
           Begin
                If EImg=1 Then EImg:=2 Else EImg:=1;
                Ship.Img:=Exp[EImg];
                WaitVbl;
           End;
           Delay(10);
     Until Ship.X>210;
     CloseGraph;
End.