
   (*                                                                  *)
   (*                 Sound Blaster Digital Sound Unit                 *)
   (*                                                                  *)
   (*    Programmed by Viriato (l41324@alfa.ist.utl.pt) in 1996 for    *)
   (*                                                                  *)
   (*                  Spellcaster's The Mag issue 12                  *)
   (*                                                                  *)
   (* This unit was made for pedagogic purposes. You may use it as you *)
   (* please, at your own riscs. I'm not responsabile for any kind of  *)
   (* damage caused by the incorrect or correct use of this unit.      *)
   (* If you use it for any comercial software, it must refer my name  *)
   (* as the coder of the unit. If you ever use this unit in any kind  *)
   (* of program, comercial or not, I would be pleased if you send me  *)
   (* a copy of it.                                                    *)

Unit SBDSU;

Interface

Var
{ A var to keep the SB caracteristics }
    Sb:Record
             Base_Port:Word;           { SB's base port adress    }
             Irq_Number:Word;          { SB's irq number          }
             Dma_Channel:Word;         { SB's DMA channel         }
             Dsp_Major_Version:Byte;   { DSP version:             }
             Dsp_Minor_Version:Byte    { 1.x - SB1.x; 2.x - SB2.x }
       End;

Function DSPReset(Base_Port:Word):Boolean;
Function SBPresent:Boolean;
Procedure DSPWrite(Value:Byte);
Function DSPRead:Byte;
Function GetDSPVersion:Byte;
Function GetSpeakerStatus:Boolean;
Procedure SetSpeakerStatus(Status:Boolean);

Implementation

Uses Crt;

(************************************************************************)
(*** SB detection, DSP initialization and basic DSP data Read/Write *****)

Function DSPReset(Base_Port:Word):Boolean;
{ Performs a DSP reset, returning TRUE only if sucessfull }
Begin
     Port[Base_Port+$6]:=1;
     Delay(1);                  { 1/1000 second is more than enough }
     Port[Base_Port+$6]:=0;
     Delay(1);               { It's enough time for ReadReady bit in port }
                             { DSP - DataAvailable (2xEh) go to 1         }
     DSPReset:=(Port[Base_Port+$A]=$AA);
End;  { DSPReset }

Function SBPresent:Boolean;
{ Returns TRUE only if an SB has been detected and keeps its base port }
Begin
     Sb.Base_Port:=$210;
     { Look for a DSP in the possible ports }
     While (Sb.Base_Port<$270) And
           Not (DSPReset(Sb.Base_Port)) Do
           Inc(Sb.Base_Port,$10);              { Try next possible port }
     { Return TRUE if Sb.Base_Port is in [210h..260h] or FALSE otherwise }
     SBPresent:=(Sb.Base_Port>=$210) And (Sb.Base_Port<=$260);
End;  { SBPresent }

Procedure DSPWrite(Value:Byte);
{ Writes a value (command or data) into the DSP }
Begin
     While (Port[Sb.Base_Port+$C] And $80)<>0 Do;
     Port[Sb.Base_Port+$C]:=Value;
End;  { DSPWrite }

Function DSPRead:Byte;
{ Reads a data value from the DSP }
Begin
     While (Port[Sb.Base_Port+$E] And $80)=0 Do;
     DSPRead:=Port[Sb.Base_Port+$A];
End;  { DSPRead }

(************************************************************************)
(*** Set of basic DSP commands ******************************************)

Function GetDSPVersion:Byte;
{ Gets the DSP version of an SB's DSP and keeps it in the variable Sb. }
{ It also returns the major version number (useful for easy SB id).    }
Begin
     DSPWrite($E1);
     Sb.Dsp_Major_Version:=DSPRead;
     Sb.Dsp_Minor_Version:=DSPRead;
     GetDSPVersion:=Sb.Dsp_Major_Version
End;

Function GetSpeakerStatus:Boolean;
{ Returns the status of the speaker, TRUE - on, FALSE - off (don't }
{ forget to turn on the speaker whenever you make the SB to play)  }
Begin
     DSPWrite($D8);
     GetSpeakerStatus:=(DSPRead=$FF);
End;

Procedure SetSpeakerStatus(Status:Boolean);
{ Switchs the speaker ON (TURE) or OFF (FALSE)  (don't forget to turn }
{ on the speaker whenever you make the SB to play)                    }
Begin
     If Status Then DSPWrite($D1)       { Enable speaker  }
     Else DSPWrite($D3)                 { Disable speaker }
End;

Begin
End.