;Ŀ
;          SAT Player v0.1, written by Lone Ranger/AcmE   (c) 1993          
;                                                                           
;  This file contains all the routines needed to play a .SAT file (used by  
;  Surprise! Productions Adlib Tracker /Rick Dangerous S!P). You may use it 
;  in your own intro/demo as long as you give credits to the coder          
;  (Lone Ranger/AcmE), and send the product it's used in to me (see         
;  ACME.NFO for contacting info). Please send all modifications or ideas    
;  to me, instead of releasing a modified version. thanx..                  
;                                                                           
;

        P286                            ; Uses 286 instuctions
        jumps                           ; Let TASM handle out-of-range jumps

Public  SAT_player
Public  SAT_Equalizer
Public  SAT_SongPos
Public  SAT_PatternPos

_Code   segment para public 'Code'
assume  cs:_Code, ds:_Code, es:_Code

db      'SATplayer v0.1, (c) Copyright 1993 by Lone Ranger/AcmE'

OldInt08h       dd      0               ; Pointer of old timer interrupt
OldIntMask      db      0               ; Value of old interrupt mask

LSBcounter      dw      0                                                       ;

; Macros 

WriteFM macro   I, D

        push    ax
        mov     dx, 388h                ; Index port of AdLib
        mov     al, &I
        out     dx, al                  ; write index
        inc     dx
        push    cx
        mov     cx, 100
        loop    $                       ; wait
        pop     cx
        mov     al, &D
        out     dx, al                  ; write data
        push    cx
        mov     cx, 400
        loop    $                       ; wait
        pop     cx
        pop     ax

Endm

; SAT format data 

SongLen         equ     Byte ptr es:[44Bh]
RestartPosition equ     Byte ptr es:[44Ch]
CallsPerSecond  equ     Byte ptr es:[44Dh]
PatternOffset   equ     44Fh
InstrumentOffset equ    5h
PatternOrderOffset equ  842

; PROCEDURES 

;
; Setup timer interrupt and reprogram timer chip 
;

EnableTIMER     proc    far

        cmp     cs:[PlayMode], 1
        je      Skip_EnableTIMER

        mov     dx, 0012h
        mov     ax, 34dch
        xor     ch, ch
        mov     cl, CallsPerSecond
        div     cx
        mov     cs:[LSBcounter], ax     ; calculate LSB counter

        mov     ax, 3508h
        int     21h                     ; Get old timer interrupt offset
        mov     word ptr cs:[OldInt08h], bx
        mov     word ptr cs:[OldInt08h+2], es

        in      al, 21h                 ; Get interrupt mask register
        mov     cs:[OldIntMask], al

        cli                             ; Make sure no ints occure while in
                                        ; setup!

        mov     al, 0FFh
        out     21h, al                 ; disable all maskable interrupts

        sti

        mov     dx, offset PlayerInterrupt
        push    cs
        pop     ds
        mov     ax, 2508h
        int     21h                     ; Setup new timer interrupt

        mov     al, 00110110b           ; Channel 0, Read/write LSB followed
        out     43h, al                 ; by MSB, Operation mode 2, binary
        mov     al, byte ptr cs:[LSBCounter]
        out     40h, al
        mov     al, byte ptr cs:[LSBCounter+1]
        out     40h, al                 ; Send counter MSB

        cli
        mov     al, cs:[OldIntMask]
        out     21h, al                 ; enable interrupts again
        sti
        sti

Skip_EnableTIMER:

        popa
        retf

EnableTIMER     endp

;
; Disable timer interrupt, restore timer offset and restore timer chip 
;

DisableTIMER    proc    far

        cmp     cs:[PlayMode], 1
        je      Skip_DisableTIMER

        cli
        mov     al, 0FFh                ; disable all interrupts
        out     21h, al
        sti

        mov     al, 00110100b           ; Channel 0, Read/write LSB followed
        out     43h, al                 ; by MSB, Operation mode 2, binary
        xor     ax, ax
        out     40h, al
        out     40h, al

        mov     dx, word ptr cs:[OldInt08h]
        mov     ds, word ptr cs:[OldInt08h+2]
        mov     ax, 2508h
        int     21h                     ; Restore the stored interrupt vector

        cli
        mov     al, cs:[OldIntMask]
        out     21h, al                 ; enable interrupts again
        sti
        sti

Skip_DisableTIMER:

        jmp     ResetFMchip

DisableTIMER    endp

;
; This is the actual player 
;

MusicSEG        dw      0               ; segment of sat-file
PlayMode        db      0               ; 0 = timer, 1 = poll

noteplay        db      0               ; internal, boulean

SAT_SongPos     db      0               ; Current Song Position
SAT_PatternPos  dw      0               ; Current Pattern Position
                                        ; (real offset!)

Channel_Volumes db      9 dup (0)       ; volumes of all 9 channels.

Modulator_numbers       db      00h,01h,02h,08h,09h,0ah,10h,11h,12h
Carrier_numbers         db      03h,04h,05h,0bh,0ch,0dh,13h,14h,15h

f_number        dw      343,363,385,408,432,458,485,514,544,577,611,647

SAT_Speed       db      6               ; current speed
TempSpeed       db      6               ; counter for speed

SAT_Equalizer   db      36 dup (0)      ; equalizer (0-63)

Player  proc    far

        pusha

        mov     ax, cs
        mov     ds, ax                  ; DS = code seg (and data)
        mov     ax, [MusicSeg]          ; ES = seg of sat-file
        mov     es, ax

; Update equalizer 

        mov     cx, 36
        mov     BX, offset SAT_Equalizer
EQU_Loop:
        cmp     byte ptr [bx], 0
        jne     EQU_dec
        inc     bx
        loop    EQU_Loop
        jmp     EQU_Done
EQU_Dec:
        dec     byte ptr [bx]
        inc     bx
        loop    EQU_loop
EQU_Done:

; Check Speed 

        dec     [TempSpeed]
        jnz     Exit_PLayer
        mov     al, [SAT_Speed]
        mov     [TempSpeed], al

; Update notes and instruments 

        xor     bh, bh
        xor     ah, ah
        mov     bl, [SAT_SongPos]       ; get song position and get pattern
        mov     al, byte ptr es:[PatternOrderOffset+bx]
        mov     cx, 2880
        mul     cx                      ;
        add     ax, 44fh                ; calc offset to real pattern in file

        add     ax, [SAT_PatternPos]    ; calc offset to current note
        mov     Di, Ax                  ; put it in DI

        xor     bp, bp                  ; counter number channels
ChannelLoop:
        xor     ax, ax                  ; clear out ax
        mov     al, es:[di+1]           ; get current instrument
        or      al, al                  ; is it a note
        jz      Skip_SetupInstr         ; nope, don't program FM
        dec     al                      ; actual instr
        call    Set_Instrument          ; program FM

        mov     [noteplay], 1           ; flag, we have to play a note

Skip_SetupInstr:

; Check special effects 

        cmp     byte ptr es:[di+2], 0Ch ; is it Volume Set
        jne     Check_Speed             ; nope
        mov     al, es:[di+3]           ; get volume
        shl     al, 4                   ;
        or      al, es:[di+4]           ;
        mov     ah, [channel_volumes+bp]; get old volume
        and     ah, 11000000b           ; save KSL value
        or      al, ah                  ; calc new value
        mov     [channel_volumes+bp], al; set it
        call    Set_Volume              ; reprogram FM

Check_Speed:
        cmp     byte ptr es:[di+2], 0Fh ; is it Speed Change
        jne     Check_Done              ; nope
        mov     al, es:[di+3]           ; get speed
        shl     al, 4                   ;
        or      al, es:[di+4]           ;
        mov     [SAT_speed], al         ; save it
        mov     [tempspeed], al

Check_Done:

        cmp     [noteplay], 1           ; Is there a note to play?
        jne     Check_Done_1            ; nope
        call    play_Note


Check_Done_1:
        mov     [noteplay], 0           ; clear flag

        inc     bp                      ; next channel
        add     di, 5                   ; next note
        cmp     bp, 10                  ; all channels done?
        jne     ChannelLoop             ; nope..

; Update pointers 

        add     [SAT_PatternPos], 9*5   ; next row
        cmp     [SAT_PatternPos], 64*9*5; all rows done?
        jb      No_Set_Songpos          ; nope.. not yet..
        mov     [SAT_PatternPos], 0     ; first row
        inc     [SAT_SongPos]           ; next songpos
        mov     al, SongLen             ;
        cmp     [SAT_SongPos], al       ; are we done yet?
        jbe     No_Set_SongPos          ; nope
        mov     al, RestartPosition     ; do it again..
        mov     [SAT_SongPos], al       ;
No_Set_Songpos:

Exit_Player:
        popa

        retf

Player  endp

;
; This procedure is called by the timer interrupt 
;

PlayerInterrupt proc    far

        push    ax ds es
        call    Player
        mov     al, 20h                 ; interrupt finished
        out     20h, al
        pop     es ds ax
        iret

PlayerInterrupt endp

;
; This routine has to be called by the master program (intro/demo)
;
; IN:  BX = 0          Check for FM chip
;                      - returns:      CF clear: FM chip found
;                                      CF set: no FM chip found
;      BX = 1          Reset FM chip
;-      BX = 2          Init player
;-                      - in:           ES: segment of SAT file
;                                      AL = 0: timer mode (don't poll)
;                                      AL = 1: polling mode (has to be
;                                              called exactly 50 or 70 times
;                                              a second. (ie. in a vertical
;                                              retrace)
;      BX = 3          Start Playing
;      BX = 4          Poll player
;      BX = 5          Stop Playing
;

JumpTable       dw      offset TestFMchip, offset ResetFMchip, offset InitPlay
                dw      offset EnableTIMER, offset Player, offset DisableTIMER

SAT_player      proc    far

        cmp     bx, 4
        je      Skip_PushA
        pusha
Skip_Pusha:
        shl     bx, 1
        jmp     cs:[JumpTable+BX]

SAT_player      endp

;
; Initialize player (set musicseg and playmode) 
;

InitPlay        proc    far
        mov     cs:[MusicSeg], es       ; Set music segment
        mov     cs:[PlayMode], al       ; seg playing mode (timer/poll)
        popa
        retf
InitPlay        endp

;
; calc freq and write it to FM 
;

Play_Note       proc    near

        xor     ax, ax

        mov     al, 0B0h                ; disable an old note
        add     ax, bp
        WriteFM al, 0
        mov     al, 0A0h
        add     ax, bp
        WriteFM al, 0

        mov     al, es:[di]             ; get note
        dec     ax

        mov     bx, ax                  ; update equalizer
        mov     cs:[SAT_Equalizer+bx], 63

        mov     cl, 12
        div     cl                      ; Get freq and block
        push    ax
        mov     bx, ax
        shr     bx, 8
        shl     bx, 1
        mov     cx, cs:[f_number+BX]    ; get freq for output

        mov     al, 0A0h
        add     ax, bp
        WriteFM al, cl                  ; write it

        pop     ax                      ; restore block
        xor     ah, ah
        add     al, 2
        shl     al, 2
        or      ch, al
        or      ch, 32                  ; calc output value (32=enable ins)

        mov     al, 0B0h                ; write it
        add     ax, bp
        WriteFM al, CH

        ret

Play_Note       endp

;
; Program instrument
; in:  AL = instrument number (0 = instr. 1 etc)
;      BP = channel
;      ES = segment of music file
;

Set_Instrument      proc    near

        xor     ah, ah
        mov     cx, 11
        mul     cx
        add     ax, 5                   ; calc offset of instr info in file
        mov     si, ax

; program instruments 

        xor     ax, ax
        mov     al, 0C0h
        add     ax, bp
        WriteFM al, es:[si]

        mov     al, 020h
        add     al, [offset Modulator_numbers+bp]
        WriteFM al, es:[si+1]

        mov     al, 020h
        add     al, [offset Carrier_numbers+bp]
        WriteFM al, es:[si+2]

        mov     al, 060h
        add     al, [offset Modulator_numbers+bp]
        WriteFM al, es:[si+3]

        mov     al, 060h
        add     al, [offset Carrier_numbers+bp]
        WriteFM al, es:[si+4]

        mov     al, 080h
        add     al, [offset Modulator_numbers+bp]
        WriteFM al, es:[si+5]

        mov     al, 080h
        add     al, [offset Carrier_numbers+bp]
        WriteFM al, es:[si+6]

        mov     al, 0E0h
        add     al, [offset Modulator_numbers+bp]
        WriteFM al, es:[si+7]

        mov     al, 0E0h
        add     al, [offset Carrier_numbers+bp]
        WriteFM al, es:[si+8]

        mov     al, 040h
        add     al, [offset Modulator_numbers+bp]
        WriteFM al, es:[si+9]

        mov     al, 040h
        add     al, [offset Carrier_numbers+bp]
        WriteFM al, es:[si+10]

        mov     al, es:[si+10]
        mov     [channel_volumes+bp], al; update volume settings

        ret

Set_Instrument      endp

;
; Programs FM volume 
;

Set_Volume      proc    near

        mov     al, 040h
        add     al, [offset Carrier_numbers+bp]
        WriteFM al, [Channel_volumes+bp]
        mov     al, 040h
        add     al, [offset Modulator_numbers+bp]
        WriteFM al, [channel_volumes+bp]

        ret

Set_Volume      endp

;
; Check for FM chip, returns CF = 0 if found, or CF = 1 if not 
;

TestFMchip      proc    far
                                                                                      WriteFM 1, 0                    ; Wis test register                           WriteFM 4, 60h                  ; zet doorvoer uit/stop tellers
        WriteFM 4, 80h
        mov     dx, 388h
        in      al, dx
        mov     cl, al
        WriteFM 2, 0Ffh
        WriteFM 4, 21h
        mov     cx, 100
        loop    $
        mov     dx, 388h
        in      al, dx
        mov     ch, al
        WriteFM 4, 60h
        WriteFM 4, 80h

        and     cl, 0E0h
        cmp     cl, 0
        jne     No_FMchip
        and     ch, 0E0h
        cmp     ch, 0C0h
        jne     No_FMchip

        popa
        clc
        ret

No_FMchip:

        popa
        stc
        ret

TestFMchip      endp

;
; Reset FM chip 
;

ResetFMchip     proc    far

        WriteFM 1, 0                    ; enable writing to FM chip
        WriteFM 8, 0                    ; select normal mode and split

        mov     al, 0A0h                ; kill all freq
        mov     cx, 63
boe_loop:
        WriteFM al, 0
        inc     al
        loop    boe_loop

        WriteFM 0BDh, 11111111b         ; select rythm mode

        mov     al, 040h                ; kill all volumes (and rythm ins)
        mov     cx, 32
boe1_loop:
        WriteFM al, 63
        inc     al
        loop    boe1_loop

        popa
        retf

ResetFMchip     endp

_Code ends
end
