//***************************************************************************
//
// this file is (c) '94-'96 Niklas Beisert
//
// this file is part of the cubic player development kit.
// you may only use/modify/spread this file under the terms stated
// in the cubic player development kit accompanying documentation.
//
//***************************************************************************

#ifndef __MCP_H
#define __MCP_H

struct sampleinfo
{
  unsigned long type;
  void *ptr;
  long length;
  long samprate;
  long loopstart;
  long loopend;
  long sloopstart;
  long sloopend;
};

#define MCP_INVERTL 1
#define MCP_INVERTR 2

enum
{
  mcpSampUnsigned=1,
  mcpSampDelta=2,
  mcpSamp16Bit=4,
  mcpSampBigEndian=8,
  mcpSampLoop=16,
  mcpSampBiDi=32,
  mcpSampSLoop=64,
  mcpSampSBiDi=128,
  mcpSampRedBits=0x80000000,
  mcpSampRedRate2=0x40000000,
  mcpSampRedRate4=0x20000000,
};

enum
{
  mcpMasterVolume, mcpMasterPanning, mcpMasterBalance, mcpMasterSurround,
  mcpMasterSpeed, mcpMasterPitch, mcpMasterBass, mcpMasterTreble,
  mcpMasterReverb, mcpMasterChorus, mcpMasterPause, mcpMasterFilter,
  mcpMasterAmplify,
  mcpGSpeed,
  mcpCVolume, mcpCPanning, mcpCPanY, mcpCPanZ, mcpCSurround, mcpCPosition,
  mcpCPitch, mcpCPitchFix, mcpCPitch6848, mcpCStop, mcpCReset,
  mcpCBass, mcpCTreble, mcpCReverb, mcpCChorus, mcpCMute, mcpCStatus,
  mcpCInstrument, mcpCSetLoop, mcpCSetDir,
  mcpGTimer,
};

int mcpReduceSamples(sampleinfo *s, int n, long m, int o);
enum
{
  mcpRedAlways16Bit=1,
  mcpRedNoPingPong=2,
  mcpRedGUS=4,
};

extern int mcpNChan;

extern int (*mcpLoadSamples)(sampleinfo* si, int n);
extern int (*mcpOpenPlayer)(int, void (*p)());
extern void (*mcpClosePlayer)();
extern void (*mcpSet)(int ch, int opt, int val);
extern int (*mcpGet)(int ch, int opt);
extern void (*mcpGetRealVolume)(int ch, int &l, int &r);
extern void (*mcpGetRealMasterVolume)(int &l, int &r);
extern void (*mcpGetMasterSample)(short *s, int len, int rate, int mode);
extern int (*mcpGetChanSample)(int ch, short *s, int len, int rate);
extern int (*mcpAddChanSample)(int ch, short *s, int len, int rate);

int mcpGetFreq6848(int note);
int mcpGetFreq8363(int note);
int mcpGetNote6848(int freq);
int mcpGetNote8363(int freq);

extern unsigned long mcpMixMaxRate;
extern unsigned long mcpMixProcRate;
extern unsigned char mcpMixOpt;

extern void (*mcpIdle)();

#endif
