//***************************************************************************
//
// this file is (c) '94-'96 Niklas Beisert
//
// this file is part of the cubic player development kit.
// you may only use/modify/spread this file under the terms stated
// in the cubic player development kit accompanying documentation.
//
//***************************************************************************

//[general]
//  link=smpgmode
//[screen]
//  defmodes=_cpiModeGraphTest
//press " to activate



// graphics mode example

#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include "poutput.h"
#include "cpiface.h"

extern unsigned char *plCubicPict;
extern unsigned char plCubicPal[];

static void plPrepareScopes()
{
  int i;
  if (plCubicPict)
  {
    outp(0x3c8, 16);
    for (i=0; i<720; i++)
      outp(0x3c9, plCubicPal[i+48]);

    plSetGraphPage(0);
    memcpy((char*)0xA0000+96*640, plCubicPict, 4096);
    plSetGraphPage(1);
    memcpy((char*)0xA0000, plCubicPict+4096, 65536);
    plSetGraphPage(2);
    memcpy((char*)0xA0000, plCubicPict+69632, 65536);
    plSetGraphPage(3);
    memcpy((char*)0xA0000, plCubicPict+135168, 65536);
    plSetGraphPage(4);
    memcpy((char*)0xA0000, plCubicPict+200704, 45056);
  }
  else
  {
    plSetGraphPage(0);
    memset((char*)0xA0000+96*640, 0, 4096);
    plSetGraphPage(1);
    memset((char*)0xA0000, 0, 65536);
    plSetGraphPage(2);
    memset((char*)0xA0000, 0, 65536);
    plSetGraphPage(3);
    memset((char*)0xA0000, 0, 65536);
    plSetGraphPage(4);
    memset((char*)0xA0000, 0, 45056);
  }
}

static int plScopesKey(unsigned short key)
{
  return 0;
}

static void scoDraw()
{
  cpiDrawGStrings();
}

static void scoSetMode()
{
  plReadCubicPic();
  cpiSetGraphMode(0);
  plPrepareScopes();
  gdrawstr(4, 0, "   testmode: ", 48, 0x09, 0);
}

static int scoIProcessKey(unsigned short key)
{
  switch (key)
  {
  case '"':
    cpiSetMode("gtest");
    break;
  default:
    return 0;
  }
  return 1;
}

static int scoEvent(int ev)
{
  switch (ev)
  {
  case cpievInitAll:
    if (plVidType==vidNorm)
      return 0;
    return 1;
  }
  return 1;
}

extern "C"
{
  cpimoderegstruct cpiModeGraphTest = {"gtest", scoSetMode, scoDraw, scoIProcessKey, plScopesKey, scoEvent};
}
