{**************************************************************************}
{*   Cette unit permet d'utiliser facilement mes routines pour intgrer  *}
{*   de la musique dans vos propres programme.                            *}
{*                                                                        *}
{* Programm par Sbastien Granjoux                                       *}
{* Commenc le 01/06/93                                                   *}
{* Modification le 10/05/95                                               *}

UNIT CRYSTAL;

INTERFACE

FUNCTION FLOADMOD(filename:POINTER):INTEGER;
FUNCTION OLOADMOD(position:LONGINT):INTEGER;
FUNCTION MLOADMOD(position:POINTER):INTEGER;
PROCEDURE UNLOADMOD;
FUNCTION SETMOD(frequence,device,port:WORD;irq,dma:BYTE):INTEGER;
PROCEDURE MAKEMOD;
PROCEDURE STARTMOD;
PROCEDURE STOPMOD;
FUNCTION DETECTSND(VAR device,port:WORD;VAR irq,dma:BYTE):INTEGER;
PROCEDURE CHANGEVOL(newvol:BYTE);
PROCEDURE SETMODPOS(newpos:WORD);
FUNCTION  GETMODPOS:WORD;
FUNCTION  USEGUS:INTEGER;
FUNCTION  USESPK:INTEGER;
FUNCTION  USEDAC:INTEGER;
FUNCTION  USEADL:INTEGER;
FUNCTION  USESB:INTEGER;
FUNCTION  USESP:INTEGER;

CONST
  THE_BEST     =0;
  PC_SPEAKER   =1;
  DAC_ON_LPT   =2;
  SOUNDBLASTER =3;
  GUS          =4;
  SOUNDPRO     =5;
  ADLIB        =6;
  NO_DEVICE    =7;

IMPLEMENTATION

USES CRYSINT;

{$L LOADMOD.OBJ}
{$L CRYSLOAD.OBJ}
{$L CRYSFILE.OBJ}
{$L CRYSOVL.OBJ}
{$L CRYSMEM.OBJ}
{$L FLOADMOD.OBJ}
{$L OLOADMOD.OBJ}
{$L MLOADMOD.OBJ}

FUNCTION FLOADMOD(filename:POINTER):INTEGER;EXTERNAL;
FUNCTION OLOADMOD(position:LONGINT):INTEGER;EXTERNAL;
FUNCTION MLOADMOD(position:POINTER):INTEGER;EXTERNAL;
PROCEDURE UNLOADMOD;EXTERNAL;
PROCEDURE FREEMEM;EXTERNAL;
PROCEDURE CLOSE;EXTERNAL;
PROCEDURE SEEK;EXTERNAL;
PROCEDURE READ;EXTERNAL;
FUNCTION SETMOD(frequence,device,port:WORD;irq,dma:BYTE):INTEGER;
BEGIN
  SETMOD:=CRYSINT.SETMOD(frequence,device,port,irq,dma);
END;
PROCEDURE MAKEMOD;
BEGIN
  CRYSINT.MAKEMOD;
END;
PROCEDURE STARTMOD;
BEGIN
  CRYSINT.STARTMOD;
END;
PROCEDURE STOPMOD;
BEGIN
  CRYSINT.STOPMOD;
END;
FUNCTION DETECTSND(VAR device,port:WORD;VAR irq,dma:BYTE):INTEGER;
BEGIN
  DETECTSND:=CRYSINT.DETECTSND(device,port,irq,dma);
END;
PROCEDURE CHANGEVOL(newvol:BYTE);
BEGIN
  CRYSINT.CHANGEVOL(newvol);
END;
PROCEDURE SETMODPOS(newpos:WORD);
BEGIN
  CRYSINT.SETMODPOS(newpos);
END;
FUNCTION GETMODPOS:WORD;
BEGIN
  GETMODPOS:=CRYSINT.GETMODPOS;
END;
FUNCTION USEGUS:INTEGER;
BEGIN
  USEGUS:=CRYSINT.USEGUS;
END;
FUNCTION USESPK:INTEGER;
BEGIN
  USESPK:=CRYSINT.USESPK;
END;
FUNCTION USEDAC:INTEGER;
BEGIN
  USEDAC:=CRYSINT.USEDAC;
END;
FUNCTION USEADL:INTEGER;
BEGIN
  USEADL:=CRYSINT.USEADL;
END;
FUNCTION USESB:INTEGER;
BEGIN
  USESB:=CRYSINT.USESB;
END;
FUNCTION USESP:INTEGER;
BEGIN
  USESP:=CRYSINT.USESP;
END;
END.
