
COMMENT !

        Assembly part of VBL-unit for WatcomC++, using register calling.

        By Hkan Wallin (the edge/CDA)

!

                .386p
                LOCALS
                JUMPS

                MODEL   FLAT

;

                VBLSYNCHMARGIN = 200


;

                PUBLIC  vsynch_
                PUBLIC  waitVBL_
                PUBLIC  set_timerperiod_
                PUBLIC  update_VBLperiod_
                PUBLIC  set1col_
                PUBLIC  getpal_
                PUBLIC  setpal_
                PUBLIC  set_VBLpal_
                PUBLIC  fade_VBLpal_
                PUBLIC  memcopy_
                PUBLIC  memfill_
                PUBLIC  reset_timer_
                PUBLIC  set_musicfrq_
                PUBLIC  timer_interrupt_
                PUBLIC  keyb_interrupt_
                PUBLIC  music_dummy_
                PUBLIC  get_irqmask_

;

DATASEG
                GLOBAL C MusicHandler:DWORD
                GLOBAL C VBLTick:DWORD
                GLOBAL C MusicTick:DWORD
                GLOBAL C VBLInitFlag:DWORD
                GLOBAL C VBLPalFlag:DWORD
                GLOBAL C VBLPal:BYTE
                GLOBAL C oldTimerHandler:PWORD
                GLOBAL C FadeCount:DWORD
                GLOBAL C FadeValues:DWORD
                GLOBAL C FadeAddValues:DWORD
                GLOBAL C VBLCount:DWORD
                GLOBAL C MusicCount:DWORD
                GLOBAL C VBLPeriod:DWORD
                GLOBAL C MusicPeriod:DWORD
                GLOBAL C SystemCount:DWORD
                GLOBAL C NextTimerInt:DWORD

;

;

CODESEG
;

                EXTRN   call_interrupt_:NEAR            ; (from irq unit)

;

music_dummy_    PROC    NEAR

                ret
                ENDP

;

keyb_interrupt_ PROC    FAR

                push    eax

                in      al,60h
                mov     ah,al
                in      al,61h
                or      al,80h
                out     61h,al
                and     al,7fh
                out     61h,al

                mov     al,20h
                out     20h,al

                pop     eax
                iretd
                ENDP

;

                tintMusic = 0
                tintVBL   = 1

;-----------------------------------------------------------------------------

timer_interrupt_ PROC    FAR
                cli
                pushad
                push    ds
                push    es

                mov     ax,DGROUP
                mov     ds,ax
                mov     es,ax


                cmp     NextTimerInt,tintVBL
                je      @@vbl_int
;-----------------------------------------------------------------------------

@@music_int:    mov     eax,MusicPeriod
                add     MusicCount,eax

                call    @@enable_next

                mov     eax,MusicHandler
                call    eax

                inc     MusicTick

                jmp     @@end

;-----------------------------------------------------------------------------

@@vbl_int:      mov     dx,3dah
@@synch:        in      al,dx
                test    al,8
                jz      @@synch

                mov     eax,VBLPeriod
                mov     VBLCount,eax
                sub     MusicCount,VBLSYNCHMARGIN

                call    @@enable_next

                cmp     VBLPalFlag,0
                jz      @@no_pal

                lea     eax,VBLPal
                call    setpal_
                mov     VBLPalFlag,0
@@no_pal:
                call    fade_1step_

                call    @@fake_BIOS

                inc     VBLTick




;-----------------------------------------------------------------------------
@@end:          pop     es
                pop     ds
                popad
                iretd
;-----------------------------------------------------------------------------
@@fake_BIOS:    push    eax
                push    ebx

                mov     eax,SystemCount
                sub     eax,VBLPeriod
                jge     @@no_system

                mov     ebx,46ch
                add     WORD PTR [ebx],1
                adc     WORD PTR 2[ebx],0
                adc     BYTE PTR 4[ebx],0

                ;push    eax
                ;lea     eax,oldTimerHandler
                ;call    call_interrupt_
                ;pop     eax

                add     eax,10000h
@@no_system:    mov     SystemCount,eax
                pop     ebx
                pop     eax
                retn                    ; Note! NEAR return required!
;-----------------------------------------------------------------------------

@@enable_next:  mov     eax,VBLCount
                or      eax,eax
                jg      @@vblc_notimm

                mov     eax,8
@@next_setvbl:  mov     NextTimerInt,tintVBL
                call    set_timerperiod_
                jmp     @@next_end

@@vblc_notimm:  cmp     eax,MusicCount
                jle     @@next_setvbl

                mov     eax,MusicCount
                or      eax,eax
                jg      @@mscc_notimm

                mov     eax,8
@@mscc_notimm:  mov     NextTimerInt,tintMusic
                call    set_timerperiod_

@@next_end:     sub     VBLCount,eax
                sub     MusicCount,eax

                mov     al,20h
                out     20h,al
                sti

                retn                    ; Note! NEAR return required!
                ENDP

;

set_musicfrq_   PROC    NEAR
                ;       In:
                ;        eax = Hz for music calling

                push    ebx
                push    edx

                mov     ebx,eax
                xor     edx,edx
                mov     eax,1193180
                div     ebx
                mov     MusicPeriod,eax

                pop     edx
                pop     ebx
                ret
                ENDP

;

vsynch_         PROC    NEAR
                push    eax
                push    edx

                mov     dx,03dah
@@vsynch1:      in      ax,dx
                test    ax,8
                jz      @@vsynch1
@@vsynch2:      in      ax,dx
                test    ax,8
                jnz     @@vsynch2

                pop     edx
                pop     eax
                ret
                ENDP

;

waitVBL_        PROC    NEAR

                cmp     VBLInitFlag,0
                jz      vsynch_

                push    eax
                pushfd
                pop     eax
                test    eax,0200h
                pop     eax
                jz      vsynch_

                push    eax
                mov     eax,VBLTick
@@wait_inttick: cmp     eax,VBLTick
                je      @@wait_inttick
                pop     eax

                ret
                ENDP

;

update_VBLperiod_ PROC NEAR

                pushfd
                push    eax

                cmp     VBLInitFlag,0
                jz      @@no_update

                cli

                call    @@wait_synch
                xor     eax,eax
                call    set_timerperiod_

                call    @@wait_synch
                call    get_timercount_

                neg     ax
                sub     eax,VBLSYNCHMARGIN
                mov     VBLPeriod,eax

@@no_update:    pop     eax
                popfd
                ret
;-----------------------------------------------------------------------------
@@wait_synch:   mov     dx,3dah
@@synchloop1:   in      al,dx
                test    al,8
                jnz     @@synchloop1
@@synchloop2:   in      al,dx
                test    al,8
                jz      @@synchloop2
                ret
                ENDP

;

get_timercount_ PROC    NEAR
                ;       Out:
                ;        eax = timer count

                xor     eax,eax
                mov     al,0
		out	43h,al
		in	al,40h
		mov	ah,al
		in	al,40h
                xchg    al,ah

                ret
                ENDP

;

set_timerperiod_ PROC    NEAR
                ;       In:
                ;        eax = timer period

                push    eax
                push    ebx
                mov     ebx,eax

                mov     al,30h
		out	43h,al
		mov	al,bl
		nop
		out	40h,al
		mov	al,bh
		nop
                out     40h,al

                pop     ebx
                pop     eax
                ret
                ENDP

;

reset_timer_    PROC    NEAR

                push    eax
                mov     ebx,eax

                mov     al,36h
		out	43h,al
                xor     al,al
		nop
		out	40h,al
		nop
                nop
                out     40h,al

                pop     eax
                ret
                ENDP

;

getpal_         PROC    NEAR
                ;       In:
                ;        eax = ptr to 768 bytes palette

                push    ebx
                push    ecx
                push    edx

                mov     ebx,eax
                mov     edx,3c7h

                xor     eax,eax
                out     dx,al
                add     edx,2

                mov     ecx,768
@@pal_loop:     in      al,dx
                mov     [ebx],al
                inc     ebx
                loop    @@pal_loop

                pop     edx
                pop     ecx
                pop     ebx
                ret
                ENDP


;

setpal_         PROC    NEAR
                ;       In:
                ;        eax = ptr to 768 bytes palette

                push    ebx
                push    ecx
                push    edx

                mov     ebx,eax
                mov     edx,3c8h

                xor     eax,eax
                out     dx,al
                inc     dx

                mov     ecx,768
@@pal_loop:     mov     al,[ebx]
                out     dx,al
                inc     ebx
                loop    @@pal_loop

                pop     edx
                pop     ecx
                pop     ebx
                ret
                ENDP

;

set1col_        PROC    NEAR
                ;       In:
                ;        al = palette number
                ;        bl = green
                ;        cl = blue
                ;        dl = red

                push    edx
                mov     dx,3c8h
                out     dx,al
                inc     dx
                pop     eax
                out     dx,al
                mov     al,bl
                nop
                out     dx,al
                mov     al,cl
                nop
                out     dx,al

                ret
                ENDP

;

set_VBLpal_     PROC    NEAR
                ;       In:
                ;        eax = ptr to 768 bytes palette


                push    ebx
                push    edx

                mov     ebx,768
                mov     edx,eax
                lea     eax,VBLPal
                call    memcopy_

                mov     VBLPalFlag,1

                pop     edx
                pop     ebx
                ret
                ENDP

;


fade_VBLpal_    PROC    NEAR
                ;       In:
                ;        eax = ptr source pal
                ;        edx = ptr dest pal
                ;        ebx = #VBLS to fade

                pushad

                or      ebx,ebx
                jle     @@no_fade

                mov     FadeCount,ebx
                mov     ebp,ebx
                mov     esi,eax
                mov     ebx,edx
                xor     ecx,ecx

@@loop:         xor     eax,eax
                xor     edx,edx
                mov     al,[ebx+ecx]
                mov     dl,[esi+ecx]
                sal     eax,16
                sal     edx,16
                mov     FadeValues[ecx*4],edx
                sub     eax,edx
                cdq
                idiv    ebp
                mov     FadeAddValues[ecx*4],eax

                inc     ecx
                cmp     ecx,768
                jl      @@loop
@@no_fade:
                popad
                ret
                ENDP


;

fade_1step_     PROC    NEAR

                push    eax
                push    ecx

                cmp     FadeCount,0
		jle	@@no_fade

                xor     ecx,ecx
@@loop:         mov     eax,FadeValues[ecx*4]
                add     eax,FadeAddValues[ecx*4]
                mov     FadeValues[ecx*4],eax
                shr     eax,16
                mov     VBLPal[ecx],al

                inc     ecx
                cmp     ecx,768
                jl      @@loop

                dec     FadeCount
                mov     VBLPalFlag,1
@@no_fade:
                pop     ecx
                pop     eax
                ret
                ENDP

;

memcopy_        PROC    NEAR
                ;       In:
                ;        eax = ptr dest
                ;        edx = ptr source
                ;        ebx = # bytes to move
                ;
                ;       Alignment based on dest!


                push    ecx
                push    esi
                push    edi

                mov     esi,edx
                mov     edi,eax

                or      ebx,ebx
                jle     @@end

@@byte_loop:    test    edi,3
                jz      @@aligned
                movsb
                dec     ebx
                jg      @@byte_loop
                jmp     @@end

@@aligned:      mov     ecx,ebx
                shr     ecx,2
                rep     movsd

                mov     ecx,ebx
                and     ecx,3
                rep     movsb


@@end:          pop     edi
                pop     esi
                pop     ecx
                ret
                ENDP

;

memfill_        PROC    NEAR
                ;       In:
                ;        eax = ptr dest
                ;         dl = data
                ;        ebx = # bytes to fill

                push    ecx
                push    edi

                mov     edi,eax
                mov     dh,dl
                mov     eax,edx
                rol     eax,16
                mov     ax,dx

@@byte_loop:    test    edi,3
                jz      @@aligned
                stosb
                dec     ebx
                jg      @@byte_loop
                jmp     @@end

@@aligned:      mov     ecx,ebx
                shr     ecx,2
                rep     stosd

                mov     ecx,ebx
                and     ecx,3
                rep     stosb

@@end:          pop     edi
                pop     ecx
                ret
                ENDP

;

get_irqmask_    PROC    NEAR

                xor     eax,eax
                in      al,0a1h
                mov     ah,al
                nop
                in      al,21h

                ret
                ENDP


;

                END




