//
//  LousyPlayer for WATCOM using virtual timer calling.
//

#include <stdlib.h>
#include <stdio.h>

#include "vbl.h"
#include "music.h"

//

extern "C" int  GUSBasePort;
extern "C" int  GUSDramDMA;
extern "C" int  GUSAdcDMA;
extern "C" int  GUSGf1IRQ;
extern "C" int  GUSMidiIRQ;

extern "C" int  init_card();
extern "C" void play_musictick();

//

static int   MusicInitFlag = 0;
static char* envstr;

//

int
try_GUS()
{
        envstr = getenv("ULTRASND");

        if (envstr != NULL)
        {
            if (sscanf(envstr,"%x,%d,%d,%d,%d",&GUSBasePort,
                                               &GUSDramDMA,
                                               &GUSAdcDMA,
                                               &GUSGf1IRQ,
                                               &GUSMidiIRQ) != 5) return 0;

            SoundCard = GUS;
            return 1;
        }

        return 0;
}

//

int
try_GUSIW()
{
        envstr = getenv("INTERWAVE");

        if (envstr != NULL)
        {
            if (try_GUS())
            {
                SoundCard = GUSIW;
                return 1;
            }
        }

        return 0;
}


//

cardid
init_music(int forcegf1)
{

        if (!MusicInitFlag)
        {

            SoundCard = NoSound;

            if (forcegf1)
                try_GUS();
            else
                if (!try_GUSIW())
                    try_GUS();

            init_card();

            MusicHandler = play_musictick;
            set_musicfrq(625);

            MusicInitFlag = 1;
            atexit(&close_music);
        }

        return (cardid) SoundCard;
}

//

cardid
init_music()
{
        return init_music(0);
}

//

void
close_music()
{
        if (MusicInitFlag)
        {
        }

}

//





