;   FILENAME: ALTSCRN.ASM
;

jumps      ; Have TASM automatically resolve out of range jumps

%tabsize 4

ifndef  MDL
    display "Error: This module requires that you provide a memory model"
    display "    definition on the command line. I.E. /dMDL=SMALL."
    err ; Force a fatal error
else

model	MDL,pascal	       ; Define the memory model

ideal

P286

include "globals.inc"
include "keytask.inc"
include "pps.inc"

dataseg

ARP		db	"   ArpPrPrTonVibT&SV&STrm??8So=VlsJmpVolBrk**ESpd"
Notes   dw      0000h
        db              '---'
        dw      0358h
        db              'C-1'
        dw      0328h
        db              'C#1'
        dw      02FAh
        db              'D-1'
        dw      02D0h
        db              'D#1'
        dw      02A6h
        db              'E-1'
        dw      0280h
        db              'F-1'
        dw      025Ch
        db              'F#1'
        dw      023Ah
        db              'G-1'
        dw      021Ah
        db              'G#1'
        dw      01FCh
        db              'A-1'
        dw      01E0h
        db              'A#1'
        dw      01C5h
        db              'B-1'
        dw      01ACh
        db              'C-2'
        dw      0194h
        db              'C#2'
        dw      017Dh
        db              'D-2'
        dw      0168h
        db              'D#2'
        dw      0153h
        db              'E-2'
        dw      0140h
        db              'F-2'
        dw      012Eh
        db              'F#2'
        dw      011Dh
        db              'G-2'
        dw      010Dh
        db              'G#2'
        dw      00FEh
        db              'A-2'
        dw      00F0h
        db              'A#2'
        dw      00E2h
        db              'B-2'
        dw      00D6h
        db              'C-3'
        dw      00CAh
        db              'C#3'
        dw      00BEh
        db              'D-3'
        dw      00B4h
        db              'D#3'
        dw      00AAh
        db              'E-3'
        dw      00A0h
        db              'F-3'
        dw      0097h
        db              'F#3'
        dw      008Fh
        db              'G-3'
        dw      0087h
        db              'G#3'
        dw      007Fh
        db              'A-3'
        dw      0078h
        db              'A#3'
        dw      0071h
        db              'B-3'
        dw      0FFFFh
        db              '???'
        dw      0FFFFh
        db              '???'

CurLineSeg	dw	0
BlankPatLine    db      "                                                              ",0
PatternLine	db	"                                                              ",0
PatternLowLine	db	"`000``B``--- 00``   00``B``--- 00``   00``B``--- 00``   00``B``--- 00``   00`",0
PatternHighLine db	"`000``B``--- 00``   00``B``--- 00``   00``B``--- 00``   00``B``--- 00``   00`",0
BelowLine	db	"͹",0
InfoLine	db	"`   `/`   ``   `/`   `` --- --- --- `---` --- --- --- `` 1 2 3 4 `` Speed:               `   `",0
BottomInfoLine  db      "Ľ",0

CurBlock        db      0
TempPos 	dw	0
CurCount	dw	0
OldPos		dw	0FFFFh

Ed_DashStr		db	"---",0
Ed_SpeedStr		db	"000/000",0
Ed_PatternStr		db	"000/000",0
Ed_Zeroes		db	"000",0
Ed_DontDoPattern        db      0

codeseg

proc	Ed_DoPat
	uses	di,ax,es,ds,si,cx,dx
	push	cx
	cmp	[Byte Ed_DontDoPattern],0
	je	@@0
	mov	si,offset Ed_DashStr
	jmp	@@0A
@@0:	xchg	al,ah
	add	di,ax
	mov	al,[di] 	     ; Sequence Channel number in AL
	push	es
	push	ds
	pop	es
	xor	ah,ah
	mov	di,offset Ed_Zeroes
	mov	cx,3
	call	MakeDec
	pop	es
	mov	si,offset Ed_Zeroes
@@0A:	pop	cx
	mov	ax,4
	mul	cx
	xor	dx,dx
	mov	di,(11*80+18)*2-1
	add	di,ax
	add	di,ax
	mov	cx,3
	call	DirectWrite1
	ret
endp	Ed_DoPat

proc    Ed_Sequence
	uses	ds,es,di,si,ax,cx,bx
	mov	ax,@data
	mov	ds,ax
	mov	es,ax
	mov	di,offset Ed_PatternStr+4
	xor	ah,ah
	mov	al,[NumBlocks]
	mov	cx,3
	call	MakeDec
	mov	di,offset Ed_PatternStr
	xor	ah,ah
	mov	al,[CurBlock]
	mov	cx,3
	call	MakeDec
	mov	di,(11*80+1)*2-1
	mov	si,offset Ed_PatternStr
	mov	cx,7
	call	DirectWrite1

	mov	di,offset Ed_PatternStr
	xor	ah,ah
	mov	al,[mt_SongPos]
	mov	cx,3
	call	MakeDec
	mov	bx,[SequenceOffset]
	mov	al,[BX-02h+offset Header]
	dec	al
	mov	di,offset Ed_PatternStr+4
	xor	ah,ah
	mov	cx,3
	call	Makedec
	mov	di,(11*80+9)*2-1
	mov	si,offset Ed_PatternStr
	mov	cx,7
	call	DirectWrite1
;	 ret
	push	ds
	pop	es
	mov	bx,[SequenceOffset]
	add	bx,offset Header
	mov	si,bx
	mov	di,bx
	sub	di,3
	mov	cx,0
@@2:	xor	ax,ax
	mov	ah,[mt_SongPos]
@@1:	add	ah,cl
	cmp	ah,3
	jge	@@2_1
@@2_0:	mov	[Byte Ed_DontDoPattern],01h
	jmp	@@3
@@2_1:	mov	bl,[SI-02h]		     ; Compare against SongLen
	add	bl,3
	cmp	ah,bl
	jge	@@2_0
@@3:	push	si
	call	Ed_DoPat
	pop	si
	mov	[Byte Ed_DontDoPattern],00h
	inc	cx
	cmp	cx,7
	jne	@@2

	ret
endp	Ed_Sequence

proc    DirectWrite
	push	es
	mov	es,[Screen]
@@1:	lodsb
	stosw
	loop	@@1
	pop	es
	ret
endp	DirectWrite

proc	DirectWrite1
	push	es
	mov	es,[Screen]
@@1:	lodsb
	inc	di
	stosb
	loop	@@1
	pop	es
	ret
endp	DirectWrite1

proc    WriteAltScrn1
	uses	ds,si,es,di
	mov	ax,@data
        mov     ds,ax
	mov	es,[Screen]
	xor	di,di
	mov	cx,2000
	xor	ax,ax
	rep	stosw

	call	WriteStandardInfo

	call	Write,0,10,seg BelowLine,offset BelowLine
	call	Write,0,11,seg InfoLine,offset InfoLine
	call	Write,0,12,seg BottomInfoLine,offset BottomInfoLine

	mov	cx,1

@@2:    push    cx
	cmp	cx,5
	jz	@@HighLine
	call	Write,0,cx,seg PatternLowLine,offset PatternLowLine
	jmp	@@PopIt
@@HighLine:
	call	Write,0,cx,seg PatternHighLine,offset PatternHighLine
@@PopIt:
	pop	cx
	inc	cx
	cmp	cx,10
	jnz	@@2

	call	Ed_Sequence

	mov	[Word OldPos],0FFFFh
        ret
endp	WriteAltScrn1

proc	MakeDec
	push	di
	dec	cx
	add	di,cx
	inc	cx
	xor	ah,ah
@@NumLoop:
	mov	bl,10
	div	bl
	add	ah,'0'
	mov	[es:di],ah
	dec	di
	xor	ah,ah
	loop	@@NumLoop

@@Done: pop	di
	ret
endp	MakeDec

proc    FindNote
	push	bx

	mov	ax,[es:si]		; Get note period
	xchg	ah,al			; Flip flop and
	and	ax,0FFFh		; get rid of unneeded bits

	mov	dx,ax
	mov	bx,offset Notes 	; Find note period in table
	mov	cx,37
@@1:	mov	ax,[bx]
	cmp	ax,dx
	je	@@2
	add	bx,5
	loop	@@1
@@2:	add	bx,2

	mov	ax,[bx] 		; Copy note string
	mov	[di],ax
	mov	al,[bx+02h]
	mov	[di+02h],al

        mov     al,[es:si+02h]          ; Get lo instrument number
	and	al,0f0h
	shr	al,4
	mov	ah,[es:si]		; Get hi instrument number
	and	ah,10h			; Put them together
	or	al,ah
	add	di,4

	push	es
	push	ds
	pop	es
	mov	cx,2
	call	MakeDec
	pop	es
	add	di,3

        mov     ax,[es:si+02h]
	xchg	ah,al
	and	ax,0fffh
	push	ax
	mov	bx,ax
	cmp	bh,0
	jne	@@2_1
	cmp	al,0
	jnz	@@2_1
	mov	ax,0
	jmp	@@2_2
@@2_1:	mov	ax,3
	inc	bh
	mul	bh
@@2_2:	add	ax,offset ARP
	mov	bx,ax
	mov	cx,3
@@3:	mov	ax,[bx]
	mov	[di],ax
	inc	bx
	inc	di
	loop	@@3
	pop	ax
	push	es
	push	ds
	pop	es
	mov	cx,2
	call	MakeDec
        pop     es
	add	di,2
	add	si,04h
	pop	bx
	ret
endp	FindNote

proc    MakeOne
	push	ds
	pop	es
	mov	di,offset PatternLine+1
	mov	ax,[TempPos]
	shr	ax,4
	mov	cx,3
	call	MakeDec

	mov	es,[CurLineSeg]
	mov	si,[TempPos]
	mov	di,offset PatternLine+7
	call	FindNote
	mov	di,offset PatternLine+23
	call	FindNote
	mov	di,offset PatternLine+39
	call	FindNote
	mov	di,offset PatternLine+55
	call	FindNote

	ret
endp    MakeOne

proc    GetEditSeg
	xor	ax,ax
	mov	al,[mt_SongPos]
	add	ax,[SequenceOffset]
	mov	di,ax
	xor	ax,ax
	mov	al,[di+offset Header]
	mov	[CurBlock],al
	shl	al,1
	mov	di,offset PatternLoc
	add	di,ax
	mov	ax,[di]
	mov	es,ax
	mov	ax,[mt_PatternPos]
	mov	di,ax
	mov	[CurLineSeg],es
	ret
endp    GetEditSeg

proc    DisplayNine
	push	ds es di si bp

	mov	ax,@data
	mov	ds,ax
	call	GetEditSeg
	mov	cx,9
	mov	di,159

	mov	bx,[mt_PatternPos]
	mov	es,[CurLineSeg]
@@1:    sub     bx,50h
	mov	[TempPos],bx
@@2:    mov     [CurCount],cx
        push    di

	mov	bx,[TempPos]
        add     bx,10h
	mov	[TempPos],bx
        js      @@Signed
	cmp	bx,3F0h
        jg      @@Signed
        call    MakeOne

@@4:    pop     di
	mov	si,offset PatternLine
        mov     cx,80
        call    DirectWrite1
        mov     cx,[CurCount]
        loop    @@2
        jmp     @@Done

@@Signed:
        pop     di
	mov	si,offset BlankPatLine
        mov     cx,80
        call    DirectWrite1
        mov     cx,[CurCount]
        loop    @@2

@@Done:
	pop	bp
	pop	si
	pop	di
	pop	es
        pop     ds
        ret
endp    DisplayNine

proc	ShowPatMode
	mov	ax,@data
	mov	ds,ax

@@AAA:	mov	ax,[mt_PatternPos]
	cmp	[OldPos],ax
	jne	@@1
	ret

@@1:	mov	[OldPos],ax
	call	DisplayNine
	call	Ed_Sequence

	ret
endp	ShowPatMode

dataseg

ShutDownIfKeyHit        db      1
Channel1Volume    db      0
Channel2Volume    db      0
Channel3Volume    db      0
Channel4Volume    db      0

codeseg

proc	FlipChannel
	mov	al,[di+MS.MasterVolume]
        or      al,al
        jnz     @@TurnItOff
	mov	al,[Byte MaxVolume]
        mov     [di+MS.MasterVolume],al
	call	DisplayChannel
        ret
@@TurnItOff:
        mov     [Byte di+MS.MasterVolume],0
	mov	[Byte si],0
	call	DisplayChannel
        ret
endp    FlipChannel

proc	DisplayChannel
        push    es
	mov	ax,[Screen]
        mov     es,ax
        mov     ax,160
	mov	bx,11
        mul     bx
	add	ax,97
	mov	di,ax
	mov	si,offset Channel1
	call	Channel_WriteIt
	add	di,4
	mov	si,offset Channel2
	call	Channel_WriteIt
        add     di,4
	mov	si,offset Channel3
	call	Channel_WriteIt
        add     di,4
	mov	si,offset Channel4
	call	Channel_WriteIt
        add     di,4

        pop     es
        ret
endp	DisplayChannel

proc	Channel_WriteIt
	cmp	[si+MS.MasterVolume],0
	je	CW1
	mov	al,0Fh
	jmp	CW2
CW1:	mov	al,01h
CW2:	mov	[es:di],al
	ret
endp    Channel_WriteIt

proc    CheckStandardKeys
	mov	bx,offset kb
;
@@Key_Home:                               ; Home
	cmp	[Byte bx+k_home],1
	jnz	@@Key_End
        mov     [Word mt_PatternPos],0
        call    DisplayNine
	jmp	@@End
;
@@Key_End:                               ; End
	cmp	[Byte bx+k_end],1
        jnz     @@Key_F7
        mov     [Word mt_PatternPos],3F0h
        call    DisplayNine
	jmp	@@End
;
@@Key_F7:
	cmp	[Byte bx+k_f7],1
        jnz     @@Key_F8
        cmp     [Byte mt_SongPos],0
	je	@@Key_F7_1
        dec     [Byte mt_SongPos]
@@Key_F7_1:
        mov     [Word mt_PatternPos],0
        call    GetEditSeg
        call    DisplayNine
	call	Ed_Sequence
	jmp	@@End
;
@@Key_F8:
	cmp	[Byte bx+k_f8],1
        jnz     @@KeyChannel1
        mov     bx,[SequenceOffset]
        mov     al,[BX-02h+offset Header]
        dec     al
        cmp     [Byte mt_SongPos],al
	je	@@Key_F8_1
        inc     [Byte mt_SongPos]
@@Key_F8_1:
        mov     [Word mt_PatternPos],0
        call    GetEditSeg
        call    DisplayNine
	call	Ed_Sequence
	jmp	@@End
;

@@KeyChannel1:
	cmp	[Byte bx+k_f1],1
        jnz     @@KeyChannel2
        mov     di,offset Channel1
	mov	si,offset Channel1Vol1
        call    FlipChannel
	jmp	@@End

;

@@KeyChannel2:
	cmp	[Byte bx+k_f2],1
        jnz     @@KeyChannel3
        mov     di,offset Channel2
	mov	si,offset Channel2Vol1
        call    FlipChannel
	jmp	@@End

;

@@KeyChannel3:
	cmp	[Byte bx+k_f3],1
        jnz     @@KeyChannel4
        mov     di,offset Channel3
	mov	si,offset Channel3Vol1
        call    FlipChannel
	jmp	@@End

;

@@KeyChannel4:
	cmp	[Byte bx+k_f4],1
        jnz     @@KeyF9
        mov     di,offset Channel4
	mov	si,offset Channel4Vol1
        call    FlipChannel
	jmp	@@End

;

@@KeyF9:
	cmp	[Byte bx+k_f9],1
        jnz     @@KeyF10
	sub	[Byte MaxVolume],4
	jnb	@@DecChannel1
	mov	[Byte MaxVolume],4

@@DecChannel1:
	mov	ah,[Byte MaxVolume]
	cmp	[Byte Channel1Vol1],0
	jz	@@DecChannel2
	mov	al,[Channel1Vol1]
	dec	al
	jnb	@@Channel1Above
	mov	al,0
@@Channel1Above:
	mov	[Channel1Volume],ah
	mov	[Channel1Vol1],al
@@DecChannel2:
	cmp	[Byte Channel2Vol1],0
	jz	@@DecChannel3
	mov	al,[Channel2Vol1]
	dec	al
	jnb	@@Channel2Above
	mov	al,0
@@Channel2Above:
	mov	[Channel2Volume],ah
	mov	[Channel2Vol1],al
@@DecChannel3:
	cmp	[Byte Channel3Volume],0
	jz	@@DecChannel4
	mov	al,[Channel3Vol1]
	dec	al
	jnb	@@Channel3Above
	mov	al,0
@@Channel3Above:
	mov	[Channel3Volume],ah
	mov	[Channel3Vol1],al
@@DecChannel4:
	cmp	[Byte Channel4Volume],0
	jz	@@End
	mov	al,[Channel4Vol1]
	dec	al
	jnb	@@Channel4Above
	mov	al,0
@@Channel4Above:
	mov	[Channel4Volume],ah
	mov	[Channel4Vol1],al
	jmp	@@End

;

@@KeyF10:
	cmp	[Byte bx+k_f10],1
        jnz     @@KeyIllegal
	add	[Byte MaxVolume],4
	jnb	@@IncChannel1
	mov	[Byte MaxVolume],255

@@IncChannel1:
	mov	ah,[Byte MaxVolume]
	cmp	[Byte Channel1Volume],0
	jz	@@IncChannel2
	mov	al,[Channel1Vol1]
	inc	al
	cmp	al,64
	jb	@@Channel1Below
	mov	al,64
@@Channel1Below:
	mov	[Channel1Volume],ah
	mov	[Channel1Vol1],al

@@IncChannel2:
	cmp	[Byte Channel2Volume],0
	jz	@@IncChannel3
	mov	al,[Channel2Vol1]
	inc	al
	cmp	al,64
	jb	@@Channel2Below
	mov	al,64
@@Channel2Below:
	mov	[Channel2Volume],ah
	mov	[Channel2Vol1],al

@@IncChannel3:
	cmp	[Byte Channel3Volume],0
	jz	@@IncChannel4
	mov	al,[Channel3Vol1]
	inc	al
	cmp	al,64
	jb	@@Channel3Below
	mov	al,64
@@Channel3Below:
	mov	[Channel3Volume],ah
	mov	[Channel3Vol1],al

@@IncChannel4:
	cmp	[Byte Channel4Volume],0
	jz	@@End
	mov	al,[Channel4Vol1]
	inc	al
	cmp	al,64
	jb	@@Channel4Below
	mov	al,64
@@Channel4Below:
	mov	[Channel4Volume],ah
	mov	[Channel4Vol1],al
	jmp	@@End

;

@@KeyIllegal:
	clc
	ret
@@End:	stc
	ret
endp    CheckStandardKeys

proc    AltScrn1
@@TopLoop:
	call	WriteAltScrn1
@@KeyLoop:
	cmp	[Byte MStatus],0
	jnz	@@JustKeys
	call	ShowPatMode
@@JustKeys:
	call	CheckStandardKeys
	cmp	[Byte bx+k_esc],1
	jnz	@@CheckF8
	mov	ax,13h
        int     10h
	jmp	@@KeyLoop
@@CheckF8:
	cmp	[Byte bx+k_tab],1
        jnz     @@KeyLoop
	mov	ax,3
	int	10h
	ret
endp    AltScrn1

endif   ; ifndef MDL

end

