
;   FILENAME: .ASM
;
;   DESCRIPTION:

%tabsize 4

ifndef  MDL
    display "Error: This module requires that you provide a memory model"
    display "       definition on the command line. I.E. /dMDL=SMALL."
    err ; Force a fatal error
else

    ideal                           ; Use TASM's Ideal mode
    model   MDL,Pascal		    ; Define the memory model
	P286

include "stdlib.inc"

codeseg

;
; PutI2- Recursive routine to actually print the value in AX as an integer.
;
proc    Puti2
        mov     bx, 10
        xor     dx, dx
        div     bx
        or      ax, ax          ;See if ax=0
        jz      Done
        push    dx
        call    Puti2
        pop     dx
Done:   mov     al, dl
        or      al, '0'
        call    PutIt
        ret
endp    PutI2

;
; PutIt- Writes the character in AL to the buffer.  Also zero
; terminates the string and increments aindex.  Note: no need to preserve
; DI here because no one else uses it.
;
proc    PutIt
        mov     [di],al
        inc     di
	cmp	cx,0
	je	@@1
	mov	[Byte di],0
@@1:	ret
endp    PutIt

; ES:DI -- Pointer to string
; AX    -- Value to convert
; CX	-- Whether to null terminate it or not.
;
; UTOA- Converts the unsigned integer value in AX to a string of digits
;       and returns a pointer to this string in ES:DI.
;
proc	sl_utoa Value:word,Null:word,String:dword
	push	ax bx cx dx di ds
	lds	si,[String]
	mov	ax,[Value]
	mov	cx,[Null]
	call	PutI2
	clc
	pop	ds di dx cx bx ax
	ret
endp	sl_utoa

endif   ; ifndef MDL

end

