'******************************************************************************
'File:      err.bas
'Version:   2.22
'Tab stops: every 2 columns
'Project:   any STK related code
'Copyright: 1994-1995 DiamondWare, Ltd.  All rights reserved.
'Written:   Keith Weiner & Erik Lorenzen
'Purpose:   Contains a routine to handle any error generated by the STK
'History:   94/10/21 KW Started
'           95/02/21 EL Finalized for 1.00
'           95/03/18 EL Added new error to err_Display(), dws_BUSY
'           95/03/22 EL Finalized for 1.01
'           95/04/06 EL Added new error to err_Display(), dws_MUSTBECLI
'           95/04/11 EL moved DisplayError to err.c (err_Display).
'           95/04/11 EL Finalized for 1.02
'           95/06/06 EL Finalized for 1.03, no changes
'           95/06/06 EL Finalized for 2.00, no changes
'           95/10/07 EL Finalized for 2.10, no changes
'           95/10/24 EL Finalized for 2.20, updated comments to those in err.c
'           95/12/07 EL Finalized for 2.21, no changes
'           96/10/10 EL Finalized for 2.22, no changes
'Notes
'-----
'*Permission is expressely granted to use err_Display or any derivitive made
' from it to registered users of the STK.
'******************************************************************************



'$INCLUDE: 'dws.bi'



SUB errDisplay

	errornum = dwsErrNo

	SELECT CASE errornum

		CASE dwsEZERO
			'This should not have happened, considering how we got here!
			PRINT"DWS: I'm confused!  There is no error number!"

		CASE dwsNOTINITTED
			'If we get here, it means you haven't called dwsInit().
			'The STK needs to initialize itself and the hardware before
			'it can do anything.
			PRINT"DWS: The STK was not initialized"

		CASE dwsALREADYINITTED
			'If we get here, it means you've called dwsInit() already.	Calling
			'dwsDetectHardWare() at this point would cause zillions of
			'problems if we let the call through.
			PRINT"DWS: The STK was already initialized"

		CASE dwsNOTSUPPORTED:
			'If we get here, it means that either the user's machine does not
			'support the function you just called, or the STK was told not to
			'support it in dwsInit.
			PRINT"DWS: Function not supported"

		CASE dwsDetectHardwareUNSTABLESYSTEM
			' Please report it to DiamondWare if you get here!
			'
			' Ideally, you would disable control-C here, so that the user can't
			' hit control-alt-delete, causing SmartDrive to flush its (possibly
			' currupt) buffers.
			PRINT"DWS: The system (or DOS box) is unstable!"
			PRINT"     If not in a multitasking system, please power down!"

			AGAIN:
			GOTO AGAIN

		'The following three errors are USER/PROGRAMMER errors.  You forgot
		'to fill the cardtyp struct full of -1's (except in those fields
		'you intended to override, or the user (upon the unlikly event that
		'the STK was unable to find a card) gave you a bad overide value.

		CASE dwsDetectHardwareBADBASEPORT
			'You set dov.baseport to a bad value, or
			'didn't fill it with a -1.
			PRINT"DWS: Bad port address"

		CASE dwsDetectHardwareBADDMA
			'You set dov.digdma to a bad value, or
			'didn't fill it with a -1.
			PRINT"DWS: Bad DMA channel"

		CASE dwsDetectHardwareBADIRQ
			'You set dov.digirq to a bad value, or
			'didn't fill it with a -1.
			PRINT"DWS: Bad IRQ level"

		CASE dwsKillCANTUNHOOKISR
			'The STK points the interrupt vector for the sound card's IRQ
			'to its own code in dws_Init.
			'
			'dws_Kill was unable to restore the vector to its original
			'value because other code has hooked it after the STK
			'initialized(!)  This is really bad.  Make the user get rid
			'of it and call dws_Kill again.

			PRINT"DWS: Get rid of your TSR, pal!"
			INPUT"(Hit ENTER when ready)";g$

		CASE dwsXBADINPUT
			'The mixer funtion's can only accept volumes between 0 & 255,
			'the volume will remain unchanged.

			PRINT"DWS: Bad mixer level"

		CASE dwsDNOTADWD
			'You passed the STK a pointer to something which is not a .DWD file!
			PRINT"DWS: Pointer does not point to a .DWD"

		CASE dwsDNOTSUPPORTEDVER
			'The STK can't play a .DWD converted using a version of VOC2DWD.EXE
			'newer than itself.  And, although we'll try to maintain backwards
			'compatibility, we may not be able to guarantee that newer versions
			'of the code will be able to play older .DWD files.  In any event,
			'it's a good idea to always convert .VOC files with the utility
			'which comes with the library you're linking into your application.
			PRINT"DWS: Please reconvert this file using the VOC2DWD.EXE"
			PRINT"     program which came with this library"

		CASE dwsDINTERNALERROR
			'This error should never occur and probably will not affect sound
			'play(?). If it happens please contact DiamondWare.
			PRINT"DWS: An internal error has occured"
			PRINT"     Please contact DiamondWare"

		CASE dwsDPlayNOSPACEFORSOUND
			'This error is more like a warning, though it may happen on a
			'regular basis, depending on how many sounds you told the STK
			'to allow in dws_Init, how you chose to prioritize sounds and
			'how many sounds are currently being played.
			PRINT"DWS: No more room for new digitized sounds right now"

		CASE dwsDSetRateFREQTOLOW
			'The STK will set rate as close as possible to the indicated rate
			'but cannot set a rate that low.
			PRINT"DWS: Playback frequency too low"

		CASE dwsDSetRateFREQTOHIGH
			'The STK will set rate as close as possible to the indicated rate
			'but cannot set a rate that high.
			PRINT"DWS: Playback frequency too high"

		CASE dwsMPlayNOTADWM
			'You passed the STK a pointer to something which is not a .DWM file!
			PRINT"DWS: Pointer does not point to a .DWM"

		CASE dwsMPlayNOTSUPPORTEDVER
			'The STK can't play a .DWM converted using a version of VOC2DWM.EXE
			'newer than itself.  And, although we'll try to maintain backwards
			'compatibility, we may not be able to guarantee that newer versions
			'of the code will be able to play older .DWM files.  In any event,
			'it's a good idea to always convert .MID files with the utility
			'which comes with the library you're linking into your application.
			PRINT"DWS: Please reconvert this file using the MID2DWM.EXE"
			PRINT"     which came with this library"

		CASE dwsMPlayINTERNALERROR:
			'This error should never occur and probably will not affect sound
			'play(?). If it happens please contact DiamondWare.
			PRINT"DWS: An internal error has occured."
			PRINT"     Please contact DiamondWare."

		CASE dwsBUSY:
			'Can only occur when DWS is being called from the background
			'(within an ISR--possibly timer or keyboard handler.)  If you get
			'this error, do your IRET, and call again from your next interrupt.
			'Repeat until successful.
			PRINT"DWS: Busy now, please call again later."

		CASE dwsIRQDISABLED:
			'The following error may be triggered by dws_Init, dws_Kill,
			'or dws_DetectHardWare.  It occurs if interrupts are disabled.
			'Enable interrupts (execute the STI instruction) and call again.
			PRINT"DWS: Interrupts are disabled."

		CASE ELSE
			'If this function was clipped intact from err.c, this case
			'should never occur and probably will not affect sound play(?)
			'If it happens please contact DiamondWare.
			PRINT"DWS: I'm confused!  Where am I?  HOW DID I GET HERE????"
			PRINT"     The ERROR number is:";errornum

	END SELECT

END SUB
