{==========================================================================
  DEMO3.PAS - GV-SOUND(tm) Demo #3 - 4 sample playback on specific channel
  Copyright (c) 1994,95 Jarrod Davis Software Co.

  This demo will play up to 4 channels at the same time on specific
  channels. Each time keys 1-4 is pressed the sample starts playing over
  at the beginning.
===========================================================================}
program Demo3;
uses
  Crt, GvSound;
var
  Finished: Boolean;
  Sample  : array[1..4] of TSample;

procedure LoadSamples;
begin
  Sample[1].Init('aha.wav');
  Sample[2].Init('thunder.raw');
  Sample[3].Init('eagle.raw');
  Sample[4].Init('boom.wav');
end;

procedure FreeSamples;
var
  i: Byte;
begin
  for i := 1 to 4 do
    Sample[i].Done;
end;

procedure PlaySamples;
var
  K: Char;
begin
  K := ReadKey;
  case UpCase(K) of
    '1': Sample[1].PlayOnChannel(1, False);
    '2': Sample[2].PlayOnChannel(2, False);
    '3': Sample[3].PlayOnChannel(3, False);
    '4': Sample[4].PlayOnChannel(4, False);
    'Q': Finished := True;
  end;
end;

begin

  WriteLn('GV-SOUND(tm) Demo #3 - 4 Sample playback on specific channel');
  WriteLn('Copyright (c) 1994,95 Jarrod Davis Software Co.');
  WriteLn;
  WriteLn('  1 - Audio Hardware Activated');
  WriteLn('  2 - Thunder');
  WriteLn('  3 - Eagle');
  WriteLn('  4 - Boom');
  WriteLn('  Q - Quit');
  WriteLn;
  Write('Press 1-4, or ''Q'' to Quit...');

  gvSetDigitalVolume(8);
  LoadSamples;
  Finished := False;
  repeat
    if KeyPressed then
      PlaySamples;
  until Finished;
  FreeSamples;
end.
