{$G+}
Unit GraphV;

Interface
Type ProcType = Procedure;

Const
     COPYPUT   = 0;
     XORPUT    = 1;
     ANDPUT    = 2;
     TRANS_PUT = 3;
     SolidFill = 0;
Var
   VLastX,
   VLastY        :Word;
   VForeColor    :Byte;
   VBackColor    :Byte;
{$I VESA.VAR}

procedure vgetmodeinfo(mode:word);
procedure vplot(x,y:Word;C:Word) ;
procedure vsetmode(mode:word)    ;
procedure vhrzline(row,x1,x2:Word;Color:Byte);
procedure vfillblock(x1,y1,x2,y2:Word;Color:Byte);
procedure vscrollup(lines:word);
procedure vscrolldown(lines:word);
procedure vprint(text:string;x,y:Word;Color:Byte);
procedure vprintfont(text:string;x,y:word;color,puttype:byte);
procedure vline(x1,y1,x2,y2:Word;Color:Byte);
procedure vputrect(buffer:pointer;x,y,xlen,ylen,width:word;PutType:word);
procedure vgetrect(buffer:pointer;x,y,xlen,ylen,width:word);
procedure vsetputmode(mode:Byte);
procedure venablemouse(lefthandler:proctype;righthandler:proctype);
procedure vdisablemouse;
procedure vsetscanlen(len:word);
procedure vscrollleft(lines:word);
procedure vscrollright(line:word);
procedure vfloodfill(x,y:word;color:byte);
function  mousex:Word;
function  mousey:Word;
procedure bussy;
procedure notbussy;
procedure vputmouse;
procedure vrestoremouse;
procedure vsetmousecoor(newx,newy:Word);
function  bussystate:Byte;

procedure MoveTo(x,y:Word);
procedure SetColor(Color:Byte);
procedure SetFillStyle(Style:Word;Color:Word);
procedure LineTo(x,y:Word);
procedure Line(x1,y1,x2,y2:Word);
procedure InitGraph(Driver,Mode:Word;Path:String);
procedure LineRel(x,y:Word);
procedure Rectangle(x1,y1,x2,y2:Word);
procedure PutImage(x,y:Word;P:Pointer;PType:Byte);
procedure GetImage(x1,y1,x2,y2:Word;P:Pointer);
Function  ImageSize(x1,y1,x2,y2:Word):LongInt;
procedure PutPixel(x,y:Word;Pixel:Word);
procedure Bar(x1,y1,x2,y2:Word);
procedure OutText(Text:String);
procedure OutTextXY(x,y:Word;Text:String);
procedure CloseGraph;
function GetColor:Byte;
procedure SetGraphMode(Mode:Word);
function GetMAXX:Word;
function GetMAXY:Word;
procedure SetWriteMode(Mode:Word);
function InstallUserDriver(name:string;Auto:Pointer):Word;
procedure EnableVGA;
procedure DisableVGA;
Procedure SETPAL(Palette:Pointer);
Implementation

{$I VESA.INC}

Procedure SETPAL(Palette:Pointer);
Var
   PS,
   PO   : Word;
Begin
     ps := Seg(Palette^);
     po := Ofs(Palette^);
     Asm
        push ds
        mov  si,po
        mov  ax,ps
        mov  ds,ax
        mov  cx,255
        mov  dx,cx
        add  cx,cx
        add  cx,dx
        mov  al,0
        mov  dx,03c8h
        out dx,al
        inc dx
        cld
        rep outsb
        pop ds
     End;
End;

Procedure EnableVGA;Assembler;
Asm
   mov  dx,03c4h
   mov  al,1
   out  dx,al
   inc  dx
   in   al,dx
   and  al,0dfh
   out  dx,al
End;

Procedure DisableVGA;Assembler;
Asm
   mov  dx,03c4h
   mov  al,1
   out  dx,al
   inc  dx
   in   al,dx
   or   al,20h
   out  dx,al
End;

function InstallUserDriver;
Begin
     InstallUserDriver := 1;
End;

procedure SetWriteMode;
Begin
     vsetputmode(lo(mode));
End;

function GetMAXX;
Begin
     GetMAXX := vscrwidth;
End;

function GetMAXY;
Begin
     GetMAXY := vscrheight;
End;

procedure SetGraphMode;
Begin
     vsetmode(mode);
     VLastX := 0;
     VLastY := 0;
     VForeColor := 1;
     VBackColor := 0;
End;
Function GetColor:Byte;
Begin
     GetColor := VForeColor;
End;

Procedure CloseGraph;Assembler;
Asm
   mov ax,0003h
   int 10h
End;
Function ImageSize(x1,y1,x2,y2:Word):LongInt;
Var
   I : LongInt;
Begin
     I := (x2-x1)+1;
     I := I*((y2-y1)+1);
     ImageSize := I + 6; { +2 for safety }
End;

procedure MoveTo(x,y:Word);
Begin
     VLastX := x;
     VLastY := y;
End;
procedure SetColor(Color:Byte);
Begin
     VForeColor := Color;
End;

Procedure SetFillStyle(Style:Word;Color:Word);
Begin
     VBackColor := Color;
End;
Procedure LineTo;
Begin
     vline(VLastX,VLastY,x,y,VForeColor);
     VLastX := X;
     VLastY := Y;
End;

Procedure LineRel;
Begin
     vline(VLastX,VLastY,VLastX+x,VLastY+y,VForeColor);
     VLastX := VLastX+x;
     VLastY := VLastY+y;
End;

Procedure Line;
Begin
     vline(x1,y1,x2,y2,VForeColor);
     VLastX := x2;
     VLastY := y2;
End;
Procedure rectangle;
Begin
     vhrzline(y1,x1,x2,VForeColor);
     vhrzline(y2,x1,x2,VForeColor);
     vline(x1,y1,x1,y2,VForeColor);
     vline(x2,y1,x2,y2,VForeColor);
End;

Procedure PutImage;
Var
   b : ^Word;
   xlen,
   ylen : Word;
Begin
   b := P;
   xlen := b^;
   inc(b);
   inc(b);
   ylen := b^;
   inc(b);
   inc(b);
   vputrect(b,x,y,xlen,ylen,xlen,PType);
End;

Procedure GetImage;
Var
   b : ^word;
Begin
     b := P;
     b^ := x2-x1+1;
     inc(b);
     inc(b);
     b^ := y2-y1+1;
     inc(b);
     inc(b);
     vgetrect(b,x1,y1,x2-x1+1,y2-y1+1,x2-x1+1);
End;

Procedure PutPixel;
Begin
     vplot(x,y,lo(pixel));
     VLastX := x;
     VLastY := y;
End;

Procedure Bar;
Begin
     vfillblock(x1,y1,x2,y2,VBackColor);
     VLastX := x2;
     VLastY := y2;
End;

Procedure OutTextXY;
Begin
     vprint(Text,x,y,VForeColor);
     VLastX := X;
     VLastY := Y;
End;

Procedure OutText;
Begin
     vprint(Text,VLastX,VLastY,VForeColor);
End;

Procedure InitGraph;
Begin
     vsetmode(mode);
     VLastX := 0;
     VLastY := 0;
     VForeColor := 1;
     VBackColor := 0;
End;

Begin
     VLastX := 0;
     VLastY := 0;
     VForeColor := 1;
     VBackColor := 0;
End.

