Procedure FillBmp(x1,y1,x2,y2:Word;Bmpno:Byte);
Var
   x,y  : Word;
   xlen,ylen : Word;
Begin
     if BmpArray[BmpNo].Found then
     Begin
          if x2 < x1 then
          Begin
               x  := x1;
               x1 := x2;
               x2 := x;
          End;
          if y2 < y1 then
          Begin
               y  := y1;
               y1 := y2;
               y2 := y;
          End;
          for y := 0 to ((y2-y1) div BmpArray[BmpNo].h) do
          Begin
               For x:= 0 to ((x2-x1) div BmpArray[BmpNo].w) do
               Begin
                    xlen := (x2-x1) - x*BmpArray[BmpNo].w;
                    if xlen > BmpArray[BmpNo].w then xlen := BmpArray[BmpNo].w;
                    ylen := (y2-y1) - y*BmpArray[BmpNo].h;
                    if ylen > BmpArray[BmpNo].h then ylen := BmpArray[BmpNo].h;
                    vputrect(BmpArray[BmpNo].Buffer,x1+x*BmpArray[BmpNo].w,
                             y1+y*BmpArray[BmpNo].h,xlen,ylen,BmpArray[BmpNo].w,0);
               End;
          End;
     End;
End;

Procedure RegisterWindow(x1,y1,x2,y2:Word;WinProc:ProcType);
Begin
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Xmin      := x1;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Xmax      := x2;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Ymin      := y1;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Ymax      := y2;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Proc      := WinProc;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Text      := '';
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Fit       := 0;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].TextColor := 0;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].BoxColor  := 0;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Pressed   := True;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].No        := 0;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].typ       := WINDOW;
     Inc(TreePtr[TreeLevel]);
     if TreePtr[TreeLevel] > MaxButton then
     Begin
          CloseGraph;
          WriteLn('Two many TreePtr values. ',TreePtr[TreeLevel]);
          Halt;
     End;
End;

{$F+}
Procedure VertWait;Assembler;
Asm
   mov dx,03dah
@@vwl1:
   in  al,dx
   test al,8
   jz @@vwl1
@@vwl2:
   in  al,dx
   test al,8
   jnz @@vwl2
End;

Procedure  BoxPrint(X,Y:Integer;Text:String;Fit,TextColor,BoxColor:Word;Pressed:Boolean);
Var
   Tab      : Word;
   OldColor : Word;
   XEND,
   YEND     : Word;
   db       : Byte;
   wd       : Byte;
Begin
     If Fit = 0 then Fit := Length(Text);
     Tab := (CharH div 2)+Trunc(CharH*((Fit-Length(Text)) / 2))+1;
     OldColor := GetColor;
     wd := 1;
     If Not Pressed then
     Begin
          XEND := X+Fit*CharW+CharW-1;
          YEND := Y+CharH*2-1;
          SetColor(BoxColor+24);
          For db := 0 to wd do
          Begin
              Line(x,y+db,xend-db,Y+db);
              line(x+db,y,x+db,yend-db);
          End;
          SetColor(BoxColor+4);
          For db := 0 to wd do
          Begin
              line(x+1+db,yend-db,xend,yend-db);
              line(xend-db,yend,xend-db,y+1+db);
          End;
          inc(wd);
          SetFillStyle(SolidFill,BoxColor+16);
          Bar(X+wd,Y+wd,XEND-wd,YEND-wd);
          PutPixel(X+wd,Y+wd,BoxColor+24);
          PutPixel(XEND-wd,YEND-wd,BoxColor+4);
          SetColor(TextColor);
          OutTextXY(X+Tab,Y+CharH div 2,Text);
          SetColor(OldColor);
     End
     else
     Begin
          XEND := X+Fit*CharW+CharW-1;
          YEND := Y+CharH*2-1;
          SetColor(BoxColor+4);
          For db := 0 to wd do
          Begin
              Line(x,y+db,xend-db,Y+db);
              line(x+db,y,x+db,yend-db);
          end;
          SetColor(BoxColor+16);
          For db := 0 to wd do
          Begin
              line(x+1+db,yend-db,xend,yend-db);
              line(xend-db,yend,xend-db,y+1+db);
          End;
          SetFillStyle(SolidFill,BoxColor+8);
          inc(wd);
          Bar(X+wd,Y+wd,XEND-wd,YEND-wd);
          SetColor(TextColor);
          OutTextXY(X+Tab,Y+CharH div 2,Text);
          SetColor(OldColor);
     End;
End;
{$F-}

Procedure ButtonPrint(X,Y:Word;Text:String;Fit,TextColor,BoxColor:Word;Pressed:Boolean;Proc:ProcType;No:Integer);
Begin
     if Fit = 0 then Fit := Length(Text);
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Xmin      := X;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Xmax      := X+(Fit+1)*CharW;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Ymin      := Y;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Ymax      := Y+CharH*2;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Proc      := Proc;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Text      := Text;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Fit       := Fit;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].TextColor := TextColor;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].BoxColor  := BoxColor;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].Pressed   := Pressed;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].No        := No;
     ButtonTree^[TreePtr[TreeLevel],TreeLevel].typ       := BUTTON;
     Inc(TreePtr[TreeLevel]);
     if TreePtr[TreeLevel] > MaxButton then
     Begin
          CloseGraph;
          WriteLn('Two many TreePtr values. ',TreePtr[TreeLevel]);
          Halt;
     End;
     BoxPrint(X,Y,Text,Fit,TextColor,BoxColor,Pressed);
End;

Procedure EMSInfo;
Var
   Len : LongInt;
   SS   : String;
Begin
     Asm
        mov ah,42h
        int 67h
        mov FreeEMS,bx
     End;
     SetFillStyle(SolidFill,Black);
     Bar(0,MAXY-CharH,CharW*15,MAXY);
     Bar(MAXX-CharW*18,MAXY-CharH,MAXX,MAXY);
     SetColor(Black+31);
     OutTextXY(0,MAXY-CharH,'Free EMS:'+S(FreeEMS*16,5,TRUE)+'K');
     Len := BlockEnd - BlockStart;
     Str(Len / Rate:7:2,SS);
     OutTextXY(MAXX-CharW*18,MAXY-CharH,'Play time:'+SS+'s');
End;



Procedure ScrOffset(Offs:Word);Assembler;
Asm
     mov bx,Offs
     mov dx,03d4h
     mov al,0ch
     mov ah,bh
     out dx,ax
     inc al
     mov ah,bl
     out dx,ax
End;

Procedure MsgBox(X1,Y1,X2,Y2,Color,AreaColor:Word);
Var
   db   :Byte;
   wd   :Byte;
Begin
     wd := 1;
     SetColor(Color+20);
     For db:= 0 to wd do
     Begin
          Line(x1,y1+db,x2-db,y1+db);
          Line(x1+db,y1,x1+db,y2-db);
     End;
     SetColor(Color+8);
     For db:= 0 to wd do
     Begin
          Line(x1+1+db,y2-db,x2,y2-db);
          Line(x2-db,y2,x2-db,y1+1+db);
     End;
     inc(wd);
     SetFillStyle(SolidFill,AreaColor);
     Bar(X1+wd,y1+wd,x2-wd,y2-wd);
End;

Procedure SaveScreen(X1,Y1,X2,Y2:Word);
Begin
     GetMem(ScrPtr[ScrNo],ImageSize(X1,Y1,X2,Y2));
     GetImage(X1,Y1,X2,Y2,ScrPtr[ScrNo]);
     LocScr[ScrNo].x := X1;
     LocScr[ScrNo].y := Y1;
     LocScr[ScrNo].Size := ImageSize(X1,Y1,X2,Y2);
     Inc(ScrNo);
     if ScrNo > MaxScr then
     Begin
          CloseGraph;
          WriteLn('Too many screens saved.Buffer exceeded.');
          Halt;
     End;
End;

Procedure RestoreScreen;
Begin
     Dec(ScrNo);
     PutImage(LocScr[ScrNo].X,LocScr[ScrNo].Y,ScrPtr[ScrNo],COPYPUT);
     FreeMem(ScrPtr[ScrNo],LocScr[ScrNo].Size);
End;

Procedure StatusBox(StatText:String;Stat:Byte);
var
   xx,
   x1,
   y1,
   x2,
   y2   : Word;
   l    : Byte;
Begin
     l := Length(StatText) div 2 + 3;
     if l * CharW < 50 then l := 70 div CharW;
     x1 := HALFMAXX - (l*CharW);
     x2 := HALFMAXX + (l*CharW);
     y1 := HALFMAXY - CharH*5;
     y2 := HALFMAXY + CharH*3;
     if Stat = 0 then
     Begin
          SaveScreen(x1,y1,x2,y2);
          MsgBox(x1,y1,x2,y2,Gray,Gray+16);
          SetColor(Black+31);
          OutTextXY((MAXX - Length(StatText)*CharW) div 2,y1+CharH*2,StatText);
          MsgBox((MAXX - 104) div 2,HALFMAXY-10,(MAXX+104) div 2,HALFMAXY + 11,Black,Black+4);
          StatusBoxActive := True;
     End;
     if StatusBoxActive then
     Begin
          if Stat > 2 then
          Msgbox((MAXX - 100) div 2,HALFMAXY-8,(MAXX - 100) div 2+Stat,HALFMAXY+9,Green,Green+12);
     End;
     if Stat = 100 then
     Begin
          RestoreScreen;
          StatusBoxActive := False;
     End;
End;

{$F+}
Procedure Ok;
Begin
     Okay := True;
     ButtonPos := False;
End;

Procedure Cancel;
Begin
     Canceled := True;
     ButtonPos := False;
End;

Procedure Block;
Begin
     BlockSelected := True;
     ButtonPos := False;
End;

Procedure Whole;
Begin
     WholeSelected := True;
     ButtonPos := False;
End;

Procedure Nothing;
Begin
End;
{$F-}

Procedure OKBox(OKText:String);
Var
   OldOkay : Boolean;
   OldProc : Byte;
   OldMX,
   OldMY,
   x1,x2,y1,y2:Word;
   OldBussy : Byte;
Begin
     OldBussy := BussyState;
     Bussy;
     y1 := HALFMAXY - 3*CharH;
     y2 := HALFMAXY + 4*CharH;
     x1 := HALFMAXX - ((Length(OKText) div 2)+2)*CharW;
     x2 := HALFMAXX + ((Length(OKText) div 2)+2)*CharW;
     SaveScreen(x1,y1,x2,y2);
     MsgBox(x1,y1,x2,y2,Blue,Blue+31);
     SetColor(Black+31);
     OutTEXTXY(x1+CharW*2,y1+CharH*2,OKText);
     OldProc := ProcNo;
     Inc(TreeLevel);
     ButtonPrint(HALFMAXX-CharW*3,Y2-CharH*3,'OK',4,Black,Gray,False,Ok,NoNo);
     OldMX := MouseX;
     OldMY := MouseY;
     vsetmousecoor(HALFMAXX-CharW,Y2-CharH*2);
     OldOkay := Okay;
     Okay := False;
     NotBussy;
     Repeat
           if ProcNo = OldProc+1 then
                Kernel;
     Until Okay;
     Okay := OldOkay;
     Bussy;
     Dec(TreePtr[TreeLevel]);
     Dec(TreeLevel);
     RestoreScreen;
     vsetmousecoor(OldMX,OldMY);
     if OldBussy = 0 then NotBussy;
End;

Function ASKBox(AskText:String):Boolean;
Var
   OldTreePtr   : Byte;
   OldOkay,
   OldCanceled : Boolean;
   OldMx,
   OldMy   : Word;
   OldProc : Byte;
   x1,x2,y1,y2:Word;
   OldBussy : Byte;
Begin
     OldBussy := BussyState;
     Bussy;
     y1 := HALFMAXY - 3*CharH;
     y2 := HALFMAXY + 4*CharH;
     x1 := HALFMAXX - ((Length(ASKText) div 2)+2)*CharW;
     x2 := HALFMAXX + ((Length(ASKText) div 2)+2)*CharW;
     SaveScreen(x1,y1,x2,y2);
     MsgBox(x1,y1,x2,y2,Blue,Blue+31);
     SetColor(Black+31);
     OutTEXTXY(x1+CharW*2,y1+CharH*2,ASKText);
     OldProc := ProcNo;
     Inc(TreeLevel);
     OldTreePtr := TreePtr[TreeLevel];
     ButtonPrint(HALFMAXX-CharW*8,Y2-CharH*3,'OK'    ,7,Black+31,Green,False,Ok    ,NoNo);
     ButtonPrint(HALFMAXX+CharW  ,Y2-CharH*3,'CANCEL',7,Black+31,Red  ,False,Cancel,NoNo);
     OldMX := MouseX;
     OldMY := MouseY;
     vsetmousecoor(HALFMAXX+CharW*3,Y2-CharH*2);
     OldOkay := Okay;
     OldCanceled := Canceled;
     Okay     := False;
     Canceled := False;
     NotBussy;
     Repeat
           if ProcNo = OldProc+1 then
                Kernel;
     Until (Okay) or (Canceled);
     ASKBox := Okay;
     Bussy;
     TreePtr[TreeLevel] := OldTreePtr;
     Dec(TreeLevel);
     RestoreScreen;
     vsetmousecoor(OldMX,OldMY);
     Okay := OldOkay;
     Canceled := OldCanceled;
     if OldBussy = 0 then NotBussy;
End;

Function BlockBox(AskText:String):Byte;
Var
   OldTreePtr  : Byte;
   OldCanceled : Boolean;
   OldMx,
   OldMy   : Word;
   OldProc : Byte;
   x1,x2,y1,y2:Word;
   OldBussy : Byte;
Begin
     OldBussy := BussyState;
     Bussy;
     y1 := HALFMAXY - 3*CharH;
     y2 := HALFMAXY + 4*CharH;
     x1 := HALFMAXX - ((Length(ASKText) div 2)+2)*CharW;
     x2 := HALFMAXX + ((Length(ASKText) div 2)+2)*CharW;
     SaveScreen(x1,y1,x2,y2);
     MsgBox(x1,y1,x2,y2,Blue,Blue+31);
     SetColor(Black+31);
     OutTEXTXY(x1+CharW*2,y1+CharH*2,ASKText);
     OldProc := ProcNo;
     Inc(TreeLevel);
     OldTreePtr := TreePtr[TreeLevel];
     ButtonPrint(HALFMAXX-CharW* 3,Y2-CharH*3,'BLOCK'    ,6,Black,Green ,False,Block ,NoNo);
     ButtonPrint(HALFMAXX-CharW*11,Y2-CharH*3,'WHOLE'    ,6,Black,Yellow,False,Whole ,NoNo);
     ButtonPrint(HALFMAXX+CharW* 5,Y2-CharH*3,'CANCEL'    ,6,Black,Red   ,False,Cancel,NoNo);
     OldMX := MouseX;
     OldMY := MouseY;
     vsetmousecoor(HALFMAXX+CharW*10,y2-CharH*2);
     OldCanceled := Canceled;
     Canceled      := False;
     BlockSelected := False;
     WholeSelected := False;
     NotBussy;
     Repeat
           if ProcNo = OldProc+1 then
                Kernel;
     Until (BlockSelected) or (Canceled) or (WholeSelected);
     if BlockSelected then BlockBox := _BLOCK;
     if WholeSelected then BlockBox := _WHOLE;
     if Canceled      then BlockBox := _CANCEL;
     Bussy;
     TreePtr[TreeLevel] := OldTreePtr;
     Dec(TreeLevel);
     RestoreScreen;
     if OldBussy = 0 then NotBussy;
     vsetmousecoor(OldMX,OldMY);
     Canceled := OldCanceled;

End;


Procedure ColorPal;External;
{$L palette.obj}



Procedure VGAInitialize(Mode:Integer);
Var
   P : Pointer;
Begin
     SetGraphMode(Mode);
     MAXX := GetMaxX;
     MAXY := GetMaxY;
     HALFMAXX := MAXX shr 1;
     HALFMAXY := MAXY shr 1;
     MAXCX := memw[$0040:$004A];
     P := Addr(ColorPal);
     SETPal(P);
End;

