Program U2R;

Uses Rexx;
Var
   InFile,
   OutFile      :File;
   InputFile,
   OutPutFile   :String;
   Buffer       :Pointer;
   ReadTo,
   Left,
   Size         :LongInt;
   Old_Y        :Byte;
   BufSize      :LongInt;
   Page         :Byte;
   Sign         :String[5];
   Rest         :Char;
   EType,
   Channels,
   Rate,
   DataSize,
   HdrSize      :LongInt;
   w            :Word;
Procedure Ulawtable;External;
{$L ulawtbl.obj }

Procedure ConvertUlaw8(USeg,UOfs,ULen : Word);Assembler;
Asm
   push es
   mov es,useg
   mov di,uofs
   mov cx,ulen
   push ds
   push cs
   pop  ds
@@convert:
   mov  bh,0
   mov  bl,es:[di]
   add  bx,bx
   mov  ax,cs:[offset ulawtable+bx]
   shr  ax,8
   add  al,080h
   mov  es:[di],al
   inc  di
   loop @@convert
   pop  ds
   pop  es
End;

Begin
     WriteLn('U2R  ULaw to Raw converter V1.00');
     WriteLn('Copyright (c) Huseyin Nakturk 1994');
     if (ParamCount < 1) or (ParamCount > 2) then
     Begin
          WriteLn('Usage: U2R input_file[.au] [output_file[.raw]]');
          Halt;
     End;
     InputFile := ParamStr(1);
     if Pos('.',InputFile) = 0 then InputFile := InputFile+'.au';
     if ParamCount = 2 then
        OutPutFile := ParamStr(2)
     else
        OutPutFile := ParamStr(1);
     if OutPutFile = Inputfile then
     begin
          Writeln('Output and Input files are same.');
          Halt;
     end;
     if Pos('.',OutPutFile) = 0 then OutPutFile := OutPutFile+'.raw';
     WriteLn(InPutFile,' -> ',OutPutFile);
     {$I-}
     Assign(InFile,InputFile);
     Reset(InFile,1);
     {$I+}
     if IOResult <> 0 then
     Begin
          WriteLn('Error opening ',InputFile);
          Halt(IOResult);
     End;
     Assign(OutFile,OutPutFile);
     ReWrite(OutFile,1);

     Sign[0] := chr(4);
     BlockRead(InFile,Sign[1],4);

     BlockRead(InFile,W,SizeOf(w));
     w := lo(w)*$100+hi(w);
     HdrSize := W;
     Hdrsize := Hdrsize * $10000;
     BlockRead(InFile,W,SizeOf(w));
     w := lo(w)*$100+hi(w);
     HdrSize := HdrSize + w;

     BlockRead(InFile,w,SizeOf(w));
     w := lo(w)*$100+hi(w);
     DataSize := w;
     DataSize := DataSize * $10000;
     BlockRead(InFile,W,SizeOf(w));
     w := lo(w)*$100+hi(w);
     DataSize := DataSize+w;

     BlockRead(InFile,W,SizeOf(w));
     w := lo(w)*$100+hi(w);
     EType := w;
     EType := Etype * $10000;
     BlockRead(InFile,W,SizeOf(w));
     w := lo(w)*$100+hi(w);
     EType := Etype+w;

     BlockRead(InFile,W,SizeOf(w));
     w := lo(w)*$100+hi(w);
     Rate := w ;
     Rate := Rate * $10000;
     BlockRead(InFile,W,SizeOf(w));
     w := lo(w)*$100+hi(w);
     Rate := Rate+w;

     BlockRead(InFile,W,SizeOf(w));
     w := lo(w)*$100+hi(w);
     Channels := w;
     Channels := Channels * $10000;
     BlockRead(InFile,W,SizeOf(w));
     w := lo(w)*$100+hi(w);
     Channels := Channels+w;

     WriteLn('Sign    : ',Sign);
     WriteLn('Hdrsize : ',HdrSize,' bytes.');
     WriteLn('DataSize: ',DataSize,' bytes.');
     WriteLn('Encoding: ',Etype);
     WriteLn('Rate    : ',Rate,'Hz');
     WriteLn('Channels: ',Channels);
     if FilePos(InFile) < HdrSize then
        WriteLn('Rest    :');
     While FilePos(InFile) < HdrSize do
     Begin
          BlockRead(InFile,Rest,1);
          Write(Rest);
     End;
     WriteLn;
     if EType = 2 then WriteLn('Not ULAW.Just removing header.');
     if EType > 3 then Begin
        WriteLn('Unsupported type.');
        Halt;
     End;
     Size := FileSize(InFile)-FilePos(InFile);
     Left := Size;
     page := mem[$0040:$0062];
     Asm
        mov ah,3
        mov bh,page
        int 10h
        mov old_y,dh
     End;
     BufSize := $FFFF;
     GetMem(Buffer,BufSize);
     While (Not EOF(Infile)) and (Left > 0) do
     Begin
          if Left > BufSize then ReadTo := BufSize
          else ReadTo := Left;
          Left := Left - ReadTo;
          {$I-}
          BlockRead(InFile,Buffer^,ReadTo);
          {$I+}
          Asm
             mov ah,2
             mov bh,page
             mov dh,old_y
             mov dl,0
             int 10h
          End;
          Write('Left: ',(Left div (Size div 100)):2,'%');
          if Etype = 1 then
             ConvertUlaw8(Seg(Buffer^),Ofs(Buffer^),ReadTo);
          BlockWrite(OutFile,Buffer^,ReadTo);
     End;
     FreeMem(Buffer,BufSize);
     Asm
        mov ah,2
        mov bh,page
        mov dh,old_y
        mov dl,0
        int 10h
     End;
     Write('Done.           ');
     Close(OutFile);
     Close(InFile);
End.
