; vhrzline
; draws a horizontal line with given color
; input    : row x1,x2 and color
; on return: -
; call type: procedure vhrzline(row,x1,x2:Word;Color:Byte)
public vhrzline
vhrzline        proc far
                prefix
                cld
                mov es,winaseg
                mov ax,[bp+8]      ; x2
                cmp ax,[bp+10]     ; x2 > x1
                ja  @@xok
                mov bx,[bp+8]
                mov ax,[bp+10]
                mov [bp+8],ax
                mov [bp+10],bx
@@xok:
                mov ax,[bp+12]     ; row
                mov bx,[bp+10]     ; starting column
                call vsetoffset    ; get ax = offset and dx = bank
                mov di,ax
                mov ax,[bp+6]      ; Color
                mov ah,al          ; for stosw
                mov cx,BankEnd
                sub cx,di
                mov bx,[bp+8]      ; x2
                sub bx,[bp+10]     ; x1
                cmp bx,cx          ; bx > cx ?
                ja @@bchange       ; yes we will change blocks
                mov cx,bx
@@bchange:
                sub bx,cx
@@draw:
                inc cx
                shr cx,1
                rep stosw
                adc cx,cx
                rep stosb
                cmp bx,0
                je  @@end
                inc  dx
                call vsetbank
                dec bx
                mov cx,bx
                xor bx,bx
                xor di,di
                jmp @@draw
@@end:
                postfix
                ret 8
vhrzline        endp

; vline
; draw a line
; input    : x1,y1,x2,y2 and color
; on return: -
; call type: procedure(x1,y1,x2,y2:Word;Color:Byte)
_DX      dw 0
_DY      dw 0
incr1    dw 0
incr2    dw 0
public vline
vline           proc far
                prefix
                mov es,winaseg
                mov ax,[bp+12]     ; y1
                mov bx,[bp+14]     ; x1
                call vsetoffset
                mov di,ax

                mov ax,[bp+14]     ; get x1
                sub ax,[bp+10]     ; sub x2
                jg @@ld1           ; skip if positive
                neg ax
@@ld1:
                mov _DX,ax         ; save DX
                mov ax,[bp+12]     ; get y1
                sub ax,[bp+8]      ; sub y2
                jg @@ld2           ; skip if positive
                neg ax
@@ld2:
                mov _DY,ax         ; save DY
                cmp ax,_DX         ; see if DY > DX
                jle @@xline        ; go do x oriented version
                jmp @@yline        ; go do y oriented version
; X oriented version of draw line.
@@xline:
                mov cx,_DX         ; cx has increment control
                sal ax,1           ; DY*2
                mov incr1,ax       ; save incr1
                sub ax,_DX         ; 2*dy - dx
                mov bx,ax          ; bx has D value

                mov ax,_DY         ; get DY
                sub ax,_DX         ; DY-DX
                sal ax,1           ; 2*(DY-DX)
                mov incr2,ax       ; save incr2

                mov _DX,0          ; assuming goint to left
                mov ax,[bp+14]     ; get x1
                sub ax,[bp+10]     ; x1-x2
                jg @@ld3
                mov _DX,1          ; goint to right
@@ld3:
                mov _DY,0          ; assume going up
                mov ax,[bp+12]     ; get y1
                sub ax,[bp+8]      ; y1 - y2
                jg @@ld5
                mov _DY,1          ; going down
@@ld5:
; Main X oriented drawing loop
;       ax = pixel value
;       bx = d
;       cx = loop control
;       dx = block number
;       di = block offset
;
                mov ax,[bp+6]      ; get color
                call vesdiput
                cmp cx,0           ; check if done
                je @@xloopend
@@xloop:
                cmp _DX,0          ; see if going left
                je @@ld7
                inc di
                jnz @@ld8
                inc dx
                push dx
                call vsetbank
                pop  dx
                jmp @@ld8
@@ld7:                          ; going left
                dec di
                jnz @@ld8
                dec dx
                push dx
                call vsetbank
                pop dx
@@ld8:
                cmp bx,0           ; test d<0
                jge @@ld9
                add bx,incr1       ; d = d + incr1
                jmp @@ld11
@@ld9:
                add bx,incr2       ; d = d + incr2
                cmp _DY,0          ; see if going up
                je @@ld10
                add di,bytesperscan
                jnc @@ld11
                inc dx
                push dx
                call vsetbank
                pop dx
                jmp @@ld11
@@ld10:
                sub di,bytesperscan; go to previous line
                jnc @@ld11
                dec dx
                push dx
                call vsetbank
                pop dx
@@ld11:
                call vesdiput
                loop @@xloop
@@xloopend:
                jmp @@done
; Y oriented version of draw line
@@yline:
                mov cx,_DY         ; cx has increment control
                mov ax,_DX
                sal ax,1           ; DX*2
                mov incr1,ax       ; save incr1
                sub ax,_DY         ; 2*dx - dy

                mov bx,ax          ; bx has D value
                mov ax,_DX         ; get DX
                sub ax,_DY         ; DX-DY
                sal ax,1           ; 2*(DX-DY)
                mov incr2,ax       ; save incr2

                mov _DX,0          ; assume goind to left
                mov ax,[bp+14]     ; get x1
                sub ax,[bp+10]     ; x1-x2
                jg @@ld12
                mov _DX,1          ; going to right
@@ld12:
                mov _DY,0          ; assume going up
                mov ax,[bp+12]     ; get y1
                sub ax,[bp+8]      ; y1-y2
                jg @@ld13
                mov _DY,1          ; going down
@@ld13:

; main Y oriented drawing loop
;       ax = pixel value
;       bx = d
;       cx = loop control
;       dx = block number
;       di = block offset

                mov ax,[bp+6]
                call vesdiput
                cmp cx,0           ; check if done
                je  @@yloopend
@@yloop:
                cmp _DY,0          ; see if going up ?
                je @@ld14
                add di,bytesperscan; going down
                jnc @@ld15
                inc dx
                push dx
                call vsetbank
                pop dx
                jmp @@ld15
@@ld14:
                sub di,bytesperscan; going up
                jnc @@ld15
                dec dx
                push dx
                call vsetbank
                pop dx
@@ld15:
                cmp bx,0           ; test d < 0
                jge @@ld16
                add bx,incr1
                jmp @@ld18
@@ld16:
                add bx,incr2
                cmp _DX,0          ; see if going left
                je @@ld17
                inc di
                jnz @@ld18
                inc dx
                push dx
                call vsetbank
                pop dx
                jmp @@ld18
@@ld17:
                dec di
                jnz @@ld18
                dec dx
                push dx
                call vsetbank
                pop dx
@@ld18:
                call vesdiput
                loop @@yloop
@@yloopend:
@@done:
                postfix
                ret 10
vline           endp
