; vgetmodeinfo
; returns information about specified mode.
; input    : mode
; on return: status_ah = 0 and status_al = 04fh if successful
; call type: procedure vgetmodeinfo(mode:word);
public vgetmodeinfo
vgetmodeinfo proc far
@@mode       equ <[bp+06]>
             prefix
             mov ax,04f01h
             mov cx,@@mode
             lea di,vesastruc
             push cs
             pop es
             int 10h
             mov status_al,al
             mov status_ah,ah
             call vvartransfer
             mov cx,windowsize
             shl cx,10
             jnz @@j
             dec cx
@@j:
             mov bankend,cx
             postfix
             ret 2
vgetmodeinfo endp

; vsetmode
; sets given vesa mode.
; input    : mode
; on return: status_ah = 0 and status_al = 04fh if succesfull
; call type: procedure vsetmode(mode:Word);
public vsetmode
vsetmode     proc far
@@mode       equ <[bp+06]>
             prefix
             mov ax,04f01h
             mov cx,@@mode
             lea di,vesastruc
             push cs
             pop es
             int 10h
             mov bx,@@mode
             mov ax,4f02h
             int 10h
             mov status_al,al
             mov status_ah,ah
             call vvartransfer
             mov cx,windowsize
             shl cx,10
             jnz @@j
             dec cx
@@j:
             mov Bankend,cx
             xor ax,ax
             mov scx,ax
             mov sdx,ax
             mov clipx1,ax
             mov clipy1,ax
             mov actstart,ax
             mov visstart,ax
             mov bptr pageno,0
             mov ax,scrheight
             mov pagelen,ax
             mov clipy2,ax
             mov ax,scrwidth
             mov clipx2,ax
             mov ah,11h
             mov al,30h
             mov bh,3           ; 8x8 base
             int 10h
             mov charseg1,es
             mov charofs1,bp
             mov ah,11h
             mov al,30h
             mov bh,4           ; 8x8 top
             int 10h
             mov charseg2,es
             mov charofs2,bp
             postfix
             ret 2
vsetmode     endp

; vsetoffset
; calculates offset and bank of given coordinates
; input    : ax : row, bx : column
; on return: ax : offset, dx : bank
; call type: for internal use
vsetoffset   proc near
             add ax,actstart
             mul  bytesperscan
             add  ax,bx
             jnc  @@l1
             inc  dx
@@l1:
             call vsetbank
             ret
vsetoffset   endp

; vsetbank
; sets given bank
; input    : dx : bank
; on return: -
; call type: for internal use
vsetbank     proc near
             push cx
             push dx
             mov cx,granularity
             shl dx,cl
             cmp dx,currentbank
             jz @@nochange
             mov currentbank,dx
             push ax
             push bx
             mov ax,4f05h
             mov bx,0000h
             int 10h
             pop bx
             pop ax
@@nochange:
             pop dx
             pop cx
             ret
vsetbank     endp

; vsetscanlen
; sets scan line length
; input    : line length
; on return: -
; call type: procedure vetscanlen(len:Word);
public vsetscanlen
vsetscanlen  proc far
@@len        equ <[bp+06]>
             prefix
             mov ax,04f06h
             mov bl,0
             mov cx,@@len
             mov scrwidth,cx
             mov bytesperscan,cx
             mov vscrwidth,cx
             int 10h
             postfix
             ret 2
vsetscanlen  endp

; vertwait
; waits for vertical trace
; for internal use
vertwait     proc near
             cmp scrolling,1
             jz @@done
             push dx
             push ax
             mov dx,03dah
@@vwl1:
             in al,dx
             test al,8
             jz @@vwl1
@@vwl2:
             in al,dx
             test al,8
             jnz @@vwl2
             pop ax
             pop dx
@@done:
             ret
vertwait     endp

; vvartransfer
; transfers vesa info to pascal variables
; ps: there must be a somehow clever!easy way to do this but i dont know
vvartransfer proc near
             mov ax,modeattr
             mov vmodeattr,ax
             mov al,winaattr
             mov vwinaattr,al
             mov al,winbattr
             mov vwinbattr,al
             mov ax,granularity
             mov vgranularity,ax
             mov ax,windowsize
             mov vwindowsize,ax
             mov ax,winaseg
             mov vwinaseg,ax
             mov ax,winbseg
             mov vwinbseg,ax
             mov ax,bytesperscan
             mov vbytesperscan,ax
             mov ax,scrwidth
             dec ax
             mov vscrwidth,ax
             mov ax,scrheight
             dec ax
             mov vscrheight,ax
             mov al,charheight
             mov vcharheight,al
             mov al,charwidth
             mov vcharwidth,al
             mov al,nummemplanes
             mov vnummemplanes,al
             mov al,bitsperpixel
             mov vbitsperpixel,al
             mov al,numofbanks
             mov vnumofbanks,al
             mov al,memmodel
             mov vmemmodel,al
             mov al,banksize
             mov vbanksize,al
             mov al,numimgpages
             mov vnumimgpages,al
             ret
vvartransfer endp

; vsplit
; splits screen from given line to two
; input    : scanline to split from
; on return: -
; call type: procedure vsplit(line:word)
public vsplit
vsplit          proc far
@@line          equ <[bp+06]>
                prefix
                push bx
                push dx
                mov bx,@@line
                mov al,018h
                mov ah,bl
                mov dx,03d4h
                out dx,ax               ; set bits 0-7
                mov al,09h
                out dx,al
                inc dx
                in al,dx
                mov ah,bh
                and ah,00000010b
                shl ah,5
                and al,10111111b
                or al,ah
                out dx,al               ; set bit 9
                dec dx
                mov al,07h
                out dx,al
                inc dx
                in al,dx
                and al,11101111b
                mov ah,bh
                and ah,00000001b
                shl ah,4
                or al,ah
                out dx,al               ; set bit 8
                pop dx
                pop bx
                postfix
                ret 2
vsplit          endp
